/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.role;

import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleContainerModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.RoleProviderFactory;
import org.keycloak.models.map.common.AbstractMapProviderFactory;
import org.keycloak.models.map.role.MapRoleEntity;
import org.keycloak.models.map.role.MapRoleProvider;
import org.keycloak.provider.InvalidationHandler;
import org.keycloak.provider.ProviderEvent;

public class MapRoleProviderFactory
extends AbstractMapProviderFactory<MapRoleProvider, MapRoleEntity, RoleModel>
implements RoleProviderFactory<MapRoleProvider>,
InvalidationHandler {
    public MapRoleProviderFactory() {
        super(RoleModel.class, MapRoleProvider.class);
    }

    @Override
    public MapRoleProvider createNew(KeycloakSession session) {
        return new MapRoleProvider(session, this.getStorage(session));
    }

    public String getHelpText() {
        return "Role provider";
    }

    public void invalidate(final KeycloakSession session, InvalidationHandler.InvalidableObjectType type, final Object ... params) {
        if (type == AbstractMapProviderFactory.MapProviderObjectType.REALM_BEFORE_REMOVE) {
            ((MapRoleProvider)this.create(session)).preRemove((RealmModel)params[0]);
        } else if (type == AbstractMapProviderFactory.MapProviderObjectType.CLIENT_BEFORE_REMOVE) {
            ((MapRoleProvider)this.create(session)).removeRoles((ClientModel)params[1]);
        } else if (type == AbstractMapProviderFactory.MapProviderObjectType.ROLE_BEFORE_REMOVE) {
            ((MapRoleProvider)this.create(session)).preRemove((RealmModel)params[0], (RoleModel)params[1]);
        } else if (type == AbstractMapProviderFactory.MapProviderObjectType.ROLE_AFTER_REMOVE) {
            session.getKeycloakSessionFactory().publish((ProviderEvent)new RoleContainerModel.RoleRemovedEvent(){

                public RoleModel getRole() {
                    return (RoleModel)params[1];
                }

                public KeycloakSession getKeycloakSession() {
                    return session;
                }
            });
        }
    }
}

