/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.logs;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.context.Context;
import io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import io.opentelemetry.sdk.internal.AttributesMap;
import io.opentelemetry.sdk.logs.LogEmitterSharedState;
import io.opentelemetry.sdk.logs.LogLimits;
import io.opentelemetry.sdk.logs.LogRecordBuilder;
import io.opentelemetry.sdk.logs.SdkReadWriteLogRecord;
import io.opentelemetry.sdk.logs.data.Body;
import io.opentelemetry.sdk.logs.data.Severity;
import java.time.Instant;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

final class SdkLogRecordBuilder
implements LogRecordBuilder {
    private final LogEmitterSharedState logEmitterSharedState;
    private final LogLimits logLimits;
    private final InstrumentationScopeInfo instrumentationScopeInfo;
    private long epochNanos;
    private SpanContext spanContext = SpanContext.getInvalid();
    private Severity severity = Severity.UNDEFINED_SEVERITY_NUMBER;
    @Nullable
    private String severityText;
    private Body body = Body.empty();
    @Nullable
    private AttributesMap attributes;

    SdkLogRecordBuilder(LogEmitterSharedState logEmitterSharedState, InstrumentationScopeInfo instrumentationScopeInfo) {
        this.logEmitterSharedState = logEmitterSharedState;
        this.logLimits = logEmitterSharedState.getLogLimits();
        this.instrumentationScopeInfo = instrumentationScopeInfo;
    }

    @Override
    public LogRecordBuilder setEpoch(long timestamp, TimeUnit unit) {
        this.epochNanos = unit.toNanos(timestamp);
        return this;
    }

    @Override
    public LogRecordBuilder setEpoch(Instant instant) {
        this.epochNanos = TimeUnit.SECONDS.toNanos(instant.getEpochSecond()) + (long)instant.getNano();
        return this;
    }

    @Override
    public LogRecordBuilder setContext(Context context) {
        this.spanContext = Span.fromContext((Context)context).getSpanContext();
        return this;
    }

    @Override
    public LogRecordBuilder setSeverity(Severity severity) {
        this.severity = severity;
        return this;
    }

    @Override
    public LogRecordBuilder setSeverityText(String severityText) {
        this.severityText = severityText;
        return this;
    }

    @Override
    public LogRecordBuilder setBody(String body) {
        this.body = Body.string(body);
        return this;
    }

    @Override
    public <T> LogRecordBuilder setAttribute(AttributeKey<T> key, T value) {
        if (key == null || key.getKey().isEmpty() || value == null) {
            return this;
        }
        if (this.attributes == null) {
            this.attributes = AttributesMap.create((long)this.logLimits.getMaxNumberOfAttributes(), (int)this.logLimits.getMaxAttributeValueLength());
        }
        this.attributes.put(key, value);
        return this;
    }

    @Override
    public void emit() {
        if (this.logEmitterSharedState.hasBeenShutdown()) {
            return;
        }
        this.logEmitterSharedState.getLogProcessor().onEmit(SdkReadWriteLogRecord.create(this.logEmitterSharedState.getLogLimits(), this.logEmitterSharedState.getResource(), this.instrumentationScopeInfo, this.epochNanos == 0L ? this.logEmitterSharedState.getClock().now() : this.epochNanos, this.spanContext, this.severity, this.severityText, this.body, this.attributes));
    }
}

