/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.admin.ui.rest;

import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.keycloak.admin.ui.rest.model.ClientRole;
import org.keycloak.admin.ui.rest.model.RoleMapper;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleContainerModel;
import org.keycloak.models.RoleModel;
import org.keycloak.services.resources.admin.permissions.AdminPermissionEvaluator;
import org.keycloak.services.resources.admin.permissions.RolePermissionEvaluator;

public abstract class RoleMappingResource {
    private final RealmModel realm;
    private final AdminPermissionEvaluator auth;

    public RoleMappingResource(RealmModel realm, AdminPermissionEvaluator auth) {
        this.realm = realm;
        this.auth = auth;
    }

    protected final Stream<ClientRole> mapping(Predicate<RoleModel> predicate) {
        return this.realm.getClientsStream().flatMap(RoleContainerModel::getRolesStream).filter(predicate).filter(arg_0 -> ((RolePermissionEvaluator)this.auth.roles()).canMapRole(arg_0)).map(roleModel -> RoleMapper.convertToModel(roleModel, this.realm.getClientsStream()));
    }

    protected final Stream<ClientRole> mapping(Predicate<RoleModel> predicate, Predicate<RoleModel> authPredicate) {
        return this.realm.getClientsStream().flatMap(RoleContainerModel::getRolesStream).filter(predicate).filter(authPredicate).map(roleModel -> RoleMapper.convertToModel(roleModel, this.realm.getClientsStream()));
    }

    protected final List<ClientRole> mapping(Predicate<RoleModel> predicate, long first, long max, String search) {
        return this.mapping(predicate).filter(clientRole -> clientRole.getClient().contains(search) || clientRole.getRole().contains(search)).skip(first).limit(max).collect(Collectors.toList());
    }

    protected final List<ClientRole> mapping(Predicate<RoleModel> predicate, Predicate<RoleModel> authPredicate, long first, long max, String search) {
        return this.mapping(predicate, authPredicate).filter(clientRole -> clientRole.getClient().contains(search) || clientRole.getRole().contains(search)).skip(first).limit(max).collect(Collectors.toList());
    }
}

