/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.processor.generation.multipart;

import io.quarkus.gizmo.ClassOutput;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.resteasy.reactive.common.processor.EndpointIndexer;
import org.jboss.resteasy.reactive.server.processor.generation.multipart.DotNames;
import org.jboss.resteasy.reactive.server.processor.generation.multipart.MultipartPopulatorGenerator;
import org.jboss.resteasy.reactive.server.processor.generation.multipart.MultipartTransformer;
import org.objectweb.asm.ClassVisitor;

public class GeneratedMultipartParamIndexerExtension
implements EndpointIndexer.MultipartParameterIndexerExtension {
    private final Map<String, String> multipartInputGeneratedPopulators = new HashMap<String, String>();
    final BiConsumer<String, BiFunction<String, ClassVisitor, ClassVisitor>> transformations;
    final ClassOutput classOutput;

    public GeneratedMultipartParamIndexerExtension(Map<String, BiFunction<String, ClassVisitor, ClassVisitor>> transformations, ClassOutput classOutput) {
        this.transformations = transformations::put;
        this.classOutput = classOutput;
    }

    public GeneratedMultipartParamIndexerExtension(BiConsumer<String, BiFunction<String, ClassVisitor, ClassVisitor>> transformations, ClassOutput classOutput) {
        this.transformations = transformations;
        this.classOutput = classOutput;
    }

    public void handleMultipartParameter(ClassInfo multipartClassInfo, IndexView index) {
        String className = multipartClassInfo.name().toString();
        if (this.multipartInputGeneratedPopulators.containsKey(className)) {
            return;
        }
        String populatorClassName = MultipartPopulatorGenerator.generate(multipartClassInfo, this.classOutput, index);
        this.multipartInputGeneratedPopulators.put(className, populatorClassName);
        ClassInfo currentClassInHierarchy = multipartClassInfo;
        while (true) {
            ClassInfo newCurrentClassInHierarchy;
            this.transformations.accept(currentClassInHierarchy.name().toString(), new MultipartTransformer(populatorClassName));
            DotName superClassDotName = currentClassInHierarchy.superName();
            if (superClassDotName.equals((Object)DotNames.OBJECT_NAME) || (newCurrentClassInHierarchy = index.getClassByName(superClassDotName)) == null) break;
            currentClassInHierarchy = newCurrentClassInHierarchy;
        }
    }
}

