/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.jpa.liquibase.connection;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import liquibase.Liquibase;
import liquibase.Scope;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.exception.LiquibaseException;
import liquibase.exception.ServiceNotFoundException;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.ResourceAccessor;
import liquibase.servicelocator.ServiceLocator;
import liquibase.sqlgenerator.SqlGeneratorFactory;
import liquibase.ui.LoggerUIService;
import org.jboss.logging.Logger;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.map.storage.jpa.liquibase.connection.JdbcConnectionFromPool;
import org.keycloak.models.map.storage.jpa.liquibase.connection.MapLiquibaseConnectionProvider;

public class DefaultLiquibaseConnectionProvider
implements MapLiquibaseConnectionProvider {
    private static final Logger logger = Logger.getLogger(DefaultLiquibaseConnectionProvider.class);
    private static final String KEYCLOAK_JPA_LEGACY_MODULE = "org.keycloak.connections.jpa";

    public DefaultLiquibaseConnectionProvider(KeycloakSession session) {
    }

    public void close() {
    }

    @Override
    public Liquibase getLiquibaseForCustomUpdate(Connection connection, String defaultSchema, String changelogLocation, ClassLoader classloader, String changelogTableName) throws LiquibaseException {
        final String scopeId = this.enterLiquibaseScope();
        try {
            Database database = DatabaseFactory.getInstance().findCorrectDatabaseImplementation((DatabaseConnection)new JdbcConnectionFromPool(connection.unwrap(Connection.class)));
            if (defaultSchema != null) {
                database.setDefaultSchemaName(defaultSchema);
            }
            ClassLoaderResourceAccessor resourceAccessor = new ClassLoaderResourceAccessor(classloader);
            database.setDatabaseChangeLogTableName(changelogTableName);
            logger.debugf("Using changelog file %s and changelogTableName %s", (Object)changelogLocation, (Object)database.getDatabaseChangeLogTableName());
            return new Liquibase(changelogLocation, (ResourceAccessor)resourceAccessor, database){

                public void close() throws LiquibaseException {
                    super.close();
                    DefaultLiquibaseConnectionProvider.this.exitLiquibaseScope(scopeId);
                }
            };
        }
        catch (RuntimeException | LiquibaseException ex) {
            this.exitLiquibaseScope(scopeId);
            throw ex;
        }
        catch (SQLException e) {
            this.exitLiquibaseScope(scopeId);
            throw new LiquibaseException((Throwable)e);
        }
    }

    private void exitLiquibaseScope(String scopeId) {
        try {
            Scope.exit((String)scopeId);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to exist scope: " + e.getMessage(), e);
        }
        finally {
            SqlGeneratorFactory.reset();
        }
    }

    private String enterLiquibaseScope() {
        String scopeId;
        HashMap<String, Object> scopeValues = new HashMap<String, Object>();
        scopeValues.put(Scope.Attr.ui.name(), new LoggerUIService());
        final ServiceLocator serviceLocator = Scope.getCurrentScope().getServiceLocator();
        scopeValues.put(Scope.Attr.serviceLocator.name(), new ServiceLocator(){

            public int getPriority() {
                return serviceLocator.getPriority();
            }

            public <T> List<T> findInstances(Class<T> interfaceType) throws ServiceNotFoundException {
                List instances = serviceLocator.findInstances(interfaceType);
                instances = instances.stream().filter(t -> !t.getClass().getPackage().getName().startsWith(DefaultLiquibaseConnectionProvider.KEYCLOAK_JPA_LEGACY_MODULE)).collect(Collectors.toList());
                return instances;
            }
        });
        try {
            scopeId = Scope.enter(scopeValues);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to initialize Liquibase: " + e.getMessage(), e);
        }
        finally {
            SqlGeneratorFactory.reset();
        }
        return scopeId;
    }
}

