/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute;

import io.quarkus.qute.Expression;
import io.quarkus.qute.ImmutableList;
import io.quarkus.qute.IncludeSectionHelper;
import io.quarkus.qute.Mapper;
import io.quarkus.qute.Parameter;
import io.quarkus.qute.SectionBlock;
import io.quarkus.qute.SectionHelper;
import io.quarkus.qute.SectionHelperFactory;
import io.quarkus.qute.Template;
import io.quarkus.qute.TemplateImpl;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

public class UserTagSectionHelper
extends IncludeSectionHelper
implements SectionHelper {
    private static final String NESTED_CONTENT = "nested-content";
    protected final boolean isNestedContentNeeded;

    UserTagSectionHelper(Supplier<Template> templateSupplier, Map<String, SectionBlock> extendingBlocks, Map<String, Expression> parameters, boolean isIsolated, boolean isNestedContentNeeded) {
        super(templateSupplier, extendingBlocks, parameters, isIsolated);
        this.isNestedContentNeeded = isNestedContentNeeded;
    }

    @Override
    protected boolean optimizeIfNoParams() {
        return false;
    }

    @Override
    protected void addAdditionalEvaluatedParams(SectionHelper.SectionResolutionContext context, Map<String, Object> evaluatedParams) {
        Expression nestedContent;
        if (this.isNestedContentNeeded && (nestedContent = ((TemplateImpl)this.template.get()).findExpression(this::isNestedContent)) != null) {
            evaluatedParams.put(NESTED_CONTENT, context.execute(context.resolutionContext().createChild(Mapper.wrap(evaluatedParams), null)));
        }
    }

    private boolean isNestedContent(Expression expr) {
        return expr.getParts().size() == 1 && expr.getParts().get(0).getName().equals(NESTED_CONTENT);
    }

    public static class Factory
    extends IncludeSectionHelper.AbstractIncludeFactory<UserTagSectionHelper> {
        private static final String IT = "it";
        private final String name;
        private final String templateId;

        public Factory(String name, String templateId) {
            this.name = name;
            this.templateId = templateId;
        }

        @Override
        public List<String> getDefaultAliases() {
            return ImmutableList.of(this.name);
        }

        @Override
        public SectionHelperFactory.ParametersInfo getParameters() {
            return SectionHelperFactory.ParametersInfo.builder().addParameter(Parameter.builder(IT).defaultValue(IT)).addParameter(Parameter.builder("_isolated").defaultValue("false").optional().valuePredicate(v -> "_isolated".equals(v))).build();
        }

        @Override
        protected boolean ignoreParameterInit(String key, String value) {
            return key.equals("_isolated") || value.equals("_isolated") || key.equals(IT) && value.equals(IT);
        }

        @Override
        protected String getTemplateId(SectionHelperFactory.SectionInitContext context) {
            return this.templateId;
        }

        @Override
        protected UserTagSectionHelper newHelper(Supplier<Template> template, Map<String, Expression> params, Map<String, SectionBlock> extendingBlocks, boolean isolated, SectionHelperFactory.SectionInitContext context) {
            boolean isNestedContentNeeded = !context.getBlock("$main").isEmpty();
            return new UserTagSectionHelper(template, extendingBlocks, params, isolated, isNestedContentNeeded);
        }

        @Override
        protected void handleParamInit(String key, String value, SectionHelperFactory.SectionInitContext context, Map<String, Expression> params) {
            if (key.equals(IT)) {
                if (value.equals(IT)) {
                    return;
                }
                if (this.isSinglePart(value)) {
                    params.put(value, context.getExpression(key));
                }
            }
            super.handleParamInit(key, value, context, params);
        }
    }
}

