/*
 * Decompiled with CFR 0.152.
 */
package javax.servlet.jsp.jstl.tlv;

import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.jsp.jstl.tlv.PageParser;
import javax.servlet.jsp.tagext.PageData;
import javax.servlet.jsp.tagext.TagLibraryValidator;
import javax.servlet.jsp.tagext.ValidationMessage;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PermittedTaglibsTLV
extends TagLibraryValidator {
    private static final String PERMITTED_TAGLIBS_PARAM = "permittedTaglibs";
    private static final String JSP_ROOT_URI = "http://java.sun.com/JSP/Page";
    private static final String JSP_ROOT_NAME = "root";
    private static final String JSP_ROOT_QN = "jsp:root";
    private static final PageParser parser = new PageParser(false);
    private final Set<String> permittedTaglibs = new HashSet<String>();

    public void setInitParameters(Map<String, Object> initParams) {
        super.setInitParameters(initParams);
        this.permittedTaglibs.clear();
        String uris = (String)initParams.get(PERMITTED_TAGLIBS_PARAM);
        if (uris != null) {
            StringTokenizer st = new StringTokenizer(uris);
            while (st.hasMoreTokens()) {
                this.permittedTaglibs.add(st.nextToken());
            }
        }
    }

    public ValidationMessage[] validate(String prefix, String uri, PageData page) {
        try {
            PermittedTaglibsHandler h = new PermittedTaglibsHandler(prefix, uri);
            parser.parse(page, h);
            return h.getResult();
        }
        catch (SAXException ex) {
            return this.vmFromString(ex.toString());
        }
        catch (ParserConfigurationException ex) {
            return this.vmFromString(ex.toString());
        }
        catch (IOException ex) {
            return this.vmFromString(ex.toString());
        }
    }

    private ValidationMessage[] vmFromString(String message) {
        return new ValidationMessage[]{new ValidationMessage(null, message)};
    }

    private class PermittedTaglibsHandler
    extends DefaultHandler {
        private final String prefix;
        private final String uri;
        private boolean failed;

        public PermittedTaglibsHandler(String prefix, String uri) {
            this.prefix = prefix;
            this.uri = uri;
        }

        public void startElement(String ns, String ln, String qn, Attributes a) {
            if (qn.equals(PermittedTaglibsTLV.JSP_ROOT_QN) || ns.equals(PermittedTaglibsTLV.JSP_ROOT_URI) && ln.equals(PermittedTaglibsTLV.JSP_ROOT_NAME)) {
                for (int i = 0; i < a.getLength(); ++i) {
                    String value;
                    String name = a.getQName(i);
                    if (!name.startsWith("xmlns:") || (value = a.getValue(i)).equals(this.uri) || value.equals(PermittedTaglibsTLV.JSP_ROOT_URI) || PermittedTaglibsTLV.this.permittedTaglibs.contains(value)) continue;
                    this.failed = true;
                }
            }
        }

        private ValidationMessage[] getResult() {
            if (this.failed) {
                return PermittedTaglibsTLV.this.vmFromString("taglib " + this.prefix + " (" + this.uri + ") allows only the " + "following taglibs to be imported: " + PermittedTaglibsTLV.this.permittedTaglibs);
            }
            return null;
        }
    }
}

