/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.olap;

import ca.sqlpower.architect.olap.MondrianModel;
import ca.sqlpower.architect.olap.OLAPObject;
import ca.sqlpower.architect.olap.OLAPUtil;
import ca.sqlpower.architect.swingui.ContainerPaneUI;
import ca.sqlpower.architect.swingui.PlayPenComponent;
import ca.sqlpower.architect.swingui.PlayPenContentPane;
import ca.sqlpower.architect.swingui.PlayPenCoordinate;
import ca.sqlpower.architect.swingui.olap.BasicVirtualCubePaneUI;
import ca.sqlpower.architect.swingui.olap.CubeEditPanel;
import ca.sqlpower.architect.swingui.olap.DimensionEditPanel;
import ca.sqlpower.architect.swingui.olap.OLAPPane;
import ca.sqlpower.architect.swingui.olap.OLAPPaneSection;
import ca.sqlpower.architect.swingui.olap.VirtualCubeEditPanel;
import ca.sqlpower.object.SPObject;
import ca.sqlpower.object.annotation.Constructor;
import ca.sqlpower.object.annotation.ConstructorParameter;
import ca.sqlpower.object.annotation.NonBound;
import ca.sqlpower.sqlobject.SQLObjectException;
import ca.sqlpower.swingui.DataEntryPanel;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.List;

public class VirtualCubePane
extends OLAPPane<MondrianModel.VirtualCube, OLAPObject> {
    public static final List<Class<? extends SPObject>> allowedChildTypes = PlayPenComponent.allowedChildTypes;

    public VirtualCubePane(VirtualCubePane copyMe, PlayPenContentPane parent) {
        super(copyMe, parent);
        this.updateUI();
    }

    @Constructor
    public VirtualCubePane(@ConstructorParameter(propertyName="model") MondrianModel.VirtualCube model, @ConstructorParameter(propertyName="parent") PlayPenContentPane parent) {
        super(model.getName(), parent);
        this.model = model;
        if (model.getCubeUsage() == null) {
            model.setCubeUsage(new MondrianModel.CubeUsages());
        }
        OLAPPaneSection<MondrianModel.CubeUsage> cubeSection = new OLAPPaneSection<MondrianModel.CubeUsage>(MondrianModel.CubeUsage.class, model.getCubeUsage().getCubeUsages(), "Cube Usages:"){

            @Override
            public void addItem(int idx, MondrianModel.CubeUsage item) {
                ((MondrianModel.VirtualCube)((Object)VirtualCubePane.this.model)).getCubeUsage().addCubeUsage(idx, item);
            }
        };
        OLAPPaneSection<MondrianModel.VirtualCubeDimension> dimensionSection = new OLAPPaneSection<MondrianModel.VirtualCubeDimension>(MondrianModel.VirtualCubeDimension.class, model.getDimensions(), "Dimensions:"){

            @Override
            public void addItem(int idx, MondrianModel.VirtualCubeDimension item) {
                ((MondrianModel.VirtualCube)((Object)VirtualCubePane.this.model)).addDimension(idx, item);
            }
        };
        OLAPPaneSection<MondrianModel.VirtualCubeMeasure> measureSection = new OLAPPaneSection<MondrianModel.VirtualCubeMeasure>(MondrianModel.VirtualCubeMeasure.class, model.getMeasures(), "Measures:"){

            @Override
            public void addItem(int idx, MondrianModel.VirtualCubeMeasure item) {
                ((MondrianModel.VirtualCube)((Object)VirtualCubePane.this.model)).addMeasure(idx, item);
            }
        };
        this.sections.add(cubeSection);
        this.sections.add(dimensionSection);
        this.sections.add(measureSection);
        this.setDashed(true);
        this.updateUI();
    }

    @Override
    @NonBound
    protected List<OLAPObject> getItems() {
        ArrayList<OLAPObject> items = new ArrayList<OLAPObject>();
        items.addAll(((MondrianModel.VirtualCube)((Object)this.model)).getCubeUsage().getCubeUsages());
        items.addAll(((MondrianModel.VirtualCube)((Object)this.model)).getChildren(OLAPObject.class));
        return items;
    }

    public void updateUI() {
        ContainerPaneUI ui = (ContainerPaneUI)BasicVirtualCubePaneUI.createUI();
        ui.installUI(this);
        this.setUI(ui);
    }

    public String toString() {
        return "VirtualCubePane: " + ((MondrianModel.VirtualCube)((Object)this.model)).getName();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public DataEntryPanel createEditDialog(PlayPenCoordinate<MondrianModel.VirtualCube, OLAPObject> coord) throws SQLObjectException {
        void var2_8;
        if (coord.getIndex() == -1) {
            VirtualCubeEditPanel virtualCubeEditPanel = new VirtualCubeEditPanel((MondrianModel.VirtualCube)((Object)this.model));
            return var2_8;
        } else {
            if (coord.getIndex() == -3) {
                return var2_8;
            }
            if (coord.getIndex() <= -1) return var2_8;
            if (coord.getItem() instanceof MondrianModel.CubeUsage) {
                MondrianModel.CubeUsage cu = (MondrianModel.CubeUsage)coord.getItem();
                MondrianModel.Cube c = OLAPUtil.findReferencedCube((MondrianModel.VirtualCube)((Object)this.model), cu);
                if (c == null) {
                    throw new NullPointerException("Couldn't find cube!");
                }
                CubeEditPanel cubeEditPanel = new CubeEditPanel(c, this.getPlayPen(), this.getPlayPen().getSession());
                return var2_8;
            } else if (coord.getItem() instanceof MondrianModel.VirtualCubeDimension) {
                MondrianModel.VirtualCubeDimension vcd = (MondrianModel.VirtualCubeDimension)coord.getItem();
                MondrianModel.Dimension d = OLAPUtil.findReferencedDimension(vcd);
                if (d == null) {
                    throw new NullPointerException("Couldn't find dimension!");
                }
                DimensionEditPanel dimensionEditPanel = new DimensionEditPanel(d);
                return var2_8;
            } else {
                if (!(coord.getItem() instanceof MondrianModel.VirtualCubeMeasure)) throw new IllegalArgumentException("Edit dialog for type " + ((Object)((Object)coord.getItem())).getClass() + " cannot be created!");
                return var2_8;
            }
        }
    }

    @Override
    protected List<OLAPObject> filterDroppableItems(List<OLAPObject> items) {
        ArrayList<OLAPObject> filtered = new ArrayList<OLAPObject>();
        for (OLAPObject item : items) {
            if (!(item instanceof MondrianModel.CubeUsage) && !(item instanceof MondrianModel.VirtualCubeDimension) && !(item instanceof MondrianModel.VirtualCubeMeasure)) continue;
            filtered.add(item);
        }
        return filtered;
    }

    @Override
    public void pasteData(Transferable t) {
    }
}

