"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProxyAuthentication = void 0;

var _lodash = require("lodash");

var _routes = require("./routes");

var _authentication_type = require("../authentication_type");

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class ProxyAuthentication extends _authentication_type.AuthenticationType {
  constructor(config, sessionStorageFactory, router, esClient, coreSetup, logger) {
    var _this$config$proxycac, _this$config$proxycac2, _this$config$proxycac3, _this$config$proxycac4;

    super(config, sessionStorageFactory, router, esClient, coreSetup, logger);

    _defineProperty(this, "type", 'proxy');

    _defineProperty(this, "authType", 'proxycache');

    _defineProperty(this, "userHeaderName", void 0);

    _defineProperty(this, "roleHeaderName", void 0);

    this.userHeaderName = ((_this$config$proxycac = this.config.proxycache) === null || _this$config$proxycac === void 0 ? void 0 : (_this$config$proxycac2 = _this$config$proxycac.user_header) === null || _this$config$proxycac2 === void 0 ? void 0 : _this$config$proxycac2.toLowerCase()) || '';
    this.roleHeaderName = ((_this$config$proxycac3 = this.config.proxycache) === null || _this$config$proxycac3 === void 0 ? void 0 : (_this$config$proxycac4 = _this$config$proxycac3.roles_header) === null || _this$config$proxycac4 === void 0 ? void 0 : _this$config$proxycac4.toLowerCase()) || '';
    this.setupRoutes();
  }

  setupRoutes() {
    const routes = new _routes.ProxyAuthRoutes(this.router, this.config, this.sessionStorageFactory, this.securityClient, this.coreSetup);
    routes.setupRoutes();
  }

  requestIncludesAuthInfo(request) {
    return request.headers[ProxyAuthentication.XFF] && request.headers[this.userHeaderName] ? true : false;
  }

  getAdditionalAuthHeader(request) {
    var _this$config$proxycac5, _this$config$proxycac6;

    const authHeaders = {};
    const customProxyHeader = (_this$config$proxycac5 = this.config.proxycache) === null || _this$config$proxycac5 === void 0 ? void 0 : _this$config$proxycac5.proxy_header;

    if (customProxyHeader && !request.headers[customProxyHeader] && (_this$config$proxycac6 = this.config.proxycache) !== null && _this$config$proxycac6 !== void 0 && _this$config$proxycac6.proxy_header_ip) {
      // TODO: check how to get remoteIp from OpenSearchDashboardsRequest and add remoteIp to this header
      authHeaders[customProxyHeader] = this.config.proxycache.proxy_header_ip;
    }

    return authHeaders;
  }

  getCookie(request, authInfo) {
    const cookie = {
      username: authInfo.username,
      credentials: {},
      authType: this.authType,
      isAnonymousAuth: false,
      expiryTime: Date.now() + this.config.session.ttl
    };

    if (this.userHeaderName && request.headers[this.userHeaderName]) {
      cookie.credentials[this.userHeaderName] = request.headers[this.userHeaderName];
    }

    if (this.roleHeaderName && request.headers[this.roleHeaderName]) {
      cookie.credentials[this.roleHeaderName] = request.headers[this.roleHeaderName];
    }

    if (request.headers[ProxyAuthentication.XFF]) {
      cookie.credentials[ProxyAuthentication.XFF] = request.headers[ProxyAuthentication.XFF];
    }

    if (request.headers.authorization) {
      cookie.credentials.authorization = request.headers.authorization;
    }

    return cookie;
  }

  async isValidCookie(cookie) {
    return cookie.authType === this.type && cookie.username && cookie.expiryTime && cookie.credentials[this.userHeaderName];
  }

  handleUnauthedRequest(request, response, toolkit) {
    var _this$config$proxycac7;

    const loginEndpoint = (_this$config$proxycac7 = this.config.proxycache) === null || _this$config$proxycac7 === void 0 ? void 0 : _this$config$proxycac7.login_endpoint;

    if (loginEndpoint) {
      return toolkit.redirected({
        location: loginEndpoint
      });
    } else {
      return toolkit.notHandled(); // TODO: redirect to error page?
    }
  }

  buildAuthHeaderFromCookie(cookie) {
    const authHeaders = {};

    if ((0, _lodash.get)(cookie.credentials, this.userHeaderName)) {
      authHeaders[this.userHeaderName] = cookie.credentials[this.userHeaderName];

      if ((0, _lodash.get)(cookie.credentials, this.roleHeaderName)) {
        authHeaders[this.roleHeaderName] = cookie.credentials[this.roleHeaderName];
      }

      if ((0, _lodash.get)(cookie.credentials, ProxyAuthentication.XFF)) {
        authHeaders[ProxyAuthentication.XFF] = cookie.credentials[ProxyAuthentication.XFF];
      }

      return authHeaders;
    } else if ((0, _lodash.get)(cookie.credentials, 'authorization')) {
      authHeaders.authorization = (0, _lodash.get)(cookie.credentials, 'authorization');
      return authHeaders;
    }
  }

}

exports.ProxyAuthentication = ProxyAuthentication;

_defineProperty(ProxyAuthentication, "XFF", 'x-forwarded-for');
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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