"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
Object.defineProperty(exports, "__esModule", { value: true });
var specs_1 = require("../utils/specs");
var tooltip_1 = require("./line/tooltip");
var tooltip_2 = require("./rect/tooltip");
function computeAnnotationTooltipState(cursorPosition, annotationDimensions, annotationSpecs, chartRotation, axesSpecs, chartDimensions) {
    var e_1, _a;
    var sortedSpecs = annotationSpecs
        .slice()
        .reverse()
        .sort(function (_a, _b) {
        var _c = _a.zIndex, a = _c === void 0 ? Number.MIN_SAFE_INTEGER : _c;
        var _d = _b.zIndex, b = _d === void 0 ? Number.MIN_SAFE_INTEGER : _d;
        return b - a;
    });
    try {
        for (var sortedSpecs_1 = __values(sortedSpecs), sortedSpecs_1_1 = sortedSpecs_1.next(); !sortedSpecs_1_1.done; sortedSpecs_1_1 = sortedSpecs_1.next()) {
            var spec = sortedSpecs_1_1.value;
            var annotationDimension = annotationDimensions.get(spec.id);
            if (spec.hideTooltips || !annotationDimension) {
                continue;
            }
            var groupId = spec.groupId, customTooltip = spec.customTooltip, customTooltipDetails = spec.customTooltipDetails;
            var tooltipSettings = getTooltipSettings(spec);
            if (specs_1.isLineAnnotation(spec)) {
                if (spec.hideLines) {
                    continue;
                }
                var lineAnnotationTooltipState = tooltip_1.computeLineAnnotationTooltipState(cursorPosition, annotationDimension, groupId, spec.domainType, axesSpecs, chartDimensions);
                if (lineAnnotationTooltipState) {
                    return __assign(__assign({}, lineAnnotationTooltipState), { tooltipSettings: tooltipSettings,
                        customTooltip: customTooltip,
                        customTooltipDetails: customTooltipDetails });
                }
            }
            else if (specs_1.isRectAnnotation(spec)) {
                var rectAnnotationTooltipState = tooltip_2.computeRectAnnotationTooltipState(cursorPosition, annotationDimension, chartRotation, chartDimensions);
                if (rectAnnotationTooltipState) {
                    return __assign(__assign({}, rectAnnotationTooltipState), { tooltipSettings: tooltipSettings,
                        customTooltip: customTooltip, customTooltipDetails: (customTooltipDetails !== null && customTooltipDetails !== void 0 ? customTooltipDetails : spec.renderTooltip) });
                }
            }
        }
    }
    catch (e_1_1) { e_1 = { error: e_1_1 }; }
    finally {
        try {
            if (sortedSpecs_1_1 && !sortedSpecs_1_1.done && (_a = sortedSpecs_1.return)) _a.call(sortedSpecs_1);
        }
        finally { if (e_1) throw e_1.error; }
    }
    return null;
}
exports.computeAnnotationTooltipState = computeAnnotationTooltipState;
function getTooltipSettings(_a) {
    var placement = _a.placement, fallbackPlacements = _a.fallbackPlacements, boundary = _a.boundary, offset = _a.offset;
    return {
        placement: placement,
        fallbackPlacements: fallbackPlacements,
        boundary: boundary,
        offset: offset,
    };
}
//# sourceMappingURL=tooltip.js.map