/*
 * Decompiled with CFR 0.152.
 */
package tr.model.util;

import java.util.Vector;
import tr.util.Observable;
import tr.util.ObservableImpl;
import tr.util.Observer;
import tr.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Manager<T extends Observable>
extends ObservableImpl
implements Observer,
Observable {
    private final Vector<T> items = new Vector();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized boolean add(T item) {
        if (item == null) {
            return false;
        }
        Manager manager = this;
        synchronized (manager) {
            if (!this.items.add(item)) {
                return false;
            }
        }
        item.addObserver((Observer)this);
        this.notifyObservers(this, new EventAdd<T>(item));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void insert(T item, int pos) {
        if (item == null) {
            return;
        }
        Manager manager = this;
        synchronized (manager) {
            this.items.add(pos, item);
        }
        item.addObserver((Observer)this);
        this.notifyObservers(this, new EventInsert<T>(item, pos));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized boolean remove(T item) {
        if (item == null) {
            return false;
        }
        Manager manager = this;
        synchronized (manager) {
            if (!this.items.contains(item)) {
                return false;
            }
            if (!this.items.remove(item)) {
                return false;
            }
        }
        item.removeObserver((Observer)this);
        this.notifyObservers(this, new EventRemove<T>(item));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeAll() {
        Manager manager = this;
        synchronized (manager) {
            for (Observable item : this.items) {
                item.removeObserver((Observer)this);
            }
            this.items.removeAllElements();
        }
        this.notifyObservers(this, new EventRemoveAll());
    }

    public final T get(int index) throws IndexOutOfBoundsException {
        return (T)((Observable)this.items.get(index));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void set(int index, T item) throws IndexOutOfBoundsException {
        Observable old;
        Manager manager = this;
        synchronized (manager) {
            old = (Observable)this.items.set(index, item);
            if (Utils.equal(item, (Object)old)) {
                return;
            }
            old.removeObserver((Observer)this);
            item.addObserver((Observer)this);
        }
        this.notifyObservers(this, new EventReplace<Observable>(old, (Observable)item, index));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Vector<T> list() {
        Manager manager = this;
        synchronized (manager) {
            return new Vector<T>(this.items);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int indexOf(T item) {
        Manager manager = this;
        synchronized (manager) {
            return this.items.indexOf(item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int size() {
        Manager manager = this;
        synchronized (manager) {
            return this.items.size();
        }
    }

    public final void update(Observable observable, Object arg) {
        this.notifyObservers(observable, arg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void resetObservers() {
        Manager manager = this;
        synchronized (manager) {
            for (Observable item : this.items) {
                item.addObserver((Observer)this);
                item.resetObservers();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class EventReplace<T>
    extends Event {
        public final T itemOld;
        public final T itemNew;
        public final int posn;

        public EventReplace(T itemOld, T itemNew, int posn) {
            this.itemOld = itemOld;
            this.itemNew = itemNew;
            this.posn = posn;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class EventRemoveAll<T>
    extends Event {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class EventRemove<T>
    extends Event {
        public final T item;

        public EventRemove(T item) {
            this.item = item;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class EventInsert<T>
    extends Event {
        public final T item;
        public final int posn;

        public EventInsert(T item, int posn) {
            this.item = item;
            this.posn = posn;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class EventAdd<T>
    extends Event {
        public final T item;

        public EventAdd(T item) {
            this.item = item;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class Event<T> {
    }
}

