/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.UnsupportedEncodingException;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.util.Date;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class MemoryMonitor
extends JPanel {
    private static final long serialVersionUID = -3463003810776195761L;
    static JCheckBox dateStampCB = new JCheckBox("Output Date Stamp");
    public Surface surf;
    JPanel controls;
    boolean doControls;
    JTextField tf;
    static List<MemoryPoolMXBean> mpools = ManagementFactory.getMemoryPoolMXBeans();
    static int numPools = mpools.size();

    public MemoryMonitor() {
        this.setLayout(new BorderLayout());
        this.setBorder(new TitledBorder(new EtchedBorder(), "Memory Monitor"));
        this.surf = new Surface();
        this.add(this.surf);
        this.controls = new JPanel();
        this.controls.setPreferredSize(new Dimension(135, 80));
        Font font = new Font("serif", 0, 10);
        JLabel jLabel = new JLabel("Sample Rate");
        jLabel.setFont(font);
        jLabel.setForeground(Color.red);
        this.controls.add(jLabel);
        this.tf = new JTextField("1000");
        this.tf.setPreferredSize(new Dimension(45, 20));
        this.controls.add(this.tf);
        jLabel = new JLabel("ms");
        this.controls.add(jLabel);
        jLabel.setFont(font);
        jLabel.setForeground(Color.red);
        this.controls.add(dateStampCB);
        dateStampCB.setFont(font);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                MemoryMonitor.this.removeAll();
                MemoryMonitor.this.doControls = !MemoryMonitor.this.doControls;
                if (MemoryMonitor.this.doControls) {
                    MemoryMonitor.this.surf.stop();
                    MemoryMonitor.this.add(MemoryMonitor.this.controls);
                } else {
                    try {
                        MemoryMonitor.this.surf.sleepAmount = Long.parseLong(MemoryMonitor.this.tf.getText().trim());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    MemoryMonitor.this.surf.start();
                    MemoryMonitor.this.add(MemoryMonitor.this.surf);
                }
                MemoryMonitor.this.validate();
                MemoryMonitor.this.repaint();
            }
        });
    }

    public static void main(String[] stringArray) {
        final MemoryMonitor memoryMonitor = new MemoryMonitor();
        WindowAdapter windowAdapter = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }

            @Override
            public void windowDeiconified(WindowEvent windowEvent) {
                memoryMonitor.surf.start();
            }

            @Override
            public void windowIconified(WindowEvent windowEvent) {
                memoryMonitor.surf.stop();
            }
        };
        JFrame jFrame = new JFrame("MemoryMonitor");
        jFrame.addWindowListener(windowAdapter);
        jFrame.getContentPane().add("Center", memoryMonitor);
        jFrame.pack();
        jFrame.setSize(new Dimension(400, 500));
        jFrame.setVisible(true);
        memoryMonitor.surf.start();
        Thread thread = new Thread(new Memeater());
        thread.start();
    }

    static class Memeater
    extends ClassLoader
    implements Runnable {
        Object[] y;
        static int count = 100000;

        @Override
        public void run() {
            this.y = new Object[10000000];
            int n = 0;
            block4: while (true) {
                if (n == 5000000) {
                    n = 0;
                }
                this.y[n++] = new Object();
                try {
                    Thread.sleep(20L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    int n2 = 0;
                    while (true) {
                        if (n2 >= 10) continue block4;
                        this.loadNext();
                        ++n2;
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    continue;
                }
                break;
            }
        }

        Class<?> loadNext() throws ClassNotFoundException {
            byte[] byArray;
            int[] nArray = new int[]{202, 254, 186, 190, 0, 0, 0, 48, 0, 10, 10, 0, 3, 0, 7, 7, 0, 8, 7, 0, 9, 1, 0, 6, 60, 105, 110, 105, 116, 62, 1, 0, 3, 40, 41, 86, 1, 0, 4, 67, 111, 100, 101, 12, 0, 4, 0, 5, 1, 0, 10, 84, 101, 115, 116};
            int[] nArray2 = new int[]{1, 0, 16, 106, 97, 118, 97, 47, 108, 97, 110, 103, 47, 79, 98, 106, 101, 99, 116, 0, 33, 0, 2, 0, 3, 0, 0, 0, 0, 0, 1, 0, 1, 0, 4, 0, 5, 0, 1, 0, 6, 0, 0, 0, 17, 0, 1, 0, 1, 0, 0, 0, 5, 42, 183, 0, 1, 177, 0, 0, 0, 0, 0, 0};
            String string = "Test" + Integer.toString(count++);
            try {
                byArray = string.substring(4).getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new Error();
            }
            int n = nArray.length + byArray.length + nArray2.length;
            byte[] byArray2 = new byte[n];
            int n2 = 0;
            for (int n3 : nArray) {
                byArray2[n2++] = (byte)n3;
            }
            for (int n3 : byArray) {
                byArray2[n2++] = n3;
            }
            for (int n3 : nArray2) {
                byArray2[n2++] = (byte)n3;
            }
            return this.defineClass(string, byArray2, 0, byArray2.length);
        }
    }

    public class Surface
    extends JPanel
    implements Runnable {
        public Thread thread;
        public long sleepAmount = 1000L;
        public int usageHistCount = 20000;
        private int w;
        private int h;
        private BufferedImage bimg;
        private Graphics2D big;
        private Font font = new Font("Times New Roman", 0, 11);
        private int columnInc;
        private float[][] usedMem;
        private float[] usedMemMax;
        private int[] ptNum;
        private int ascent;
        private int descent;
        private Rectangle graphOutlineRect = new Rectangle();
        private Rectangle2D mfRect = new Rectangle2D.Float();
        private Rectangle2D muRect = new Rectangle2D.Float();
        private Line2D graphLine = new Line2D.Float();
        private Color graphColor = new Color(46, 139, 87);
        private Color mfColor = new Color(0, 100, 0);
        private String usedStr;

        public Surface() {
            this.setBackground(Color.black);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    if (Surface.this.thread == null) {
                        Surface.this.start();
                    } else {
                        Surface.this.stop();
                    }
                }
            });
            this.usedMem = new float[numPools][];
            this.usedMemMax = new float[numPools];
            for (int i = 0; i < numPools; ++i) {
                this.usedMemMax[i] = 1048576.0f;
            }
            this.ptNum = new int[numPools];
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(135, 80);
        }

        @Override
        public void paint(Graphics graphics) {
            if (this.big == null) {
                return;
            }
            this.big.setBackground(this.getBackground());
            this.big.clearRect(0, 0, this.w, this.h);
            this.h /= (numPools + numPools % 2) / 2;
            this.w /= 2;
            int n = 0;
            block0: for (int i = 0; i < 2; ++i) {
                for (int j = 0; j < (numPools + numPools % 2) / 2; ++j) {
                    this.plotMemoryUsage(this.w * i, this.h * j, this.w, this.h, n);
                    if (++n < numPools) continue;
                    i = 3;
                    j = (numPools + numPools % 2) / 2;
                    continue block0;
                }
            }
            graphics.drawImage(this.bimg, 0, 0, this);
        }

        public void plotMemoryUsage(int n, int n2, int n3, int n4, int n5) {
            int n6;
            int n7;
            int n8;
            MemoryPoolMXBean memoryPoolMXBean = mpools.get(n5);
            float f = memoryPoolMXBean.getUsage().getUsed();
            float f2 = memoryPoolMXBean.getUsage().getMax();
            if (f2 < 0.0f) {
                if (f > this.usedMemMax[n5]) {
                    this.usedMemMax[n5] = f;
                }
                f2 = this.usedMemMax[n5];
            }
            this.big.setColor(Color.green);
            this.big.drawString(String.valueOf((int)f2 / 1024) + "K Max ", (float)n + 4.0f, (float)n2 + (float)this.ascent + 0.5f);
            this.big.setColor(Color.yellow);
            this.big.drawString(memoryPoolMXBean.getName(), (float)(n + n3 / 2), (float)n2 + (float)this.ascent + 0.5f);
            this.usedStr = String.valueOf((int)f / 1024) + "K used";
            this.big.setColor(Color.green);
            this.big.drawString(this.usedStr, n + 4, n2 + n4 - this.descent);
            float f3 = this.ascent + this.descent;
            float f4 = (float)n4 - f3 * 2.0f - 0.5f;
            float f5 = f4 / 10.0f;
            float f6 = 20.0f;
            float f7 = (float)n3 - f6 - 10.0f;
            this.big.setColor(this.mfColor);
            int n9 = (int)((f2 - f) / f2 * 10.0f);
            for (n8 = 0; n8 < n9; ++n8) {
                this.mfRect.setRect(n + 5, (float)n2 + f3 + (float)n8 * f5, f6, f5 - 1.0f);
                this.big.fill(this.mfRect);
            }
            this.big.setColor(Color.green);
            while (n8 < 10) {
                this.muRect.setRect(n + 5, (float)n2 + f3 + (float)n8 * f5, f6, f5 - 1.0f);
                this.big.fill(this.muRect);
                ++n8;
            }
            if (f7 <= 30.0f) {
                f7 = 30.0f;
            }
            if (f4 <= f3) {
                f4 = f3;
            }
            this.big.setColor(this.graphColor);
            int n10 = n + 30;
            int n11 = n2 + (int)f3;
            int n12 = (int)f7;
            int n13 = (int)f4;
            this.graphOutlineRect.setRect(n10, n11, n12, n13);
            this.big.draw(this.graphOutlineRect);
            int n14 = n13 / 10;
            for (n7 = n11; n7 <= n13 + n11; n7 += n14) {
                this.graphLine.setLine(n10, n7, n10 + n12, n7);
                this.big.draw(this.graphLine);
            }
            n7 = n12 / 15;
            if (this.columnInc == 0) {
                this.columnInc = n7;
            }
            for (n6 = n10 + this.columnInc; n6 < n12 + n10; n6 += n7) {
                this.graphLine.setLine(n6, n11, n6, n11 + n13);
                this.big.draw(this.graphLine);
            }
            --this.columnInc;
            if (this.usedMem[n5] == null) {
                this.usedMem[n5] = new float[this.usageHistCount];
                this.ptNum[n5] = 0;
            }
            this.usedMem[n5][this.ptNum[n5]] = f;
            this.big.setColor(Color.yellow);
            n6 = this.ptNum[n5] > n12 ? n12 : this.ptNum[n5];
            int n15 = n10 + n12 - n6;
            int n16 = this.ptNum[n5] - n6;
            while (n16 < this.ptNum[n5]) {
                if (n16 != 0) {
                    int n17;
                    if (this.usedMem[n5][n16] != this.usedMem[n5][n16 - 1]) {
                        n17 = (int)((float)n11 + (float)n13 * ((f2 - this.usedMem[n5][n16 - 1]) / f2));
                        int n18 = (int)((float)n11 + (float)n13 * ((f2 - this.usedMem[n5][n16]) / f2));
                        this.big.drawLine(n15 - 1, n17, n15, n18);
                    } else {
                        n17 = (int)((float)n11 + (float)n13 * ((f2 - this.usedMem[n5][n16]) / f2));
                        this.big.fillRect(n15, n17, 1, 1);
                    }
                }
                ++n16;
                ++n15;
            }
            if (this.ptNum[n5] + 2 == this.usedMem[n5].length) {
                for (n15 = 1; n15 < this.ptNum[n5]; ++n15) {
                    this.usedMem[n5][n15 - 1] = this.usedMem[n5][n15];
                }
                int n19 = n5;
                this.ptNum[n19] = this.ptNum[n19] - 1;
            } else {
                int n20 = n5;
                this.ptNum[n20] = this.ptNum[n20] + 1;
            }
        }

        public void start() {
            this.thread = new Thread(this);
            this.thread.setPriority(1);
            this.thread.setName("MemoryMonitor");
            this.thread.start();
        }

        public synchronized void stop() {
            this.thread = null;
            this.notify();
        }

        @Override
        public void run() {
            Thread thread = Thread.currentThread();
            while (this.thread == thread && !this.isShowing() || this.getSize().width == 0) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
            }
            while (this.thread == thread && this.isShowing()) {
                Dimension dimension = this.getSize();
                if (dimension.width != this.w || dimension.height != this.h) {
                    this.w = dimension.width;
                    this.h = dimension.height;
                    this.bimg = (BufferedImage)this.createImage(this.w, this.h);
                    this.big = this.bimg.createGraphics();
                    this.big.setFont(this.font);
                    FontMetrics fontMetrics = this.big.getFontMetrics(this.font);
                    this.ascent = fontMetrics.getAscent();
                    this.descent = fontMetrics.getDescent();
                }
                this.repaint();
                try {
                    Thread.sleep(this.sleepAmount);
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
                if (!dateStampCB.isSelected()) continue;
                System.out.println(new Date().toString() + " " + this.usedStr);
            }
            this.thread = null;
        }
    }
}

