/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanMetadataElement;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.security.ConfigAttributeDefinition;
import org.springframework.security.ConfigAttributeEditor;
import org.springframework.security.config.AnonymousBeanDefinitionParser;
import org.springframework.security.config.BasicAuthenticationBeanDefinitionParser;
import org.springframework.security.config.ConcurrentSessionsBeanDefinitionParser;
import org.springframework.security.config.ConfigUtils;
import org.springframework.security.config.FormLoginBeanDefinitionParser;
import org.springframework.security.config.LogoutBeanDefinitionParser;
import org.springframework.security.config.PortMappingsBeanDefinitionParser;
import org.springframework.security.config.RememberMeBeanDefinitionParser;
import org.springframework.security.config.X509BeanDefinitionParser;
import org.springframework.security.intercept.web.DefaultFilterInvocationDefinitionSource;
import org.springframework.security.intercept.web.RequestKey;
import org.springframework.security.util.AntUrlPathMatcher;
import org.springframework.security.util.RegexUrlPathMatcher;
import org.springframework.security.util.UrlMatcher;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class HttpSecurityBeanDefinitionParser
implements BeanDefinitionParser {
    static final Log logger = LogFactory.getLog((Class)(class$org$springframework$security$config$HttpSecurityBeanDefinitionParser == null ? (class$org$springframework$security$config$HttpSecurityBeanDefinitionParser = HttpSecurityBeanDefinitionParser.class$("org.springframework.security.config.HttpSecurityBeanDefinitionParser")) : class$org$springframework$security$config$HttpSecurityBeanDefinitionParser));
    static final String ATT_REALM = "realm";
    static final String DEF_REALM = "Spring Security Application";
    static final String ATT_PATH_PATTERN = "pattern";
    static final String ATT_SESSION_FIXATION_PROTECTION = "session-fixation-protection";
    static final String OPT_SESSION_FIXATION_NO_PROTECTION = "none";
    static final String OPT_SESSION_FIXATION_CLEAN_SESSION = "newSession";
    static final String OPT_SESSION_FIXATION_MIGRATE_SESSION = "migrateSession";
    static final String ATT_PATH_TYPE = "path-type";
    static final String DEF_PATH_TYPE_ANT = "ant";
    static final String OPT_PATH_TYPE_REGEX = "regex";
    static final String ATT_FILTERS = "filters";
    static final String OPT_FILTERS_NONE = "none";
    static final String ATT_ACCESS_CONFIG = "access";
    static final String ATT_REQUIRES_CHANNEL = "requires-channel";
    static final String OPT_REQUIRES_HTTP = "http";
    static final String OPT_REQUIRES_HTTPS = "https";
    static final String OPT_ANY_CHANNEL = "any";
    static final String ATT_HTTP_METHOD = "method";
    static final String ATT_CREATE_SESSION = "create-session";
    static final String DEF_CREATE_SESSION_IF_REQUIRED = "ifRequired";
    static final String OPT_CREATE_SESSION_ALWAYS = "always";
    static final String OPT_CREATE_SESSION_NEVER = "never";
    static final String ATT_LOWERCASE_COMPARISONS = "lowercase-comparisons";
    static final String DEF_LOWERCASE_COMPARISONS = "true";
    static final String ATT_AUTO_CONFIG = "auto-config";
    static final String DEF_AUTO_CONFIG = "false";
    static final String ATT_SERVLET_API_PROVISION = "servlet-api-provision";
    static final String DEF_SERVLET_API_PROVISION = "true";
    static final String ATT_ACCESS_MGR = "access-decision-manager-ref";
    static final String ATT_USER_SERVICE_REF = "user-service-ref";
    static final String ATT_ENTRY_POINT_REF = "entry-point-ref";
    static final String ATT_ONCE_PER_REQUEST = "once-per-request";
    static final String ATT_ACCESS_DENIED_PAGE = "access-denied-page";
    static /* synthetic */ Class class$org$springframework$security$config$HttpSecurityBeanDefinitionParser;
    static /* synthetic */ Class class$org$springframework$security$config$EntryPointInjectionBeanPostProcessor;
    static /* synthetic */ Class class$org$springframework$security$config$UserDetailsServiceInjectionBeanPostProcessor;
    static /* synthetic */ Class class$org$springframework$security$config$RememberMeServicesInjectionBeanPostProcessor;
    static /* synthetic */ Class class$org$springframework$security$util$FilterChainProxy;
    static /* synthetic */ Class class$org$springframework$security$context$HttpSessionContextIntegrationFilter;
    static /* synthetic */ Class class$org$springframework$security$wrapper$SecurityContextHolderAwareRequestFilter;
    static /* synthetic */ Class class$org$springframework$security$ui$ExceptionTranslationFilter;
    static /* synthetic */ Class class$org$springframework$security$ui$AccessDeniedHandlerImpl;
    static /* synthetic */ Class class$org$springframework$security$intercept$web$FilterSecurityInterceptor;
    static /* synthetic */ Class class$org$springframework$security$securechannel$ChannelProcessingFilter;
    static /* synthetic */ Class class$org$springframework$security$securechannel$ChannelDecisionManagerImpl;
    static /* synthetic */ Class class$org$springframework$security$securechannel$SecureChannelProcessor;
    static /* synthetic */ Class class$org$springframework$security$securechannel$RetryWithHttpEntryPoint;
    static /* synthetic */ Class class$org$springframework$security$securechannel$RetryWithHttpsEntryPoint;
    static /* synthetic */ Class class$org$springframework$security$securechannel$InsecureChannelProcessor;
    static /* synthetic */ Class class$org$springframework$security$ui$SessionFixationProtectionFilter;
    static /* synthetic */ Class class$org$springframework$security$ui$webapp$DefaultLoginPageGeneratingFilter;

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        Element anonymousElt;
        ConfigUtils.registerProviderManagerIfNecessary(parserContext);
        BeanDefinitionRegistry registry = parserContext.getRegistry();
        UrlMatcher matcher = HttpSecurityBeanDefinitionParser.createUrlMatcher(element);
        Object source = parserContext.extractSource((Object)element);
        boolean convertPathsToLowerCase = matcher instanceof AntUrlPathMatcher && matcher.requiresLowerCaseUrl();
        List interceptUrlElts = DomUtils.getChildElementsByTagName((Element)element, (String)"intercept-url");
        LinkedHashMap filterChainMap = new LinkedHashMap();
        LinkedHashMap channelRequestMap = new LinkedHashMap();
        this.registerFilterChainProxy(parserContext, filterChainMap, matcher, source);
        this.parseInterceptUrlsForChannelSecurityAndFilterChain(interceptUrlElts, filterChainMap, channelRequestMap, convertPathsToLowerCase, parserContext);
        boolean allowSessionCreation = this.registerHttpSessionIntegrationFilter(element, parserContext);
        this.registerServletApiFilter(element, parserContext);
        String accessManagerId = element.getAttribute(ATT_ACCESS_MGR);
        if (!StringUtils.hasText((String)accessManagerId)) {
            ConfigUtils.registerDefaultAccessManagerIfNecessary(parserContext);
            accessManagerId = "_accessManager";
        }
        BeanDefinition portMapper = new PortMappingsBeanDefinitionParser().parse(DomUtils.getChildElementByTagName((Element)element, (String)"port-mappings"), parserContext);
        registry.registerBeanDefinition("_portMapper", portMapper);
        this.registerExceptionTranslationFilter(element, parserContext, allowSessionCreation);
        if (channelRequestMap.size() > 0) {
            this.registerChannelProcessingBeans(parserContext, matcher, channelRequestMap);
        }
        this.registerFilterSecurityInterceptor(element, parserContext, matcher, accessManagerId, HttpSecurityBeanDefinitionParser.parseInterceptUrlsForFilterInvocationRequestMap(interceptUrlElts, convertPathsToLowerCase, parserContext));
        boolean sessionControlEnabled = this.registerConcurrentSessionControlBeansIfRequired(element, parserContext);
        this.registerSessionFixationProtectionFilter(parserContext, element.getAttribute(ATT_SESSION_FIXATION_PROTECTION), sessionControlEnabled);
        boolean autoConfig = false;
        if ("true".equals(element.getAttribute(ATT_AUTO_CONFIG))) {
            autoConfig = true;
        }
        if ((anonymousElt = DomUtils.getChildElementByTagName((Element)element, (String)"anonymous")) != null || autoConfig) {
            new AnonymousBeanDefinitionParser().parse(anonymousElt, parserContext);
        }
        this.parseRememberMeAndLogout(element, autoConfig, parserContext);
        this.parseBasicFormLoginAndOpenID(element, parserContext, autoConfig, allowSessionCreation);
        Element x509Elt = DomUtils.getChildElementByTagName((Element)element, (String)"x509");
        if (x509Elt != null) {
            new X509BeanDefinitionParser().parse(x509Elt, parserContext);
        }
        RootBeanDefinition postProcessor = new RootBeanDefinition(class$org$springframework$security$config$EntryPointInjectionBeanPostProcessor == null ? (class$org$springframework$security$config$EntryPointInjectionBeanPostProcessor = HttpSecurityBeanDefinitionParser.class$("org.springframework.security.config.EntryPointInjectionBeanPostProcessor")) : class$org$springframework$security$config$EntryPointInjectionBeanPostProcessor);
        postProcessor.setRole(2);
        registry.registerBeanDefinition("_entryPointInjectionBeanPostProcessor", (BeanDefinition)postProcessor);
        RootBeanDefinition postProcessor2 = new RootBeanDefinition(class$org$springframework$security$config$UserDetailsServiceInjectionBeanPostProcessor == null ? (class$org$springframework$security$config$UserDetailsServiceInjectionBeanPostProcessor = HttpSecurityBeanDefinitionParser.class$("org.springframework.security.config.UserDetailsServiceInjectionBeanPostProcessor")) : class$org$springframework$security$config$UserDetailsServiceInjectionBeanPostProcessor);
        postProcessor2.setRole(2);
        registry.registerBeanDefinition("_userServiceInjectionPostProcessor", (BeanDefinition)postProcessor2);
        return null;
    }

    private void parseRememberMeAndLogout(Element elt, boolean autoConfig, ParserContext pc) {
        Element logoutElt;
        Element rememberMeElt = DomUtils.getChildElementByTagName((Element)elt, (String)"remember-me");
        String rememberMeServices = null;
        if (rememberMeElt != null || autoConfig) {
            RememberMeBeanDefinitionParser rmbdp = new RememberMeBeanDefinitionParser();
            rmbdp.parse(rememberMeElt, pc);
            rememberMeServices = rmbdp.getServicesName();
            RootBeanDefinition rememberMeInjectionPostProcessor = new RootBeanDefinition(class$org$springframework$security$config$RememberMeServicesInjectionBeanPostProcessor == null ? (class$org$springframework$security$config$RememberMeServicesInjectionBeanPostProcessor = HttpSecurityBeanDefinitionParser.class$("org.springframework.security.config.RememberMeServicesInjectionBeanPostProcessor")) : class$org$springframework$security$config$RememberMeServicesInjectionBeanPostProcessor);
            rememberMeInjectionPostProcessor.setRole(2);
            pc.getRegistry().registerBeanDefinition("_rememberMeServicesInjectionBeanPostProcessor", (BeanDefinition)rememberMeInjectionPostProcessor);
        }
        if ((logoutElt = DomUtils.getChildElementByTagName((Element)elt, (String)"logout")) != null || autoConfig) {
            new LogoutBeanDefinitionParser(rememberMeServices).parse(logoutElt, pc);
        }
    }

    private void registerFilterChainProxy(ParserContext pc, Map filterChainMap, UrlMatcher matcher, Object source) {
        if (pc.getRegistry().containsBeanDefinition("_filterChainProxy")) {
            pc.getReaderContext().error("Duplicate <http> element detected", source);
        }
        RootBeanDefinition filterChainProxy = new RootBeanDefinition(class$org$springframework$security$util$FilterChainProxy == null ? (class$org$springframework$security$util$FilterChainProxy = HttpSecurityBeanDefinitionParser.class$("org.springframework.security.util.FilterChainProxy")) : class$org$springframework$security$util$FilterChainProxy);
        filterChainProxy.setSource(source);
        filterChainProxy.getPropertyValues().addPropertyValue("matcher", (Object)matcher);
        filterChainProxy.getPropertyValues().addPropertyValue("stripQueryStringFromUrls", (Object)(matcher instanceof AntUrlPathMatcher));
        filterChainProxy.getPropertyValues().addPropertyValue("filterChainMap", (Object)filterChainMap);
        pc.getRegistry().registerBeanDefinition("_filterChainProxy", (BeanDefinition)filterChainProxy);
        pc.getRegistry().registerAlias("_filterChainProxy", "springSecurityFilterChain");
    }

    private boolean registerHttpSessionIntegrationFilter(Element element, ParserContext pc) {
        RootBeanDefinition httpScif = new RootBeanDefinition(class$org$springframework$security$context$HttpSessionContextIntegrationFilter == null ? (class$org$springframework$security$context$HttpSessionContextIntegrationFilter = HttpSecurityBeanDefinitionParser.class$("org.springframework.security.context.HttpSessionContextIntegrationFilter")) : class$org$springframework$security$context$HttpSessionContextIntegrationFilter);
        boolean sessionCreationAllowed = true;
        String createSession = element.getAttribute(ATT_CREATE_SESSION);
        if (OPT_CREATE_SESSION_ALWAYS.equals(createSession)) {
            httpScif.getPropertyValues().addPropertyValue("allowSessionCreation", (Object)Boolean.TRUE);
            httpScif.getPropertyValues().addPropertyValue("forceEagerSessionCreation", (Object)Boolean.TRUE);
        } else if (OPT_CREATE_SESSION_NEVER.equals(createSession)) {
            httpScif.getPropertyValues().addPropertyValue("allowSessionCreation", (Object)Boolean.FALSE);
            httpScif.getPropertyValues().addPropertyValue("forceEagerSessionCreation", (Object)Boolean.FALSE);
            sessionCreationAllowed = false;
        } else {
            createSession = DEF_CREATE_SESSION_IF_REQUIRED;
            httpScif.getPropertyValues().addPropertyValue("allowSessionCreation", (Object)Boolean.TRUE);
            httpScif.getPropertyValues().addPropertyValue("forceEagerSessionCreation", (Object)Boolean.FALSE);
        }
        pc.getRegistry().registerBeanDefinition("_httpSessionContextIntegrationFilter", (BeanDefinition)httpScif);
        ConfigUtils.addHttpFilter(pc, (BeanMetadataElement)new RuntimeBeanReference("_httpSessionContextIntegrationFilter"));
        return sessionCreationAllowed;
    }

    private void registerServletApiFilter(Element element, ParserContext pc) {
        String provideServletApi = element.getAttribute(ATT_SERVLET_API_PROVISION);
        if (!StringUtils.hasText((String)provideServletApi)) {
            provideServletApi = "true";
        }
        if ("true".equals(provideServletApi)) {
            pc.getRegistry().registerBeanDefinition("_securityContextHolderAwareRequestFilter", (BeanDefinition)new RootBeanDefinition(class$org$springframework$security$wrapper$SecurityContextHolderAwareRequestFilter == null ? (class$org$springframework$security$wrapper$SecurityContextHolderAwareRequestFilter = HttpSecurityBeanDefinitionParser.class$("org.springframework.security.wrapper.SecurityContextHolderAwareRequestFilter")) : class$org$springframework$security$wrapper$SecurityContextHolderAwareRequestFilter));
            ConfigUtils.addHttpFilter(pc, (BeanMetadataElement)new RuntimeBeanReference("_securityContextHolderAwareRequestFilter"));
        }
    }

    private boolean registerConcurrentSessionControlBeansIfRequired(Element element, ParserContext parserContext) {
        Element sessionControlElt = DomUtils.getChildElementByTagName((Element)element, (String)"concurrent-session-control");
        if (sessionControlElt == null) {
            return false;
        }
        new ConcurrentSessionsBeanDefinitionParser().parse(sessionControlElt, parserContext);
        logger.info((Object)"Concurrent session filter in use, setting 'forceEagerSessionCreation' to true");
        BeanDefinition sessionIntegrationFilter = parserContext.getRegistry().getBeanDefinition("_httpSessionContextIntegrationFilter");
        sessionIntegrationFilter.getPropertyValues().addPropertyValue("forceEagerSessionCreation", (Object)Boolean.TRUE);
        return true;
    }

    private void registerExceptionTranslationFilter(Element element, ParserContext pc, boolean allowSessionCreation) {
        String accessDeniedPage = element.getAttribute(ATT_ACCESS_DENIED_PAGE);
        ConfigUtils.validateHttpRedirect(accessDeniedPage, pc, pc.extractSource((Object)element));
        BeanDefinitionBuilder exceptionTranslationFilterBuilder = BeanDefinitionBuilder.rootBeanDefinition((Class)(class$org$springframework$security$ui$ExceptionTranslationFilter == null ? (class$org$springframework$security$ui$ExceptionTranslationFilter = HttpSecurityBeanDefinitionParser.class$("org.springframework.security.ui.ExceptionTranslationFilter")) : class$org$springframework$security$ui$ExceptionTranslationFilter));
        exceptionTranslationFilterBuilder.addPropertyValue("createSessionAllowed", (Object)new Boolean(allowSessionCreation));
        if (StringUtils.hasText((String)accessDeniedPage)) {
            RootBeanDefinition accessDeniedHandler = new RootBeanDefinition(class$org$springframework$security$ui$AccessDeniedHandlerImpl == null ? (class$org$springframework$security$ui$AccessDeniedHandlerImpl = HttpSecurityBeanDefinitionParser.class$("org.springframework.security.ui.AccessDeniedHandlerImpl")) : class$org$springframework$security$ui$AccessDeniedHandlerImpl);
            accessDeniedHandler.getPropertyValues().addPropertyValue("errorPage", (Object)accessDeniedPage);
            exceptionTranslationFilterBuilder.addPropertyValue("accessDeniedHandler", (Object)accessDeniedHandler);
        }
        pc.getRegistry().registerBeanDefinition("_exceptionTranslationFilter", (BeanDefinition)exceptionTranslationFilterBuilder.getBeanDefinition());
        ConfigUtils.addHttpFilter(pc, (BeanMetadataElement)new RuntimeBeanReference("_exceptionTranslationFilter"));
    }

    private void registerFilterSecurityInterceptor(Element element, ParserContext pc, UrlMatcher matcher, String accessManagerId, LinkedHashMap filterInvocationDefinitionMap) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition((Class)(class$org$springframework$security$intercept$web$FilterSecurityInterceptor == null ? (class$org$springframework$security$intercept$web$FilterSecurityInterceptor = HttpSecurityBeanDefinitionParser.class$("org.springframework.security.intercept.web.FilterSecurityInterceptor")) : class$org$springframework$security$intercept$web$FilterSecurityInterceptor));
        builder.addPropertyReference("accessDecisionManager", accessManagerId);
        builder.addPropertyReference("authenticationManager", "_authenticationManager");
        if (DEF_AUTO_CONFIG.equals(element.getAttribute(ATT_ONCE_PER_REQUEST))) {
            builder.addPropertyValue("observeOncePerRequest", (Object)Boolean.FALSE);
        }
        DefaultFilterInvocationDefinitionSource fids = new DefaultFilterInvocationDefinitionSource(matcher, filterInvocationDefinitionMap);
        fids.setStripQueryStringFromUrls(matcher instanceof AntUrlPathMatcher);
        builder.addPropertyValue("objectDefinitionSource", (Object)fids);
        pc.getRegistry().registerBeanDefinition("_filterSecurityInterceptor", (BeanDefinition)builder.getBeanDefinition());
        ConfigUtils.addHttpFilter(pc, (BeanMetadataElement)new RuntimeBeanReference("_filterSecurityInterceptor"));
    }

    private void registerChannelProcessingBeans(ParserContext pc, UrlMatcher matcher, LinkedHashMap channelRequestMap) {
        RootBeanDefinition channelFilter = new RootBeanDefinition(class$org$springframework$security$securechannel$ChannelProcessingFilter == null ? (class$org$springframework$security$securechannel$ChannelProcessingFilter = HttpSecurityBeanDefinitionParser.class$("org.springframework.security.securechannel.ChannelProcessingFilter")) : class$org$springframework$security$securechannel$ChannelProcessingFilter);
        channelFilter.getPropertyValues().addPropertyValue("channelDecisionManager", (Object)new RuntimeBeanReference("_channelDecisionManager"));
        DefaultFilterInvocationDefinitionSource channelFilterInvDefSource = new DefaultFilterInvocationDefinitionSource(matcher, channelRequestMap);
        channelFilterInvDefSource.setStripQueryStringFromUrls(matcher instanceof AntUrlPathMatcher);
        channelFilter.getPropertyValues().addPropertyValue("filterInvocationDefinitionSource", (Object)channelFilterInvDefSource);
        RootBeanDefinition channelDecisionManager = new RootBeanDefinition(class$org$springframework$security$securechannel$ChannelDecisionManagerImpl == null ? (class$org$springframework$security$securechannel$ChannelDecisionManagerImpl = HttpSecurityBeanDefinitionParser.class$("org.springframework.security.securechannel.ChannelDecisionManagerImpl")) : class$org$springframework$security$securechannel$ChannelDecisionManagerImpl);
        ManagedList channelProcessors = new ManagedList(3);
        RootBeanDefinition secureChannelProcessor = new RootBeanDefinition(class$org$springframework$security$securechannel$SecureChannelProcessor == null ? (class$org$springframework$security$securechannel$SecureChannelProcessor = HttpSecurityBeanDefinitionParser.class$("org.springframework.security.securechannel.SecureChannelProcessor")) : class$org$springframework$security$securechannel$SecureChannelProcessor);
        RootBeanDefinition retryWithHttp = new RootBeanDefinition(class$org$springframework$security$securechannel$RetryWithHttpEntryPoint == null ? (class$org$springframework$security$securechannel$RetryWithHttpEntryPoint = HttpSecurityBeanDefinitionParser.class$("org.springframework.security.securechannel.RetryWithHttpEntryPoint")) : class$org$springframework$security$securechannel$RetryWithHttpEntryPoint);
        RootBeanDefinition retryWithHttps = new RootBeanDefinition(class$org$springframework$security$securechannel$RetryWithHttpsEntryPoint == null ? (class$org$springframework$security$securechannel$RetryWithHttpsEntryPoint = HttpSecurityBeanDefinitionParser.class$("org.springframework.security.securechannel.RetryWithHttpsEntryPoint")) : class$org$springframework$security$securechannel$RetryWithHttpsEntryPoint);
        RuntimeBeanReference portMapper = new RuntimeBeanReference("_portMapper");
        retryWithHttp.getPropertyValues().addPropertyValue("portMapper", (Object)portMapper);
        retryWithHttps.getPropertyValues().addPropertyValue("portMapper", (Object)portMapper);
        secureChannelProcessor.getPropertyValues().addPropertyValue("entryPoint", (Object)retryWithHttps);
        RootBeanDefinition inSecureChannelProcessor = new RootBeanDefinition(class$org$springframework$security$securechannel$InsecureChannelProcessor == null ? (class$org$springframework$security$securechannel$InsecureChannelProcessor = HttpSecurityBeanDefinitionParser.class$("org.springframework.security.securechannel.InsecureChannelProcessor")) : class$org$springframework$security$securechannel$InsecureChannelProcessor);
        inSecureChannelProcessor.getPropertyValues().addPropertyValue("entryPoint", (Object)retryWithHttp);
        channelProcessors.add(secureChannelProcessor);
        channelProcessors.add(inSecureChannelProcessor);
        channelDecisionManager.getPropertyValues().addPropertyValue("channelProcessors", (Object)channelProcessors);
        pc.getRegistry().registerBeanDefinition("_channelProcessingFilter", (BeanDefinition)channelFilter);
        ConfigUtils.addHttpFilter(pc, (BeanMetadataElement)new RuntimeBeanReference("_channelProcessingFilter"));
        pc.getRegistry().registerBeanDefinition("_channelDecisionManager", (BeanDefinition)channelDecisionManager);
    }

    private void registerSessionFixationProtectionFilter(ParserContext pc, String sessionFixationAttribute, boolean sessionControlEnabled) {
        if (!StringUtils.hasText((String)sessionFixationAttribute)) {
            sessionFixationAttribute = OPT_SESSION_FIXATION_MIGRATE_SESSION;
        }
        if (!sessionFixationAttribute.equals("none")) {
            BeanDefinitionBuilder sessionFixationFilter = BeanDefinitionBuilder.rootBeanDefinition((Class)(class$org$springframework$security$ui$SessionFixationProtectionFilter == null ? (class$org$springframework$security$ui$SessionFixationProtectionFilter = HttpSecurityBeanDefinitionParser.class$("org.springframework.security.ui.SessionFixationProtectionFilter")) : class$org$springframework$security$ui$SessionFixationProtectionFilter));
            sessionFixationFilter.addPropertyValue("migrateSessionAttributes", (Object)sessionFixationAttribute.equals(OPT_SESSION_FIXATION_MIGRATE_SESSION));
            if (sessionControlEnabled) {
                sessionFixationFilter.addPropertyReference("sessionRegistry", "_sessionRegistry");
            }
            pc.getRegistry().registerBeanDefinition("_sessionFixationProtectionFilter", (BeanDefinition)sessionFixationFilter.getBeanDefinition());
            ConfigUtils.addHttpFilter(pc, (BeanMetadataElement)new RuntimeBeanReference("_sessionFixationProtectionFilter"));
        }
    }

    private void parseBasicFormLoginAndOpenID(Element element, ParserContext pc, boolean autoConfig, boolean allowSessionCreation) {
        String customEntryPoint;
        Element openIDLoginElt;
        Element formLoginElt;
        Element basicAuthElt;
        RootBeanDefinition formLoginFilter = null;
        RootBeanDefinition formLoginEntryPoint = null;
        String formLoginPage = null;
        RootBeanDefinition openIDFilter = null;
        RootBeanDefinition openIDEntryPoint = null;
        String openIDLoginPage = null;
        String realm = element.getAttribute(ATT_REALM);
        if (!StringUtils.hasText((String)realm)) {
            realm = DEF_REALM;
        }
        if ((basicAuthElt = DomUtils.getChildElementByTagName((Element)element, (String)"http-basic")) != null || autoConfig) {
            new BasicAuthenticationBeanDefinitionParser(realm).parse(basicAuthElt, pc);
        }
        if ((formLoginElt = DomUtils.getChildElementByTagName((Element)element, (String)"form-login")) != null || autoConfig) {
            FormLoginBeanDefinitionParser parser = new FormLoginBeanDefinitionParser("/j_spring_security_check", "org.springframework.security.ui.webapp.AuthenticationProcessingFilter");
            parser.parse(formLoginElt, pc);
            formLoginFilter = parser.getFilterBean();
            formLoginEntryPoint = parser.getEntryPointBean();
            formLoginPage = parser.getLoginPage();
        }
        if ((openIDLoginElt = DomUtils.getChildElementByTagName((Element)element, (String)"openid-login")) != null) {
            FormLoginBeanDefinitionParser parser = new FormLoginBeanDefinitionParser("/j_spring_openid_security_check", "org.springframework.security.ui.openid.OpenIDAuthenticationProcessingFilter");
            parser.parse(openIDLoginElt, pc);
            openIDFilter = parser.getFilterBean();
            openIDEntryPoint = parser.getEntryPointBean();
            openIDLoginPage = parser.getLoginPage();
            BeanDefinitionBuilder openIDProviderBuilder = BeanDefinitionBuilder.rootBeanDefinition((String)"org.springframework.security.providers.openid.OpenIDAuthenticationProvider");
            String userService = openIDLoginElt.getAttribute(ATT_USER_SERVICE_REF);
            if (StringUtils.hasText((String)userService)) {
                openIDProviderBuilder.addPropertyReference("userDetailsService", userService);
            }
            AbstractBeanDefinition openIDProvider = openIDProviderBuilder.getBeanDefinition();
            pc.getRegistry().registerBeanDefinition("_openIDAuthenticationProvider", (BeanDefinition)openIDProvider);
            ConfigUtils.addAuthenticationProvider(pc, "_openIDAuthenticationProvider");
        }
        boolean needLoginPage = false;
        if (formLoginFilter != null) {
            needLoginPage = true;
            formLoginFilter.getPropertyValues().addPropertyValue("allowSessionCreation", (Object)new Boolean(allowSessionCreation));
            pc.getRegistry().registerBeanDefinition("_formLoginFilter", (BeanDefinition)formLoginFilter);
            ConfigUtils.addHttpFilter(pc, (BeanMetadataElement)new RuntimeBeanReference("_formLoginFilter"));
            pc.getRegistry().registerBeanDefinition("_formLoginEntryPoint", (BeanDefinition)formLoginEntryPoint);
        }
        if (openIDFilter != null) {
            needLoginPage = true;
            openIDFilter.getPropertyValues().addPropertyValue("allowSessionCreation", (Object)new Boolean(allowSessionCreation));
            pc.getRegistry().registerBeanDefinition("_openIDFilter", (BeanDefinition)openIDFilter);
            ConfigUtils.addHttpFilter(pc, (BeanMetadataElement)new RuntimeBeanReference("_openIDFilter"));
            pc.getRegistry().registerBeanDefinition("_openIDFilterEntryPoint", (BeanDefinition)openIDEntryPoint);
        }
        if (needLoginPage && formLoginPage == null && openIDLoginPage == null) {
            logger.info((Object)"No login page configured. The default internal one will be used. Use the 'login-page' attribute to set the URL of the login page.");
            BeanDefinitionBuilder loginPageFilter = BeanDefinitionBuilder.rootBeanDefinition((Class)(class$org$springframework$security$ui$webapp$DefaultLoginPageGeneratingFilter == null ? (class$org$springframework$security$ui$webapp$DefaultLoginPageGeneratingFilter = HttpSecurityBeanDefinitionParser.class$("org.springframework.security.ui.webapp.DefaultLoginPageGeneratingFilter")) : class$org$springframework$security$ui$webapp$DefaultLoginPageGeneratingFilter));
            if (formLoginFilter != null) {
                loginPageFilter.addConstructorArg((Object)new RuntimeBeanReference("_formLoginFilter"));
            }
            if (openIDFilter != null) {
                loginPageFilter.addConstructorArg((Object)new RuntimeBeanReference("_openIDFilter"));
            }
            pc.getRegistry().registerBeanDefinition("_defaultLoginPageFilter", (BeanDefinition)loginPageFilter.getBeanDefinition());
            ConfigUtils.addHttpFilter(pc, (BeanMetadataElement)new RuntimeBeanReference("_defaultLoginPageFilter"));
        }
        if (StringUtils.hasText((String)(customEntryPoint = element.getAttribute(ATT_ENTRY_POINT_REF)))) {
            pc.getRegistry().registerAlias(customEntryPoint, "_mainEntryPoint");
            return;
        }
        if (basicAuthElt != null && formLoginElt == null && openIDLoginElt == null) {
            pc.getRegistry().registerAlias("_basicAuthenticationEntryPoint", "_mainEntryPoint");
            return;
        }
        if (formLoginFilter != null && openIDLoginPage == null) {
            pc.getRegistry().registerAlias("_formLoginEntryPoint", "_mainEntryPoint");
            return;
        }
        if (openIDFilter != null && formLoginFilter == null) {
            pc.getRegistry().registerAlias("_openIDFilterEntryPoint", "_mainEntryPoint");
            return;
        }
        if (DomUtils.getChildElementByTagName((Element)element, (String)"x509") != null) {
            pc.getRegistry().registerAlias("_preAuthenticatedProcessingFilterEntryPoint", "_mainEntryPoint");
            return;
        }
        pc.getReaderContext().error("No AuthenticationEntryPoint could be established. Please make sure you have a login mechanism configured through the namespace (such as form-login) or specify a custom AuthenticationEntryPoint with the custom-entry-point-ref attribute ", pc.extractSource((Object)element));
    }

    static UrlMatcher createUrlMatcher(Element element) {
        String lowercaseComparisons;
        String patternType = element.getAttribute(ATT_PATH_TYPE);
        if (!StringUtils.hasText((String)patternType)) {
            patternType = DEF_PATH_TYPE_ANT;
        }
        boolean useRegex = patternType.equals(OPT_PATH_TYPE_REGEX);
        UrlMatcher matcher = new AntUrlPathMatcher();
        if (useRegex) {
            matcher = new RegexUrlPathMatcher();
        }
        if (!StringUtils.hasText((String)(lowercaseComparisons = element.getAttribute(ATT_LOWERCASE_COMPARISONS)))) {
            lowercaseComparisons = null;
        }
        if ("true".equals(lowercaseComparisons)) {
            if (useRegex) {
                ((RegexUrlPathMatcher)matcher).setRequiresLowerCaseUrl(true);
            }
        } else if (DEF_AUTO_CONFIG.equals(lowercaseComparisons) && !useRegex) {
            ((AntUrlPathMatcher)matcher).setRequiresLowerCaseUrl(false);
        }
        return matcher;
    }

    void parseInterceptUrlsForChannelSecurityAndFilterChain(List urlElts, Map filterChainMap, Map channelRequestMap, boolean useLowerCasePaths, ParserContext parserContext) {
        Iterator urlEltsIterator = urlElts.iterator();
        ConfigAttributeEditor editor = new ConfigAttributeEditor();
        while (urlEltsIterator.hasNext()) {
            String filters;
            String requiredChannel;
            Element urlElt = (Element)urlEltsIterator.next();
            String path = urlElt.getAttribute(ATT_PATH_PATTERN);
            if (!StringUtils.hasText((String)path)) {
                parserContext.getReaderContext().error("path attribute cannot be empty or null", (Object)urlElt);
            }
            if (useLowerCasePaths) {
                path = path.toLowerCase();
            }
            if (StringUtils.hasText((String)(requiredChannel = urlElt.getAttribute(ATT_REQUIRES_CHANNEL)))) {
                String channelConfigAttribute = null;
                if (requiredChannel.equals(OPT_REQUIRES_HTTPS)) {
                    channelConfigAttribute = "REQUIRES_SECURE_CHANNEL";
                } else if (requiredChannel.equals(OPT_REQUIRES_HTTP)) {
                    channelConfigAttribute = "REQUIRES_INSECURE_CHANNEL";
                } else if (requiredChannel.equals(OPT_ANY_CHANNEL)) {
                    channelConfigAttribute = "ANY_CHANNEL";
                } else {
                    parserContext.getReaderContext().error("Unsupported channel " + requiredChannel, (Object)urlElt);
                }
                editor.setAsText(channelConfigAttribute);
                channelRequestMap.put(new RequestKey(path), (ConfigAttributeDefinition)editor.getValue());
            }
            if (!StringUtils.hasText((String)(filters = urlElt.getAttribute(ATT_FILTERS)))) continue;
            if (!filters.equals("none")) {
                parserContext.getReaderContext().error("Currently only 'none' is supported as the custom filters attribute", (Object)urlElt);
            }
            filterChainMap.put(path, Collections.EMPTY_LIST);
        }
    }

    static LinkedHashMap parseInterceptUrlsForFilterInvocationRequestMap(List urlElts, boolean useLowerCasePaths, ParserContext parserContext) {
        LinkedHashMap<RequestKey, Object> filterInvocationDefinitionMap = new LinkedHashMap<RequestKey, Object>();
        Iterator urlEltsIterator = urlElts.iterator();
        ConfigAttributeEditor editor = new ConfigAttributeEditor();
        while (urlEltsIterator.hasNext()) {
            String access;
            String method;
            Element urlElt = (Element)urlEltsIterator.next();
            String path = urlElt.getAttribute(ATT_PATH_PATTERN);
            if (!StringUtils.hasText((String)path)) {
                parserContext.getReaderContext().error("path attribute cannot be empty or null", (Object)urlElt);
            }
            if (useLowerCasePaths) {
                path = path.toLowerCase();
            }
            if (!StringUtils.hasText((String)(method = urlElt.getAttribute(ATT_HTTP_METHOD)))) {
                method = null;
            }
            if (!StringUtils.hasText((String)(access = urlElt.getAttribute(ATT_ACCESS_CONFIG)))) continue;
            editor.setAsText(access);
            RequestKey key = new RequestKey(path, method);
            if (filterInvocationDefinitionMap.containsKey(key)) {
                logger.warn((Object)("Duplicate URL defined: " + key + ". The original attribute values will be overwritten"));
            }
            filterInvocationDefinitionMap.put(key, editor.getValue());
        }
        return filterInvocationDefinitionMap;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

