/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.http;

import java.util.List;
import java.util.Map;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Counter;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.shared.SharedObjectInterface;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.http.HTTP;
import org.pentaho.di.trans.steps.http.HTTPData;
import org.pentaho.di.trans.steps.http.Messages;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTTPMeta
extends BaseStepMeta
implements StepMetaInterface {
    private String url;
    private String[] argumentField;
    private String[] argumentParameter;
    private String fieldName;
    private boolean urlInField;
    private String urlField;

    public String[] getArgumentField() {
        return this.argumentField;
    }

    public void setArgumentField(String[] argument) {
        this.argumentField = argument;
    }

    public String[] getArgumentParameter() {
        return this.argumentParameter;
    }

    public void setArgumentParameter(String[] argumentDirection) {
        this.argumentParameter = argumentDirection;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String procedure) {
        this.url = procedure;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String resultName) {
        this.fieldName = resultName;
    }

    public boolean isUrlInField() {
        return this.urlInField;
    }

    public void setUrlInField(boolean urlInField) {
        this.urlInField = urlInField;
    }

    public String getUrlField() {
        return this.urlField;
    }

    public void setUrlField(String urlField) {
        this.urlField = urlField;
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleXMLException {
        this.readData(stepnode, databases);
    }

    public void allocate(int nrargs) {
        this.argumentField = new String[nrargs];
        this.argumentParameter = new String[nrargs];
    }

    @Override
    public Object clone() {
        HTTPMeta retval = (HTTPMeta)super.clone();
        int nrargs = this.argumentField.length;
        retval.allocate(nrargs);
        for (int i = 0; i < nrargs; ++i) {
            retval.argumentField[i] = this.argumentField[i];
            retval.argumentParameter[i] = this.argumentParameter[i];
        }
        return retval;
    }

    @Override
    public void setDefault() {
        int nrargs = 0;
        this.allocate(nrargs);
        for (int i = 0; i < nrargs; ++i) {
            this.argumentField[i] = "arg" + i;
            this.argumentParameter[i] = "arg";
        }
        this.fieldName = "result";
    }

    @Override
    public void getFields(RowMetaInterface inputRowMeta, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space) throws KettleStepException {
        if (!Const.isEmpty((String)this.fieldName)) {
            ValueMeta v = new ValueMeta(this.fieldName, 2);
            inputRowMeta.addValueMeta((ValueMetaInterface)v);
        }
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(300);
        retval.append("    ").append(XMLHandler.addTagValue((String)"url", (String)this.url));
        retval.append("    " + XMLHandler.addTagValue((String)"urlInField", (boolean)this.urlInField));
        retval.append("    " + XMLHandler.addTagValue((String)"urlField", (String)this.urlField));
        retval.append("    <lookup>").append(Const.CR);
        for (int i = 0; i < this.argumentField.length; ++i) {
            retval.append("      <arg>").append(Const.CR);
            retval.append("        ").append(XMLHandler.addTagValue((String)"name", (String)this.argumentField[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"parameter", (String)this.argumentParameter[i]));
            retval.append("      </arg>").append(Const.CR);
        }
        retval.append("    </lookup>").append(Const.CR);
        retval.append("    <result>").append(Const.CR);
        retval.append("      ").append(XMLHandler.addTagValue((String)"name", (String)this.fieldName));
        retval.append("    </result>").append(Const.CR);
        return retval.toString();
    }

    private void readData(Node stepnode, List<? extends SharedObjectInterface> databases) throws KettleXMLException {
        try {
            this.url = XMLHandler.getTagValue((Node)stepnode, (String)"url");
            this.urlInField = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"urlInField"));
            this.urlField = XMLHandler.getTagValue((Node)stepnode, (String)"urlField");
            Node lookup = XMLHandler.getSubNode((Node)stepnode, (String)"lookup");
            int nrargs = XMLHandler.countNodes((Node)lookup, (String)"arg");
            this.allocate(nrargs);
            for (int i = 0; i < nrargs; ++i) {
                Node anode = XMLHandler.getSubNodeByNr((Node)lookup, (String)"arg", (int)i);
                this.argumentField[i] = XMLHandler.getTagValue((Node)anode, (String)"name");
                this.argumentParameter[i] = XMLHandler.getTagValue((Node)anode, (String)"parameter");
            }
            this.fieldName = XMLHandler.getTagValue((Node)stepnode, (String)"result", (String)"name");
        }
        catch (Exception e) {
            throw new KettleXMLException(Messages.getString("HTTPMeta.Exception.UnableToReadStepInfo"), (Throwable)e);
        }
    }

    @Override
    public void readRep(Repository rep, long id_step, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleException {
        try {
            this.url = rep.getStepAttributeString(id_step, "url");
            this.urlInField = rep.getStepAttributeBoolean(id_step, "urlInField");
            this.urlField = rep.getStepAttributeString(id_step, "urlField");
            int nrargs = rep.countNrStepAttributes(id_step, "arg_name");
            this.allocate(nrargs);
            for (int i = 0; i < nrargs; ++i) {
                this.argumentField[i] = rep.getStepAttributeString(id_step, i, "arg_name");
                this.argumentParameter[i] = rep.getStepAttributeString(id_step, i, "arg_parameter");
            }
            this.fieldName = rep.getStepAttributeString(id_step, "result_name");
        }
        catch (Exception e) {
            throw new KettleException(Messages.getString("HTTPMeta.Exception.UnexpectedErrorReadingStepInfo"), (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, long id_transformation, long id_step) throws KettleException {
        try {
            rep.saveStepAttribute(id_transformation, id_step, "url", this.url);
            rep.saveStepAttribute(id_transformation, id_step, "urlInField", this.urlInField);
            rep.saveStepAttribute(id_transformation, id_step, "urlField", this.urlField);
            for (int i = 0; i < this.argumentField.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "arg_name", this.argumentField[i]);
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "arg_parameter", this.argumentParameter[i]);
            }
            rep.saveStepAttribute(id_transformation, id_step, "result_name", this.fieldName);
        }
        catch (Exception e) {
            throw new KettleException(Messages.getString("HTTPMeta.Exception.UnableToSaveStepInfo") + id_step, (Throwable)e);
        }
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info) {
        CheckResult cr;
        if (input.length > 0) {
            cr = new CheckResult(1, Messages.getString("HTTPMeta.CheckResult.ReceivingInfoFromOtherSteps"), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, Messages.getString("HTTPMeta.CheckResult.NoInpuReceived"), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        cr = this.urlInField ? (Const.isEmpty((String)this.urlField) ? new CheckResult(4, Messages.getString("HTTPMeta.CheckResult.UrlfieldMissing"), (CheckResultSourceInterface)stepMeta) : new CheckResult(4, Messages.getString("HTTPMeta.CheckResult.UrlfieldOk"), (CheckResultSourceInterface)stepMeta)) : (Const.isEmpty((String)this.url) ? new CheckResult(4, Messages.getString("HTTPMeta.CheckResult.UrlMissing"), (CheckResultSourceInterface)stepMeta) : new CheckResult(1, Messages.getString("HTTPMeta.CheckResult.UrlOk"), (CheckResultSourceInterface)stepMeta));
        remarks.add((CheckResultInterface)cr);
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new HTTP(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new HTTPData();
    }

    @Override
    public boolean supportsErrorHandling() {
        return true;
    }
}

