/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.step;

import org.pentaho.di.core.Const;
import org.pentaho.di.core.logging.LogWriter;
import org.pentaho.di.trans.Messages;
import org.pentaho.di.trans.step.StepMetaDataCombi;

public class StepInitThread
implements Runnable {
    public boolean ok;
    public boolean finished;
    private StepMetaDataCombi combi;
    private LogWriter log;

    public StepInitThread(StepMetaDataCombi combi, LogWriter log) {
        this.combi = combi;
        this.log = log;
        this.ok = false;
        this.finished = false;
    }

    public String toString() {
        return this.combi.stepname;
    }

    public void run() {
        try {
            if (this.combi.step.init(this.combi.meta, this.combi.data)) {
                this.combi.data.setStatus(3);
                this.ok = true;
            } else {
                this.combi.step.setErrors(1L);
                this.log.logError(this.toString(), Messages.getString("Trans.Log.ErrorInitializingStep", this.combi.step.getStepname()), new Object[0]);
            }
        }
        catch (Throwable e) {
            this.log.logError(this.toString(), Messages.getString("Trans.Log.ErrorInitializingStep", this.combi.step.getStepname()), new Object[0]);
            this.log.logError(this.toString(), Const.getStackTracker((Throwable)e), new Object[0]);
        }
        this.finished = true;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public boolean isOk() {
        return this.ok;
    }

    public StepMetaDataCombi getCombi() {
        return this.combi;
    }

    public void setCombi(StepMetaDataCombi combi) {
        this.combi = combi;
    }
}

