"use strict";
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spread = (this && this.__spread) || function () {
    for (var ar = [], i = 0; i < arguments.length; i++) ar = ar.concat(__read(arguments[i]));
    return ar;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var d3_array_1 = require("d3-array");
var d3_interpolate_1 = require("d3-interpolate");
var d3_scale_1 = require("d3-scale");
var re_reselect_1 = __importDefault(require("re-reselect"));
var constants_1 = require("../../../../scales/constants");
var get_chart_id_1 = require("../../../../state/selectors/get_chart_id");
var get_heatmap_spec_1 = require("./get_heatmap_spec");
var get_heatmap_table_1 = require("./get_heatmap_table");
exports.getColorScale = re_reselect_1.default([get_heatmap_spec_1.getHeatmapSpecSelector, get_heatmap_table_1.getHeatmapTableSelector], function (spec, heatmapTable) {
    var colors = spec.colors, colorScaleSpec = spec.colorScale;
    var _a = spec.ranges, ranges = _a === void 0 ? heatmapTable.extent : _a;
    var colorRange = (colors !== null && colors !== void 0 ? colors : ['green', 'red']);
    var colorScale = {
        type: colorScaleSpec,
    };
    if (colorScale.type === constants_1.ScaleType.Quantize) {
        colorScale.config = d3_scale_1.scaleQuantize()
            .domain(d3_array_1.extent(ranges))
            .range(colorRange);
        colorScale.ticks = colorScale.config.ticks(spec.colors.length);
    }
    else if (colorScale.type === constants_1.ScaleType.Quantile) {
        colorScale.config = d3_scale_1.scaleQuantile()
            .domain(ranges)
            .range(colorRange);
        colorScale.ticks = colorScale.config.quantiles();
    }
    else if (colorScale.type === constants_1.ScaleType.Threshold) {
        colorScale.config = d3_scale_1.scaleThreshold()
            .domain(ranges)
            .range(colorRange);
        colorScale.ticks = colorScale.config.domain();
    }
    else {
        colorScale.config = d3_scale_1.scaleLinear()
            .domain(ranges)
            .interpolate(d3_interpolate_1.interpolateHcl)
            .range(colorRange);
        colorScale.ticks = addBaselineOnLinearScale(ranges[0], ranges[1], colorScale.config.ticks(6));
    }
    return colorScale;
})(get_chart_id_1.getChartIdSelector);
function addBaselineOnLinearScale(min, max, ticks) {
    if (min < 0 && max < 0) {
        return __spread(ticks, [0]);
    }
    if (min >= 0 && max >= 0) {
        return __spread([0], ticks);
    }
    return ticks;
}
//# sourceMappingURL=get_color_scale.js.map