# -*- coding: utf-8 -*-
# Copyright 2021 Red Hat
# GNU General Public License v3.0+
# (see COPYING or https://www.gnu.org/licenses/gpl-3.0.txt)

from __future__ import absolute_import, division, print_function

__metaclass__ = type

#############################################
#                WARNING                    #
#############################################
#
# This file is auto generated by the
# cli_rm_builder.
#
# Manually editing this file is not advised.
#
# To update the argspec make the desired changes
# in the module docstring and re-run
# cli_rm_builder.
#
#############################################

"""
The arg spec for the nxos_ntp_global module
"""


class Ntp_globalArgs(object):  # pylint: disable=R0903
    """The arg spec for the nxos_ntp_global module
    """

    argument_spec = {
        "running_config": {"type": "str"},
        "config": {
            "type": "dict",
            "options": {
                "access_group": {
                    "type": "dict",
                    "options": {
                        "match_all": {"type": "bool"},
                        "peer": {
                            "type": "list",
                            "elements": "dict",
                            "options": {"access_list": {"type": "str"}},
                        },
                        "query_only": {
                            "type": "list",
                            "elements": "dict",
                            "options": {"access_list": {"type": "str"}},
                        },
                        "serve": {
                            "type": "list",
                            "elements": "dict",
                            "options": {"access_list": {"type": "str"}},
                        },
                        "serve_only": {
                            "type": "list",
                            "elements": "dict",
                            "options": {"access_list": {"type": "str"}},
                        },
                    },
                },
                "allow": {
                    "type": "dict",
                    "options": {
                        "control": {
                            "type": "dict",
                            "options": {"rate_limit": {"type": "int"}},
                        },
                        "private": {"type": "bool"},
                    },
                },
                "authenticate": {"type": "bool"},
                "authentication_keys": {
                    "type": "list",
                    "elements": "dict",
                    "no_log": False,
                    "options": {
                        "id": {"type": "int"},
                        "key": {"type": "str", "no_log": True},
                        "encryption": {"type": "int"},
                    },
                },
                "logging": {"type": "bool"},
                "master": {
                    "type": "dict",
                    "options": {"stratum": {"type": "int"}},
                },
                "passive": {"type": "bool"},
                "peers": {
                    "type": "list",
                    "elements": "dict",
                    "options": {
                        "peer": {"type": "str"},
                        "key_id": {"type": "int"},
                        "maxpoll": {"type": "int"},
                        "minpoll": {"type": "int"},
                        "prefer": {"type": "bool"},
                        "use_vrf": {"type": "str"},
                    },
                },
                "servers": {
                    "type": "list",
                    "elements": "dict",
                    "options": {
                        "server": {"type": "str"},
                        "key_id": {"type": "int"},
                        "maxpoll": {"type": "int"},
                        "minpoll": {"type": "int"},
                        "prefer": {"type": "bool"},
                        "use_vrf": {"type": "str"},
                    },
                },
                "source": {"type": "str"},
                "source_interface": {"type": "str"},
                "trusted_keys": {
                    "type": "list",
                    "elements": "dict",
                    "no_log": False,
                    "options": {"key_id": {"type": "int"}},
                },
            },
        },
        "state": {
            "type": "str",
            "choices": [
                "merged",
                "replaced",
                "overridden",
                "deleted",
                "parsed",
                "gathered",
                "rendered",
            ],
            "default": "merged",
        },
    }  # pylint: disable=C0301
