/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.serializer;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.protocol.message.NewSessionTicketMessage;
import de.rub.nds.tlsattacker.core.protocol.serializer.HandshakeMessageSerializer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NewSessionTicketSerializer
extends HandshakeMessageSerializer<NewSessionTicketMessage> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final NewSessionTicketMessage msg;

    public NewSessionTicketSerializer(NewSessionTicketMessage message, ProtocolVersion version) {
        super(message, version);
        this.msg = message;
    }

    @Override
    public byte[] serializeHandshakeMessageContent() {
        LOGGER.debug("Serializing NewSessionTicketMessage");
        this.writeLifetimeHint(this.msg);
        if (!this.version.isTLS13()) {
            throw new UnsupportedOperationException("NewSessionTicket message is currently not supported for not TLS 1.3");
        }
        this.writeTicketAgeAdd(this.msg);
        this.writeTicketNonceLength(this.msg);
        this.writeTicketNonce(this.msg);
        this.writeTicketIdentityLength(this.msg);
        this.writeTicketIdentity(this.msg);
        this.writeExtensions();
        return this.getAlreadySerialized();
    }

    private void writeLifetimeHint(NewSessionTicketMessage msg) {
        this.appendBytes(ArrayConverter.longToBytes((long)((Long)msg.getTicketLifetimeHint().getValue()), (int)4));
        LOGGER.debug("LifetimeHint: " + ArrayConverter.bytesToHexString((byte[])ArrayConverter.longToBytes((long)((Long)msg.getTicketLifetimeHint().getValue()), (int)4)));
    }

    private void writeTicketLength(NewSessionTicketMessage msg) {
        this.appendBytes(ArrayConverter.intToBytes((int)((Integer)msg.getTicketLength().getValue()), (int)2));
        LOGGER.debug("TicketLength: " + ArrayConverter.bytesToHexString((byte[])ArrayConverter.intToBytes((int)((Integer)msg.getTicketLength().getValue()), (int)2)));
    }

    private void writeTicket(NewSessionTicketMessage msg) {
        this.appendBytes((byte[])msg.getTicket().getKeyName().getValue());
        LOGGER.debug("Keyname: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getTicket().getKeyName().getValue())));
        this.appendBytes((byte[])msg.getTicket().getIV().getValue());
        LOGGER.debug("IV: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getTicket().getIV().getValue())));
        this.appendBytes((byte[])msg.getTicket().getEncryptedState().getValue());
        LOGGER.debug("EncryptedState: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getTicket().getEncryptedState().getValue())));
        this.appendBytes((byte[])msg.getTicket().getMAC().getValue());
        LOGGER.debug("MAC: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getTicket().getMAC().getValue())));
    }

    private void writeTicketAgeAdd(NewSessionTicketMessage msg) {
        this.appendBytes((byte[])msg.getTicket().getTicketAgeAdd().getValue());
        LOGGER.debug("TicketAgeAdd: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getTicket().getTicketAgeAdd().getValue())));
    }

    private void writeTicketNonceLength(NewSessionTicketMessage msg) {
        this.appendBytes(ArrayConverter.intToBytes((int)((Integer)msg.getTicket().getTicketNonceLength().getValue()), (int)1));
        LOGGER.debug("TicketNonceLength: " + msg.getTicket().getTicketNonceLength().getValue());
    }

    private void writeTicketNonce(NewSessionTicketMessage msg) {
        this.appendBytes((byte[])msg.getTicket().getTicketNonce().getValue());
        LOGGER.debug("TicketNonce: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getTicket().getTicketNonce().getValue())));
    }

    private void writeTicketIdentityLength(NewSessionTicketMessage msg) {
        this.appendBytes(ArrayConverter.intToBytes((int)((Integer)msg.getTicket().getIdentityLength().getValue()), (int)2));
        LOGGER.debug("TicketIdentityLength: " + msg.getTicket().getIdentityLength().getValue());
    }

    private void writeTicketIdentity(NewSessionTicketMessage msg) {
        this.appendBytes((byte[])msg.getTicket().getIdentity().getValue());
        LOGGER.debug("TicketIdentity: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getTicket().getIdentity().getValue())));
    }

    private void writeExtensions() {
        if (this.hasExtensionLengthField()) {
            this.writeExtensionLength();
            if (this.hasExtensions()) {
                this.writeExtensionBytes();
            }
        }
    }
}

