/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.propertysheet;

import java.awt.Toolkit;
import java.beans.FeatureDescriptor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JTextField;
import org.openide.explorer.propertysheet.CheckboxInplaceEditor;
import org.openide.explorer.propertysheet.ComboInplaceEditor;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.InplaceEditor;
import org.openide.explorer.propertysheet.NodePropertyModel;
import org.openide.explorer.propertysheet.PropUtils;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.explorer.propertysheet.RadioInplaceEditor;
import org.openide.explorer.propertysheet.ReusablePropertyEnv;
import org.openide.explorer.propertysheet.StringInplaceEditor;
import org.openide.explorer.propertysheet.WrapperInplaceEditor;
import org.openide.explorer.propertysheet.editors.EnhancedPropertyEditor;
import org.openide.nodes.Node;
import org.openide.util.WeakListeners;

final class InplaceEditorFactory {
    private InplaceEditor checkbox = null;
    private InplaceEditor text = null;
    private InplaceEditor combo = null;
    private InplaceEditor radio = null;
    private ReusablePropertyEnv reusableEnv;
    private boolean tableUI;
    int radioButtonMax = -1;
    private boolean useLabels = false;
    private boolean useRadioBoolean = PropUtils.forceRadioButtons;

    InplaceEditorFactory(boolean bl, ReusablePropertyEnv reusablePropertyEnv) {
        this.tableUI = bl;
        this.reusableEnv = reusablePropertyEnv;
        PropertyChangeListener propertyChangeListener = WeakListeners.propertyChange((PropertyChangeListener)new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                InplaceEditorFactory.this.checkbox = null;
                InplaceEditorFactory.this.text = null;
                InplaceEditorFactory.this.combo = null;
                InplaceEditorFactory.this.radio = null;
            }
        }, (Object)Toolkit.getDefaultToolkit());
        Toolkit.getDefaultToolkit().addPropertyChangeListener("win.xpstyle.themeActive", propertyChangeListener);
    }

    void setRadioButtonMax(int n) {
        this.radioButtonMax = n;
    }

    void setUseLabels(boolean bl) {
        this.useLabels = bl;
    }

    void setUseRadioBoolean(boolean bl) {
        this.useRadioBoolean = bl;
    }

    private InplaceEditor getRadioEditor(boolean bl) {
        RadioInplaceEditor radioInplaceEditor;
        if (bl) {
            radioInplaceEditor = new RadioInplaceEditor(this.tableUI);
        } else {
            if (this.radio == null) {
                this.radio = new RadioInplaceEditor(this.tableUI);
                ((JComponent)((Object)this.radio)).setName("RadioEditor for " + this.getClass().getName() + "@" + System.identityHashCode(this));
            }
            radioInplaceEditor = (RadioInplaceEditor)this.radio;
        }
        radioInplaceEditor.setUseTitle(this.useLabels);
        return radioInplaceEditor;
    }

    private InplaceEditor getComboBoxEditor(boolean bl) {
        if (bl) {
            return new ComboInplaceEditor(this.tableUI);
        }
        if (this.combo == null) {
            this.combo = new ComboInplaceEditor(this.tableUI);
            ((JComponent)((Object)this.combo)).setName("ComboInplaceEditor for " + this.getClass().getName() + "@" + System.identityHashCode(this));
        }
        return this.combo;
    }

    private InplaceEditor getStringEditor(boolean bl) {
        if (bl) {
            return new StringInplaceEditor();
        }
        if (this.text == null) {
            this.text = new StringInplaceEditor();
            ((JComponent)((Object)this.text)).setName("StringEditor for " + this.getClass().getName() + "@" + System.identityHashCode(this));
        }
        return this.text;
    }

    private InplaceEditor getCheckboxEditor(boolean bl) {
        CheckboxInplaceEditor checkboxInplaceEditor;
        if (bl) {
            checkboxInplaceEditor = new CheckboxInplaceEditor();
        } else {
            if (this.checkbox == null) {
                this.checkbox = new CheckboxInplaceEditor();
                ((JComponent)((Object)this.checkbox)).setName("CheckboxEditor for " + this.getClass().getName() + "@" + System.identityHashCode(this));
            }
            checkboxInplaceEditor = (CheckboxInplaceEditor)this.checkbox;
        }
        checkboxInplaceEditor.setUseTitle(this.useLabels);
        return checkboxInplaceEditor;
    }

    public InplaceEditor getInplaceEditor(Node.Property property, boolean bl) {
        PropertyEnv propertyEnv = new PropertyEnv();
        propertyEnv.setBeans(this.reusableEnv.getBeans());
        return this.getInplaceEditor(property, propertyEnv, bl);
    }

    InplaceEditor getInplaceEditor(Node.Property property, PropertyEnv propertyEnv, boolean bl) {
        Object object;
        PropertyEditor propertyEditor = PropUtils.getPropertyEditor(property);
        InplaceEditor inplaceEditor = (InplaceEditor)property.getValue("inplaceEditor");
        propertyEnv.setFeatureDescriptor((FeatureDescriptor)property);
        propertyEnv.setEditable(property.canWrite());
        if (propertyEditor instanceof ExPropertyEditor) {
            object = (ExPropertyEditor)propertyEditor;
            object.attachEnv(propertyEnv);
            if (inplaceEditor == null) {
                inplaceEditor = propertyEnv.getInplaceEditor();
            }
        } else if (propertyEditor instanceof EnhancedPropertyEditor && (object = (EnhancedPropertyEditor)propertyEditor).hasInPlaceCustomEditor()) {
            inplaceEditor = new WrapperInplaceEditor((EnhancedPropertyEditor)object);
        }
        if (inplaceEditor == null) {
            object = property.getValueType();
            if (object == Boolean.class || object == Boolean.TYPE) {
                if (propertyEditor instanceof PropUtils.NoPropertyEditorEditor) {
                    inplaceEditor = this.getStringEditor(bl);
                } else {
                    boolean bl2 = this.useRadioBoolean || property.getValue("stringValues") != null;
                    inplaceEditor = bl2 ? this.getRadioEditor(bl) : this.getCheckboxEditor(bl);
                }
            } else {
                inplaceEditor = propertyEditor.getTags() != null ? (propertyEditor.getTags().length <= this.radioButtonMax ? this.getRadioEditor(bl) : this.getComboBoxEditor(bl)) : this.getStringEditor(bl);
            }
        }
        if (!this.tableUI && Boolean.FALSE.equals(property.getValue("canEditAsText"))) {
            inplaceEditor.getComponent().setEnabled(false);
        }
        inplaceEditor.clear();
        inplaceEditor.setPropertyModel(new NodePropertyModel(property, propertyEnv.getBeans()));
        inplaceEditor.connect(propertyEditor, propertyEnv);
        if (this.tableUI) {
            if (inplaceEditor instanceof JTextField) {
                inplaceEditor.getComponent().setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 0));
            } else {
                inplaceEditor.getComponent().setBorder(BorderFactory.createEmptyBorder());
            }
        }
        return inplaceEditor;
    }
}

