/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol.datatransfer;

import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.datatransfer.BlockConstructionStage;
import org.apache.hadoop.hdfs.protocol.datatransfer.BlockPinningException;
import org.apache.hadoop.hdfs.protocol.proto.DataTransferProtos;
import org.apache.hadoop.hdfs.protocol.proto.HdfsProtos;
import org.apache.hadoop.hdfs.protocolPB.PBHelperClient;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenIdentifier;
import org.apache.hadoop.hdfs.security.token.block.InvalidBlockTokenException;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.DataChecksum;
import org.apache.htrace.core.SpanId;
import org.apache.htrace.core.Tracer;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public abstract class DataTransferProtoUtil {
    static BlockConstructionStage fromProto(DataTransferProtos.OpWriteBlockProto.BlockConstructionStage stage) {
        return BlockConstructionStage.valueOf(stage.name());
    }

    static DataTransferProtos.OpWriteBlockProto.BlockConstructionStage toProto(BlockConstructionStage stage) {
        return DataTransferProtos.OpWriteBlockProto.BlockConstructionStage.valueOf(stage.name());
    }

    public static DataTransferProtos.ChecksumProto toProto(DataChecksum checksum) {
        HdfsProtos.ChecksumTypeProto type = PBHelperClient.convert(checksum.getChecksumType());
        return DataTransferProtos.ChecksumProto.newBuilder().setBytesPerChecksum(checksum.getBytesPerChecksum()).setType(type).build();
    }

    public static DataChecksum fromProto(DataTransferProtos.ChecksumProto proto) {
        if (proto == null) {
            return null;
        }
        int bytesPerChecksum = proto.getBytesPerChecksum();
        DataChecksum.Type type = PBHelperClient.convert(proto.getType());
        return DataChecksum.newDataChecksum((DataChecksum.Type)type, (int)bytesPerChecksum);
    }

    static DataTransferProtos.ClientOperationHeaderProto buildClientHeader(ExtendedBlock blk, String client, Token<BlockTokenIdentifier> blockToken) {
        return DataTransferProtos.ClientOperationHeaderProto.newBuilder().setBaseHeader(DataTransferProtoUtil.buildBaseHeader(blk, blockToken)).setClientName(client).build();
    }

    static DataTransferProtos.BaseHeaderProto buildBaseHeader(ExtendedBlock blk, Token<BlockTokenIdentifier> blockToken) {
        DataTransferProtos.BaseHeaderProto.Builder builder = DataTransferProtos.BaseHeaderProto.newBuilder().setBlock(PBHelperClient.convert(blk)).setToken(PBHelperClient.convert(blockToken));
        SpanId spanId = Tracer.getCurrentSpanId();
        if (spanId.isValid()) {
            builder.setTraceInfo(DataTransferProtos.DataTransferTraceInfoProto.newBuilder().setTraceId(spanId.getHigh()).setParentId(spanId.getLow()));
        }
        return builder.build();
    }

    public static SpanId fromProto(DataTransferProtos.DataTransferTraceInfoProto proto) {
        if (proto != null && proto.hasTraceId() && proto.hasParentId()) {
            return new SpanId(proto.getTraceId(), proto.getParentId());
        }
        return null;
    }

    public static void checkBlockOpStatus(DataTransferProtos.BlockOpResponseProto response, String logInfo) throws IOException {
        DataTransferProtoUtil.checkBlockOpStatus(response, logInfo, false);
    }

    public static void checkBlockOpStatus(DataTransferProtos.BlockOpResponseProto response, String logInfo, boolean checkBlockPinningErr) throws IOException {
        if (response.getStatus() != DataTransferProtos.Status.SUCCESS) {
            if (response.getStatus() == DataTransferProtos.Status.ERROR_ACCESS_TOKEN) {
                throw new InvalidBlockTokenException("Got access token error, status message " + response.getMessage() + ", " + logInfo);
            }
            if (checkBlockPinningErr && response.getStatus() == DataTransferProtos.Status.ERROR_BLOCK_PINNED) {
                throw new BlockPinningException("Got error, status=" + response.getStatus().name() + ", status message " + response.getMessage() + ", " + logInfo);
            }
            throw new IOException("Got error, status=" + response.getStatus().name() + ", status message " + response.getMessage() + ", " + logInfo);
        }
    }
}

