/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats.conllu;

import java.io.IOException;
import java.util.ArrayList;
import opennlp.tools.formats.conllu.ConlluSentence;
import opennlp.tools.sentdetect.SentenceSample;
import opennlp.tools.util.FilterObjectStream;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.Span;

public class ConlluSentenceSampleStream
extends FilterObjectStream<ConlluSentence, SentenceSample> {
    private final int sentencesPerSample;

    public ConlluSentenceSampleStream(ObjectStream<ConlluSentence> samples, int sentencesPerSample) {
        super(samples);
        this.sentencesPerSample = sentencesPerSample;
    }

    @Override
    public SentenceSample read() throws IOException {
        ConlluSentence sentence;
        StringBuilder documentText = new StringBuilder();
        ArrayList<Span> sentenceSpans = new ArrayList<Span>();
        for (int i = 0; i < this.sentencesPerSample && (sentence = (ConlluSentence)this.samples.read()) != null; ++i) {
            int startIndex = documentText.length();
            documentText.append(sentence.getTextComment()).append(' ');
            sentenceSpans.add(new Span(startIndex, documentText.length() - 1));
        }
        if (documentText.length() > 0) {
            documentText.setLength(documentText.length() - 1);
            return new SentenceSample(documentText, sentenceSpans.toArray(new Span[sentenceSpans.size()]));
        }
        return null;
    }
}

