/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.layout.template.json.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.function.Supplier;
import org.apache.logging.log4j.core.util.Constants;
import org.apache.logging.log4j.layout.template.json.util.DummyRecyclerFactory;
import org.apache.logging.log4j.layout.template.json.util.QueueingRecyclerFactory;
import org.apache.logging.log4j.layout.template.json.util.RecyclerFactory;
import org.apache.logging.log4j.layout.template.json.util.StringParameterParser;
import org.apache.logging.log4j.layout.template.json.util.ThreadLocalRecyclerFactory;
import org.apache.logging.log4j.util.LoaderUtil;
import org.jctools.queues.MpmcArrayQueue;

public final class RecyclerFactories {
    private static final String JCTOOLS_QUEUE_CLASS_SUPPLIER_PATH = "org.jctools.queues.MpmcArrayQueue.new";
    private static final boolean JCTOOLS_QUEUE_CLASS_AVAILABLE = RecyclerFactories.isJctoolsQueueClassAvailable();

    private RecyclerFactories() {
    }

    private static boolean isJctoolsQueueClassAvailable() {
        try {
            String className = JCTOOLS_QUEUE_CLASS_SUPPLIER_PATH.replaceAll("\\.new$", "");
            LoaderUtil.loadClass((String)className);
            return true;
        }
        catch (ClassNotFoundException ignored) {
            return false;
        }
    }

    public static RecyclerFactory ofSpec(String recyclerFactorySpec) {
        int defaultCapacity = Math.max(2 * Runtime.getRuntime().availableProcessors() + 1, 8);
        if (recyclerFactorySpec == null) {
            if (Constants.ENABLE_THREADLOCALS) {
                return ThreadLocalRecyclerFactory.getInstance();
            }
            Supplier<Queue<Object>> queueSupplier = JCTOOLS_QUEUE_CLASS_AVAILABLE ? () -> new MpmcArrayQueue(defaultCapacity) : () -> new ArrayBlockingQueue(defaultCapacity);
            return new QueueingRecyclerFactory(queueSupplier);
        }
        if (recyclerFactorySpec.equals("dummy")) {
            return DummyRecyclerFactory.getInstance();
        }
        if (recyclerFactorySpec.equals("threadLocal")) {
            return ThreadLocalRecyclerFactory.getInstance();
        }
        if (recyclerFactorySpec.startsWith("queue")) {
            return RecyclerFactories.readQueueingRecyclerFactory(recyclerFactorySpec, defaultCapacity);
        }
        throw new IllegalArgumentException("invalid recycler factory: " + recyclerFactorySpec);
    }

    private static RecyclerFactory readQueueingRecyclerFactory(String recyclerFactorySpec, int defaultCapacity) {
        int capacity;
        String queueFactorySpec = recyclerFactorySpec.substring("queue".length() + (recyclerFactorySpec.startsWith("queue:") ? 1 : 0));
        Map<String, StringParameterParser.Value> parsedValues = StringParameterParser.parse(queueFactorySpec, new LinkedHashSet<String>(Arrays.asList("supplier", "capacity")));
        StringParameterParser.Value supplierValue = parsedValues.get("supplier");
        String supplierPath = supplierValue == null || supplierValue instanceof StringParameterParser.NullValue ? (JCTOOLS_QUEUE_CLASS_AVAILABLE ? JCTOOLS_QUEUE_CLASS_SUPPLIER_PATH : "java.util.concurrent.ArrayBlockingQueue.new") : supplierValue.toString();
        StringParameterParser.Value capacityValue = parsedValues.get("capacity");
        if (capacityValue == null || capacityValue instanceof StringParameterParser.NullValue) {
            capacity = defaultCapacity;
        } else {
            try {
                capacity = Integer.parseInt(capacityValue.toString());
            }
            catch (NumberFormatException error) {
                throw new IllegalArgumentException("failed reading capacity in queueing recycler factory: " + queueFactorySpec, error);
            }
        }
        return RecyclerFactories.createRecyclerFactory(queueFactorySpec, supplierPath, capacity);
    }

    private static RecyclerFactory createRecyclerFactory(String queueFactorySpec, String supplierPath, int capacity) {
        int supplierPathSplitterIndex = supplierPath.lastIndexOf(46);
        if (supplierPathSplitterIndex < 0) {
            throw new IllegalArgumentException("invalid supplier in queueing recycler factory: " + queueFactorySpec);
        }
        String supplierClassName = supplierPath.substring(0, supplierPathSplitterIndex);
        String supplierMethodName = supplierPath.substring(supplierPathSplitterIndex + 1);
        try {
            Supplier<Queue<Object>> queueSupplier;
            Class supplierClass = LoaderUtil.loadClass((String)supplierClassName);
            if ("new".equals(supplierMethodName)) {
                Constructor supplierCtor = supplierClass.getDeclaredConstructor(Integer.TYPE);
                queueSupplier = () -> {
                    try {
                        Queue typedQueue = (Queue)supplierCtor.newInstance(capacity);
                        return typedQueue;
                    }
                    catch (Exception error) {
                        throw new RuntimeException("recycler queue construction failed for factory: " + queueFactorySpec, error);
                    }
                };
            } else {
                Method supplierMethod = supplierClass.getMethod(supplierMethodName, Integer.TYPE);
                queueSupplier = () -> {
                    try {
                        Queue typedQueue = (Queue)supplierMethod.invoke(null, capacity);
                        return typedQueue;
                    }
                    catch (Exception error) {
                        throw new RuntimeException("recycler queue construction failed for factory: " + queueFactorySpec, error);
                    }
                };
            }
            return new QueueingRecyclerFactory(queueSupplier);
        }
        catch (Exception error) {
            throw new RuntimeException("failed executing queueing recycler factory: " + queueFactorySpec, error);
        }
    }
}

