"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var re_reselect_1 = __importDefault(require("re-reselect"));
var get_chart_id_1 = require("../../../../state/selectors/get_chart_id");
var get_legend_size_1 = require("../../../../state/selectors/get_legend_size");
var get_settings_specs_1 = require("../../../../state/selectors/get_settings_specs");
var axis_type_utils_1 = require("../../../xy_chart/utils/axis_type_utils");
var get_heatmap_config_1 = require("./get_heatmap_config");
var getParentDimension = function (state) { return state.parentDimensions; };
exports.getHeatmapContainerSizeSelector = re_reselect_1.default([getParentDimension, get_legend_size_1.getLegendSizeSelector, get_heatmap_config_1.getHeatmapConfigSelector, get_settings_specs_1.getSettingsSpecSelector], function (parentDimensions, legendSize, _a, _b) {
    var maxLegendHeight = _a.maxLegendHeight;
    var showLegend = _b.showLegend, legendPosition = _b.legendPosition;
    if (!showLegend) {
        return parentDimensions;
    }
    if (axis_type_utils_1.isVerticalAxis(legendPosition)) {
        return {
            left: 0,
            top: 0,
            width: parentDimensions.width - legendSize.width - legendSize.margin * 2,
            height: parentDimensions.height,
        };
    }
    var legendHeight = (maxLegendHeight !== null && maxLegendHeight !== void 0 ? maxLegendHeight : legendSize.height + legendSize.margin * 2);
    return {
        left: 0,
        top: 0,
        width: parentDimensions.width,
        height: parentDimensions.height - legendHeight,
    };
})(get_chart_id_1.getChartIdSelector);
//# sourceMappingURL=get_heatmap_container_size.js.map