/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.help.search;

import com.sun.java.help.search.Query;
import com.sun.java.help.search.RoleFiller;

class ConceptData {
    private final byte _query;
    private final byte _nColumns;
    private final byte _role;
    private final int _concept;
    private int _conceptLength;
    private final int _proximity;
    private final double _penalty;
    private ConceptData _next;
    private static final int ProxPerTerm = 100;

    public ConceptData(int n, int n2, double d, int n3, int n4) {
        this._query = (byte)n3;
        this._nColumns = (byte)n4;
        this._concept = n;
        this._proximity = n4 * 100;
        this._role = (byte)n2;
        this._penalty = d;
        this._next = null;
    }

    void addLast(ConceptData conceptData) {
        if (this._next != null) {
            this._next.addLast(conceptData);
        } else {
            this._next = conceptData;
        }
    }

    boolean cEquals(ConceptData conceptData) {
        return this._concept == conceptData._concept;
    }

    boolean compareWith(ConceptData conceptData) {
        return this._concept < conceptData._concept || this.cEquals(conceptData) && this._role < conceptData._role || this.crEquals(conceptData) && this._penalty < conceptData._penalty;
    }

    boolean crEquals(ConceptData conceptData) {
        return this._concept == conceptData._concept && this._role == conceptData._role;
    }

    boolean crqEquals(ConceptData conceptData) {
        return this._concept == conceptData._concept && this._role == conceptData._role && this._query == conceptData._query;
    }

    public void generateFillers(RoleFiller[] roleFillerArray, int n) {
        if (roleFillerArray[this._query] != RoleFiller.STOP) {
            new RoleFiller(this._nColumns, this, this._role, n, n + this._proximity).use(roleFillerArray, this._query);
        }
        if (this._next != null) {
            this._next.generateFillers(roleFillerArray, n);
        }
    }

    public int getConcept() {
        return this._concept;
    }

    public int getConceptLength() {
        return this._conceptLength;
    }

    public byte getNColumns() {
        return this._nColumns;
    }

    public ConceptData getNext() {
        return this._next;
    }

    public double getPenalty() {
        return this._penalty;
    }

    public byte getQuery() {
        return this._query;
    }

    public int getQueryMask() {
        return (this._next != null ? this._next.getQueryMask() : 0) | 1 << this._query;
    }

    public byte getRole() {
        return this._role;
    }

    public double getScore() {
        return this._penalty;
    }

    public void runBy(Query[] queryArray) {
        ConceptData conceptData = this;
        do {
            queryArray[conceptData._query].updateEstimate(conceptData._role, conceptData._penalty);
        } while ((conceptData = conceptData._next) != null);
    }

    public void setConceptLength(int n) {
        this._conceptLength = n;
        if (this._next != null) {
            this._next.setConceptLength(n);
        }
    }

    public void setNext(ConceptData conceptData) {
        this._next = conceptData;
    }
}

