/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.projection.proj;

import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.projection.ProjectionConfigurationException;
import org.openstreetmap.josm.data.projection.proj.AbstractProj;
import org.openstreetmap.josm.data.projection.proj.IScaleFactorProvider;
import org.openstreetmap.josm.data.projection.proj.ProjParameters;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public class Mercator
extends AbstractProj
implements IScaleFactorProvider {
    private static final double EPSILON = 1.0E-6;
    protected double scaleFactor;

    @Override
    public String getName() {
        return I18n.tr("Mercator", new Object[0]);
    }

    @Override
    public String getProj4Id() {
        return "merc";
    }

    @Override
    public void initialize(ProjParameters params) throws ProjectionConfigurationException {
        super.initialize(params);
        this.scaleFactor = 1.0;
        if (params.lat_ts != null) {
            double standardParallel = Utils.toRadians(params.lat_ts);
            this.scaleFactor = this.spherical ? (this.scaleFactor *= Math.cos(standardParallel)) : (this.scaleFactor *= this.msfn(Math.sin(standardParallel), Math.cos(standardParallel)));
        }
        if (params.lat0 != null) {
            double lat0 = Utils.toRadians(params.lat0);
            double sinPhi = Math.sin(lat0);
            this.scaleFactor *= Math.cos(lat0) / Math.sqrt(1.0 - this.e2 * sinPhi * sinPhi);
        }
    }

    @Override
    public double[] project(double y, double x) {
        if (Math.abs(y) > 1.5707953267948966) {
            return new double[]{0.0, 0.0};
        }
        y = this.spherical ? Math.log(Math.tan(0.7853981633974483 + 0.5 * y)) : -Math.log(this.tsfn(y, Math.sin(y)));
        return new double[]{x, y};
    }

    @Override
    public double[] invproject(double x, double y) {
        if (this.spherical) {
            y = 1.5707963267948966 - 2.0 * Math.atan(Math.exp(-y));
        } else {
            y = Math.exp(-y);
            y = this.cphi2(y);
        }
        return new double[]{y, x};
    }

    @Override
    public Bounds getAlgorithmBounds() {
        return new Bounds(-89.0, -180.0, 89.0, 180.0, false);
    }

    @Override
    public double getScaleFactor() {
        return this.scaleFactor;
    }

    @Override
    public boolean lonIsLinearToEast() {
        return true;
    }
}

