#------------------------------------------------------------------------------
# File:         TagLookup.pm
#
# Description:  Fast lookup for ExifTool tags
#
# Notes:        This lookup is used to look up tag names for writing
#
# Revisions:    2004-12-31 - P. Harvey Created
#               2013-01-06 - PH Allow wildcards in FindTagInfo()
#------------------------------------------------------------------------------

package Image::ExifTool::TagLookup;

use strict;
require Exporter;

use vars qw($VERSION @ISA @EXPORT_OK);
use Image::ExifTool qw(:Utils);

$VERSION = '1.18';
@ISA = qw(Exporter);
@EXPORT_OK = qw(FindTagInfo TagExists);

sub AddTags($$);
sub AddFields($$$$$$;$$);

#
# Note: the lists below were generated by Image::ExifTool::BuildTagLookup
#

#++++ Begin automatically generated code ++++

# list of tables containing writable tags
my @tableList = (
	'Image::ExifTool::APP12::Ducky',
	'Image::ExifTool::Apple::Main',
	'Image::ExifTool::Canon::AFConfig',
	'Image::ExifTool::Canon::AFMicroAdj',
	'Image::ExifTool::Canon::Ambience',
	'Image::ExifTool::Canon::AspectInfo',
	'Image::ExifTool::Canon::CNTH',
	'Image::ExifTool::Canon::CameraInfo1000D',
	'Image::ExifTool::Canon::CameraInfo1D',
	'Image::ExifTool::Canon::CameraInfo1DX',
	'Image::ExifTool::Canon::CameraInfo1DmkII',
	'Image::ExifTool::Canon::CameraInfo1DmkIII',
	'Image::ExifTool::Canon::CameraInfo1DmkIIN',
	'Image::ExifTool::Canon::CameraInfo1DmkIV',
	'Image::ExifTool::Canon::CameraInfo40D',
	'Image::ExifTool::Canon::CameraInfo450D',
	'Image::ExifTool::Canon::CameraInfo500D',
	'Image::ExifTool::Canon::CameraInfo50D',
	'Image::ExifTool::Canon::CameraInfo550D',
	'Image::ExifTool::Canon::CameraInfo5D',
	'Image::ExifTool::Canon::CameraInfo5DmkII',
	'Image::ExifTool::Canon::CameraInfo5DmkIII',
	'Image::ExifTool::Canon::CameraInfo600D',
	'Image::ExifTool::Canon::CameraInfo60D',
	'Image::ExifTool::Canon::CameraInfo650D',
	'Image::ExifTool::Canon::CameraInfo6D',
	'Image::ExifTool::Canon::CameraInfo70D',
	'Image::ExifTool::Canon::CameraInfo750D',
	'Image::ExifTool::Canon::CameraInfo7D',
	'Image::ExifTool::Canon::CameraInfo80D',
	'Image::ExifTool::Canon::CameraInfoPowerShot',
	'Image::ExifTool::Canon::CameraInfoPowerShot2',
	'Image::ExifTool::Canon::CameraInfoUnknown',
	'Image::ExifTool::Canon::CameraInfoUnknown32',
	'Image::ExifTool::Canon::CameraSettings',
	'Image::ExifTool::Canon::ColorBalance',
	'Image::ExifTool::Canon::ColorCalib',
	'Image::ExifTool::Canon::ColorCalib2',
	'Image::ExifTool::Canon::ColorCoefs',
	'Image::ExifTool::Canon::ColorCoefs2',
	'Image::ExifTool::Canon::ColorData1',
	'Image::ExifTool::Canon::ColorData10',
	'Image::ExifTool::Canon::ColorData11',
	'Image::ExifTool::Canon::ColorData2',
	'Image::ExifTool::Canon::ColorData3',
	'Image::ExifTool::Canon::ColorData4',
	'Image::ExifTool::Canon::ColorData5',
	'Image::ExifTool::Canon::ColorData6',
	'Image::ExifTool::Canon::ColorData7',
	'Image::ExifTool::Canon::ColorData8',
	'Image::ExifTool::Canon::ColorData9',
	'Image::ExifTool::Canon::ColorInfo',
	'Image::ExifTool::Canon::ContrastInfo',
	'Image::ExifTool::Canon::CropInfo',
	'Image::ExifTool::Canon::FaceDetect1',
	'Image::ExifTool::Canon::FaceDetect2',
	'Image::ExifTool::Canon::FaceDetect3',
	'Image::ExifTool::Canon::FileInfo',
	'Image::ExifTool::Canon::Flags',
	'Image::ExifTool::Canon::FocalLength',
	'Image::ExifTool::Canon::HDRInfo',
	'Image::ExifTool::Canon::LensInfo',
	'Image::ExifTool::Canon::LightingOpt',
	'Image::ExifTool::Canon::LogInfo',
	'Image::ExifTool::Canon::Main',
	'Image::ExifTool::Canon::MeasuredColor',
	'Image::ExifTool::Canon::ModifiedInfo',
	'Image::ExifTool::Canon::MovieInfo',
	'Image::ExifTool::Canon::MultiExp',
	'Image::ExifTool::Canon::MyColors',
	'Image::ExifTool::Canon::PSInfo',
	'Image::ExifTool::Canon::PSInfo2',
	'Image::ExifTool::Canon::Panorama',
	'Image::ExifTool::Canon::PreviewImageInfo',
	'Image::ExifTool::Canon::Processing',
	'Image::ExifTool::Canon::RawBurstInfo',
	'Image::ExifTool::Canon::SerialInfo',
	'Image::ExifTool::Canon::ShotInfo',
	'Image::ExifTool::Canon::TimeInfo',
	'Image::ExifTool::Canon::VignettingCorr',
	'Image::ExifTool::Canon::VignettingCorr2',
	'Image::ExifTool::Canon::WBInfo',
	'Image::ExifTool::CanonCustom::Functions10D',
	'Image::ExifTool::CanonCustom::Functions1D',
	'Image::ExifTool::CanonCustom::Functions2',
	'Image::ExifTool::CanonCustom::Functions20D',
	'Image::ExifTool::CanonCustom::Functions30D',
	'Image::ExifTool::CanonCustom::Functions350D',
	'Image::ExifTool::CanonCustom::Functions400D',
	'Image::ExifTool::CanonCustom::Functions5D',
	'Image::ExifTool::CanonCustom::FunctionsD30',
	'Image::ExifTool::CanonCustom::PersonalFuncValues',
	'Image::ExifTool::CanonCustom::PersonalFuncs',
	'Image::ExifTool::CanonRaw::ExposureInfo',
	'Image::ExifTool::CanonRaw::FlashInfo',
	'Image::ExifTool::CanonRaw::ImageFormat',
	'Image::ExifTool::CanonRaw::ImageInfo',
	'Image::ExifTool::CanonRaw::Main',
	'Image::ExifTool::CanonRaw::MakeModel',
	'Image::ExifTool::CanonRaw::RawJpgInfo',
	'Image::ExifTool::CanonRaw::TimeStamp',
	'Image::ExifTool::CanonVRD::CropInfo',
	'Image::ExifTool::CanonVRD::DLOInfo',
	'Image::ExifTool::CanonVRD::DR4',
	'Image::ExifTool::CanonVRD::DR4Header',
	'Image::ExifTool::CanonVRD::GammaInfo',
	'Image::ExifTool::CanonVRD::Main',
	'Image::ExifTool::CanonVRD::ToneCurve',
	'Image::ExifTool::CanonVRD::Ver1',
	'Image::ExifTool::CanonVRD::Ver2',
	'Image::ExifTool::Casio::FaceInfo1',
	'Image::ExifTool::Casio::FaceInfo2',
	'Image::ExifTool::Casio::Main',
	'Image::ExifTool::Casio::Type2',
	'Image::ExifTool::Composite',
	'Image::ExifTool::DJI::Main',
	'Image::ExifTool::DJI::XMP',
	'Image::ExifTool::DNG::AdobeData',
	'Image::ExifTool::DarwinCore::Main',
	'Image::ExifTool::Exif::Main',
	'Image::ExifTool::Extra',
	'Image::ExifTool::FLIR::Main',
	'Image::ExifTool::FotoStation::Main',
	'Image::ExifTool::FotoStation::SoftEdit',
	'Image::ExifTool::FujiFilm::AFCSettings',
	'Image::ExifTool::FujiFilm::DriveSettings',
	'Image::ExifTool::FujiFilm::FocusSettings',
	'Image::ExifTool::FujiFilm::Main',
	'Image::ExifTool::FujiFilm::PrioritySettings',
	'Image::ExifTool::GE::Main',
	'Image::ExifTool::GPS::Main',
	'Image::ExifTool::IPTC::ApplicationRecord',
	'Image::ExifTool::IPTC::EnvelopeRecord',
	'Image::ExifTool::IPTC::NewsPhoto',
	'Image::ExifTool::JFIF::Main',
	'Image::ExifTool::Jpeg2000::ColorSpec',
	'Image::ExifTool::Jpeg2000::Main',
	'Image::ExifTool::Kodak::CameraInfo',
	'Image::ExifTool::Kodak::IFD',
	'Image::ExifTool::Kodak::KDC_IFD',
	'Image::ExifTool::Kodak::Main',
	'Image::ExifTool::Kodak::Meta',
	'Image::ExifTool::Kodak::SubIFD0',
	'Image::ExifTool::Kodak::SubIFD1',
	'Image::ExifTool::Kodak::SubIFD2',
	'Image::ExifTool::Kodak::SubIFD3',
	'Image::ExifTool::Kodak::SubIFD5',
	'Image::ExifTool::Kodak::Type10',
	'Image::ExifTool::Kodak::Type2',
	'Image::ExifTool::Kodak::Type3',
	'Image::ExifTool::Kodak::Type4',
	'Image::ExifTool::Kodak::Type5',
	'Image::ExifTool::Kodak::Type6',
	'Image::ExifTool::Kodak::Type7',
	'Image::ExifTool::Kodak::Type9',
	'Image::ExifTool::MIE::Audio',
	'Image::ExifTool::MIE::Camera',
	'Image::ExifTool::MIE::Doc',
	'Image::ExifTool::MIE::Extender',
	'Image::ExifTool::MIE::Flash',
	'Image::ExifTool::MIE::GPS',
	'Image::ExifTool::MIE::Geo',
	'Image::ExifTool::MIE::Image',
	'Image::ExifTool::MIE::Lens',
	'Image::ExifTool::MIE::Main',
	'Image::ExifTool::MIE::Orient',
	'Image::ExifTool::MIE::Preview',
	'Image::ExifTool::MIE::Thumbnail',
	'Image::ExifTool::MIE::UTM',
	'Image::ExifTool::MIE::Video',
	'Image::ExifTool::MWG::Collections',
	'Image::ExifTool::MWG::Keywords',
	'Image::ExifTool::MWG::Regions',
	'Image::ExifTool::MacOS::MDItem',
	'Image::ExifTool::MacOS::XAttr',
	'Image::ExifTool::Microsoft::MP',
	'Image::ExifTool::Microsoft::MP1',
	'Image::ExifTool::Microsoft::Stitch',
	'Image::ExifTool::Microsoft::XMP',
	'Image::ExifTool::Microsoft::Xtra',
	'Image::ExifTool::Minolta::CameraInfoA100',
	'Image::ExifTool::Minolta::CameraSettings',
	'Image::ExifTool::Minolta::CameraSettings5D',
	'Image::ExifTool::Minolta::CameraSettings7D',
	'Image::ExifTool::Minolta::CameraSettingsA100',
	'Image::ExifTool::Minolta::ISInfoA100',
	'Image::ExifTool::Minolta::Main',
	'Image::ExifTool::Minolta::WBInfoA100',
	'Image::ExifTool::MinoltaRaw::PRD',
	'Image::ExifTool::MinoltaRaw::RIF',
	'Image::ExifTool::MinoltaRaw::WBG',
	'Image::ExifTool::Motorola::Main',
	'Image::ExifTool::Nikon::AFInfo',
	'Image::ExifTool::Nikon::AFInfo2',
	'Image::ExifTool::Nikon::AFInfo2V0400',
	'Image::ExifTool::Nikon::AFTune',
	'Image::ExifTool::Nikon::BarometerInfo',
	'Image::ExifTool::Nikon::CaptureOutput',
	'Image::ExifTool::Nikon::ColorBalance1',
	'Image::ExifTool::Nikon::ColorBalance2',
	'Image::ExifTool::Nikon::ColorBalance3',
	'Image::ExifTool::Nikon::ColorBalance4',
	'Image::ExifTool::Nikon::ColorBalanceA',
	'Image::ExifTool::Nikon::ColorBalanceB',
	'Image::ExifTool::Nikon::ColorBalanceC',
	'Image::ExifTool::Nikon::ColorBalanceUnknown',
	'Image::ExifTool::Nikon::DistortInfo',
	'Image::ExifTool::Nikon::FaceDetect',
	'Image::ExifTool::Nikon::FileInfo',
	'Image::ExifTool::Nikon::FlashInfo0100',
	'Image::ExifTool::Nikon::FlashInfo0102',
	'Image::ExifTool::Nikon::FlashInfo0103',
	'Image::ExifTool::Nikon::FlashInfo0106',
	'Image::ExifTool::Nikon::FlashInfo0107',
	'Image::ExifTool::Nikon::FlashInfo0300',
	'Image::ExifTool::Nikon::GEM',
	'Image::ExifTool::Nikon::HDRInfo',
	'Image::ExifTool::Nikon::ISOInfo',
	'Image::ExifTool::Nikon::LensData00',
	'Image::ExifTool::Nikon::LensData01',
	'Image::ExifTool::Nikon::LensData0204',
	'Image::ExifTool::Nikon::LensData0400',
	'Image::ExifTool::Nikon::LensData0402',
	'Image::ExifTool::Nikon::LensData0403',
	'Image::ExifTool::Nikon::LensData0800',
	'Image::ExifTool::Nikon::LocationInfo',
	'Image::ExifTool::Nikon::Main',
	'Image::ExifTool::Nikon::MakerNotes0x51',
	'Image::ExifTool::Nikon::MenuSettingsZ7II',
	'Image::ExifTool::Nikon::MenuSettingsZ9',
	'Image::ExifTool::Nikon::MultiExposure',
	'Image::ExifTool::Nikon::PictureControl',
	'Image::ExifTool::Nikon::PictureControl2',
	'Image::ExifTool::Nikon::PictureControl3',
	'Image::ExifTool::Nikon::PreviewIFD',
	'Image::ExifTool::Nikon::ROC',
	'Image::ExifTool::Nikon::RetouchInfo',
	'Image::ExifTool::Nikon::Scan',
	'Image::ExifTool::Nikon::ShotInfo',
	'Image::ExifTool::Nikon::ShotInfoD300S',
	'Image::ExifTool::Nikon::ShotInfoD300a',
	'Image::ExifTool::Nikon::ShotInfoD300b',
	'Image::ExifTool::Nikon::ShotInfoD3S',
	'Image::ExifTool::Nikon::ShotInfoD3X',
	'Image::ExifTool::Nikon::ShotInfoD3a',
	'Image::ExifTool::Nikon::ShotInfoD3b',
	'Image::ExifTool::Nikon::ShotInfoD40',
	'Image::ExifTool::Nikon::ShotInfoD4S',
	'Image::ExifTool::Nikon::ShotInfoD500',
	'Image::ExifTool::Nikon::ShotInfoD5000',
	'Image::ExifTool::Nikon::ShotInfoD5100',
	'Image::ExifTool::Nikon::ShotInfoD5200',
	'Image::ExifTool::Nikon::ShotInfoD6',
	'Image::ExifTool::Nikon::ShotInfoD700',
	'Image::ExifTool::Nikon::ShotInfoD7000',
	'Image::ExifTool::Nikon::ShotInfoD80',
	'Image::ExifTool::Nikon::ShotInfoD800',
	'Image::ExifTool::Nikon::ShotInfoD810',
	'Image::ExifTool::Nikon::ShotInfoD850',
	'Image::ExifTool::Nikon::ShotInfoD90',
	'Image::ExifTool::Nikon::ShotInfoZ7II',
	'Image::ExifTool::Nikon::ShotInfoZ9',
	'Image::ExifTool::Nikon::Type2',
	'Image::ExifTool::Nikon::VRInfo',
	'Image::ExifTool::Nikon::WorldTime',
	'Image::ExifTool::NikonCapture::Brightness',
	'Image::ExifTool::NikonCapture::ColorBoost',
	'Image::ExifTool::NikonCapture::CropData',
	'Image::ExifTool::NikonCapture::DLightingHQ',
	'Image::ExifTool::NikonCapture::DLightingHS',
	'Image::ExifTool::NikonCapture::Exposure',
	'Image::ExifTool::NikonCapture::HighlightData',
	'Image::ExifTool::NikonCapture::Main',
	'Image::ExifTool::NikonCapture::NoiseReduction',
	'Image::ExifTool::NikonCapture::PhotoEffects',
	'Image::ExifTool::NikonCapture::PictureCtrl',
	'Image::ExifTool::NikonCapture::RedEyeData',
	'Image::ExifTool::NikonCapture::UnsharpData',
	'Image::ExifTool::NikonCapture::WBAdjData',
	'Image::ExifTool::NikonCustom::SettingsD3',
	'Image::ExifTool::NikonCustom::SettingsD4',
	'Image::ExifTool::NikonCustom::SettingsD40',
	'Image::ExifTool::NikonCustom::SettingsD5',
	'Image::ExifTool::NikonCustom::SettingsD500',
	'Image::ExifTool::NikonCustom::SettingsD5000',
	'Image::ExifTool::NikonCustom::SettingsD5100',
	'Image::ExifTool::NikonCustom::SettingsD5200',
	'Image::ExifTool::NikonCustom::SettingsD610',
	'Image::ExifTool::NikonCustom::SettingsD700',
	'Image::ExifTool::NikonCustom::SettingsD7000',
	'Image::ExifTool::NikonCustom::SettingsD80',
	'Image::ExifTool::NikonCustom::SettingsD800',
	'Image::ExifTool::NikonCustom::SettingsD810',
	'Image::ExifTool::NikonCustom::SettingsD850',
	'Image::ExifTool::NikonCustom::SettingsD90',
	'Image::ExifTool::NikonCustom::SettingsZ9',
	'Image::ExifTool::Nintendo::CameraInfo',
	'Image::ExifTool::Olympus::CameraSettings',
	'Image::ExifTool::Olympus::Equipment',
	'Image::ExifTool::Olympus::FETags',
	'Image::ExifTool::Olympus::FocusInfo',
	'Image::ExifTool::Olympus::ImageProcessing',
	'Image::ExifTool::Olympus::Main',
	'Image::ExifTool::Olympus::RawDevelopment',
	'Image::ExifTool::Olympus::RawDevelopment2',
	'Image::ExifTool::Olympus::RawInfo',
	'Image::ExifTool::PDF::Info',
	'Image::ExifTool::PLUS::XMP',
	'Image::ExifTool::PNG::Main',
	'Image::ExifTool::PNG::PhysicalPixel',
	'Image::ExifTool::PNG::TextualData',
	'Image::ExifTool::Panasonic::Data1',
	'Image::ExifTool::Panasonic::FaceDetInfo',
	'Image::ExifTool::Panasonic::FaceRecInfo',
	'Image::ExifTool::Panasonic::FocusInfo',
	'Image::ExifTool::Panasonic::Leica2',
	'Image::ExifTool::Panasonic::Leica3',
	'Image::ExifTool::Panasonic::Leica5',
	'Image::ExifTool::Panasonic::Leica6',
	'Image::ExifTool::Panasonic::Leica9',
	'Image::ExifTool::Panasonic::Main',
	'Image::ExifTool::Panasonic::ShotInfo',
	'Image::ExifTool::Panasonic::Subdir',
	'Image::ExifTool::Panasonic::TimeInfo',
	'Image::ExifTool::PanasonicRaw::DistortionInfo',
	'Image::ExifTool::PanasonicRaw::Main',
	'Image::ExifTool::PanasonicRaw::WBInfo',
	'Image::ExifTool::PanasonicRaw::WBInfo2',
	'Image::ExifTool::Pentax::AEInfo',
	'Image::ExifTool::Pentax::AEInfo2',
	'Image::ExifTool::Pentax::AEInfo3',
	'Image::ExifTool::Pentax::AFInfo',
	'Image::ExifTool::Pentax::AFPointInfo',
	'Image::ExifTool::Pentax::AWBInfo',
	'Image::ExifTool::Pentax::BatteryInfo',
	'Image::ExifTool::Pentax::CameraInfo',
	'Image::ExifTool::Pentax::CameraSettings',
	'Image::ExifTool::Pentax::ColorInfo',
	'Image::ExifTool::Pentax::EVStepInfo',
	'Image::ExifTool::Pentax::FaceInfo',
	'Image::ExifTool::Pentax::FacePos',
	'Image::ExifTool::Pentax::FaceSize',
	'Image::ExifTool::Pentax::FilterInfo',
	'Image::ExifTool::Pentax::FlashInfo',
	'Image::ExifTool::Pentax::KelvinWB',
	'Image::ExifTool::Pentax::LensCorr',
	'Image::ExifTool::Pentax::LensData',
	'Image::ExifTool::Pentax::LensInfo',
	'Image::ExifTool::Pentax::LensInfo2',
	'Image::ExifTool::Pentax::LensInfo3',
	'Image::ExifTool::Pentax::LensInfo4',
	'Image::ExifTool::Pentax::LensInfo5',
	'Image::ExifTool::Pentax::LensInfoQ',
	'Image::ExifTool::Pentax::LensRec',
	'Image::ExifTool::Pentax::LevelInfo',
	'Image::ExifTool::Pentax::Main',
	'Image::ExifTool::Pentax::PixelShiftInfo',
	'Image::ExifTool::Pentax::SRInfo',
	'Image::ExifTool::Pentax::SRInfo2',
	'Image::ExifTool::Pentax::ShotInfo',
	'Image::ExifTool::Pentax::TempInfo',
	'Image::ExifTool::Pentax::TimeInfo',
	'Image::ExifTool::Pentax::Type2',
	'Image::ExifTool::Pentax::WBLevels',
	'Image::ExifTool::PhaseOne::Main',
	'Image::ExifTool::PhaseOne::SensorCalibration',
	'Image::ExifTool::PhotoMechanic::SoftEdit',
	'Image::ExifTool::PhotoMechanic::XMP',
	'Image::ExifTool::Photoshop::JPEG_Quality',
	'Image::ExifTool::Photoshop::Main',
	'Image::ExifTool::Photoshop::Resolution',
	'Image::ExifTool::PostScript::Main',
	'Image::ExifTool::QuickTime::ItemList',
	'Image::ExifTool::QuickTime::ItemPropCont',
	'Image::ExifTool::QuickTime::Keys',
	'Image::ExifTool::QuickTime::Main',
	'Image::ExifTool::QuickTime::MediaHeader',
	'Image::ExifTool::QuickTime::MovieHeader',
	'Image::ExifTool::QuickTime::Preview',
	'Image::ExifTool::QuickTime::TrackHeader',
	'Image::ExifTool::QuickTime::UserData',
	'Image::ExifTool::Reconyx::Main',
	'Image::ExifTool::Reconyx::Type2',
	'Image::ExifTool::Reconyx::Type3',
	'Image::ExifTool::Ricoh::FaceInfo',
	'Image::ExifTool::Ricoh::FirmwareInfo',
	'Image::ExifTool::Ricoh::ImageInfo',
	'Image::ExifTool::Ricoh::Main',
	'Image::ExifTool::Ricoh::SerialInfo',
	'Image::ExifTool::Ricoh::Subdir',
	'Image::ExifTool::Ricoh::ThetaSubdir',
	'Image::ExifTool::Samsung::Main',
	'Image::ExifTool::Samsung::OrientationInfo',
	'Image::ExifTool::Samsung::PictureWizard',
	'Image::ExifTool::Samsung::Type2',
	'Image::ExifTool::Sanyo::FaceInfo',
	'Image::ExifTool::Sanyo::Main',
	'Image::ExifTool::Sigma::Main',
	'Image::ExifTool::Sigma::WBSettings',
	'Image::ExifTool::Sigma::WBSettings2',
	'Image::ExifTool::Sony::AFInfo',
	'Image::ExifTool::Sony::AFStatus15',
	'Image::ExifTool::Sony::AFStatus19',
	'Image::ExifTool::Sony::AFStatus79',
	'Image::ExifTool::Sony::CameraInfo',
	'Image::ExifTool::Sony::CameraInfo2',
	'Image::ExifTool::Sony::CameraInfo3',
	'Image::ExifTool::Sony::CameraSettings',
	'Image::ExifTool::Sony::CameraSettings2',
	'Image::ExifTool::Sony::CameraSettings3',
	'Image::ExifTool::Sony::Ericsson',
	'Image::ExifTool::Sony::ExtraInfo',
	'Image::ExifTool::Sony::ExtraInfo2',
	'Image::ExifTool::Sony::ExtraInfo3',
	'Image::ExifTool::Sony::FaceInfo',
	'Image::ExifTool::Sony::FaceInfo1',
	'Image::ExifTool::Sony::FaceInfo2',
	'Image::ExifTool::Sony::FaceInfoA',
	'Image::ExifTool::Sony::FocusInfo',
	'Image::ExifTool::Sony::ISOInfo',
	'Image::ExifTool::Sony::Main',
	'Image::ExifTool::Sony::MeterInfo',
	'Image::ExifTool::Sony::MeterInfo9',
	'Image::ExifTool::Sony::MoreInfo0201',
	'Image::ExifTool::Sony::MoreInfo0401',
	'Image::ExifTool::Sony::MoreSettings',
	'Image::ExifTool::Sony::Panorama',
	'Image::ExifTool::Sony::ShotInfo',
	'Image::ExifTool::Sony::Tag2010a',
	'Image::ExifTool::Sony::Tag2010b',
	'Image::ExifTool::Sony::Tag2010c',
	'Image::ExifTool::Sony::Tag2010d',
	'Image::ExifTool::Sony::Tag2010e',
	'Image::ExifTool::Sony::Tag2010f',
	'Image::ExifTool::Sony::Tag2010g',
	'Image::ExifTool::Sony::Tag2010h',
	'Image::ExifTool::Sony::Tag2010i',
	'Image::ExifTool::Sony::Tag202a',
	'Image::ExifTool::Sony::Tag9050a',
	'Image::ExifTool::Sony::Tag9050b',
	'Image::ExifTool::Sony::Tag9050c',
	'Image::ExifTool::Sony::Tag9400a',
	'Image::ExifTool::Sony::Tag9400b',
	'Image::ExifTool::Sony::Tag9400c',
	'Image::ExifTool::Sony::Tag9402',
	'Image::ExifTool::Sony::Tag9403',
	'Image::ExifTool::Sony::Tag9404a',
	'Image::ExifTool::Sony::Tag9404b',
	'Image::ExifTool::Sony::Tag9404c',
	'Image::ExifTool::Sony::Tag9405a',
	'Image::ExifTool::Sony::Tag9405b',
	'Image::ExifTool::Sony::Tag9406',
	'Image::ExifTool::Sony::Tag940a',
	'Image::ExifTool::Sony::Tag940c',
	'Image::ExifTool::SonyIDC::Main',
	'Image::ExifTool::XMP::Album',
	'Image::ExifTool::XMP::DICOM',
	'Image::ExifTool::XMP::Device',
	'Image::ExifTool::XMP::ExpressionMedia',
	'Image::ExifTool::XMP::GAudio',
	'Image::ExifTool::XMP::GCamera',
	'Image::ExifTool::XMP::GCreations',
	'Image::ExifTool::XMP::GDepth',
	'Image::ExifTool::XMP::GFocus',
	'Image::ExifTool::XMP::GImage',
	'Image::ExifTool::XMP::GPano',
	'Image::ExifTool::XMP::GSpherical',
	'Image::ExifTool::XMP::GettyImages',
	'Image::ExifTool::XMP::LImage',
	'Image::ExifTool::XMP::Lightroom',
	'Image::ExifTool::XMP::MediaPro',
	'Image::ExifTool::XMP::aas',
	'Image::ExifTool::XMP::acdsee',
	'Image::ExifTool::XMP::apple_fi',
	'Image::ExifTool::XMP::aux',
	'Image::ExifTool::XMP::cc',
	'Image::ExifTool::XMP::cell',
	'Image::ExifTool::XMP::crd',
	'Image::ExifTool::XMP::creatorAtom',
	'Image::ExifTool::XMP::crs',
	'Image::ExifTool::XMP::dc',
	'Image::ExifTool::XMP::dex',
	'Image::ExifTool::XMP::digiKam',
	'Image::ExifTool::XMP::exif',
	'Image::ExifTool::XMP::exifEX',
	'Image::ExifTool::XMP::extensis',
	'Image::ExifTool::XMP::fpv',
	'Image::ExifTool::XMP::ics',
	'Image::ExifTool::XMP::iptcCore',
	'Image::ExifTool::XMP::iptcExt',
	'Image::ExifTool::XMP::pdf',
	'Image::ExifTool::XMP::photoshop',
	'Image::ExifTool::XMP::pmi',
	'Image::ExifTool::XMP::prism',
	'Image::ExifTool::XMP::prl',
	'Image::ExifTool::XMP::prm',
	'Image::ExifTool::XMP::pur',
	'Image::ExifTool::XMP::rdf',
	'Image::ExifTool::XMP::swf',
	'Image::ExifTool::XMP::tiff',
	'Image::ExifTool::XMP::x',
	'Image::ExifTool::XMP::xmp',
	'Image::ExifTool::XMP::xmpBJ',
	'Image::ExifTool::XMP::xmpDM',
	'Image::ExifTool::XMP::xmpMM',
	'Image::ExifTool::XMP::xmpNote',
	'Image::ExifTool::XMP::xmpPLUS',
	'Image::ExifTool::XMP::xmpRights',
	'Image::ExifTool::XMP::xmpTPg',
);

# lookup for all writable tags
my %tagLookup = (
	'aberrationcorrectiondistance' => { 109 => 0x69 },
	'about' => { 497 => 'about' },
	'aboutcvterm' => { 489 => 'AboutCvTerm' },
	'aboutcvtermcvid' => { 489 => [\'AboutCvTerm','AboutCvTermCvId'] },
	'aboutcvtermid' => { 489 => [\'AboutCvTerm','AboutCvTermCvTermId'] },
	'aboutcvtermname' => { 489 => [\'AboutCvTerm','AboutCvTermCvTermName'] },
	'aboutcvtermrefinedabout' => { 489 => [\'AboutCvTerm','AboutCvTermCvTermRefinedAbout'] },
	'absolutealtitude' => { 116 => 'AbsoluteAltitude' },
	'abspeakaudiofilepath' => { 503 => 'absPeakAudioFilePath' },
	'academicfield' => { 493 => 'academicField' },
	'acceleration' => { 119 => 0x9404, 484 => 'Acceleration' },
	'accelerationtracking' => { 84 => 0x518 },
	'accelerationvector' => { 1 => 0x8 },
	'accelerometer' => { 390 => 0x3 },
	'accelerometerdata' => { 380 => 'vrot' },
	'accelerometerx' => { 320 => 0x8d },
	'accelerometery' => { 320 => 0x8e },
	'accelerometerz' => { 320 => 0x8c },
	'accessoryserialnumber' => { 320 => 0x54 },
	'accessorytype' => { 320 => 0x53 },
	'actionadvised' => { 131 => 0x2a },
	'activearea' => { 119 => 0xc68d },
	'actived-lighting' => { 226 => 0x22, 270 => 0x24 },
	'actived-lightingmode' => { 270 => 0x25 },
	'adaptervoltage' => { 138 => 0x407 },
	'addaspectratioinfo' => { 84 => 0x80e },
	'addiptcinformation' => { 84 => 0x815 },
	'additionalmodelinformation' => { 489 => 'AddlModelInfo' },
	'addoriginaldecisiondata' => { 84 => 0x80f, 85 => 0x11, 86 => 0x13, 89 => 0x14 },
	'address' => { 161 => 'Address' },
	'adjustmentmode' => { 397 => 0x15 },
	'adlbracketingstep' => { 248 => 0x883 },
	'adlbracketingtype' => { 248 => 0x884 },
	'adobe' => { 120 => 'Adobe' },
	'adultcontentwarning' => { 307 => 'AdultContentWarning', 496 => 'adultContentWarning' },
	'advancedfilter' => { 127 => 0x1201 },
	'advancedraw' => { 272 => 0x76a43203 },
	'advancedscenetype' => { 320 => 0x3d },
	'advisory' => { 501 => 'Advisory' },
	'ae_iso' => { 328 => 0x2, 329 => 0x4, 330 => 0x12 },
	'aeaperture' => { 328 => 0x1, 329 => 0x3, 330 => 0x11 },
	'aeaperturesteps' => { 328 => 0x8, 329 => 0xb },
	'aebautocancel' => { 84 => 0x104 },
	'aebbracketvalue' => { 77 => 0x11 },
	'aebracketingsteps' => { 247 => 0x174c, 248 => 0x87b, 257 => 0x1756 },
	'aebsequence' => { 84 => 0x105 },
	'aebsequenceautocancel' => { 82 => 0x9, 83 => 0x9, 85 => 0x8, 86 => 0x9, 89 => 0x9, 90 => 0x7 },
	'aebshotcount' => { 84 => 0x106 },
	'aebxv' => { 328 => 0x4, 329 => 0x6 },
	'aeerror' => { 329 => 0x8 },
	'aeexposuretime' => { 328 => 0x0, 329 => 0x2, 330 => 0x10 },
	'aelbutton' => { 184 => 0x45 },
	'aelexposureindicator' => { 184 => 0x51 },
	'aelock' => { 184 => 0x5b, 281 => '4.2', 290 => '4.2', 297 => 0x201, 355 => 0x48, 407 => 0x40, 408 => 0x40, 409 => [0x86,0x286] },
	'aelockbutton' => { 279 => '16.1', 281 => '4.1', 284 => '15.1', 285 => '16.1', 286 => '16.1', 288 => '30.1', 289 => '16.1', 290 => '4.1', 292 => '17.1', 294 => '17.1' },
	'aelockbuttonplusdials' => { 279 => '16.2', 288 => '32.1', 292 => '44.1' },
	'aelockformb-d80' => { 294 => '3.1' },
	'aelockmetermodeafterfocus' => { 84 => 0x114 },
	'aemaxaperture' => { 328 => 0x9, 329 => 0x10, 330 => 0x1c },
	'aemaxaperture2' => { 328 => 0xa, 329 => 0x11, 330 => 0x1d },
	'aemeteringmode' => { 328 => 0xc },
	'aemeteringmode2' => { 328 => '13.1' },
	'aemeteringsegments' => { 187 => 0x628, 355 => 0x209 },
	'aemicroadjustment' => { 84 => 0x110 },
	'aeminaperture' => { 328 => 0xb, 329 => 0x12, 330 => 0x1e },
	'aeminexposuretime' => { 328 => 0x5, 329 => 0x13, 330 => 0x1f },
	'aeprogrammode' => { 328 => 0x6 },
	'aeprojectlink' => { 478 => 'aeProjectLink' },
	'aeprojectlinkcompositionid' => { 478 => [\'aeProjectLink','aeProjectLinkCompositionID'] },
	'aeprojectlinkfullpath' => { 478 => [\'aeProjectLink','aeProjectLinkFullPath'] },
	'aeprojectlinkrenderoutputmoduleindex' => { 478 => [\'aeProjectLink','aeProjectLinkRenderOutputModuleIndex'] },
	'aeprojectlinkrenderqueueitemid' => { 478 => [\'aeProjectLink','aeProjectLinkRenderQueueItemID'] },
	'aeprojectlinkrendertimestamp' => { 478 => [\'aeProjectLink','aeProjectLinkRenderTimeStamp'] },
	'aesetting' => { 34 => 0x21 },
	'aewhitebalance' => { 328 => 0xd },
	'aexv' => { 328 => 0x3, 329 => 0x5 },
	'af-assistilluminator' => { 295 => 0x19 },
	'af-cfocusdisplay' => { 295 => 0x234 },
	'af-cpriority' => { 128 => '0.2' },
	'af-cpriorityselection' => { 279 => '1.1', 280 => '1.1', 282 => '1.1', 283 => '1.1', 285 => '0.1', 286 => '0.1', 287 => '0.1', 288 => '1.1', 289 => '0.1', 292 => '1.1', 293 => '1.1', 295 => 0x3 },
	'af-csetting' => { 124 => 0x0 },
	'af-cspeedtrackingsensitivity' => { 124 => '0.2' },
	'af-ctrackingsensitivity' => { 124 => '0.1' },
	'af-czoneareaswitching' => { 124 => '0.3' },
	'af-onbutton' => { 282 => '70.1', 283 => '70.1', 293 => '70.1' },
	'af-onformb-d10' => { 279 => '3.3', 288 => '3.2' },
	'af-onformb-d11' => { 289 => '2.2' },
	'af-onformb-d12' => { 292 => '50.1' },
	'af-onoutoffocusrelease' => { 295 => 0x10 },
	'af-spriority' => { 128 => '0.1' },
	'af-spriorityselection' => { 279 => '1.2', 280 => '1.2', 282 => '1.2', 283 => '1.2', 287 => '0.2', 288 => '1.2', 289 => '0.2', 292 => '1.2', 293 => '1.2', 295 => 0x5 },
	'afacceldeceltracking' => { 2 => 0x3 },
	'afactivation' => { 279 => '2.1', 280 => '2.1', 282 => '78.3', 283 => '78.3', 288 => '2.1', 292 => '2.1', 293 => '78.3', 295 => 0xf },
	'afadjustment' => { 355 => 0x72, 364 => 0x267 },
	'afandmeteringbuttons' => { 84 => 0x701 },
	'afaperture' => { 219 => 0x5, 220 => 0x5, 224 => 0x5 },
	'afareaheight' => { 193 => [0x1a,0x34,0x50], 194 => 0x48 },
	'afareaillumination' => { 184 => 0x4b, 290 => '15.3' },
	'afareamode' => { 126 => '0.3', 180 => 0x33, 184 => 0xe, 192 => 0x0, 193 => 0x5, 229 => 0x210, 320 => 0xf, 387 => 0x1205, 400 => [0xa,0x3a], 407 => 0x11, 408 => 0x10, 409 => 0x24, 420 => 0xb043, 444 => 0x17 },
	'afareamodesetting' => { 281 => '11.1', 284 => '0.1', 290 => '16.1', 294 => '2.1', 420 => 0x201c },
	'afareapointsize' => { 126 => '0.4' },
	'afareas' => { 297 => 0x304 },
	'afareaselectionmethod' => { 2 => 0xd },
	'afareaselectmethod' => { 84 => 0x51b },
	'afareawidth' => { 193 => [0x18,0x32,0x4e], 194 => 0x46 },
	'afareaxposition' => { 193 => [0x14,0x2e,0x4a], 387 => 0x1203 },
	'afareaxposition1' => { 387 => 0x1201 },
	'afareayposition' => { 193 => [0x16,0x30,0x4c], 387 => 0x1204 },
	'afareayposition1' => { 387 => 0x1202 },
	'afareazonesize' => { 126 => '0.5' },
	'afassist' => { 82 => 0x5, 90 => 0x5, 184 => 0x48, 279 => '2.5', 281 => '0.2', 284 => '0.2', 285 => '1.1', 286 => '1.1', 287 => '1.3', 288 => '2.4', 289 => '1.3', 290 => '0.2', 292 => '2.4', 294 => '2.3' },
	'afassistbeam' => { 2 => 0x8, 84 => 0x50e, 85 => 0x4, 86 => 0x5, 87 => 0x4, 88 => 0x4, 89 => 0x5 },
	'afassistlamp' => { 320 => 0x31 },
	'afbuttonpressed' => { 409 => [0x83,0x283] },
	'afconfigtool' => { 2 => 0x1 },
	'afdefocus' => { 331 => 0x6 },
	'afduringliveview' => { 84 => 0x511 },
	'affinea' => { 471 => 'AffineA' },
	'affineb' => { 471 => 'AffineB' },
	'affinec' => { 471 => 'AffineC' },
	'affined' => { 471 => 'AffineD' },
	'affinetune' => { 195 => 0x0, 229 => 0x5b0, 297 => 0x306 },
	'affinetuneadj' => { 195 => 0x2, 240 => 0x2d1, 241 => 0x2dc, 297 => 0x307 },
	'affinetuneadjtele' => { 195 => 0x3 },
	'affinetuneindex' => { 195 => 0x1 },
	'affinex' => { 471 => 'AffineX' },
	'affiney' => { 471 => 'AffineY' },
	'affocuspointxposition' => { 193 => 0x2f },
	'affocuspointyposition' => { 193 => 0x31 },
	'afhold' => { 331 => 0x1fd },
	'afilluminator' => { 407 => 0x29, 420 => 0xb044 },
	'afimageheight' => { 193 => [0x12,0x2c,0x48], 194 => 0x40 },
	'afimagewidth' => { 193 => [0x10,0x2a,0x46], 194 => 0x3e },
	'afintegrationtime' => { 331 => 0x7 },
	'afmicroadj' => { 400 => [0x17d,0x50] },
	'afmicroadjmode' => { 3 => 0x1, 404 => 0x131 },
	'afmicroadjregisteredlenses' => { 404 => '305.1' },
	'afmicroadjustment' => { 84 => 0x507 },
	'afmicroadjvalue' => { 3 => 0x2, 404 => 0x130 },
	'afmode' => { 113 => 0x3009, 127 => 0x1022, 180 => 0x16, 397 => 0x5 },
	'afmoderestrictions' => { 280 => '50.3', 282 => '48.3', 283 => '48.3', 292 => '48.3', 293 => '48.3' },
	'afonaelockbuttonswitch' => { 84 => 0x702 },
	'afonbutton' => { 279 => '3.1', 280 => '47.1', 295 => 0x83 },
	'afpoint' => { 34 => 0x13, 112 => 0x18, 180 => 0x15, 192 => 0x1, 300 => 0x308, 397 => 0x1f, 400 => [0x37,0x7], 404 => 0x19, 405 => 0x18, 406 => [0x18,0x20] },
	'afpointactivationarea' => { 83 => 0x11, 89 => 0x11 },
	'afpointareaexpansion' => { 84 => 0x508 },
	'afpointatshutterrelease' => { 400 => [0x39,0x9] },
	'afpointautoselection' => { 84 => 0x50b },
	'afpointbrightness' => { 84 => 0x50d, 279 => '2.4', 280 => '46.5', 282 => '2.2', 283 => '2.2', 292 => '2.3', 293 => '2.2' },
	'afpointdisplayduringfocus' => { 2 => 0x10, 84 => 0x50c },
	'afpointillumination' => { 83 => 0xa, 279 => '2.3', 280 => '46.2', 282 => '47.2', 283 => '47.2', 287 => '1.2', 288 => '2.3', 289 => '1.2', 292 => '47.2', 293 => '47.2', 294 => '2.4' },
	'afpointinfocus' => { 400 => [0x38,0x8] },
	'afpointmode' => { 336 => 0x3 },
	'afpointposition' => { 113 => 0x2021, 320 => 0x4d },
	'afpointregistration' => { 82 => 0x7 },
	'afpoints' => { 183 => 0x10 },
	'afpointsel' => { 295 => 0xb },
	'afpointselected' => { 184 => 0xd, 297 => 0x305, 355 => 0xe, 404 => 0x15, 405 => 0x14, 406 => [0x14,0x1c], 420 => 0x201e },
	'afpointselected2' => { 336 => 0x4 },
	'afpointselection' => { 83 => 0xb, 279 => '1.3', 280 => '1.3', 288 => '1.3', 292 => '1.3', 293 => '1.3' },
	'afpointselectionmethod' => { 84 => 0x50f, 85 => 0xc, 86 => 0xd, 89 => 0xd },
	'afpointsetting' => { 407 => 0x12, 408 => 0x11 },
	'afpointsinfocus' => { 77 => 0xe, 192 => 0x2, 193 => 0x30, 331 => 0xb, 332 => 0x4, 355 => [0xf,0x3c] },
	'afpointsinfocus5d' => { 19 => 0x38 },
	'afpointspotmetering' => { 83 => 0xd },
	'afpointsselected' => { 193 => 0x1c, 332 => '4.1', 452 => 0x4 },
	'afpointsspecial' => { 332 => '4.2' },
	'afpointsunknown1' => { 331 => 0x0 },
	'afpointsunknown2' => { 331 => 0x2 },
	'afpointsused' => { 193 => [0xa,0x8], 400 => [0x10,0x16e] },
	'afpointswitching' => { 2 => 0x4 },
	'afpredictor' => { 331 => 0x4 },
	'afresponse' => { 226 => 0xad },
	'afresult' => { 302 => 0x1038 },
	'afsearch' => { 297 => 0x303 },
	'afsensoractive' => { 180 => 0x1 },
	'afstatus' => { 387 => 0x1200 },
	'afstatus_00_b4' => { 403 => 0x0 },
	'afstatus_01_c4' => { 403 => 0x2 },
	'afstatus_02_d4' => { 403 => 0x4 },
	'afstatus_03_e4' => { 403 => 0x6 },
	'afstatus_04_f4' => { 403 => 0x8 },
	'afstatus_05_g4' => { 403 => 0xa },
	'afstatus_06_h4' => { 403 => 0xc },
	'afstatus_07_b3' => { 403 => 0xe },
	'afstatus_08_c3' => { 403 => 0x10 },
	'afstatus_09_d3' => { 403 => 0x12 },
	'afstatus_10_e3' => { 403 => 0x14 },
	'afstatus_11_f3' => { 403 => 0x16 },
	'afstatus_12_g3' => { 403 => 0x18 },
	'afstatus_13_h3' => { 403 => 0x1a },
	'afstatus_14_b2' => { 403 => 0x1c },
	'afstatus_15_c2' => { 403 => 0x1e },
	'afstatus_16_d2' => { 403 => 0x20 },
	'afstatus_17_e2' => { 403 => 0x22 },
	'afstatus_18_f2' => { 403 => 0x24 },
	'afstatus_19_g2' => { 403 => 0x26 },
	'afstatus_20_h2' => { 403 => 0x28 },
	'afstatus_21_c1' => { 403 => 0x2a },
	'afstatus_22_d1' => { 403 => 0x2c },
	'afstatus_23_e1' => { 403 => 0x2e },
	'afstatus_24_f1' => { 403 => 0x30 },
	'afstatus_25_g1' => { 403 => 0x32 },
	'afstatus_26_a7_vertical' => { 403 => 0x34 },
	'afstatus_27_a6_vertical' => { 403 => 0x36 },
	'afstatus_28_a5_vertical' => { 403 => 0x38 },
	'afstatus_29_c7_vertical' => { 403 => 0x3a },
	'afstatus_30_c6_vertical' => { 403 => 0x3c },
	'afstatus_31_c5_vertical' => { 403 => 0x3e },
	'afstatus_32_e7_vertical' => { 403 => 0x40 },
	'afstatus_33_e6_center_vertical' => { 403 => 0x42 },
	'afstatus_34_e5_vertical' => { 403 => 0x44 },
	'afstatus_35_g7_vertical' => { 403 => 0x46 },
	'afstatus_36_g6_vertical' => { 403 => 0x48 },
	'afstatus_37_g5_vertical' => { 403 => 0x4a },
	'afstatus_38_i7_vertical' => { 403 => 0x4c },
	'afstatus_39_i6_vertical' => { 403 => 0x4e },
	'afstatus_40_i5_vertical' => { 403 => 0x50 },
	'afstatus_41_a7' => { 403 => 0x52 },
	'afstatus_42_b7' => { 403 => 0x54 },
	'afstatus_43_c7' => { 403 => 0x56 },
	'afstatus_44_d7' => { 403 => 0x58 },
	'afstatus_45_e7' => { 403 => 0x5a },
	'afstatus_46_f7' => { 403 => 0x5c },
	'afstatus_47_g7' => { 403 => 0x5e },
	'afstatus_48_h7' => { 403 => 0x60 },
	'afstatus_49_i7' => { 403 => 0x62 },
	'afstatus_50_a6' => { 403 => 0x64 },
	'afstatus_51_b6' => { 403 => 0x66 },
	'afstatus_52_c6' => { 403 => 0x68 },
	'afstatus_53_d6' => { 403 => 0x6a },
	'afstatus_54_e6_center' => { 403 => 0x6c },
	'afstatus_55_f6' => { 403 => 0x6e },
	'afstatus_56_g6' => { 403 => 0x70 },
	'afstatus_57_h6' => { 403 => 0x72 },
	'afstatus_58_i6' => { 403 => 0x74 },
	'afstatus_59_a5' => { 403 => 0x76 },
	'afstatus_60_b5' => { 403 => 0x78 },
	'afstatus_61_c5' => { 403 => 0x7a },
	'afstatus_62_d5' => { 403 => 0x7c },
	'afstatus_63_e5' => { 403 => 0x7e },
	'afstatus_64_f5' => { 403 => 0x80 },
	'afstatus_65_g5' => { 403 => 0x82 },
	'afstatus_66_h5' => { 403 => 0x84 },
	'afstatus_67_i5' => { 403 => 0x86 },
	'afstatus_68_c11' => { 403 => 0x88 },
	'afstatus_69_d11' => { 403 => 0x8a },
	'afstatus_70_e11' => { 403 => 0x8c },
	'afstatus_71_f11' => { 403 => 0x8e },
	'afstatus_72_g11' => { 403 => 0x90 },
	'afstatus_73_b10' => { 403 => 0x92 },
	'afstatus_74_c10' => { 403 => 0x94 },
	'afstatus_75_d10' => { 403 => 0x96 },
	'afstatus_76_e10' => { 403 => 0x98 },
	'afstatus_77_f10' => { 403 => 0x9a },
	'afstatus_78_g10' => { 403 => 0x9c },
	'afstatus_79_h10' => { 403 => 0x9e },
	'afstatus_80_b9' => { 403 => 0xa0 },
	'afstatus_81_c9' => { 403 => 0xa2 },
	'afstatus_82_d9' => { 403 => 0xa4 },
	'afstatus_83_e9' => { 403 => 0xa6 },
	'afstatus_84_f9' => { 403 => 0xa8 },
	'afstatus_85_g9' => { 403 => 0xaa },
	'afstatus_86_h9' => { 403 => 0xac },
	'afstatus_87_b8' => { 403 => 0xae },
	'afstatus_88_c8' => { 403 => 0xb0 },
	'afstatus_89_d8' => { 403 => 0xb2 },
	'afstatus_90_e8' => { 403 => 0xb4 },
	'afstatus_91_f8' => { 403 => 0xb6 },
	'afstatus_92_g8' => { 403 => 0xb8 },
	'afstatus_93_h8' => { 403 => 0xba },
	'afstatus_94_e6_center_f2-8' => { 403 => 0xbc },
	'afstatusactivesensor' => { 180 => 0x2, 400 => [0x4,0x3b], 404 => 0x1e, 405 => 0x1b, 406 => [0x1b,0x21] },
	'afstatusbottom' => { 180 => 0x8, 404 => 0x2a, 405 => 0x21, 406 => 0x21 },
	'afstatusbottom-left' => { 180 => 0x12, 405 => 0x2b, 406 => 0x2b },
	'afstatusbottom-right' => { 180 => 0x6, 405 => 0x1f, 406 => 0x1f },
	'afstatusbottomassist-left' => { 404 => 0x28 },
	'afstatusbottomassist-right' => { 404 => 0x2c },
	'afstatusbottomhorizontal' => { 401 => 0x10, 402 => 0x1c },
	'afstatusbottomvertical' => { 401 => 0x16, 402 => 0x26 },
	'afstatuscenter-10' => { 404 => 0x34 },
	'afstatuscenter-11' => { 404 => 0x36 },
	'afstatuscenter-12' => { 404 => 0x38 },
	'afstatuscenter-14' => { 404 => 0x3c },
	'afstatuscenter-7' => { 404 => 0x2e },
	'afstatuscenter-9' => { 404 => 0x32 },
	'afstatuscenter-horizontal' => { 404 => 0x30 },
	'afstatuscenter-vertical' => { 404 => 0x3a },
	'afstatuscenterf2-8' => { 404 => 0x4c },
	'afstatuscenterhorizontal' => { 180 => 0x2f, 401 => 0xc, 402 => 0x18, 405 => 0x2f, 406 => 0x2f },
	'afstatuscentervertical' => { 180 => 0xc, 401 => 0x14, 402 => 0x22, 405 => 0x25, 406 => 0x25 },
	'afstatusfarleft' => { 401 => 0x6, 404 => 0x26 },
	'afstatusfarlefthorizontal' => { 402 => 0x4 },
	'afstatusfarleftvertical' => { 402 => 0x12 },
	'afstatusfarright' => { 401 => 0x18, 404 => 0x44 },
	'afstatusfarrighthorizontal' => { 402 => 0x2c },
	'afstatusfarrightvertical' => { 402 => 0x34 },
	'afstatusleft' => { 180 => 0x2d, 401 => 0x2, 404 => 0x22, 405 => 0x2d, 406 => 0x2d },
	'afstatuslefthorizontal' => { 402 => 0x6 },
	'afstatusleftvertical' => { 402 => 0xe },
	'afstatuslower-left' => { 401 => 0x4, 404 => 0x24 },
	'afstatuslower-lefthorizontal' => { 402 => 0xa },
	'afstatuslower-leftvertical' => { 402 => 0x10 },
	'afstatuslower-middle' => { 401 => 0x22, 402 => 0x24 },
	'afstatuslower-right' => { 401 => 0x1e, 404 => 0x4a },
	'afstatuslower-righthorizontal' => { 402 => 0x32 },
	'afstatuslower-rightvertical' => { 402 => 0x3a },
	'afstatuslowerfarleft' => { 402 => 0x8 },
	'afstatuslowerfarright' => { 402 => 0x30 },
	'afstatusmiddlehorizontal' => { 180 => 0xa, 405 => 0x23, 406 => 0x23 },
	'afstatusnearleft' => { 401 => 0xe, 402 => 0x1a },
	'afstatusnearright' => { 401 => 0xa, 402 => 0x16 },
	'afstatusright' => { 180 => 0x31, 401 => 0x1c, 404 => 0x48, 405 => 0x31, 406 => 0x31 },
	'afstatusrighthorizontal' => { 402 => 0x2e },
	'afstatusrightvertical' => { 402 => 0x38 },
	'afstatustop' => { 180 => 0xe, 404 => 0x40, 405 => 0x27, 406 => 0x27 },
	'afstatustop-left' => { 180 => 0x10, 405 => 0x29, 406 => 0x29 },
	'afstatustop-right' => { 180 => 0x4, 405 => 0x1d, 406 => 0x1d },
	'afstatustopassist-left' => { 404 => 0x3e },
	'afstatustopassist-right' => { 404 => 0x42 },
	'afstatustophorizontal' => { 401 => 0x8, 402 => 0x14 },
	'afstatustopvertical' => { 401 => 0x12, 402 => 0x1e },
	'afstatusupper-left' => { 401 => 0x0, 404 => 0x20 },
	'afstatusupper-lefthorizontal' => { 402 => 0x2 },
	'afstatusupper-leftvertical' => { 402 => 0xc },
	'afstatusupper-middle' => { 401 => 0x20, 402 => 0x20 },
	'afstatusupper-right' => { 401 => 0x1a, 404 => 0x46 },
	'afstatusupper-righthorizontal' => { 402 => 0x2a },
	'afstatusupper-rightvertical' => { 402 => 0x36 },
	'afstatusupperfarleft' => { 402 => 0x0 },
	'afstatusupperfarright' => { 402 => 0x28 },
	'afstatusviewfinder' => { 2 => 0x12 },
	'aftracking' => { 420 => 0x2021 },
	'aftrackingsensitivity' => { 2 => 0x2 },
	'aftype' => { 400 => 0x2 },
	'afwithshutter' => { 407 => 0x2a },
	'aggregateissuenumber' => { 493 => 'aggregateIssueNumber' },
	'aggregationtype' => { 493 => 'aggregationType' },
	'agreement' => { 496 => 'agreement' },
	'ah2greeninterpolationthreshold' => { 138 => 0xe4e },
	'airplanemode' => { 229 => 0x624 },
	'aiservocontinuousshooting' => { 83 => 0x15 },
	'aiservofirstimage' => { 2 => 0x5 },
	'aiservofirstimagepriority' => { 84 => 0x519 },
	'aiservoimagepriority' => { 84 => 0x503 },
	'aiservosecondimage' => { 2 => 0x6 },
	'aiservosecondimagepriority' => { 84 => 0x51a },
	'aiservotrackingmethod' => { 84 => 0x504 },
	'aiservotrackingsensitivity' => { 83 => 0x14, 84 => 0x502 },
	'album' => { 372 => ['albm',"\xa9alb"], 374 => 'album', 380 => ['albm',"\xa9alb"], 503 => 'album' },
	'albumartist' => { 179 => 'WM/AlbumArtist', 372 => 'aART', 380 => 'albr' },
	'albumcoverurl' => { 179 => 'WM/AlbumCoverURL' },
	'albumtitle' => { 179 => 'WM/AlbumTitle' },
	'albumtitleid' => { 372 => 'atID' },
	'alreadyapplied' => { 477 => 'AlreadyApplied', 479 => 'AlreadyApplied' },
	'alternatetitle' => { 493 => 'alternateTitle' },
	'alternatetitlea-lang' => { 493 => [\'alternateTitle','alternateTitleA-lang'] },
	'alternatetitlea-platform' => { 493 => [\'alternateTitle','alternateTitleA-platform'] },
	'alternatetitletext' => { 493 => [\'alternateTitle','alternateTitleText'] },
	'altitude' => { 196 => 0x6 },
	'alttapename' => { 503 => 'altTapeName' },
	'alttextaccessibility' => { 488 => 'AltTextAccessibility' },
	'alttimecode' => { 503 => 'altTimecode' },
	'alttimecodetimeformat' => { 503 => [\'altTimecode','altTimecodeTimeFormat'] },
	'alttimecodetimevalue' => { 503 => [\'altTimecode','altTimecodeTimeValue'] },
	'alttimecodevalue' => { 503 => [\'altTimecode','altTimecodeValue'] },
	'ambienceselection' => { 4 => 0x1 },
	'ambientinfrared' => { 383 => 0x5c },
	'ambientlight' => { 383 => 0x5e },
	'ambienttemperature' => { 119 => 0x9400, 381 => 0x14, 382 => 0x46, 383 => 0x50, 444 => 0x4, 484 => 'Temperature' },
	'ambienttemperaturefahrenheit' => { 381 => 0x13, 382 => 0x44, 383 => 0x4e },
	'analogbalance' => { 119 => 0xc627 },
	'analogcaptureiso' => { 138 => 0x89e },
	'analogisotable' => { 138 => 0x89d },
	'androidversion' => { 374 => 'com.android.version' },
	'angleadj' => { 103 => 0x10003, 109 => 0x8b },
	'angleinforoll' => { 473 => 'AngleInfoRoll' },
	'angleinfoyaw' => { 473 => 'AngleInfoYaw' },
	'anti-blur' => { 420 => 0xb04b },
	'antialiasstrength' => { 119 => 0xc632 },
	'aperturelock' => { 280 => '38.2', 282 => '38.2', 283 => '38.2', 292 => '38.2', 293 => '38.2', 295 => 0xb8 },
	'aperturemode' => { 380 => 'apmd' },
	'aperturerange' => { 84 => 0x10d },
	'apertureringuse' => { 336 => '1.4' },
	'aperturesetting' => { 184 => 0x7, 407 => 0x30, 408 => 0x29, 409 => 0x1 },
	'aperturevalue' => { 93 => 0x2, 119 => 0x9202, 302 => 0x1002, 364 => 0x401, 483 => 'ApertureValue' },
	'appinfo' => { 457 => 'AppInfo' },
	'appinfoapplication' => { 457 => [\'AppInfo','AppInfoApplication'] },
	'appinfoitemuri' => { 457 => [\'AppInfo','AppInfoItemURI'] },
	'appinfoversion' => { 457 => [\'AppInfo','AppInfoVersion'] },
	'applekeywords' => { 306 => 'AAPL:Keywords' },
	'applephotosvariationidentifier' => { 374 => 'apple.photos.variation-identifier' },
	'applestoreaccount' => { 372 => 'apID' },
	'applestoreaccounttype' => { 372 => 'akID' },
	'applestorecatalogid' => { 372 => 'cnID' },
	'applestorecountry' => { 372 => 'sfID' },
	'applicationkeystring' => { 138 => 0x400 },
	'applicationnotes' => { 119 => 0x2bc, 325 => 0x2bc },
	'applicationrecordversion' => { 131 => 0x0 },
	'applyshootingmeteringmode' => { 84 => 0x10e },
	'approved' => { 485 => 'Approved' },
	'approvedby' => { 485 => 'ApprovedBy' },
	'approximatefnumber' => { 315 => 0x313, 322 => 0x3406 },
	'approximatefocusdistance' => { 474 => 'ApproximateFocusDistance' },
	'appversion' => { 487 => 'AppVersion' },
	'aps-csizecapture' => { 438 => 0x114, 439 => [0x114,0x1eb,0x1ee,0x21a,0x21c] },
	'aquahsl' => { 103 => 0x20914 },
	'armidentifier' => { 132 => 0x78 },
	'armversion' => { 132 => 0x7a },
	'arranger' => { 372 => "\xa9arg", 380 => "\xa9arg" },
	'arrangerkeywords' => { 380 => "\xa9ark" },
	'artdirector' => { 372 => "\xa9ard" },
	'artfilter' => { 297 => 0x529 },
	'artfiltereffect' => { 297 => 0x52f },
	'artist' => { 119 => 0x13b, 310 => 'Artist', 355 => 0x22e, 372 => "\xa9ART", 374 => 'artist', 380 => "\xa9ART", 499 => 'Artist', 503 => 'artist' },
	'artmode' => { 113 => 0x301b },
	'artmodeparameters' => { 113 => 0x310b },
	'artwork' => { 374 => 'artwork' },
	'artworkcircadatecreated' => { 489 => [\'ArtworkOrObject','ArtworkOrObjectAOCircaDateCreated'] },
	'artworkcontentdescription' => { 489 => [\'ArtworkOrObject','ArtworkOrObjectAOContentDescription'] },
	'artworkcontributiondescription' => { 489 => [\'ArtworkOrObject','ArtworkOrObjectAOContributionDescription'] },
	'artworkcopyrightnotice' => { 489 => [\'ArtworkOrObject','ArtworkOrObjectAOCopyrightNotice'] },
	'artworkcopyrightownerid' => { 489 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentCopyrightOwnerId'] },
	'artworkcopyrightownername' => { 489 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentCopyrightOwnerName'] },
	'artworkcreator' => { 489 => [\'ArtworkOrObject','ArtworkOrObjectAOCreator'] },
	'artworkcreatorid' => { 489 => [\'ArtworkOrObject','ArtworkOrObjectAOCreatorId'] },
	'artworkdatecreated' => { 489 => [\'ArtworkOrObject','ArtworkOrObjectAODateCreated'] },
	'artworklicensorid' => { 489 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentLicensorId'] },
	'artworklicensorname' => { 489 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentLicensorName'] },
	'artworkorobject' => { 489 => 'ArtworkOrObject' },
	'artworkphysicaldescription' => { 489 => [\'ArtworkOrObject','ArtworkOrObjectAOPhysicalDescription'] },
	'artworksource' => { 489 => [\'ArtworkOrObject','ArtworkOrObjectAOSource'] },
	'artworksourceinventoryno' => { 489 => [\'ArtworkOrObject','ArtworkOrObjectAOSourceInvNo'] },
	'artworksourceinvurl' => { 489 => [\'ArtworkOrObject','ArtworkOrObjectAOSourceInvURL'] },
	'artworkstyleperiod' => { 489 => [\'ArtworkOrObject','ArtworkOrObjectAOStylePeriod'] },
	'artworktitle' => { 489 => [\'ArtworkOrObject','ArtworkOrObjectAOTitle'] },
	'aspectframe' => { 301 => 0x1113 },
	'aspectratio' => { 5 => 0x0, 301 => 0x1112, 355 => 0x80, 407 => 0x55, 408 => 0x55, 409 => 0xa },
	'assetid' => { 467 => 'AssetID' },
	'asshoticcprofile' => { 119 => 0xc68f },
	'asshotneutral' => { 119 => 0xc628 },
	'asshotpreprofilematrix' => { 119 => 0xc690 },
	'asshotprofilename' => { 119 => 0xc6f6 },
	'asshotwhitexy' => { 119 => 0xc629 },
	'assignbktbutton' => { 279 => '4.2', 280 => '16.1', 282 => '16.1', 283 => '16.1', 292 => '16.1', 293 => '16.1' },
	'assignfuncbutton' => { 84 => 0x70b },
	'assignmb-d17af-onbutton' => { 283 => '79.1' },
	'assignmb-d17funcbutton' => { 283 => '67.1' },
	'assignmb-d17funcbuttonplusdials' => { 283 => '68.1' },
	'assignmb-d18af-onbutton' => { 293 => '79.1' },
	'assignmb-d18funcbutton' => { 293 => '67.1' },
	'assignmb-d18funcbuttonplusdials' => { 293 => '68.1' },
	'assignmoviefunc1buttonplusdials' => { 282 => '75.1', 283 => '75.1', 293 => '75.1' },
	'assignmoviefunc2button' => { 282 => '82.1', 283 => '82.1', 293 => '82.1' },
	'assignmoviepreviewbuttonplusdials' => { 282 => '75.2', 283 => '75.2', 293 => '75.2' },
	'assignmovierecordbutton' => { 280 => '43.2', 292 => '45.1', 295 => 0x9b },
	'assignmovierecordbuttonplusdials' => { 282 => '45.1', 283 => '45.1', 293 => '45.1' },
	'assignmoviesubselector' => { 282 => '74.1', 283 => '74.1', 293 => '74.1' },
	'assignmoviesubselectorplusdials' => { 282 => '76.1', 283 => '76.1', 293 => '76.1' },
	'assignremotefnbutton' => { 280 => '54.1', 292 => '51.1' },
	'assistbuttonfunction' => { 82 => 0xd },
	'atcaptureusercrop' => { 138 => 0x943 },
	'attributionname' => { 475 => 'attributionName' },
	'attributionurl' => { 475 => 'attributionURL' },
	'audio' => { 320 => 0x20 },
	'audiobitrate' => { 67 => 0x6c, 489 => 'audioBitRate' },
	'audiobitratemode' => { 489 => 'audioBitRateMode' },
	'audiobitspersample' => { 489 => 'audioBitsPerSample' },
	'audiobutton' => { 295 => 0x17b },
	'audiobuttonplaybackmode' => { 295 => 0x1b9 },
	'audiochannelcount' => { 489 => 'audioChannelCount' },
	'audiochannels' => { 67 => 0x70 },
	'audiochanneltype' => { 503 => 'audioChannelType' },
	'audiocompression' => { 84 => 0x816, 155 => 'Compression' },
	'audiocompressor' => { 503 => 'audioCompressor' },
	'audiodata' => { 459 => 'Data' },
	'audioduration' => { 131 => 0x99 },
	'audiogain' => { 374 => 'player.movie.audio.gain' },
	'audiomimetype' => { 459 => 'Mime' },
	'audiomoddate' => { 503 => 'audioModDate' },
	'audiooutcue' => { 131 => 0x9a },
	'audiosamplerate' => { 67 => 0x6e, 503 => 'audioSampleRate' },
	'audiosampletype' => { 503 => 'audioSampleType' },
	'audiosamplingrate' => { 131 => 0x97 },
	'audiosamplingresolution' => { 131 => 0x98 },
	'audiotype' => { 131 => 0x96 },
	'author' => { 157 => 'Author', 306 => 'Author', 310 => 'Author', 371 => 'Author', 372 => ['auth',"\xa9aut"], 374 => 'author', 380 => 'auth', 472 => 'author', 490 => 'Author', 501 => 'Author' },
	'authorsposition' => { 491 => 'AuthorsPosition' },
	'authorurl' => { 179 => 'WM/AuthorURL' },
	'autoafpointcolortracking' => { 84 => 0x51c },
	'autoafpointseleositraf' => { 2 => 0xa },
	'autoaperture' => { 346 => '0.1' },
	'autobracket' => { 397 => 0x19 },
	'autobracketing' => { 127 => 0x1100, 355 => 0x18, 387 => 0x1007 },
	'autobracketingmode' => { 291 => '12.3' },
	'autobracketingset' => { 291 => '12.1' },
	'autobracketmodem' => { 279 => '21.2', 280 => '13.3', 282 => '13.2', 283 => '13.2', 288 => '26.2', 292 => '13.3', 293 => '13.2', 295 => 0x5f },
	'autobracketorder' => { 184 => 0x43, 279 => '21.3', 280 => '13.2', 282 => '13.1', 283 => '13.1', 288 => '26.3', 289 => '12.2', 290 => '2.2', 291 => '12.2', 292 => '13.2', 293 => '13.1', 294 => '13.2', 295 => 0x61 },
	'autobracketset' => { 279 => '21.1', 280 => '13.1', 284 => '11.1', 285 => '12.1', 286 => '12.1', 288 => '26.1', 289 => '12.1', 290 => '2.1', 292 => '13.1', 294 => '13.1' },
	'autobrightness' => { 477 => 'AutoBrightness', 479 => 'AutoBrightness' },
	'autocontrast' => { 477 => 'AutoContrast', 479 => 'AutoContrast' },
	'autodistortioncontrol' => { 206 => 0x4, 228 => 0x143 },
	'autodynamicrange' => { 127 => 0x140b },
	'autoexposure' => { 477 => 'AutoExposure', 479 => 'AutoExposure' },
	'autoexposurebracketing' => { 77 => 0x10 },
	'autoflashisosensitivity' => { 282 => '38.5', 283 => '38.5', 293 => '38.5', 295 => 0x5b },
	'autofocus' => { 300 => 0x209 },
	'autofocusmoderestrictions' => { 295 => 0x107 },
	'autofp' => { 290 => '7.3', 294 => '31.4' },
	'autoiso' => { 77 => 0x1, 113 => 0x3008, 229 => 0x142, 281 => '1.1', 290 => '1.1' },
	'autoisomax' => { 281 => '1.2', 290 => '1.2' },
	'autoisominshutterspeed' => { 281 => '1.3', 290 => '1.3' },
	'autolateralca' => { 477 => 'AutoLateralCA', 479 => 'AutoLateralCA' },
	'autolightingoptimizer' => { 16 => 0xbe, 17 => 0xbf, 20 => 0xbf, 62 => 0x2, 84 => 0x204, 103 => 0x20500, 109 => 0x6f },
	'autolightingoptimizeron' => { 103 => '0x20500.0', 109 => 0x6e },
	'autoportraitframed' => { 420 => 0x2016 },
	'autoredeye' => { 272 => 0xfe28a44f },
	'autorotate' => { 77 => 0x1b },
	'autoshadows' => { 477 => 'AutoShadows', 479 => 'AutoShadows' },
	'autotone' => { 477 => 'AutoTone', 479 => 'AutoTone' },
	'autotonedigest' => { 477 => 'AutoToneDigest', 479 => 'AutoToneDigest' },
	'autotonedigestnosat' => { 477 => 'AutoToneDigestNoSat', 479 => 'AutoToneDigestNoSat' },
	'autowhiteversion' => { 477 => 'AutoWhiteVersion', 479 => 'AutoWhiteVersion' },
	'auxiliarylens' => { 226 => 0x82 },
	'avaperturesetting' => { 336 => 0x13 },
	'averageblacklevel' => { 45 => 0xe7, 47 => 0xfb, 48 => 0x114, 49 => 0x146 },
	'averagelv' => { 187 => 0x38 },
	'avsettingwithoutlens' => { 84 => 0x707 },
	'azimuth' => { 165 => 'Azimuth' },
	'babyage' => { 320 => [0x8010,0x33] },
	'babyname' => { 320 => 0x66 },
	'backgroundalpha' => { 498 => 'bgalpha' },
	'balance' => { 374 => 'player.movie.audio.balance' },
	'baseexposurecompensation' => { 336 => 0x15 },
	'baseiso' => { 77 => 0x2, 97 => 0x101c, 138 => 0x903, 322 => 0x312a, 450 => 0x6 },
	'baseisodaylight' => { 138 => 0x910 },
	'baseisoflash' => { 138 => 0x913 },
	'baseisofluorescent' => { 138 => 0x912 },
	'baseisotungsten' => { 138 => 0x911 },
	'baselineexposure' => { 119 => 0xc62a },
	'baselineexposureoffset' => { 119 => 0xc7a5 },
	'baselinenoise' => { 119 => 0xc62b },
	'baselinesharpness' => { 119 => 0xc62c },
	'baseurl' => { 501 => 'BaseURL' },
	'bass' => { 374 => 'player.movie.audio.bass' },
	'batterylevel' => { 320 => 0x38, 407 => 0x51, 411 => 0xc, 412 => 0x4, 413 => 0x4, 451 => 0x7 },
	'batterylevelgrip1' => { 451 => 0x6 },
	'batterylevelgrip2' => { 451 => 0x8 },
	'batteryorder' => { 279 => '12.5', 288 => '13.2', 289 => '2.1', 292 => '3.1' },
	'batterystate' => { 184 => 0x60, 407 => 0x50, 413 => 0x14 },
	'batterytemperature' => { 411 => 0x1, 413 => 0x2, 451 => 0x5 },
	'batterytype' => { 64 => 0x38, 383 => 0x66 },
	'batteryunknown' => { 411 => 0x2, 413 => 0x0 },
	'batteryvoltage' => { 138 => 0x408, 381 => 0x2a, 382 => 0x49, 383 => 0x62, 411 => 0x8 },
	'batteryvoltage1' => { 413 => 0x6 },
	'batteryvoltage2' => { 413 => 0x8 },
	'batteryvoltageavg' => { 383 => 0x64 },
	'bayergreensplit' => { 119 => 0xc62d },
	'bayerpattern' => { 137 => 0xf902, 188 => 0x17 },
	'beatsperminute' => { 372 => 'tmpo' },
	'beatspliceparams' => { 503 => 'beatSpliceParams' },
	'beatspliceparamsriseindecibel' => { 503 => [\'beatSpliceParams','beatSpliceParamsRiseInDecibel'] },
	'beatspliceparamsriseintimeduration' => { 503 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDuration'] },
	'beatspliceparamsriseintimedurationscale' => { 503 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDurationScale'] },
	'beatspliceparamsriseintimedurationvalue' => { 503 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDurationValue'] },
	'beatspliceparamsusefilebeatsmarker' => { 503 => [\'beatSpliceParams','beatSpliceParamsUseFileBeatsMarker'] },
	'beep' => { 279 => '13.1', 280 => '5.4', 281 => '0.1', 284 => '2.1', 285 => '3.1', 286 => '3.1', 288 => '10.1', 290 => '0.1', 292 => '5.5', 294 => '4.1' },
	'beeppitch' => { 289 => '3.1' },
	'beepvolume' => { 289 => '4.5' },
	'bestqualityscale' => { 119 => 0xc65c },
	'bestshotmode' => { 113 => 0x3007 },
	'bitdepth' => { 162 => 'BitDepth', 188 => 0x11, 237 => 0x41 },
	'bitspercomponent' => { 133 => 0x87 },
	'bitspersample' => { 119 => 0x102, 325 => 0xa, 499 => 'BitsPerSample' },
	'blackacquirerows' => { 138 => 0x18ba },
	'blacklevel' => { 119 => 0xc61a, 204 => 0x20, 226 => 0x3d, 302 => [0x401,0x1012], 364 => 0x21d },
	'blacklevel2' => { 301 => 0x600, 305 => 0x600 },
	'blacklevelblue' => { 325 => 0x1e },
	'blacklevelbottom' => { 138 => 0x3f0 },
	'blackleveldata' => { 364 => 0x223 },
	'blackleveldeltah' => { 119 => 0xc61b },
	'blackleveldeltav' => { 119 => 0xc61c },
	'blacklevelgreen' => { 325 => 0x1d },
	'blacklevelred' => { 325 => 0x1c },
	'blacklevelrepeatdim' => { 119 => 0xc619 },
	'blacklevelrough' => { 138 => 0x40e },
	'blacklevelroughafter' => { 138 => 0x416 },
	'blacklevels' => { 35 => 0x1d },
	'blackleveltop' => { 138 => 0x3ef },
	'blackpoint' => { 355 => 0x200 },
	'blacks2012' => { 477 => 'Blacks2012', 479 => 'Blacks2012' },
	'blacksadj' => { 454 => 0x9018 },
	'bleachbypasstoning' => { 355 => 0x7f },
	'blockshotafresponse' => { 282 => '1.5', 283 => '1.5', 293 => '1.5', 295 => 0x7 },
	'blogtitle' => { 493 => 'blogTitle' },
	'blogurl' => { 493 => 'blogURL' },
	'bluebalance' => { 302 => 0x1018, 325 => 0x12, 355 => 0x1b },
	'bluecurvelimits' => { 108 => 0x1fe },
	'bluecurvepoints' => { 107 => 0x79, 108 => 0x1d4 },
	'bluehsl' => { 103 => 0x20915 },
	'bluehue' => { 477 => 'BlueHue', 479 => 'BlueHue' },
	'bluesaturation' => { 477 => 'BlueSaturation', 479 => 'BlueSaturation' },
	'bluratinfinity' => { 463 => 'BlurAtInfinity' },
	'blurcontrol' => { 355 => 0x82 },
	'blurwarning' => { 127 => 0x1300 },
	'bodybatteryadload' => { 334 => 0x3 },
	'bodybatteryadnoload' => { 334 => 0x2 },
	'bodybatterystate' => { 334 => '1.1' },
	'bodybatteryvoltage1' => { 334 => 0x2 },
	'bodybatteryvoltage2' => { 334 => 0x4 },
	'bodybatteryvoltage3' => { 334 => 0x6 },
	'bodybatteryvoltage4' => { 334 => 0x8 },
	'bodyfirmware' => { 388 => 0x0 },
	'bodyfirmwareversion' => { 298 => 0x104, 299 => 0x100, 302 => 0x104 },
	'bodyserialnumber' => { 388 => 0x10 },
	'bookedition' => { 493 => 'bookEdition' },
	'bootloaderversion' => { 382 => 0x26 },
	'bracketincrement' => { 229 => 0x21a },
	'bracketmode' => { 57 => 0x3 },
	'bracketprogram' => { 229 => 0x218 },
	'bracketsequence' => { 113 => 0x301d },
	'bracketset' => { 229 => 0x216 },
	'bracketsettings' => { 320 => 0x45 },
	'bracketshotnumber' => { 57 => 0x5, 336 => 0x9, 418 => 0x2b },
	'bracketshotnumber2' => { 418 => 0x2d },
	'bracketstep' => { 181 => 0xe },
	'bracketvalue' => { 57 => 0x4 },
	'brightness' => { 119 => 0xfe53, 156 => 'Brightness', 176 => 'Brightness', 181 => 0x2c, 231 => 0x34, 232 => 0x39, 233 => 0x41, 374 => 'player.movie.visual.brightness', 381 => 0x25, 383 => 0x54, 407 => 0x22, 420 => 0x2007, 477 => 'Brightness', 479 => 'Brightness' },
	'brightnessadj' => { 108 => 0x114, 265 => 0x0, 275 => 0x2d, 454 => 0x8018 },
	'brightnessvalue' => { 119 => 0x9203, 187 => [0x691,0x49c3], 302 => 0x1003, 425 => 0x1e, 428 => 0x1140, 429 => 0x1140, 430 => 0x111c, 431 => 0x1198, 432 => 0x1174, 433 => 0x102c, 434 => 0x224, 435 => 0x224, 436 => 0x219, 483 => 'BrightnessValue' },
	'buildnumber' => { 191 => 0x5500 },
	'bulbduration' => { 77 => 0x18 },
	'burstcount' => { 138 => 0x40d },
	'burstid' => { 460 => 'BurstID' },
	'burstmode' => { 140 => 0xa, 320 => 0x2a },
	'burstmode2' => { 140 => 0x18 },
	'burstprimary' => { 460 => 'BurstPrimary' },
	'burstshot' => { 397 => 0x34 },
	'burstspeed' => { 320 => 0x77 },
	'burstuuid' => { 1 => 0xb },
	'buttonfunctioncontroloff' => { 84 => 0x70a },
	'bwadjustment' => { 127 => 0x1049 },
	'bwfilter' => { 181 => 0x2a, 189 => 0x39 },
	'bwmode' => { 302 => 0x203 },
	'by-line' => { 131 => 0x50 },
	'by-linetitle' => { 131 => 0x55 },
	'bytecount' => { 493 => 'byteCount' },
	'c14configuration' => { 138 => 0x1964 },
	'cacheversion' => { 119 => 0xc7aa },
	'calibratedfocallength' => { 116 => 'CalibratedFocalLength' },
	'calibratedopticalcenterx' => { 116 => 'CalibratedOpticalCenterX' },
	'calibratedopticalcentery' => { 116 => 'CalibratedOpticalCenterY' },
	'calibration' => { 397 => [0x24,0x30] },
	'calibrationhistory' => { 138 => 0x9c9 },
	'calibrationilluminant1' => { 119 => 0xc65a },
	'calibrationilluminant2' => { 119 => 0xc65b },
	'calibrationilluminant3' => { 119 => 0xcd31 },
	'calibrationversion' => { 138 => 0x9c6 },
	'callforimage' => { 467 => 'CallForImage' },
	'camera' => { 457 => [\'Cameras','CamerasCamera'] },
	'cameraangle' => { 380 => 'angl', 503 => 'cameraAngle' },
	'cameraappinfo' => { 457 => [\'Cameras','CamerasCameraAppInfo'] },
	'cameraappinfoapplication' => { 457 => [\'Cameras','CamerasCameraAppInfoApplication'] },
	'cameraappinfoitemuri' => { 457 => [\'Cameras','CamerasCameraAppInfoItemURI'] },
	'cameraappinfoversion' => { 457 => [\'Cameras','CamerasCameraAppInfoVersion'] },
	'cameraburstid' => { 461 => 'CameraBurstID' },
	'cameracalibration' => { 397 => 0x11f },
	'cameracalibration1' => { 119 => 0xc623 },
	'cameracalibration2' => { 119 => 0xc624 },
	'cameracalibration3' => { 119 => 0xcd32 },
	'cameracalibrationsig' => { 119 => 0xc6f3 },
	'cameracolorcalibration01' => { 36 => 0x0, 37 => 0x0 },
	'cameracolorcalibration02' => { 36 => 0x4, 37 => 0x5 },
	'cameracolorcalibration03' => { 36 => 0x8, 37 => 0xa },
	'cameracolorcalibration04' => { 36 => 0xc, 37 => 0xf },
	'cameracolorcalibration05' => { 36 => 0x10, 37 => 0x14 },
	'cameracolorcalibration06' => { 36 => 0x14, 37 => 0x19 },
	'cameracolorcalibration07' => { 36 => 0x18, 37 => 0x1e },
	'cameracolorcalibration08' => { 36 => 0x1c, 37 => 0x23 },
	'cameracolorcalibration09' => { 36 => 0x20, 37 => 0x28 },
	'cameracolorcalibration10' => { 36 => 0x24, 37 => 0x2d },
	'cameracolorcalibration11' => { 36 => 0x28, 37 => 0x32 },
	'cameracolorcalibration12' => { 36 => 0x2c, 37 => 0x37 },
	'cameracolorcalibration13' => { 36 => 0x30, 37 => 0x3c },
	'cameracolorcalibration14' => { 36 => 0x34, 37 => 0x41 },
	'cameracolorcalibration15' => { 36 => 0x38, 37 => 0x46 },
	'cameradepthmap' => { 457 => [\'Cameras','CamerasCameraDepthMap'] },
	'cameradepthmapconfidenceuri' => { 457 => [\'Cameras','CamerasCameraDepthMapConfidenceURI'] },
	'cameradepthmapdepthuri' => { 457 => [\'Cameras','CamerasCameraDepthMapDepthURI'] },
	'cameradepthmapfar' => { 457 => [\'Cameras','CamerasCameraDepthMapFar'] },
	'cameradepthmapfocaltable' => { 457 => [\'Cameras','CamerasCameraDepthMapFocalTable'] },
	'cameradepthmapfocaltableentrycount' => { 457 => [\'Cameras','CamerasCameraDepthMapFocalTableEntryCount'] },
	'cameradepthmapformat' => { 457 => [\'Cameras','CamerasCameraDepthMapFormat'] },
	'cameradepthmapitemsemantic' => { 457 => [\'Cameras','CamerasCameraDepthMapItemSemantic'] },
	'cameradepthmapmeasuretype' => { 457 => [\'Cameras','CamerasCameraDepthMapMeasureType'] },
	'cameradepthmapnear' => { 457 => [\'Cameras','CamerasCameraDepthMapNear'] },
	'cameradepthmapsoftware' => { 457 => [\'Cameras','CamerasCameraDepthMapSoftware'] },
	'cameradepthmapunits' => { 457 => [\'Cameras','CamerasCameraDepthMapUnits'] },
	'cameradirection' => { 374 => 'direction.facing' },
	'camerae-mountversion' => { 453 => 0xb },
	'cameraelevationangle' => { 119 => 0x9405, 484 => 'CameraElevationAngle' },
	'camerafilename' => { 467 => 'CameraFilename' },
	'cameraid' => { 302 => 0x209, 380 => 'cmid', 396 => 0x209 },
	'cameraidentifier' => { 374 => 'camera.identifier' },
	'cameraimage' => { 457 => [\'Cameras','CamerasCameraImage'] },
	'cameraimageitemsemantic' => { 457 => [\'Cameras','CamerasCameraImageItemSemantic'] },
	'cameraimageitemuri' => { 457 => [\'Cameras','CamerasCameraImageItemURI'] },
	'cameraimagingmodel' => { 457 => [\'Cameras','CamerasCameraImagingModel'] },
	'cameraimagingmodeldistortion' => { 457 => [\'Cameras','CamerasCameraImagingModelDistortion'] },
	'cameraimagingmodeldistortioncount' => { 457 => [\'Cameras','CamerasCameraImagingModelDistortionCount'] },
	'cameraimagingmodelfocallengthx' => { 457 => [\'Cameras','CamerasCameraImagingModelFocalLengthX'] },
	'cameraimagingmodelfocallengthy' => { 457 => [\'Cameras','CamerasCameraImagingModelFocalLengthY'] },
	'cameraimagingmodelimageheight' => { 457 => [\'Cameras','CamerasCameraImagingModelImageHeight'] },
	'cameraimagingmodelimagewidth' => { 457 => [\'Cameras','CamerasCameraImagingModelImageWidth'] },
	'cameraimagingmodelpixelaspectratio' => { 457 => [\'Cameras','CamerasCameraImagingModelPixelAspectRatio'] },
	'cameraimagingmodelprincipalpointx' => { 457 => [\'Cameras','CamerasCameraImagingModelPrincipalPointX'] },
	'cameraimagingmodelprincipalpointy' => { 457 => [\'Cameras','CamerasCameraImagingModelPrincipalPointY'] },
	'cameraimagingmodelskew' => { 457 => [\'Cameras','CamerasCameraImagingModelSkew'] },
	'cameraiso' => { 34 => 0x10 },
	'cameralabel' => { 119 => 0xc7a1, 503 => 'cameraLabel' },
	'cameralightestimate' => { 457 => [\'Cameras','CamerasCameraLightEstimate'] },
	'cameralightestimatecolorcorrectionb' => { 457 => [\'Cameras','CamerasCameraLightEstimateColorCorrectionB'] },
	'cameralightestimatecolorcorrectiong' => { 457 => [\'Cameras','CamerasCameraLightEstimateColorCorrectionG'] },
	'cameralightestimatecolorcorrectionr' => { 457 => [\'Cameras','CamerasCameraLightEstimateColorCorrectionR'] },
	'cameralightestimatepixelintensity' => { 457 => [\'Cameras','CamerasCameraLightEstimatePixelIntensity'] },
	'cameramakemodel' => { 467 => 'CameraMakeModel' },
	'cameramodel' => { 364 => 0x410, 503 => 'cameraModel' },
	'cameramodelid' => { 176 => 'CameraModelID' },
	'cameramodelrestriction' => { 477 => 'CameraModelRestriction', 479 => 'CameraModelRestriction' },
	'cameramotion' => { 374 => 'direction.motion' },
	'cameramove' => { 503 => 'cameraMove' },
	'cameraorientation' => { 7 => 0x30, 9 => 0x7d, 11 => 0x30, 13 => 0x35, 14 => 0x30, 15 => 0x30, 16 => 0x31, 17 => 0x31, 18 => 0x35, 19 => 0x27, 20 => 0x31, 21 => 0x7d, 22 => 0x38, 23 => [0x36,0x3a], 24 => 0x7d, 25 => 0x83, 26 => 0x84, 27 => 0x96, 28 => 0x35, 29 => 0x96, 320 => 0x8f, 359 => 0x1, 364 => 0x100, 413 => [0x16,0x18], 441 => 0x28, 442 => 0x24, 443 => 0x29 },
	'cameraowner' => { 141 => 0xc353 },
	'cameraparameters' => { 302 => 0x2050 },
	'camerapicturestyle' => { 28 => 0xaf },
	'camerapitch' => { 115 => 0x9, 380 => "\xa9gpt" },
	'camerapointcloud' => { 457 => [\'Cameras','CamerasCameraPointCloud'] },
	'camerapointcloudmetric' => { 457 => [\'Cameras','CamerasCameraPointCloudMetric'] },
	'camerapointcloudpointcloud' => { 457 => [\'Cameras','CamerasCameraPointCloudPointCloud'] },
	'camerapointcloudpoints' => { 457 => [\'Cameras','CamerasCameraPointCloudPoints'] },
	'camerapose' => { 457 => [\'Cameras','CamerasCameraPose'] },
	'cameraposepositionx' => { 457 => [\'Cameras','CamerasCameraPosePositionX'] },
	'cameraposepositiony' => { 457 => [\'Cameras','CamerasCameraPosePositionY'] },
	'cameraposepositionz' => { 457 => [\'Cameras','CamerasCameraPosePositionZ'] },
	'cameraposerotationw' => { 457 => [\'Cameras','CamerasCameraPoseRotationW'] },
	'cameraposerotationx' => { 457 => [\'Cameras','CamerasCameraPoseRotationX'] },
	'cameraposerotationy' => { 457 => [\'Cameras','CamerasCameraPoseRotationY'] },
	'cameraposerotationz' => { 457 => [\'Cameras','CamerasCameraPoseRotationZ'] },
	'cameraposetimestamp' => { 457 => [\'Cameras','CamerasCameraPoseTimestamp'] },
	'cameraprofile' => { 477 => 'CameraProfile', 479 => 'CameraProfile' },
	'cameraprofiledigest' => { 477 => 'CameraProfileDigest', 479 => 'CameraProfileDigest' },
	'camerarawcolortone' => { 109 => 0xe1 },
	'camerarawcontrast' => { 109 => 0xe3 },
	'camerarawhighlightpoint' => { 109 => 0xe6 },
	'camerarawlinear' => { 109 => 0xe4 },
	'camerarawoutputhighlightpoint' => { 109 => 0xe8 },
	'camerarawoutputshadowpoint' => { 109 => 0xe9 },
	'camerarawsaturation' => { 109 => 0xe2 },
	'camerarawshadowpoint' => { 109 => 0xe7 },
	'camerarawsharpness' => { 109 => 0xe5 },
	'cameraroll' => { 115 => 0xb, 380 => "\xa9grl" },
	'cameras' => { 457 => 'Cameras' },
	'cameraserialnumber' => { 119 => 0xc62f, 178 => 'CameraSerialNumber', 467 => 'CameraSerialNumber' },
	'camerasettingsversion' => { 297 => 0x0 },
	'cameratemperature' => { 7 => 0x18, 9 => 0x1b, 11 => 0x18, 13 => 0x19, 14 => 0x18, 15 => 0x18, 16 => 0x19, 17 => 0x19, 18 => 0x19, 19 => 0x17, 20 => 0x19, 21 => 0x1b, 22 => 0x19, 23 => 0x19, 24 => 0x1b, 25 => 0x1b, 26 => 0x1b, 27 => 0x1b, 28 => 0x19, 29 => 0x1b, 30 => [0x87,0x91], 31 => [0x99,0x9f,0xa4,0xa8,0x105], 33 => ['-3',0x64,0x47,0x53,0x5b,0x5c], 77 => 0xc, 138 => 0x406, 301 => 0x1306, 315 => 0x320, 322 => 0x3402, 355 => 0x47, 394 => 0x43, 445 => 0x5 },
	'cameratemperature4' => { 360 => 0x14 },
	'cameratemperature5' => { 360 => 0x16 },
	'cameratemperaturerangemax' => { 121 => 0x5 },
	'cameratemperaturerangemin' => { 121 => 0x6 },
	'cameratrait' => { 457 => [\'Cameras','CamerasCameraTrait'] },
	'cameratype' => { 77 => 0x1a, 302 => 0x207 },
	'cameratype2' => { 298 => 0x100 },
	'cameravendorinfo' => { 457 => [\'Cameras','CamerasCameraVendorInfo'] },
	'cameravendorinfomanufacturer' => { 457 => [\'Cameras','CamerasCameraVendorInfoManufacturer'] },
	'cameravendorinfomodel' => { 457 => [\'Cameras','CamerasCameraVendorInfoModel'] },
	'cameravendorinfonotes' => { 457 => [\'Cameras','CamerasCameraVendorInfoNotes'] },
	'camerayaw' => { 115 => 0xa, 380 => "\xa9gyw" },
	'camreverse' => { 116 => 'CamReverse' },
	'canondr4' => { 120 => 'CanonDR4' },
	'canonexposuremode' => { 34 => 0x14 },
	'canonfiledescription' => { 97 => 0x805 },
	'canonfilelength' => { 64 => 0xe },
	'canonfirmwareversion' => { 64 => 0x7, 97 => 0x80b },
	'canonflashinfo' => { 97 => 0x1028 },
	'canonflashmode' => { 34 => 0x4 },
	'canonimagesize' => { 10 => 0x39, 34 => 0xa },
	'canonimagetype' => { 64 => 0x6, 97 => 0x815 },
	'canonlogversion' => { 63 => 0xb },
	'canonmodelid' => { 64 => 0x10, 97 => 0x1834 },
	'canonvrd' => { 120 => 'CanonVRD' },
	'caption' => { 472 => 'caption' },
	'caption-abstract' => { 131 => 0x78 },
	'captionsauthornames' => { 482 => 'CaptionsAuthorNames' },
	'captionsdatetimestamps' => { 482 => 'CaptionsDateTimeStamps' },
	'captionwriter' => { 491 => 'CaptionWriter' },
	'captureframerate' => { 113 => 0x4001 },
	'captureheightnormal' => { 138 => 0x1839 },
	'capturelook' => { 138 => 0xc48 },
	'capturemode' => { 374 => 'com.apple.photos.captureMode' },
	'capturesoftware' => { 465 => 'CaptureSoftware' },
	'capturewidthnormal' => { 138 => 0x1838 },
	'capturewidthtest' => { 138 => 0x1842 },
	'cardshutterlock' => { 184 => 0x49 },
	'casioimagesize' => { 113 => 0x9 },
	'catalogsets' => { 131 => 0xff, 458 => 'CatalogSets', 470 => 'CatalogSets' },
	'categories' => { 64 => 0x23, 472 => 'categories' },
	'category' => { 131 => 0xf, 179 => 'WM/Category', 296 => 0x30, 372 => 'catg', 491 => 'Category' },
	'cbcrgain' => { 394 => 0xa036 },
	'cbcrgaindefault' => { 394 => 0xa035 },
	'cbcrmatrix' => { 394 => 0xa034 },
	'cbcrmatrixdefault' => { 394 => 0xa033 },
	'ccdboardversion' => { 315 => 0x331 },
	'ccdscanmode' => { 302 => 0x1039 },
	'ccdsensitivity' => { 262 => 0x6 },
	'ccdversion' => { 315 => 0x330 },
	'cellglobalid' => { 476 => 'cgi' },
	'celllength' => { 119 => 0x109 },
	'cellr' => { 476 => 'r' },
	'celltowerid' => { 476 => 'cellid' },
	'cellwidth' => { 119 => 0x108 },
	'centerafarea' => { 290 => '15.1' },
	'centerfocuspoint' => { 294 => '2.2' },
	'centerpixel' => { 138 => 0x40c },
	'centerweightedareasize' => { 279 => '7.1', 280 => '8.1', 282 => '8.1', 283 => '8.1', 287 => '7.1', 288 => '5.1', 289 => '7.1', 290 => '6.3', 292 => '8.1', 293 => '8.1', 294 => '8.1', 295 => 0x1f },
	'certificate' => { 507 => 'Certificate' },
	'cfainterpolationalgorithm' => { 138 => 0xe60 },
	'cfainterpolationmetric' => { 138 => 0xe61 },
	'cfaoffsetcols' => { 138 => 0xc71 },
	'cfaoffsetrows' => { 138 => 0xc6f },
	'cfapattern' => { 119 => 0xa302, 325 => 0x9, 483 => 'CFAPattern' },
	'cfapattern2' => { 119 => 0x828e },
	'cfapatterncolumns' => { 483 => [\'CFAPattern','CFAPatternColumns'] },
	'cfapatternrows' => { 483 => [\'CFAPattern','CFAPatternRows'] },
	'cfapatternvalues' => { 483 => [\'CFAPattern','CFAPatternValues'] },
	'cfarepeatpatterndim' => { 119 => 0x828d },
	'cfazipperfixthreshold' => { 138 => 0xe62 },
	'channel' => { 493 => 'channel' },
	'channela-lang' => { 493 => [\'channel','channelA-lang'] },
	'channelchannel' => { 493 => [\'channel','channelChannel'] },
	'channels' => { 155 => 'Channels' },
	'channelsubchannel1' => { 493 => [\'channel','channelSubchannel1'] },
	'channelsubchannel2' => { 493 => [\'channel','channelSubchannel2'] },
	'channelsubchannel3' => { 493 => [\'channel','channelSubchannel3'] },
	'channelsubchannel4' => { 493 => [\'channel','channelSubchannel4'] },
	'chapterlist' => { 380 => 'chpl' },
	'checkmark' => { 103 => 0x10101, 108 => 0x26a },
	'checkmark2' => { 109 => 0x8e },
	'childfontfiles' => { 508 => [\'Fonts','FontsChildFontFiles'] },
	'chmodeshootingspeed' => { 279 => '10.3', 280 => '11.2', 295 => 0x10b },
	'chromablurradius' => { 119 => 0xc631 },
	'chromanoisecolorspace' => { 138 => 0xe6d },
	'chromanoiseedgemapthresh' => { 138 => 0xe6c },
	'chromanoisehighfthresh' => { 138 => 0xe6a },
	'chromanoiselowfthresh' => { 138 => 0xe6b },
	'chromaticaberration' => { 103 => 0x20703, 109 => 0x66, 394 => 0xa051 },
	'chromaticaberrationb' => { 477 => 'ChromaticAberrationB', 479 => 'ChromaticAberrationB' },
	'chromaticaberrationblue' => { 103 => 0x20708, 109 => 0x6b },
	'chromaticaberrationcorr' => { 79 => [0x4,0x5] },
	'chromaticaberrationcorrection' => { 119 => 0x7034, 345 => 0x1, 454 => 0x900d },
	'chromaticaberrationcorrparams' => { 119 => 0x7035, 449 => 0x66a, 450 => [0x37c,0x384,0x39c,0x3b0,0x3b8] },
	'chromaticaberrationon' => { 103 => '0x20703.0', 109 => 0x62 },
	'chromaticaberrationr' => { 477 => 'ChromaticAberrationR', 479 => 'ChromaticAberrationR' },
	'chromaticaberrationred' => { 103 => 0x20707, 109 => 0x6a },
	'chromaticaberrationsetting' => { 80 => 0x6 },
	'chrominancenoisereduction' => { 103 => 0x20601, 109 => 0x5e, 397 => 0x1a },
	'chrominancenr_tiff_jpeg' => { 109 => 0x60 },
	'circadatecreated' => { 489 => 'CircaDateCreated' },
	'circgradbasedcorractive' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionActive'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionActive'] },
	'circgradbasedcorramount' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionAmount'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionAmount'] },
	'circgradbasedcorrblacks2012' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalBlacks2012'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalBlacks2012'] },
	'circgradbasedcorrbrightness' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalBrightness'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalBrightness'] },
	'circgradbasedcorrclarity' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity'] },
	'circgradbasedcorrclarity2012' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity2012'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity2012'] },
	'circgradbasedcorrcontrast' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast'] },
	'circgradbasedcorrcontrast2012' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast2012'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast2012'] },
	'circgradbasedcorrcorrectionname' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionName'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionName'] },
	'circgradbasedcorrcorrectionsyncid' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionSyncID'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionSyncID'] },
	'circgradbasedcorrdefringe' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalDefringe'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalDefringe'] },
	'circgradbasedcorrdehaze' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalDehaze'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalDehaze'] },
	'circgradbasedcorrexposure' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure'] },
	'circgradbasedcorrexposure2012' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure2012'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure2012'] },
	'circgradbasedcorrhighlights2012' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalHighlights2012'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalHighlights2012'] },
	'circgradbasedcorrhue' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalHue'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalHue'] },
	'circgradbasedcorrluminancenoise' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalLuminanceNoise'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalLuminanceNoise'] },
	'circgradbasedcorrmaskalpha' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAlpha'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAlpha'] },
	'circgradbasedcorrmaskangle' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAngle'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAngle'] },
	'circgradbasedcorrmaskbottom' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksBottom'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksBottom'] },
	'circgradbasedcorrmaskcentervalue' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterValue'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterValue'] },
	'circgradbasedcorrmaskcenterweight' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterWeight'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterWeight'] },
	'circgradbasedcorrmaskdabs' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksDabs'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksDabs'] },
	'circgradbasedcorrmaskfeather' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFeather'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFeather'] },
	'circgradbasedcorrmaskflipped' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlipped'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlipped'] },
	'circgradbasedcorrmaskflow' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlow'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlow'] },
	'circgradbasedcorrmaskfullx' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullX'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullX'] },
	'circgradbasedcorrmaskfully' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullY'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullY'] },
	'circgradbasedcorrmaskinputdigest' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksInputDigest'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksInputDigest'] },
	'circgradbasedcorrmaskleft' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksLeft'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksLeft'] },
	'circgradbasedcorrmaskmaskactive' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskActive'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskActive'] },
	'circgradbasedcorrmaskmaskblendmode' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskBlendMode'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskBlendMode'] },
	'circgradbasedcorrmaskmaskdigest' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskDigest'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskDigest'] },
	'circgradbasedcorrmaskmaskinverted' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskInverted'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskInverted'] },
	'circgradbasedcorrmaskmaskname' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskName'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskName'] },
	'circgradbasedcorrmaskmasks' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasks'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasks'] },
	'circgradbasedcorrmaskmasksalpha' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksAlpha'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksAlpha'] },
	'circgradbasedcorrmaskmasksangle' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksAngle'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksAngle'] },
	'circgradbasedcorrmaskmasksbottom' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksBottom'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksBottom'] },
	'circgradbasedcorrmaskmaskscentervalue' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksCenterValue'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksCenterValue'] },
	'circgradbasedcorrmaskmaskscenterweight' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksCenterWeight'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksCenterWeight'] },
	'circgradbasedcorrmaskmasksdabs' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksDabs'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksDabs'] },
	'circgradbasedcorrmaskmasksfeather' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFeather'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFeather'] },
	'circgradbasedcorrmaskmasksflipped' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFlipped'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFlipped'] },
	'circgradbasedcorrmaskmasksflow' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFlow'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFlow'] },
	'circgradbasedcorrmaskmasksfullx' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFullX'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFullX'] },
	'circgradbasedcorrmaskmasksfully' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFullY'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFullY'] },
	'circgradbasedcorrmaskmasksinputdigest' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksInputDigest'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksInputDigest'] },
	'circgradbasedcorrmaskmasksleft' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksLeft'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksLeft'] },
	'circgradbasedcorrmaskmasksmaskactive' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskActive'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskActive'] },
	'circgradbasedcorrmaskmasksmaskblendmode' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskBlendMode'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskBlendMode'] },
	'circgradbasedcorrmaskmasksmaskdigest' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskDigest'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskDigest'] },
	'circgradbasedcorrmaskmasksmaskinverted' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskInverted'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskInverted'] },
	'circgradbasedcorrmaskmasksmaskname' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskName'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskName'] },
	'circgradbasedcorrmaskmasksmasksubtype' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskSubType'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskSubType'] },
	'circgradbasedcorrmaskmasksmasksyncid' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskSyncID'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskSyncID'] },
	'circgradbasedcorrmaskmasksmaskversion' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskVersion'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskVersion'] },
	'circgradbasedcorrmaskmasksmidpoint' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMidpoint'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMidpoint'] },
	'circgradbasedcorrmaskmasksorigin' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksOrigin'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksOrigin'] },
	'circgradbasedcorrmaskmasksperimetervalue' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksPerimeterValue'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksPerimeterValue'] },
	'circgradbasedcorrmaskmasksradius' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksRadius'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksRadius'] },
	'circgradbasedcorrmaskmasksreferencepoint' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksReferencePoint'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksReferencePoint'] },
	'circgradbasedcorrmaskmasksright' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksRight'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksRight'] },
	'circgradbasedcorrmaskmasksroundness' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksRoundness'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksRoundness'] },
	'circgradbasedcorrmaskmaskssizex' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksSizeX'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksSizeX'] },
	'circgradbasedcorrmaskmaskssizey' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksSizeY'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksSizeY'] },
	'circgradbasedcorrmaskmaskstop' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksTop'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksTop'] },
	'circgradbasedcorrmaskmasksubtype' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskSubType'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskSubType'] },
	'circgradbasedcorrmaskmasksvalue' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskValue'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskValue'] },
	'circgradbasedcorrmaskmasksversion' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksVersion'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksVersion'] },
	'circgradbasedcorrmaskmaskswhat' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksWhat'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksWhat'] },
	'circgradbasedcorrmaskmaskswholeimagearea' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksWholeImageArea'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksWholeImageArea'] },
	'circgradbasedcorrmaskmasksx' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksX'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksX'] },
	'circgradbasedcorrmaskmasksy' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksY'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksY'] },
	'circgradbasedcorrmaskmasksyncid' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskSyncID'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskSyncID'] },
	'circgradbasedcorrmaskmaskszerox' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksZeroX'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksZeroX'] },
	'circgradbasedcorrmaskmaskszeroy' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksZeroY'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksZeroY'] },
	'circgradbasedcorrmaskmaskversion' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskVersion'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskVersion'] },
	'circgradbasedcorrmaskmidpoint' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMidpoint'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMidpoint'] },
	'circgradbasedcorrmaskorigin' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksOrigin'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksOrigin'] },
	'circgradbasedcorrmaskperimetervalue' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksPerimeterValue'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'circgradbasedcorrmaskradius' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRadius'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRadius'] },
	'circgradbasedcorrmaskrange' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMask'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMask'] },
	'circgradbasedcorrmaskrangeareamodels' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'] },
	'circgradbasedcorrmaskrangeareamodelscolorsampleinfo' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'circgradbasedcorrmaskrangeareamodelscomponents' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'] },
	'circgradbasedcorrmaskrangecoloramount' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'] },
	'circgradbasedcorrmaskrangedepthfeather' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'] },
	'circgradbasedcorrmaskrangedepthmax' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'] },
	'circgradbasedcorrmaskrangedepthmin' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'] },
	'circgradbasedcorrmaskrangeinvert' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'] },
	'circgradbasedcorrmaskrangelumfeather' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'] },
	'circgradbasedcorrmaskrangeluminancedepthsampleinfo' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'circgradbasedcorrmaskrangelummax' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'] },
	'circgradbasedcorrmaskrangelummin' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'] },
	'circgradbasedcorrmaskrangelumrange' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'] },
	'circgradbasedcorrmaskrangesampletype' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'] },
	'circgradbasedcorrmaskrangetype' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'] },
	'circgradbasedcorrmaskrangeversion' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'] },
	'circgradbasedcorrmaskreferencepoint' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksReferencePoint'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksReferencePoint'] },
	'circgradbasedcorrmaskright' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRight'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRight'] },
	'circgradbasedcorrmaskroundness' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRoundness'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRoundness'] },
	'circgradbasedcorrmasks' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasks'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasks'] },
	'circgradbasedcorrmasksizex' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeX'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeX'] },
	'circgradbasedcorrmasksizey' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeY'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeY'] },
	'circgradbasedcorrmasktop' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksTop'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksTop'] },
	'circgradbasedcorrmaskvalue' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskValue'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskValue'] },
	'circgradbasedcorrmaskversion' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksVersion'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksVersion'] },
	'circgradbasedcorrmaskwhat' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksWhat'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksWhat'] },
	'circgradbasedcorrmaskwholeimagearea' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksWholeImageArea'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksWholeImageArea'] },
	'circgradbasedcorrmaskx' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksX'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksX'] },
	'circgradbasedcorrmasky' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksY'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksY'] },
	'circgradbasedcorrmaskzerox' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroX'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroX'] },
	'circgradbasedcorrmaskzeroy' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroY'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroY'] },
	'circgradbasedcorrmoire' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalMoire'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalMoire'] },
	'circgradbasedcorrrangemask' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMask'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMask'] },
	'circgradbasedcorrrangemaskareamodels' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskAreaModels'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskAreaModels'] },
	'circgradbasedcorrrangemaskareamodelscolorsampleinfo' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'circgradbasedcorrrangemaskareamodelscomponents' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'] },
	'circgradbasedcorrrangemaskcoloramount' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskColorAmount'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskColorAmount'] },
	'circgradbasedcorrrangemaskdepthfeather' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskDepthFeather'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskDepthFeather'] },
	'circgradbasedcorrrangemaskdepthmax' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskDepthMax'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskDepthMax'] },
	'circgradbasedcorrrangemaskdepthmin' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskDepthMin'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskDepthMin'] },
	'circgradbasedcorrrangemaskinvert' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskInvert'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskInvert'] },
	'circgradbasedcorrrangemasklumfeather' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumFeather'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumFeather'] },
	'circgradbasedcorrrangemaskluminancedepthsampleinfo' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'circgradbasedcorrrangemasklummax' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumMax'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumMax'] },
	'circgradbasedcorrrangemasklummin' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumMin'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumMin'] },
	'circgradbasedcorrrangemasklumrange' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumRange'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumRange'] },
	'circgradbasedcorrrangemasksampletype' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskSampleType'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskSampleType'] },
	'circgradbasedcorrrangemasktype' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskType'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskType'] },
	'circgradbasedcorrrangemaskversion' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskVersion'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskVersion'] },
	'circgradbasedcorrsaturation' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSaturation'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSaturation'] },
	'circgradbasedcorrshadows2012' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalShadows2012'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalShadows2012'] },
	'circgradbasedcorrsharpness' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSharpness'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSharpness'] },
	'circgradbasedcorrtemperature' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTemperature'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTemperature'] },
	'circgradbasedcorrtexture' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTexture'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTexture'] },
	'circgradbasedcorrtint' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTint'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTint'] },
	'circgradbasedcorrtoninghue' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalToningHue'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalToningHue'] },
	'circgradbasedcorrtoningsaturation' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalToningSaturation'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalToningSaturation'] },
	'circgradbasedcorrwhat' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsWhat'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsWhat'] },
	'circgradbasedcorrwhites2012' => { 477 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalWhites2012'], 479 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalWhites2012'] },
	'circulargradientbasedcorrections' => { 477 => 'CircularGradientBasedCorrections', 479 => 'CircularGradientBasedCorrections' },
	'city' => { 131 => 0x5a, 161 => 'City', 320 => 0x6d, 491 => 'City' },
	'city2' => { 320 => 0x80 },
	'clarity' => { 232 => 0x35, 233 => 0x3d, 420 => 0x2036, 477 => 'Clarity', 479 => 'Clarity' },
	'clarity2012' => { 477 => 'Clarity2012', 479 => 'Clarity2012' },
	'claritycontrol' => { 355 => 0x96 },
	'classification' => { 380 => 'clsf' },
	'classifystate' => { 131 => 0xe1 },
	'clearretouch' => { 320 => 0x7c },
	'clearretouchvalue' => { 320 => 0xa3 },
	'client' => { 503 => 'client' },
	'clientname' => { 485 => 'ClientName' },
	'clipboardaspectratio' => { 477 => 'ClipboardAspectRatio', 479 => 'ClipboardAspectRatio' },
	'clipboardorientation' => { 477 => 'ClipboardOrientation', 479 => 'ClipboardOrientation' },
	'clipfilename' => { 380 => 'clfn' },
	'clipid' => { 380 => 'clid' },
	'clmodeshootingspeed' => { 279 => '10.2', 280 => '11.3', 282 => '11.2', 283 => '11.2', 288 => '11.2', 289 => '10.2', 292 => '11.2', 293 => '11.2', 294 => '11.1', 295 => 0x3b },
	'cluster' => { 477 => 'Cluster', 479 => 'Cluster' },
	'cmcontrast' => { 305 => 0x2022 },
	'cmddialsreverserotation' => { 295 => 0xba },
	'cmexposurecompensation' => { 305 => 0x2000 },
	'cmhue' => { 305 => 0x2021 },
	'cmsaturation' => { 305 => 0x2020 },
	'cmsharpness' => { 305 => 0x2023 },
	'cmwhitebalance' => { 305 => 0x2001 },
	'cmwhitebalancecomp' => { 305 => 0x2002 },
	'cmwhitebalancegraypoint' => { 305 => 0x2010 },
	'codec' => { 169 => 'Codec' },
	'codedcharacterset' => { 132 => 0x5a },
	'codeversion' => { 380 => 'cver' },
	'collection' => { 310 => 'Collection' },
	'collectionname' => { 170 => [\'Collections','CollectionsCollectionName'], 380 => 'coll' },
	'collections' => { 170 => 'Collections', 472 => 'collections' },
	'collectionuri' => { 170 => [\'Collections','CollectionsCollectionURI'] },
	'color' => { 374 => 'player.movie.visual.color', 492 => 'color' },
	'coloraberrationcontrol' => { 272 => 0xc89224b },
	'coloradjustment' => { 397 => 0x14 },
	'coloradjustmentmode' => { 396 => 0x210 },
	'coloranta' => { 508 => [\'Colorants','ColorantsA'] },
	'colorantb' => { 508 => [\'Colorants','ColorantsB'] },
	'colorantblack' => { 508 => [\'Colorants','ColorantsBlack'] },
	'colorantblue' => { 508 => [\'Colorants','ColorantsBlue'] },
	'colorantcyan' => { 508 => [\'Colorants','ColorantsCyan'] },
	'colorantgray' => { 508 => [\'Colorants','ColorantsGray'] },
	'colorantgreen' => { 508 => [\'Colorants','ColorantsGreen'] },
	'colorantl' => { 508 => [\'Colorants','ColorantsL'] },
	'colorantmagenta' => { 508 => [\'Colorants','ColorantsMagenta'] },
	'colorantmode' => { 508 => [\'Colorants','ColorantsMode'] },
	'colorantred' => { 508 => [\'Colorants','ColorantsRed'] },
	'colorants' => { 508 => 'Colorants' },
	'colorantswatchname' => { 508 => [\'Colorants','ColorantsSwatchName'] },
	'coloranttint' => { 508 => [\'Colorants','ColorantsTint'] },
	'coloranttype' => { 508 => [\'Colorants','ColorantsType'] },
	'colorantyellow' => { 508 => [\'Colorants','ColorantsYellow'] },
	'colorbalance' => { 156 => 'ColorBalance' },
	'colorbalanceadj' => { 272 => 0x76a43202 },
	'colorbalanceblue' => { 181 => 0x1e },
	'colorbalancegreen' => { 181 => 0x1d },
	'colorbalancered' => { 181 => 0x1c },
	'colorbalanceversion' => { 203 => 0x4, 204 => 0x4, 205 => 0x0 },
	'colorblur' => { 109 => 0x65 },
	'colorbluron' => { 103 => 0x20704 },
	'colorbooster' => { 272 => 0x5f0e7d23 },
	'colorboostlevel' => { 266 => 0x1 },
	'colorboosttype' => { 266 => 0x0 },
	'colorchromeeffect' => { 127 => 0x1048 },
	'colorchromefxblue' => { 127 => 0x104e },
	'colorclass' => { 366 => 0xde, 367 => 'ColorClass' },
	'colorcompensationfilter' => { 184 => [0x3a,0x5f], 186 => 0x111, 420 => 0xb022 },
	'colorcompensationfiltercustom' => { 407 => 0xd, 408 => 0xc },
	'colorcompensationfilterset' => { 407 => 0x8, 408 => 0x7, 409 => 0x18, 425 => 0xf },
	'colorcontrol' => { 302 => 0x102b },
	'colorcorrection' => { 454 => 0x8015 },
	'colorcreatoreffect' => { 297 => 0x532 },
	'colordataversion' => { 41 => 0x0, 42 => 0x0, 44 => 0x0, 45 => 0x0, 46 => 0x0, 47 => 0x0, 48 => 0x0, 49 => 0x0, 50 => 0x0 },
	'coloreffect' => { 320 => 0x28 },
	'colorfilter' => { 112 => 0x17, 113 => 0x3017, 181 => 0x29, 189 => [0x38,0x4d,0x4f], 362 => 0x17 },
	'colorgain' => { 237 => 0x51 },
	'colorgradeblending' => { 477 => 'ColorGradeBlending', 479 => 'ColorGradeBlending' },
	'colorgradeglobalhue' => { 477 => 'ColorGradeGlobalHue', 479 => 'ColorGradeGlobalHue' },
	'colorgradegloballum' => { 477 => 'ColorGradeGlobalLum', 479 => 'ColorGradeGlobalLum' },
	'colorgradeglobalsat' => { 477 => 'ColorGradeGlobalSat', 479 => 'ColorGradeGlobalSat' },
	'colorgradehighlightlum' => { 477 => 'ColorGradeHighlightLum', 479 => 'ColorGradeHighlightLum' },
	'colorgrademidtonehue' => { 477 => 'ColorGradeMidtoneHue', 479 => 'ColorGradeMidtoneHue' },
	'colorgrademidtonelum' => { 477 => 'ColorGradeMidtoneLum', 479 => 'ColorGradeMidtoneLum' },
	'colorgrademidtonesat' => { 477 => 'ColorGradeMidtoneSat', 479 => 'ColorGradeMidtoneSat' },
	'colorgradeshadowlum' => { 477 => 'ColorGradeShadowLum', 479 => 'ColorGradeShadowLum' },
	'colorhue' => { 103 => 0x20900, 226 => 0x8d },
	'colorimetricreference' => { 119 => 0xc6bf },
	'colorlabel' => { 482 => 'ColorLabel' },
	'colormatrix' => { 63 => 0xa, 301 => 0x200, 302 => 0x1011, 394 => 0xa030 },
	'colormatrix1' => { 119 => 0xc621, 364 => 0x106 },
	'colormatrix2' => { 119 => 0xc622, 305 => 0x200, 364 => 0x226 },
	'colormatrix3' => { 119 => 0xcd33 },
	'colormatrixa' => { 355 => 0x203 },
	'colormatrixa2' => { 355 => 0x21c },
	'colormatrixadobergb' => { 394 => 0xa032 },
	'colormatrixb' => { 355 => 0x204 },
	'colormatrixb2' => { 355 => 0x21d },
	'colormatrixnumber' => { 302 => 0x1019 },
	'colormatrixsrgb' => { 394 => 0xa031 },
	'colormode' => { 113 => 0x3015, 127 => 0x1210, 140 => 0x66, 181 => 0x28, 184 => 0x16, 186 => 0x101, 187 => 0x36, 189 => 0x7, 226 => 0x3, 262 => 0x4, 320 => 0x32, 397 => 0x2c, 420 => 0xb029, 491 => 'ColorMode' },
	'colormoirereduction' => { 103 => 0x20670, 273 => 0x15 },
	'colormoirereductionmode' => { 273 => 0x5 },
	'colormoirereductionon' => { 103 => '0x20670.0' },
	'colornoisereduction' => { 454 => 0x8029, 477 => 'ColorNoiseReduction', 479 => 'ColorNoiseReduction' },
	'colornoisereductiondetail' => { 477 => 'ColorNoiseReductionDetail', 479 => 'ColorNoiseReductionDetail' },
	'colornoisereductionintensity' => { 273 => 0x18 },
	'colornoisereductionsharpness' => { 273 => 0x1c },
	'colornoisereductionsmoothness' => { 477 => 'ColorNoiseReductionSmoothness', 479 => 'ColorNoiseReductionSmoothness' },
	'colorplanes' => { 123 => 0x2 },
	'colorprofile' => { 181 => 0x33 },
	'colorprofilesettings' => { 297 => 0x539 },
	'colorrepresentation' => { 133 => 0x3c },
	'colorsaturationadj' => { 103 => 0x20305 },
	'colorsequence' => { 133 => 0x41 },
	'colorspace' => { 51 => 0x3, 64 => 0xb4, 97 => 0x10b4, 119 => 0xa001, 135 => 0x3, 162 => 'ColorSpace', 182 => 0x2f, 183 => 0x25, 184 => 0x17, 226 => 0x1e, 297 => 0x507, 355 => 0x37, 394 => 0xa011, 397 => 0xb, 407 => 0x1b, 408 => 0x83, 409 => 0xe, 425 => 0x6, 483 => 'ColorSpace' },
	'colorspace2' => { 63 => 0x9 },
	'colorspecapproximation' => { 135 => 0x2 },
	'colorspecdata' => { 135 => 0x3 },
	'colorspecmethod' => { 135 => 0x0 },
	'colorspecprecedence' => { 135 => 0x1 },
	'colortempasshot' => { 38 => 0x4, 39 => 0x7, 40 => 0x1d, 41 => 0x59, 42 => 0x6d, 43 => 0x26, 44 => 0x43, 47 => 0x43, 48 => 0x43, 49 => 0x43, 50 => 0x4b },
	'colortempauto' => { 38 => 0x9, 39 => 0xf, 40 => 0x22, 41 => 0x5e, 42 => 0x72, 43 => 0x1c, 44 => 0x48, 47 => 0x48, 48 => 0x48, 49 => 0x48, 50 => 0x50 },
	'colortempcloudy' => { 38 => 0x22, 39 => 0x37, 40 => 0x31, 41 => 0xa4, 42 => 0xdb, 43 => 0x35, 44 => 0x5c, 47 => 0x75, 48 => 0x8e, 49 => 0x93, 50 => 0x96, 355 => 0x55 },
	'colortempcustom' => { 44 => 0x84 },
	'colortempcustom1' => { 40 => 0x45 },
	'colortempcustom2' => { 40 => 0x4a },
	'colortempdaylight' => { 38 => 0x18, 39 => 0x27, 40 => 0x27, 41 => 0x9a, 42 => 0xd1, 43 => 0x2b, 44 => 0x52, 47 => 0x6b, 48 => 0x84, 49 => 0x89, 50 => 0x8c, 355 => 0x53 },
	'colortemperature' => { 7 => 0x73, 8 => [0x48,0x4e], 9 => 0xc0, 10 => 0x37, 11 => 0x62, 12 => 0x37, 13 => 0x7c, 14 => 0x73, 15 => 0x73, 16 => 0x77, 17 => 0x73, 18 => 0x7c, 19 => 0x58, 20 => 0x73, 21 => 0xc0, 22 => 0x7f, 23 => 0x7d, 24 => 0xc0, 25 => 0xc6, 26 => 0xc7, 27 => 0x135, 28 => 0x7b, 29 => 0x13a, 64 => 0xae, 74 => 0x9, 97 => 0x10ae, 127 => 0x1005, 138 => 0x846, 156 => 'ColorTemperature', 182 => [0x6e,0x49], 183 => 0x3f, 184 => [0x39,0x5e], 186 => 0x10b, 189 => [0x3c,0x4c,0x4e], 315 => 0x321, 355 => 0x50, 387 => 0x1308, 420 => 0xb021, 477 => 'Temperature', 479 => 'Temperature' },
	'colortemperatureadj' => { 454 => 0x8013 },
	'colortemperatureauto' => { 226 => 0x4f },
	'colortemperaturebg' => { 302 => 0x1013 },
	'colortemperaturecustom' => { 407 => 0xc, 408 => 0xb },
	'colortemperaturerg' => { 302 => 0x1014 },
	'colortemperatureset' => { 407 => 0x7, 408 => 0x6 },
	'colortemperaturesetting' => { 184 => 0x25, 409 => 0x17, 425 => 0xe },
	'colortempflash' => { 38 => 0x36, 39 => 0x57, 40 => 0x40, 41 => 0xb8, 42 => 0xef, 43 => 0x49, 44 => 0x70, 47 => 0x89, 48 => 0xa2, 49 => 0xa7, 50 => 0xaa, 355 => 0x5a },
	'colortempflashdata' => { 44 => 0x24a },
	'colortempfluorescent' => { 38 => 0x2c, 39 => 0x47, 40 => 0x3b, 41 => 0xae, 42 => 0xe5, 43 => 0x3f, 44 => 0x66, 47 => 0x7f, 48 => 0x98, 49 => 0x9d, 50 => 0xa0 },
	'colortempfluorescentd' => { 355 => 0x57 },
	'colortempfluorescentn' => { 355 => 0x58 },
	'colortempfluorescentw' => { 355 => 0x59 },
	'colortempkelvin' => { 38 => 0x31, 39 => 0x4f, 41 => 0xb3, 42 => 0xea, 43 => 0x44, 44 => 0x6b, 47 => 0x84, 48 => 0x9d, 49 => 0xa2, 50 => 0xa5, 320 => 0x44, 387 => 0x1307 },
	'colortempmeasured' => { 38 => 0xe, 39 => 0x17, 41 => 0x63, 42 => 0x77, 44 => 0x4d, 47 => 0x4d, 48 => 0x4d, 49 => 0x4d, 50 => 0x55 },
	'colortemppc1' => { 43 => 0x94, 44 => 0x75 },
	'colortemppc2' => { 43 => 0x99, 44 => 0x7a },
	'colortemppc3' => { 43 => 0x9e, 44 => 0x7f },
	'colortempshade' => { 38 => 0x1d, 39 => 0x2f, 40 => 0x2c, 41 => 0x9f, 42 => 0xd6, 43 => 0x30, 44 => 0x57, 47 => 0x70, 48 => 0x89, 49 => 0x8e, 50 => 0x91, 355 => 0x54 },
	'colortemptungsten' => { 38 => 0x27, 39 => 0x3f, 40 => 0x36, 41 => 0xa9, 42 => 0xe0, 43 => 0x3a, 44 => 0x61, 47 => 0x7a, 48 => 0x93, 49 => 0x98, 50 => 0x9b, 355 => 0x56 },
	'colortempunknown' => { 38 => 0x13, 39 => 0x1f, 41 => 0x68, 42 => 0x7c, 43 => 0x21, 47 => 0x52, 48 => 0x52, 49 => 0x52, 50 => 0x5a },
	'colortempunknown10' => { 38 => 0x63, 39 => 0x9f, 41 => 0x95, 42 => 0xa9, 43 => 0x76, 47 => 0xa2, 48 => 0x7f, 49 => 0x7f, 50 => 0x87 },
	'colortempunknown11' => { 38 => 0x68, 39 => 0xa7, 41 => 0xbd, 42 => [0xae,0xb3], 43 => 0x7b, 47 => 0xa7, 48 => 0xa7, 49 => 0x84, 50 => 0xaf },
	'colortempunknown12' => { 38 => 0x6d, 39 => 0xaf, 41 => 0xc2, 42 => 0xb8, 43 => 0x80, 47 => 0xac, 48 => 0xac, 49 => 0xac, 50 => 0xb4 },
	'colortempunknown13' => { 38 => 0x72, 39 => 0xb7, 41 => 0xc7, 42 => 0xbd, 43 => 0x85, 47 => 0xb1, 48 => 0xb1, 49 => 0xb1, 50 => 0xb9 },
	'colortempunknown14' => { 41 => 0xcc, 42 => 0xc2, 43 => 0x8a, 47 => 0xb6, 48 => 0xb6, 49 => 0xb6, 50 => 0xbe },
	'colortempunknown15' => { 41 => 0xd1, 42 => 0xc7, 43 => 0x8f, 47 => 0xbb, 48 => 0xbb, 49 => 0xbb, 50 => 0xc3 },
	'colortempunknown16' => { 41 => 0xd6, 42 => 0xcc, 43 => 0xa3, 48 => 0xc0, 49 => 0xc0, 50 => 0xc8 },
	'colortempunknown17' => { 41 => 0xdb, 42 => 0xf4, 48 => 0xc5, 49 => 0xc5, 50 => 0xcd },
	'colortempunknown18' => { 41 => 0xe0, 42 => 0xf9, 48 => 0xca, 49 => 0xca, 50 => 0xd2 },
	'colortempunknown19' => { 41 => 0xe5, 42 => 0xfe, 48 => 0xcf, 49 => 0xcf, 50 => 0xd7 },
	'colortempunknown2' => { 38 => 0x3b, 39 => 0x5f, 41 => 0x6d, 42 => 0x81, 43 => 0x4e, 47 => 0x57, 48 => 0x57, 49 => 0x57, 50 => 0x5f },
	'colortempunknown20' => { 41 => 0xea, 42 => 0x103, 48 => 0xd4, 49 => 0xd4, 50 => 0xdc },
	'colortempunknown21' => { 41 => 0xef, 42 => 0x108, 49 => 0xd9, 50 => 0xe1 },
	'colortempunknown22' => { 41 => 0xf4, 42 => 0x10d, 49 => 0xde, 50 => 0xe6 },
	'colortempunknown23' => { 41 => 0xf9, 42 => 0x112, 49 => 0xe3, 50 => 0xeb },
	'colortempunknown24' => { 41 => 0xfe, 42 => 0x117, 49 => 0xe8, 50 => 0xf0 },
	'colortempunknown25' => { 41 => 0x103, 42 => 0x11c, 49 => 0xed, 50 => 0xf5 },
	'colortempunknown26' => { 41 => 0x108, 42 => 0x121, 49 => 0xf2, 50 => 0xfa },
	'colortempunknown27' => { 41 => 0x10d, 42 => 0x126, 49 => 0xf7, 50 => 0xff },
	'colortempunknown28' => { 41 => 0x112, 49 => 0xfc, 50 => 0x104 },
	'colortempunknown29' => { 41 => 0x117, 49 => 0x101, 50 => 0x109 },
	'colortempunknown3' => { 38 => 0x40, 39 => 0x67, 41 => 0x72, 42 => 0x86, 43 => 0x53, 47 => 0x5c, 48 => 0x5c, 49 => 0x5c, 50 => 0x64 },
	'colortempunknown30' => { 49 => 0x106 },
	'colortempunknown4' => { 38 => 0x45, 39 => 0x6f, 41 => 0x77, 42 => 0x8b, 43 => 0x58, 47 => 0x61, 48 => 0x61, 49 => 0x61, 50 => 0x69 },
	'colortempunknown5' => { 38 => 0x4a, 39 => 0x77, 41 => 0x7c, 42 => 0x90, 43 => 0x5d, 47 => 0x66, 48 => 0x66, 49 => 0x66, 50 => 0x6e },
	'colortempunknown6' => { 38 => 0x4f, 39 => 0x7f, 41 => 0x81, 42 => 0x95, 43 => 0x62, 47 => 0x8e, 48 => 0x6b, 49 => 0x6b, 50 => 0x73 },
	'colortempunknown7' => { 38 => 0x54, 39 => 0x87, 41 => 0x86, 42 => 0x9a, 43 => 0x67, 47 => 0x93, 48 => 0x70, 49 => 0x70, 50 => 0x78 },
	'colortempunknown8' => { 38 => 0x59, 39 => 0x8f, 41 => 0x8b, 42 => 0x9f, 43 => 0x6c, 47 => 0x98, 48 => 0x75, 49 => 0x75, 50 => 0x7d },
	'colortempunknown9' => { 38 => 0x5e, 39 => 0x97, 41 => 0x90, 42 => 0xa4, 43 => 0x71, 47 => 0x9d, 48 => 0x7a, 49 => 0x7a, 50 => 0x82 },
	'colortint' => { 319 => 0x35c },
	'colortone' => { 10 => 0x6f, 12 => 0x77, 34 => 0x2a, 51 => 0x2, 63 => 0x8 },
	'colortoneadj' => { 103 => 0x20304, 108 => 0x11e },
	'colortoneauto' => { 71 => 0x9c },
	'colortonefaithful' => { 19 => 0x107, 70 => 0x6c, 71 => 0x6c },
	'colortonelandscape' => { 19 => 0x105, 70 => 0x3c, 71 => 0x3c },
	'colortonemonochrome' => { 70 => 0x84, 71 => 0x84 },
	'colortoneneutral' => { 19 => 0x106, 70 => 0x54, 71 => 0x54 },
	'colortoneportrait' => { 19 => 0x104, 70 => 0x24, 71 => 0x24 },
	'colortonestandard' => { 19 => 0x103, 70 => 0xc, 71 => 0xc },
	'colortoneuserdef1' => { 19 => 0x109, 70 => 0x9c, 71 => 0xb4 },
	'colortoneuserdef2' => { 19 => 0x10a, 70 => 0xb4, 71 => 0xcc },
	'colortoneuserdef3' => { 19 => 0x10b, 70 => 0xcc, 71 => 0xe4 },
	'comlenblksize' => { 138 => 0xfde8 },
	'commanddialplaybackmode' => { 295 => 0x1cb },
	'commanddials' => { 290 => '5.1' },
	'commanddialsaperturesetting' => { 279 => '17.3', 280 => '18.3', 282 => '18.3', 283 => '18.3', 288 => '33.3', 289 => '17.3', 292 => '18.3', 293 => '18.3' },
	'commanddialschangemainsub' => { 279 => '17.2', 280 => '18.1', 282 => '18.1', 283 => '18.1', 288 => '33.2', 289 => '17.2', 292 => '18.1', 293 => '18.1' },
	'commanddialsmenuandplayback' => { 279 => '17.4', 280 => '18.2', 282 => '18.2', 283 => '18.2', 288 => '33.4', 289 => '17.4', 292 => '18.2', 293 => '18.2' },
	'commanddialsreverserotation' => { 279 => '17.1', 280 => '6.4', 282 => '6.2', 283 => '6.2', 284 => '16.2', 285 => '17.2', 288 => '33.1', 289 => '17.1', 292 => '6.2', 293 => '6.2', 294 => '18.1' },
	'commanderchannel' => { 290 => '10.2', 291 => '25.2' },
	'commandergroupa_ttl-aacomp' => { 290 => '13.1', 291 => '31.1' },
	'commandergroupa_ttlcomp' => { 294 => '32.1' },
	'commandergroupamanualoutput' => { 290 => '13.2', 291 => '28.2' },
	'commandergroupamode' => { 290 => '11.2', 291 => '28.1' },
	'commandergroupb_ttl-aacomp' => { 290 => '14.1', 291 => '32.1' },
	'commandergroupb_ttlcomp' => { 294 => '33.1' },
	'commandergroupbmanualoutput' => { 290 => '14.2', 291 => '29.2' },
	'commandergroupbmode' => { 290 => '11.3', 291 => '29.1' },
	'commanderinternalflash' => { 290 => '11.1', 291 => '27.1' },
	'commanderinternalmanualoutput' => { 290 => '12.2', 291 => '27.2' },
	'commanderinternalttlchannel' => { 288 => '18.2' },
	'commanderinternalttlcomp' => { 290 => '12.1', 291 => '30.2', 294 => '31.2' },
	'commanderinternalttlcompbuiltin' => { 288 => '20.1', 289 => '26.1' },
	'commanderinternalttlcompgroupa' => { 288 => '21.1', 289 => '27.1' },
	'commanderinternalttlcompgroupb' => { 288 => '22.1', 289 => '28.1' },
	'comment' => { 0 => 0x2, 120 => 'Comment', 157 => 'Comment', 310 => 'Comment', 372 => "\xa9cmt", 374 => 'comment', 380 => "\xa9cmt" },
	'compass' => { 390 => 0x4 },
	'compatibleversion' => { 477 => 'CompatibleVersion', 479 => 'CompatibleVersion' },
	'compilation' => { 372 => 'cpil' },
	'compimageimagespersequence' => { 484 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesNumberOfImagesInSequences'] },
	'compimagemaxexposureall' => { 484 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesMaxExposureTimesOfAll'] },
	'compimagemaxexposureused' => { 484 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesMaxExposureTimesOfUsed'] },
	'compimageminexposureall' => { 484 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesMinExposureTimesOfAll'] },
	'compimageminexposureused' => { 484 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesMinExposureTimesOfUsed'] },
	'compimagenumsequences' => { 484 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesNumberOfSequences'] },
	'compimagesumexposureall' => { 484 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesSumOfExposureTimesOfAll'] },
	'compimagesumexposureused' => { 484 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesSumOfExposureTimesOfUsed'] },
	'compimagetotalexposureperiod' => { 484 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesTotalExposurePeriod'] },
	'compimagevalues' => { 484 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesValues'] },
	'complianceprofile' => { 493 => 'complianceProfile' },
	'componentsconfiguration' => { 119 => 0x9101, 162 => 'Components', 483 => 'ComponentsConfiguration' },
	'componentversion' => { 97 => 0x80c },
	'composer' => { 179 => 'WM/Composer', 372 => ["\xa9com","\xa9wrt"], 380 => ["\xa9com","\xa9wrt"], 503 => 'composer' },
	'composerkeywords' => { 380 => "\xa9cok" },
	'compositeimage' => { 119 => 0xa460, 484 => 'CompositeImage' },
	'compositeimagecount' => { 119 => 0xa461, 484 => 'CompositeImageCount' },
	'compositeimageexposuretimes' => { 119 => 0xa462, 484 => 'CompositeImageExposureTimes' },
	'composition' => { 467 => 'Composition' },
	'compositionadjust' => { 354 => '0.1' },
	'compositionadjustrotation' => { 354 => 0x7 },
	'compositionadjustx' => { 354 => 0x5 },
	'compositionadjusty' => { 354 => 0x6 },
	'compressedbitsperpixel' => { 119 => 0x9102, 483 => 'CompressedBitsPerPixel' },
	'compressedimagesize' => { 186 => 0x40, 302 => 0x40 },
	'compression' => { 119 => 0x103, 325 => 0xb, 499 => 'Compression' },
	'compressionfactor' => { 297 => 0x50d },
	'compressionformat' => { 63 => 0x4 },
	'compressionratio' => { 162 => 'Compression', 302 => 0x1034 },
	'compressorversion' => { 380 => 'CNCV' },
	'condadobvfactor' => { 138 => 0xf3e },
	'condadodaybvthresh' => { 138 => 0xf3c },
	'condadodayoffsets' => { 138 => 0xf42 },
	'condadofluoffsets' => { 138 => 0xf44 },
	'condadofluthresh' => { 138 => 0xf41 },
	'condadoillfactor' => { 138 => 0xf3f },
	'condadoneurange' => { 138 => 0xf3d },
	'condadotunoffsets' => { 138 => 0xf43 },
	'condadotunthresh' => { 138 => 0xf40 },
	'conductor' => { 179 => 'WM/Conductor', 372 => "\xa9con" },
	'confidence' => { 462 => 'Confidence' },
	'confidencelevel' => { 473 => 'ConfidenceLevel' },
	'confidencemime' => { 462 => 'ConfidenceMime' },
	'constrainedcropheight' => { 108 => 0x266, 366 => 0xd6 },
	'constrainedcropwidth' => { 108 => 0x262, 366 => 0xd5 },
	'contact' => { 131 => 0x76 },
	'contactinfo' => { 477 => 'ContactInfo', 479 => 'ContactInfo', 492 => 'contactInfo' },
	'container' => { 457 => 'Container' },
	'containerdirectory' => { 457 => [\'Container','ContainerDirectory'] },
	'containerdirectoryitem' => { 457 => [\'Container','ContainerDirectoryItem'] },
	'containerdirectoryitemdatauri' => { 457 => [\'Container','ContainerDirectoryItemDataURI'] },
	'containerdirectoryitemlength' => { 457 => [\'Container','ContainerDirectoryItemLength'] },
	'containerdirectoryitemmime' => { 457 => [\'Container','ContainerDirectoryItemMime'] },
	'containerdirectoryitempadding' => { 457 => [\'Container','ContainerDirectoryItemPadding'] },
	'containerformat' => { 489 => 'ContainerFormat' },
	'containerformatidentifier' => { 489 => [\'ContainerFormat','ContainerFormatIdentifier'] },
	'containerformatname' => { 489 => [\'ContainerFormat','ContainerFormatName'] },
	'contentcreatedate' => { 372 => "\xa9day", 380 => ['@day',"\xa9day"] },
	'contentdistributor' => { 179 => 'WM/ContentDistributor' },
	'contentdistributorid' => { 380 => 'cdis' },
	'contentid' => { 380 => 'ccid' },
	'contentlocationcode' => { 131 => 0x1a },
	'contentlocationname' => { 131 => 0x1b },
	'contenttype' => { 493 => 'contentType' },
	'continuousbracketing' => { 184 => 0x20 },
	'continuousdrive' => { 34 => 0x5 },
	'continuousmodedisplay' => { 295 => 0x51 },
	'continuousmodeliveview' => { 293 => '77.2' },
	'continuousshootingspeed' => { 84 => 0x610 },
	'continuousshotlimit' => { 84 => 0x611 },
	'contrast' => { 10 => 0x73, 12 => 0x75, 34 => 0xd, 112 => 0xc, 113 => [0x3012,0x20], 119 => [0xa408,0xfe54], 127 => [0x1004,0x1006], 156 => 'Contrast', 176 => 'Contrast', 181 => 0x20, 182 => 0x31, 183 => 0x27, 184 => 0x19, 189 => 0x2, 231 => 0x33, 232 => 0x37, 233 => 0x3f, 302 => 0x1029, 320 => 0x39, 322 => 0x300a, 355 => 0x20, 362 => 0xc, 374 => 'player.movie.visual.contrast', 381 => 0x24, 383 => 0x52, 387 => 0x1012, 397 => 0xd, 407 => 0x1d, 408 => 0x1a, 420 => 0x2004, 477 => 'Contrast', 479 => 'Contrast', 483 => 'Contrast' },
	'contrast2012' => { 477 => 'Contrast2012', 479 => 'Contrast2012' },
	'contrastadj' => { 103 => 0x20303, 108 => 0x115, 275 => 0x2c, 454 => 0x8017 },
	'contrastauto' => { 71 => 0x90 },
	'contrastcurve' => { 226 => 0x8c },
	'contrastdetectaf' => { 193 => 0x4 },
	'contrastdetectafarea' => { 355 => 0x231 },
	'contrastdetectafinfocus' => { 193 => [0x1c,0x52] },
	'contrastfaithful' => { 19 => 0xec, 70 => 0x60, 71 => 0x60 },
	'contrasthighlight' => { 355 => 0x6d },
	'contrasthighlightshadowadj' => { 355 => 0x6f },
	'contrastlandscape' => { 19 => 0xea, 70 => 0x30, 71 => 0x30 },
	'contrastmode' => { 320 => 0x2c },
	'contrastmonochrome' => { 19 => 0xed, 70 => 0x78, 71 => 0x78 },
	'contrastneutral' => { 19 => 0xeb, 70 => 0x48, 71 => 0x48 },
	'contrastportrait' => { 19 => 0xe9, 70 => 0x18, 71 => 0x18 },
	'contrastsetting' => { 297 => 0x505, 305 => 0x1012, 409 => 0x10, 425 => 0x8 },
	'contrastshadow' => { 355 => 0x6e },
	'contraststandard' => { 19 => 0xe8, 70 => 0x0, 71 => 0x0 },
	'contrastuserdef1' => { 19 => 0xee, 70 => 0x90, 71 => 0xa8 },
	'contrastuserdef2' => { 19 => 0xef, 70 => 0xa8, 71 => 0xc0 },
	'contrastuserdef3' => { 19 => 0xf0, 70 => 0xc0, 71 => 0xd8 },
	'contributedmedia' => { 503 => 'contributedMedia' },
	'contributedmediaduration' => { 503 => [\'contributedMedia','contributedMediaDuration'] },
	'contributedmediadurationscale' => { 503 => [\'contributedMedia','contributedMediaDurationScale'] },
	'contributedmediadurationvalue' => { 503 => [\'contributedMedia','contributedMediaDurationValue'] },
	'contributedmediamanaged' => { 503 => [\'contributedMedia','contributedMediaManaged'] },
	'contributedmediapath' => { 503 => [\'contributedMedia','contributedMediaPath'] },
	'contributedmediastarttime' => { 503 => [\'contributedMedia','contributedMediaStartTime'] },
	'contributedmediastarttimescale' => { 503 => [\'contributedMedia','contributedMediaStartTimeScale'] },
	'contributedmediastarttimevalue' => { 503 => [\'contributedMedia','contributedMediaStartTimeValue'] },
	'contributedmediatrack' => { 503 => [\'contributedMedia','contributedMediaTrack'] },
	'contributedmediawebstatement' => { 503 => [\'contributedMedia','contributedMediaWebStatement'] },
	'contributor' => { 480 => 'contributor', 489 => 'Contributor' },
	'contributoridentifier' => { 489 => [\'Contributor','ContributorIdentifier'] },
	'contributorname' => { 489 => [\'Contributor','ContributorName'] },
	'contributorrole' => { 489 => [\'Contributor','ContributorRole'] },
	'contributors' => { 157 => 'Contributors' },
	'controldialset' => { 184 => 0x46 },
	'controlledvocabularyterm' => { 489 => 'CVterm' },
	'controllerboardversion' => { 315 => 0x332 },
	'controlmode' => { 77 => 0x12 },
	'controlringresponse' => { 295 => 0x1d5 },
	'controlringrotation' => { 84 => 0x712 },
	'conversionlens' => { 298 => 0x403, 320 => 0x35 },
	'converter' => { 119 => 0xfe4d, 262 => 0xb, 477 => 'Converter', 479 => 'Converter' },
	'converttograyscale' => { 477 => 'ConvertToGrayscale', 479 => 'ConvertToGrayscale' },
	'cookingequipment' => { 495 => 'cookingEquipment' },
	'cookingmethod' => { 495 => 'cookingMethod' },
	'copyright' => { 0 => 0x3, 119 => 0x8298, 157 => 'Copyright', 310 => 'Copyright', 355 => 0x22f, 371 => 'Copyright', 372 => ['cprt',"\xa9cpy"], 374 => 'copyright', 380 => ['cprt',"\xa9cpy"], 477 => 'Copyright', 479 => 'Copyright', 490 => 'Copyright', 496 => 'copyright', 499 => 'Copyright', 503 => 'copyright' },
	'copyrightflag' => { 369 => 0x40a },
	'copyrightnotice' => { 131 => 0x74 },
	'copyrightowner' => { 307 => 'CopyrightOwner' },
	'copyrightownerid' => { 307 => [\'CopyrightOwner','CopyrightOwnerCopyrightOwnerID'] },
	'copyrightownerimageid' => { 307 => 'CopyrightOwnerImageID' },
	'copyrightownername' => { 307 => [\'CopyrightOwner','CopyrightOwnerCopyrightOwnerName'] },
	'copyrightregistrationnumber' => { 307 => 'CopyrightRegistrationNumber' },
	'copyrightstatus' => { 307 => 'CopyrightStatus' },
	'copyrightyear' => { 489 => 'CopyrightYear', 493 => 'copyrightYear' },
	'coringfilter' => { 301 => 0x310, 302 => 0x102d, 305 => 0x310 },
	'coringvalues' => { 301 => 0x311, 305 => 0x311 },
	'corporateentity' => { 493 => 'corporateEntity' },
	'correlatedcolortemp' => { 319 => 0x35b },
	'country' => { 161 => 'Country', 320 => 0x69, 491 => 'Country' },
	'country-primarylocationcode' => { 131 => 0x64 },
	'country-primarylocationname' => { 131 => 0x65 },
	'countrycode' => { 225 => 0x5, 367 => 'CountryCode', 488 => 'CountryCode' },
	'course' => { 495 => 'course' },
	'coverage' => { 480 => 'coverage' },
	'coverart' => { 372 => 'covr' },
	'coverdate' => { 493 => 'coverDate' },
	'coverdisplaydate' => { 493 => 'coverDisplayDate' },
	'coveruri' => { 380 => 'cvru' },
	'cpufirmwareversion' => { 355 => 0x28 },
	'crc32' => { 481 => 'crc32' },
	'createdate' => { 119 => 0x9004, 157 => 'CreateDate', 306 => 'CreationDate', 310 => 'create-date', 371 => 'CreationDate', 377 => 0x1, 501 => 'CreateDate' },
	'creationdate' => { 374 => 'creationdate', 490 => 'CreationDate', 493 => 'creationDate' },
	'creationtime' => { 310 => 'Creation Time' },
	'creativestyle' => { 407 => 0x1a, 408 => 0x18, 418 => 0x41, 420 => 0xb020, 450 => 0x4a },
	'creativestylesetting' => { 409 => 0xf, 425 => 0x7 },
	'creativestylewaschanged' => { 454 => 0x8001 },
	'creator' => { 306 => 'Creator', 371 => 'Creator', 480 => 'creator', 489 => 'Creator', 490 => 'Creator' },
	'creatoraddress' => { 488 => [\'CreatorContactInfo','CreatorContactInfoCiAdrExtadr'] },
	'creatorappid' => { 178 => 'CreatorAppId' },
	'creatorcity' => { 488 => [\'CreatorContactInfo','CreatorContactInfoCiAdrCity'] },
	'creatorcontactinfo' => { 488 => 'CreatorContactInfo' },
	'creatorcountry' => { 488 => [\'CreatorContactInfo','CreatorContactInfoCiAdrCtry'] },
	'creatoridentifier' => { 489 => [\'Creator','CreatorIdentifier'] },
	'creatorname' => { 489 => [\'Creator','CreatorName'] },
	'creatoropenwithuioptions' => { 178 => 'CreatorOpenWithUIOptions' },
	'creatorpostalcode' => { 488 => [\'CreatorContactInfo','CreatorContactInfoCiAdrPcode'] },
	'creatorregion' => { 488 => [\'CreatorContactInfo','CreatorContactInfoCiAdrRegion'] },
	'creatorrole' => { 489 => [\'Creator','CreatorRole'] },
	'creatortool' => { 501 => 'CreatorTool' },
	'creatorworkemail' => { 488 => [\'CreatorContactInfo','CreatorContactInfoCiEmailWork'] },
	'creatorworktelephone' => { 488 => [\'CreatorContactInfo','CreatorContactInfoCiTelWork'] },
	'creatorworkurl' => { 488 => [\'CreatorContactInfo','CreatorContactInfoCiUrlWork'] },
	'credit' => { 131 => 0x6e, 491 => 'Credit' },
	'creditline' => { 496 => 'creditLine' },
	'creditlinereq' => { 506 => 'CreditLineReq' },
	'creditlinerequired' => { 307 => 'CreditLineRequired' },
	'cropactive' => { 101 => 0x0, 108 => 0x244 },
	'cropangle' => { 477 => 'CropAngle', 479 => 'CropAngle' },
	'croparea' => { 226 => 0x45, 454 => 0x9011 },
	'cropaspectratio' => { 103 => 0x30101, 108 => 0x260 },
	'cropaspectratiocustom' => { 103 => 0x30102 },
	'cropbottom' => { 123 => 0x9, 267 => 0x36, 325 => 0x31, 366 => 0xdc, 477 => 'CropBottom', 479 => 'CropBottom' },
	'cropbottommargin' => { 53 => 0x3 },
	'cropcircleactive' => { 109 => 0xd6 },
	'cropcircleradius' => { 109 => 0xd9 },
	'cropcirclex' => { 109 => 0xd7 },
	'cropcircley' => { 109 => 0xd8 },
	'cropconstraintowarp' => { 477 => 'CropConstrainToWarp', 479 => 'CropConstrainToWarp' },
	'croph' => { 471 => 'CropH' },
	'cropheight' => { 101 => 0x6, 108 => 0x24c, 301 => 0x615, 305 => 0x615, 477 => 'CropHeight', 479 => 'CropHeight' },
	'crophispeed' => { 226 => 0x1b },
	'cropleft' => { 108 => 0x246, 123 => 0x6, 267 => 0x1e, 301 => 0x612, 305 => 0x612, 325 => 0x30, 366 => 0xd9, 477 => 'CropLeft', 479 => 'CropLeft' },
	'cropleftmargin' => { 53 => 0x0 },
	'cropmode' => { 127 => 0x104d, 387 => 0x1018 },
	'croporiginalheight' => { 101 => 0xb },
	'croporiginalwidth' => { 101 => 0xa },
	'cropoutputheight' => { 267 => 0xce },
	'cropoutputheightinches' => { 267 => 0x96 },
	'cropoutputpixels' => { 267 => 0xd6 },
	'cropoutputresolution' => { 267 => 0xb6 },
	'cropoutputscale' => { 267 => 0xbe },
	'cropoutputwidth' => { 267 => 0xc6 },
	'cropoutputwidthinches' => { 267 => 0x8e },
	'croppedareaimageheightpixels' => { 465 => 'CroppedAreaImageHeightPixels', 466 => 'CroppedAreaImageHeightPixels' },
	'croppedareaimagewidthpixels' => { 465 => 'CroppedAreaImageWidthPixels', 466 => 'CroppedAreaImageWidthPixels' },
	'croppedarealeftpixels' => { 465 => 'CroppedAreaLeftPixels', 466 => 'CroppedAreaLeftPixels' },
	'croppedareatoppixels' => { 465 => 'CroppedAreaTopPixels', 466 => 'CroppedAreaTopPixels' },
	'croppedimageheight' => { 5 => 0x2, 387 => 0x1604 },
	'croppedimageleft' => { 5 => 0x3 },
	'croppedimagetop' => { 5 => 0x4 },
	'croppedimagewidth' => { 5 => 0x1, 387 => 0x1603 },
	'cropping' => { 454 => 0x9010 },
	'cropright' => { 123 => 0x8, 267 => 0x2e, 325 => 0x32, 366 => 0xdb, 477 => 'CropRight', 479 => 'CropRight' },
	'croprightmargin' => { 53 => 0x1 },
	'croprotatedoriginalheight' => { 101 => 0x2 },
	'croprotatedoriginalwidth' => { 101 => 0x1 },
	'croprotation' => { 101 => 0x8, 123 => 0xb },
	'cropscaledresolution' => { 267 => 0x9e },
	'cropsourceresolution' => { 267 => 0xae },
	'croptop' => { 108 => 0x248, 123 => 0x7, 267 => 0x26, 301 => 0x613, 305 => 0x613, 325 => 0x2f, 366 => 0xda, 477 => 'CropTop', 479 => 'CropTop' },
	'croptopmargin' => { 53 => 0x2 },
	'cropunit' => { 477 => 'CropUnit', 479 => 'CropUnit' },
	'cropunits' => { 477 => 'CropUnits', 479 => 'CropUnits' },
	'cropw' => { 471 => 'CropW' },
	'cropwidth' => { 101 => 0x5, 108 => 0x24a, 301 => 0x614, 305 => 0x614, 477 => 'CropWidth', 479 => 'CropWidth' },
	'cropx' => { 101 => 0x3, 471 => 'CropX' },
	'cropy' => { 101 => 0x4, 471 => 'CropY' },
	'crossprocess' => { 355 => 0x7b },
	'crossprocessparams' => { 355 => 0x235 },
	'cuisine' => { 495 => 'cuisine' },
	'currenticcprofile' => { 119 => 0xc691 },
	'currentpreprofilematrix' => { 119 => 0xc692 },
	'currentversion' => { 454 => 0xd000 },
	'curve0x' => { 471 => 'Curve0x' },
	'curve0y' => { 471 => 'Curve0y' },
	'curve1x' => { 471 => 'Curve1x' },
	'curve1y' => { 471 => 'Curve1y' },
	'curve2x' => { 471 => 'Curve2x' },
	'curve2y' => { 471 => 'Curve2y' },
	'curve3x' => { 471 => 'Curve3x' },
	'curve3y' => { 471 => 'Curve3y' },
	'curve4x' => { 471 => 'Curve4x' },
	'curve4y' => { 471 => 'Curve4y' },
	'curves' => { 272 => 0x76a43201 },
	'custom1' => { 307 => 'Custom1' },
	'custom10' => { 307 => 'Custom10' },
	'custom2' => { 307 => 'Custom2' },
	'custom3' => { 307 => 'Custom3' },
	'custom4' => { 307 => 'Custom4' },
	'custom5' => { 307 => 'Custom5' },
	'custom6' => { 307 => 'Custom6' },
	'custom7' => { 307 => 'Custom7' },
	'custom8' => { 307 => 'Custom8' },
	'custom9' => { 307 => 'Custom9' },
	'customcolortone' => { 109 => 0x4c },
	'customcontrast' => { 109 => 0x4e },
	'customcontrols' => { 84 => 0x70c },
	'customdefaultunsharpfineness' => { 109 => 0xbe },
	'customdefaultunsharpstrength' => { 109 => 0xbc },
	'customdefaultunsharpthreshold' => { 109 => 0xc0 },
	'customilluminant' => { 138 => 0x405 },
	'customizedials' => { 84 => 0x715 },
	'customlinear' => { 109 => 0x4f },
	'customoutputhighlightpoint' => { 109 => 0x53 },
	'customoutputshadowpoint' => { 109 => 0x54 },
	'custompicturestyle' => { 103 => 0x10021 },
	'custompicturestyledata' => { 103 => 0xf0500 },
	'custompicturestylefilename' => { 64 => 0x4010 },
	'customrawhighlight' => { 109 => 0x7c },
	'customrawhighlightpoint' => { 109 => 0x51 },
	'customrawshadow' => { 109 => 0x85 },
	'customrawshadowpoint' => { 109 => 0x52 },
	'customrendered' => { 119 => 0xa401, 483 => 'CustomRendered' },
	'customsaturation' => { 109 => 0x4d, 297 => 0x503 },
	'customsettingsalldefault' => { 279 => '0.2', 288 => '0.2' },
	'customsettingsbank' => { 279 => '0.1', 280 => '0.1', 282 => '0.1', 283 => '0.1', 288 => '0.1', 292 => '0.2', 293 => '0.2', 295 => 0x1 },
	'customsharpness' => { 109 => 0x50 },
	'customunsharpmaskfineness' => { 109 => 0xb8 },
	'customunsharpmaskstrength' => { 109 => 0xb6 },
	'customunsharpmaskthreshold' => { 109 => 0xba },
	'customwb_rblevels' => { 425 => 0x1a },
	'customwb_rgblevels' => { 408 => 0x8, 409 => 0x19 },
	'customwbbluelevel' => { 184 => 0x36 },
	'customwberror' => { 184 => 0x37 },
	'customwbgreenlevel' => { 184 => 0x35 },
	'customwbredlevel' => { 184 => 0x34 },
	'customwbsetting' => { 184 => 0x26 },
	'cx' => { 380 => '_cx_' },
	'cy' => { 380 => '_cy_' },
	'd-lightinghq' => { 272 => 0x2175eb78 },
	'd-lightinghqcolorboost' => { 268 => 0x2 },
	'd-lightinghqhighlight' => { 268 => 0x1 },
	'd-lightinghqselected' => { 272 => 0x6a6e36b6 },
	'd-lightinghqshadow' => { 268 => 0x0 },
	'd-lightinghs' => { 272 => 0xce5554aa },
	'd-lightinghsadjustment' => { 269 => 0x0 },
	'd-lightinghscolorboost' => { 269 => 0x1 },
	'd-rangeoptimizerhighlight' => { 454 => 0x8024 },
	'd-rangeoptimizermode' => { 454 => 0x8022 },
	'd-rangeoptimizershadow' => { 454 => 0x802d },
	'd-rangeoptimizervalue' => { 454 => 0x8023 },
	'darkblacksegrows' => { 138 => 0x18d8 },
	'darkfocusenvironment' => { 320 => 0x8003 },
	'darkframecountfactor' => { 138 => 0xc85 },
	'darkframelongexposure' => { 138 => 0xc84 },
	'darkframeshortexposure' => { 138 => 0xc83 },
	'darkpedestal' => { 138 => 0xc7f },
	'datacompressionmethod' => { 133 => 0x6e },
	'dataimprint' => { 181 => 0x34 },
	'dataonscreen' => { 489 => 'DataOnScreen' },
	'dataonscreenregion' => { 489 => [\'DataOnScreen','DataOnScreenRegion'] },
	'dataonscreenregiond' => { 489 => [\'DataOnScreen','DataOnScreenRegionD'] },
	'dataonscreenregionh' => { 489 => [\'DataOnScreen','DataOnScreenRegionH'] },
	'dataonscreenregiontext' => { 489 => [\'DataOnScreen','DataOnScreenRegionText'] },
	'dataonscreenregionunit' => { 489 => [\'DataOnScreen','DataOnScreenRegionUnit'] },
	'dataonscreenregionw' => { 489 => [\'DataOnScreen','DataOnScreenRegionW'] },
	'dataonscreenregionx' => { 489 => [\'DataOnScreen','DataOnScreenRegionX'] },
	'dataonscreenregiony' => { 489 => [\'DataOnScreen','DataOnScreenRegionY'] },
	'datascaling' => { 355 => 0x3d },
	'date' => { 355 => 0x6, 480 => 'date' },
	'dateacquired' => { 178 => 'DateAcquired', 179 => '{2CBAA8F5-D81F-47CA-B17A-F8D822300131} 100' },
	'datecreated' => { 131 => 0x37, 491 => 'DateCreated' },
	'datedisplayformat' => { 264 => 0x3 },
	'dateidentified' => { 118 => [\'Identification','IdentificationDateIdentified'] },
	'dateimprint' => { 284 => '4.2' },
	'daterecieved' => { 493 => 'dateRecieved' },
	'datesent' => { 132 => 0x46 },
	'datestampmode' => { 64 => 0x1c, 226 => 0x9d },
	'datetime' => { 472 => 'datetime', 499 => 'DateTime' },
	'datetimedigitized' => { 483 => 'DateTimeDigitized' },
	'datetimeoriginal' => { 100 => 0x0, 119 => 0x9003, 154 => 0x14, 157 => 'OriginalDate', 375 => 'IDIT', 380 => 'date', 381 => 0xb, 382 => 0x3b, 383 => 0x3e, 483 => 'DateTimeOriginal' },
	'datetimestamp' => { 140 => 0x64 },
	'datetimeutc' => { 297 => 0x908 },
	'daylightsavings' => { 78 => 0x3, 264 => 0x2 },
	'dayofweek' => { 382 => 0x42, 383 => 0x4a },
	'dccontinent' => { 118 => [\'dctermsLocation','dctermsLocationContinent'] },
	'dccoordinateprecision' => { 118 => [\'dctermsLocation','dctermsLocationCoordinatePrecision'] },
	'dccoordinateuncertaintyinmeters' => { 118 => [\'dctermsLocation','dctermsLocationCoordinateUncertaintyInMeters'] },
	'dccountry' => { 118 => [\'dctermsLocation','dctermsLocationCountry'] },
	'dccountrycode' => { 118 => [\'dctermsLocation','dctermsLocationCountryCode'] },
	'dccounty' => { 118 => [\'dctermsLocation','dctermsLocationCounty'] },
	'dcdecimallatitude' => { 118 => [\'dctermsLocation','dctermsLocationDecimalLatitude'] },
	'dcdecimallongitude' => { 118 => [\'dctermsLocation','dctermsLocationDecimalLongitude'] },
	'dcevent' => { 118 => 'Event' },
	'dcfootprintspatialfit' => { 118 => [\'dctermsLocation','dctermsLocationFootprintSpatialFit'] },
	'dcfootprintsrs' => { 118 => [\'dctermsLocation','dctermsLocationFootprintSRS'] },
	'dcfootprintwkt' => { 118 => [\'dctermsLocation','dctermsLocationFootprintWKT'] },
	'dcgeodeticdatum' => { 118 => [\'dctermsLocation','dctermsLocationGeodeticDatum'] },
	'dcgeoreferencedby' => { 118 => [\'dctermsLocation','dctermsLocationGeoreferencedBy'] },
	'dcgeoreferenceddate' => { 118 => [\'dctermsLocation','dctermsLocationGeoreferencedDate'] },
	'dcgeoreferenceprotocol' => { 118 => [\'dctermsLocation','dctermsLocationGeoreferenceProtocol'] },
	'dcgeoreferenceremarks' => { 118 => [\'dctermsLocation','dctermsLocationGeoreferenceRemarks'] },
	'dcgeoreferencesources' => { 118 => [\'dctermsLocation','dctermsLocationGeoreferenceSources'] },
	'dcgeoreferenceverificationstatus' => { 118 => [\'dctermsLocation','dctermsLocationGeoreferenceVerificationStatus'] },
	'dchighergeography' => { 118 => [\'dctermsLocation','dctermsLocationHigherGeography'] },
	'dchighergeographyid' => { 118 => [\'dctermsLocation','dctermsLocationHigherGeographyID'] },
	'dcisland' => { 118 => [\'dctermsLocation','dctermsLocationIsland'] },
	'dcislandgroup' => { 118 => [\'dctermsLocation','dctermsLocationIslandGroup'] },
	'dclocality' => { 118 => [\'dctermsLocation','dctermsLocationLocality'] },
	'dclocationaccordingto' => { 118 => [\'dctermsLocation','dctermsLocationLocationAccordingTo'] },
	'dclocationid' => { 118 => [\'dctermsLocation','dctermsLocationLocationID'] },
	'dclocationremarks' => { 118 => [\'dctermsLocation','dctermsLocationLocationRemarks'] },
	'dcmaximumdepthinmeters' => { 118 => [\'dctermsLocation','dctermsLocationMaximumDepthInMeters'] },
	'dcmaximumdistanceabovesurfaceinmeters' => { 118 => [\'dctermsLocation','dctermsLocationMaximumDistanceAboveSurfaceInMeters'] },
	'dcmaximumelevationinmeters' => { 118 => [\'dctermsLocation','dctermsLocationMaximumElevationInMeters'] },
	'dcminimumdepthinmeters' => { 118 => [\'dctermsLocation','dctermsLocationMinimumDepthInMeters'] },
	'dcminimumdistanceabovesurfaceinmeters' => { 118 => [\'dctermsLocation','dctermsLocationMinimumDistanceAboveSurfaceInMeters'] },
	'dcminimumelevationinmeters' => { 118 => [\'dctermsLocation','dctermsLocationMinimumElevationInMeters'] },
	'dcmunicipality' => { 118 => [\'dctermsLocation','dctermsLocationMunicipality'] },
	'dcpointradiusspatialfit' => { 118 => [\'dctermsLocation','dctermsLocationPointRadiusSpatialFit'] },
	'dcstateprovince' => { 118 => [\'dctermsLocation','dctermsLocationStateProvince'] },
	'dctermslocation' => { 118 => 'dctermsLocation' },
	'dcverbatimcoordinates' => { 118 => [\'dctermsLocation','dctermsLocationVerbatimCoordinates'] },
	'dcverbatimcoordinatesystem' => { 118 => [\'dctermsLocation','dctermsLocationVerbatimCoordinateSystem'] },
	'dcverbatimdepth' => { 118 => [\'dctermsLocation','dctermsLocationVerbatimDepth'] },
	'dcverbatimelevation' => { 118 => [\'dctermsLocation','dctermsLocationVerbatimElevation'] },
	'dcverbatimlatitude' => { 118 => [\'dctermsLocation','dctermsLocationVerbatimLatitude'] },
	'dcverbatimlocality' => { 118 => [\'dctermsLocation','dctermsLocationVerbatimLocality'] },
	'dcverbatimlongitude' => { 118 => [\'dctermsLocation','dctermsLocationVerbatimLongitude'] },
	'dcverbatimsrs' => { 118 => [\'dctermsLocation','dctermsLocationVerbatimSRS'] },
	'dcwaterbody' => { 118 => [\'dctermsLocation','dctermsLocationWaterBody'] },
	'declination' => { 165 => 'Declination' },
	'decposition' => { 181 => 0x32 },
	'defaultautogray' => { 477 => 'DefaultAutoGray', 479 => 'DefaultAutoGray' },
	'defaultautotone' => { 477 => 'DefaultAutoTone', 479 => 'DefaultAutoTone' },
	'defaultblackrender' => { 119 => 0xc7a6 },
	'defaultcroporigin' => { 119 => 0xc61f },
	'defaultcropsize' => { 119 => 0xc620 },
	'defaulteraseoption' => { 84 => 0x813 },
	'defaultscale' => { 119 => 0xc61e },
	'defaultsspecifictoiso' => { 477 => 'DefaultsSpecificToISO', 479 => 'DefaultsSpecificToISO' },
	'defaultsspecifictoserial' => { 477 => 'DefaultsSpecificToSerial', 479 => 'DefaultsSpecificToSerial' },
	'defaultusercrop' => { 119 => 0xc7b5 },
	'defectisocode' => { 138 => 0x90f },
	'defringe' => { 477 => 'Defringe', 479 => 'Defringe' },
	'defringegreenamount' => { 477 => 'DefringeGreenAmount', 479 => 'DefringeGreenAmount' },
	'defringegreenhuehi' => { 477 => 'DefringeGreenHueHi', 479 => 'DefringeGreenHueHi' },
	'defringegreenhuelo' => { 477 => 'DefringeGreenHueLo', 479 => 'DefringeGreenHueLo' },
	'defringepurpleamount' => { 477 => 'DefringePurpleAmount', 479 => 'DefringePurpleAmount' },
	'defringepurplehuehi' => { 477 => 'DefringePurpleHueHi', 479 => 'DefringePurpleHueHi' },
	'defringepurplehuelo' => { 477 => 'DefringePurpleHueLo', 479 => 'DefringePurpleHueLo' },
	'dehaze' => { 477 => 'Dehaze', 479 => 'Dehaze' },
	'deletedimagecount' => { 226 => 0xa6, 238 => 0x6e },
	'deprecatedon' => { 475 => 'deprecatedOn' },
	'depthfar' => { 119 => 0xc7eb },
	'depthformat' => { 119 => 0xc7e9 },
	'depthimage' => { 462 => 'Data' },
	'depthmeasuretype' => { 119 => 0xc7ed },
	'depthnear' => { 119 => 0xc7ea },
	'depthunits' => { 119 => 0xc7ec },
	'derivedfrom' => { 504 => 'DerivedFrom' },
	'derivedfromalternatepaths' => { 504 => [\'DerivedFrom','DerivedFromAlternatePaths'] },
	'derivedfromdocumentid' => { 504 => [\'DerivedFrom','DerivedFromDocumentID'] },
	'derivedfromfilepath' => { 504 => [\'DerivedFrom','DerivedFromFilePath'] },
	'derivedfromfrompart' => { 504 => [\'DerivedFrom','DerivedFromFromPart'] },
	'derivedfrominstanceid' => { 504 => [\'DerivedFrom','DerivedFromInstanceID'] },
	'derivedfromlastmodifydate' => { 504 => [\'DerivedFrom','DerivedFromLastModifyDate'] },
	'derivedfromlasturl' => { 504 => [\'DerivedFrom','DerivedFromLastURL'] },
	'derivedfromlinkcategory' => { 504 => [\'DerivedFrom','DerivedFromLinkCategory'] },
	'derivedfromlinkform' => { 504 => [\'DerivedFrom','DerivedFromLinkForm'] },
	'derivedfrommanager' => { 504 => [\'DerivedFrom','DerivedFromManager'] },
	'derivedfrommanagervariant' => { 504 => [\'DerivedFrom','DerivedFromManagerVariant'] },
	'derivedfrommanageto' => { 504 => [\'DerivedFrom','DerivedFromManageTo'] },
	'derivedfrommanageui' => { 504 => [\'DerivedFrom','DerivedFromManageUI'] },
	'derivedfrommaskmarkers' => { 504 => [\'DerivedFrom','DerivedFromMaskMarkers'] },
	'derivedfromoriginaldocumentid' => { 504 => [\'DerivedFrom','DerivedFromOriginalDocumentID'] },
	'derivedfrompartmapping' => { 504 => [\'DerivedFrom','DerivedFromPartMapping'] },
	'derivedfromplacedresolutionunit' => { 504 => [\'DerivedFrom','DerivedFromPlacedResolutionUnit'] },
	'derivedfromplacedxresolution' => { 504 => [\'DerivedFrom','DerivedFromPlacedXResolution'] },
	'derivedfromplacedyresolution' => { 504 => [\'DerivedFrom','DerivedFromPlacedYResolution'] },
	'derivedfromrenditionclass' => { 504 => [\'DerivedFrom','DerivedFromRenditionClass'] },
	'derivedfromrenditionparams' => { 504 => [\'DerivedFrom','DerivedFromRenditionParams'] },
	'derivedfromtopart' => { 504 => [\'DerivedFrom','DerivedFromToPart'] },
	'derivedfromversionid' => { 504 => [\'DerivedFrom','DerivedFromVersionID'] },
	'description' => { 310 => 'Description', 372 => ['desc','dscp',"\xa9des"], 374 => 'description', 380 => 'dscp', 477 => 'Description', 479 => 'Description', 480 => 'description', 501 => 'Description' },
	'destination' => { 132 => 0x5 },
	'destinationcity' => { 355 => 0x24, 361 => 0x3 },
	'destinationcitycode' => { 362 => 0x1001 },
	'destinationdst' => { 355 => 0x26, 361 => '0.3' },
	'developmentdynamicrange' => { 127 => 0x1403 },
	'deviantmatrixcustom' => { 138 => 0x7de },
	'deviantmatrixdaylight' => { 138 => 0x7da },
	'deviantmatrixflash' => { 138 => 0x7dd },
	'deviantmatrixfluorescent' => { 138 => 0x7dc },
	'deviantmatrixtungsten' => { 138 => 0x7db },
	'deviantwhitecustom' => { 138 => 0x842 },
	'deviantwhitedaylight' => { 138 => 0x83e },
	'deviantwhiteflash' => { 138 => 0x841 },
	'deviantwhitefluorescent' => { 138 => 0x840 },
	'deviantwhitetungsten' => { 138 => 0x83f },
	'device' => { 493 => 'device' },
	'devicesettingdescription' => { 483 => 'DeviceSettingDescription' },
	'devicesettingdescriptioncolumns' => { 483 => [\'DeviceSettingDescription','DeviceSettingDescriptionColumns'] },
	'devicesettingdescriptionrows' => { 483 => [\'DeviceSettingDescription','DeviceSettingDescriptionRows'] },
	'devicesettingdescriptionsettings' => { 483 => [\'DeviceSettingDescription','DeviceSettingDescriptionSettings'] },
	'devicetype' => { 394 => 0x2 },
	'dewarpdata' => { 116 => 'DewarpData' },
	'dewarpflag' => { 116 => 'DewarpFlag' },
	'dialdirectiontvav' => { 84 => 0x706 },
	'dietaryneeds' => { 495 => 'dietaryNeeds' },
	'diffractioncompensation' => { 228 => 0x142, 229 => 0x1a2, 252 => 0xc4a0 },
	'diffractioncorrection' => { 320 => 0xbc, 345 => 0x3 },
	'diffractioncorrectionon' => { 103 => 0x2070b },
	'digitalcreationdate' => { 131 => 0x3e },
	'digitalcreationtime' => { 131 => 0x3f },
	'digitaldeehighlightadj' => { 237 => 0x202 },
	'digitaldeeshadowadj' => { 237 => 0x200 },
	'digitaldeethreshold' => { 237 => 0x201 },
	'digitalfilter' => { 397 => 0x59 },
	'digitalfilter01' => { 342 => 0x5 },
	'digitalfilter02' => { 342 => 0x16 },
	'digitalfilter03' => { 342 => 0x27 },
	'digitalfilter04' => { 342 => 0x38 },
	'digitalfilter05' => { 342 => 0x49 },
	'digitalfilter06' => { 342 => 0x5a },
	'digitalfilter07' => { 342 => 0x6b },
	'digitalfilter08' => { 342 => 0x7c },
	'digitalfilter09' => { 342 => 0x8d },
	'digitalfilter10' => { 342 => 0x9e },
	'digitalfilter11' => { 342 => 0xaf },
	'digitalfilter12' => { 342 => 0xc0 },
	'digitalfilter13' => { 342 => 0xd1 },
	'digitalfilter14' => { 342 => 0xe2 },
	'digitalfilter15' => { 342 => 0xf3 },
	'digitalfilter16' => { 342 => 0x104 },
	'digitalfilter17' => { 342 => 0x115 },
	'digitalfilter18' => { 342 => 0x126 },
	'digitalfilter19' => { 342 => 0x137 },
	'digitalfilter20' => { 342 => 0x148 },
	'digitalgain' => { 74 => 0xb },
	'digitalgem' => { 215 => 0x0 },
	'digitalice' => { 237 => 0x100 },
	'digitalimageguid' => { 489 => 'DigImageGUID' },
	'digitalroc' => { 235 => 0x0 },
	'digitalsourcefiletype' => { 489 => 'DigitalSourcefileType' },
	'digitalsourcetype' => { 489 => 'DigitalSourceType' },
	'digitalzoom' => { 34 => 0xc, 112 => 0xa, 127 => 0x1044, 140 => 0x68, 151 => 0x22, 152 => 0x1e, 156 => 'DigitalZoom', 181 => 0xc, 226 => 0x86, 262 => 0xa, 302 => 0x204, 355 => 0x1e, 362 => 0xa, 396 => 0x204, 441 => 0x12, 442 => 0x12 },
	'digitalzoomon' => { 396 => 0x21b },
	'digitalzoomratio' => { 119 => 0xa404, 430 => 0x200, 432 => 0x21c, 483 => 'DigitalZoomRatio' },
	'director' => { 179 => 'WM/Director', 372 => "\xa9dir", 374 => 'director', 380 => "\xa9dir", 503 => 'director' },
	'directorphotography' => { 503 => 'directorPhotography' },
	'directory' => { 120 => 'Directory' },
	'directoryindex' => { 7 => 0x137, 9 => 0x2dc, 11 => 0x17e, 13 => 0x238, 14 => 0x13f, 15 => 0x133, 16 => 0x1df, 17 => 0x1a7, 18 => 0x1f0, 19 => 0xcc, 20 => 0x1c7, 21 => 0x298, 22 => 0x1e7, 23 => 0x1e5, 24 => [0x27c,0x280], 25 => 0x2b6, 26 => 0x2bf, 28 => 0x1f7, 29 => 0x4ba },
	'directoryindex2' => { 21 => 0x29c },
	'directorynumber' => { 208 => 0x3, 383 => 0x12 },
	'disableautocreation' => { 460 => 'DisableAutoCreation' },
	'disclaimer' => { 310 => 'Disclaimer' },
	'discnumber' => { 503 => 'discNumber' },
	'dishtype' => { 495 => 'dishType' },
	'disknumber' => { 372 => 'disk' },
	'displayallafpoints' => { 84 => 0x514 },
	'displayaperture' => { 34 => 0x23 },
	'displayedunitsx' => { 370 => 0x2 },
	'displayedunitsy' => { 370 => 0x6 },
	'displayname' => { 374 => 'displayname', 492 => 'displayName' },
	'distance1' => { 140 => 0x28 },
	'distance2' => { 140 => 0x2c },
	'distance3' => { 140 => 0x30 },
	'distance4' => { 140 => 0x34 },
	'distortion' => { 394 => 0xa050 },
	'distortioncompensation' => { 454 => 0x8040 },
	'distortioncontrol' => { 238 => 0x10 },
	'distortioncorrection' => { 79 => 0x3, 103 => 0x20705, 109 => 0x67, 119 => 0x7036, 297 => 0x50b, 324 => '7.1', 345 => 0x0, 449 => 0x601, 450 => 0x5b },
	'distortioncorrection2' => { 301 => 0x1011 },
	'distortioncorrectionalreadyapplied' => { 474 => 'DistortionCorrectionAlreadyApplied' },
	'distortioncorrectionon' => { 103 => '0x20705.0', 109 => 0x63 },
	'distortioncorrectionsetting' => { 80 => 0x7, 420 => 0x2013 },
	'distortioncorrectionvalue' => { 79 => 0x9 },
	'distortioncorrparams' => { 119 => 0x7037, 429 => 0x1a23, 432 => 0x1870, 434 => 0x189c, 435 => 0x18cc, 436 => 0x17d0, 449 => 0x6ca, 450 => 0x64 },
	'distortioncorrparamsnumber' => { 432 => 0x1899, 434 => 0x18c5, 435 => 0x18f5, 436 => 0x17f9 },
	'distortioncorrparamspresent' => { 432 => 0x1898, 434 => 0x18c4, 435 => 0x18f4, 436 => 0x17f8, 438 => 0x10b, 439 => 0x10b, 449 => 0x600, 450 => 0x5a },
	'distortioneffect' => { 103 => 0x20709 },
	'distortionn' => { 324 => 0xc },
	'distortionparam02' => { 324 => 0x2 },
	'distortionparam04' => { 324 => 0x4 },
	'distortionparam08' => { 324 => 0x8 },
	'distortionparam09' => { 324 => 0x9 },
	'distortionparam11' => { 324 => 0xb },
	'distortionscale' => { 324 => 0x5 },
	'distributor' => { 493 => 'distributor' },
	'distributorproductid' => { 492 => 'distributorProductID' },
	'dloon' => { 103 => '0x20706.0', 109 => 0xdc },
	'dlosetting' => { 103 => 0x20706, 109 => 0xdd },
	'dlosettingapplied' => { 102 => 0x4 },
	'dloshootingdistance' => { 109 => 0xde },
	'dloversion' => { 102 => 0x5 },
	'dmcomment' => { 503 => 'comment' },
	'dmdithermatrix' => { 138 => 0xc7a },
	'dmdithermatrixheight' => { 138 => 0xc7c },
	'dmdithermatrixwidth' => { 138 => 0xc7b },
	'dngadobedata' => { 119 => 0xc634 },
	'dngbackwardversion' => { 119 => 0xc613 },
	'dngignoresidecars' => { 477 => 'DNGIgnoreSidecars', 479 => 'DNGIgnoreSidecars' },
	'dnglensinfo' => { 119 => 0xc630 },
	'dngprivatedata' => { 119 => 0xc634 },
	'dngversion' => { 119 => 0xc612 },
	'document' => { 310 => 'Document' },
	'documentancestors' => { 491 => 'DocumentAncestors' },
	'documenthistory' => { 131 => 0xe7 },
	'documentid' => { 504 => 'DocumentID' },
	'documentname' => { 119 => 0x10d },
	'documentnotes' => { 131 => 0xe6 },
	'doi' => { 493 => 'doi' },
	'dopesheet' => { 489 => 'Dopesheet' },
	'dopesheetlink' => { 489 => 'DopesheetLink' },
	'dopesheetlinklink' => { 489 => [\'DopesheetLink','DopesheetLinkLink'] },
	'dopesheetlinklinkqualifier' => { 489 => [\'DopesheetLink','DopesheetLinkLinkQualifier'] },
	'doublingmicrovolts' => { 138 => 0xc82 },
	'dpp' => { 472 => 'dpp' },
	'dr4cameramodel' => { 104 => 0x3 },
	'drangepriority' => { 127 => 0x1443 },
	'drangepriorityauto' => { 127 => 0x1444 },
	'drangepriorityfixed' => { 127 => 0x1445 },
	'drivemode' => { 113 => 0x3103, 125 => '0.1', 181 => 0x6, 184 => 0x1e, 187 => 0xe, 297 => 0x600, 355 => 0x34, 387 => 0x1002, 397 => 0x3, 407 => 0x4, 408 => 0x7e, 409 => 0x34 },
	'drivemode2' => { 184 => 0xa, 336 => 0x7, 418 => 0xe, 425 => 0x1 },
	'drivemodesetting' => { 409 => 0x4 },
	'drivespeed' => { 125 => '0.2' },
	'dspfirmwareversion' => { 355 => 0x27 },
	'duration' => { 67 => 0x6a, 155 => 'Duration', 169 => 'Duration', 495 => 'duration', 503 => 'duration' },
	'durationscale' => { 503 => [\'duration','durationScale'] },
	'durationvalue' => { 503 => [\'duration','durationValue'] },
	'dustremovaldata' => { 64 => 0x97 },
	'dxcropalert' => { 229 => 0x23c },
	'dynamicafarea' => { 279 => '1.4', 288 => '1.4' },
	'dynamicareaafassist' => { 295 => 0x18 },
	'dynamicareaafdisplay' => { 280 => '46.1', 282 => '47.1', 283 => '47.1', 292 => '47.1', 293 => '47.1' },
	'dynamicrange' => { 127 => 0x1400 },
	'dynamicrangeexpansion' => { 355 => 0x69, 387 => 0x100e },
	'dynamicrangemax' => { 108 => 0x7c },
	'dynamicrangemin' => { 108 => 0x7a },
	'dynamicrangeoptimizer' => { 184 => 0x15, 420 => [0xb025,0xb04f], 428 => 0x1144, 429 => [0x1144,0x324], 430 => [0x1120,0x300], 431 => [0x119c,0x37c], 432 => [0x1178,0x328], 433 => [0x1030,0x50], 434 => [0x228,0x50], 435 => [0x228,0x50], 436 => [0x21b,0x4e] },
	'dynamicrangeoptimizerbracket' => { 418 => 0x2e },
	'dynamicrangeoptimizerlevel' => { 407 => 0x19, 408 => 0x17, 409 => 0xd, 418 => 0x79, 425 => 0x5 },
	'dynamicrangeoptimizermode' => { 187 => 0x15, 407 => 0x18, 408 => 0x16, 418 => [0x77,0x15] },
	'dynamicrangeoptimizersetting' => { 184 => 0x27, 409 => 0xc, 425 => 0x4 },
	'dynamicrangesetting' => { 127 => 0x1402 },
	'e-dialinprogram' => { 336 => '1.3' },
	'earliestageorloweststage' => { 118 => [\'GeologicalContext','GeologicalContextEarliestAgeOrLowestStage'] },
	'earliesteonorlowesteonothem' => { 118 => [\'GeologicalContext','GeologicalContextEarliestEonOrLowestEonothem'] },
	'earliestepochorlowestseries' => { 118 => [\'GeologicalContext','GeologicalContextEarliestEpochOrLowestSeries'] },
	'earliesteraorlowesterathem' => { 118 => [\'GeologicalContext','GeologicalContextEarliestEraOrLowestErathem'] },
	'earliestperiodorlowestsystem' => { 118 => [\'GeologicalContext','GeologicalContextEarliestPeriodOrLowestSystem'] },
	'earthpos' => { 457 => 'EarthPos' },
	'earthposaltitude' => { 457 => [\'EarthPos','EarthPosAltitude'] },
	'earthposlatitude' => { 457 => [\'EarthPos','EarthPosLatitude'] },
	'earthposlongitude' => { 457 => [\'EarthPos','EarthPosLongitude'] },
	'earthposrotationw' => { 457 => [\'EarthPos','EarthPosRotationW'] },
	'earthposrotationx' => { 457 => [\'EarthPos','EarthPosRotationX'] },
	'earthposrotationy' => { 457 => [\'EarthPos','EarthPosRotationY'] },
	'earthposrotationz' => { 457 => [\'EarthPos','EarthPosRotationZ'] },
	'earthpostimestamp' => { 457 => [\'EarthPos','EarthPosTimestamp'] },
	'easyexposurecomp' => { 294 => '6.1' },
	'easyexposurecompensation' => { 279 => '6.4', 280 => '6.5', 282 => '6.3', 283 => '6.3', 287 => '5.1', 288 => '4.4', 289 => '5.2', 292 => '6.3', 293 => '6.3', 295 => 0x1d },
	'easymode' => { 34 => 0xb },
	'edgemapslope' => { 138 => 0x930 },
	'edgemapx1' => { 138 => 0x931 },
	'edgemapx2' => { 138 => 0x932 },
	'edgemapx3' => { 138 => 0x934 },
	'edgemapx4' => { 138 => 0x935 },
	'edgenoisereduction' => { 273 => 0x4, 454 => 0x8028 },
	'edit1' => { 380 => "\xa9ed1" },
	'edit2' => { 380 => "\xa9ed2" },
	'edit3' => { 380 => "\xa9ed3" },
	'edit4' => { 380 => "\xa9ed4" },
	'edit5' => { 380 => "\xa9ed5" },
	'edit6' => { 380 => "\xa9ed6" },
	'edit7' => { 380 => "\xa9ed7" },
	'edit8' => { 380 => "\xa9ed8" },
	'edit9' => { 380 => "\xa9ed9" },
	'edition' => { 493 => 'edition' },
	'editorialupdate' => { 131 => 0x8 },
	'editstatus' => { 131 => 0x7, 367 => 'EditStatus', 472 => 'EditStatus' },
	'editversionname' => { 272 => 0x3d136244 },
	'effectivelv' => { 355 => 0x2d },
	'effectivemaxaperture' => { 219 => 0x12, 220 => 0x13, 224 => 0x14 },
	'eissn' => { 493 => 'eIssn' },
	'electricalblackcolumns' => { 138 => 0x1810 },
	'electronicfront-curtainshutter' => { 282 => '5.2', 283 => '5.2', 292 => '5.3', 293 => '5.2' },
	'electronicfrontcurtainshutter' => { 420 => 0x201a },
	'elevation' => { 165 => 'Elevation' },
	'email' => { 157 => 'EMail' },
	'embargodate' => { 496 => 'embargoDate' },
	'embdencrightsexpr' => { 489 => 'EmbdEncRightsExpr' },
	'embeddedencodedrightsexpr' => { 489 => [\'EmbdEncRightsExpr','EmbdEncRightsExprEncRightsExpr'] },
	'embeddedencodedrightsexprlangid' => { 489 => [\'EmbdEncRightsExpr','EmbdEncRightsExprRightsExprLangId'] },
	'embeddedencodedrightsexprtype' => { 489 => [\'EmbdEncRightsExpr','EmbdEncRightsExprRightsExprEncType'] },
	'embeddedxmpdigest' => { 491 => 'EmbeddedXMPDigest' },
	'emissivity' => { 121 => 0x3 },
	'emptyslotrelease' => { 229 => 0x625 },
	'enablechromanoisereduction' => { 138 => 0xe6e },
	'enablesharpening' => { 138 => 0x92e },
	'encodedby' => { 179 => 'WM/EncodedBy', 372 => "\xa9enc" },
	'encodedwith' => { 374 => 'Encoded_With' },
	'encoder' => { 372 => "\xa9too", 380 => "\xa9too" },
	'encoderid' => { 380 => "\xa9enc" },
	'encodingtime' => { 179 => 'WM/EncodingTime' },
	'encryptionkey' => { 394 => 0xa020 },
	'endingpage' => { 493 => 'endingPage' },
	'enduser' => { 307 => 'EndUser' },
	'enduserid' => { 307 => [\'EndUser','EndUserEndUserID'] },
	'endusername' => { 307 => [\'EndUser','EndUserEndUserName'] },
	'energysavingmode' => { 229 => 0x648 },
	'engineer' => { 503 => 'engineer' },
	'enhancedarktones' => { 265 => 0x8 },
	'enhancement' => { 112 => 0x16, 113 => 0x3016 },
	'enhanceparams' => { 119 => 0xc7ee },
	'enhancer' => { 301 => 0x300 },
	'enhancervalues' => { 301 => 0x301 },
	'envelopenumber' => { 132 => 0x28 },
	'envelopepriority' => { 132 => 0x3c },
	'enveloperecordversion' => { 132 => 0x0 },
	'episode' => { 489 => 'Episode' },
	'episodeglobaluniqueid' => { 372 => 'egid' },
	'episodeidentifier' => { 489 => [\'Episode','EpisodeIdentifier'] },
	'episodename' => { 489 => [\'Episode','EpisodeName'] },
	'episodenumber' => { 489 => [\'Episode','EpisodeNumber'] },
	'epsonimageheight' => { 302 => 0x20c },
	'epsonimagewidth' => { 302 => 0x20b },
	'epsonsoftware' => { 302 => 0x20d },
	'equipmentinstitution' => { 456 => 'EquipmentInstitution' },
	'equipmentmanufacturer' => { 456 => 'EquipmentManufacturer' },
	'equipmentversion' => { 298 => 0x0 },
	'ettlii' => { 84 => 0x304, 85 => 0xd, 86 => 0xe, 87 => 0x7, 88 => 0x7, 89 => 0xe },
	'event' => { 458 => 'Event', 470 => 'Event', 489 => 'Event', 493 => 'event' },
	'eventalias' => { 492 => 'eventAlias' },
	'eventdate' => { 118 => [\'Event','EventEventDate'] },
	'eventday' => { 118 => [\'Event','EventDay'] },
	'eventearliestdate' => { 118 => [\'Event','EventEarliestDate'] },
	'eventend' => { 492 => 'eventEnd' },
	'eventenddayofyear' => { 118 => [\'Event','EventEndDayOfYear'] },
	'eventfieldnotes' => { 118 => [\'Event','EventFieldNotes'] },
	'eventfieldnumber' => { 118 => [\'Event','EventFieldNumber'] },
	'eventhabitat' => { 118 => [\'Event','EventHabitat'] },
	'eventid' => { 118 => [\'Event','EventEventID'], 489 => 'EventId' },
	'eventlatestdate' => { 118 => [\'Event','EventLatestDate'] },
	'eventmonth' => { 118 => [\'Event','EventMonth'] },
	'eventnumber' => { 381 => 0x9, 382 => 0x37, 383 => 0x3a },
	'eventparenteventid' => { 118 => [\'Event','EventParentEventID'] },
	'eventremarks' => { 118 => [\'Event','EventEventRemarks'] },
	'eventsamplesizeunit' => { 118 => [\'Event','EventSampleSizeUnit'] },
	'eventsamplesizevalue' => { 118 => [\'Event','EventSampleSizeValue'] },
	'eventsamplingeffort' => { 118 => [\'Event','EventSamplingEffort'] },
	'eventsamplingprotocol' => { 118 => [\'Event','EventSamplingProtocol'] },
	'eventstart' => { 492 => 'eventStart' },
	'eventstartdayofyear' => { 118 => [\'Event','EventStartDayOfYear'] },
	'eventsubtype' => { 492 => 'eventSubtype' },
	'eventtime' => { 118 => [\'Event','EventEventTime'] },
	'eventtype' => { 492 => 'eventType' },
	'eventverbatimeventdate' => { 118 => [\'Event','EventVerbatimEventDate'] },
	'eventyear' => { 118 => [\'Event','EventYear'] },
	'evfgrid' => { 295 => 0x165 },
	'evfimageframe' => { 295 => 0x164 },
	'evfreleaseindicator' => { 295 => 0x24f },
	'evfwarmdisplaybrightness' => { 295 => 0x24d },
	'evfwarmdisplaymode' => { 295 => 0x24b },
	'evsteps' => { 336 => '1.2', 338 => 0x0 },
	'evstepsize' => { 284 => '5.1', 285 => '6.1', 286 => '6.1', 290 => '0.7' },
	'exclusivecoverage' => { 467 => 'ExclusiveCoverage' },
	'exclusivityenddate' => { 496 => 'exclusivityEndDate' },
	'excursiontolerance' => { 133 => 0x82 },
	'executiveproducer' => { 372 => "\xa9xpd" },
	'exif' => { 120 => 'EXIF' },
	'exifbyteorder' => { 120 => 'ExifByteOrder' },
	'exifcamerainfo' => { 131 => 0xe8 },
	'exifimageheight' => { 119 => 0xa003, 483 => 'PixelYDimension' },
	'exifimagewidth' => { 119 => 0xa002, 483 => 'PixelXDimension' },
	'exifunicodebyteorder' => { 120 => 'ExifUnicodeByteOrder' },
	'exifversion' => { 119 => 0x9000, 483 => 'ExifVersion' },
	'exitpupilposition' => { 219 => 0x4, 220 => 0x4, 224 => 0x4 },
	'expirationdate' => { 131 => 0x25, 496 => 'expirationDate' },
	'expirationtime' => { 131 => 0x26 },
	'exposure' => { 119 => 0xfe51, 477 => 'Exposure', 479 => 'Exposure' },
	'exposure2012' => { 477 => 'Exposure2012', 479 => 'Exposure2012' },
	'exposureadj' => { 270 => 0x0 },
	'exposureadj2' => { 270 => 0x12 },
	'exposureadjust' => { 397 => 0xc },
	'exposurebracketingindicatorlast' => { 184 => 0x52 },
	'exposurebracketshotnumber' => { 187 => 0x2d, 418 => 0x2f },
	'exposurebracketstepsize' => { 336 => 0x8 },
	'exposurebracketvalue' => { 226 => 0x19 },
	'exposurecompautocancel' => { 84 => 0x113 },
	'exposurecompensation' => { 77 => 0x6, 93 => 0x0, 119 => 0x9204, 140 => 0x24, 156 => 'ExposureComp', 176 => 'ExposureCompensation', 181 => 0xd, 182 => 0x53, 183 => 0x1e, 187 => 0x49c0, 302 => 0x1006, 355 => 0x16, 364 => 0x402, 394 => 0xa013, 397 => [0xc,0x35,0x4d], 428 => 0x114c, 429 => 0x114c, 430 => 0x1128, 432 => 0x1180, 433 => 0x1038, 434 => 0x230, 435 => 0x230, 436 => 0x223, 483 => 'ExposureBiasValue' },
	'exposurecompensation2' => { 425 => [0x24,0x26,0x2a] },
	'exposurecompensationmode' => { 184 => 0x47, 187 => 0x2a },
	'exposurecompensationset' => { 407 => 0x3, 408 => 0x3, 409 => 0x3, 425 => 0x1e },
	'exposurecompensationsetting' => { 184 => 0x1 },
	'exposurecompstepsize' => { 279 => '6.3', 280 => '7.3', 282 => '7.3', 283 => '7.3', 288 => '4.3', 292 => '7.3', 293 => '7.3' },
	'exposurecontrolstep' => { 287 => '6.1', 289 => '6.1' },
	'exposurecontrolstepsize' => { 279 => '6.2', 280 => '7.1', 282 => '7.1', 283 => '7.1', 288 => '4.2', 292 => '7.1', 293 => '7.1', 294 => '7.1', 295 => 0x1b },
	'exposurecount' => { 127 => 0x1032 },
	'exposuredelaymode' => { 279 => '10.1', 280 => '11.1', 282 => '11.1', 283 => '11.1', 284 => '9.1', 285 => '10.1', 286 => '10.1', 288 => '10.4', 289 => '10.1', 290 => '6.4', 292 => '11.1', 293 => '11.1', 294 => '11.2' },
	'exposuredifference' => { 226 => 0xe },
	'exposuregaincustom' => { 138 => 0x89c },
	'exposuregaindaylight' => { 138 => 0x898 },
	'exposuregainflash' => { 138 => 0x89b },
	'exposuregainfluorescent' => { 138 => 0x89a },
	'exposuregaintungsten' => { 138 => 0x899 },
	'exposureindex' => { 119 => 0xa215, 483 => 'ExposureIndex' },
	'exposureindicator' => { 184 => 0x50 },
	'exposurelevelincrements' => { 82 => 0x6, 83 => 0x6, 84 => 0x101, 85 => 0x5, 86 => 0x6, 87 => 0x5, 88 => 0x5, 89 => 0x6, 90 => 0x4, 407 => 0x58, 408 => 0x58 },
	'exposurelockused' => { 465 => 'ExposureLockUsed' },
	'exposuremode' => { 119 => 0xa402, 156 => 'ExposureMode', 181 => 0x1, 182 => 0xa, 183 => 0x0, 184 => 0x0, 187 => 0x34, 297 => 0x200, 317 => 0x40d, 397 => 0x8, 420 => 0xb041, 483 => 'ExposureMode' },
	'exposuremodeinmanual' => { 84 => 0x10b },
	'exposureprogram' => { 119 => 0x8822, 387 => 0x1001, 400 => [0x17e,0x43], 407 => 0x3c, 408 => 0x3c, 409 => 0x5, 413 => 0x14, 418 => 0x3f, 425 => 0x2, 428 => 0x1175, 429 => 0x1179, 430 => 0x1155, 431 => 0x11d1, 432 => 0x11ad, 433 => 0x1065, 434 => 0x25d, 435 => 0x25d, 436 => 0x24c, 446 => 0xb, 447 => 0xc, 448 => 0xb, 450 => 0x48, 483 => 'ExposureProgram' },
	'exposureshift' => { 297 => 0x203 },
	'exposurestandardadjustment' => { 420 => 0x202d },
	'exposuretime' => { 7 => 0x4, 8 => 0x4, 9 => 0x4, 10 => 0x4, 11 => 0x4, 12 => 0x4, 13 => 0x4, 14 => 0x4, 15 => 0x4, 16 => 0x4, 17 => 0x4, 18 => 0x4, 19 => 0x4, 20 => 0x4, 21 => 0x4, 22 => 0x4, 23 => 0x4, 24 => 0x4, 25 => 0x4, 26 => 0x4, 27 => 0x4, 28 => 0x4, 29 => 0x4, 30 => 0x6, 31 => 0x7, 77 => 0x16, 119 => 0x829a, 137 => 0xfd05, 140 => 0x20, 142 => 0xfa24, 144 => 0xf104, 147 => 0x12, 149 => 0x38, 151 => 0x14, 152 => 0x10, 154 => 0x10, 156 => 'ExposureTime', 181 => 0x9, 182 => 0x35, 183 => 0x48, 184 => 0x8, 187 => 0x49b8, 355 => 0x12, 394 => 0xa018, 397 => [0x32,0x4a], 407 => 0x0, 408 => 0x0, 425 => [0x21,0x23,0x27], 450 => 0x10, 483 => 'ExposureTime' },
	'exposuretime2' => { 397 => [0x33,0x4b] },
	'exposuretuning' => { 226 => 0x1c },
	'exposurevalue' => { 138 => 0x3 },
	'exposurewarning' => { 127 => 0x1302 },
	'exrauto' => { 127 => 0x1033 },
	'exrmode' => { 127 => 0x1034 },
	'extdescraccessibility' => { 488 => 'ExtDescrAccessibility' },
	'extendedmenubanks' => { 229 => 0x114 },
	'extendedshutterspeeds' => { 295 => 0x102 },
	'extendedwbdetect' => { 297 => 0x902 },
	'extender' => { 298 => 0x301 },
	'extenderfirmwareversion' => { 298 => 0x304 },
	'extendermagnification' => { 158 => 'Magnification' },
	'extendermake' => { 158 => 'Make' },
	'extendermodel' => { 158 => 'Model', 298 => 0x303 },
	'extenderserialnumber' => { 158 => 'SerialNumber', 298 => 0x302 },
	'extenderstatus' => { 353 => 0x3 },
	'externalflash' => { 300 => 0x1201 },
	'externalflashae1' => { 302 => 0x101f },
	'externalflashae1_0' => { 302 => 0x101b },
	'externalflashae2' => { 302 => 0x1020 },
	'externalflashae2_0' => { 302 => 0x101c },
	'externalflashbounce' => { 300 => 0x1204, 302 => 0x1026, 343 => 0x1a },
	'externalflashcompensation' => { 211 => 0x1b },
	'externalflashexposurecomp' => { 226 => 0x17, 343 => 0x19 },
	'externalflashfirmware' => { 209 => 0x6, 210 => 0x6, 211 => 0x6, 212 => 0x6, 213 => 0x6, 214 => 0x6 },
	'externalflashflags' => { 209 => 0x8, 210 => 0x8, 211 => 0x8, 212 => 0x8 },
	'externalflashguidenumber' => { 300 => 0x1203, 343 => '24.1' },
	'externalflashgvalue' => { 302 => 0x1025 },
	'externalflashmode' => { 302 => 0x1028, 343 => 0x2 },
	'externalflashreadystate' => { 213 => '9.1' },
	'externalflashstatus' => { 213 => '8.2' },
	'externalflashzoom' => { 300 => 0x1205, 302 => 0x1027 },
	'externalflashzoomoverride' => { 213 => '8.1' },
	'externalmetadatalink' => { 489 => 'ExternalMetadataLink' },
	'externalsensorbrightnessvalue' => { 315 => 0x311, 318 => 0x311, 319 => 0x311, 322 => 0x3408 },
	'extrainfoversion' => { 411 => 0x1a },
	'eyestartaf' => { 184 => 0x40 },
	'fac100per' => { 138 => 0xe94 },
	'fac170per' => { 138 => 0xe93 },
	'fac18per' => { 138 => 0xe92 },
	'face10position' => { 110 => 0x3f4, 111 => 0x1ec, 207 => 0x28, 340 => 0x12 },
	'face10size' => { 341 => 0x12 },
	'face11position' => { 207 => 0x2c, 340 => 0x14 },
	'face11size' => { 341 => 0x14 },
	'face12position' => { 207 => 0x30, 340 => 0x16 },
	'face12size' => { 341 => 0x16 },
	'face13position' => { 340 => 0x18 },
	'face13size' => { 341 => 0x18 },
	'face14position' => { 340 => 0x1a },
	'face14size' => { 341 => 0x1a },
	'face15position' => { 340 => 0x1c },
	'face15size' => { 341 => 0x1c },
	'face16position' => { 340 => 0x1e },
	'face16size' => { 341 => 0x1e },
	'face17position' => { 340 => 0x20 },
	'face17size' => { 341 => 0x20 },
	'face18position' => { 340 => 0x22 },
	'face18size' => { 341 => 0x22 },
	'face19position' => { 340 => 0x24 },
	'face19size' => { 341 => 0x24 },
	'face1position' => { 54 => 0x8, 110 => 0xd, 111 => 0x18, 207 => 0x4, 312 => 0x1, 340 => 0x0, 384 => 0xbc, 414 => 0x1, 415 => 0x0, 416 => 0x0, 417 => 0x5b },
	'face1size' => { 341 => 0x0 },
	'face20position' => { 340 => 0x26 },
	'face20size' => { 341 => 0x26 },
	'face21position' => { 340 => 0x28 },
	'face21size' => { 341 => 0x28 },
	'face22position' => { 340 => 0x2a },
	'face22size' => { 341 => 0x2a },
	'face23position' => { 340 => 0x2c },
	'face23size' => { 341 => 0x2c },
	'face24position' => { 340 => 0x2e },
	'face24size' => { 341 => 0x2e },
	'face25position' => { 340 => 0x30 },
	'face25size' => { 341 => 0x30 },
	'face26position' => { 340 => 0x32 },
	'face26size' => { 341 => 0x32 },
	'face27position' => { 340 => 0x34 },
	'face27size' => { 341 => 0x34 },
	'face28position' => { 340 => 0x36 },
	'face28size' => { 341 => 0x36 },
	'face29position' => { 340 => 0x38 },
	'face29size' => { 341 => 0x38 },
	'face2position' => { 54 => 0xa, 110 => 0x7c, 111 => 0x4c, 207 => 0x8, 312 => 0x5, 340 => 0x2, 384 => 0xc8, 414 => 0x6, 415 => 0x20, 416 => 0x25, 417 => 0x65 },
	'face2size' => { 341 => 0x2 },
	'face30position' => { 340 => 0x3a },
	'face30size' => { 341 => 0x3a },
	'face31position' => { 340 => 0x3c },
	'face31size' => { 341 => 0x3c },
	'face32position' => { 340 => 0x3e },
	'face32size' => { 341 => 0x3e },
	'face3position' => { 54 => 0xc, 110 => 0xeb, 111 => 0x80, 207 => 0xc, 312 => 0x9, 340 => 0x4, 384 => 0xd4, 414 => 0xb, 415 => 0x40, 416 => 0x4a, 417 => 0x6f },
	'face3size' => { 341 => 0x4 },
	'face4position' => { 54 => 0xe, 110 => 0x15a, 111 => 0xb4, 207 => 0x10, 312 => 0xd, 340 => 0x6, 384 => 0xe0, 414 => 0x10, 415 => 0x60, 416 => 0x6f, 417 => 0x79 },
	'face4size' => { 341 => 0x6 },
	'face5position' => { 54 => 0x10, 110 => 0x1c9, 111 => 0xe8, 207 => 0x14, 312 => 0x11, 340 => 0x8, 384 => 0xec, 414 => 0x15, 415 => 0x80, 416 => 0x94 },
	'face5size' => { 341 => 0x8 },
	'face6position' => { 54 => 0x12, 110 => 0x238, 111 => 0x11c, 207 => 0x18, 340 => 0xa, 384 => 0xf8, 414 => 0x1a, 415 => 0xa0, 416 => 0xb9 },
	'face6size' => { 341 => 0xa },
	'face7position' => { 54 => 0x14, 110 => 0x2a7, 111 => 0x150, 207 => 0x1c, 340 => 0xc, 384 => 0x104, 414 => 0x1f, 415 => 0xc0, 416 => 0xde },
	'face7size' => { 341 => 0xc },
	'face8position' => { 54 => 0x16, 110 => 0x316, 111 => 0x184, 207 => 0x20, 340 => 0xe, 384 => 0x110, 414 => 0x24, 415 => 0xe0, 416 => 0x103 },
	'face8size' => { 341 => 0xe },
	'face9position' => { 54 => 0x18, 110 => 0x385, 111 => 0x1b8, 207 => 0x24, 340 => 0x10 },
	'face9size' => { 341 => 0x10 },
	'facebalanceorigi' => { 471 => 'FaceBalanceOrigI' },
	'facebalanceorigq' => { 471 => 'FaceBalanceOrigQ' },
	'facebalancestrength' => { 471 => 'FaceBalanceStrength' },
	'facebalancewarmth' => { 471 => 'FaceBalanceWarmth' },
	'facedetect' => { 355 => 0x76, 394 => 0x100 },
	'facedetectarea' => { 301 => 0x1201 },
	'facedetectframecrop' => { 301 => 0x1207 },
	'facedetectframesize' => { 54 => 0x3, 110 => 0x1, 111 => 0x4, 207 => 0x1, 301 => 0x1203, 355 => 0x77, 384 => 0xb6 },
	'facedetection' => { 409 => 0x30, 425 => 0x19 },
	'faceelementpositions' => { 127 => 0x4203 },
	'faceelementselected' => { 127 => 0x4005 },
	'faceelementtypes' => { 127 => 0x4201 },
	'faceid' => { 473 => 'FaceID' },
	'faceinfounknown' => { 113 => 0x2089 },
	'facename' => { 394 => 0x123 },
	'faceorientation' => { 111 => 0x8 },
	'faceposition' => { 339 => 0x2, 395 => 0x4 },
	'facepositions' => { 127 => 0x4103 },
	'facerecognition' => { 394 => 0x120 },
	'facesdetected' => { 54 => 0x2, 55 => 0x2, 56 => 0x3, 110 => 0x0, 111 => 0x2, 113 => 0x211c, 127 => 0x4100, 207 => 0x3, 301 => 0x1200, 320 => 0x3f, 339 => 0x0, 384 => 0xb5, 395 => 0x0, 414 => 0x0, 417 => 0x3, 427 => 0x30 },
	'facesrecognized' => { 313 => 0x0 },
	'facewidth' => { 55 => 0x1 },
	'fade' => { 420 => 0x2034 },
	'faithfuloutputhighlightpoint' => { 109 => 0x38 },
	'faithfuloutputshadowpoint' => { 109 => 0x39 },
	'faithfulrawcolortone' => { 109 => 0x31 },
	'faithfulrawcontrast' => { 109 => 0x33 },
	'faithfulrawhighlight' => { 109 => 0x79 },
	'faithfulrawhighlightpoint' => { 109 => 0x36 },
	'faithfulrawlinear' => { 109 => 0x34 },
	'faithfulrawsaturation' => { 109 => 0x32 },
	'faithfulrawshadow' => { 109 => 0x82 },
	'faithfulrawshadowpoint' => { 109 => 0x37 },
	'faithfulrawsharpness' => { 109 => 0x35 },
	'faithfulunsharpmaskfineness' => { 109 => 0xac },
	'faithfulunsharpmaskstrength' => { 109 => 0xaa },
	'faithfulunsharpmaskthreshold' => { 109 => 0xae },
	'far' => { 462 => 'Far' },
	'fastresetlinetime' => { 138 => 0x1860 },
	'feedidentifier' => { 489 => 'FeedIdentifier' },
	'femicroadjustment' => { 84 => 0x111 },
	'ffid' => { 481 => 'ffid' },
	'field' => { 492 => 'field' },
	'fieldcount' => { 302 => 0x103f },
	'fieldofview' => { 380 => "FOV\x00" },
	'fifoenonepixeldelay' => { 138 => 0x1901 },
	'filecreatedate' => { 120 => 'FileCreateDate' },
	'filedatarate' => { 503 => 'fileDataRate' },
	'fileformat' => { 95 => 0x0, 132 => 0x14, 397 => [0x22,0x26], 420 => 0xb000 },
	'filegroupid' => { 120 => 'FileGroupID' },
	'fileindex' => { 7 => 0x143, 9 => 0x2d0, 11 => 0x172, 13 => 0x22c, 14 => 0x133, 15 => 0x13f, 16 => 0x1d3, 17 => 0x19b, 18 => 0x1e4, 19 => 0xd0, 20 => 0x1bb, 21 => 0x28c, 22 => 0x1db, 23 => 0x1d9, 24 => [0x270,0x274], 25 => 0x2aa, 26 => 0x2b3, 28 => 0x1eb, 29 => 0x4ae, 321 => 0x0 },
	'fileindex2' => { 21 => 0x290 },
	'filemodifydate' => { 120 => 'FileModifyDate' },
	'filename' => { 120 => 'FileName' },
	'filenameasdelivered' => { 307 => 'FileNameAsDelivered' },
	'filenumber' => { 57 => 0x1, 64 => 0x8, 97 => 0x1817, 114 => 'Canon-FileNumber', 208 => 0x4, 383 => 0x10 },
	'filenumbermemory' => { 181 => 0x1a },
	'filenumbersequence' => { 279 => '12.2', 284 => '3.1', 285 => '4.1', 286 => '4.1', 288 => '11.1', 289 => '4.3', 294 => '5.2', 295 => 0x48 },
	'filepermissions' => { 120 => 'FilePermissions' },
	'filesource' => { 119 => 0xa300, 127 => 0x8000, 483 => 'FileSource' },
	'fileuserid' => { 120 => 'FileUserID' },
	'fileversion' => { 132 => 0x16 },
	'fillflashautoreduction' => { 82 => 0xe, 83 => 0xe, 90 => 0xa },
	'filllight' => { 477 => 'FillLight', 479 => 'FillLight' },
	'fillorder' => { 119 => 0x10a },
	'filmgraineffect' => { 297 => 0x538 },
	'filmmode' => { 127 => 0x1401, 317 => 0x412, 320 => 0x42 },
	'filmtype' => { 237 => 0x2 },
	'filtereffect' => { 57 => 0xe, 231 => 0x37, 232 => 0x3f, 233 => 0x47, 320 => 0xa1 },
	'filtereffectauto' => { 71 => 0xa0 },
	'filtereffectfaithful' => { 70 => 0x70, 71 => 0x70 },
	'filtereffectlandscape' => { 70 => 0x40, 71 => 0x40 },
	'filtereffectmonochrome' => { 19 => 0xff, 70 => 0x88, 71 => 0x88 },
	'filtereffectneutral' => { 70 => 0x58, 71 => 0x58 },
	'filtereffectportrait' => { 70 => 0x28, 71 => 0x28 },
	'filtereffectstandard' => { 70 => 0x10, 71 => 0x10 },
	'filtereffectuserdef1' => { 70 => 0xa0, 71 => 0xb8 },
	'filtereffectuserdef2' => { 70 => 0xb8, 71 => 0xd0 },
	'filtereffectuserdef3' => { 70 => 0xd0, 71 => 0xe8 },
	'finderdisplayduringexposure' => { 83 => 0x1 },
	'finesharpness' => { 355 => 0x70 },
	'finetuneoptcenterweighted' => { 279 => '7.2', 280 => '9.1', 282 => '9.1', 283 => '9.1', 287 => '8.1', 292 => '9.1', 293 => '9.1', 294 => '9.1', 295 => 0x23 },
	'finetuneopthighlightweighted' => { 282 => '46.1', 283 => '46.1', 292 => '46.1', 293 => '46.1', 295 => 0x27 },
	'finetuneoptmatrixmetering' => { 279 => '8.1', 280 => '8.2', 282 => '8.2', 283 => '8.2', 287 => '7.2', 288 => '6.1', 292 => '8.2', 293 => '8.2', 294 => '8.2', 295 => 0x21 },
	'finetuneoptspotmetering' => { 279 => '8.2', 280 => '9.2', 282 => '9.2', 283 => '9.2', 287 => '8.2', 288 => '6.2', 292 => '9.2', 293 => '9.2', 294 => '9.2', 295 => 0x25 },
	'finishexposure' => { 138 => 0xdbd },
	'finishfiletype' => { 138 => 0xdb8 },
	'finishlook' => { 138 => 0xdbc },
	'finishnoise' => { 138 => 0xdba },
	'finishresolution' => { 138 => 0xdb9 },
	'finishsharpening' => { 138 => 0xdbb },
	'firmware' => { 302 => 0x405, 397 => [0x8c,0x17,0x3b], 474 => 'Firmware' },
	'firmware2' => { 397 => 0x57 },
	'firmwaredate' => { 112 => 0x15, 113 => 0x2001, 381 => 0x4, 383 => 0x30 },
	'firmwareid' => { 188 => 0x0 },
	'firmwarename' => { 394 => 0xa001 },
	'firmwarerevision' => { 19 => 0xa4, 64 => 0x1e, 385 => 0x0 },
	'firmwarerevision2' => { 385 => 0xc },
	'firmwareversion' => { 7 => 0x10b, 11 => 0x136, 14 => 0xff, 15 => 0x107, 138 => [0x415,0xce5], 154 => 0x57, 156 => 'FirmwareVersion', 318 => 0x320, 320 => 0x2, 322 => 0x3109, 355 => 0x230, 380 => ['CNFV','FIRM'], 382 => 0x18, 383 => 0x2a, 387 => 0x2 },
	'firmwareversions' => { 364 => 0x301 },
	'firstphotodate' => { 465 => 'FirstPhotoDate' },
	'firstpublicationdate' => { 307 => 'FirstPublicationDate' },
	'fixtureidentifier' => { 131 => 0x16, 472 => 'FixtureIdentifier' },
	'flash' => { 114 => 'XMP-Flash', 119 => 0x9209, 152 => 0x22, 182 => 0x1f, 183 => 0x15, 383 => 0x5a, 483 => 'Flash' },
	'flashaction' => { 407 => 0x3e, 408 => 0x3e, 420 => 0x2017, 425 => [0x2a,0x2c,0x30] },
	'flashaction2' => { 407 => 0x4c, 408 => 0x4c, 425 => 0x77 },
	'flashactionexternal' => { 425 => [0x78,0x7c] },
	'flashactivity' => { 34 => 0x1c },
	'flashbatterylevel' => { 44 => 0x249 },
	'flashbias' => { 320 => 0x24 },
	'flashbits' => { 34 => 0x1d },
	'flashburstpriority' => { 295 => 0x111 },
	'flashbuttonfunction' => { 84 => 0x70e },
	'flashchargelevel' => { 302 => 0x1010 },
	'flashcolorfilter' => { 211 => 0x10, 212 => 0x10 },
	'flashcommandermode' => { 209 => '9.1', 210 => '9.1', 211 => '9.1', 212 => '9.1' },
	'flashcompensation' => { 138 => 0x3f3, 209 => 0xa, 210 => 0xa, 211 => 0xa, 212 => 0x27, 213 => 0xa, 214 => 0xa, 474 => 'FlashCompensation' },
	'flashcontrol' => { 407 => 0x23, 408 => 0x1f, 409 => 0x21 },
	'flashcontrolbuilt-in' => { 288 => '16.1', 289 => '23.1', 291 => '23.1', 292 => '24.1' },
	'flashcontrolmode' => { 209 => '9.2', 210 => '9.2', 211 => '9.2', 212 => '9.2', 228 => 0x148, 229 => 0x1a8, 252 => 0xc4a6, 297 => 0x404 },
	'flashcurtain' => { 320 => 0x48 },
	'flashdefault' => { 184 => 0x42 },
	'flashdevice' => { 302 => 0x1005 },
	'flashdistance' => { 113 => 0x2034 },
	'flashenergy' => { 119 => 0xa20b, 483 => 'FlashEnergy' },
	'flashexposurebracketvalue' => { 226 => 0x18 },
	'flashexposurecomp' => { 77 => 0xf, 127 => 0x1011, 159 => 'ExposureComp', 181 => 0x23, 186 => 0x104, 187 => 0x49c1, 226 => 0x12, 297 => 0x401, 302 => 0x1023, 355 => 0x4d, 387 => 0x100b, 397 => [0x3a,0x56], 420 => 0x104 },
	'flashexposurecomp2' => { 256 => 0x4d2 },
	'flashexposurecomp3' => { 211 => 0x1d },
	'flashexposurecomp4' => { 211 => 0x27 },
	'flashexposurecomparea' => { 280 => '38.4', 282 => '38.4', 283 => '38.4', 292 => '38.4', 293 => '38.4', 295 => 0x59 },
	'flashexposurecompset' => { 184 => 0x10, 328 => 0xe, 407 => 0x14, 408 => 0x12, 409 => 0x23, 425 => 0x1f },
	'flashexposurecompset2' => { 425 => [0x26,0x2c] },
	'flashexposureindicator' => { 184 => 0x54 },
	'flashexposureindicatorlast' => { 184 => 0x56 },
	'flashexposureindicatornext' => { 184 => 0x55 },
	'flashexposurelock' => { 57 => 0x19 },
	'flashfired' => { 140 => 0x5d, 159 => 'Fired', 181 => 0x14, 255 => '590.3', 483 => [\'Flash','FlashFired'] },
	'flashfiring' => { 84 => 0x306, 85 => 0x6, 86 => 0x7, 89 => 0x7 },
	'flashfirmwareversion' => { 298 => 0x1002 },
	'flashfocallength' => { 209 => 0xb, 210 => 0xc, 211 => 0xc, 212 => 0xc, 213 => 0xc },
	'flashfunction' => { 187 => 0x31, 483 => [\'Flash','FlashFunction'] },
	'flashgndistance' => { 209 => 0xe, 210 => 0xf, 211 => 0xf, 212 => 0xf, 213 => 0xf, 228 => 0x14e, 229 => 0x1ae, 252 => 0xc4ac },
	'flashgroupacompensation' => { 209 => 0x11, 210 => 0x12, 211 => 0x13, 212 => 0x28, 213 => 0x28 },
	'flashgroupacontrolmode' => { 209 => 0xf, 210 => '16.1', 211 => '17.1', 212 => '17.1', 213 => '17.1' },
	'flashgroupaoutput' => { 209 => 0x11, 210 => 0x12, 211 => 0x13, 212 => 0x28, 213 => 0x28 },
	'flashgroupbcompensation' => { 209 => 0x12, 210 => 0x13, 211 => 0x14, 212 => 0x29, 213 => 0x29 },
	'flashgroupbcontrolmode' => { 209 => 0x10, 210 => '17.1', 211 => '18.1', 212 => '18.1', 213 => '18.1' },
	'flashgroupboutput' => { 209 => 0x12, 210 => 0x13, 211 => 0x14, 212 => 0x29, 213 => 0x29 },
	'flashgroupccompensation' => { 210 => 0x14, 211 => 0x15, 212 => 0x2a, 213 => 0x2a },
	'flashgroupccontrolmode' => { 210 => '17.2', 211 => '18.2', 212 => '18.2', 213 => '18.2' },
	'flashgroupcoutput' => { 210 => 0x14, 211 => 0x15, 212 => 0x2a, 213 => 0x2a },
	'flashguidenumber' => { 77 => 0xd, 94 => 0x0, 159 => 'GuideNumber' },
	'flashintensity' => { 112 => [0x19,0x5], 297 => 0x405 },
	'flashlevel' => { 281 => 0x9, 420 => 0xb048 },
	'flashmake' => { 159 => 'Make' },
	'flashmanufacturer' => { 178 => 'FlashManufacturer' },
	'flashmastercompensation' => { 228 => 0x162, 229 => 0x1aa, 252 => 0xc4c0 },
	'flashmastercontrolmode' => { 228 => 0x160, 252 => 0xc4be },
	'flashmasteroutput' => { 228 => 0x166, 252 => 0xc4c4 },
	'flashmetering' => { 181 => 0x3f, 184 => 0x1c },
	'flashmeteringmode' => { 7 => 0x15, 13 => 0x15, 14 => 0x15, 15 => 0x15, 16 => 0x15, 17 => 0x15, 18 => 0x15, 20 => 0x15, 22 => 0x15, 28 => 0x15 },
	'flashmeteringsegments' => { 355 => 0x20a },
	'flashmode' => { 112 => 0x4, 138 => 0x3f2, 140 => 0x5c, 151 => 0x27, 159 => 'Mode', 181 => 0x2, 182 => 0x20, 183 => 0x16, 184 => 0xf, 226 => 0x87, 297 => 0x400, 302 => 0x1004, 355 => 0xc, 362 => 0x4, 386 => 0x20, 387 => 0x100a, 396 => 0x225, 407 => 0x13, 408 => 0x7f, 409 => 0x20, 425 => 0x10, 428 => 0x1138, 429 => 0x1138, 430 => 0x1114, 431 => 0x1190, 432 => 0x116c, 433 => 0x1024, 434 => 0x21c, 435 => 0x21c, 436 => 0x211, 483 => [\'Flash','FlashMode'] },
	'flashmodel' => { 159 => 'Model', 178 => 'FlashModel', 298 => 0x1001 },
	'flashoptions' => { 336 => 0x2 },
	'flashoptions2' => { 336 => 0x10 },
	'flashoutput' => { 44 => 0x248, 77 => 0x21, 209 => 0xa, 210 => 0xa, 211 => 0xa, 212 => 0x27, 228 => 0x152, 229 => 0x1b2, 252 => 0xc4b0 },
	'flashpixversion' => { 119 => 0xa000, 483 => 'FlashpixVersion' },
	'flashredeyemode' => { 483 => [\'Flash','FlashRedEyeMode'] },
	'flashremotecontrol' => { 228 => 0x15c, 229 => 0x1bc, 252 => 0xc4ba, 297 => 0x403 },
	'flashreturn' => { 483 => [\'Flash','FlashReturn'] },
	'flashserialnumber' => { 159 => 'SerialNumber', 298 => 0x1003 },
	'flashsetting' => { 226 => 0x8 },
	'flashshutterspeed' => { 279 => '20.2', 280 => '23.2', 282 => '23.2', 283 => '23.2', 288 => '15.2', 289 => '22.2', 290 => '7.2', 291 => '22.2', 292 => '23.2', 293 => '23.2', 294 => '23.1', 295 => 0x57 },
	'flashsource' => { 209 => 0x4, 210 => 0x4, 211 => 0x4, 212 => 0x4, 213 => 0x4, 214 => 0x4 },
	'flashstatus' => { 343 => 0x0, 425 => [0x82,0x86], 438 => 0x31, 439 => 0x39, 440 => 0x39 },
	'flashstatusbuilt-in' => { 409 => [0x87,0x287] },
	'flashstatusexternal' => { 409 => [0x88,0x288] },
	'flashsyncspeed' => { 279 => '20.1', 280 => '23.1', 282 => '23.1', 283 => '23.1', 288 => '15.1', 289 => '22.1', 291 => '22.1', 292 => '23.1', 293 => '23.1', 295 => 0x53 },
	'flashsyncspeedav' => { 82 => 0x3, 84 => 0x10f, 85 => 0x2, 86 => 0x3, 87 => 0x2, 88 => 0x2, 89 => 0x3, 90 => 0x6 },
	'flashthreshold' => { 94 => 0x1 },
	'flashtype' => { 159 => 'Type', 184 => 0x59, 226 => 0x9, 298 => 0x1000 },
	'flashwarning' => { 289 => '30.1', 290 => '7.1', 294 => '31.1', 320 => 0x62 },
	'flashwirelessoption' => { 228 => 0x15a, 229 => 0x1c8, 252 => 0xc4c6 },
	'flexiblespotposition' => { 420 => 0x201d },
	'flickadvancedirection' => { 295 => 0x25f },
	'flickerreduce' => { 396 => 0x218 },
	'flickerreduction' => { 127 => 0x1446, 248 => 0xe84 },
	'flickerreductionindicator' => { 248 => 0x5e2 },
	'flickerreductionshooting' => { 229 => 0x1a4 },
	'flightpitchdegree' => { 116 => 'FlightPitchDegree' },
	'flightrolldegree' => { 116 => 'FlightRollDegree' },
	'flightxspeed' => { 116 => 'FlightXSpeed' },
	'flightyawdegree' => { 116 => 'FlightYawDegree' },
	'flightyspeed' => { 116 => 'FlightYSpeed' },
	'flightzspeed' => { 116 => 'FlightZSpeed' },
	'fliphorizontal' => { 272 => 0x76a43206 },
	'fnumber' => { 7 => 0x3, 9 => 0x3, 11 => 0x3, 13 => 0x3, 14 => 0x3, 15 => 0x3, 16 => 0x3, 17 => 0x3, 18 => 0x3, 19 => 0x3, 20 => 0x3, 21 => 0x3, 22 => 0x3, 23 => 0x3, 24 => 0x3, 25 => 0x3, 26 => 0x3, 27 => 0x3, 28 => 0x3, 29 => 0x3, 30 => 0x5, 31 => 0x6, 77 => 0x15, 119 => 0x829d, 137 => 0xfd04, 140 => 0x1e, 142 => 0xfa23, 144 => 0xf103, 147 => 0x13, 149 => 0x3c, 151 => 0x1c, 152 => 0x18, 154 => 0xc, 163 => 'FNumber', 181 => 0xa, 182 => 0x36, 183 => 0x47, 184 => 0x9, 187 => 0x49c7, 224 => 0x38, 319 => 0x35a, 355 => 0x13, 394 => 0xa019, 397 => [0x31,0x49], 407 => 0x1, 408 => 0x1, 425 => [0x20,0x22,0x26], 483 => 'FNumber' },
	'focaldistance' => { 463 => 'FocalDistance' },
	'focallength' => { 7 => 0x1d, 8 => 0xa, 9 => 0x23, 10 => 0x9, 11 => 0x1d, 12 => 0x9, 13 => 0x1e, 14 => 0x1d, 15 => 0x1d, 16 => 0x1e, 17 => 0x1e, 18 => 0x1e, 19 => 0x28, 20 => 0x1e, 21 => 0x23, 22 => 0x1e, 23 => 0x1e, 24 => 0x23, 25 => 0x23, 26 => 0x23, 27 => 0x23, 28 => 0x1e, 29 => 0x23, 59 => 0x1, 113 => 0x1d, 119 => 0x920a, 147 => 0x1d, 163 => 'FocalLength', 181 => 0x12, 219 => 0xa, 220 => 0xb, 224 => [0xc,0x3c], 314 => 0x1, 355 => 0x1d, 364 => 0x403, 387 => 0x1500, 406 => 0xe, 432 => 0x1278, 433 => 0x1134, 434 => 0x32c, 435 => 0x32c, 436 => 0x30a, 483 => 'FocalLength' },
	'focallength2' => { 425 => [0x23,0x25,0x29] },
	'focallengthin35mmformat' => { 119 => 0xa405, 394 => 0xa01a, 483 => 'FocalLengthIn35mmFilm' },
	'focallengthtelezoom' => { 406 => 0x10 },
	'focalplaneafpointarea' => { 437 => 0x2 },
	'focalplaneafpointlocation1' => { 437 => 0x6 },
	'focalplaneafpointlocation10' => { 437 => 0x2a },
	'focalplaneafpointlocation11' => { 437 => 0x2e },
	'focalplaneafpointlocation12' => { 437 => 0x32 },
	'focalplaneafpointlocation13' => { 437 => 0x36 },
	'focalplaneafpointlocation14' => { 437 => 0x3a },
	'focalplaneafpointlocation15' => { 437 => 0x3e },
	'focalplaneafpointlocation2' => { 437 => 0xa },
	'focalplaneafpointlocation3' => { 437 => 0xe },
	'focalplaneafpointlocation4' => { 437 => 0x12 },
	'focalplaneafpointlocation5' => { 437 => 0x16 },
	'focalplaneafpointlocation6' => { 437 => 0x1a },
	'focalplaneafpointlocation7' => { 437 => 0x1e },
	'focalplaneafpointlocation8' => { 437 => 0x22 },
	'focalplaneafpointlocation9' => { 437 => 0x26 },
	'focalplaneafpointsused' => { 437 => 0x1 },
	'focalplanediagonal' => { 298 => 0x103, 302 => 0x205 },
	'focalplaneresolutionunit' => { 119 => 0xa210, 483 => 'FocalPlaneResolutionUnit' },
	'focalplanexresolution' => { 119 => 0xa20e, 483 => 'FocalPlaneXResolution' },
	'focalplanexsize' => { 59 => 0x2 },
	'focalplanexunknown' => { 59 => 0x2 },
	'focalplaneyresolution' => { 119 => 0xa20f, 483 => 'FocalPlaneYResolution' },
	'focalplaneysize' => { 59 => 0x3 },
	'focalplaneyunknown' => { 59 => 0x3 },
	'focalpointx' => { 463 => 'FocalPointX' },
	'focalpointy' => { 463 => 'FocalPointY' },
	'focaltype' => { 10 => 0x2d, 59 => 0x0 },
	'focalunits' => { 34 => 0x19 },
	'focus' => { 262 => 0x8 },
	'focusarea' => { 181 => 0x31 },
	'focusareaselection' => { 290 => '15.2' },
	'focusbracket' => { 320 => 0xbd },
	'focusbracketstepsize' => { 297 => 0x308 },
	'focuscontinuous' => { 34 => 0x20 },
	'focusdisplayaiservoandmf' => { 84 => 0x515 },
	'focusdistance' => { 163 => 'FocusDistance', 181 => 0x13, 187 => 0x49bb, 219 => 0x9, 220 => 0xa, 224 => [0xb,0x4f], 300 => 0x305, 314 => 0x0, 318 => 0x304, 319 => 0x304 },
	'focusdistancelower' => { 7 => 0x45, 9 => 0x8e, 11 => 0x45, 13 => 0x56, 14 => 0x45, 15 => 0x45, 16 => 0x52, 17 => 0x52, 18 => 0x56, 20 => 0x52, 21 => 0x8e, 22 => 0x59, 23 => 0x57, 24 => 0x8e, 25 => 0x94, 26 => 0x95, 27 => 0xa7, 28 => 0x56, 29 => 0xa7, 57 => 0x15, 77 => 0x14 },
	'focusdistanceupper' => { 7 => 0x43, 9 => 0x8c, 11 => 0x43, 13 => 0x54, 14 => 0x43, 15 => 0x43, 16 => 0x50, 17 => 0x50, 18 => 0x54, 20 => 0x50, 21 => 0x8c, 22 => 0x57, 23 => 0x55, 24 => 0x8c, 25 => 0x92, 26 => 0x93, 27 => 0xa5, 28 => 0x54, 29 => 0xa5, 57 => 0x14, 77 => 0x13 },
	'focusholdbutton' => { 184 => 0x44 },
	'focusinfoversion' => { 300 => 0x0 },
	'focusingscreen' => { 83 => 0x0, 84 => 0x80b, 89 => 0x0 },
	'focuslocation' => { 420 => 0x2027 },
	'focuslocked' => { 180 => 0x14 },
	'focusmode' => { 34 => 0x7, 112 => 0x3, 113 => [0x3003,0xd], 127 => 0x1021, 138 => 0x3f5, 140 => 0x38, 156 => 'FocusMode', 181 => 0x30, 183 => 0xe, 184 => 0xc, 226 => 0x7, 297 => 0x301, 302 => 0x100b, 320 => 0x7, 355 => 0xd, 362 => 0x3, 387 => 0x1006, 400 => [0xb,0x5], 406 => [0x15,0x1d], 407 => 0x4d, 408 => 0x4d, 420 => [0xb042,0xb04e,0x201b], 425 => 0x13, 444 => 0x16 },
	'focusmode2' => { 126 => '0.1', 336 => '3.1', 425 => [0x2c,0x2e,0x32] },
	'focusmodesetting' => { 281 => '10.1', 404 => 0x14, 405 => 0x15, 407 => 0x10, 408 => 0xf, 409 => 0x6 },
	'focusmodeswitch' => { 184 => 0x58, 407 => 0x2e },
	'focuspeakingdisplay' => { 295 => 0x235 },
	'focuspeakinghighlightcolor' => { 295 => 0x4b },
	'focuspeakinglevel' => { 295 => 0x49 },
	'focuspixel' => { 127 => 0x1023 },
	'focuspointlock' => { 295 => 0x1d3 },
	'focuspointpersistence' => { 295 => 0x105 },
	'focuspointwrap' => { 279 => '2.2', 280 => '2.2', 282 => '2.1', 283 => '2.1', 287 => '1.1', 288 => '2.2', 289 => '1.1', 292 => '2.2', 293 => '2.1', 294 => '2.5', 295 => 0x16 },
	'focusposition' => { 219 => 0x8, 220 => 0x8, 224 => 0x9, 355 => 0x10, 418 => 0x9bb },
	'focusposition2' => { 425 => [0x29,0x2b,0x2f], 444 => 0x2d, 447 => 0x20 },
	'focuspositionhorizontal' => { 194 => 0x43 },
	'focuspositionvertical' => { 194 => 0x45 },
	'focusprocess' => { 297 => 0x302 },
	'focusrange' => { 34 => 0x12, 302 => 0x100a },
	'focusrangeindex' => { 346 => '3.1' },
	'focusringrotation' => { 84 => 0x713 },
	'focussetting' => { 397 => 0x6 },
	'focusshiftexposurelock' => { 228 => 0xe8, 229 => 0xf4, 252 => 0xc446 },
	'focusshiftinterval' => { 228 => 0xe4, 229 => 0xf0, 252 => 0xc442 },
	'focusshiftnumbershots' => { 228 => 0xdc, 229 => 0xe8, 252 => 0xc43a },
	'focusshiftshooting' => { 261 => 0x7844 },
	'focusshiftstepwidth' => { 228 => 0xe0, 229 => 0xec, 252 => 0xc43e },
	'focusstatus' => { 406 => 0x19, 407 => 0x53, 408 => 0x53 },
	'focusstepcount' => { 300 => 0x301, 302 => 0x100e },
	'focusstepinfinity' => { 300 => 0x303, 302 => 0x103b },
	'focusstepnear' => { 300 => 0x304, 302 => 0x103c },
	'focustrackinglockon' => { 279 => ['1.5','4.1'], 280 => '1.4', 287 => '0.4', 288 => '3.1', 289 => '0.4', 292 => '1.4' },
	'focuswarning' => { 127 => 0x1301 },
	'foldername' => { 181 => 0x27 },
	'foldernumber' => { 407 => 0x9a, 409 => [0x402,0x114,0x316] },
	'fontcomposite' => { 508 => [\'Fonts','FontsComposite'] },
	'fontface' => { 508 => [\'Fonts','FontsFontFace'] },
	'fontfamily' => { 508 => [\'Fonts','FontsFontFamily'] },
	'fontfilename' => { 508 => [\'Fonts','FontsFontFileName'] },
	'fontname' => { 508 => [\'Fonts','FontsFontName'] },
	'fonts' => { 508 => 'Fonts' },
	'fonttype' => { 508 => [\'Fonts','FontsFontType'] },
	'fontversion' => { 508 => [\'Fonts','FontsVersionString'] },
	'for' => { 371 => 'For' },
	'forcewrite' => { 120 => 'ForceWrite' },
	'format' => { 380 => "\xa9fmt", 462 => 'Format', 480 => 'format', 501 => 'Format' },
	'forwardlock' => { 498 => 'forwardlock' },
	'forwardmatrix1' => { 119 => 0xc714 },
	'forwardmatrix2' => { 119 => 0xc715 },
	'forwardmatrix3' => { 119 => 0xcd34 },
	'fossilspecimen' => { 118 => 'FossilSpecimen' },
	'fossilspecimenmaterialsampleid' => { 118 => [\'FossilSpecimen','FossilSpecimenMaterialSampleID'] },
	'framecount' => { 67 => [0x2,0x4] },
	'frameheight' => { 127 => 0x3822 },
	'framenum' => { 366 => 0xd7 },
	'framenumber' => { 127 => 0x8003, 187 => 0x3c, 355 => 0x29 },
	'framerate' => { 67 => [0x1,0x6], 119 => 0xc764, 127 => 0x3820 },
	'framereadouttime' => { 374 => 'camera.framereadouttimeinmicroseconds' },
	'framewidth' => { 127 => 0x3821 },
	'framing' => { 492 => 'framing' },
	'freebytes' => { 97 => 0x1 },
	'freememorycardimages' => { 182 => [0x37,0x54], 183 => [0x2d,0x4a], 184 => 0x32 },
	'fujiflashmode' => { 127 => 0x1010 },
	'fullhdhighspeedrec' => { 127 => 0x3824 },
	'fullimagesize' => { 420 => 0xb02b },
	'fullpanoheightpixels' => { 465 => 'FullPanoHeightPixels', 466 => 'FullPanoHeightPixels' },
	'fullpanowidthpixels' => { 465 => 'FullPanoWidthPixels', 466 => 'FullPanoWidthPixels' },
	'fullpresssnap' => { 387 => 0x100d },
	'fullsizeimage' => { 162 => 'data' },
	'fullsizeimagename' => { 162 => '1Name' },
	'fullsizeimagetype' => { 162 => '0Type' },
	'func1button' => { 282 => '14.1', 283 => '14.1', 293 => '14.1', 295 => 0x63 },
	'func1buttonplaybackmode' => { 295 => 0x1a5 },
	'func1buttonplusdials' => { 282 => '42.1', 283 => '42.1', 293 => '42.1' },
	'func2button' => { 282 => '80.1', 283 => '80.1', 293 => '80.1', 295 => 0x73 },
	'func2buttonplaybackmode' => { 295 => 0x1a7 },
	'func2buttonplusdials' => { 282 => '81.1' },
	'func3button' => { 282 => '83.1', 295 => 0x119 },
	'func3buttonplaybackmode' => { 295 => 0x1a9 },
	'func4button' => { 295 => 0x175 },
	'func4buttonplaybackmode' => { 295 => 0x1af },
	'funcbutton' => { 279 => ['14.1','15.1'], 280 => '14.1', 288 => '28.1', 289 => '13.1', 292 => '14.1', 294 => '14.1' },
	'funcbuttonplusdials' => { 279 => ['14.2','15.2'], 280 => '14.2', 288 => '31.1', 292 => '42.1' },
	'functionbutton' => { 286 => '13.1', 290 => '5.2' },
	'gainbase' => { 301 => 0x610 },
	'gaincontrol' => { 119 => 0xa407, 483 => 'GainControl' },
	'gamma' => { 119 => 0xa500, 138 => 0x8fe, 308 => 'gAMA', 325 => 0x11c, 484 => 'Gamma' },
	'gammablackpoint' => { 105 => 0xc },
	'gammacolortone' => { 105 => 0x3 },
	'gammacompensatedvalue' => { 133 => 0x91 },
	'gammacontrast' => { 105 => 0x2 },
	'gammacurveoutputrange' => { 105 => 0xf },
	'gammahighlight' => { 105 => 0xa },
	'gammalinear' => { 103 => 0x20200 },
	'gammamidpoint' => { 105 => 0xe },
	'gammasaturation' => { 105 => 0x4 },
	'gammashadow' => { 105 => 0x9 },
	'gammasharpnessstrength' => { 105 => 0x8 },
	'gammaunsharpmaskfineness' => { 105 => 0x6 },
	'gammaunsharpmaskstrength' => { 105 => 0x5 },
	'gammaunsharpmaskthreshold' => { 105 => 0x7 },
	'gammawhitepoint' => { 105 => 0xd },
	'garminsettings' => { 380 => 'pmcc' },
	'garminsoftware' => { 380 => 'uuid' },
	'gdalmetadata' => { 119 => 0xa480 },
	'gdalnodata' => { 119 => 0xa481 },
	'geimagesize' => { 127 => 0x1304 },
	'gemake' => { 129 => 0x300 },
	'gemodel' => { 129 => 0x207 },
	'genre' => { 372 => ['gnre',"\xa9gen"], 374 => 'genre', 380 => ['gnre',"\xa9gen"], 489 => 'Genre', 493 => 'genre', 503 => 'genre' },
	'genrecvid' => { 489 => [\'Genre','GenreCvId'] },
	'genrecvtermid' => { 489 => [\'Genre','GenreCvTermId'] },
	'genrecvtermname' => { 489 => [\'Genre','GenreCvTermName'] },
	'genrecvtermrefinedabout' => { 489 => [\'Genre','GenreCvTermRefinedAbout'] },
	'genreid' => { 372 => 'geID' },
	'geography' => { 494 => 'geography' },
	'geologicalcontext' => { 118 => 'GeologicalContext' },
	'geologicalcontextbed' => { 118 => [\'GeologicalContext','GeologicalContextBed'] },
	'geologicalcontextformation' => { 118 => [\'GeologicalContext','GeologicalContextFormation'] },
	'geologicalcontextgroup' => { 118 => [\'GeologicalContext','GeologicalContextGroup'] },
	'geologicalcontextid' => { 118 => [\'GeologicalContext','GeologicalContextGeologicalContextID'] },
	'geologicalcontextmember' => { 118 => [\'GeologicalContext','GeologicalContextMember'] },
	'geosync' => { 120 => 'Geosync' },
	'geotag' => { 120 => 'Geotag' },
	'geotiffasciiparams' => { 119 => 0x87b1 },
	'geotiffdirectory' => { 119 => 0x87af },
	'geotiffdoubleparams' => { 119 => 0x87b0 },
	'geotime' => { 120 => 'Geotime' },
	'giftftppriority' => { 467 => 'GIFTFtpPriority' },
	'gimbalpitchdegree' => { 116 => 'GimbalPitchDegree' },
	'gimbalreverse' => { 116 => 'GimbalReverse' },
	'gimbalrolldegree' => { 116 => 'GimbalRollDegree' },
	'gimbalyawdegree' => { 116 => 'GimbalYawDegree' },
	'globalaltitude' => { 369 => 0x419 },
	'globalangle' => { 369 => 0x40d },
	'good' => { 503 => 'good' },
	'googlehostheader' => { 372 => 'gshh' },
	'googlepingmessage' => { 372 => 'gspm' },
	'googlepingurl' => { 372 => 'gspu' },
	'googleplusuploadcode' => { 119 => 0x9009 },
	'googlesourcedata' => { 372 => 'gssd' },
	'googlestarttime' => { 372 => 'gsst' },
	'googletrackduration' => { 372 => 'gstd' },
	'goprotype' => { 380 => 'GoPr' },
	'gpsaltitude' => { 130 => 0x6, 160 => 'Altitude', 483 => 'GPSAltitude' },
	'gpsaltituderef' => { 130 => 0x5, 483 => 'GPSAltitudeRef' },
	'gpsareainformation' => { 130 => 0x1c, 483 => 'GPSAreaInformation' },
	'gpscoordinates' => { 372 => "\xa9xyz", 374 => 'location.ISO6709', 380 => ['@xyz',"\xa9xyz"] },
	'gpsdatestamp' => { 130 => 0x1d },
	'gpsdatetime' => { 160 => 'DateTime', 483 => 'GPSTimeStamp' },
	'gpsdestbearing' => { 130 => 0x18, 160 => 'Bearing', 483 => 'GPSDestBearing' },
	'gpsdestbearingref' => { 130 => 0x17, 483 => 'GPSDestBearingRef' },
	'gpsdestdistance' => { 130 => 0x1a, 160 => 'Distance', 483 => 'GPSDestDistance' },
	'gpsdestdistanceref' => { 130 => 0x19, 483 => 'GPSDestDistanceRef' },
	'gpsdestlatitude' => { 130 => 0x14, 483 => 'GPSDestLatitude' },
	'gpsdestlatituderef' => { 130 => 0x13 },
	'gpsdestlongitude' => { 130 => 0x16, 483 => 'GPSDestLongitude' },
	'gpsdestlongituderef' => { 130 => 0x15 },
	'gpsdifferential' => { 130 => 0x1e, 160 => 'Differential', 483 => 'GPSDifferential' },
	'gpsdop' => { 130 => 0xb, 483 => 'GPSDOP' },
	'gpshpositioningerror' => { 130 => 0x1f, 483 => 'GPSHPositioningError' },
	'gpsimgdirection' => { 130 => 0x11, 483 => 'GPSImgDirection' },
	'gpsimgdirectionref' => { 130 => 0x10, 483 => 'GPSImgDirectionRef' },
	'gpslatitude' => { 116 => 'GpsLatitude', 130 => 0x2, 160 => 'Latitude', 483 => 'GPSLatitude' },
	'gpslatituderef' => { 130 => 0x1 },
	'gpslongitude' => { 116 => 'GpsLongitude', 130 => 0x4, 160 => 'Longitude', 483 => 'GPSLongitude' },
	'gpslongituderef' => { 130 => 0x3 },
	'gpslongtitude' => { 116 => 'GpsLongtitude' },
	'gpsmapdatum' => { 130 => 0x12, 160 => 'Datum', 483 => 'GPSMapDatum' },
	'gpsmeasuremode' => { 130 => 0xa, 160 => 'MeasureMode', 483 => 'GPSMeasureMode' },
	'gpsposition' => { 114 => 'Exif-GPSPosition' },
	'gpsprocessingmethod' => { 130 => 0x1b, 483 => 'GPSProcessingMethod' },
	'gpssatellites' => { 130 => 0x8, 160 => 'Satellites', 483 => 'GPSSatellites' },
	'gpsspeed' => { 130 => 0xd, 160 => 'Speed', 483 => 'GPSSpeed' },
	'gpsspeedref' => { 130 => 0xc, 483 => 'GPSSpeedRef' },
	'gpsstatus' => { 130 => 0x9, 483 => 'GPSStatus' },
	'gpsstring' => { 138 => 0x402 },
	'gpstimestamp' => { 130 => 0x7 },
	'gpstrack' => { 130 => 0xf, 160 => 'Heading', 483 => 'GPSTrack' },
	'gpstrackref' => { 130 => 0xe, 483 => 'GPSTrackRef' },
	'gpsversionid' => { 130 => 0x0, 483 => 'GPSVersionID' },
	'gradation' => { 297 => 0x50f },
	'gradientbasedcorractive' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionActive'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionActive'] },
	'gradientbasedcorramount' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionAmount'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionAmount'] },
	'gradientbasedcorrblacks2012' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalBlacks2012'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalBlacks2012'] },
	'gradientbasedcorrbrightness' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalBrightness'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalBrightness'] },
	'gradientbasedcorrclarity' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity'] },
	'gradientbasedcorrclarity2012' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity2012'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity2012'] },
	'gradientbasedcorrcontrast' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast'] },
	'gradientbasedcorrcontrast2012' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast2012'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast2012'] },
	'gradientbasedcorrcorrectionname' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionName'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionName'] },
	'gradientbasedcorrcorrectionsyncid' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionSyncID'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionSyncID'] },
	'gradientbasedcorrdefringe' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalDefringe'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalDefringe'] },
	'gradientbasedcorrdehaze' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalDehaze'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalDehaze'] },
	'gradientbasedcorrections' => { 477 => 'GradientBasedCorrections', 479 => 'GradientBasedCorrections' },
	'gradientbasedcorrexposure' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure'] },
	'gradientbasedcorrexposure2012' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure2012'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure2012'] },
	'gradientbasedcorrhighlights2012' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalHighlights2012'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalHighlights2012'] },
	'gradientbasedcorrhue' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalHue'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalHue'] },
	'gradientbasedcorrluminancenoise' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalLuminanceNoise'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalLuminanceNoise'] },
	'gradientbasedcorrmaskalpha' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAlpha'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAlpha'] },
	'gradientbasedcorrmaskangle' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAngle'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAngle'] },
	'gradientbasedcorrmaskbottom' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksBottom'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksBottom'] },
	'gradientbasedcorrmaskcentervalue' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterValue'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterValue'] },
	'gradientbasedcorrmaskcenterweight' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterWeight'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterWeight'] },
	'gradientbasedcorrmaskdabs' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksDabs'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksDabs'] },
	'gradientbasedcorrmaskfeather' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFeather'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFeather'] },
	'gradientbasedcorrmaskflipped' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlipped'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlipped'] },
	'gradientbasedcorrmaskflow' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlow'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlow'] },
	'gradientbasedcorrmaskfullx' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullX'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullX'] },
	'gradientbasedcorrmaskfully' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullY'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullY'] },
	'gradientbasedcorrmaskinputdigest' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksInputDigest'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksInputDigest'] },
	'gradientbasedcorrmaskleft' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksLeft'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksLeft'] },
	'gradientbasedcorrmaskmaskactive' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskActive'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskActive'] },
	'gradientbasedcorrmaskmaskblendmode' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskBlendMode'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskBlendMode'] },
	'gradientbasedcorrmaskmaskdigest' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskDigest'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskDigest'] },
	'gradientbasedcorrmaskmaskinverted' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskInverted'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskInverted'] },
	'gradientbasedcorrmaskmaskname' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskName'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskName'] },
	'gradientbasedcorrmaskmasks' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasks'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasks'] },
	'gradientbasedcorrmaskmasksalpha' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksAlpha'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksAlpha'] },
	'gradientbasedcorrmaskmasksangle' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksAngle'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksAngle'] },
	'gradientbasedcorrmaskmasksbottom' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksBottom'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksBottom'] },
	'gradientbasedcorrmaskmaskscentervalue' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksCenterValue'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksCenterValue'] },
	'gradientbasedcorrmaskmaskscenterweight' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksCenterWeight'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksCenterWeight'] },
	'gradientbasedcorrmaskmasksdabs' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksDabs'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksDabs'] },
	'gradientbasedcorrmaskmasksfeather' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFeather'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFeather'] },
	'gradientbasedcorrmaskmasksflipped' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFlipped'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFlipped'] },
	'gradientbasedcorrmaskmasksflow' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFlow'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFlow'] },
	'gradientbasedcorrmaskmasksfullx' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFullX'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFullX'] },
	'gradientbasedcorrmaskmasksfully' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFullY'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFullY'] },
	'gradientbasedcorrmaskmasksinputdigest' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksInputDigest'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksInputDigest'] },
	'gradientbasedcorrmaskmasksleft' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksLeft'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksLeft'] },
	'gradientbasedcorrmaskmasksmaskactive' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskActive'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskActive'] },
	'gradientbasedcorrmaskmasksmaskblendmode' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskBlendMode'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskBlendMode'] },
	'gradientbasedcorrmaskmasksmaskdigest' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskDigest'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskDigest'] },
	'gradientbasedcorrmaskmasksmaskinverted' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskInverted'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskInverted'] },
	'gradientbasedcorrmaskmasksmaskname' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskName'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskName'] },
	'gradientbasedcorrmaskmasksmasksubtype' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskSubType'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskSubType'] },
	'gradientbasedcorrmaskmasksmasksyncid' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskSyncID'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskSyncID'] },
	'gradientbasedcorrmaskmasksmaskversion' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskVersion'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskVersion'] },
	'gradientbasedcorrmaskmasksmidpoint' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMidpoint'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMidpoint'] },
	'gradientbasedcorrmaskmasksorigin' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksOrigin'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksOrigin'] },
	'gradientbasedcorrmaskmasksperimetervalue' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksPerimeterValue'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksPerimeterValue'] },
	'gradientbasedcorrmaskmasksradius' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksRadius'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksRadius'] },
	'gradientbasedcorrmaskmasksreferencepoint' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksReferencePoint'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksReferencePoint'] },
	'gradientbasedcorrmaskmasksright' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksRight'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksRight'] },
	'gradientbasedcorrmaskmasksroundness' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksRoundness'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksRoundness'] },
	'gradientbasedcorrmaskmaskssizex' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksSizeX'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksSizeX'] },
	'gradientbasedcorrmaskmaskssizey' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksSizeY'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksSizeY'] },
	'gradientbasedcorrmaskmaskstop' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksTop'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksTop'] },
	'gradientbasedcorrmaskmasksubtype' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskSubType'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskSubType'] },
	'gradientbasedcorrmaskmasksvalue' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskValue'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskValue'] },
	'gradientbasedcorrmaskmasksversion' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksVersion'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksVersion'] },
	'gradientbasedcorrmaskmaskswhat' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksWhat'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksWhat'] },
	'gradientbasedcorrmaskmaskswholeimagearea' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksWholeImageArea'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksWholeImageArea'] },
	'gradientbasedcorrmaskmasksx' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksX'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksX'] },
	'gradientbasedcorrmaskmasksy' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksY'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksY'] },
	'gradientbasedcorrmaskmasksyncid' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskSyncID'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskSyncID'] },
	'gradientbasedcorrmaskmaskszerox' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksZeroX'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksZeroX'] },
	'gradientbasedcorrmaskmaskszeroy' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksZeroY'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksZeroY'] },
	'gradientbasedcorrmaskmaskversion' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskVersion'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskVersion'] },
	'gradientbasedcorrmaskmidpoint' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMidpoint'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMidpoint'] },
	'gradientbasedcorrmaskorigin' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksOrigin'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksOrigin'] },
	'gradientbasedcorrmaskperimetervalue' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksPerimeterValue'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'gradientbasedcorrmaskradius' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRadius'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRadius'] },
	'gradientbasedcorrmaskrange' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMask'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMask'] },
	'gradientbasedcorrmaskrangeareamodels' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'] },
	'gradientbasedcorrmaskrangeareamodelscolorsampleinfo' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'gradientbasedcorrmaskrangeareamodelscomponents' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'] },
	'gradientbasedcorrmaskrangecoloramount' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'] },
	'gradientbasedcorrmaskrangedepthfeather' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'] },
	'gradientbasedcorrmaskrangedepthmax' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'] },
	'gradientbasedcorrmaskrangedepthmin' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'] },
	'gradientbasedcorrmaskrangeinvert' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'] },
	'gradientbasedcorrmaskrangelumfeather' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'] },
	'gradientbasedcorrmaskrangeluminancedepthsampleinfo' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'gradientbasedcorrmaskrangelummax' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'] },
	'gradientbasedcorrmaskrangelummin' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'] },
	'gradientbasedcorrmaskrangelumrange' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'] },
	'gradientbasedcorrmaskrangesampletype' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'] },
	'gradientbasedcorrmaskrangetype' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'] },
	'gradientbasedcorrmaskrangeversion' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'] },
	'gradientbasedcorrmaskreferencepoint' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksReferencePoint'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksReferencePoint'] },
	'gradientbasedcorrmaskright' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRight'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRight'] },
	'gradientbasedcorrmaskroundness' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRoundness'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRoundness'] },
	'gradientbasedcorrmasks' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasks'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasks'] },
	'gradientbasedcorrmasksizex' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeX'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeX'] },
	'gradientbasedcorrmasksizey' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeY'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeY'] },
	'gradientbasedcorrmasktop' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksTop'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksTop'] },
	'gradientbasedcorrmaskvalue' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskValue'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskValue'] },
	'gradientbasedcorrmaskversion' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksVersion'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksVersion'] },
	'gradientbasedcorrmaskwhat' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksWhat'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksWhat'] },
	'gradientbasedcorrmaskwholeimagearea' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksWholeImageArea'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksWholeImageArea'] },
	'gradientbasedcorrmaskx' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksX'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksX'] },
	'gradientbasedcorrmasky' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksY'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksY'] },
	'gradientbasedcorrmaskzerox' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroX'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroX'] },
	'gradientbasedcorrmaskzeroy' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroY'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroY'] },
	'gradientbasedcorrmoire' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalMoire'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalMoire'] },
	'gradientbasedcorrrangemask' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMask'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMask'] },
	'gradientbasedcorrrangemaskareamodels' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskAreaModels'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskAreaModels'] },
	'gradientbasedcorrrangemaskareamodelscolorsampleinfo' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'gradientbasedcorrrangemaskareamodelscomponents' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'] },
	'gradientbasedcorrrangemaskcoloramount' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskColorAmount'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskColorAmount'] },
	'gradientbasedcorrrangemaskdepthfeather' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskDepthFeather'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskDepthFeather'] },
	'gradientbasedcorrrangemaskdepthmax' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskDepthMax'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskDepthMax'] },
	'gradientbasedcorrrangemaskdepthmin' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskDepthMin'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskDepthMin'] },
	'gradientbasedcorrrangemaskinvert' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskInvert'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskInvert'] },
	'gradientbasedcorrrangemasklumfeather' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumFeather'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumFeather'] },
	'gradientbasedcorrrangemaskluminancedepthsampleinfo' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'gradientbasedcorrrangemasklummax' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumMax'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumMax'] },
	'gradientbasedcorrrangemasklummin' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumMin'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumMin'] },
	'gradientbasedcorrrangemasklumrange' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumRange'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumRange'] },
	'gradientbasedcorrrangemasksampletype' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskSampleType'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskSampleType'] },
	'gradientbasedcorrrangemasktype' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskType'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskType'] },
	'gradientbasedcorrrangemaskversion' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskVersion'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskVersion'] },
	'gradientbasedcorrsaturation' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSaturation'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSaturation'] },
	'gradientbasedcorrshadows2012' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalShadows2012'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalShadows2012'] },
	'gradientbasedcorrsharpness' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSharpness'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSharpness'] },
	'gradientbasedcorrtemperature' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTemperature'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTemperature'] },
	'gradientbasedcorrtexture' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTexture'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTexture'] },
	'gradientbasedcorrtint' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTint'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTint'] },
	'gradientbasedcorrtoninghue' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalToningHue'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalToningHue'] },
	'gradientbasedcorrtoningsaturation' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalToningSaturation'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalToningSaturation'] },
	'gradientbasedcorrwhat' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsWhat'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsWhat'] },
	'gradientbasedcorrwhites2012' => { 477 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalWhites2012'], 479 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalWhites2012'] },
	'grainamount' => { 477 => 'GrainAmount', 479 => 'GrainAmount' },
	'graineffect' => { 127 => 0x1047 },
	'grainfrequency' => { 477 => 'GrainFrequency', 479 => 'GrainFrequency' },
	'grainseed' => { 477 => 'GrainSeed', 479 => 'GrainSeed' },
	'grainsize' => { 477 => 'GrainSize', 479 => 'GrainSize' },
	'graymixeraqua' => { 477 => 'GrayMixerAqua', 479 => 'GrayMixerAqua' },
	'graymixerblue' => { 477 => 'GrayMixerBlue', 479 => 'GrayMixerBlue' },
	'graymixergreen' => { 477 => 'GrayMixerGreen', 479 => 'GrayMixerGreen' },
	'graymixermagenta' => { 477 => 'GrayMixerMagenta', 479 => 'GrayMixerMagenta' },
	'graymixerorange' => { 477 => 'GrayMixerOrange', 479 => 'GrayMixerOrange' },
	'graymixerpurple' => { 477 => 'GrayMixerPurple', 479 => 'GrayMixerPurple' },
	'graymixerred' => { 477 => 'GrayMixerRed', 479 => 'GrayMixerRed' },
	'graymixeryellow' => { 477 => 'GrayMixerYellow', 479 => 'GrayMixerYellow' },
	'graypoint' => { 454 => 0x8021 },
	'grayresponseunit' => { 119 => 0x122 },
	'greencurvelimits' => { 108 => 0x1c4 },
	'greencurvepoints' => { 107 => 0x53, 108 => 0x19a },
	'greenhsl' => { 103 => 0x20913 },
	'greenhue' => { 477 => 'GreenHue', 479 => 'GreenHue' },
	'greensaturation' => { 477 => 'GreenSaturation', 479 => 'GreenSaturation' },
	'griddisplay' => { 279 => '13.3', 280 => '4.3', 282 => '4.2', 283 => '4.2', 284 => '2.2', 288 => '10.5', 289 => '3.4', 290 => '6.1', 292 => '4.4', 293 => '4.2', 294 => '4.2' },
	'gripbatteryadload' => { 334 => 0x5 },
	'gripbatteryadnoload' => { 334 => 0x4 },
	'gripbatterystate' => { 334 => '1.2' },
	'group' => { 477 => 'Group', 479 => 'Group' },
	'groupareaafillumination' => { 280 => '46.4', 283 => '47.4', 292 => '47.4' },
	'grouping' => { 372 => ['grup',"\xa9grp"], 380 => "\xa9grp" },
	'guid' => { 372 => 'GUID' },
	'h2resetblackpixels' => { 138 => 0x18a6 },
	'h3resetblackcolumns' => { 138 => 0x18ce },
	'h3resetblackpixels' => { 138 => 0x18b0 },
	'halftonehints' => { 119 => 0x141 },
	'hardlink' => { 120 => 'HardLink' },
	'hasalternative' => { 493 => 'hasAlternative' },
	'hascorrection' => { 493 => 'hasCorrection' },
	'hascorrectiona-lang' => { 493 => [\'hasCorrection','hasCorrectionA-lang'] },
	'hascorrectiona-platform' => { 493 => [\'hasCorrection','hasCorrectionA-platform'] },
	'hascorrectiontext' => { 493 => [\'hasCorrection','hasCorrectionText'] },
	'hascrop' => { 477 => 'HasCrop', 479 => 'HasCrop' },
	'hasextendedxmp' => { 505 => 'HasExtendedXMP' },
	'hassettings' => { 477 => 'HasSettings', 479 => 'HasSettings' },
	'hastranslation' => { 493 => 'hasTranslation' },
	'hasvisibleoverprint' => { 508 => 'HasVisibleOverprint' },
	'hasvisibletransparency' => { 508 => 'HasVisibleTransparency' },
	'hdmioutputn-log' => { 228 => 0x35a },
	'hdmioutputresolution' => { 229 => 0x610 },
	'hdmiviewassist' => { 295 => 0x20f },
	'hdr' => { 60 => 0x1, 216 => 0x4, 320 => 0x9e, 355 => 0x85, 420 => 0x200a },
	'hdreffect' => { 60 => 0x2 },
	'hdrimagetype' => { 1 => 0xa },
	'hdrinfoversion' => { 216 => 0x0 },
	'hdrlevel' => { 216 => 0x5, 409 => 0x2e, 425 => 0x17 },
	'hdrlevel2' => { 216 => 0x7 },
	'hdrpmakernote' => { 460 => 'hdrp_makernote' },
	'hdrsetting' => { 409 => 0x2d, 425 => 0x16, 428 => 0x1148, 429 => 0x1148, 430 => 0x1124, 431 => 0x11a0, 432 => 0x117c, 433 => 0x1034, 434 => 0x22c, 435 => 0x22c, 436 => 0x21f },
	'hdrshot' => { 320 => 0x76 },
	'hdrsmoothing' => { 216 => 0x6 },
	'hdvideo' => { 372 => 'hdvd' },
	'headline' => { 131 => 0x69, 489 => 'Headline', 491 => 'Headline' },
	'hierarchicalkeywords' => { 171 => [\'Keywords','KeywordsHierarchy'] },
	'hierarchicalkeywords1' => { 171 => [\'Keywords','KeywordsHierarchyKeyword'] },
	'hierarchicalkeywords1applied' => { 171 => [\'Keywords','KeywordsHierarchyApplied'] },
	'hierarchicalkeywords1children' => { 171 => [\'Keywords','KeywordsHierarchyChildren'] },
	'hierarchicalkeywords2' => { 171 => [\'Keywords','KeywordsHierarchyChildrenKeyword'] },
	'hierarchicalkeywords2applied' => { 171 => [\'Keywords','KeywordsHierarchyChildrenApplied'] },
	'hierarchicalkeywords2children' => { 171 => [\'Keywords','KeywordsHierarchyChildrenChildren'] },
	'hierarchicalkeywords3' => { 171 => [\'Keywords','KeywordsHierarchyChildrenChildrenKeyword'] },
	'hierarchicalkeywords3applied' => { 171 => [\'Keywords','KeywordsHierarchyChildrenChildrenApplied'] },
	'hierarchicalkeywords3children' => { 171 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildren'] },
	'hierarchicalkeywords4' => { 171 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords4applied' => { 171 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenApplied'] },
	'hierarchicalkeywords4children' => { 171 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildren'] },
	'hierarchicalkeywords5' => { 171 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords5applied' => { 171 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenApplied'] },
	'hierarchicalkeywords5children' => { 171 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildren'] },
	'hierarchicalkeywords6' => { 171 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords6applied' => { 171 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildrenApplied'] },
	'hierarchicalsubject' => { 469 => 'hierarchicalSubject' },
	'highestbiostratigraphiczone' => { 118 => [\'GeologicalContext','GeologicalContextHighestBiostratigraphicZone'] },
	'highisomultiplierblue' => { 325 => 0x1a },
	'highisomultipliergreen' => { 325 => 0x19 },
	'highisomultiplierred' => { 325 => 0x18 },
	'highisonoisereduction' => { 16 => 0xbc, 17 => 0xbd, 20 => 0xbd, 28 => 0xc9, 62 => 0x5, 84 => 0x202, 226 => 0xb1, 355 => 0x71, 407 => 0x2c, 408 => 0x26, 409 => 0x26, 420 => 0x2009, 425 => 0x12, 450 => 0x42 },
	'highisonoisereduction2' => { 420 => 0xb050 },
	'highlight' => { 397 => 0xf },
	'highlight2012' => { 477 => 'Highlight2012', 479 => 'Highlight2012' },
	'highlightadj' => { 103 => 0x2030c },
	'highlightcolordistortreduct' => { 454 => 0x8026 },
	'highlightlinearitylimit' => { 394 => 0xa025 },
	'highlightprotection' => { 271 => 0x6 },
	'highlightrecovery' => { 477 => 'HighlightRecovery', 479 => 'HighlightRecovery' },
	'highlights' => { 420 => 0x2033, 471 => 'Highlights' },
	'highlights2012' => { 477 => 'Highlights2012', 479 => 'Highlights2012' },
	'highlightsadj' => { 454 => 0x9019 },
	'highlightshadow' => { 320 => 0xad },
	'highlighttone' => { 127 => 0x1041 },
	'highlighttonepriority' => { 13 => 0x7, 16 => 0x7, 17 => 0x7, 18 => 0x7, 20 => 0x7, 22 => 0x7, 28 => 0x7, 62 => 0x3, 84 => 0x203 },
	'highlightwarning' => { 320 => 0x8002 },
	'highlowkeyadj' => { 355 => 0x6c },
	'highspeedsync' => { 184 => 0x5, 295 => 0x55, 407 => 0x2, 408 => 0x2 },
	'hintversion' => { 380 => 'hinv' },
	'histogramxml' => { 272 => 0x83a1a25 },
	'history' => { 491 => 'History', 504 => 'History' },
	'historyaction' => { 504 => [\'History','HistoryAction'] },
	'historychanged' => { 504 => [\'History','HistoryChanged'] },
	'historyinstanceid' => { 504 => [\'History','HistoryInstanceID'] },
	'historyparameters' => { 504 => [\'History','HistoryParameters'] },
	'historysoftwareagent' => { 504 => [\'History','HistorySoftwareAgent'] },
	'historywhen' => { 504 => [\'History','HistoryWhen'] },
	'holefilldarkdeltathreshold' => { 138 => 0xc88 },
	'holefilldeltathreshold' => { 138 => 0xc7e },
	'hometowncity' => { 113 => 0x3006, 355 => 0x23, 361 => 0x2 },
	'hometowncitycode' => { 362 => 0x1000 },
	'hometowndst' => { 355 => 0x25, 361 => '0.2' },
	'hostcomputer' => { 119 => 0x13c },
	'hostsoftwarerendering' => { 138 => 0xce7 },
	'hue' => { 189 => 0x3b, 232 => 0x3d, 233 => 0x45, 355 => 0x67 },
	'hueadj' => { 275 => 0x2f, 454 => 0x8019 },
	'hueadjust' => { 387 => 0x1016 },
	'hueadjustment' => { 182 => 0x4a, 183 => 0x40, 226 => 0x92, 231 => 0x36 },
	'hueadjustmentaqua' => { 477 => 'HueAdjustmentAqua', 479 => 'HueAdjustmentAqua' },
	'hueadjustmentblue' => { 477 => 'HueAdjustmentBlue', 479 => 'HueAdjustmentBlue' },
	'hueadjustmentgreen' => { 477 => 'HueAdjustmentGreen', 479 => 'HueAdjustmentGreen' },
	'hueadjustmentmagenta' => { 477 => 'HueAdjustmentMagenta', 479 => 'HueAdjustmentMagenta' },
	'hueadjustmentorange' => { 477 => 'HueAdjustmentOrange', 479 => 'HueAdjustmentOrange' },
	'hueadjustmentpurple' => { 477 => 'HueAdjustmentPurple', 479 => 'HueAdjustmentPurple' },
	'hueadjustmentred' => { 477 => 'HueAdjustmentRed', 479 => 'HueAdjustmentRed' },
	'hueadjustmentyellow' => { 477 => 'HueAdjustmentYellow', 479 => 'HueAdjustmentYellow' },
	'huesetting' => { 305 => 0x1011 },
	'humanobservation' => { 118 => 'HumanObservation' },
	'humanobservationday' => { 118 => [\'HumanObservation','HumanObservationDay'] },
	'humanobservationearliestdate' => { 118 => [\'HumanObservation','HumanObservationEarliestDate'] },
	'humanobservationenddayofyear' => { 118 => [\'HumanObservation','HumanObservationEndDayOfYear'] },
	'humanobservationeventdate' => { 118 => [\'HumanObservation','HumanObservationEventDate'] },
	'humanobservationeventid' => { 118 => [\'HumanObservation','HumanObservationEventID'] },
	'humanobservationeventremarks' => { 118 => [\'HumanObservation','HumanObservationEventRemarks'] },
	'humanobservationeventtime' => { 118 => [\'HumanObservation','HumanObservationEventTime'] },
	'humanobservationfieldnotes' => { 118 => [\'HumanObservation','HumanObservationFieldNotes'] },
	'humanobservationfieldnumber' => { 118 => [\'HumanObservation','HumanObservationFieldNumber'] },
	'humanobservationhabitat' => { 118 => [\'HumanObservation','HumanObservationHabitat'] },
	'humanobservationlatestdate' => { 118 => [\'HumanObservation','HumanObservationLatestDate'] },
	'humanobservationmonth' => { 118 => [\'HumanObservation','HumanObservationMonth'] },
	'humanobservationparenteventid' => { 118 => [\'HumanObservation','HumanObservationParentEventID'] },
	'humanobservationsamplesizeunit' => { 118 => [\'HumanObservation','HumanObservationSampleSizeUnit'] },
	'humanobservationsamplesizevalue' => { 118 => [\'HumanObservation','HumanObservationSampleSizeValue'] },
	'humanobservationsamplingeffort' => { 118 => [\'HumanObservation','HumanObservationSamplingEffort'] },
	'humanobservationsamplingprotocol' => { 118 => [\'HumanObservation','HumanObservationSamplingProtocol'] },
	'humanobservationstartdayofyear' => { 118 => [\'HumanObservation','HumanObservationStartDayOfYear'] },
	'humanobservationverbatimeventdate' => { 118 => [\'HumanObservation','HumanObservationVerbatimEventDate'] },
	'humanobservationyear' => { 118 => [\'HumanObservation','HumanObservationYear'] },
	'humidity' => { 119 => 0x9401, 484 => 'Humidity' },
	'icc_profile' => { 120 => 'ICC_Profile' },
	'iccprofilename' => { 491 => 'ICCProfile' },
	'iconuri' => { 380 => 'icnu' },
	'idccreativestyle' => { 454 => 0x8000 },
	'idcpreviewlength' => { 454 => 0x202 },
	'idcpreviewstart' => { 454 => 0x201 },
	'identification' => { 118 => 'Identification' },
	'identificationid' => { 118 => [\'Identification','IdentificationIdentificationID'] },
	'identificationqualifier' => { 118 => [\'Identification','IdentificationIdentificationQualifier'] },
	'identificationreferences' => { 118 => [\'Identification','IdentificationIdentificationReferences'] },
	'identificationremarks' => { 118 => [\'Identification','IdentificationIdentificationRemarks'] },
	'identificationverificationstatus' => { 118 => [\'Identification','IdentificationIdentificationVerificationStatus'] },
	'identifiedby' => { 118 => [\'Identification','IdentificationIdentifiedBy'] },
	'identifier' => { 480 => 'identifier', 501 => 'Identifier' },
	'ifcameramodel' => { 138 => 0x9c8 },
	'illuminantdata1' => { 119 => 0xcd35 },
	'illuminantdata2' => { 119 => 0xcd36 },
	'illuminantdata3' => { 119 => 0xcd37 },
	'illumination' => { 290 => '0.5', 382 => 0x48 },
	'imageabsolutex' => { 138 => 0x3fe },
	'imageabsolutey' => { 138 => 0x3ff },
	'imageadjustment' => { 226 => 0x80, 262 => 0x5 },
	'imagealterationconstraints' => { 307 => 'ImageAlterationConstraints' },
	'imagearea' => { 242 => 0x10, 245 => 0x10 },
	'imageareaoffset' => { 355 => 0x38 },
	'imageauthentication' => { 226 => 0x20 },
	'imageboundary' => { 226 => 0x16 },
	'imagecount' => { 127 => 0x1438, 226 => 0xa5, 423 => 0x11b },
	'imagecreator' => { 307 => 'ImageCreator' },
	'imagecreatorid' => { 307 => [\'ImageCreator','ImageCreatorImageCreatorID'] },
	'imagecreatorimageid' => { 307 => 'ImageCreatorImageID' },
	'imagecreatorname' => { 307 => [\'ImageCreator','ImageCreatorImageCreatorName'] },
	'imagecropx' => { 138 => 0x41f },
	'imagecropy' => { 138 => 0x420 },
	'imagedata' => { 464 => 'Data' },
	'imagedatasize' => { 226 => 0xa2 },
	'imagedescription' => { 119 => 0x10e, 499 => 'ImageDescription' },
	'imageduplicationconstraints' => { 307 => 'ImageDuplicationConstraints' },
	'imagedustoff' => { 272 => 0xfe443a45 },
	'imageeditcount' => { 355 => 0x41 },
	'imageediting' => { 355 => 0x32 },
	'imageeffects' => { 387 => 0x1010 },
	'imagefileconstraints' => { 307 => 'ImageFileConstraints' },
	'imagefileformatasdelivered' => { 307 => 'ImageFileFormatAsDelivered' },
	'imagefilesizeasdelivered' => { 307 => 'ImageFileSizeAsDelivered' },
	'imagegeneration' => { 127 => 0x1436 },
	'imageheight' => { 119 => 0x101, 188 => 0xc, 364 => 0x10d, 462 => 'ImageHeight', 499 => 'ImageLength' },
	'imagehistory' => { 119 => 0x9213, 482 => 'ImageHistory' },
	'imageidnumber' => { 315 => 0x340 },
	'imagemimetype' => { 464 => 'Mime' },
	'imagenumber' => { 119 => 0x9211, 156 => 'ImageNumber', 182 => 0xae, 183 => 0x5e, 364 => 0x113, 407 => 0x9b, 409 => [0x400,'276.1',0x314], 474 => 'ImageNumber' },
	'imagenumber2' => { 183 => 0x62 },
	'imageoptimization' => { 226 => 0xa9 },
	'imageorientation' => { 131 => 0x83 },
	'imageprocessing' => { 226 => 0x1a },
	'imageprocessingfiledatecreated' => { 138 => 0xc81 },
	'imageprocessingfiletagsversionnumber' => { 138 => 0xc80 },
	'imageprocessingversion' => { 301 => 0x0 },
	'imagequality' => { 156 => 'ImageQuality', 244 => '723.2', 245 => '732.2', 255 => '708.1', 320 => 0x1 },
	'imagequality2' => { 297 => 0x603 },
	'imagerank' => { 467 => 'ImageRank' },
	'imagerbiassettlingdelaymsec' => { 138 => 0x600 },
	'imagerboardversion' => { 138 => 0x439 },
	'imagercols' => { 138 => 0x17d4 },
	'imageref' => { 487 => 'ImageRef' },
	'imageregion' => { 489 => 'ImageRegion' },
	'imageregionboundary' => { 489 => [\'ImageRegion','ImageRegionRegionBoundary'] },
	'imageregionboundaryh' => { 489 => [\'ImageRegion','ImageRegionRegionBoundaryRbH'] },
	'imageregionboundaryrx' => { 489 => [\'ImageRegion','ImageRegionRegionBoundaryRbRx'] },
	'imageregionboundaryshape' => { 489 => [\'ImageRegion','ImageRegionRegionBoundaryRbShape'] },
	'imageregionboundaryunit' => { 489 => [\'ImageRegion','ImageRegionRegionBoundaryRbUnit'] },
	'imageregionboundaryvertices' => { 489 => [\'ImageRegion','ImageRegionRegionBoundaryRbVertices'] },
	'imageregionboundaryverticesx' => { 489 => [\'ImageRegion','ImageRegionRegionBoundaryRbVerticesRbX'] },
	'imageregionboundaryverticesy' => { 489 => [\'ImageRegion','ImageRegionRegionBoundaryRbVerticesRbY'] },
	'imageregionboundaryw' => { 489 => [\'ImageRegion','ImageRegionRegionBoundaryRbW'] },
	'imageregionboundaryx' => { 489 => [\'ImageRegion','ImageRegionRegionBoundaryRbX'] },
	'imageregionboundaryy' => { 489 => [\'ImageRegion','ImageRegionRegionBoundaryRbY'] },
	'imageregionctype' => { 489 => [\'ImageRegion','ImageRegionRCtype'] },
	'imageregionctypeidentifier' => { 489 => [\'ImageRegion','ImageRegionRCtypeIdentifier'] },
	'imageregionctypename' => { 489 => [\'ImageRegion','ImageRegionRCtypeName'] },
	'imageregionid' => { 489 => [\'ImageRegion','ImageRegionRId'] },
	'imageregionname' => { 489 => [\'ImageRegion','ImageRegionName'] },
	'imageregionrole' => { 489 => [\'ImageRegion','ImageRegionRRole'] },
	'imageregionroleidentifier' => { 489 => [\'ImageRegion','ImageRegionRRoleIdentifier'] },
	'imageregionrolename' => { 489 => [\'ImageRegion','ImageRegionRRoleName'] },
	'imageresolution' => { 138 => 0x944 },
	'imageresolutionjpg' => { 138 => 0x945 },
	'imagereview' => { 281 => '0.4', 290 => '0.4' },
	'imagereviewmonitorofftime' => { 280 => '21.1', 282 => '21.1', 283 => '21.1', 287 => '20.1', 292 => '21.1', 293 => '21.1', 295 => 0x39 },
	'imagereviewtime' => { 279 => '25.1', 281 => '2.1', 284 => '19.1', 285 => '20.1', 286 => '20.1', 288 => '9.2', 289 => '20.1', 294 => '21.2' },
	'imagerfiledatecreated' => { 138 => 0x9c5 },
	'imagerfileproductionlevel' => { 138 => 0x9c4 },
	'imagerfiletagsversionstandard' => { 138 => 0x9c7 },
	'imagerotated' => { 151 => 0x2a },
	'imagerpowerondelaymsec' => { 138 => 0x5fd },
	'imagerrows' => { 138 => 0x17de },
	'imagesegmentlines' => { 138 => 0x184d },
	'imagesegmentstartline' => { 138 => 0x184c },
	'imagesize' => { 162 => 'ImageSize' },
	'imagesizeraw' => { 226 => 0x3e },
	'imagesizerestriction' => { 496 => 'imageSizeRestriction' },
	'imagesourcedata' => { 119 => 0x935c },
	'imagespace' => { 138 => 0x909 },
	'imagestabilization' => { 34 => 0x22, 113 => 0x3020, 127 => 0x1422, 156 => 'ImageStabilization', 182 => 0xbd, 183 => 0x71, 184 => 0x57, 185 => 0x0, 186 => [0x18,0x107,0x113], 187 => 0x49c2, 226 => 0xac, 297 => 0x604, 300 => 0x1600, 320 => 0x1a, 412 => 0x12, 413 => 0x11, 420 => 0xb026 },
	'imagestabilization2' => { 411 => 0xa },
	'imagestabilizationsetting' => { 187 => 0x14, 407 => 0x3d, 408 => 0x3d, 418 => 0x14 },
	'imagestyle' => { 407 => 0x2d, 408 => 0x27 },
	'imagesupplier' => { 307 => 'ImageSupplier' },
	'imagesupplierid' => { 307 => [\'ImageSupplier','ImageSupplierImageSupplierID'] },
	'imagesupplierimageid' => { 307 => 'ImageSupplierImageID' },
	'imagesuppliername' => { 307 => [\'ImageSupplier','ImageSupplierImageSupplierName'] },
	'imagetemperaturemax' => { 121 => 0x1 },
	'imagetemperaturemin' => { 121 => 0x2 },
	'imagetone' => { 355 => 0x4f },
	'imagetype' => { 131 => 0x82, 307 => 'ImageType' },
	'imageuniqueid' => { 1 => 0x15, 64 => 0x28, 119 => 0xa420, 482 => 'ImageUniqueID', 483 => 'ImageUniqueID' },
	'imagewidth' => { 119 => 0x100, 188 => 0xe, 364 => 0x10c, 462 => 'ImageWidth', 499 => 'ImageWidth' },
	'inclinationangle' => { 454 => 0x900f },
	'inclinationcorrection' => { 454 => 0x900e },
	'incrementaltemperature' => { 477 => 'IncrementalTemperature', 479 => 'IncrementalTemperature' },
	'incrementaltint' => { 477 => 'IncrementalTint', 479 => 'IncrementalTint' },
	'industry' => { 493 => 'industry', 494 => 'industry' },
	'infobuttonwhenshooting' => { 84 => 0x409 },
	'information' => { 374 => 'information', 380 => "\xa9inf" },
	'infourl' => { 380 => 'infu' },
	'infraredilluminator' => { 381 => 0x28 },
	'ingredientexclusion' => { 495 => 'ingredientExclusion' },
	'ingredients' => { 504 => 'Ingredients' },
	'ingredientsalternatepaths' => { 504 => [\'Ingredients','IngredientsAlternatePaths'] },
	'ingredientsdocumentid' => { 504 => [\'Ingredients','IngredientsDocumentID'] },
	'ingredientsfilepath' => { 504 => [\'Ingredients','IngredientsFilePath'] },
	'ingredientsfrompart' => { 504 => [\'Ingredients','IngredientsFromPart'] },
	'ingredientsinstanceid' => { 504 => [\'Ingredients','IngredientsInstanceID'] },
	'ingredientslastmodifydate' => { 504 => [\'Ingredients','IngredientsLastModifyDate'] },
	'ingredientslasturl' => { 504 => [\'Ingredients','IngredientsLastURL'] },
	'ingredientslinkcategory' => { 504 => [\'Ingredients','IngredientsLinkCategory'] },
	'ingredientslinkform' => { 504 => [\'Ingredients','IngredientsLinkForm'] },
	'ingredientsmanager' => { 504 => [\'Ingredients','IngredientsManager'] },
	'ingredientsmanagervariant' => { 504 => [\'Ingredients','IngredientsManagerVariant'] },
	'ingredientsmanageto' => { 504 => [\'Ingredients','IngredientsManageTo'] },
	'ingredientsmanageui' => { 504 => [\'Ingredients','IngredientsManageUI'] },
	'ingredientsmaskmarkers' => { 504 => [\'Ingredients','IngredientsMaskMarkers'] },
	'ingredientsoriginaldocumentid' => { 504 => [\'Ingredients','IngredientsOriginalDocumentID'] },
	'ingredientspartmapping' => { 504 => [\'Ingredients','IngredientsPartMapping'] },
	'ingredientsplacedresolutionunit' => { 504 => [\'Ingredients','IngredientsPlacedResolutionUnit'] },
	'ingredientsplacedxresolution' => { 504 => [\'Ingredients','IngredientsPlacedXResolution'] },
	'ingredientsplacedyresolution' => { 504 => [\'Ingredients','IngredientsPlacedYResolution'] },
	'ingredientsrenditionclass' => { 504 => [\'Ingredients','IngredientsRenditionClass'] },
	'ingredientsrenditionparams' => { 504 => [\'Ingredients','IngredientsRenditionParams'] },
	'ingredientstopart' => { 504 => [\'Ingredients','IngredientsToPart'] },
	'ingredientsversionid' => { 504 => [\'Ingredients','IngredientsVersionID'] },
	'initialafpointaiservoaf' => { 84 => 0x51e },
	'initialafpointinservo' => { 2 => 0x13 },
	'initialcameradolly' => { 465 => 'InitialCameraDolly' },
	'initialhorizontalfovdegrees' => { 465 => 'InitialHorizontalFOVDegrees' },
	'initialkey' => { 179 => 'WM/InitialKey' },
	'initialverticalfovdegrees' => { 465 => 'InitialVerticalFOVDegrees' },
	'initialviewheadingdegrees' => { 465 => 'InitialViewHeadingDegrees', 466 => 'InitialViewHeadingDegrees' },
	'initialviewpitchdegrees' => { 465 => 'InitialViewPitchDegrees', 466 => 'InitialViewPitchDegrees' },
	'initialviewrolldegrees' => { 465 => 'InitialViewRollDegrees', 466 => 'InitialViewRollDegrees' },
	'initialzoomliveview' => { 279 => '4.4' },
	'initialzoomsetting' => { 279 => '9.3', 288 => '27.3' },
	'inkset' => { 119 => 0x14c },
	'inputprofile' => { 138 => 0x1389 },
	'instanceid' => { 504 => 'InstanceID' },
	'instantplaybacksetup' => { 184 => 0x3e },
	'instantplaybacktime' => { 184 => 0x3d },
	'instructions' => { 491 => 'Instructions' },
	'instrument' => { 503 => 'instrument' },
	'integrationtime' => { 138 => 0x423 },
	'intellectualgenre' => { 488 => 'IntellectualGenre' },
	'intelligentauto' => { 420 => 0xb052, 446 => 0xd, 447 => 0xe, 448 => 0xd },
	'intelligentcontrast' => { 52 => 0x4 },
	'intelligentd-range' => { 320 => 0x79 },
	'intelligentexposure' => { 320 => 0x5d },
	'intelligentresolution' => { 320 => 0x70 },
	'interchangecolorspace' => { 133 => 0x40 },
	'intergraphmatrix' => { 119 => 0x8480 },
	'internalflash' => { 181 => 0x2b, 279 => '23.1', 281 => '8.1', 284 => '22.1', 286 => '23.1', 290 => '8.1', 294 => '24.1', 300 => 0x1208 },
	'internalflashae1' => { 302 => 0x1021 },
	'internalflashae1_0' => { 302 => 0x101d },
	'internalflashae2' => { 302 => 0x1022 },
	'internalflashae2_0' => { 302 => 0x101e },
	'internalflashmode' => { 343 => 0x1 },
	'internalflashstrength' => { 343 => 0x3 },
	'internalflashtable' => { 302 => 0x1024 },
	'internallensserialnumber' => { 394 => 0xa005 },
	'internalndfilter' => { 320 => 0x9d },
	'internalserialnumber' => { 64 => 0x96, 76 => 0x9, 127 => 0x10, 187 => 0x49dc, 296 => 0x18, 298 => 0x102, 317 => 0x500, 320 => 0x25, 335 => 0x4, 387 => 0x5, 438 => [0x7c,0xf0], 439 => 0x88, 440 => [0x88,0x8a] },
	'interopindex' => { 119 => 0x1, 484 => 'InteroperabilityIndex' },
	'interopversion' => { 119 => 0x2 },
	'interval' => { 248 => 0xd0 },
	'intervaldurationhours' => { 228 => 0xa0 },
	'intervaldurationminutes' => { 228 => 0xa4 },
	'intervaldurationseconds' => { 228 => 0xa8 },
	'intervalexposuresmoothing' => { 228 => 0xb8, 252 => 0xc416 },
	'intervalframe' => { 248 => 0xd4 },
	'intervallength' => { 181 => 0x10 },
	'intervalmode' => { 181 => 0x26 },
	'intervalnumber' => { 181 => 0x11 },
	'intervalpriority' => { 228 => 0xba, 252 => 0xc418 },
	'intervals' => { 228 => 0xb0, 229 => 0xbc, 252 => 0xc40e },
	'intervalshooting' => { 252 => 0x760c, 260 => 0x760c, 261 => 0x6c98, 355 => 0x92 },
	'introtime' => { 503 => 'introTime' },
	'introtimescale' => { 503 => [\'introTime','introTimeScale'] },
	'introtimevalue' => { 503 => [\'introTime','introTimeValue'] },
	'ipaversion' => { 138 => 0xdae },
	'ipfcameramodel' => { 138 => 0xe4d },
	'iptc' => { 120 => 'IPTC' },
	'iptc-naa' => { 119 => 0x83bb, 325 => 0x83bb },
	'iptcbitspersample' => { 133 => 0x56 },
	'iptcdigest' => { 369 => 0x425 },
	'iptcimageheight' => { 133 => 0x1e },
	'iptcimagerotation' => { 133 => 0x66 },
	'iptcimagewidth' => { 133 => 0x14 },
	'iptclastedited' => { 489 => 'IptcLastEdited' },
	'iptcpicturenumber' => { 133 => 0xa },
	'iptcpixelheight' => { 133 => 0x32 },
	'iptcpixelwidth' => { 133 => 0x28 },
	'isalternativeof' => { 493 => 'isAlternativeOf' },
	'isbn' => { 493 => 'isbn' },
	'iscorrectionof' => { 493 => 'isCorrectionOf' },
	'iscustompicturestyle' => { 109 => 0x3 },
	'ismergedhdr' => { 474 => 'IsMergedHDR' },
	'ismergedpanorama' => { 474 => 'IsMergedPanorama' },
	'iso' => { 7 => 0x6, 9 => 0x6, 10 => 0x75, 11 => 0x6, 12 => 0x79, 13 => 0x6, 14 => 0x6, 15 => 0x6, 16 => 0x6, 17 => 0x6, 18 => 0x6, 19 => 0x6, 20 => 0x6, 21 => 0x6, 22 => 0x6, 23 => 0x6, 24 => 0x6, 25 => 0x6, 26 => 0x6, 27 => 0x6, 28 => 0x6, 29 => 0x6, 30 => 0x0, 31 => 0x1, 112 => 0x14, 113 => [0x3014,0x14], 119 => 0x8827, 137 => 0xfd06, 138 => 0x1784, 140 => 0x60, 142 => [0xfa2e,0xfa46], 143 => [0x27,0x28], 144 => 0xf105, 147 => 0x14, 149 => 0x4e, 151 => 0x1e, 152 => 0x1a, 154 => 0x34, 156 => 'ISO', 181 => 0x8, 187 => 0x49ba, 217 => 0x0, 226 => 0x2, 320 => 0xd1, 325 => 0x17, 355 => [0x8b,0x14], 362 => 0x14, 364 => 0x105, 394 => 0xa014, 397 => 0x86, 418 => 0x6f, 425 => [0x1f,0x21,0x25], 483 => 'ISOSpeedRatings' },
	'iso2' => { 217 => 0x6, 239 => 0x265, 240 => 0x25c, 241 => 0x265, 242 => 0x221, 243 => 0x25d, 244 => 0x256, 245 => 0x25d, 249 => 0x2b5, 253 => 0x265, 259 => 0x2b5 },
	'isoauto' => { 336 => '14.4' },
	'isoautoflashlimit' => { 229 => 0x146 },
	'isoautohilimit' => { 229 => 0x144, 247 => 0x18eb, 248 => 0xe82, 257 => 0x185d },
	'isoautomax' => { 419 => 0x4 },
	'isoautomin' => { 419 => 0x2 },
	'isoautoparameters' => { 355 => 0x7a },
	'isoautoshuttertime' => { 229 => 0x14e, 247 => 0x18ea, 248 => 0xe81, 257 => 0x185c },
	'isocalibrationgain' => { 138 => 0x89f },
	'isodisplay' => { 282 => '4.1', 283 => '4.1', 284 => '2.3', 285 => '3.3', 286 => '3.3', 289 => '3.3', 292 => '4.3', 293 => '4.1', 294 => '4.3' },
	'isoexpansion' => { 84 => 0x103, 85 => 0x7, 86 => 0x8, 89 => 0x8, 217 => 0x4 },
	'isoexpansion2' => { 217 => 0xa },
	'isofloor' => { 336 => 0x6 },
	'isoselected' => { 319 => 0x359 },
	'isoselection' => { 226 => 0xf },
	'isosensitivitystep' => { 287 => '6.2', 289 => '6.2' },
	'isosetting' => { 140 => 0x5e, 152 => 0x14, 156 => 'ISOSetting', 181 => 0x24, 182 => 0x26, 183 => 0x1c, 184 => 0x13, 189 => 0x6, 226 => 0x13, 336 => '17.3', 386 => 0x27, 407 => 0x16, 408 => 0x14, 409 => 0x2, 418 => 0x6d, 419 => 0x0 },
	'isospeed' => { 119 => 0x8833, 484 => 'ISOSpeed' },
	'isospeedexpansion' => { 83 => 0x3 },
	'isospeedincrements' => { 84 => 0x102 },
	'isospeedlatitudeyyy' => { 119 => 0x8834, 484 => 'ISOSpeedLatitudeyyy' },
	'isospeedlatitudezzz' => { 119 => 0x8835, 484 => 'ISOSpeedLatitudezzz' },
	'isospeedrange' => { 84 => 0x103 },
	'isostepsize' => { 279 => '6.1', 280 => '7.2', 282 => '7.2', 283 => '7.2', 288 => '4.1', 292 => '7.2', 293 => '7.2', 295 => 0x15d },
	'isovalue' => { 302 => 0x1001 },
	'isrccode' => { 380 => "\xa9isr" },
	'issn' => { 493 => 'issn' },
	'issueidentifier' => { 493 => 'issueIdentifier' },
	'issuename' => { 493 => 'issueName' },
	'issueteaser' => { 493 => 'issueTeaser' },
	'issuetype' => { 493 => 'issueType' },
	'istranslationof' => { 493 => 'isTranslationOf' },
	'itemsubtype' => { 178 => 'ItemSubType' },
	'itunesu' => { 372 => 'itnu' },
	'jobid' => { 131 => 0xb8 },
	'jobname' => { 485 => 'JobName' },
	'jobref' => { 502 => 'JobRef' },
	'jobrefid' => { 502 => [\'JobRef','JobRefId'] },
	'jobrefname' => { 502 => [\'JobRef','JobRefName'] },
	'jobrefurl' => { 502 => [\'JobRef','JobRefUrl'] },
	'jobstatus' => { 485 => 'JobStatus' },
	'jpeg-heifswitch' => { 420 => 0x2039 },
	'jpeghandling' => { 477 => 'JPEGHandling', 479 => 'JPEGHandling' },
	'jpegquality' => { 10 => 0x66, 320 => 0x43, 322 => 0x3034, 420 => 0xb047 },
	'jpegsize' => { 322 => 0x303a },
	'jpgcompression' => { 248 => 0x7d4 },
	'jpgfromraw' => { 97 => 0x2007, 114 => 'Exif-JpgFromRaw', 325 => 0x2e },
	'jpgfromrawlength' => { 119 => [0x117,0x202] },
	'jpgfromrawstart' => { 119 => [0x111,0x201] },
	'jpgrecordedpixels' => { 336 => '14.1' },
	'jurisdiction' => { 475 => 'jurisdiction' },
	'keepexposure' => { 295 => 0x237 },
	'kelvinwb_01' => { 344 => 0x5 },
	'kelvinwb_02' => { 344 => 0x9 },
	'kelvinwb_03' => { 344 => 0xd },
	'kelvinwb_04' => { 344 => 0x11 },
	'kelvinwb_05' => { 344 => 0x15 },
	'kelvinwb_06' => { 344 => 0x19 },
	'kelvinwb_07' => { 344 => 0x1d },
	'kelvinwb_08' => { 344 => 0x21 },
	'kelvinwb_09' => { 344 => 0x25 },
	'kelvinwb_10' => { 344 => 0x29 },
	'kelvinwb_11' => { 344 => 0x2d },
	'kelvinwb_12' => { 344 => 0x31 },
	'kelvinwb_13' => { 344 => 0x35 },
	'kelvinwb_14' => { 344 => 0x39 },
	'kelvinwb_15' => { 344 => 0x3d },
	'kelvinwb_16' => { 344 => 0x41 },
	'kelvinwb_daylight' => { 344 => 0x1 },
	'kerneldenominators' => { 138 => 0x933 },
	'key' => { 503 => 'key' },
	'keystonecompensation' => { 301 => 0x1900 },
	'keystonedirection' => { 301 => 0x1901 },
	'keystonevalue' => { 301 => 0x1906 },
	'keyword' => { 372 => 'keyw', 493 => 'keyword' },
	'keywordinfo' => { 171 => 'Keywords' },
	'keywords' => { 131 => 0x19, 157 => 'Keywords', 306 => 'Keywords', 371 => 'Keywords', 374 => 'keywords', 472 => 'keywords', 490 => 'Keywords', 501 => 'Keywords' },
	'killdate' => { 493 => 'killDate' },
	'killdatea-platform' => { 493 => [\'killDate','killDateA-platform'] },
	'killdatedate' => { 493 => [\'killDate','killDateDate'] },
	'kodakimageheight' => { 137 => 0xf908, 140 => 0xe, 142 => [0xfa1e,0xfa52], 148 => 0x70 },
	'kodakimagewidth' => { 137 => 0xf907, 140 => 0xc, 142 => [0xfa1d,0xfa51], 148 => 0x6c },
	'kodakinfotype' => { 137 => 0xfa00 },
	'kodaklook' => { 138 => 0xe4c },
	'kodaklookprofile' => { 138 => 0x138a },
	'kodakmaker' => { 148 => 0x8 },
	'kodakmodel' => { 140 => 0x0, 148 => 0x28 },
	'kodaktag' => { 138 => 0x3ea },
	'kodakversion' => { 138 => 0x0 },
	'label' => { 310 => 'Label', 501 => 'Label' },
	'labelname1' => { 487 => [\'TagStructure','TagStructureLabelName'] },
	'labelname2' => { 487 => [\'TagStructure','TagStructureSubLabelsLabelName'] },
	'labelname3' => { 487 => [\'TagStructure','TagStructureSubLabelsSubLabelsLabelName'] },
	'labelname4' => { 487 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsLabelName'] },
	'labelname5' => { 487 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsLabelName'] },
	'labelname6' => { 487 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsLabelName'] },
	'landmark' => { 320 => 0x6f },
	'landscapeoutputhighlightpoint' => { 109 => 0x26 },
	'landscapeoutputshadowpoint' => { 109 => 0x27 },
	'landscaperawcolortone' => { 109 => 0x1f },
	'landscaperawcontrast' => { 109 => 0x21 },
	'landscaperawhighlight' => { 109 => 0x77 },
	'landscaperawhighlightpoint' => { 109 => 0x24 },
	'landscaperawlinear' => { 109 => 0x22 },
	'landscaperawsaturation' => { 109 => 0x20 },
	'landscaperawshadow' => { 109 => 0x80 },
	'landscaperawshadowpoint' => { 109 => 0x25 },
	'landscaperawsharpness' => { 109 => 0x23 },
	'landscapeunsharpmaskfineness' => { 109 => 0xa0 },
	'landscapeunsharpmaskstrength' => { 109 => 0x9e },
	'landscapeunsharpmaskthreshold' => { 109 => 0xa2 },
	'language' => { 229 => 0x592, 480 => 'language' },
	'languageidentifier' => { 131 => 0x87 },
	'largestvalidinteriorrectheight' => { 465 => 'LargestValidInteriorRectHeight' },
	'largestvalidinteriorrectleft' => { 465 => 'LargestValidInteriorRectLeft' },
	'largestvalidinteriorrecttop' => { 465 => 'LargestValidInteriorRectTop' },
	'largestvalidinteriorrectwidth' => { 465 => 'LargestValidInteriorRectWidth' },
	'lastfilenumber' => { 181 => 0x1b },
	'lastkeywordiptc' => { 178 => 'LastKeywordIPTC' },
	'lastkeywordxmp' => { 178 => 'LastKeywordXMP' },
	'lastphotodate' => { 465 => 'LastPhotoDate' },
	'lasturl' => { 504 => 'LastURL' },
	'lateralchromaticaberration' => { 420 => 0x2012 },
	'lateralchromaticaberrationcorrectionalreadyapplied' => { 474 => 'LateralChromaticAberrationCorrectionAlreadyApplied' },
	'latestageorhigheststage' => { 118 => [\'GeologicalContext','GeologicalContextLatestAgeOrHighestStage'] },
	'latesteonorhighesteonothem' => { 118 => [\'GeologicalContext','GeologicalContextLatestEonOrHighestEonothem'] },
	'latestepochorhighestseries' => { 118 => [\'GeologicalContext','GeologicalContextLatestEpochOrHighestSeries'] },
	'latesteraorhighesterathem' => { 118 => [\'GeologicalContext','GeologicalContextLatestEraOrHighestErathem'] },
	'latestperiodorhighestsystem' => { 118 => [\'GeologicalContext','GeologicalContextLatestPeriodOrHighestSystem'] },
	'latitude' => { 116 => 'Latitude' },
	'lc1' => { 346 => 0x2 },
	'lc10' => { 346 => 0xb },
	'lc11' => { 346 => 0xc },
	'lc12' => { 346 => 0xd },
	'lc14' => { 346 => 0xf },
	'lc15' => { 346 => 0x10 },
	'lc3' => { 346 => 0x4 },
	'lc4' => { 346 => 0x5 },
	'lc5' => { 346 => 0x6 },
	'lc6' => { 346 => 0x7 },
	'lc7' => { 346 => 0x8 },
	'lc8' => { 346 => 0x9 },
	'lcddisplayatpoweron' => { 84 => 0x811, 88 => 0xa },
	'lcddisplayreturntoshoot' => { 89 => 0x12 },
	'lcdillumination' => { 279 => '17.5', 280 => '5.2', 282 => '5.1', 283 => '5.1', 288 => '10.3', 289 => '4.2', 292 => '5.2', 293 => '5.1', 294 => '5.4', 295 => 0x101 },
	'lcdilluminationduringbulb' => { 84 => 0x408 },
	'lcdmatrix' => { 138 => 0xe74 },
	'lcdmatrixchickfix' => { 138 => 0xe75 },
	'lcdmatrixmarvin' => { 138 => 0xe76 },
	'lcdpanels' => { 83 => 0x8 },
	'lcheditor' => { 272 => 0x8ae85e },
	'legacyiptcdigest' => { 491 => 'LegacyIPTCDigest' },
	'legalcode' => { 475 => 'legalcode' },
	'lens' => { 119 => 0xfdea, 226 => 0x84, 474 => 'Lens' },
	'lensafstopbutton' => { 82 => 0x11, 83 => 0x13, 84 => 0x506, 85 => 0x10, 86 => 0x12, 89 => 0x13, 90 => 0x9 },
	'lensaperturerange' => { 397 => [0x30,0x48] },
	'lenscontrolring' => { 295 => 0xad },
	'lenscorrectionsettings' => { 482 => 'LensCorrectionSettings' },
	'lensdistortinfo' => { 474 => 'LensDistortInfo' },
	'lensdistortionparams' => { 302 => 0x206 },
	'lensdrivenoaf' => { 84 => 0x505 },
	'lensdrivewhenafimpossible' => { 2 => 0xb },
	'lense-mountversion' => { 409 => 0x3f0, 453 => 0xd },
	'lensfirmware' => { 388 => 0x20, 394 => 0xa004 },
	'lensfirmwareversion' => { 298 => 0x204, 320 => 0x60, 409 => 0x3f3, 453 => 0x14 },
	'lensfocallength' => { 103 => 0xf0512, 346 => 0x9 },
	'lensfocalrange' => { 397 => [0xa,0x2a] },
	'lensfocusfunctionbuttons' => { 280 => '55.1', 282 => '52.1', 283 => '52.1', 292 => '52.1', 293 => '52.1' },
	'lensformat' => { 432 => 0x1891, 434 => 0x18bd, 435 => 0x18ed, 436 => 0x17f1, 438 => 0x106, 439 => 0x106, 449 => 0x603, 450 => 0x5d },
	'lensfstops' => { 218 => 0x7, 219 => 0xc, 220 => 0xd, 224 => 0xe, 226 => 0x8b, 346 => '0.3' },
	'lensfunc1button' => { 295 => 0x9f },
	'lensfunc2button' => { 295 => 0xa7 },
	'lensid' => { 224 => 0x30, 474 => 'LensID' },
	'lensidnumber' => { 218 => 0x6, 219 => 0xb, 220 => 0xc, 224 => 0xd },
	'lensinfo' => { 119 => 0xa432, 352 => 0x2a, 474 => 'LensInfo', 484 => 'LensSpecification' },
	'lenskind' => { 346 => 0x1 },
	'lensmake' => { 119 => 0xa433, 163 => 'Make', 484 => 'LensMake' },
	'lensmanualdistortionamount' => { 477 => 'LensManualDistortionAmount', 479 => 'LensManualDistortionAmount' },
	'lensmanufacturer' => { 178 => 'LensManufacturer' },
	'lensmaxaperturerange' => { 397 => 0x2b },
	'lensmodel' => { 7 => 0x937, 14 => 0x92b, 15 => 0x933, 64 => 0x95, 119 => 0xa434, 163 => 'Model', 178 => 'LensModel', 221 => 0x18a, 222 => 0x18b, 223 => 0x2ac, 298 => 0x203, 352 => 0xc, 364 => 0x412, 484 => 'LensModel' },
	'lensmodulationoptimizer' => { 127 => 0x1045 },
	'lensmount' => { 409 => 0x99, 432 => 0x1892, 434 => 0x18be, 435 => 0x18ee, 436 => 0x17f2, 438 => 0x105, 439 => 0x105, 449 => 0x604, 450 => 0x5e },
	'lensmount2' => { 453 => 0x8 },
	'lensprofilechromaticaberrationscale' => { 477 => 'LensProfileChromaticAberrationScale', 479 => 'LensProfileChromaticAberrationScale' },
	'lensprofiledigest' => { 477 => 'LensProfileDigest', 479 => 'LensProfileDigest' },
	'lensprofiledistortionscale' => { 477 => 'LensProfileDistortionScale', 479 => 'LensProfileDistortionScale' },
	'lensprofileenable' => { 477 => 'LensProfileEnable', 479 => 'LensProfileEnable' },
	'lensprofilefilename' => { 477 => 'LensProfileFilename', 479 => 'LensProfileFilename' },
	'lensprofileisembedded' => { 477 => 'LensProfileIsEmbedded', 479 => 'LensProfileIsEmbedded' },
	'lensprofilematchkeycameramodelname' => { 477 => 'LensProfileMatchKeyCameraModelName', 479 => 'LensProfileMatchKeyCameraModelName' },
	'lensprofilematchkeyexifmake' => { 477 => 'LensProfileMatchKeyExifMake', 479 => 'LensProfileMatchKeyExifMake' },
	'lensprofilematchkeyexifmodel' => { 477 => 'LensProfileMatchKeyExifModel', 479 => 'LensProfileMatchKeyExifModel' },
	'lensprofilematchkeyisraw' => { 477 => 'LensProfileMatchKeyIsRaw', 479 => 'LensProfileMatchKeyIsRaw' },
	'lensprofilematchkeylensid' => { 477 => 'LensProfileMatchKeyLensID', 479 => 'LensProfileMatchKeyLensID' },
	'lensprofilematchkeylensinfo' => { 477 => 'LensProfileMatchKeyLensInfo', 479 => 'LensProfileMatchKeyLensInfo' },
	'lensprofilematchkeylensname' => { 477 => 'LensProfileMatchKeyLensName', 479 => 'LensProfileMatchKeyLensName' },
	'lensprofilematchkeysensorformatfactor' => { 477 => 'LensProfileMatchKeySensorFormatFactor', 479 => 'LensProfileMatchKeySensorFormatFactor' },
	'lensprofilename' => { 477 => 'LensProfileName', 479 => 'LensProfileName' },
	'lensprofilesetup' => { 477 => 'LensProfileSetup', 479 => 'LensProfileSetup' },
	'lensprofilevignettingscale' => { 477 => 'LensProfileVignettingScale', 479 => 'LensProfileVignettingScale' },
	'lensproperties' => { 298 => 0x20b },
	'lensserialnumber' => { 21 => 0x164, 32 => 0x16b, 61 => 0x0, 119 => 0xa435, 163 => 'SerialNumber', 298 => 0x202, 318 => 0x321, 320 => 0x52, 380 => 'LENS', 388 => 0x30, 474 => 'LensSerialNumber', 484 => 'LensSerialNumber' },
	'lensshutterlock' => { 184 => 0x4a },
	'lensspec' => { 404 => 0x0, 405 => 0x0, 406 => 0x0, 420 => 0xb02a },
	'lensspecfeatures' => { 438 => [0x115,0x116], 439 => [0x116,0x1ed,0x1f0,0x21c,0x21e] },
	'lenstemperature' => { 302 => 0x1008 },
	'lenstype' => { 7 => 0xe2, 8 => 0xd, 9 => 0x1a7, 10 => 0xc, 11 => 0x111, 12 => 0xc, 13 => 0x14f, 14 => 0xd6, 15 => 0xde, 16 => 0xf6, 17 => 0xea, 18 => 0xff, 19 => [0xc,0x97], 20 => 0xe6, 21 => 0x153, 22 => 0xea, 23 => 0xe8, 24 => 0x127, 25 => 0x161, 26 => 0x166, 27 => 0x184, 28 => 0x112, 29 => 0x189, 34 => 0x16, 186 => 0x10c, 187 => 0x49bd, 226 => 0x83, 298 => 0x201, 311 => 0x16, 315 => 0x310, 317 => 0x303, 318 => 0x303, 320 => 0x51, 322 => 0x3405, 347 => 0x0, 348 => 0x0, 349 => 0x1, 350 => 0x1, 351 => 0x1, 353 => 0x0, 394 => 0xa003, 397 => 0x27, 420 => 0xb027, 432 => 0x1896, 434 => 0x18c2, 435 => 0x18f2, 436 => 0x17f6, 438 => 0x109, 439 => 0x109, 449 => 0x608, 450 => 0x62 },
	'lenstype2' => { 409 => 0x3f7, 432 => 0x1893, 434 => 0x18bf, 435 => 0x18ef, 436 => 0x17f3, 438 => 0x107, 439 => 0x107, 449 => 0x605, 450 => 0x60 },
	'lenstype3' => { 453 => 0x9 },
	'lenstypemake' => { 320 => 0xc4 },
	'lenstypemodel' => { 320 => [0xc5,0xe4] },
	'lenszoomposition' => { 446 => 0x19, 447 => 0x1e, 450 => [0x342,0x34e,0x35a] },
	'levelindicator' => { 328 => 0x15 },
	'levelmeter' => { 380 => ['Lvlm','lvlm'] },
	'levelorientation' => { 354 => 0x0 },
	'license' => { 475 => 'license' },
	'licensee' => { 307 => 'Licensee' },
	'licenseeid' => { 307 => [\'Licensee','LicenseeLicenseeID'] },
	'licenseeimageid' => { 307 => 'LicenseeImageID' },
	'licenseeimagenotes' => { 307 => 'LicenseeImageNotes' },
	'licenseename' => { 307 => [\'Licensee','LicenseeLicenseeName'] },
	'licenseenddate' => { 307 => 'LicenseEndDate' },
	'licenseeprojectreference' => { 307 => 'LicenseeProjectReference' },
	'licenseetransactionid' => { 307 => 'LicenseeTransactionID' },
	'licenseid' => { 307 => 'LicenseID' },
	'licensestartdate' => { 307 => 'LicenseStartDate' },
	'licensetransactiondate' => { 307 => 'LicenseTransactionDate' },
	'licensetype' => { 481 => 'licensetype' },
	'licensor' => { 307 => 'Licensor' },
	'licensorcity' => { 307 => [\'Licensor','LicensorLicensorCity'] },
	'licensorcountry' => { 307 => [\'Licensor','LicensorLicensorCountry'] },
	'licensoremail' => { 307 => [\'Licensor','LicensorLicensorEmail'] },
	'licensorextendedaddress' => { 307 => [\'Licensor','LicensorLicensorExtendedAddress'] },
	'licensorid' => { 307 => [\'Licensor','LicensorLicensorID'] },
	'licensorimageid' => { 307 => 'LicensorImageID' },
	'licensorname' => { 307 => [\'Licensor','LicensorLicensorName'] },
	'licensornotes' => { 307 => 'LicensorNotes' },
	'licensorpostalcode' => { 307 => [\'Licensor','LicensorLicensorPostalCode'] },
	'licensorregion' => { 307 => [\'Licensor','LicensorLicensorRegion'] },
	'licensorstreetaddress' => { 307 => [\'Licensor','LicensorLicensorStreetAddress'] },
	'licensortelephone1' => { 307 => [\'Licensor','LicensorLicensorTelephone1'] },
	'licensortelephone2' => { 307 => [\'Licensor','LicensorLicensorTelephone2'] },
	'licensortelephonetype1' => { 307 => [\'Licensor','LicensorLicensorTelephoneType1'] },
	'licensortelephonetype2' => { 307 => [\'Licensor','LicensorLicensorTelephoneType2'] },
	'licensortransactionid' => { 307 => 'LicensorTransactionID' },
	'licensorurl' => { 307 => [\'Licensor','LicensorLicensorURL'] },
	'lightcondition' => { 302 => 0x1009 },
	'lightingmode' => { 113 => 0x302a },
	'lightreading' => { 355 => 0x15 },
	'lightsource' => { 119 => 0x9208, 226 => 0x90, 305 => 0x1000, 483 => 'LightSource' },
	'lightsourcespecial' => { 396 => 0x21d },
	'lightswitch' => { 292 => '0.1', 294 => '0.1' },
	'lightvaluecenter' => { 302 => 0x103d },
	'lightvalueperiphery' => { 302 => 0x103e },
	'limitaf-areamodesel3dtracking' => { 295 => 0x153 },
	'limitaf-areamodeseldynamic_l' => { 295 => 0x151 },
	'limitaf-areamodeseldynamic_m' => { 295 => 0x150 },
	'limitaf-areamodeseldynamic_s' => { 295 => 0x14f },
	'limitaf-areamodeselpinpoint' => { 295 => 0x11 },
	'limitaf-areamodeselwideaf_l' => { 295 => 0x14 },
	'limitaf-areamodeselwideaf_s' => { 295 => 0x13 },
	'limitafareamodeselauto' => { 295 => 0x15 },
	'limitafareamodeselection' => { 280 => '51.1', 282 => '49.1', 283 => '49.1', 292 => '49.1', 293 => '49.1' },
	'limitreleasemodeselc120' => { 295 => '269.4' },
	'limitreleasemodeselc30' => { 295 => '269.3' },
	'limitreleasemodeselch' => { 295 => '269.2' },
	'limitreleasemodeselcl' => { 295 => '269.1' },
	'limitreleasemodeselself' => { 295 => '269.5' },
	'limitselectableimagearea16to9' => { 295 => 0x47 },
	'limitselectableimagearea1to1' => { 295 => 0x46 },
	'limitselectableimageareadx' => { 295 => 0x45 },
	'linearitylimitblue' => { 325 => 0x10 },
	'linearitylimitgreen' => { 325 => 0xf },
	'linearitylimitred' => { 325 => 0xe },
	'linearityuppermargin' => { 41 => 0x32c, 42 => 0x282, 45 => [0x2ba,0x2d1,0x2d5], 47 => 0x1e5, 48 => [0x1fe,0x2de], 49 => [0x232,0x310], 50 => 0x31e },
	'linearizationtable' => { 119 => 0xc618 },
	'linearresponselimit' => { 119 => 0xc62e },
	'link' => { 493 => 'link' },
	'linkaetoafpoint' => { 336 => '14.2' },
	'linkedencodedrightsexpr' => { 489 => [\'LinkedEncRightsExpr','LinkedEncRightsExprLinkedRightsExpr'] },
	'linkedencodedrightsexprlangid' => { 489 => [\'LinkedEncRightsExpr','LinkedEncRightsExprRightsExprLangId'] },
	'linkedencodedrightsexprtype' => { 489 => [\'LinkedEncRightsExpr','LinkedEncRightsExprRightsExprEncType'] },
	'linkedencrightsexpr' => { 489 => 'LinkedEncRightsExpr' },
	'linlogcoring' => { 138 => 0x904 },
	'lithostratigraphicterms' => { 118 => [\'GeologicalContext','GeologicalContextLithostratigraphicTerms'] },
	'livephotoauto' => { 374 => 'live-photo.auto' },
	'livephotovitalityscore' => { 374 => 'live-photo.vitality-score' },
	'livephotovitalityscoringversion' => { 374 => 'live-photo.vitality-scoring-version' },
	'liveviewaf' => { 284 => '32.1', 294 => '34.1' },
	'liveviewafareamode' => { 289 => '34.1' },
	'liveviewafmethod' => { 425 => 0x20 },
	'liveviewafmode' => { 289 => '34.2' },
	'liveviewafsetting' => { 409 => 0x36 },
	'liveviewbuttonoptions' => { 280 => '50.2', 282 => '48.2', 283 => '48.2', 292 => '48.2', 293 => '48.2' },
	'liveviewexposuresimulation' => { 84 => 0x810 },
	'liveviewfocusmode' => { 409 => [0x8b,0x28b] },
	'liveviewmetering' => { 409 => [0x84,0x284] },
	'liveviewmonitorofftime' => { 280 => '21.2', 282 => '21.2', 283 => '21.2', 285 => '20.2', 286 => '20.2', 287 => '20.2', 289 => '20.2', 292 => '21.2', 293 => '21.2' },
	'liveviewshooting' => { 57 => 0x13 },
	'livingspecimen' => { 118 => 'LivingSpecimen' },
	'livingspecimenmaterialsampleid' => { 118 => [\'LivingSpecimen','LivingSpecimenMaterialSampleID'] },
	'localcaption' => { 131 => 0x79 },
	'localizedcameramodel' => { 119 => 0xc615 },
	'locallocationname' => { 394 => 0x30 },
	'location' => { 225 => 0x9, 320 => 0x67, 470 => 'Location', 488 => 'Location', 492 => 'location', 493 => 'location' },
	'locationaccuracyhorizontal' => { 374 => 'location.accuracy.horizontal' },
	'locationareacode' => { 476 => 'lac' },
	'locationbody' => { 374 => 'location.body' },
	'locationcreated' => { 489 => 'LocationCreated' },
	'locationcreatedcity' => { 489 => [\'LocationCreated','LocationCreatedCity'] },
	'locationcreatedcountrycode' => { 489 => [\'LocationCreated','LocationCreatedCountryCode'] },
	'locationcreatedcountryname' => { 489 => [\'LocationCreated','LocationCreatedCountryName'] },
	'locationcreatedgpsaltitude' => { 489 => [\'LocationCreated','LocationCreatedGPSAltitude'] },
	'locationcreatedgpslatitude' => { 489 => [\'LocationCreated','LocationCreatedGPSLatitude'] },
	'locationcreatedgpslongitude' => { 489 => [\'LocationCreated','LocationCreatedGPSLongitude'] },
	'locationcreatedidentifier' => { 489 => [\'LocationCreated','LocationCreatedIdentifier'] },
	'locationcreatedlocationid' => { 489 => [\'LocationCreated','LocationCreatedLocationId'] },
	'locationcreatedlocationname' => { 489 => [\'LocationCreated','LocationCreatedLocationName'] },
	'locationcreatedprovincestate' => { 489 => [\'LocationCreated','LocationCreatedProvinceState'] },
	'locationcreatedsublocation' => { 489 => [\'LocationCreated','LocationCreatedSublocation'] },
	'locationcreatedworldregion' => { 489 => [\'LocationCreated','LocationCreatedWorldRegion'] },
	'locationdate' => { 374 => 'location.date' },
	'locationinformation' => { 380 => 'loci' },
	'locationinfoversion' => { 225 => 0x0 },
	'locationname' => { 374 => 'location.name', 394 => 0x31 },
	'locationnote' => { 374 => 'location.note' },
	'locationrole' => { 374 => 'location.role' },
	'locationshown' => { 489 => 'LocationShown' },
	'locationshowncity' => { 489 => [\'LocationShown','LocationShownCity'] },
	'locationshowncountrycode' => { 489 => [\'LocationShown','LocationShownCountryCode'] },
	'locationshowncountryname' => { 489 => [\'LocationShown','LocationShownCountryName'] },
	'locationshowngpsaltitude' => { 489 => [\'LocationShown','LocationShownGPSAltitude'] },
	'locationshowngpslatitude' => { 489 => [\'LocationShown','LocationShownGPSLatitude'] },
	'locationshowngpslongitude' => { 489 => [\'LocationShown','LocationShownGPSLongitude'] },
	'locationshownidentifier' => { 489 => [\'LocationShown','LocationShownIdentifier'] },
	'locationshownlocationid' => { 489 => [\'LocationShown','LocationShownLocationId'] },
	'locationshownlocationname' => { 489 => [\'LocationShown','LocationShownLocationName'] },
	'locationshownprovincestate' => { 489 => [\'LocationShown','LocationShownProvinceState'] },
	'locationshownsublocation' => { 489 => [\'LocationShown','LocationShownSublocation'] },
	'locationshownworldregion' => { 489 => [\'LocationShown','LocationShownWorldRegion'] },
	'lockmicrophonebutton' => { 84 => 0x709 },
	'logcomment' => { 503 => 'logComment' },
	'logscale' => { 138 => 0x902 },
	'longdescription' => { 372 => 'ldes' },
	'longexposurenoisereduction' => { 62 => 0x4, 84 => 0x201, 85 => 0x1, 86 => 0x2, 87 => 0x1, 88 => 0x1, 89 => 0x2, 90 => 0x1, 320 => 0x49, 407 => 0x2b, 408 => 0x25, 409 => 0x25, 420 => 0x2008, 425 => 0x11, 450 => 0x44 },
	'longexposurenoisereduction2' => { 57 => 0x8 },
	'longexposurenrused' => { 320 => 0xbe },
	'longitude' => { 116 => 'Longitude' },
	'look' => { 477 => 'Look', 479 => 'Look' },
	'lookamount' => { 477 => [\'Look','LookAmount'], 479 => [\'Look','LookAmount'] },
	'lookcluster' => { 477 => [\'Look','LookCluster'], 479 => [\'Look','LookCluster'] },
	'lookcopyright' => { 477 => [\'Look','LookCopyright'], 479 => [\'Look','LookCopyright'] },
	'lookgroup' => { 477 => [\'Look','LookGroup'], 479 => [\'Look','LookGroup'] },
	'lookname' => { 477 => 'LookName', 479 => 'LookName' },
	'lookparameters' => { 477 => [\'Look','LookParameters'], 479 => [\'Look','LookParameters'] },
	'lookparameterscameraprofile' => { 477 => [\'Look','LookParametersCameraProfile'], 479 => [\'Look','LookParametersCameraProfile'] },
	'lookparametersclarity2012' => { 477 => [\'Look','LookParametersClarity2012'], 479 => [\'Look','LookParametersClarity2012'] },
	'lookparametersconverttograyscale' => { 477 => [\'Look','LookParametersConvertToGrayscale'], 479 => [\'Look','LookParametersConvertToGrayscale'] },
	'lookparameterslooktable' => { 477 => [\'Look','LookParametersLookTable'], 479 => [\'Look','LookParametersLookTable'] },
	'lookparametersprocessversion' => { 477 => [\'Look','LookParametersProcessVersion'], 479 => [\'Look','LookParametersProcessVersion'] },
	'lookparameterstonecurvepv2012' => { 477 => [\'Look','LookParametersToneCurvePV2012'], 479 => [\'Look','LookParametersToneCurvePV2012'] },
	'lookparameterstonecurvepv2012blue' => { 477 => [\'Look','LookParametersToneCurvePV2012Blue'], 479 => [\'Look','LookParametersToneCurvePV2012Blue'] },
	'lookparameterstonecurvepv2012green' => { 477 => [\'Look','LookParametersToneCurvePV2012Green'], 479 => [\'Look','LookParametersToneCurvePV2012Green'] },
	'lookparameterstonecurvepv2012red' => { 477 => [\'Look','LookParametersToneCurvePV2012Red'], 479 => [\'Look','LookParametersToneCurvePV2012Red'] },
	'lookparametersversion' => { 477 => [\'Look','LookParametersVersion'], 479 => [\'Look','LookParametersVersion'] },
	'looksupportsamount' => { 477 => [\'Look','LookSupportsAmount'], 479 => [\'Look','LookSupportsAmount'] },
	'looksupportsmonochrome' => { 477 => [\'Look','LookSupportsMonochrome'], 479 => [\'Look','LookSupportsMonochrome'] },
	'looksupportsoutputreferred' => { 477 => [\'Look','LookSupportsOutputReferred'], 479 => [\'Look','LookSupportsOutputReferred'] },
	'lookuuid' => { 477 => [\'Look','LookUUID'], 479 => [\'Look','LookUUID'] },
	'loop' => { 503 => 'loop' },
	'loopstyle' => { 380 => 'LOOP' },
	'lowestbiostratigraphiczone' => { 118 => [\'GeologicalContext','GeologicalContextLowestBiostratigraphicZone'] },
	'luminanceadjustmentaqua' => { 477 => 'LuminanceAdjustmentAqua', 479 => 'LuminanceAdjustmentAqua' },
	'luminanceadjustmentblue' => { 477 => 'LuminanceAdjustmentBlue', 479 => 'LuminanceAdjustmentBlue' },
	'luminanceadjustmentgreen' => { 477 => 'LuminanceAdjustmentGreen', 479 => 'LuminanceAdjustmentGreen' },
	'luminanceadjustmentmagenta' => { 477 => 'LuminanceAdjustmentMagenta', 479 => 'LuminanceAdjustmentMagenta' },
	'luminanceadjustmentorange' => { 477 => 'LuminanceAdjustmentOrange', 479 => 'LuminanceAdjustmentOrange' },
	'luminanceadjustmentpurple' => { 477 => 'LuminanceAdjustmentPurple', 479 => 'LuminanceAdjustmentPurple' },
	'luminanceadjustmentred' => { 477 => 'LuminanceAdjustmentRed', 479 => 'LuminanceAdjustmentRed' },
	'luminanceadjustmentyellow' => { 477 => 'LuminanceAdjustmentYellow', 479 => 'LuminanceAdjustmentYellow' },
	'luminancecurvelimits' => { 108 => 0x150 },
	'luminancecurvepoints' => { 108 => 0x126 },
	'luminancenoisereduction' => { 103 => 0x20600, 109 => 0x5f, 397 => 0x1b },
	'luminancenoisereductioncontrast' => { 477 => 'LuminanceNoiseReductionContrast', 479 => 'LuminanceNoiseReductionContrast' },
	'luminancenoisereductiondetail' => { 477 => 'LuminanceNoiseReductionDetail', 479 => 'LuminanceNoiseReductionDetail' },
	'luminancenr_tiff_jpeg' => { 109 => 0x6d },
	'luminancesmoothing' => { 477 => 'LuminanceSmoothing', 479 => 'LuminanceSmoothing' },
	'lvshootingareadisplay' => { 84 => [0x40b,0x40c] },
	'lyrics' => { 372 => "\xa9lyr", 380 => "\xa9lyr", 503 => 'lyrics' },
	'lyricsuri' => { 380 => 'lrcu' },
	'm16cversion' => { 315 => 0x333 },
	'macatom' => { 478 => 'macAtom' },
	'macatomapplicationcode' => { 478 => [\'macAtom','macAtomApplicationCode'] },
	'macatominvocationappleevent' => { 478 => [\'macAtom','macAtomInvocationAppleEvent'] },
	'macatomposixprojectpath' => { 478 => [\'macAtom','macAtomPosixProjectPath'] },
	'machineobservation' => { 118 => 'MachineObservation' },
	'machineobservationday' => { 118 => [\'MachineObservation','MachineObservationDay'] },
	'machineobservationearliestdate' => { 118 => [\'MachineObservation','MachineObservationEarliestDate'] },
	'machineobservationenddayofyear' => { 118 => [\'MachineObservation','MachineObservationEndDayOfYear'] },
	'machineobservationeventdate' => { 118 => [\'MachineObservation','MachineObservationEventDate'] },
	'machineobservationeventid' => { 118 => [\'MachineObservation','MachineObservationEventID'] },
	'machineobservationeventremarks' => { 118 => [\'MachineObservation','MachineObservationEventRemarks'] },
	'machineobservationeventtime' => { 118 => [\'MachineObservation','MachineObservationEventTime'] },
	'machineobservationfieldnotes' => { 118 => [\'MachineObservation','MachineObservationFieldNotes'] },
	'machineobservationfieldnumber' => { 118 => [\'MachineObservation','MachineObservationFieldNumber'] },
	'machineobservationhabitat' => { 118 => [\'MachineObservation','MachineObservationHabitat'] },
	'machineobservationlatestdate' => { 118 => [\'MachineObservation','MachineObservationLatestDate'] },
	'machineobservationmonth' => { 118 => [\'MachineObservation','MachineObservationMonth'] },
	'machineobservationparenteventid' => { 118 => [\'MachineObservation','MachineObservationParentEventID'] },
	'machineobservationsamplesizeunit' => { 118 => [\'MachineObservation','MachineObservationSampleSizeUnit'] },
	'machineobservationsamplesizevalue' => { 118 => [\'MachineObservation','MachineObservationSampleSizeValue'] },
	'machineobservationsamplingeffort' => { 118 => [\'MachineObservation','MachineObservationSamplingEffort'] },
	'machineobservationsamplingprotocol' => { 118 => [\'MachineObservation','MachineObservationSamplingProtocol'] },
	'machineobservationstartdayofyear' => { 118 => [\'MachineObservation','MachineObservationStartDayOfYear'] },
	'machineobservationverbatimeventdate' => { 118 => [\'MachineObservation','MachineObservationVerbatimEventDate'] },
	'machineobservationyear' => { 118 => [\'MachineObservation','MachineObservationYear'] },
	'macro' => { 127 => 0x1020, 129 => 0x202, 151 => 0x2b, 302 => 0x202, 386 => 0x21, 396 => 0x202, 420 => 0xb040 },
	'macroled' => { 300 => 0x120a },
	'macromagnification' => { 7 => 0x1b, 11 => 0x1b, 14 => 0x1b, 15 => 0x1b, 19 => 0x1b, 20 => 0x1b, 57 => 0x10 },
	'macromode' => { 34 => 0x1, 181 => 0xb, 297 => 0x300, 320 => 0x1c, 387 => 0x1009 },
	'magentahsl' => { 103 => 0x20917 },
	'magicfilter' => { 297 => 0x52c },
	'magnifiedview' => { 86 => 0x11, 88 => 0x9 },
	'mainboardversion' => { 138 => 0x438 },
	'maindialexposurecomp' => { 290 => '0.6' },
	'mainingredient' => { 495 => 'mainIngredient' },
	'majorversion' => { 468 => 'MajorVersion' },
	'make' => { 98 => 0x0, 115 => 0x1, 119 => 0x10f, 156 => 'Make', 310 => 'Make', 325 => 0x10f, 374 => 'make', 380 => ['@mak',"\xa9mak"], 492 => 'make', 499 => 'Make' },
	'makernote' => { 483 => 'MakerNote' },
	'makernoteapple' => { 117 => 'MakN', 119 => 0x927c },
	'makernotecanon' => { 117 => 'MakN', 119 => 0x927c },
	'makernotecasio' => { 117 => 'MakN', 119 => 0x927c },
	'makernotecasio2' => { 117 => 'MakN', 119 => 0x927c },
	'makernotedji' => { 117 => 'MakN', 119 => 0x927c },
	'makernoteflir' => { 117 => 'MakN', 119 => 0x927c },
	'makernotefujifilm' => { 117 => 'MakN', 119 => 0x927c },
	'makernotege' => { 117 => 'MakN', 119 => 0x927c },
	'makernotege2' => { 117 => 'MakN', 119 => 0x927c },
	'makernotehasselblad' => { 117 => 'MakN', 119 => 0x927c },
	'makernotehp' => { 117 => 'MakN', 119 => 0x927c },
	'makernotehp2' => { 117 => 'MakN', 119 => 0x927c },
	'makernotehp4' => { 117 => 'MakN', 119 => 0x927c },
	'makernotehp6' => { 117 => 'MakN', 119 => 0x927c },
	'makernoteisl' => { 117 => 'MakN', 119 => 0x927c },
	'makernotejvc' => { 117 => 'MakN', 119 => 0x927c },
	'makernotejvctext' => { 117 => 'MakN', 119 => 0x927c },
	'makernotekodak10' => { 117 => 'MakN', 119 => 0x927c },
	'makernotekodak11' => { 117 => 'MakN', 119 => 0x927c },
	'makernotekodak12' => { 117 => 'MakN', 119 => 0x927c },
	'makernotekodak1a' => { 117 => 'MakN', 119 => 0x927c },
	'makernotekodak1b' => { 117 => 'MakN', 119 => 0x927c },
	'makernotekodak2' => { 117 => 'MakN', 119 => 0x927c },
	'makernotekodak3' => { 117 => 'MakN', 119 => 0x927c },
	'makernotekodak4' => { 117 => 'MakN', 119 => 0x927c },
	'makernotekodak5' => { 117 => 'MakN', 119 => 0x927c },
	'makernotekodak6a' => { 117 => 'MakN', 119 => 0x927c },
	'makernotekodak6b' => { 117 => 'MakN', 119 => 0x927c },
	'makernotekodak7' => { 117 => 'MakN', 119 => 0x927c },
	'makernotekodak8a' => { 117 => 'MakN', 119 => 0x927c },
	'makernotekodak8b' => { 117 => 'MakN', 119 => 0x927c },
	'makernotekodak8c' => { 117 => 'MakN', 119 => 0x927c },
	'makernotekodak9' => { 117 => 'MakN', 119 => 0x927c },
	'makernotekodakunknown' => { 117 => 'MakN', 119 => 0x927c },
	'makernotekyocera' => { 117 => 'MakN', 119 => 0x927c },
	'makernoteleica' => { 117 => 'MakN', 119 => 0x927c },
	'makernoteleica10' => { 117 => 'MakN', 119 => 0x927c },
	'makernoteleica2' => { 117 => 'MakN', 119 => 0x927c },
	'makernoteleica3' => { 117 => 'MakN', 119 => 0x927c },
	'makernoteleica4' => { 117 => 'MakN', 119 => 0x927c },
	'makernoteleica5' => { 117 => 'MakN', 119 => 0x927c },
	'makernoteleica6' => { 117 => 'MakN', 119 => 0x927c },
	'makernoteleica7' => { 117 => 'MakN', 119 => 0x927c },
	'makernoteleica8' => { 117 => 'MakN', 119 => 0x927c },
	'makernoteleica9' => { 117 => 'MakN', 119 => 0x927c },
	'makernoteminolta' => { 117 => 'MakN', 119 => 0x927c },
	'makernoteminolta2' => { 117 => 'MakN', 119 => 0x927c },
	'makernoteminolta3' => { 117 => 'MakN', 119 => 0x927c },
	'makernotemotorola' => { 117 => 'MakN', 119 => 0x927c },
	'makernotenikon' => { 117 => 'MakN', 119 => 0x927c },
	'makernotenikon2' => { 117 => 'MakN', 119 => 0x927c },
	'makernotenikon3' => { 117 => 'MakN', 119 => 0x927c },
	'makernotenintendo' => { 117 => 'MakN', 119 => 0x927c },
	'makernoteoffset' => { 396 => 0xff },
	'makernoteolympus' => { 117 => 'MakN', 119 => 0x927c },
	'makernoteolympus2' => { 117 => 'MakN', 119 => 0x927c },
	'makernotepanasonic' => { 117 => 'MakN', 119 => 0x927c },
	'makernotepanasonic2' => { 117 => 'MakN', 119 => 0x927c },
	'makernotepanasonic3' => { 117 => 'MakN', 119 => 0x927c },
	'makernotepentax' => { 117 => 'MakN', 119 => 0x927c },
	'makernotepentax2' => { 117 => 'MakN', 119 => 0x927c },
	'makernotepentax3' => { 117 => 'MakN', 119 => 0x927c },
	'makernotepentax4' => { 117 => 'MakN', 119 => 0x927c },
	'makernotepentax5' => { 117 => 'MakN', 119 => 0x927c },
	'makernotepentax6' => { 117 => 'MakN', 119 => 0x927c },
	'makernotepentaxunknown' => { 380 => 'PXMN' },
	'makernotephaseone' => { 117 => 'MakN', 119 => 0x927c },
	'makernotereconyx' => { 117 => 'MakN', 119 => 0x927c },
	'makernotereconyx2' => { 117 => 'MakN', 119 => 0x927c },
	'makernotereconyx3' => { 117 => 'MakN', 119 => 0x927c },
	'makernotericoh' => { 117 => 'MakN', 119 => 0x927c },
	'makernotericoh2' => { 117 => 'MakN', 119 => 0x927c },
	'makernotericohpentax' => { 117 => 'MakN', 119 => 0x927c },
	'makernotericohtext' => { 117 => 'MakN', 119 => 0x927c },
	'makernotesafety' => { 119 => 0xc635 },
	'makernotesamsung1a' => { 117 => 'MakN', 119 => 0x927c },
	'makernotesamsung1b' => { 117 => 'MakN', 119 => 0x927c },
	'makernotesamsung2' => { 117 => 'MakN', 119 => 0x927c },
	'makernotesanyo' => { 117 => 'MakN', 119 => 0x927c },
	'makernotesanyoc4' => { 117 => 'MakN', 119 => 0x927c },
	'makernotesanyopatch' => { 117 => 'MakN', 119 => 0x927c },
	'makernotesigma' => { 117 => 'MakN', 119 => 0x927c },
	'makernotesony' => { 117 => 'MakN', 119 => 0x927c },
	'makernotesony2' => { 117 => 'MakN', 119 => 0x927c },
	'makernotesony3' => { 117 => 'MakN', 119 => 0x927c },
	'makernotesony4' => { 117 => 'MakN', 119 => 0x927c },
	'makernotesony5' => { 117 => 'MakN', 119 => 0x927c },
	'makernotesonyericsson' => { 117 => 'MakN', 119 => 0x927c },
	'makernotesonysrf' => { 117 => 'MakN', 119 => 0x927c },
	'makernotetype' => { 387 => 0x1 },
	'makernoteunknown' => { 117 => 'MakN', 119 => 0x927c },
	'makernoteunknownbinary' => { 117 => 'MakN', 119 => 0x927c },
	'makernoteunknowntext' => { 117 => 'MakN', 119 => 0x927c },
	'makernoteversion' => { 186 => 0x0, 226 => 0x1, 302 => 0x0, 320 => 0x8000, 391 => 0x0, 394 => 0x1, 397 => [0x1d,0x1f], 410 => 0x2000 },
	'makerurl' => { 380 => "\xa9mal" },
	'managedfrom' => { 504 => 'ManagedFrom' },
	'managedfromalternatepaths' => { 504 => [\'ManagedFrom','ManagedFromAlternatePaths'] },
	'managedfromdocumentid' => { 504 => [\'ManagedFrom','ManagedFromDocumentID'] },
	'managedfromfilepath' => { 504 => [\'ManagedFrom','ManagedFromFilePath'] },
	'managedfromfrompart' => { 504 => [\'ManagedFrom','ManagedFromFromPart'] },
	'managedfrominstanceid' => { 504 => [\'ManagedFrom','ManagedFromInstanceID'] },
	'managedfromlastmodifydate' => { 504 => [\'ManagedFrom','ManagedFromLastModifyDate'] },
	'managedfromlasturl' => { 504 => [\'ManagedFrom','ManagedFromLastURL'] },
	'managedfromlinkcategory' => { 504 => [\'ManagedFrom','ManagedFromLinkCategory'] },
	'managedfromlinkform' => { 504 => [\'ManagedFrom','ManagedFromLinkForm'] },
	'managedfrommanager' => { 504 => [\'ManagedFrom','ManagedFromManager'] },
	'managedfrommanagervariant' => { 504 => [\'ManagedFrom','ManagedFromManagerVariant'] },
	'managedfrommanageto' => { 504 => [\'ManagedFrom','ManagedFromManageTo'] },
	'managedfrommanageui' => { 504 => [\'ManagedFrom','ManagedFromManageUI'] },
	'managedfrommaskmarkers' => { 504 => [\'ManagedFrom','ManagedFromMaskMarkers'] },
	'managedfromoriginaldocumentid' => { 504 => [\'ManagedFrom','ManagedFromOriginalDocumentID'] },
	'managedfrompartmapping' => { 504 => [\'ManagedFrom','ManagedFromPartMapping'] },
	'managedfromplacedresolutionunit' => { 504 => [\'ManagedFrom','ManagedFromPlacedResolutionUnit'] },
	'managedfromplacedxresolution' => { 504 => [\'ManagedFrom','ManagedFromPlacedXResolution'] },
	'managedfromplacedyresolution' => { 504 => [\'ManagedFrom','ManagedFromPlacedYResolution'] },
	'managedfromrenditionclass' => { 504 => [\'ManagedFrom','ManagedFromRenditionClass'] },
	'managedfromrenditionparams' => { 504 => [\'ManagedFrom','ManagedFromRenditionParams'] },
	'managedfromtopart' => { 504 => [\'ManagedFrom','ManagedFromToPart'] },
	'managedfromversionid' => { 504 => [\'ManagedFrom','ManagedFromVersionID'] },
	'manager' => { 504 => 'Manager' },
	'managervariant' => { 504 => 'ManagerVariant' },
	'manageto' => { 504 => 'ManageTo' },
	'manageui' => { 504 => 'ManageUI' },
	'manifest' => { 504 => 'Manifest' },
	'manifestlinkform' => { 504 => [\'Manifest','ManifestLinkForm'] },
	'manifestplacedresolutionunit' => { 504 => [\'Manifest','ManifestPlacedResolutionUnit'] },
	'manifestplacedxresolution' => { 504 => [\'Manifest','ManifestPlacedXResolution'] },
	'manifestplacedyresolution' => { 504 => [\'Manifest','ManifestPlacedYResolution'] },
	'manifestreference' => { 504 => [\'Manifest','ManifestReference'] },
	'manifestreferencealternatepaths' => { 504 => [\'Manifest','ManifestReferenceAlternatePaths'] },
	'manifestreferencedocumentid' => { 504 => [\'Manifest','ManifestReferenceDocumentID'] },
	'manifestreferencefilepath' => { 504 => [\'Manifest','ManifestReferenceFilePath'] },
	'manifestreferencefrompart' => { 504 => [\'Manifest','ManifestReferenceFromPart'] },
	'manifestreferenceinstanceid' => { 504 => [\'Manifest','ManifestReferenceInstanceID'] },
	'manifestreferencelastmodifydate' => { 504 => [\'Manifest','ManifestReferenceLastModifyDate'] },
	'manifestreferencelasturl' => { 504 => [\'Manifest','ManifestReferenceLastURL'] },
	'manifestreferencelinkcategory' => { 504 => [\'Manifest','ManifestReferenceLinkCategory'] },
	'manifestreferencelinkform' => { 504 => [\'Manifest','ManifestReferenceLinkForm'] },
	'manifestreferencemanager' => { 504 => [\'Manifest','ManifestReferenceManager'] },
	'manifestreferencemanagervariant' => { 504 => [\'Manifest','ManifestReferenceManagerVariant'] },
	'manifestreferencemanageto' => { 504 => [\'Manifest','ManifestReferenceManageTo'] },
	'manifestreferencemanageui' => { 504 => [\'Manifest','ManifestReferenceManageUI'] },
	'manifestreferencemaskmarkers' => { 504 => [\'Manifest','ManifestReferenceMaskMarkers'] },
	'manifestreferenceoriginaldocumentid' => { 504 => [\'Manifest','ManifestReferenceOriginalDocumentID'] },
	'manifestreferencepartmapping' => { 504 => [\'Manifest','ManifestReferencePartMapping'] },
	'manifestreferenceplacedresolutionunit' => { 504 => [\'Manifest','ManifestReferencePlacedResolutionUnit'] },
	'manifestreferenceplacedxresolution' => { 504 => [\'Manifest','ManifestReferencePlacedXResolution'] },
	'manifestreferenceplacedyresolution' => { 504 => [\'Manifest','ManifestReferencePlacedYResolution'] },
	'manifestreferencerenditionclass' => { 504 => [\'Manifest','ManifestReferenceRenditionClass'] },
	'manifestreferencerenditionparams' => { 504 => [\'Manifest','ManifestReferenceRenditionParams'] },
	'manifestreferencetopart' => { 504 => [\'Manifest','ManifestReferenceToPart'] },
	'manifestreferenceversionid' => { 504 => [\'Manifest','ManifestReferenceVersionID'] },
	'manometerpressure' => { 297 => 0x900, 320 => 0x86 },
	'manometerreading' => { 297 => 0x901 },
	'manualafpointselectpattern' => { 84 => 0x513 },
	'manualafpointselpattern' => { 2 => 0xf },
	'manualflash' => { 300 => 0x1209 },
	'manualflashoutput' => { 34 => 0x29, 281 => '8.2', 284 => '22.2', 285 => '23.1', 286 => '23.2', 288 => '16.2', 289 => '23.2', 290 => '8.2', 291 => '23.2', 294 => '24.2', 387 => 0x100c },
	'manualflashstrength' => { 297 => 0x406 },
	'manualfocusdistance' => { 226 => 0x85, 302 => 0x100c, 396 => 0x223 },
	'manualfocuspointillumination' => { 295 => 0x17 },
	'manualfocusringinafmode' => { 295 => 0x1a },
	'manualtv' => { 83 => 0x5, 84 => 0x705 },
	'manufacturedate' => { 191 => 0x6705, 335 => 0x1 },
	'manufacturedate1' => { 389 => 0x4 },
	'manufacturedate2' => { 389 => 0x5 },
	'manufacturer' => { 462 => 'Manufacturer', 492 => 'manufacturer' },
	'mariahchromablursize' => { 138 => 0xf0d },
	'mariahmaphithreshold' => { 138 => 0xf0c },
	'mariahmaplothreshold' => { 138 => 0xf0b },
	'mariahsigmathreshold' => { 138 => 0xf0e },
	'mariahtexturethreshold' => { 138 => 0xf0a },
	'marked' => { 490 => 'Marked', 507 => 'Marked' },
	'markers' => { 503 => 'markers' },
	'markerscomment' => { 503 => [\'markers','markersComment'] },
	'markerscuepointparams' => { 503 => [\'markers','markersCuePointParams'] },
	'markerscuepointparamskey' => { 503 => [\'markers','markersCuePointParamsKey'] },
	'markerscuepointparamsvalue' => { 503 => [\'markers','markersCuePointParamsValue'] },
	'markerscuepointtype' => { 503 => [\'markers','markersCuePointType'] },
	'markersduration' => { 503 => [\'markers','markersDuration'] },
	'markerslocation' => { 503 => [\'markers','markersLocation'] },
	'markersname' => { 503 => [\'markers','markersName'] },
	'markersprobability' => { 503 => [\'markers','markersProbability'] },
	'markersspeaker' => { 503 => [\'markers','markersSpeaker'] },
	'markersstarttime' => { 503 => [\'markers','markersStartTime'] },
	'markerstarget' => { 503 => [\'markers','markersTarget'] },
	'markerstype' => { 503 => [\'markers','markersType'] },
	'maskedareas' => { 119 => 0xc68e },
	'maskgroupbasedcorractive' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionActive'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionActive'] },
	'maskgroupbasedcorramount' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionAmount'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionAmount'] },
	'maskgroupbasedcorrblacks2012' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalBlacks2012'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalBlacks2012'] },
	'maskgroupbasedcorrbrightness' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalBrightness'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalBrightness'] },
	'maskgroupbasedcorrclarity' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalClarity'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalClarity'] },
	'maskgroupbasedcorrclarity2012' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalClarity2012'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalClarity2012'] },
	'maskgroupbasedcorrcontrast' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalContrast'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalContrast'] },
	'maskgroupbasedcorrcontrast2012' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalContrast2012'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalContrast2012'] },
	'maskgroupbasedcorrcorrectionname' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionName'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionName'] },
	'maskgroupbasedcorrcorrectionsyncid' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionSyncID'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionSyncID'] },
	'maskgroupbasedcorrdefringe' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalDefringe'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalDefringe'] },
	'maskgroupbasedcorrdehaze' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalDehaze'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalDehaze'] },
	'maskgroupbasedcorrections' => { 477 => 'MaskGroupBasedCorrections', 479 => 'MaskGroupBasedCorrections' },
	'maskgroupbasedcorrexposure' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalExposure'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalExposure'] },
	'maskgroupbasedcorrexposure2012' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalExposure2012'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalExposure2012'] },
	'maskgroupbasedcorrhighlights2012' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalHighlights2012'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalHighlights2012'] },
	'maskgroupbasedcorrhue' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalHue'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalHue'] },
	'maskgroupbasedcorrluminancenoise' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalLuminanceNoise'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalLuminanceNoise'] },
	'maskgroupbasedcorrmask' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasks'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasks'] },
	'maskgroupbasedcorrmaskalpha' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksAlpha'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksAlpha'] },
	'maskgroupbasedcorrmaskangle' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksAngle'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksAngle'] },
	'maskgroupbasedcorrmaskbottom' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksBottom'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksBottom'] },
	'maskgroupbasedcorrmaskcentervalue' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCenterValue'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCenterValue'] },
	'maskgroupbasedcorrmaskcenterweight' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCenterWeight'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCenterWeight'] },
	'maskgroupbasedcorrmaskdabs' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksDabs'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksDabs'] },
	'maskgroupbasedcorrmaskfeather' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFeather'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFeather'] },
	'maskgroupbasedcorrmaskflipped' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFlipped'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFlipped'] },
	'maskgroupbasedcorrmaskflow' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFlow'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFlow'] },
	'maskgroupbasedcorrmaskfullx' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFullX'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFullX'] },
	'maskgroupbasedcorrmaskfully' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFullY'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFullY'] },
	'maskgroupbasedcorrmaskinputdigest' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksInputDigest'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksInputDigest'] },
	'maskgroupbasedcorrmaskleft' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksLeft'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksLeft'] },
	'maskgroupbasedcorrmaskmaskactive' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskActive'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskActive'] },
	'maskgroupbasedcorrmaskmaskblendmode' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskBlendMode'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskBlendMode'] },
	'maskgroupbasedcorrmaskmaskdigest' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskDigest'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskDigest'] },
	'maskgroupbasedcorrmaskmaskinverted' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskInverted'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskInverted'] },
	'maskgroupbasedcorrmaskmaskname' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskName'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskName'] },
	'maskgroupbasedcorrmaskmasks' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasks'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasks'] },
	'maskgroupbasedcorrmaskmasksalpha' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksAlpha'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksAlpha'] },
	'maskgroupbasedcorrmaskmasksangle' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksAngle'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksAngle'] },
	'maskgroupbasedcorrmaskmasksbottom' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksBottom'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksBottom'] },
	'maskgroupbasedcorrmaskmaskscentervalue' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksCenterValue'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksCenterValue'] },
	'maskgroupbasedcorrmaskmaskscenterweight' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksCenterWeight'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksCenterWeight'] },
	'maskgroupbasedcorrmaskmasksdabs' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksDabs'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksDabs'] },
	'maskgroupbasedcorrmaskmasksfeather' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFeather'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFeather'] },
	'maskgroupbasedcorrmaskmasksflipped' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFlipped'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFlipped'] },
	'maskgroupbasedcorrmaskmasksflow' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFlow'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFlow'] },
	'maskgroupbasedcorrmaskmasksfullx' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFullX'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFullX'] },
	'maskgroupbasedcorrmaskmasksfully' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFullY'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFullY'] },
	'maskgroupbasedcorrmaskmasksinputdigest' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksInputDigest'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksInputDigest'] },
	'maskgroupbasedcorrmaskmasksleft' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksLeft'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksLeft'] },
	'maskgroupbasedcorrmaskmasksmaskactive' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskActive'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskActive'] },
	'maskgroupbasedcorrmaskmasksmaskblendmode' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskBlendMode'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskBlendMode'] },
	'maskgroupbasedcorrmaskmasksmaskdigest' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskDigest'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskDigest'] },
	'maskgroupbasedcorrmaskmasksmaskinverted' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskInverted'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskInverted'] },
	'maskgroupbasedcorrmaskmasksmaskname' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskName'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskName'] },
	'maskgroupbasedcorrmaskmasksmasksubtype' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskSubType'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskSubType'] },
	'maskgroupbasedcorrmaskmasksmasksyncid' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskSyncID'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskSyncID'] },
	'maskgroupbasedcorrmaskmasksmaskversion' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskVersion'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskVersion'] },
	'maskgroupbasedcorrmaskmasksmidpoint' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMidpoint'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMidpoint'] },
	'maskgroupbasedcorrmaskmasksorigin' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksOrigin'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksOrigin'] },
	'maskgroupbasedcorrmaskmasksperimetervalue' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksPerimeterValue'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksPerimeterValue'] },
	'maskgroupbasedcorrmaskmasksradius' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksRadius'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksRadius'] },
	'maskgroupbasedcorrmaskmasksreferencepoint' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksReferencePoint'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksReferencePoint'] },
	'maskgroupbasedcorrmaskmasksright' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksRight'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksRight'] },
	'maskgroupbasedcorrmaskmasksroundness' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksRoundness'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksRoundness'] },
	'maskgroupbasedcorrmaskmaskssizex' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksSizeX'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksSizeX'] },
	'maskgroupbasedcorrmaskmaskssizey' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksSizeY'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksSizeY'] },
	'maskgroupbasedcorrmaskmaskstop' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksTop'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksTop'] },
	'maskgroupbasedcorrmaskmasksubtype' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskSubType'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskSubType'] },
	'maskgroupbasedcorrmaskmasksvalue' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskValue'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskValue'] },
	'maskgroupbasedcorrmaskmasksversion' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksVersion'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksVersion'] },
	'maskgroupbasedcorrmaskmaskswhat' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksWhat'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksWhat'] },
	'maskgroupbasedcorrmaskmaskswholeimagearea' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksWholeImageArea'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksWholeImageArea'] },
	'maskgroupbasedcorrmaskmasksx' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksX'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksX'] },
	'maskgroupbasedcorrmaskmasksy' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksY'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksY'] },
	'maskgroupbasedcorrmaskmasksyncid' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskSyncID'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskSyncID'] },
	'maskgroupbasedcorrmaskmaskszerox' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksZeroX'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksZeroX'] },
	'maskgroupbasedcorrmaskmaskszeroy' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksZeroY'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksZeroY'] },
	'maskgroupbasedcorrmaskmaskversion' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskVersion'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskVersion'] },
	'maskgroupbasedcorrmaskmidpoint' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMidpoint'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMidpoint'] },
	'maskgroupbasedcorrmaskorigin' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksOrigin'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksOrigin'] },
	'maskgroupbasedcorrmaskperimetervalue' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksPerimeterValue'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'maskgroupbasedcorrmaskradius' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksRadius'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksRadius'] },
	'maskgroupbasedcorrmaskrange' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMask'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMask'] },
	'maskgroupbasedcorrmaskrangeareamodels' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'] },
	'maskgroupbasedcorrmaskrangeareamodelscolorsampleinfo' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'maskgroupbasedcorrmaskrangeareamodelscomponents' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'] },
	'maskgroupbasedcorrmaskrangecoloramount' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'] },
	'maskgroupbasedcorrmaskrangedepthfeather' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'] },
	'maskgroupbasedcorrmaskrangedepthmax' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'] },
	'maskgroupbasedcorrmaskrangedepthmin' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'] },
	'maskgroupbasedcorrmaskrangeinvert' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'] },
	'maskgroupbasedcorrmaskrangelumfeather' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'] },
	'maskgroupbasedcorrmaskrangeluminancedepthsampleinfo' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'maskgroupbasedcorrmaskrangelummax' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'] },
	'maskgroupbasedcorrmaskrangelummin' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'] },
	'maskgroupbasedcorrmaskrangelumrange' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'] },
	'maskgroupbasedcorrmaskrangesampletype' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'] },
	'maskgroupbasedcorrmaskrangetype' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'] },
	'maskgroupbasedcorrmaskrangeversion' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'] },
	'maskgroupbasedcorrmaskreferencepoint' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksReferencePoint'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksReferencePoint'] },
	'maskgroupbasedcorrmaskright' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksRight'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksRight'] },
	'maskgroupbasedcorrmaskroundness' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksRoundness'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksRoundness'] },
	'maskgroupbasedcorrmasksizex' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksSizeX'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksSizeX'] },
	'maskgroupbasedcorrmasksizey' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksSizeY'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksSizeY'] },
	'maskgroupbasedcorrmasktop' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksTop'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksTop'] },
	'maskgroupbasedcorrmaskvalue' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskValue'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskValue'] },
	'maskgroupbasedcorrmaskversion' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksVersion'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksVersion'] },
	'maskgroupbasedcorrmaskwhat' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksWhat'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksWhat'] },
	'maskgroupbasedcorrmaskwholeimagearea' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksWholeImageArea'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksWholeImageArea'] },
	'maskgroupbasedcorrmaskx' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksX'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksX'] },
	'maskgroupbasedcorrmasky' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksY'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksY'] },
	'maskgroupbasedcorrmaskzerox' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksZeroX'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksZeroX'] },
	'maskgroupbasedcorrmaskzeroy' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksZeroY'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksZeroY'] },
	'maskgroupbasedcorrmoire' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalMoire'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalMoire'] },
	'maskgroupbasedcorrrangemask' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMask'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMask'] },
	'maskgroupbasedcorrrangemaskareamodels' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskAreaModels'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskAreaModels'] },
	'maskgroupbasedcorrrangemaskareamodelscolorsampleinfo' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'maskgroupbasedcorrrangemaskareamodelscomponents' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'] },
	'maskgroupbasedcorrrangemaskcoloramount' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskColorAmount'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskColorAmount'] },
	'maskgroupbasedcorrrangemaskdepthfeather' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskDepthFeather'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskDepthFeather'] },
	'maskgroupbasedcorrrangemaskdepthmax' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskDepthMax'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskDepthMax'] },
	'maskgroupbasedcorrrangemaskdepthmin' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskDepthMin'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskDepthMin'] },
	'maskgroupbasedcorrrangemaskinvert' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskInvert'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskInvert'] },
	'maskgroupbasedcorrrangemasklumfeather' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumFeather'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumFeather'] },
	'maskgroupbasedcorrrangemaskluminancedepthsampleinfo' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'maskgroupbasedcorrrangemasklummax' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumMax'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumMax'] },
	'maskgroupbasedcorrrangemasklummin' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumMin'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumMin'] },
	'maskgroupbasedcorrrangemasklumrange' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumRange'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumRange'] },
	'maskgroupbasedcorrrangemasksampletype' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskSampleType'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskSampleType'] },
	'maskgroupbasedcorrrangemasktype' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskType'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskType'] },
	'maskgroupbasedcorrrangemaskversion' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskVersion'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskVersion'] },
	'maskgroupbasedcorrsaturation' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalSaturation'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalSaturation'] },
	'maskgroupbasedcorrshadows2012' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalShadows2012'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalShadows2012'] },
	'maskgroupbasedcorrsharpness' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalSharpness'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalSharpness'] },
	'maskgroupbasedcorrtemperature' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalTemperature'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalTemperature'] },
	'maskgroupbasedcorrtexture' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalTexture'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalTexture'] },
	'maskgroupbasedcorrtint' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalTint'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalTint'] },
	'maskgroupbasedcorrtoninghue' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalToningHue'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalToningHue'] },
	'maskgroupbasedcorrtoningsaturation' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalToningSaturation'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalToningSaturation'] },
	'maskgroupbasedcorrwhat' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsWhat'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsWhat'] },
	'maskgroupbasedcorrwhites2012' => { 477 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalWhites2012'], 479 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalWhites2012'] },
	'masterdocumentid' => { 131 => 0xb9 },
	'mastergain' => { 237 => 0x50 },
	'materialsample' => { 118 => 'MaterialSample' },
	'materialsampleid' => { 118 => [\'MaterialSample','MaterialSampleMaterialSampleID'] },
	'matrixmetering' => { 280 => '50.1', 282 => '48.1', 283 => '48.1', 292 => '48.1', 293 => '48.1', 295 => 0x233 },
	'matrixselectk' => { 138 => 0x91b },
	'matrixselectthreshold' => { 138 => 0x91a },
	'matrixselectthreshold1' => { 138 => 0x91e },
	'matrixselectthreshold2' => { 138 => 0x91f },
	'matrixstructure' => { 379 => 0xa },
	'maxaperture' => { 34 => 0x1a, 138 => 0x3f9, 144 => 0x6103, 163 => 'MaxAperture', 181 => 0x17, 187 => 0x49c5, 224 => 0x36, 298 => 0x20a, 346 => '14.1' },
	'maxapertureatmaxfocal' => { 127 => 0x1407, 163 => 'MaxApertureAtMaxFocal', 218 => 0xb, 219 => 0x10, 220 => 0x11, 224 => 0x12, 298 => 0x206 },
	'maxapertureatminfocal' => { 127 => 0x1406, 218 => 0xa, 219 => 0xf, 220 => 0x10, 224 => 0x11, 298 => 0x205 },
	'maxaperturevalue' => { 119 => 0x9205, 364 => 0x414, 483 => 'MaxApertureValue' },
	'maxavailheight' => { 489 => 'MaxAvailHeight' },
	'maxavailwidth' => { 489 => 'MaxAvailWidth' },
	'maxcontinuousrelease' => { 279 => 0xb, 280 => 0xc, 282 => '12.1', 283 => '12.1', 288 => 0xc, 289 => 0xb, 292 => '12.1', 293 => '12.1', 295 => 0x3d },
	'maxfaces' => { 301 => 0x1202 },
	'maxfocallength' => { 7 => 0xe6, 8 => 0x10, 9 => 0x1ab, 10 => 0x13, 11 => 0x115, 12 => 0x13, 13 => 0x153, 14 => 0xda, 16 => 0xfa, 17 => 0xee, 18 => 0x103, 19 => 0x95, 20 => 0xea, 21 => 0x157, 22 => 0xee, 23 => 0xec, 24 => 0x12b, 25 => 0x165, 26 => 0x16a, 27 => 0x188, 28 => 0x116, 29 => 0x18d, 34 => 0x17, 127 => 0x1405, 163 => 'MaxFocalLength', 218 => 0x9, 219 => 0xe, 220 => 0xf, 224 => 0x10, 298 => 0x208, 432 => 0x127c, 433 => 0x1138, 434 => 0x330, 435 => 0x330, 436 => 0x30e },
	'maximumdensityrange' => { 133 => 0x8c },
	'maxpagesize' => { 508 => 'MaxPageSize' },
	'maxpagesizeh' => { 508 => [\'MaxPageSize','MaxPageSizeH'] },
	'maxpagesizeunit' => { 508 => [\'MaxPageSize','MaxPageSizeUnit'] },
	'maxpagesizew' => { 508 => [\'MaxPageSize','MaxPageSizeW'] },
	'maxpixelvaluethreshold' => { 138 => 0xc7d },
	'maxsamplevalue' => { 119 => 0x119 },
	'maxstorage' => { 498 => 'maxstorage' },
	'mb-d10batteries' => { 279 => '12.6' },
	'mb-d10batterytype' => { 288 => '13.3' },
	'mb-d11batterytype' => { 289 => '2.3' },
	'mb-d12batterytype' => { 292 => '3.2' },
	'mb-d80batteries' => { 290 => '6.5' },
	'mb-d80batterytype' => { 294 => '3.2' },
	'mcuversion' => { 218 => 0xc, 219 => 0x11, 220 => 0x12, 224 => 0x13 },
	'md5digest' => { 164 => 'zmd5' },
	'mditemfindercomment' => { 173 => 'MDItemFinderComment' },
	'mditemfscreationdate' => { 173 => 'MDItemFSCreationDate' },
	'mditemfslabel' => { 173 => 'MDItemFSLabel' },
	'mditemusertags' => { 173 => 'MDItemUserTags' },
	'meal' => { 495 => 'meal' },
	'measuredev' => { 28 => 0x9, 77 => 0x3, 97 => 0x1814, 156 => 'MeasuredEV' },
	'measuredev2' => { 13 => 0x8, 28 => 0x8, 77 => 0x17 },
	'measuredev3' => { 13 => 0x9 },
	'measuredlv' => { 187 => 0x690, 315 => 0x312, 318 => 0x312, 319 => 0x312, 322 => 0x3407 },
	'measuredrggb' => { 65 => 0x1 },
	'measuredrggbdata' => { 44 => 0x287 },
	'measurementaccuracy' => { 118 => [\'MeasurementOrFact','MeasurementOrFactMeasurementAccuracy'] },
	'measurementdeterminedby' => { 118 => [\'MeasurementOrFact','MeasurementOrFactMeasurementDeterminedBy'] },
	'measurementdetermineddate' => { 118 => [\'MeasurementOrFact','MeasurementOrFactMeasurementDeterminedDate'] },
	'measurementid' => { 118 => [\'MeasurementOrFact','MeasurementOrFactMeasurementID'] },
	'measurementmethod' => { 118 => [\'MeasurementOrFact','MeasurementOrFactMeasurementMethod'] },
	'measurementorfact' => { 118 => 'MeasurementOrFact' },
	'measurementremarks' => { 118 => [\'MeasurementOrFact','MeasurementOrFactMeasurementRemarks'] },
	'measurementtype' => { 118 => [\'MeasurementOrFact','MeasurementOrFactMeasurementType'] },
	'measurementunit' => { 118 => [\'MeasurementOrFact','MeasurementOrFactMeasurementUnit'] },
	'measurementvalue' => { 118 => [\'MeasurementOrFact','MeasurementOrFactMeasurementValue'] },
	'measuretype' => { 462 => 'MeasureType' },
	'mechanicalshuttercount' => { 226 => 0x37 },
	'mediaclassprimaryid' => { 179 => 'WM/MediaClassPrimaryID' },
	'mediaclasssecondaryid' => { 179 => 'WM/MediaClassSecondaryID' },
	'mediaconstraints' => { 307 => 'MediaConstraints' },
	'mediacreatedate' => { 376 => 0x1 },
	'mediaeventiddate' => { 467 => 'MediaEventIdDate' },
	'mediagroupuuid' => { 1 => 0x11 },
	'mediamodifydate' => { 376 => 0x2 },
	'mediasummarycode' => { 307 => 'MediaSummaryCode' },
	'mediatype' => { 372 => 'stik' },
	'memoaudioquality' => { 84 => 0x812 },
	'memorycardconfiguration' => { 413 => 0x16 },
	'memorycardnumber' => { 208 => 0x2 },
	'menubuttondisplayposition' => { 82 => 0xb, 85 => 0xa, 86 => 0xb, 89 => 0xb },
	'menubuttonreturn' => { 90 => 0xb },
	'menumonitorofftime' => { 279 => '26.1', 280 => '22.1', 282 => '22.1', 283 => '22.1', 287 => '21.1', 288 => '8.2', 289 => '21.1', 292 => '22.1', 293 => '22.1', 294 => '22.1', 295 => 0x35 },
	'menusettingsz7iioffset' => { 260 => 0xceb6 },
	'metadatadate' => { 501 => 'MetadataDate' },
	'metadatamoddate' => { 503 => 'metadataModDate' },
	'metaversion' => { 427 => 0x34 },
	'meterinfo1row1' => { 421 => 0x0, 422 => 0x0 },
	'meterinfo1row2' => { 421 => 0x6c, 422 => 0x5a },
	'meterinfo1row3' => { 421 => 0xd8, 422 => 0xb4 },
	'meterinfo1row4' => { 421 => 0x144, 422 => 0x10e },
	'meterinfo1row5' => { 421 => 0x1b0, 422 => 0x168 },
	'meterinfo1row6' => { 421 => 0x21c, 422 => 0x1c2 },
	'meterinfo1row7' => { 421 => 0x288, 422 => 0x21c },
	'meterinfo2row1' => { 421 => 0x2f4, 422 => 0x276 },
	'meterinfo2row2' => { 421 => 0x378, 422 => 0x2e4 },
	'meterinfo2row3' => { 421 => 0x3fc, 422 => 0x352 },
	'meterinfo2row4' => { 421 => 0x480, 422 => 0x3c0 },
	'meterinfo2row5' => { 421 => 0x504, 422 => 0x42e },
	'meterinfo2row6' => { 421 => 0x588, 422 => 0x49c },
	'meterinfo2row7' => { 421 => 0x60c, 422 => 0x50a },
	'meterinfo2row8' => { 421 => 0x690, 422 => 0x578 },
	'meterinfo2row9' => { 421 => 0x714, 422 => 0x5e6 },
	'metering' => { 281 => '6.1' },
	'meteringmode' => { 34 => 0x11, 119 => 0x9207, 140 => 0x1c, 181 => 0x7, 182 => 0x25, 184 => 0x12, 297 => 0x202, 355 => 0x17, 397 => 0x9, 407 => 0x15, 408 => 0x13, 409 => 0x7, 425 => 0x3, 428 => 0x1174, 429 => 0x1178, 430 => 0x1154, 431 => 0x11d0, 432 => 0x11ac, 433 => 0x1064, 434 => 0x25c, 435 => 0x25c, 436 => 0x24b, 483 => 'MeteringMode' },
	'meteringmode2' => { 336 => '2.1', 420 => 0x202c },
	'meteringmode3' => { 336 => '16.1' },
	'meteringoffscaleindicator' => { 184 => 0x53 },
	'meteringtime' => { 279 => '22.2', 281 => '3.2', 284 => '17.1', 285 => '18.1', 288 => '7.3', 289 => '18.1', 290 => '3.2', 294 => '19.1' },
	'micro1version' => { 382 => 0x1f },
	'micro2version' => { 382 => 0x2d },
	'microphoneattenuator' => { 229 => 0x2d2 },
	'microphonefrequencyresponse' => { 229 => 0x2d4 },
	'microphonejackpower' => { 229 => 0x2fa },
	'microphonesensitivity' => { 229 => 0x2d0 },
	'microvideo' => { 460 => 'MicroVideo' },
	'microvideooffset' => { 460 => 'MicroVideoOffset' },
	'microvideopresentationtimestampus' => { 460 => 'MicroVideoPresentationTimestampUs' },
	'microvideoversion' => { 460 => 'MicroVideoVersion' },
	'midrangesharpness' => { 233 => 0x3b },
	'mieversion' => { 164 => '0Vers' },
	'mime' => { 462 => 'Mime' },
	'minaperture' => { 34 => 0x1b, 138 => 0x3f8, 163 => 'MinAperture', 346 => '0.2' },
	'minaperturevalue' => { 364 => 0x415 },
	'minfocallength' => { 7 => 0xe4, 8 => 0xe, 9 => 0x1a9, 10 => 0x11, 11 => 0x113, 12 => 0x11, 13 => 0x151, 14 => 0xd8, 16 => 0xf8, 17 => 0xec, 18 => 0x101, 19 => 0x93, 20 => 0xe8, 21 => 0x155, 22 => 0xec, 23 => 0xea, 24 => 0x129, 25 => 0x163, 26 => 0x168, 27 => 0x186, 28 => 0x114, 29 => 0x18b, 34 => 0x18, 127 => 0x1404, 163 => 'MinFocalLength', 218 => 0x8, 219 => 0xd, 220 => 0xe, 224 => 0xf, 298 => 0x207, 432 => 0x127a, 433 => 0x1136, 434 => 0x32e, 435 => 0x32e, 436 => 0x30c },
	'minfocusdistance' => { 346 => 0x3 },
	'minintegrationrows' => { 138 => 0x1874 },
	'minoltadate' => { 181 => 0x15 },
	'minoltaimagesize' => { 181 => 0x4, 182 => 0xc, 183 => 0x2, 186 => 0x103 },
	'minoltamodelid' => { 181 => 0x25 },
	'minoltaquality' => { 181 => 0x5, 182 => 0xd, 183 => 0x3, 186 => [0x102,0x103] },
	'minoltatime' => { 181 => 0x16 },
	'minormodelagedisclosure' => { 307 => 'MinorModelAgeDisclosure' },
	'minorversion' => { 468 => 'MinorVersion' },
	'minsamplevalue' => { 119 => 0x118 },
	'mirrorlockup' => { 82 => 0xc, 83 => 0xc, 84 => 0x60f, 85 => 0xb, 86 => 0xc, 87 => 0x6, 88 => 0x6, 89 => 0xc, 90 => 0x3 },
	'mobilecountrycode' => { 476 => 'mcc' },
	'mobilenetworkcode' => { 476 => 'mnc' },
	'moddate' => { 310 => 'modify-date', 490 => 'ModDate' },
	'modedialposition' => { 413 => 0x14 },
	'model' => { 98 => 0x6, 119 => 0x110, 156 => 'Model', 310 => 'Model', 325 => 0x110, 355 => 0x23f, 374 => 'model', 380 => ['@mod','CNMN','cmnm',"\xa9mdl","\xa9mod"], 397 => 0x84, 462 => 'Model', 492 => 'model', 499 => 'Model' },
	'modelage' => { 489 => 'ModelAge' },
	'modelid' => { 296 => 0x0 },
	'modelingflash' => { 279 => '21.4', 280 => '31.1', 282 => '31.1', 283 => '31.1', 288 => '26.4', 289 => '30.2', 290 => '7.4', 291 => '30.1', 292 => '31.1', 293 => '31.1', 294 => '31.3', 295 => 0x5d },
	'modelreleaseid' => { 307 => 'ModelReleaseID' },
	'modelreleasestatus' => { 307 => 'ModelReleaseStatus' },
	'modelreleaseyear' => { 441 => 0x52, 442 => 0x46, 443 => 0x53 },
	'modeltiepoint' => { 119 => 0x8482 },
	'modeltransform' => { 119 => 0x85d8 },
	'modelyear' => { 492 => 'modelYear' },
	'modificationdate' => { 493 => 'modificationDate' },
	'modifiedcolortemp' => { 66 => 0x9 },
	'modifieddigitalgain' => { 66 => 0xb },
	'modifiedparamflag' => { 58 => 0x1 },
	'modifiedpicturestyle' => { 66 => 0xa },
	'modifiedsaturation' => { 297 => 0x504 },
	'modifiedsensorbluelevel' => { 66 => 0x5 },
	'modifiedsensorredlevel' => { 66 => 0x4 },
	'modifiedsharpness' => { 66 => 0x2 },
	'modifiedsharpnessfreq' => { 66 => 0x3 },
	'modifiedtonecurve' => { 66 => 0x1 },
	'modifiedwhitebalance' => { 66 => 0x8 },
	'modifiedwhitebalanceblue' => { 66 => 0x7 },
	'modifiedwhitebalancered' => { 66 => 0x6 },
	'modifydate' => { 119 => 0x132, 157 => 'ModifyDate', 306 => 'ModDate', 308 => 'tIME', 371 => 'ModDate', 377 => 0x2, 501 => 'ModifyDate' },
	'moirefilter' => { 119 => 0xfe58, 477 => 'MoireFilter', 479 => 'MoireFilter' },
	'monitorbrightness' => { 229 => 0x59a },
	'monitordisplayoff' => { 184 => 0x4c },
	'monitormatrix' => { 138 => 0x8fc },
	'monitorofftime' => { 279 => '18.2', 281 => '3.1', 290 => '3.1' },
	'monochromecolor' => { 297 => 0x53b },
	'monochromecontrast' => { 109 => 0x3c },
	'monochromefiltereffect' => { 103 => 0x20307, 109 => 0x3a, 320 => 0xac, 355 => 0x73 },
	'monochromegraineffect' => { 320 => 0xd2 },
	'monochromelinear' => { 109 => 0x3d },
	'monochromeoutputhighlightpoint' => { 109 => 0x41 },
	'monochromeoutputshadowpoint' => { 109 => 0x42 },
	'monochromeprofilesettings' => { 297 => 0x537 },
	'monochromerawhighlight' => { 109 => 0x7a },
	'monochromerawhighlightpoint' => { 109 => 0x3f },
	'monochromerawshadow' => { 109 => 0x83 },
	'monochromerawshadowpoint' => { 109 => 0x40 },
	'monochromesharpness' => { 109 => 0x3e },
	'monochrometoning' => { 355 => 0x74 },
	'monochrometoningeffect' => { 103 => 0x20306, 109 => 0x3b },
	'monochromeunsharpmaskfineness' => { 109 => 0xb2 },
	'monochromeunsharpmaskstrength' => { 109 => 0xb0 },
	'monochromeunsharpmaskthreshold' => { 109 => 0xb4 },
	'monochromevignetting' => { 297 => 0x53a },
	'monthdaycreated' => { 140 => 0x12, 149 => 0xe },
	'mood' => { 179 => 'WM/Mood' },
	'moonphase' => { 381 => 0x12, 382 => 0x43, 383 => 0x4c },
	'morepermissions' => { 475 => 'morePermissions' },
	'motionsensitivity' => { 381 => 0x29, 383 => 0x60 },
	'movementcount' => { 372 => "\xa9mvc" },
	'movementname' => { 372 => "\xa9mvn" },
	'movementnumber' => { 372 => "\xa9mvi" },
	'movieactived-lighting' => { 228 => 0x238, 229 => 0x2b8 },
	'movieaelockbuttonassignment' => { 292 => '40.1' },
	'movieaf-onbutton' => { 295 => 0xcb },
	'movieafareamode' => { 229 => 0x2c6, 295 => 0x203 },
	'movieafspeed' => { 295 => 0xdd },
	'movieafspeedapply' => { 295 => 0xdf },
	'movieaftrackingsensitivity' => { 295 => 0xe1 },
	'movieaperturelock' => { 295 => 0x259 },
	'movieautodistortioncontrol' => { 228 => 0x242 },
	'moviediffractioncompensation' => { 228 => 0x241 },
	'moviedxcropalert' => { 229 => 0x2fb },
	'movieelectronicvr' => { 229 => 0x2cc },
	'movieevfgrid' => { 295 => 0x21d },
	'movieflickerreduction' => { 229 => 0x2c0 },
	'moviefocusmode' => { 228 => 0x248, 229 => 0x2c4 },
	'moviefocuspointlock' => { 295 => 0x226 },
	'movieframerate' => { 228 => 0x1f8, 229 => 0x2f4 },
	'movieframesize' => { 228 => 0x1f6, 229 => 0x2f2 },
	'moviefunc1button' => { 282 => '41.1', 283 => '41.1', 293 => '41.1', 295 => 0xc3 },
	'moviefunc3button' => { 295 => 0x127 },
	'moviefunctionbutton' => { 280 => '41.1', 292 => '41.1' },
	'moviefunctionbuttonplusdials' => { 280 => '52.1' },
	'moviehighisonoisereduction' => { 228 => 0x23c, 229 => 0x2ba },
	'moviehighlightdisplaythreshold' => { 295 => 0x215 },
	'movieimagearea' => { 229 => 0x25c },
	'movieisoautocontrolmanualmode' => { 229 => 0x26a },
	'movieisoautohilimit' => { 229 => 0x268 },
	'movieisoautomanualmode' => { 228 => 0x204, 229 => 0x26c },
	'moviemeteringmode' => { 229 => 0x2c2 },
	'moviemidtonedisplayrange' => { 295 => 0x219 },
	'moviemidtonedisplayvalue' => { 295 => 0x217 },
	'moviemultiselector' => { 295 => 0xd9 },
	'moviepreviewbutton' => { 280 => '41.2', 282 => '41.2', 283 => '41.2', 292 => '41.2', 293 => '41.2' },
	'moviepreviewbuttonplusdials' => { 280 => '52.2' },
	'movierecordbuttonplaybackmode' => { 295 => 0x1b5 },
	'movieshutterbutton' => { 280 => '38.3', 282 => '38.3', 283 => '38.3', 292 => '38.3', 293 => '38.3' },
	'movieshutterspeedlock' => { 295 => 0x225 },
	'movieslowmotion' => { 228 => 0x1fa },
	'moviesoundrecording' => { 229 => 0x2ce },
	'moviesubjectdetection' => { 229 => 0x2fc },
	'moviesubselectorassignment' => { 280 => '48.2' },
	'moviesubselectorassignmentplusdials' => { 280 => '53.1' },
	'movietonemap' => { 229 => 0x2ec },
	'movietype' => { 228 => 0x1fe, 229 => 0x266, 252 => 0xc55c },
	'movievibrationreduction' => { 228 => 0x24e },
	'movievibrationreductionsameasphoto' => { 228 => 0x24f },
	'movievignettecontrol' => { 228 => 0x23e, 229 => 0x1a0 },
	'movievignettecontrolsameasphoto' => { 228 => 0x240 },
	'movievrmode' => { 229 => 0x2c8 },
	'moviezebrapattern' => { 295 => 0x213 },
	'multiburstimageheight' => { 420 => 0x1002 },
	'multiburstimagewidth' => { 420 => 0x1001 },
	'multiburstmode' => { 420 => 0x1000 },
	'multicontrollerwhilemetering' => { 84 => 0x517 },
	'multiexposure' => { 68 => 0x1, 320 => 0xb4 },
	'multiexposureautogain' => { 230 => 0x3 },
	'multiexposurecontrol' => { 68 => 0x2 },
	'multiexposuremode' => { 230 => 0x1 },
	'multiexposureshots' => { 68 => 0x3, 229 => 0x8e, 230 => 0x2 },
	'multiframenoisereduction' => { 409 => 0x35, 420 => 0x200b, 425 => 0x15 },
	'multiframenreffect' => { 420 => 0x2023 },
	'multifunctionlock' => { 84 => 0x70f },
	'multipleexposuremode' => { 229 => 0x8c, 301 => 0x101c },
	'multipleexposureset' => { 336 => '10.1' },
	'multisample' => { 237 => 0x40 },
	'multiselector' => { 279 => '9.4', 280 => '10.3', 282 => '10.3', 283 => '10.3', 288 => '27.4', 292 => '10.3', 293 => '10.3' },
	'multiselectorliveview' => { 279 => '4.3', 282 => '37.1', 283 => '37.1', 292 => '37.1', 293 => '37.1' },
	'multiselectorliveviewmode' => { 247 => 0x18c2 },
	'multiselectorplaybackmode' => { 279 => ['13.5','9.2'], 280 => '10.2', 283 => '10.2', 288 => '27.2', 292 => '10.2', 293 => '10.2', 295 => 0xb3 },
	'multiselectorshootmode' => { 279 => '9.1', 280 => '10.1', 282 => '10.1', 283 => '10.1', 288 => '27.1', 292 => '10.1', 293 => '10.1', 295 => 0xaf },
	'multishot' => { 325 => 0x121 },
	'mute' => { 374 => 'player.movie.audio.mute' },
	'mycolormode' => { 69 => 0x2 },
	'name' => { 380 => 'name', 477 => 'Name', 479 => 'Name' },
	'narrator' => { 372 => "\xa9nrt" },
	'nationalcatalognumber' => { 493 => 'nationalCatalogNumber' },
	'nativedigest' => { 483 => 'NativeDigest', 499 => 'NativeDigest' },
	'ndfilter' => { 77 => 0x1c, 297 => 0x204, 387 => 0x1019 },
	'near' => { 462 => 'Near' },
	'nefbitdepth' => { 226 => 0xe22 },
	'nefcompression' => { 226 => 0x93, 227 => 0xa },
	'neflinearizationtable' => { 226 => 0x96 },
	'negativecachelargepreviewsize' => { 477 => 'NegativeCacheLargePreviewSize', 479 => 'NegativeCacheLargePreviewSize' },
	'negativecachemaximumsize' => { 477 => 'NegativeCacheMaximumSize', 479 => 'NegativeCacheMaximumSize' },
	'negativecachepath' => { 477 => 'NegativeCachePath', 479 => 'NegativeCachePath' },
	'neutraldensityfactor' => { 474 => 'NeutralDensityFactor' },
	'neutraldensityfilter' => { 355 => 0x88 },
	'neutraloutputhighlightpoint' => { 109 => 0x2f },
	'neutraloutputshadowpoint' => { 109 => 0x30 },
	'neutralrawcolortone' => { 109 => 0x28 },
	'neutralrawcontrast' => { 109 => 0x2a },
	'neutralrawhighlight' => { 109 => 0x78 },
	'neutralrawhighlightpoint' => { 109 => 0x2d },
	'neutralrawlinear' => { 109 => 0x2b },
	'neutralrawsaturation' => { 109 => 0x29 },
	'neutralrawshadow' => { 109 => 0x81 },
	'neutralrawshadowpoint' => { 109 => 0x2e },
	'neutralrawsharpness' => { 109 => 0x2c },
	'neutralunsharpmaskfineness' => { 109 => 0xa6 },
	'neutralunsharpmaskthreshold' => { 109 => 0xa8 },
	'neutraunsharpmaskstrength' => { 109 => 0xa4 },
	'newrawimagedigest' => { 119 => 0xc7a7 },
	'newsphotoversion' => { 133 => 0x0 },
	'nickname' => { 501 => 'Nickname' },
	'nikoncapturedata' => { 226 => 0xe01 },
	'nikoncaptureeditversions' => { 226 => 0xe13 },
	'nikoncaptureoffsets' => { 226 => 0xe0e },
	'nikoncaptureoutput' => { 226 => 0xe1e },
	'nikoncaptureversion' => { 226 => 0xe09 },
	'nikoniccprofile' => { 226 => 0xe1d },
	'nikonimagesize' => { 244 => '723.1', 245 => '732.1', 255 => 0x2c4 },
	'nikonmeteringmode' => { 228 => 0x146, 248 => 0x2ea4, 257 => 0x175e },
	'nikonsettings' => { 226 => 0x4e },
	'noisefilter' => { 297 => 0x527 },
	'noiseprofile' => { 119 => 0xc761 },
	'noisereduction' => { 127 => [0x100b,0x100e], 182 => 0xb0, 183 => 0x60, 184 => 0x3f, 226 => 0x95, 272 => 0x753dcbc0, 273 => 0x17, 297 => 0x50a, 302 => 0x103a, 320 => 0x2d, 355 => 0x49, 387 => 0x100f, 389 => 0x2a },
	'noisereduction2' => { 301 => 0x1010 },
	'noisereductionapplied' => { 119 => 0xc6f7 },
	'noisereductionintensity' => { 273 => 0x9 },
	'noisereductionmethod' => { 273 => 0x11 },
	'noisereductionmode' => { 454 => 0x801e },
	'noisereductionparametersatcapture' => { 138 => 0xe73 },
	'noisereductionparameterscamera' => { 138 => 0xe72 },
	'noisereductionparametershost3mp' => { 138 => 0xe71 },
	'noisereductionparametershost6mp' => { 138 => 0xe70 },
	'noisereductionparametershostrgb' => { 138 => 0xe6f },
	'noisereductionparameterskhufu3mp' => { 138 => 0xe65 },
	'noisereductionparameterskhufu6mp' => { 138 => 0xe64 },
	'noisereductionparameterskhufurgb' => { 138 => 0xe63 },
	'noisereductionparams' => { 325 => 0x1b },
	'noisereductionsharpness' => { 273 => 0xd },
	'noisereductionstrength' => { 320 => 0xd6 },
	'noisereductionvalue' => { 454 => 0x8027 },
	'nomemorycard' => { 279 => '22.1', 280 => '4.2', 281 => '0.3', 284 => '2.4', 285 => '3.2', 286 => '3.2', 288 => '33.7', 289 => '3.2', 290 => '0.3', 292 => '4.2', 294 => '4.5' },
	'nominalmaxaperture' => { 346 => 0xa },
	'nominalminaperture' => { 346 => '10.1' },
	'normallinetime' => { 138 => 0x186a },
	'normalwhitelevel' => { 41 => 0x32a, 42 => 0x280, 45 => [0x2b8,0x2cf,0x2d3], 46 => 0x569, 47 => 0x1e3, 48 => [0x1fc,0x2dc], 49 => [0x230,0x30e], 50 => 0x31c },
	'notes' => { 455 => 'Notes', 472 => 'notes' },
	'npages' => { 508 => 'NPages' },
	'nullrecord' => { 97 => 0x0 },
	'numafpoints' => { 332 => 0x2 },
	'number' => { 493 => 'number' },
	'numberofbeats' => { 503 => 'numberOfBeats' },
	'numberoffocuspoints' => { 282 => '1.3', 283 => '1.3', 286 => '0.2', 287 => '0.3', 289 => '0.3' },
	'numfaceelements' => { 127 => 0x4200 },
	'numfacepositions' => { 312 => 0x0 },
	'numindexentries' => { 133 => 0x54 },
	'numwbentries' => { 326 => 0x0, 327 => 0x0 },
	'object' => { 493 => 'object' },
	'objectattributereference' => { 131 => 0x4 },
	'objectcycle' => { 131 => 0x4b, 472 => 'ObjectCycle' },
	'objectdescription' => { 492 => 'objectDescription' },
	'objectdistance' => { 112 => 0x6, 113 => 0x2022 },
	'objectname' => { 131 => 0x5 },
	'objectpreviewdata' => { 131 => 0xca },
	'objectpreviewfileformat' => { 131 => 0xc8 },
	'objectpreviewfileversion' => { 131 => 0xc9 },
	'objectsubtype' => { 492 => 'objectSubtype' },
	'objecttype' => { 492 => 'objectType' },
	'objecttypereference' => { 131 => 0x3 },
	'occurrence' => { 118 => 'Occurrence' },
	'occurrenceassociatedmedia' => { 118 => [\'Occurrence','OccurrenceAssociatedMedia'] },
	'occurrenceassociatedoccurrences' => { 118 => [\'Occurrence','OccurrenceAssociatedOccurrences'] },
	'occurrenceassociatedreferences' => { 118 => [\'Occurrence','OccurrenceAssociatedReferences'] },
	'occurrenceassociatedsequences' => { 118 => [\'Occurrence','OccurrenceAssociatedSequences'] },
	'occurrenceassociatedtaxa' => { 118 => [\'Occurrence','OccurrenceAssociatedTaxa'] },
	'occurrencebehavior' => { 118 => [\'Occurrence','OccurrenceBehavior'] },
	'occurrencecatalognumber' => { 118 => [\'Occurrence','OccurrenceCatalogNumber'] },
	'occurrencedetails' => { 118 => [\'Occurrence','OccurrenceOccurrenceDetails'] },
	'occurrencedisposition' => { 118 => [\'Occurrence','OccurrenceDisposition'] },
	'occurrenceestablishmentmeans' => { 118 => [\'Occurrence','OccurrenceEstablishmentMeans'] },
	'occurrenceid' => { 118 => [\'Occurrence','OccurrenceOccurrenceID'] },
	'occurrenceindividualcount' => { 118 => [\'Occurrence','OccurrenceIndividualCount'] },
	'occurrenceindividualid' => { 118 => [\'Occurrence','OccurrenceIndividualID'] },
	'occurrencelifestage' => { 118 => [\'Occurrence','OccurrenceLifeStage'] },
	'occurrenceorganismquantity' => { 118 => [\'Occurrence','OccurrenceOrganismQuantity'] },
	'occurrenceorganismquantitytype' => { 118 => [\'Occurrence','OccurrenceOrganismQuantityType'] },
	'occurrenceothercatalognumbers' => { 118 => [\'Occurrence','OccurrenceOtherCatalogNumbers'] },
	'occurrencepreparations' => { 118 => [\'Occurrence','OccurrencePreparations'] },
	'occurrencepreviousidentifications' => { 118 => [\'Occurrence','OccurrencePreviousIdentifications'] },
	'occurrencerecordedby' => { 118 => [\'Occurrence','OccurrenceRecordedBy'] },
	'occurrencerecordnumber' => { 118 => [\'Occurrence','OccurrenceRecordNumber'] },
	'occurrenceremarks' => { 118 => [\'Occurrence','OccurrenceOccurrenceRemarks'] },
	'occurrencereproductivecondition' => { 118 => [\'Occurrence','OccurrenceReproductiveCondition'] },
	'occurrencesex' => { 118 => [\'Occurrence','OccurrenceSex'] },
	'occurrencestatus' => { 118 => [\'Occurrence','OccurrenceOccurrenceStatus'] },
	'oecfcolumns' => { 483 => [\'OECF','OECFColumns'] },
	'oecfnames' => { 483 => [\'OECF','OECFNames'] },
	'oecfrows' => { 483 => [\'OECF','OECFRows'] },
	'oecfvalues' => { 483 => [\'OECF','OECFValues'] },
	'offsaledate' => { 493 => 'offSaleDate' },
	'offsaledatea-platform' => { 493 => [\'offSaleDate','offSaleDateA-platform'] },
	'offsaledatedate' => { 493 => [\'offSaleDate','offSaleDateDate'] },
	'offsetdacvalue' => { 138 => 0x190a },
	'offsetschema' => { 119 => 0xea1d },
	'offsettime' => { 119 => 0x9010 },
	'offsettimedigitized' => { 119 => 0x9012 },
	'offsettimeoriginal' => { 119 => 0x9011 },
	'okbutton' => { 289 => '15.1', 294 => '16.1' },
	'oldsubfiletype' => { 119 => 0xff },
	'olympusimageheight' => { 302 => 0x102f },
	'olympusimagewidth' => { 302 => 0x102e },
	'omenatcapturestrength' => { 138 => 0xa60 },
	'omenautostrength' => { 138 => 0xa5f },
	'omenearlystrength' => { 138 => 0xa5e },
	'omenfocallengthlimit' => { 138 => 0xa62 },
	'omeninitialipfstrength' => { 138 => 0xa5d },
	'omensurfaceindex' => { 138 => 0xa64 },
	'oneshotafrelease' => { 2 => 0x9 },
	'onetouchwb' => { 302 => 0x302 },
	'onsaledate' => { 493 => 'onSaleDate' },
	'onsaledatea-platform' => { 493 => [\'onSaleDate','onSaleDateA-platform'] },
	'onsaledatedate' => { 493 => [\'onSaleDate','onSaleDateDate'] },
	'onsaleday' => { 493 => 'onSaleDay' },
	'onsaledaya-platform' => { 493 => [\'onSaleDay','onSaleDayA-platform'] },
	'onsaledayday' => { 493 => [\'onSaleDay','onSaleDayDay'] },
	'opcodelist1' => { 119 => 0xc740 },
	'opcodelist2' => { 119 => 0xc741 },
	'opcodelist3' => { 119 => 0xc74e },
	'opticalzoom' => { 142 => 0xfa3d, 144 => [0x6006,0xf006], 145 => 0x1000, 146 => 0xf, 149 => 0x1e, 151 => 0x20, 152 => 0x1c, 163 => 'OpticalZoom' },
	'opticalzoomcode' => { 77 => 0xa },
	'opticalzoommode' => { 320 => 0x34 },
	'opticalzoomon' => { 396 => 0x219 },
	'optionenddate' => { 496 => 'optionEndDate' },
	'opto-electricconvfactor' => { 483 => 'OECF' },
	'orangehsl' => { 103 => 0x20911 },
	'ordernumber' => { 127 => 0x8002 },
	'organisationinimagecode' => { 489 => 'OrganisationInImageCode' },
	'organisationinimagename' => { 489 => 'OrganisationInImageName' },
	'organism' => { 118 => 'Organism' },
	'organismassociatedoccurrences' => { 118 => [\'Organism','OrganismAssociatedOccurrences'] },
	'organismassociatedorganisms' => { 118 => [\'Organism','OrganismAssociatedOrganisms'] },
	'organismid' => { 118 => [\'Organism','OrganismOrganismID'] },
	'organismname' => { 118 => [\'Organism','OrganismOrganismName'] },
	'organismpreviousidentifications' => { 118 => [\'Organism','OrganismPreviousIdentifications'] },
	'organismremarks' => { 118 => [\'Organism','OrganismOrganismRemarks'] },
	'organismscope' => { 118 => [\'Organism','OrganismOrganismScope'] },
	'organization' => { 493 => 'organization' },
	'orientation' => { 119 => 0x112, 325 => 0x112, 492 => 'orientation', 499 => 'Orientation' },
	'orientation2' => { 425 => [0x28,0x2e] },
	'orientationlinkedaf' => { 2 => 0xe },
	'orientationlinkedafpoint' => { 84 => 0x516 },
	'originalalbumtitle' => { 179 => 'WM/OriginalAlbumTitle' },
	'originalartist' => { 179 => 'WM/OriginalArtist', 372 => "\xa9ope" },
	'originalbestqualitysize' => { 119 => 0xc792 },
	'originalcreatedatetime' => { 467 => 'OriginalCreateDateTime' },
	'originaldecisiondata' => { 114 => 'Canon-OriginalDecisionData' },
	'originaldecisiondataoffset' => { 64 => 0x83 },
	'originaldefaultcropsize' => { 119 => 0xc793 },
	'originaldefaultfinalsize' => { 119 => 0xc791 },
	'originaldirectory' => { 317 => 0x408 },
	'originaldocumentid' => { 504 => 'OriginalDocumentID' },
	'originalfilename' => { 97 => 0x816, 138 => 0x3e9, 150 => 0x20, 317 => 0x407, 467 => 'OriginalFilename' },
	'originalimageheight' => { 79 => 0xc, 123 => 0x1 },
	'originalimagewidth' => { 79 => 0xb, 123 => 0x0 },
	'originallyricist' => { 179 => 'WM/OriginalLyricist' },
	'originalrawfiledata' => { 119 => 0xc68c },
	'originalrawfiledigest' => { 119 => 0xc71d },
	'originalrawfilename' => { 119 => 0xc68b },
	'originaltransmissionreference' => { 131 => 0x67 },
	'originatingprogram' => { 131 => 0x41, 472 => 'OriginatingProgram' },
	'originplatform' => { 493 => 'originPlatform' },
	'os' => { 481 => 'os' },
	'otherconditions' => { 307 => 'OtherConditions' },
	'otherconstraints' => { 307 => 'OtherConstraints' },
	'otherimage' => { 114 => 'Exif-OtherImage' },
	'otherimageinfo' => { 307 => 'OtherImageInfo' },
	'otherimagelength' => { 119 => 0x202 },
	'otherimagestart' => { 119 => 0x201 },
	'otherlicensedocuments' => { 307 => 'OtherLicenseDocuments' },
	'otherlicenseinfo' => { 307 => 'OtherLicenseInfo' },
	'otherlicenserequirements' => { 307 => 'OtherLicenseRequirements' },
	'outcue' => { 503 => 'outCue' },
	'outcuescale' => { 503 => [\'outCue','outCueScale'] },
	'outcuevalue' => { 503 => [\'outCue','outCueValue'] },
	'outputimageheight' => { 197 => 0x3 },
	'outputimagewidth' => { 197 => 0x2 },
	'outputlut' => { 320 => 0xa7 },
	'outputprofile' => { 138 => 0x138b },
	'outputresolution' => { 197 => 0x4 },
	'overclockcols' => { 138 => 0x189c },
	'overclockrows' => { 138 => 0x18c4 },
	'overridelookvignette' => { 477 => 'OverrideLookVignette', 479 => 'OverrideLookVignette' },
	'owner' => { 507 => 'Owner' },
	'ownerid' => { 131 => 0xbc },
	'ownername' => { 15 => 0x10f, 64 => 0x9, 97 => 0x810, 119 => [0xa430,0xfde8], 156 => 'OwnerName', 474 => 'OwnerName', 484 => 'CameraOwnerName' },
	'padding' => { 119 => 0xea1c },
	'pagecount' => { 493 => 'pageCount' },
	'pageimage' => { 501 => [\'PageInfo','PageInfoImage'] },
	'pageimageformat' => { 501 => [\'PageInfo','PageInfoFormat'] },
	'pageimageheight' => { 501 => [\'PageInfo','PageInfoHeight'] },
	'pageimagepagenumber' => { 501 => [\'PageInfo','PageInfoPageNumber'] },
	'pageimagewidth' => { 501 => [\'PageInfo','PageInfoWidth'] },
	'pageinfo' => { 501 => 'PageInfo' },
	'pagename' => { 119 => 0x11d },
	'pagenumber' => { 119 => 0x129 },
	'pageprogressiondirection' => { 493 => 'pageProgressionDirection' },
	'pagerange' => { 493 => 'pageRange' },
	'paintbasedcorrectionmasks' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasks'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasks'] },
	'paintbasedcorrections' => { 477 => 'PaintBasedCorrections', 479 => 'PaintBasedCorrections' },
	'paintcorrectionactive' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionActive'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionActive'] },
	'paintcorrectionamount' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionAmount'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionAmount'] },
	'paintcorrectionblacks2012' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalBlacks2012'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalBlacks2012'] },
	'paintcorrectionbrightness' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalBrightness'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalBrightness'] },
	'paintcorrectionclarity' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity'] },
	'paintcorrectionclarity2012' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity2012'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity2012'] },
	'paintcorrectioncontrast' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast'] },
	'paintcorrectioncontrast2012' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast2012'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast2012'] },
	'paintcorrectioncorrectionname' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionName'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionName'] },
	'paintcorrectioncorrectionsyncid' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionSyncID'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionSyncID'] },
	'paintcorrectiondefringe' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalDefringe'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalDefringe'] },
	'paintcorrectiondehaze' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalDehaze'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalDehaze'] },
	'paintcorrectionexposure' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure'] },
	'paintcorrectionexposure2012' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure2012'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure2012'] },
	'paintcorrectionhighlights2012' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalHighlights2012'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalHighlights2012'] },
	'paintcorrectionhue' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalHue'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalHue'] },
	'paintcorrectionluminancenoise' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalLuminanceNoise'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalLuminanceNoise'] },
	'paintcorrectionmaskalpha' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAlpha'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAlpha'] },
	'paintcorrectionmaskangle' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAngle'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAngle'] },
	'paintcorrectionmaskbottom' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksBottom'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksBottom'] },
	'paintcorrectionmaskcentervalue' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterValue'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterValue'] },
	'paintcorrectionmaskcenterweight' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterWeight'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterWeight'] },
	'paintcorrectionmaskdabs' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksDabs'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksDabs'] },
	'paintcorrectionmaskfeather' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFeather'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFeather'] },
	'paintcorrectionmaskflipped' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlipped'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlipped'] },
	'paintcorrectionmaskflow' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlow'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlow'] },
	'paintcorrectionmaskfullx' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullX'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullX'] },
	'paintcorrectionmaskfully' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullY'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullY'] },
	'paintcorrectionmaskinputdigest' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksInputDigest'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksInputDigest'] },
	'paintcorrectionmaskleft' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksLeft'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksLeft'] },
	'paintcorrectionmaskmaskactive' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskActive'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskActive'] },
	'paintcorrectionmaskmaskblendmode' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskBlendMode'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskBlendMode'] },
	'paintcorrectionmaskmaskdigest' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskDigest'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskDigest'] },
	'paintcorrectionmaskmaskinverted' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskInverted'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskInverted'] },
	'paintcorrectionmaskmaskname' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskName'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskName'] },
	'paintcorrectionmaskmasks' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasks'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasks'] },
	'paintcorrectionmaskmasksalpha' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksAlpha'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksAlpha'] },
	'paintcorrectionmaskmasksangle' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksAngle'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksAngle'] },
	'paintcorrectionmaskmasksbottom' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksBottom'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksBottom'] },
	'paintcorrectionmaskmaskscentervalue' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksCenterValue'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksCenterValue'] },
	'paintcorrectionmaskmaskscenterweight' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksCenterWeight'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksCenterWeight'] },
	'paintcorrectionmaskmasksdabs' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksDabs'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksDabs'] },
	'paintcorrectionmaskmasksfeather' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFeather'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFeather'] },
	'paintcorrectionmaskmasksflipped' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFlipped'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFlipped'] },
	'paintcorrectionmaskmasksflow' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFlow'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFlow'] },
	'paintcorrectionmaskmasksfullx' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFullX'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFullX'] },
	'paintcorrectionmaskmasksfully' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFullY'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFullY'] },
	'paintcorrectionmaskmasksinputdigest' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksInputDigest'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksInputDigest'] },
	'paintcorrectionmaskmasksleft' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksLeft'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksLeft'] },
	'paintcorrectionmaskmasksmaskactive' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskActive'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskActive'] },
	'paintcorrectionmaskmasksmaskblendmode' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskBlendMode'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskBlendMode'] },
	'paintcorrectionmaskmasksmaskdigest' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskDigest'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskDigest'] },
	'paintcorrectionmaskmasksmaskinverted' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskInverted'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskInverted'] },
	'paintcorrectionmaskmasksmaskname' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskName'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskName'] },
	'paintcorrectionmaskmasksmasksubtype' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskSubType'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskSubType'] },
	'paintcorrectionmaskmasksmasksyncid' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskSyncID'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskSyncID'] },
	'paintcorrectionmaskmasksmaskversion' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskVersion'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskVersion'] },
	'paintcorrectionmaskmasksmidpoint' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMidpoint'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMidpoint'] },
	'paintcorrectionmaskmasksorigin' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksOrigin'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksOrigin'] },
	'paintcorrectionmaskmasksperimetervalue' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksPerimeterValue'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksPerimeterValue'] },
	'paintcorrectionmaskmasksradius' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksRadius'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksRadius'] },
	'paintcorrectionmaskmasksreferencepoint' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksReferencePoint'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksReferencePoint'] },
	'paintcorrectionmaskmasksright' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksRight'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksRight'] },
	'paintcorrectionmaskmasksroundness' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksRoundness'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksRoundness'] },
	'paintcorrectionmaskmaskssizex' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksSizeX'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksSizeX'] },
	'paintcorrectionmaskmaskssizey' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksSizeY'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksSizeY'] },
	'paintcorrectionmaskmaskstop' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksTop'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksTop'] },
	'paintcorrectionmaskmasksubtype' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskSubType'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskSubType'] },
	'paintcorrectionmaskmasksvalue' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskValue'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskValue'] },
	'paintcorrectionmaskmasksversion' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksVersion'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksVersion'] },
	'paintcorrectionmaskmaskswhat' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksWhat'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksWhat'] },
	'paintcorrectionmaskmaskswholeimagearea' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksWholeImageArea'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksWholeImageArea'] },
	'paintcorrectionmaskmasksx' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksX'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksX'] },
	'paintcorrectionmaskmasksy' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksY'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksY'] },
	'paintcorrectionmaskmasksyncid' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskSyncID'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskSyncID'] },
	'paintcorrectionmaskmaskszerox' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksZeroX'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksZeroX'] },
	'paintcorrectionmaskmaskszeroy' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksZeroY'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksZeroY'] },
	'paintcorrectionmaskmaskversion' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskVersion'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskVersion'] },
	'paintcorrectionmaskmidpoint' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMidpoint'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMidpoint'] },
	'paintcorrectionmaskorigin' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksOrigin'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksOrigin'] },
	'paintcorrectionmaskperimetervalue' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksPerimeterValue'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'paintcorrectionmaskradius' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRadius'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRadius'] },
	'paintcorrectionmaskrange' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMask'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMask'] },
	'paintcorrectionmaskrangeareamodels' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'] },
	'paintcorrectionmaskrangeareamodelscolorsampleinfo' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'paintcorrectionmaskrangeareamodelscomponents' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'] },
	'paintcorrectionmaskrangecoloramount' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'] },
	'paintcorrectionmaskrangedepthfeather' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'] },
	'paintcorrectionmaskrangedepthmax' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'] },
	'paintcorrectionmaskrangedepthmin' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'] },
	'paintcorrectionmaskrangeinvert' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'] },
	'paintcorrectionmaskrangelumfeather' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'] },
	'paintcorrectionmaskrangeluminancedepthsampleinfo' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'paintcorrectionmaskrangelummax' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'] },
	'paintcorrectionmaskrangelummin' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'] },
	'paintcorrectionmaskrangelumrange' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'] },
	'paintcorrectionmaskrangesampletype' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'] },
	'paintcorrectionmaskrangetype' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'] },
	'paintcorrectionmaskrangeversion' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'] },
	'paintcorrectionmaskreferencepoint' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksReferencePoint'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksReferencePoint'] },
	'paintcorrectionmaskright' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRight'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRight'] },
	'paintcorrectionmaskroundness' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRoundness'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRoundness'] },
	'paintcorrectionmasksizex' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeX'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeX'] },
	'paintcorrectionmasksizey' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeY'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeY'] },
	'paintcorrectionmasktop' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksTop'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksTop'] },
	'paintcorrectionmaskvalue' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskValue'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskValue'] },
	'paintcorrectionmaskversion' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksVersion'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksVersion'] },
	'paintcorrectionmaskwhat' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksWhat'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksWhat'] },
	'paintcorrectionmaskwholeimagearea' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksWholeImageArea'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksWholeImageArea'] },
	'paintcorrectionmaskx' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksX'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksX'] },
	'paintcorrectionmasky' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksY'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksY'] },
	'paintcorrectionmaskzerox' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroX'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroX'] },
	'paintcorrectionmaskzeroy' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroY'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroY'] },
	'paintcorrectionmoire' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalMoire'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalMoire'] },
	'paintcorrectionrangemask' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMask'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMask'] },
	'paintcorrectionrangemaskareamodels' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskAreaModels'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskAreaModels'] },
	'paintcorrectionrangemaskareamodelscolorsampleinfo' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'paintcorrectionrangemaskareamodelscomponents' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'] },
	'paintcorrectionrangemaskcoloramount' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskColorAmount'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskColorAmount'] },
	'paintcorrectionrangemaskdepthfeather' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskDepthFeather'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskDepthFeather'] },
	'paintcorrectionrangemaskdepthmax' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskDepthMax'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskDepthMax'] },
	'paintcorrectionrangemaskdepthmin' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskDepthMin'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskDepthMin'] },
	'paintcorrectionrangemaskinvert' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskInvert'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskInvert'] },
	'paintcorrectionrangemasklumfeather' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumFeather'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumFeather'] },
	'paintcorrectionrangemaskluminancedepthsampleinfo' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'paintcorrectionrangemasklummax' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumMax'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumMax'] },
	'paintcorrectionrangemasklummin' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumMin'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumMin'] },
	'paintcorrectionrangemasklumrange' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumRange'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumRange'] },
	'paintcorrectionrangemasksampletype' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskSampleType'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskSampleType'] },
	'paintcorrectionrangemasktype' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskType'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskType'] },
	'paintcorrectionrangemaskversion' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskVersion'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskVersion'] },
	'paintcorrectionsaturation' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSaturation'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSaturation'] },
	'paintcorrectionshadows2012' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalShadows2012'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalShadows2012'] },
	'paintcorrectionsharpness' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSharpness'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSharpness'] },
	'paintcorrectiontemperature' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTemperature'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTemperature'] },
	'paintcorrectiontexture' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTexture'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTexture'] },
	'paintcorrectiontint' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTint'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTint'] },
	'paintcorrectiontoninghue' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalToningHue'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalToningHue'] },
	'paintcorrectiontoningsaturation' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalToningSaturation'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalToningSaturation'] },
	'paintcorrectionwhat' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsWhat'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsWhat'] },
	'paintcorrectionwhites2012' => { 477 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalWhites2012'], 479 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalWhites2012'] },
	'panasonicdatetime' => { 323 => 0x0 },
	'panasonicexifversion' => { 320 => 0x26 },
	'panasonicimageheight' => { 320 => 0x4c },
	'panasonicimagewidth' => { 320 => 0x4b },
	'panasonicrawversion' => { 325 => 0x1 },
	'panasonictitle' => { 119 => 0xc6d2 },
	'panasonictitle2' => { 119 => 0xc6d3 },
	'panoramaangle' => { 127 => 0x1153 },
	'panoramacropbottom' => { 426 => 0x7 },
	'panoramacropleft' => { 426 => 0x4 },
	'panoramacropright' => { 426 => 0x6 },
	'panoramacroptop' => { 426 => 0x5 },
	'panoramadirection' => { 72 => 0x5, 127 => 0x1154, 426 => 0x3 },
	'panoramaframeheight' => { 426 => 0x9 },
	'panoramaframenumber' => { 72 => 0x2 },
	'panoramaframewidth' => { 426 => 0x8 },
	'panoramafullheight' => { 426 => 0x2 },
	'panoramafullwidth' => { 426 => 0x1 },
	'panoramamode' => { 140 => 0x3c, 297 => 0x601 },
	'panoramasize3d' => { 409 => 0x38 },
	'panoramasourceheight' => { 426 => 0xb },
	'panoramasourcewidth' => { 426 => 0xa },
	'panoramicstitchcameramotion' => { 176 => 'PanoramicStitchCameraMotion', 177 => 0x1 },
	'panoramicstitchmaptype' => { 176 => 'PanoramicStitchMapType', 177 => 0x2 },
	'panoramicstitchphi0' => { 176 => 'PanoramicStitchPhi0', 177 => 0x5 },
	'panoramicstitchphi1' => { 176 => 'PanoramicStitchPhi1', 177 => 0x6 },
	'panoramicstitchtheta0' => { 176 => 'PanoramicStitchTheta0', 177 => 0x3 },
	'panoramicstitchtheta1' => { 176 => 'PanoramicStitchTheta1', 177 => 0x4 },
	'panoramicstitchversion' => { 177 => 0x0 },
	'pantry' => { 504 => 'Pantry' },
	'pantryinstanceid' => { 504 => [\'Pantry','PantryInstanceID'] },
	'parallax' => { 127 => 0xb211, 296 => 0x28 },
	'parametricdarks' => { 477 => 'ParametricDarks', 479 => 'ParametricDarks' },
	'parametrichighlights' => { 477 => 'ParametricHighlights', 479 => 'ParametricHighlights' },
	'parametrichighlightsplit' => { 477 => 'ParametricHighlightSplit', 479 => 'ParametricHighlightSplit' },
	'parametriclights' => { 477 => 'ParametricLights', 479 => 'ParametricLights' },
	'parametricmidtonesplit' => { 477 => 'ParametricMidtoneSplit', 479 => 'ParametricMidtoneSplit' },
	'parametricshadows' => { 477 => 'ParametricShadows', 479 => 'ParametricShadows' },
	'parametricshadowsplit' => { 477 => 'ParametricShadowSplit', 479 => 'ParametricShadowSplit' },
	'parentalrating' => { 179 => 'WM/ParentalRating' },
	'parentmediaeventid' => { 467 => 'ParentMediaEventID' },
	'parentmeid' => { 467 => 'ParentMEID' },
	'parentproductid' => { 372 => '@ppi' },
	'parentreference1' => { 487 => [\'TagStructure','TagStructureParentReference'] },
	'parentreference2' => { 487 => [\'TagStructure','TagStructureSubLabelsParentReference'] },
	'parentreference3' => { 487 => [\'TagStructure','TagStructureSubLabelsSubLabelsParentReference'] },
	'parentreference4' => { 487 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsParentReference'] },
	'parentreference5' => { 487 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsParentReference'] },
	'parentreference6' => { 487 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsParentReference'] },
	'parentshorttitle' => { 372 => '@PST' },
	'parenttitle' => { 372 => '@pti' },
	'partialactivecols1' => { 138 => 0x17e8 },
	'partialactivecols2' => { 138 => 0x17f2 },
	'partialactiverows1' => { 138 => 0x17fc },
	'partialactiverows2' => { 138 => 0x1806 },
	'partofcompilation' => { 503 => 'partOfCompilation' },
	'patientbirthdate' => { 456 => 'PatientDOB' },
	'patientid' => { 456 => 'PatientID' },
	'patientname' => { 456 => 'PatientName' },
	'patientsex' => { 456 => 'PatientSex' },
	'patternareaheight' => { 138 => 0x963 },
	'patternareawidth' => { 138 => 0x962 },
	'patterncorrectionfactorscale' => { 138 => 0x969 },
	'patterncropcols1' => { 138 => 0x96c },
	'patterncropcols2' => { 138 => 0x96d },
	'patterncroprows1' => { 138 => 0x96a },
	'patterncroprows2' => { 138 => 0x96b },
	'patternimagerheight' => { 138 => 0x961 },
	'patternimagerwidth' => { 138 => 0x960 },
	'patternx' => { 138 => 0x966 },
	'patterny' => { 138 => 0x967 },
	'pdfversion' => { 490 => 'PDFVersion' },
	'pentaximagesize' => { 355 => 0x9 },
	'pentaxmodelid' => { 335 => 0x0, 355 => 0x5 },
	'pentaxmodeltype' => { 355 => 0x1 },
	'pentaxversion' => { 355 => 0x0 },
	'people' => { 458 => 'People', 470 => 'People' },
	'perchannelblacklevel' => { 41 => 0x157, 42 => 0x16b, 44 => 0xc4, 45 => [0x2b4,0x2cb,0x2cf], 46 => [0x108,0x14d], 47 => 0x1df, 48 => [0x1f8,0x2d8], 49 => [0x22c,0x30a], 50 => 0x149 },
	'performer' => { 372 => 'perf', 380 => 'perf' },
	'performerkeywords' => { 380 => "\xa9prk" },
	'performers' => { 380 => "\xa9prf" },
	'performerurl' => { 380 => "\xa9prl" },
	'period' => { 179 => 'WM/Period' },
	'peripheralillumcentralradius' => { 454 => 0x8030 },
	'peripheralillumcentralvalue' => { 454 => 0x8031 },
	'peripheralillumination' => { 103 => 0x20702, 109 => 0x68 },
	'peripheralilluminationcorr' => { 62 => 0x1, 345 => 0x2 },
	'peripheralilluminationon' => { 103 => '0x20702.0', 109 => 0x64 },
	'peripheralillumperiphvalue' => { 454 => 0x8032 },
	'peripherallighting' => { 79 => 0x2, 127 => 0x3804 },
	'peripherallightingsetting' => { 80 => 0x5 },
	'peripherallightingvalue' => { 79 => 0x6 },
	'permissions' => { 496 => 'permissions' },
	'permits' => { 475 => 'permits' },
	'person' => { 493 => 'person' },
	'personality' => { 467 => 'Personality' },
	'personheard' => { 489 => 'PersonHeard' },
	'personheardidentifier' => { 489 => [\'PersonHeard','PersonHeardIdentifier'] },
	'personheardname' => { 489 => [\'PersonHeard','PersonHeardName'] },
	'personinimage' => { 489 => 'PersonInImage' },
	'personinimagecharacteristic' => { 489 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristic'] },
	'personinimagecvtermcvid' => { 489 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvId'] },
	'personinimagecvtermid' => { 489 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermId'] },
	'personinimagecvtermname' => { 489 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermName'] },
	'personinimagecvtermrefinedabout' => { 489 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermRefinedAbout'] },
	'personinimagedescription' => { 489 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonDescription'] },
	'personinimageid' => { 489 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonId'] },
	'personinimagename' => { 489 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonName'] },
	'personinimagewdetails' => { 489 => 'PersonInImageWDetails' },
	'perspectiveaspect' => { 477 => 'PerspectiveAspect', 479 => 'PerspectiveAspect' },
	'perspectivehorizontal' => { 477 => 'PerspectiveHorizontal', 479 => 'PerspectiveHorizontal' },
	'perspectiverotate' => { 477 => 'PerspectiveRotate', 479 => 'PerspectiveRotate' },
	'perspectivescale' => { 477 => 'PerspectiveScale', 479 => 'PerspectiveScale' },
	'perspectiveupright' => { 477 => 'PerspectiveUpright', 479 => 'PerspectiveUpright' },
	'perspectivevertical' => { 477 => 'PerspectiveVertical', 479 => 'PerspectiveVertical' },
	'perspectivex' => { 477 => 'PerspectiveX', 479 => 'PerspectiveX' },
	'perspectivey' => { 477 => 'PerspectiveY', 479 => 'PerspectiveY' },
	'pf0customfuncregistration' => { 92 => 0x1 },
	'pf10retainprogramshift' => { 92 => 0xb },
	'pf13drivepriority' => { 92 => 0xe },
	'pf14disablefocussearch' => { 92 => 0xf },
	'pf15disableafassistbeam' => { 92 => 0x10 },
	'pf16autofocuspointshoot' => { 92 => 0x11 },
	'pf17disableafpointsel' => { 92 => 0x12 },
	'pf18enableautoafpointsel' => { 92 => 0x13 },
	'pf19continuousshootspeed' => { 92 => 0x14 },
	'pf19shootingspeedhigh' => { 91 => 0xa },
	'pf19shootingspeedlow' => { 91 => 0x9 },
	'pf1disableshootingmodes' => { 92 => 0x2 },
	'pf1value' => { 91 => 0x1 },
	'pf20limitcontinousshots' => { 92 => 0x15 },
	'pf20maxcontinousshots' => { 91 => 0xb },
	'pf21enablequietoperation' => { 92 => 0x16 },
	'pf23felocktime' => { 91 => 0xd },
	'pf23postreleasetime' => { 91 => 0xe },
	'pf23settimerlengths' => { 92 => 0x18 },
	'pf23shutterbuttontime' => { 91 => 0xc },
	'pf24lightlcdduringbulb' => { 92 => 0x19 },
	'pf25aemode' => { 91 => 0xf },
	'pf25afmode' => { 91 => 0x12 },
	'pf25afpointsel' => { 91 => 0x13 },
	'pf25colormatrix' => { 91 => 0x17 },
	'pf25defaultclearsettings' => { 92 => 0x1a },
	'pf25drivemode' => { 91 => 0x11 },
	'pf25imagesize' => { 91 => 0x14 },
	'pf25meteringmode' => { 91 => 0x10 },
	'pf25parameters' => { 91 => 0x16 },
	'pf25wbmode' => { 91 => 0x15 },
	'pf26shortenreleaselag' => { 92 => 0x1b },
	'pf27reversedialrotation' => { 92 => 0x1c },
	'pf27value' => { 91 => 0x18 },
	'pf28noquickdialexpcomp' => { 92 => 0x1d },
	'pf29quickdialswitchoff' => { 92 => 0x1e },
	'pf2disablemeteringmodes' => { 92 => 0x3 },
	'pf2value' => { 91 => 0x2 },
	'pf30enlargementmode' => { 92 => 0x1f },
	'pf31originaldecisiondata' => { 92 => 0x20 },
	'pf3manualexposuremetering' => { 92 => 0x4 },
	'pf3value' => { 91 => 0x3 },
	'pf4exposuretimelimits' => { 92 => 0x5 },
	'pf4exposuretimemax' => { 91 => 0x5 },
	'pf4exposuretimemin' => { 91 => 0x4 },
	'pf5aperturelimits' => { 92 => 0x6 },
	'pf5aperturemax' => { 91 => 0x7 },
	'pf5aperturemin' => { 91 => 0x6 },
	'pf6presetshootingmodes' => { 92 => 0x7 },
	'pf7bracketcontinuousshoot' => { 92 => 0x8 },
	'pf8bracketshots' => { 91 => 0x8 },
	'pf8setbracketshots' => { 92 => 0x9 },
	'pf9changebracketsequence' => { 92 => 0xa },
	'phasedetectaf' => { 193 => 0x6 },
	'phonenumber' => { 157 => 'Phone' },
	'photoeffect' => { 34 => 0x28 },
	'photoeffecthistoryxml' => { 272 => 0xe9651831 },
	'photoeffects' => { 272 => 0xab5eca5e },
	'photoeffectsblue' => { 274 => 0x8 },
	'photoeffectsgreen' => { 274 => 0x6 },
	'photoeffectsred' => { 274 => 0x4 },
	'photoeffectstype' => { 274 => 0x0 },
	'photographicsensitivity' => { 484 => 'PhotographicSensitivity' },
	'photoinfoplayback' => { 279 => '17.6', 288 => '33.6' },
	'photometricinterpretation' => { 119 => 0x106, 499 => 'PhotometricInterpretation' },
	'photoshootingmenubank' => { 229 => 0x112, 248 => 0xe7d, 258 => 0xfbd },
	'photoshootingmenubankimagearea' => { 229 => 0x134, 248 => '3716.1', 258 => 0x791 },
	'photoshopbgrthumbnail' => { 369 => 0x409 },
	'photoshopquality' => { 368 => 0x0 },
	'photoshopthumbnail' => { 369 => 0x40c },
	'photostyle' => { 320 => 0x89 },
	'picklabel' => { 482 => 'PickLabel' },
	'pictinfo' => { 396 => 0x208 },
	'picturecontrol' => { 272 => 0xe2173c47 },
	'picturecontrolactive' => { 275 => 0x0 },
	'picturecontroladjust' => { 231 => 0x30, 232 => 0x30, 233 => 0x36 },
	'picturecontrolbase' => { 231 => 0x18, 232 => 0x18, 233 => 0x1c },
	'picturecontroldata' => { 226 => [0xbd,0x23] },
	'picturecontrolmode' => { 275 => 0x13 },
	'picturecontrolname' => { 231 => 0x4, 232 => 0x4, 233 => 0x8 },
	'picturecontrolquickadjust' => { 231 => 0x31, 232 => 0x31, 233 => 0x37 },
	'pictureeffect' => { 420 => 0x200e },
	'pictureeffect2' => { 428 => 0x1163, 429 => 0x1167, 430 => 0x1143, 431 => 0x11bf, 432 => 0x119b, 433 => 0x1053, 434 => 0x24b, 435 => 0x24b, 436 => 0x23c, 450 => 0x46 },
	'picturefinish' => { 182 => 0x71 },
	'picturemode' => { 127 => 0x1031, 297 => 0x520, 355 => [0xb,0x33], 397 => 0x3d },
	'picturemode2' => { 336 => 0x0 },
	'picturemodebwfilter' => { 297 => 0x525 },
	'picturemodecontrast' => { 297 => 0x523 },
	'picturemodeeffect' => { 297 => 0x52d },
	'picturemodehue' => { 297 => 0x522 },
	'picturemodesaturation' => { 297 => 0x521 },
	'picturemodesharpness' => { 297 => 0x524 },
	'picturemodetone' => { 297 => 0x526 },
	'pictureprofile' => { 428 => [0x115e,0x115f], 429 => [0x1162,0x1163], 430 => [0x113e,0x113f], 431 => [0x11ba,0x11bb], 432 => [0x1196,0x1197], 433 => [0x104e,0x104f], 434 => [0x246,0x247], 435 => [0x246,0x247], 436 => [0x237,0x238] },
	'picturestyle' => { 8 => [0x4b,0x51], 9 => 0xf4, 10 => 0x6c, 11 => 0x86, 12 => 0x73, 16 => 0xab, 17 => 0xa7, 18 => 0xb0, 19 => 0x6c, 20 => 0xa7, 21 => 0xf4, 22 => 0xb3, 24 => 0xf4, 25 => 0xfa, 27 => 0x169, 74 => 0xa, 103 => 0x20301, 109 => 0x2 },
	'picturestylepc' => { 64 => 0x4009 },
	'picturestyleuserdef' => { 64 => 0x4008 },
	'picturewizard' => { 394 => 0x21 },
	'picturewizardcolor' => { 393 => 0x1 },
	'picturewizardcontrast' => { 393 => 0x4 },
	'picturewizardmode' => { 393 => 0x0 },
	'picturewizardsaturation' => { 393 => 0x2 },
	'picturewizardsharpness' => { 393 => 0x3 },
	'pipelineversion' => { 176 => 'PipelineVersion' },
	'pitch' => { 115 => 0x6, 280 => '4.1', 292 => '4.1', 380 => ['ptch',"\xa9fpt"] },
	'pitchangle' => { 247 => 0x350f, 248 => 0x2c28, 252 => 0xc21e, 257 => 0x36f8, 258 => 0x2eff, 260 => 0xce36, 261 => 0xeaef, 297 => 0x904, 320 => 0x91, 354 => 0x2, 392 => 0x1 },
	'pitchshift' => { 374 => 'player.movie.audio.pitchshift' },
	'pixelaspectratio' => { 373 => 'pasp' },
	'pixelclockfrequency' => { 138 => 0x40b },
	'pixelcorrectionoffset' => { 138 => 0x972 },
	'pixelcorrectionscale' => { 138 => 0x971 },
	'pixelscale' => { 119 => 0x830e },
	'pixelshiftinfo' => { 420 => 0x202f },
	'pixelshiftoffset' => { 127 => 0x1106 },
	'pixelshiftresolution' => { 356 => 0x0 },
	'pixelshiftshots' => { 127 => 0x1105 },
	'pixelsperunitx' => { 309 => 0x0 },
	'pixelsperunity' => { 309 => 0x4 },
	'pixelunits' => { 309 => 0x8 },
	'planarconfiguration' => { 119 => 0x11c, 499 => 'PlanarConfiguration' },
	'plane' => { 457 => [\'Planes','PlanesPlane'] },
	'planeboundary' => { 457 => [\'Planes','PlanesPlaneBoundary'] },
	'planeboundaryvertexcount' => { 457 => [\'Planes','PlanesPlaneBoundaryVertexCount'] },
	'planeextentx' => { 457 => [\'Planes','PlanesPlaneExtentX'] },
	'planeextentz' => { 457 => [\'Planes','PlanesPlaneExtentZ'] },
	'planepose' => { 457 => [\'Planes','PlanesPlanePose'] },
	'planeposepositionx' => { 457 => [\'Planes','PlanesPlanePosePositionX'] },
	'planeposepositiony' => { 457 => [\'Planes','PlanesPlanePosePositionY'] },
	'planeposepositionz' => { 457 => [\'Planes','PlanesPlanePosePositionZ'] },
	'planeposerotationw' => { 457 => [\'Planes','PlanesPlanePoseRotationW'] },
	'planeposerotationx' => { 457 => [\'Planes','PlanesPlanePoseRotationX'] },
	'planeposerotationy' => { 457 => [\'Planes','PlanesPlanePoseRotationY'] },
	'planeposerotationz' => { 457 => [\'Planes','PlanesPlanePoseRotationZ'] },
	'planeposetimestamp' => { 457 => [\'Planes','PlanesPlanePoseTimestamp'] },
	'planes' => { 457 => 'Planes' },
	'planningref' => { 489 => 'PlanningRef' },
	'planningrefidentifier' => { 489 => [\'PlanningRef','PlanningRefIdentifier'] },
	'planningrefname' => { 489 => [\'PlanningRef','PlanningRefName'] },
	'planningrefrole' => { 489 => [\'PlanningRef','PlanningRefRole'] },
	'platenames' => { 508 => 'PlateNames' },
	'platform' => { 493 => 'platform' },
	'playallframes' => { 380 => 'AllF' },
	'playbackflickdown' => { 295 => 0x159 },
	'playbackflickup' => { 295 => 0x155 },
	'playbackmenustime' => { 284 => '20.1', 285 => '21.1', 286 => '21.1' },
	'playbackmonitorofftime' => { 279 => '25.2', 280 => '36.1', 282 => '36.1', 283 => '36.1', 287 => '35.1', 288 => '8.1', 289 => '35.1', 292 => '36.1', 293 => '36.1', 294 => '21.1', 295 => 0x33 },
	'playbackzoom' => { 280 => '37.1' },
	'playdisplay' => { 184 => 0x4e },
	'playerversion' => { 374 => 'player.version' },
	'playgap' => { 372 => 'pgap' },
	'playlistid' => { 372 => 'plID' },
	'playmode' => { 380 => 'SDLN' },
	'playselection' => { 380 => 'SelO' },
	'plusversion' => { 307 => 'Version' },
	'pmversion' => { 367 => 'PMVersion' },
	'pngwarning' => { 310 => 'Warning' },
	'podcast' => { 372 => 'pcst' },
	'podcasturl' => { 372 => 'purl' },
	'poilevel' => { 225 => 0x8 },
	'portraitimpressionbalance' => { 260 => 0x7fa0 },
	'portraitnote' => { 460 => 'PortraitNote' },
	'portraitoutputhighlightpoint' => { 109 => 0x1d },
	'portraitoutputshadowpoint' => { 109 => 0x1e },
	'portraitrawcolortone' => { 109 => 0x16 },
	'portraitrawcontrast' => { 109 => 0x18 },
	'portraitrawhighlight' => { 109 => 0x76 },
	'portraitrawhighlightpoint' => { 109 => 0x1b },
	'portraitrawlinear' => { 109 => 0x19 },
	'portraitrawsaturation' => { 109 => 0x17 },
	'portraitrawshadow' => { 109 => 0x7f },
	'portraitrawshadowpoint' => { 109 => 0x1c },
	'portraitrawsharpness' => { 109 => 0x1a },
	'portraitrefiner' => { 113 => 0x302b },
	'portraitrequest' => { 460 => 'PortraitRequest' },
	'portraitunsharpmaskfineness' => { 109 => 0x9a },
	'portraitunsharpmaskstrength' => { 109 => 0x98 },
	'portraitunsharpmaskthreshold' => { 109 => 0x9c },
	'portraitversion' => { 460 => 'PortraitVersion' },
	'pose' => { 457 => 'Pose' },
	'poseheadingdegrees' => { 465 => 'PoseHeadingDegrees' },
	'posepitchdegrees' => { 465 => 'PosePitchDegrees' },
	'posepositionx' => { 457 => [\'Pose','PosePositionX'] },
	'posepositiony' => { 457 => [\'Pose','PosePositionY'] },
	'posepositionz' => { 457 => [\'Pose','PosePositionZ'] },
	'poserolldegrees' => { 465 => 'PoseRollDegrees' },
	'poserotationw' => { 457 => [\'Pose','PoseRotationW'] },
	'poserotationx' => { 457 => [\'Pose','PoseRotationX'] },
	'poserotationy' => { 457 => [\'Pose','PoseRotationY'] },
	'poserotationz' => { 457 => [\'Pose','PoseRotationZ'] },
	'posetimestamp' => { 457 => [\'Pose','PoseTimestamp'] },
	'positiondescriptor' => { 492 => 'positionDescriptor' },
	'postalcode' => { 161 => 'PostalCode' },
	'postcropvignetteamount' => { 477 => 'PostCropVignetteAmount', 479 => 'PostCropVignetteAmount' },
	'postcropvignettefeather' => { 477 => 'PostCropVignetteFeather', 479 => 'PostCropVignetteFeather' },
	'postcropvignettehighlightcontrast' => { 477 => 'PostCropVignetteHighlightContrast', 479 => 'PostCropVignetteHighlightContrast' },
	'postcropvignettemidpoint' => { 477 => 'PostCropVignetteMidpoint', 479 => 'PostCropVignetteMidpoint' },
	'postcropvignetteroundness' => { 477 => 'PostCropVignetteRoundness', 479 => 'PostCropVignetteRoundness' },
	'postcropvignettestyle' => { 477 => 'PostCropVignetteStyle', 479 => 'PostCropVignetteStyle' },
	'postfocusmerging' => { 320 => 0xbf },
	'potentialface1position' => { 417 => 0xb },
	'potentialface2position' => { 417 => 0x15 },
	'potentialface3position' => { 417 => 0x1f },
	'potentialface4position' => { 417 => 0x29 },
	'potentialface5position' => { 417 => 0x33 },
	'potentialface6position' => { 417 => 0x3d },
	'potentialface7position' => { 417 => 0x47 },
	'potentialface8position' => { 417 => 0x51 },
	'powersource' => { 334 => '0.1' },
	'poweruptime' => { 226 => 0xb6 },
	'preaf' => { 126 => '0.2' },
	'precaptureframes' => { 302 => 0x300 },
	'predictor' => { 119 => 0x13d },
	'preflashreturnstrength' => { 245 => 0x28a },
	'prefs' => { 131 => 0xdd, 367 => 'Prefs' },
	'prereadfastresetcount' => { 138 => 0x187e },
	'preservedfilename' => { 504 => 'PreservedFileName' },
	'preservedspecimen' => { 118 => 'PreservedSpecimen' },
	'preservedspecimenmaterialsampleid' => { 118 => [\'PreservedSpecimen','PreservedSpecimenMaterialSampleID'] },
	'presettype' => { 477 => 'PresetType', 479 => 'PresetType' },
	'presetwhitebalance' => { 184 => 0x24, 454 => 0x8002 },
	'presetwhitebalanceadj' => { 454 => 0x8014 },
	'pressure' => { 119 => 0x9402, 484 => 'Pressure' },
	'previewapplicationname' => { 119 => 0xc716 },
	'previewapplicationversion' => { 119 => 0xc717 },
	'previewbutton' => { 279 => ['14.1','15.1'], 280 => '15.1', 282 => '15.1', 283 => '15.1', 288 => '29.1', 289 => '14.1', 292 => '15.1', 293 => '15.1' },
	'previewbuttonplusdials' => { 279 => ['14.2','15.2'], 280 => '15.2', 282 => '43.1', 283 => '43.1', 288 => '31.2', 292 => '43.1', 293 => '43.1' },
	'previewcolorspace' => { 119 => 0xc71a },
	'previewcropbottom' => { 366 => 0xef },
	'previewcropleft' => { 366 => 0xec },
	'previewcropright' => { 366 => 0xee },
	'previewcroptop' => { 366 => 0xed },
	'previewdate' => { 378 => 0x0 },
	'previewdatetime' => { 119 => 0xc71b },
	'previewimage' => { 113 => 0x2000, 114 => 'Exif-PreviewImage', 120 => 'PreviewImage', 122 => 0x4, 166 => 'data', 186 => 0x81, 302 => 0x280, 318 => 0x300, 380 => 'mcvr', 420 => 0x2001 },
	'previewimageborders' => { 355 => 0x3e },
	'previewimageheight' => { 73 => 0x4, 142 => 0xfa58 },
	'previewimagelength' => { 73 => 0x2, 113 => 0x3, 119 => [0x117,0x202], 186 => 0x89, 234 => 0x202, 297 => 0x102, 302 => 0x1037, 355 => 0x3, 386 => 0x1e, 391 => 0x3, 397 => [0x1b,0x1d], 410 => 0x202 },
	'previewimagename' => { 166 => '1Name' },
	'previewimagesize' => { 113 => 0x2, 147 => 0x2, 166 => 'ImageSize', 355 => 0x2, 397 => [0x1c,0x1e], 420 => 0xb02c, 454 => 0x9012 },
	'previewimagestart' => { 73 => 0x5, 113 => 0x4, 119 => [0x111,0x201], 186 => 0x88, 234 => 0x201, 297 => 0x101, 302 => 0x1036, 355 => 0x4, 386 => 0x1c, 391 => 0x2, 397 => [0x1a,0x1c], 410 => 0x201 },
	'previewimagetype' => { 166 => '0Type' },
	'previewimagevalid' => { 297 => 0x100, 302 => 0x1035 },
	'previewimagewidth' => { 73 => 0x3, 142 => 0xfa57 },
	'previewquality' => { 73 => 0x1 },
	'previewsettingsdigest' => { 119 => 0xc719 },
	'previewsettingsname' => { 119 => 0xc718 },
	'primaryafpoint' => { 193 => [0x38,0x44,0x7] },
	'primarychromaticities' => { 119 => 0x13f, 499 => 'PrimaryChromaticities' },
	'primaryftp' => { 467 => 'PrimaryFTP' },
	'primaryslot' => { 248 => 0xe7f, 258 => 0xfbf },
	'printim' => { 119 => 0xc4a5 },
	'prioritysetinawb' => { 420 => 0x202b },
	'prioritysetupshutterrelease' => { 184 => 0x1d, 407 => 0x28 },
	'privatertkinfo' => { 469 => 'privateRTKInfo' },
	'processbordercolsleft' => { 138 => 0xc61 },
	'processbordercolsright' => { 138 => 0xc62 },
	'processborderrowsbottom' => { 138 => 0xc64 },
	'processborderrowstop' => { 138 => 0xc63 },
	'processingsoftware' => { 119 => 0xb },
	'processversion' => { 477 => 'ProcessVersion', 479 => 'ProcessVersion' },
	'producer' => { 179 => 'WM/Producer', 306 => 'Producer', 372 => "\xa9prd", 374 => 'producer', 380 => "\xa9prd", 490 => 'Producer' },
	'producerkeywords' => { 380 => "\xa9pdk" },
	'productcode' => { 493 => 'productCode' },
	'productid' => { 132 => 0x32, 372 => 'prID', 492 => 'productID' },
	'productidtype' => { 492 => 'productIDType' },
	'productinimage' => { 489 => 'ProductInImage' },
	'productinimagedescription' => { 489 => [\'ProductInImage','ProductInImageProductDescription'] },
	'productinimagegtin' => { 489 => [\'ProductInImage','ProductInImageProductGTIN'] },
	'productinimagename' => { 489 => [\'ProductInImage','ProductInImageProductName'] },
	'productioncode' => { 335 => 0x2 },
	'productorserviceconstraints' => { 307 => 'ProductOrServiceConstraints' },
	'productversion' => { 372 => 'VERS' },
	'profession' => { 493 => 'profession' },
	'profile' => { 457 => [\'Profiles','ProfilesProfile'] },
	'profilecalibrationsig' => { 119 => 0xc6f4 },
	'profilecameraindices' => { 457 => [\'Profiles','ProfilesProfileCameraIndices'] },
	'profilecopyright' => { 119 => 0xc6fe },
	'profileembedpolicy' => { 119 => 0xc6fd },
	'profilegaintablemap' => { 119 => 0xcd2d },
	'profilehuesatmapdata1' => { 119 => 0xc6fa },
	'profilehuesatmapdata2' => { 119 => 0xc6fb },
	'profilehuesatmapdata3' => { 119 => 0xcd39 },
	'profilehuesatmapdims' => { 119 => 0xc6f9 },
	'profilehuesatmapencoding' => { 119 => 0xc7a3 },
	'profilelooktabledata' => { 119 => 0xc726 },
	'profilelooktabledims' => { 119 => 0xc725 },
	'profilelooktableencoding' => { 119 => 0xc7a4 },
	'profilename' => { 119 => 0xc6f8, 308 => 'iCCP-name' },
	'profiles' => { 457 => 'Profiles' },
	'profiletonecurve' => { 119 => 0xc6fc },
	'profiletype' => { 457 => [\'Profiles','ProfilesProfileType'] },
	'programiso' => { 320 => 0x3c },
	'programline' => { 336 => '1.1' },
	'programmode' => { 189 => 0x5 },
	'programshift' => { 226 => 0xd },
	'programversion' => { 131 => 0x46 },
	'prohibits' => { 475 => 'prohibits' },
	'projectiontype' => { 465 => 'ProjectionType', 466 => 'ProjectionType' },
	'projectname' => { 503 => 'projectName' },
	'projectref' => { 503 => 'projectRef' },
	'projectrefpath' => { 503 => [\'projectRef','projectRefPath'] },
	'projectreftype' => { 503 => [\'projectRef','projectRefType'] },
	'promotionurl' => { 179 => 'WM/PromotionURL' },
	'propertyreleaseid' => { 307 => 'PropertyReleaseID' },
	'propertyreleasestatus' => { 307 => 'PropertyReleaseStatus' },
	'provider' => { 179 => 'WM/Provider' },
	'province-state' => { 131 => 0x5f },
	'publicationdate' => { 493 => 'publicationDate' },
	'publicationdatea-platform' => { 493 => [\'publicationDate','publicationDateA-platform'] },
	'publicationdatedate' => { 493 => [\'publicationDate','publicationDateDate'] },
	'publicationdisplaydate' => { 493 => 'publicationDisplayDate' },
	'publicationdisplaydatea-platform' => { 493 => [\'publicationDisplayDate','publicationDisplayDateA-platform'] },
	'publicationdisplaydatedate' => { 493 => [\'publicationDisplayDate','publicationDisplayDateDate'] },
	'publicationevent' => { 489 => 'PublicationEvent' },
	'publicationeventdate' => { 489 => [\'PublicationEvent','PublicationEventDate'] },
	'publicationeventidentifier' => { 489 => [\'PublicationEvent','PublicationEventIdentifier'] },
	'publicationeventname' => { 489 => [\'PublicationEvent','PublicationEventName'] },
	'publicationname' => { 493 => 'publicationName' },
	'publisher' => { 179 => 'WM/Publisher', 372 => "\xa9pub", 374 => 'publisher', 480 => 'publisher' },
	'publishingfrequency' => { 493 => 'publishingFrequency' },
	'pulldown' => { 503 => 'pullDown' },
	'purchasedate' => { 372 => 'purd' },
	'purplehsl' => { 103 => 0x20916 },
	'pxshiftperiphedgenr' => { 454 => 0x9013 },
	'pxshiftperiphedgenrvalue' => { 454 => 0x9014 },
	'quality' => { 0 => 0x1, 34 => 0x3, 112 => 0x2, 113 => 0x3002, 127 => 0x1000, 140 => 0x9, 226 => 0x4, 262 => 0x3, 302 => 0x201, 315 => 0x300, 355 => 0x8, 362 => 0x2, 397 => 0x16, 407 => 0x56, 408 => 0x56, 409 => 0xb, 420 => [0x102,0x202e] },
	'quality2' => { 428 => 0x1170, 429 => 0x1174, 430 => 0x1150, 432 => 0x11a8, 433 => 0x1060, 434 => 0x258, 435 => 0x258, 436 => 0x247, 441 => 0x29, 442 => 0x25, 443 => 0x2a },
	'qualitybutton' => { 295 => 0x17d },
	'qualitybuttonplaybackmode' => { 295 => 0x1bf },
	'qualitymode' => { 113 => 0x8 },
	'quantizationmethod' => { 133 => 0x78 },
	'quickadjust' => { 275 => 0x2a },
	'quickcontroldialinmeter' => { 84 => 0x703 },
	'quickfix' => { 272 => 0x416391c6 },
	'quickshot' => { 396 => 0x213 },
	'quiettime' => { 138 => 0x188a },
	'rads' => { 380 => 'rads' },
	'rangefinder' => { 284 => '4.1', 285 => '5.1', 286 => '5.1' },
	'rangemask' => { 477 => 'RangeMaskMapInfo', 479 => 'RangeMaskMapInfo' },
	'rangemaskmapinfo' => { 477 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfo'], 479 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfo'] },
	'rangemaskmapinfolabmax' => { 477 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoLabMax'], 479 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoLabMax'] },
	'rangemaskmapinfolabmin' => { 477 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoLabMin'], 479 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoLabMin'] },
	'rangemaskmapinfolumeq' => { 477 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoLumEq'], 479 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoLumEq'] },
	'rangemaskmapinforgbmax' => { 477 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoRGBMax'], 479 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoRGBMax'] },
	'rangemaskmapinforgbmin' => { 477 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoRGBMin'], 479 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoRGBMin'] },
	'rasterizedcaption' => { 131 => 0x7d },
	'rating' => { 119 => 0x4746, 127 => 0x1431, 366 => 0xdf, 372 => 'rtng', 380 => 'rtng', 420 => 0x2002, 472 => 'rating', 481 => 'rating', 489 => 'Rating', 493 => 'rating', 501 => 'Rating' },
	'ratingpercent' => { 119 => 0x4749, 178 => 'Rating', 372 => 'rate', 501 => 'RatingPercent' },
	'ratingregion' => { 489 => [\'Rating','RatingRatingRegion'] },
	'ratingregioncity' => { 489 => [\'Rating','RatingRatingRegionCity'] },
	'ratingregioncountrycode' => { 489 => [\'Rating','RatingRatingRegionCountryCode'] },
	'ratingregioncountryname' => { 489 => [\'Rating','RatingRatingRegionCountryName'] },
	'ratingregiongpsaltitude' => { 489 => [\'Rating','RatingRatingRegionGPSAltitude'] },
	'ratingregiongpslatitude' => { 489 => [\'Rating','RatingRatingRegionGPSLatitude'] },
	'ratingregiongpslongitude' => { 489 => [\'Rating','RatingRatingRegionGPSLongitude'] },
	'ratingregionidentifier' => { 489 => [\'Rating','RatingRatingRegionIdentifier'] },
	'ratingregionlocationid' => { 489 => [\'Rating','RatingRatingRegionLocationId'] },
	'ratingregionlocationname' => { 489 => [\'Rating','RatingRatingRegionLocationName'] },
	'ratingregionprovincestate' => { 489 => [\'Rating','RatingRatingRegionProvinceState'] },
	'ratingregionsublocation' => { 489 => [\'Rating','RatingRatingRegionSublocation'] },
	'ratingregionworldregion' => { 489 => [\'Rating','RatingRatingRegionWorldRegion'] },
	'ratingscalemaxvalue' => { 489 => [\'Rating','RatingRatingScaleMaxValue'] },
	'ratingscaleminvalue' => { 489 => [\'Rating','RatingRatingScaleMinValue'] },
	'ratingsourcelink' => { 489 => [\'Rating','RatingRatingSourceLink'] },
	'ratingvalue' => { 489 => [\'Rating','RatingRatingValue'] },
	'ratingvaluelogolink' => { 489 => [\'Rating','RatingRatingValueLogoLink'] },
	'rawandjpgrecording' => { 82 => 0x8, 186 => 0x109, 336 => 0xd },
	'rawbrightnessadj' => { 103 => 0x20001, 108 => 0x38 },
	'rawburstimagecount' => { 75 => 0x2 },
	'rawburstimagenum' => { 75 => 0x1 },
	'rawcoloradj' => { 108 => 0x2e },
	'rawcropbottom' => { 366 => 0xd4 },
	'rawcropleft' => { 366 => 0xd1 },
	'rawcropright' => { 366 => 0xd3 },
	'rawcroptop' => { 366 => 0xd2 },
	'rawcustomsaturation' => { 108 => 0x30 },
	'rawcustomtone' => { 108 => 0x34 },
	'rawdata' => { 394 => 0xa048 },
	'rawdatabyteorder' => { 394 => 0x40 },
	'rawdatacfapattern' => { 394 => 0x50 },
	'rawdatauniqueid' => { 119 => 0xc65d },
	'rawdepth' => { 188 => 0x10 },
	'rawdevartfilter' => { 304 => 0x121 },
	'rawdevautogradation' => { 304 => 0x119 },
	'rawdevcolorspace' => { 303 => 0x108, 304 => 0x109 },
	'rawdevcontrastvalue' => { 303 => 0x106, 304 => 0x105 },
	'rawdeveditstatus' => { 303 => 0x10b },
	'rawdevelopmentprocess' => { 355 => 0x62 },
	'rawdevengine' => { 303 => 0x109, 304 => 0x10b },
	'rawdevexposurebiasvalue' => { 303 => 0x100, 304 => 0x100 },
	'rawdevgradation' => { 304 => 0x112 },
	'rawdevgraypoint' => { 303 => 0x103, 304 => 0x104 },
	'rawdevmemorycoloremphasis' => { 303 => 0x105, 304 => 0x108 },
	'rawdevnoisereduction' => { 303 => 0x10a, 304 => 0x10a },
	'rawdevpicturemode' => { 304 => 0x10c },
	'rawdevpm_bwfilter' => { 304 => 0x110 },
	'rawdevpmcontrast' => { 304 => 0x10e },
	'rawdevpmnoisefilter' => { 304 => 0x120 },
	'rawdevpmpicturetone' => { 304 => 0x111 },
	'rawdevpmsaturation' => { 304 => 0x10d },
	'rawdevpmsharpness' => { 304 => 0x10f },
	'rawdevsaturation3' => { 304 => 0x113 },
	'rawdevsaturationemphasis' => { 303 => 0x104, 304 => 0x107 },
	'rawdevsettings' => { 303 => 0x10c },
	'rawdevsharpnessvalue' => { 303 => 0x107, 304 => 0x106 },
	'rawdevversion' => { 303 => 0x0, 304 => 0x0 },
	'rawdevwbfineadjustment' => { 303 => 0x102, 304 => 0x103 },
	'rawdevwhitebalance' => { 304 => 0x101 },
	'rawdevwhitebalancevalue' => { 303 => 0x101, 304 => 0x102 },
	'rawfile' => { 119 => 0xfe4c },
	'rawfilename' => { 477 => 'RawFileName', 479 => 'RawFileName' },
	'rawfiletype' => { 420 => 0x2029 },
	'rawformat' => { 325 => 0x2d, 364 => 0x10e },
	'rawimagecenter' => { 226 => 0x99 },
	'rawimagedigest' => { 119 => 0xc71c },
	'rawimagesize' => { 355 => 0x39 },
	'rawinfoversion' => { 305 => 0x0 },
	'rawjpgheight' => { 99 => 0x4 },
	'rawjpgquality' => { 57 => 0x6, 99 => 0x1 },
	'rawjpgsize' => { 57 => 0x7, 99 => 0x2 },
	'rawjpgwidth' => { 99 => 0x3 },
	'rawmeasuredrggb' => { 43 => 0x26a, 45 => 0x280, 47 => 0x194, 48 => [0x1ad,0x26b] },
	'rawrppused' => { 472 => 'rawrppused' },
	'rawtopreviewgain' => { 119 => 0xc7a8 },
	'readouttypeactual' => { 138 => 0x1903 },
	'readouttyperequested' => { 138 => 0x1902 },
	'reardisplay' => { 279 => '12.3', 280 => '6.2' },
	'recdevice' => { 489 => 'RecDevice' },
	'recdeviceattlensdescription' => { 489 => [\'RecDevice','RecDeviceAttLensDescription'] },
	'recdevicemanufacturer' => { 489 => [\'RecDevice','RecDeviceManufacturer'] },
	'recdevicemodelname' => { 489 => [\'RecDevice','RecDeviceModelName'] },
	'recdeviceownersdeviceid' => { 489 => [\'RecDevice','RecDeviceOwnersDeviceId'] },
	'recdeviceserialnumber' => { 489 => [\'RecDevice','RecDeviceSerialNumber'] },
	'recipeendingpage' => { 495 => 'recipeEndingPage' },
	'recipepagerange' => { 495 => 'recipePageRange' },
	'recipesource' => { 495 => 'recipeSource' },
	'recipestartingpage' => { 495 => 'recipeStartingPage' },
	'recipetitle' => { 495 => 'recipeTitle' },
	'recognizedface1age' => { 313 => 0x20 },
	'recognizedface1name' => { 313 => 0x4 },
	'recognizedface1position' => { 313 => 0x18 },
	'recognizedface2age' => { 313 => 0x50 },
	'recognizedface2name' => { 313 => 0x34 },
	'recognizedface2position' => { 313 => 0x48 },
	'recognizedface3age' => { 313 => 0x80 },
	'recognizedface3name' => { 313 => 0x64 },
	'recognizedface3position' => { 313 => 0x78 },
	'recognizedfaceflags' => { 320 => 0x63 },
	'recommendedexposureindex' => { 119 => 0x8832, 484 => 'RecommendedExposureIndex' },
	'record' => { 118 => 'Record' },
	'recordbasisofrecord' => { 118 => [\'Record','RecordBasisOfRecord'] },
	'recordcollectioncode' => { 118 => [\'Record','RecordCollectionCode'] },
	'recordcollectionid' => { 118 => [\'Record','RecordCollectionID'] },
	'recorddatageneralizations' => { 118 => [\'Record','RecordDataGeneralizations'] },
	'recorddatasetid' => { 118 => [\'Record','RecordDatasetID'] },
	'recorddatasetname' => { 118 => [\'Record','RecordDatasetName'] },
	'recorddisplay' => { 184 => 0x4d },
	'recorddynamicproperties' => { 118 => [\'Record','RecordDynamicProperties'] },
	'recordid' => { 97 => 0x1804 },
	'recordinformationwithheld' => { 118 => [\'Record','RecordInformationWithheld'] },
	'recordingcopyright' => { 380 => "\xa9phg" },
	'recordingformat' => { 387 => 0x1000 },
	'recordingmode' => { 112 => 0x1, 362 => 0x1 },
	'recordinstitutioncode' => { 118 => [\'Record','RecordInstitutionCode'] },
	'recordinstitutionid' => { 118 => [\'Record','RecordInstitutionID'] },
	'recordlabelname' => { 380 => "\xa9lab" },
	'recordlabelurl' => { 380 => "\xa9lal" },
	'recordlocationdata' => { 229 => 0x660 },
	'recordmode' => { 34 => 0x9, 113 => 0x3000 },
	'recordownerinstitutioncode' => { 118 => [\'Record','RecordOwnerInstitutionCode'] },
	'recordshutterrelease' => { 396 => 0x217 },
	'redbalance' => { 302 => 0x1017, 325 => 0x11, 355 => 0x1c },
	'redcurvelimits' => { 108 => 0x18a },
	'redcurvepoints' => { 107 => 0x2d, 108 => 0x160 },
	'redeyecorrection' => { 276 => 0x0 },
	'redeyeinfo' => { 477 => 'RedEyeInfo', 479 => 'RedEyeInfo' },
	'redeyereduction' => { 184 => 0x41, 407 => 0x6a, 409 => 0x28 },
	'redeyeremoval' => { 320 => 0xb9 },
	'redhsl' => { 103 => 0x20910 },
	'redhue' => { 477 => 'RedHue', 479 => 'RedHue' },
	'redsaturation' => { 477 => 'RedSaturation', 479 => 'RedSaturation' },
	'reductionmatrix1' => { 119 => 0xc625 },
	'reductionmatrix2' => { 119 => 0xc626 },
	'reductionmatrix3' => { 119 => 0xcd3a },
	'reelname' => { 119 => 0xc789, 380 => 'reel' },
	'reference1' => { 487 => [\'TagStructure','TagStructureReference'] },
	'reference2' => { 487 => [\'TagStructure','TagStructureSubLabelsReference'] },
	'reference3' => { 487 => [\'TagStructure','TagStructureSubLabelsSubLabelsReference'] },
	'reference4' => { 487 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsReference'] },
	'reference5' => { 487 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsReference'] },
	'reference6' => { 487 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsReference'] },
	'referenceblackwhite' => { 119 => 0x214, 499 => 'ReferenceBlackWhite' },
	'referencedate' => { 131 => 0x2f },
	'referencenumber' => { 131 => 0x32 },
	'references' => { 157 => 'References' },
	'referenceservice' => { 131 => 0x2d },
	'regionappliedtodimensions' => { 172 => [\'Regions','RegionsAppliedToDimensions'] },
	'regionappliedtodimensionsh' => { 172 => [\'Regions','RegionsAppliedToDimensionsH'] },
	'regionappliedtodimensionsunit' => { 172 => [\'Regions','RegionsAppliedToDimensionsUnit'] },
	'regionappliedtodimensionsw' => { 172 => [\'Regions','RegionsAppliedToDimensionsW'] },
	'regionarea' => { 172 => [\'Regions','RegionsRegionListArea'] },
	'regionaread' => { 172 => [\'Regions','RegionsRegionListAreaD'] },
	'regionareah' => { 172 => [\'Regions','RegionsRegionListAreaH'] },
	'regionareaunit' => { 172 => [\'Regions','RegionsRegionListAreaUnit'] },
	'regionareaw' => { 172 => [\'Regions','RegionsRegionListAreaW'] },
	'regionareax' => { 172 => [\'Regions','RegionsRegionListAreaX'] },
	'regionareay' => { 172 => [\'Regions','RegionsRegionListAreaY'] },
	'regionbarcodevalue' => { 172 => [\'Regions','RegionsRegionListBarCodeValue'] },
	'regionconstraints' => { 307 => 'RegionConstraints' },
	'regiondescription' => { 172 => [\'Regions','RegionsRegionListDescription'] },
	'regionextensions' => { 172 => [\'Regions','RegionsRegionListExtensions'] },
	'regionfocususage' => { 172 => [\'Regions','RegionsRegionListFocusUsage'] },
	'regioninfo' => { 172 => 'Regions' },
	'regioninfodateregionsvalid' => { 175 => [\'RegionInfo','RegionInfoDateRegionsValid'] },
	'regioninfomp' => { 175 => 'RegionInfo' },
	'regioninforegions' => { 175 => [\'RegionInfo','RegionInfoRegions'] },
	'regionlist' => { 172 => [\'Regions','RegionsRegionList'] },
	'regionname' => { 172 => [\'Regions','RegionsRegionListName'] },
	'regionpersondisplayname' => { 175 => [\'RegionInfo','RegionInfoRegionsPersonDisplayName'] },
	'regionpersonemaildigest' => { 175 => [\'RegionInfo','RegionInfoRegionsPersonEmailDigest'] },
	'regionpersonliveidcid' => { 175 => [\'RegionInfo','RegionInfoRegionsPersonLiveIdCID'] },
	'regionpersonsourceid' => { 175 => [\'RegionInfo','RegionInfoRegionsPersonSourceID'] },
	'regionrectangle' => { 175 => [\'RegionInfo','RegionInfoRegionsRectangle'] },
	'regionrotation' => { 172 => [\'Regions','RegionsRegionListRotation'] },
	'regionseealso' => { 172 => [\'Regions','RegionsRegionListSeeAlso'] },
	'regiontype' => { 172 => [\'Regions','RegionsRegionListType'] },
	'registryentryrole' => { 489 => [\'RegistryId','RegistryIdRegEntryRole'] },
	'registryid' => { 489 => 'RegistryId' },
	'registryitemid' => { 489 => [\'RegistryId','RegistryIdRegItemId'] },
	'registryorganisationid' => { 489 => [\'RegistryId','RegistryIdRegOrgId'] },
	'relatedaudiofile' => { 155 => 'data' },
	'relatedaudiofilename' => { 155 => '1Name' },
	'relatedaudiofiletype' => { 155 => '0Type' },
	'relatedimagefileformat' => { 119 => 0x1000 },
	'relatedimageheight' => { 119 => 0x1002 },
	'relatedimagewidth' => { 119 => 0x1001 },
	'relatedresourceid' => { 118 => [\'ResourceRelationship','ResourceRelationshipRelatedResourceID'] },
	'relatedsoundfile' => { 119 => 0xa004, 483 => 'RelatedSoundFile' },
	'relatedvideofile' => { 169 => 'data' },
	'relatedvideofilename' => { 169 => '1Name' },
	'relatedvideofiletype' => { 169 => '0Type' },
	'relation' => { 480 => 'relation' },
	'relationshipaccordingto' => { 118 => [\'ResourceRelationship','ResourceRelationshipRelationshipAccordingTo'] },
	'relationshipestablisheddate' => { 118 => [\'ResourceRelationship','ResourceRelationshipRelationshipEstablishedDate'] },
	'relationshipofresource' => { 118 => [\'ResourceRelationship','ResourceRelationshipRelationshipOfResource'] },
	'relationshipremarks' => { 118 => [\'ResourceRelationship','ResourceRelationshipRelationshipRemarks'] },
	'relativealtitude' => { 116 => 'RelativeAltitude' },
	'relativepeakaudiofilepath' => { 503 => 'relativePeakAudioFilePath' },
	'relativetimestamp' => { 503 => 'relativeTimestamp' },
	'relativetimestampscale' => { 503 => [\'relativeTimestamp','relativeTimestampScale'] },
	'relativetimestampvalue' => { 503 => [\'relativeTimestamp','relativeTimestampValue'] },
	'releasebuttontousedial' => { 279 => '17.8', 280 => '18.5', 282 => '18.4', 283 => '18.4', 288 => '33.8', 289 => '17.6', 292 => '18.5', 293 => '18.4' },
	'releasedate' => { 131 => 0x1e, 372 => 'rldt', 472 => 'ReleaseDate', 503 => 'releaseDate' },
	'releasemode' => { 113 => 0x3001, 247 => 0x184d, 420 => 0xb049 },
	'releasemode2' => { 428 => 0x112c, 429 => [0x112c,0x8], 430 => [0x1108,0x8], 431 => [0x1184,0x8], 432 => [0x1160,0x8], 433 => [0x4,0x1018], 434 => [0x4,0x210], 435 => [0x4,0x210], 436 => [0x4,0x208], 438 => [0x67,0x3f], 439 => [0x6b,0x6d,0x73,0x4b], 440 => [0x6b,0x4b], 441 => 0x10, 442 => 0x10, 443 => 0x9, 450 => 0x34 },
	'releasemode3' => { 428 => 0x1128, 429 => 0x1128, 430 => 0x1104, 431 => 0x1180, 432 => 0x115c, 433 => 0x1014, 434 => 0x20c, 435 => 0x20c, 436 => 0x204 },
	'releaseready' => { 489 => 'ReleaseReady' },
	'releasesetting' => { 97 => 0x1016 },
	'releasetime' => { 131 => 0x23, 472 => 'ReleaseTime' },
	'remoteonduration' => { 281 => '3.4', 284 => '17.2', 285 => '18.2', 286 => '18.2', 287 => '18.2', 289 => '18.2', 290 => '4.3', 294 => '19.2' },
	'renditionclass' => { 504 => 'RenditionClass' },
	'renditionof' => { 504 => 'RenditionOf' },
	'renditionofalternatepaths' => { 504 => [\'RenditionOf','RenditionOfAlternatePaths'] },
	'renditionofdocumentid' => { 504 => [\'RenditionOf','RenditionOfDocumentID'] },
	'renditionoffilepath' => { 504 => [\'RenditionOf','RenditionOfFilePath'] },
	'renditionoffrompart' => { 504 => [\'RenditionOf','RenditionOfFromPart'] },
	'renditionofinstanceid' => { 504 => [\'RenditionOf','RenditionOfInstanceID'] },
	'renditionoflastmodifydate' => { 504 => [\'RenditionOf','RenditionOfLastModifyDate'] },
	'renditionoflasturl' => { 504 => [\'RenditionOf','RenditionOfLastURL'] },
	'renditionoflinkcategory' => { 504 => [\'RenditionOf','RenditionOfLinkCategory'] },
	'renditionoflinkform' => { 504 => [\'RenditionOf','RenditionOfLinkForm'] },
	'renditionofmanager' => { 504 => [\'RenditionOf','RenditionOfManager'] },
	'renditionofmanagervariant' => { 504 => [\'RenditionOf','RenditionOfManagerVariant'] },
	'renditionofmanageto' => { 504 => [\'RenditionOf','RenditionOfManageTo'] },
	'renditionofmanageui' => { 504 => [\'RenditionOf','RenditionOfManageUI'] },
	'renditionofmaskmarkers' => { 504 => [\'RenditionOf','RenditionOfMaskMarkers'] },
	'renditionoforiginaldocumentid' => { 504 => [\'RenditionOf','RenditionOfOriginalDocumentID'] },
	'renditionofpartmapping' => { 504 => [\'RenditionOf','RenditionOfPartMapping'] },
	'renditionofplacedresolutionunit' => { 504 => [\'RenditionOf','RenditionOfPlacedResolutionUnit'] },
	'renditionofplacedxresolution' => { 504 => [\'RenditionOf','RenditionOfPlacedXResolution'] },
	'renditionofplacedyresolution' => { 504 => [\'RenditionOf','RenditionOfPlacedYResolution'] },
	'renditionofrenditionclass' => { 504 => [\'RenditionOf','RenditionOfRenditionClass'] },
	'renditionofrenditionparams' => { 504 => [\'RenditionOf','RenditionOfRenditionParams'] },
	'renditionoftopart' => { 504 => [\'RenditionOf','RenditionOfToPart'] },
	'renditionofversionid' => { 504 => [\'RenditionOf','RenditionOfVersionID'] },
	'renditionparams' => { 504 => 'RenditionParams' },
	'repeatingflashcount' => { 209 => 0xd, 210 => 0xe, 211 => 0xe, 212 => 0xe, 213 => 0xe, 288 => '17.2', 289 => '24.2', 290 => '9.2', 291 => '24.2', 294 => '25.2' },
	'repeatingflashcountbuilt-in' => { 256 => 0x4db },
	'repeatingflashcountexternal' => { 256 => 0x4c3 },
	'repeatingflashoutput' => { 288 => '17.1', 289 => '24.1', 290 => '9.1', 291 => '24.1', 294 => '25.1' },
	'repeatingflashoutputexternal' => { 256 => 0x4c0 },
	'repeatingflashrate' => { 209 => 0xc, 210 => 0xd, 211 => 0xd, 212 => 0xd, 213 => 0xd, 288 => '18.1', 289 => '25.1', 290 => '10.1', 291 => '25.1', 294 => '26.1' },
	'repeatingflashratebuilt-in' => { 256 => 0x4da },
	'repeatingflashrateexternal' => { 256 => 0x4c2 },
	'requirements' => { 380 => "\xa9req" },
	'requires' => { 475 => 'requires' },
	'resampleparams' => { 503 => 'resampleParams' },
	'resampleparamsquality' => { 503 => [\'resampleParams','resampleParamsQuality'] },
	'resamplingkerneldenominators050' => { 138 => 0xe50 },
	'resamplingkerneldenominators067' => { 138 => 0xe4f },
	'resamplingkerneldenominators100' => { 138 => 0xe51 },
	'resaved' => { 396 => 0x21e },
	'resetblacksegrows' => { 138 => 0x181a },
	'resolution' => { 162 => 'Resolution' },
	'resolutionmode' => { 397 => [0x87,0x4] },
	'resolutionunit' => { 119 => 0x128, 134 => 0x2, 499 => 'ResolutionUnit' },
	'resourceid' => { 118 => [\'ResourceRelationship','ResourceRelationshipResourceID'] },
	'resourcerelationship' => { 118 => 'ResourceRelationship' },
	'resourcerelationshipid' => { 118 => [\'ResourceRelationship','ResourceRelationshipResourceRelationshipID'] },
	'restrictdrivemodes' => { 84 => 0x612 },
	'restrictions' => { 496 => 'restrictions' },
	'retouchareafeather' => { 477 => [\'RetouchAreas','RetouchAreasFeather'], 479 => [\'RetouchAreas','RetouchAreasFeather'] },
	'retouchareamaskalpha' => { 477 => [\'RetouchAreas','RetouchAreasMasksAlpha'], 479 => [\'RetouchAreas','RetouchAreasMasksAlpha'] },
	'retouchareamaskangle' => { 477 => [\'RetouchAreas','RetouchAreasMasksAngle'], 479 => [\'RetouchAreas','RetouchAreasMasksAngle'] },
	'retouchareamaskbottom' => { 477 => [\'RetouchAreas','RetouchAreasMasksBottom'], 479 => [\'RetouchAreas','RetouchAreasMasksBottom'] },
	'retouchareamaskcentervalue' => { 477 => [\'RetouchAreas','RetouchAreasMasksCenterValue'], 479 => [\'RetouchAreas','RetouchAreasMasksCenterValue'] },
	'retouchareamaskcenterweight' => { 477 => [\'RetouchAreas','RetouchAreasMasksCenterWeight'], 479 => [\'RetouchAreas','RetouchAreasMasksCenterWeight'] },
	'retouchareamaskdabs' => { 477 => [\'RetouchAreas','RetouchAreasMasksDabs'], 479 => [\'RetouchAreas','RetouchAreasMasksDabs'] },
	'retouchareamaskfeather' => { 477 => [\'RetouchAreas','RetouchAreasMasksFeather'], 479 => [\'RetouchAreas','RetouchAreasMasksFeather'] },
	'retouchareamaskflipped' => { 477 => [\'RetouchAreas','RetouchAreasMasksFlipped'], 479 => [\'RetouchAreas','RetouchAreasMasksFlipped'] },
	'retouchareamaskflow' => { 477 => [\'RetouchAreas','RetouchAreasMasksFlow'], 479 => [\'RetouchAreas','RetouchAreasMasksFlow'] },
	'retouchareamaskfullx' => { 477 => [\'RetouchAreas','RetouchAreasMasksFullX'], 479 => [\'RetouchAreas','RetouchAreasMasksFullX'] },
	'retouchareamaskfully' => { 477 => [\'RetouchAreas','RetouchAreasMasksFullY'], 479 => [\'RetouchAreas','RetouchAreasMasksFullY'] },
	'retouchareamaskinputdigest' => { 477 => [\'RetouchAreas','RetouchAreasMasksInputDigest'], 479 => [\'RetouchAreas','RetouchAreasMasksInputDigest'] },
	'retouchareamaskleft' => { 477 => [\'RetouchAreas','RetouchAreasMasksLeft'], 479 => [\'RetouchAreas','RetouchAreasMasksLeft'] },
	'retouchareamaskmaskactive' => { 477 => [\'RetouchAreas','RetouchAreasMasksMaskActive'], 479 => [\'RetouchAreas','RetouchAreasMasksMaskActive'] },
	'retouchareamaskmaskblendmode' => { 477 => [\'RetouchAreas','RetouchAreasMasksMaskBlendMode'], 479 => [\'RetouchAreas','RetouchAreasMasksMaskBlendMode'] },
	'retouchareamaskmaskdigest' => { 477 => [\'RetouchAreas','RetouchAreasMasksMaskDigest'], 479 => [\'RetouchAreas','RetouchAreasMasksMaskDigest'] },
	'retouchareamaskmaskinverted' => { 477 => [\'RetouchAreas','RetouchAreasMasksMaskInverted'], 479 => [\'RetouchAreas','RetouchAreasMasksMaskInverted'] },
	'retouchareamaskmaskname' => { 477 => [\'RetouchAreas','RetouchAreasMasksMaskName'], 479 => [\'RetouchAreas','RetouchAreasMasksMaskName'] },
	'retouchareamaskmasks' => { 477 => [\'RetouchAreas','RetouchAreasMasksMasks'], 479 => [\'RetouchAreas','RetouchAreasMasksMasks'] },
	'retouchareamaskmasksalpha' => { 477 => [\'RetouchAreas','RetouchAreasMasksMasksAlpha'], 479 => [\'RetouchAreas','RetouchAreasMasksMasksAlpha'] },
	'retouchareamaskmasksangle' => { 477 => [\'RetouchAreas','RetouchAreasMasksMasksAngle'], 479 => [\'RetouchAreas','RetouchAreasMasksMasksAngle'] },
	'retouchareamaskmasksbottom' => { 477 => [\'RetouchAreas','RetouchAreasMasksMasksBottom'], 479 => [\'RetouchAreas','RetouchAreasMasksMasksBottom'] },
	'retouchareamaskmaskscentervalue' => { 477 => [\'RetouchAreas','RetouchAreasMasksMasksCenterValue'], 479 => [\'RetouchAreas','RetouchAreasMasksMasksCenterValue'] },
	'retouchareamaskmaskscenterweight' => { 477 => [\'RetouchAreas','RetouchAreasMasksMasksCenterWeight'], 479 => [\'RetouchAreas','RetouchAreasMasksMasksCenterWeight'] },
	'retouchareamaskmasksdabs' => { 477 => [\'RetouchAreas','RetouchAreasMasksMasksDabs'], 479 => [\'RetouchAreas','RetouchAreasMasksMasksDabs'] },
	'retouchareamaskmasksfeather' => { 477 => [\'RetouchAreas','RetouchAreasMasksMasksFeather'], 479 => [\'RetouchAreas','RetouchAreasMasksMasksFeather'] },
	'retouchareamaskmasksflipped' => { 477 => [\'RetouchAreas','RetouchAreasMasksMasksFlipped'], 479 => [\'RetouchAreas','RetouchAreasMasksMasksFlipped'] },
	'retouchareamaskmasksflow' => { 477 => [\'RetouchAreas','RetouchAreasMasksMasksFlow'], 479 => [\'RetouchAreas','RetouchAreasMasksMasksFlow'] },
	'retouchareamaskmasksfullx' => { 477 => [\'RetouchAreas','RetouchAreasMasksMasksFullX'], 479 => [\'RetouchAreas','RetouchAreasMasksMasksFullX'] },
	'retouchareamaskmasksfully' => { 477 => [\'RetouchAreas','RetouchAreasMasksMasksFullY'], 479 => [\'RetouchAreas','RetouchAreasMasksMasksFullY'] },
	'retouchareamaskmasksinputdigest' => { 477 => [\'RetouchAreas','RetouchAreasMasksMasksInputDigest'], 479 => [\'RetouchAreas','RetouchAreasMasksMasksInputDigest'] },
	'retouchareamaskmasksleft' => { 477 => [\'RetouchAreas','RetouchAreasMasksMasksLeft'], 479 => [\'RetouchAreas','RetouchAreasMasksMasksLeft'] },
	'retouchareamaskmasksmaskactive' => { 477 => [\'RetouchAreas','RetouchAreasMasksMasksMaskActive'], 479 => [\'RetouchAreas','RetouchAreasMasksMasksMaskActive'] },
	'retouchareamaskmasksmaskblendmode' => { 477 => [\'RetouchAreas','RetouchAreasMasksMasksMaskBlendMode'], 479 => [\'RetouchAreas','RetouchAreasMasksMasksMaskBlendMode'] },
	'retouchareamaskmasksmaskdigest' => { 477 => [\'RetouchAreas','RetouchAreasMasksMasksMaskDigest'], 479 => [\'RetouchAreas','RetouchAreasMasksMasksMaskDigest'] },
	'retouchareamaskmasksmaskinverted' => { 477 => [\'RetouchAreas','RetouchAreasMasksMasksMaskInverted'], 479 => [\'RetouchAreas','RetouchAreasMasksMasksMaskInverted'] },
	'retouchareamaskmasksmaskname' => { 477 => [\'RetouchAreas','RetouchAreasMasksMasksMaskName'], 479 => [\'RetouchAreas','RetouchAreasMasksMasksMaskName'] },
	'retouchareamaskmasksmasksubtype' => { 477 => [\'RetouchAreas','RetouchAreasMasksMasksMaskSubType'], 479 => [\'RetouchAreas','RetouchAreasMasksMasksMaskSubType'] },
	'retouchareamaskmasksmasksyncid' => { 477 => [\'RetouchAreas','RetouchAreasMasksMasksMaskSyncID'], 479 => [\'RetouchAreas','RetouchAreasMasksMasksMaskSyncID'] },
	'retouchareamaskmasksmaskversion' => { 477 => [\'RetouchAreas','RetouchAreasMasksMasksMaskVersion'], 479 => [\'RetouchAreas','RetouchAreasMasksMasksMaskVersion'] },
	'retouchareamaskmasksmidpoint' => { 477 => [\'RetouchAreas','RetouchAreasMasksMasksMidpoint'], 479 => [\'RetouchAreas','RetouchAreasMasksMasksMidpoint'] },
	'retouchareamaskmasksorigin' => { 477 => [\'RetouchAreas','RetouchAreasMasksMasksOrigin'], 479 => [\'RetouchAreas','RetouchAreasMasksMasksOrigin'] },
	'retouchareamaskmasksperimetervalue' => { 477 => [\'RetouchAreas','RetouchAreasMasksMasksPerimeterValue'], 479 => [\'RetouchAreas','RetouchAreasMasksMasksPerimeterValue'] },
	'retouchareamaskmasksradius' => { 477 => [\'RetouchAreas','RetouchAreasMasksMasksRadius'], 479 => [\'RetouchAreas','RetouchAreasMasksMasksRadius'] },
	'retouchareamaskmasksreferencepoint' => { 477 => [\'RetouchAreas','RetouchAreasMasksMasksReferencePoint'], 479 => [\'RetouchAreas','RetouchAreasMasksMasksReferencePoint'] },
	'retouchareamaskmasksright' => { 477 => [\'RetouchAreas','RetouchAreasMasksMasksRight'], 479 => [\'RetouchAreas','RetouchAreasMasksMasksRight'] },
	'retouchareamaskmasksroundness' => { 477 => [\'RetouchAreas','RetouchAreasMasksMasksRoundness'], 479 => [\'RetouchAreas','RetouchAreasMasksMasksRoundness'] },
	'retouchareamaskmaskssizex' => { 477 => [\'RetouchAreas','RetouchAreasMasksMasksSizeX'], 479 => [\'RetouchAreas','RetouchAreasMasksMasksSizeX'] },
	'retouchareamaskmaskssizey' => { 477 => [\'RetouchAreas','RetouchAreasMasksMasksSizeY'], 479 => [\'RetouchAreas','RetouchAreasMasksMasksSizeY'] },
	'retouchareamaskmaskstop' => { 477 => [\'RetouchAreas','RetouchAreasMasksMasksTop'], 479 => [\'RetouchAreas','RetouchAreasMasksMasksTop'] },
	'retouchareamaskmasksubtype' => { 477 => [\'RetouchAreas','RetouchAreasMasksMaskSubType'], 479 => [\'RetouchAreas','RetouchAreasMasksMaskSubType'] },
	'retouchareamaskmasksvalue' => { 477 => [\'RetouchAreas','RetouchAreasMasksMasksMaskValue'], 479 => [\'RetouchAreas','RetouchAreasMasksMasksMaskValue'] },
	'retouchareamaskmasksversion' => { 477 => [\'RetouchAreas','RetouchAreasMasksMasksVersion'], 479 => [\'RetouchAreas','RetouchAreasMasksMasksVersion'] },
	'retouchareamaskmaskswhat' => { 477 => [\'RetouchAreas','RetouchAreasMasksMasksWhat'], 479 => [\'RetouchAreas','RetouchAreasMasksMasksWhat'] },
	'retouchareamaskmaskswholeimagearea' => { 477 => [\'RetouchAreas','RetouchAreasMasksMasksWholeImageArea'], 479 => [\'RetouchAreas','RetouchAreasMasksMasksWholeImageArea'] },
	'retouchareamaskmasksx' => { 477 => [\'RetouchAreas','RetouchAreasMasksMasksX'], 479 => [\'RetouchAreas','RetouchAreasMasksMasksX'] },
	'retouchareamaskmasksy' => { 477 => [\'RetouchAreas','RetouchAreasMasksMasksY'], 479 => [\'RetouchAreas','RetouchAreasMasksMasksY'] },
	'retouchareamaskmasksyncid' => { 477 => [\'RetouchAreas','RetouchAreasMasksMaskSyncID'], 479 => [\'RetouchAreas','RetouchAreasMasksMaskSyncID'] },
	'retouchareamaskmaskszerox' => { 477 => [\'RetouchAreas','RetouchAreasMasksMasksZeroX'], 479 => [\'RetouchAreas','RetouchAreasMasksMasksZeroX'] },
	'retouchareamaskmaskszeroy' => { 477 => [\'RetouchAreas','RetouchAreasMasksMasksZeroY'], 479 => [\'RetouchAreas','RetouchAreasMasksMasksZeroY'] },
	'retouchareamaskmaskversion' => { 477 => [\'RetouchAreas','RetouchAreasMasksMaskVersion'], 479 => [\'RetouchAreas','RetouchAreasMasksMaskVersion'] },
	'retouchareamaskmidpoint' => { 477 => [\'RetouchAreas','RetouchAreasMasksMidpoint'], 479 => [\'RetouchAreas','RetouchAreasMasksMidpoint'] },
	'retouchareamaskorigin' => { 477 => [\'RetouchAreas','RetouchAreasMasksOrigin'], 479 => [\'RetouchAreas','RetouchAreasMasksOrigin'] },
	'retouchareamaskperimetervalue' => { 477 => [\'RetouchAreas','RetouchAreasMasksPerimeterValue'], 479 => [\'RetouchAreas','RetouchAreasMasksPerimeterValue'] },
	'retouchareamaskradius' => { 477 => [\'RetouchAreas','RetouchAreasMasksRadius'], 479 => [\'RetouchAreas','RetouchAreasMasksRadius'] },
	'retouchareamaskrange' => { 477 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMask'], 479 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMask'] },
	'retouchareamaskrangeareamodels' => { 477 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskAreaModels'], 479 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskAreaModels'] },
	'retouchareamaskrangeareamodelscolorsampleinfo' => { 477 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 479 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'retouchareamaskrangeareamodelscomponents' => { 477 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskAreaModelsAreaComponents'], 479 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskAreaModelsAreaComponents'] },
	'retouchareamaskrangecoloramount' => { 477 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskColorAmount'], 479 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskColorAmount'] },
	'retouchareamaskrangedepthfeather' => { 477 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskDepthFeather'], 479 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskDepthFeather'] },
	'retouchareamaskrangedepthmax' => { 477 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskDepthMax'], 479 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskDepthMax'] },
	'retouchareamaskrangedepthmin' => { 477 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskDepthMin'], 479 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskDepthMin'] },
	'retouchareamaskrangeinvert' => { 477 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskInvert'], 479 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskInvert'] },
	'retouchareamaskrangelumfeather' => { 477 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumFeather'], 479 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumFeather'] },
	'retouchareamaskrangeluminancedepthsampleinfo' => { 477 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLuminanceDepthSampleInfo'], 479 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'retouchareamaskrangelummax' => { 477 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumMax'], 479 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumMax'] },
	'retouchareamaskrangelummin' => { 477 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumMin'], 479 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumMin'] },
	'retouchareamaskrangelumrange' => { 477 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumRange'], 479 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumRange'] },
	'retouchareamaskrangesampletype' => { 477 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskSampleType'], 479 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskSampleType'] },
	'retouchareamaskrangetype' => { 477 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskType'], 479 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskType'] },
	'retouchareamaskrangeversion' => { 477 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskVersion'], 479 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskVersion'] },
	'retouchareamaskreferencepoint' => { 477 => [\'RetouchAreas','RetouchAreasMasksReferencePoint'], 479 => [\'RetouchAreas','RetouchAreasMasksReferencePoint'] },
	'retouchareamaskright' => { 477 => [\'RetouchAreas','RetouchAreasMasksRight'], 479 => [\'RetouchAreas','RetouchAreasMasksRight'] },
	'retouchareamaskroundness' => { 477 => [\'RetouchAreas','RetouchAreasMasksRoundness'], 479 => [\'RetouchAreas','RetouchAreasMasksRoundness'] },
	'retouchareamasks' => { 477 => [\'RetouchAreas','RetouchAreasMasks'], 479 => [\'RetouchAreas','RetouchAreasMasks'] },
	'retouchareamasksizex' => { 477 => [\'RetouchAreas','RetouchAreasMasksSizeX'], 479 => [\'RetouchAreas','RetouchAreasMasksSizeX'] },
	'retouchareamasksizey' => { 477 => [\'RetouchAreas','RetouchAreasMasksSizeY'], 479 => [\'RetouchAreas','RetouchAreasMasksSizeY'] },
	'retouchareamasktop' => { 477 => [\'RetouchAreas','RetouchAreasMasksTop'], 479 => [\'RetouchAreas','RetouchAreasMasksTop'] },
	'retouchareamaskvalue' => { 477 => [\'RetouchAreas','RetouchAreasMasksMaskValue'], 479 => [\'RetouchAreas','RetouchAreasMasksMaskValue'] },
	'retouchareamaskversion' => { 477 => [\'RetouchAreas','RetouchAreasMasksVersion'], 479 => [\'RetouchAreas','RetouchAreasMasksVersion'] },
	'retouchareamaskwhat' => { 477 => [\'RetouchAreas','RetouchAreasMasksWhat'], 479 => [\'RetouchAreas','RetouchAreasMasksWhat'] },
	'retouchareamaskwholeimagearea' => { 477 => [\'RetouchAreas','RetouchAreasMasksWholeImageArea'], 479 => [\'RetouchAreas','RetouchAreasMasksWholeImageArea'] },
	'retouchareamaskx' => { 477 => [\'RetouchAreas','RetouchAreasMasksX'], 479 => [\'RetouchAreas','RetouchAreasMasksX'] },
	'retouchareamasky' => { 477 => [\'RetouchAreas','RetouchAreasMasksY'], 479 => [\'RetouchAreas','RetouchAreasMasksY'] },
	'retouchareamaskzerox' => { 477 => [\'RetouchAreas','RetouchAreasMasksZeroX'], 479 => [\'RetouchAreas','RetouchAreasMasksZeroX'] },
	'retouchareamaskzeroy' => { 477 => [\'RetouchAreas','RetouchAreasMasksZeroY'], 479 => [\'RetouchAreas','RetouchAreasMasksZeroY'] },
	'retouchareamethod' => { 477 => [\'RetouchAreas','RetouchAreasMethod'], 479 => [\'RetouchAreas','RetouchAreasMethod'] },
	'retouchareaoffsety' => { 477 => [\'RetouchAreas','RetouchAreasOffsetY'], 479 => [\'RetouchAreas','RetouchAreasOffsetY'] },
	'retouchareaopacity' => { 477 => [\'RetouchAreas','RetouchAreasOpacity'], 479 => [\'RetouchAreas','RetouchAreasOpacity'] },
	'retouchareas' => { 477 => 'RetouchAreas', 479 => 'RetouchAreas' },
	'retouchareaseed' => { 477 => [\'RetouchAreas','RetouchAreasSeed'], 479 => [\'RetouchAreas','RetouchAreasSeed'] },
	'retouchareasourcestate' => { 477 => [\'RetouchAreas','RetouchAreasSourceState'], 479 => [\'RetouchAreas','RetouchAreasSourceState'] },
	'retouchareasourcex' => { 477 => [\'RetouchAreas','RetouchAreasSourceX'], 479 => [\'RetouchAreas','RetouchAreasSourceX'] },
	'retouchareaspottype' => { 477 => [\'RetouchAreas','RetouchAreasSpotType'], 479 => [\'RetouchAreas','RetouchAreasSpotType'] },
	'retouchhistory' => { 226 => 0x9e },
	'retouchinfo' => { 477 => 'RetouchInfo', 479 => 'RetouchInfo' },
	'retouchnefprocessing' => { 236 => 0x5 },
	'retractlensonpoweroff' => { 84 => 0x814 },
	'reuse' => { 307 => 'Reuse' },
	'reuseallowed' => { 506 => 'ReuseAllowed' },
	'reuseprohibited' => { 496 => 'reuseProhibited' },
	'reverseexposurecompdial' => { 286 => '5.2' },
	'reversefocusring' => { 295 => 0x163 },
	'reverseindicators' => { 279 => '12.1', 280 => '6.1', 282 => '6.1', 283 => '6.1', 284 => '4.3', 285 => '5.2', 286 => '5.4', 288 => '33.5', 289 => '5.1', 292 => '6.1', 293 => '6.1', 294 => '6.2', 295 => 0xc1 },
	'reverseshutterspeedaperture' => { 286 => '5.3' },
	'revision' => { 481 => 'revision' },
	'rflensmffocusringsensitivity' => { 84 => 0x714 },
	'rflenstype' => { 57 => 0x3d },
	'rgbcurvelimits' => { 108 => 0x238 },
	'rgbcurvepoints' => { 107 => 0x7, 108 => 0x20e },
	'rgbtables' => { 119 => 0xcd3b },
	'richtextcomment' => { 486 => 'RichTextComment' },
	'ricohdate' => { 386 => 0x6 },
	'ricohimageheight' => { 386 => 0x2 },
	'ricohimagewidth' => { 386 => 0x0 },
	'rightalbedo' => { 468 => 'RightAlbedo' },
	'rightascension' => { 165 => 'RightAscension' },
	'rights' => { 480 => 'rights' },
	'rightsagent' => { 496 => 'rightsAgent' },
	'rightsowner' => { 496 => 'rightsOwner' },
	'roll' => { 115 => 0x8, 380 => ['roll',"\xa9frl"] },
	'rollangle' => { 247 => 0x350b, 248 => 0x2c24, 252 => 0xc21a, 257 => 0x36f4, 258 => 0x2efb, 260 => 0xce32, 261 => 0xeaeb, 297 => 0x903, 320 => 0x90, 354 => 0x1, 392 => 0x2 },
	'romoperationmode' => { 97 => 0x80d },
	'rotation' => { 30 => 0x17, 31 => 0x18, 96 => 0x3, 103 => 0x10002, 108 => 0x26e, 114 => 'QuickTime-Rotation', 123 => 0x4, 165 => 'Rotation', 182 => [0x65,0x50], 183 => 0x46, 184 => 0x5a, 187 => 0x10, 247 => 0x3693, 248 => 0xca, 255 => '590.1', 272 => 0x76a43207, 320 => 0x30, 336 => '17.2', 366 => 0xd8, 373 => 'irot', 407 => 0x3f, 408 => 0x3f, 418 => 0x10 },
	'routedto' => { 485 => 'RoutedTo' },
	'routing' => { 371 => 'Routing' },
	'routingdestinations' => { 467 => 'RoutingDestinations' },
	'routingexclusions' => { 467 => 'RoutingExclusions' },
	'routingnotes' => { 485 => 'RoutingNotes' },
	'rowsperstrip' => { 119 => 0x116 },
	'rpp' => { 472 => 'rpp' },
	'rtkflag' => { 116 => 'RtkFlag' },
	'rtkstdhgt' => { 116 => 'RtkStdHgt' },
	'rtkstdlat' => { 116 => 'RtkStdLat' },
	'rtkstdlon' => { 116 => 'RtkStdLon' },
	'safetyshift' => { 84 => 0x108 },
	'safetyshiftinavortv' => { 82 => 0x10, 83 => 0x10, 85 => 0xf, 86 => 0x10, 89 => 0x10 },
	'sameexposurefornewaperture' => { 84 => 0x112 },
	'samplebits' => { 155 => 'SampleBits' },
	'samplepagerange' => { 493 => 'samplePageRange' },
	'samplerate' => { 155 => 'SampleRate' },
	'samplesperpixel' => { 119 => 0x115, 325 => 0x8, 499 => 'SamplesPerPixel' },
	'samplestructure' => { 133 => 0x5a },
	'samsungmodelid' => { 394 => 0x3 },
	'sanyoquality' => { 396 => 0x201 },
	'sanyothumbnail' => { 396 => 0x100 },
	'saturation' => { 10 => 0x6e, 12 => 0x76, 34 => 0xe, 51 => 0x1, 63 => 0x7, 112 => 0xd, 113 => [0x3013,0x1f], 119 => [0xa409,0xfe55], 127 => 0x1003, 156 => 'Saturation', 181 => 0x1f, 182 => 0x32, 183 => 0x28, 184 => 0x1a, 189 => 0x1, 226 => 0xaa, 231 => 0x35, 232 => 0x3b, 233 => 0x43, 320 => 0x40, 322 => 0x300d, 355 => 0x1f, 362 => 0xd, 381 => 0x27, 383 => 0x58, 386 => 0x28, 387 => 0x1013, 397 => 0x10, 407 => 0x1e, 408 => 0x1b, 420 => 0x2005, 477 => 'Saturation', 479 => 'Saturation', 483 => 'Saturation' },
	'saturationadj' => { 103 => 0x20901, 108 => 0x116, 226 => 0x94, 271 => 0x1, 275 => 0x2e, 454 => 0x8016 },
	'saturationadjustmentaqua' => { 477 => 'SaturationAdjustmentAqua', 479 => 'SaturationAdjustmentAqua' },
	'saturationadjustmentblue' => { 477 => 'SaturationAdjustmentBlue', 479 => 'SaturationAdjustmentBlue' },
	'saturationadjustmentgreen' => { 477 => 'SaturationAdjustmentGreen', 479 => 'SaturationAdjustmentGreen' },
	'saturationadjustmentmagenta' => { 477 => 'SaturationAdjustmentMagenta', 479 => 'SaturationAdjustmentMagenta' },
	'saturationadjustmentorange' => { 477 => 'SaturationAdjustmentOrange', 479 => 'SaturationAdjustmentOrange' },
	'saturationadjustmentpurple' => { 477 => 'SaturationAdjustmentPurple', 479 => 'SaturationAdjustmentPurple' },
	'saturationadjustmentred' => { 477 => 'SaturationAdjustmentRed', 479 => 'SaturationAdjustmentRed' },
	'saturationadjustmentyellow' => { 477 => 'SaturationAdjustmentYellow', 479 => 'SaturationAdjustmentYellow' },
	'saturationauto' => { 71 => 0x98 },
	'saturationfaithful' => { 19 => 0xfe, 70 => 0x68, 71 => 0x68 },
	'saturationlandscape' => { 19 => 0xfc, 70 => 0x38, 71 => 0x38 },
	'saturationmonochrome' => { 70 => 0x80, 71 => 0x80 },
	'saturationneutral' => { 19 => 0xfd, 70 => 0x50, 71 => 0x50 },
	'saturationportrait' => { 19 => 0xfb, 70 => 0x20, 71 => 0x20 },
	'saturationsetting' => { 305 => 0x1010, 409 => 0x11, 425 => 0x9 },
	'saturationstandard' => { 19 => 0xfa, 70 => 0x8, 71 => 0x8 },
	'saturationuserdef1' => { 19 => 0x100, 70 => 0x98, 71 => 0xb0 },
	'saturationuserdef2' => { 19 => 0x101, 70 => 0xb0, 71 => 0xc8 },
	'saturationuserdef3' => { 19 => 0x102, 70 => 0xc8, 71 => 0xe0 },
	'saveid' => { 504 => 'SaveID' },
	'sbaanalysiscomplete' => { 138 => 0xc35 },
	'sbablack' => { 138 => 0xc25 },
	'sbagmoffset' => { 138 => 0xc4a },
	'sbagray' => { 138 => 0xc26 },
	'sbagreenmagentabal' => { 138 => 0xc33 },
	'sbahighgray' => { 138 => 0xc46 },
	'sbailloffset' => { 138 => 0xc49 },
	'sbailluminantbal' => { 138 => 0xc34 },
	'sbalowgray' => { 138 => 0xc47 },
	'sbaneutralbal' => { 138 => 0xc32 },
	'sbawhite' => { 138 => 0xc27 },
	'scaletype' => { 503 => 'scaleType' },
	'scanimageenhancer' => { 237 => 0x60 },
	'scanningdirection' => { 133 => 0x64 },
	'scene' => { 380 => 'scen', 488 => 'Scene', 503 => 'scene' },
	'scenearea' => { 300 => 0x211, 302 => 0x1031 },
	'sceneassist' => { 226 => 0x9c },
	'scenecapturetype' => { 119 => 0xa406, 483 => 'SceneCaptureType' },
	'scenedetect' => { 300 => 0x210, 302 => 0x1030 },
	'scenedetectdata' => { 300 => 0x212, 302 => 0x1033 },
	'scenemode' => { 142 => 0xfa02, 186 => 0x100, 226 => 0x8f, 297 => 0x509, 302 => 0x403, 320 => 0x8001, 329 => 0xf, 420 => 0xb023 },
	'scenemodeused' => { 144 => [0x6002,0xf002] },
	'scenerecognition' => { 127 => 0x1425 },
	'sceneselect' => { 396 => 0x21f },
	'scenetype' => { 119 => 0xa301, 483 => 'SceneType' },
	'screentips' => { 279 => '12.7', 280 => '5.3', 288 => '13.1', 289 => '4.4', 292 => '5.4', 294 => '5.1' },
	'scriptversion' => { 138 => 0x1770 },
	'season' => { 489 => 'Season', 492 => 'season' },
	'seasonidentifier' => { 489 => [\'Season','SeasonIdentifier'] },
	'seasonname' => { 489 => [\'Season','SeasonName'] },
	'seasonnumber' => { 489 => [\'Season','SeasonNumber'] },
	'secondaryftp' => { 467 => 'SecondaryFTP' },
	'secondaryslotfunction' => { 229 => 0x22c, 247 => 0x1d0, 257 => 0x1d0 },
	'section' => { 493 => 'section' },
	'securityclassification' => { 119 => 0x9212 },
	'selectableafpoint' => { 84 => 0x509 },
	'selectafareaselectionmode' => { 2 => 0xc },
	'selectafareaselectmode' => { 84 => 0x512 },
	'selfdata' => { 116 => 'SelfData' },
	'selftimer' => { 34 => 0x2, 320 => 0x2e, 396 => 0x214, 428 => 0x1134, 429 => 0x1134, 430 => 0x1110, 431 => 0x118c, 432 => 0x1168, 433 => 0x1020, 434 => 0x218, 435 => 0x218, 436 => 0x210 },
	'selftimer2' => { 77 => 0x1d },
	'selftimerinterval' => { 289 => '19.2' },
	'selftimermode' => { 119 => 0x882b },
	'selftimershotcount' => { 280 => '20.2', 282 => '20.3', 283 => '20.3', 284 => '18.2', 285 => '19.2', 286 => '19.2', 287 => '19.3', 289 => '19.3', 292 => '20.3', 293 => '20.3', 294 => '20.2', 295 => 0x2d },
	'selftimershotinterval' => { 280 => '20.3', 282 => '20.2', 283 => '20.2', 287 => '19.2', 292 => '20.2', 293 => '20.2', 295 => 0x31 },
	'selftimertime' => { 97 => 0x1806, 184 => 0x1f, 279 => '18.1', 280 => '20.1', 281 => '3.3', 282 => '20.1', 283 => '20.1', 284 => '18.1', 285 => '19.1', 286 => '19.1', 287 => '19.1', 288 => '7.2', 289 => '19.1', 290 => '3.3', 292 => '20.1', 293 => '20.1', 294 => '20.1', 295 => 0x2b },
	'sellingagency' => { 493 => 'sellingAgency' },
	'seminfo' => { 119 => 0x8546 },
	'sensingmethod' => { 119 => 0xa217, 483 => 'SensingMethod' },
	'sensitivityadjust' => { 355 => 0x40 },
	'sensitivitysteps' => { 336 => ['14.3','17.4'], 338 => 0x1 },
	'sensitivitytype' => { 119 => 0x8830, 484 => 'SensitivityType' },
	'sensor' => { 191 => 0x665e },
	'sensorarea' => { 302 => 0x400 },
	'sensorareas' => { 394 => 0xa010 },
	'sensorbitdepth' => { 322 => 0x312d },
	'sensorbluelevel' => { 74 => 0x5 },
	'sensorcalibration' => { 301 => 0x805 },
	'sensorcleaning' => { 90 => 0xd },
	'sensorfullheight' => { 137 => 0xf904 },
	'sensorfullwidth' => { 137 => 0xf903 },
	'sensorheight' => { 137 => 0xf901, 142 => 0xfa21, 188 => 0x8, 322 => 0x312c, 364 => 0x109, 387 => 0x1602 },
	'sensorimageheight' => { 138 => 0x3ee },
	'sensorimagewidth' => { 138 => 0x3ed },
	'sensorleftborder' => { 138 => 0x3eb },
	'sensorleftmargin' => { 364 => 0x10a },
	'sensorpixelsize' => { 226 => 0x9a },
	'sensorredlevel' => { 74 => 0x4 },
	'sensorserialnumber' => { 138 => 0x9ce },
	'sensorshield' => { 229 => 0x66d },
	'sensorsize' => { 156 => 'SensorSize', 355 => 0x35 },
	'sensortemperature' => { 300 => 0x1500, 302 => 0x1007, 360 => 0xc, 364 => 0x210, 397 => [0x39,0x55] },
	'sensortemperature2' => { 360 => 0xe, 364 => 0x211 },
	'sensortopborder' => { 138 => 0x3ec },
	'sensortopmargin' => { 364 => 0x10b },
	'sensortype' => { 320 => 0xca },
	'sensorwidth' => { 137 => 0xf900, 142 => 0xfa20, 188 => 0xa, 322 => 0x312b, 364 => 0x108, 387 => 0x1601 },
	'sequence' => { 381 => 0x7, 382 => 0x35, 383 => 0x36 },
	'sequencefilenumber' => { 429 => 0x4, 430 => 0x4, 431 => 0x4, 432 => 0x4, 441 => 0xc, 442 => 0xc, 443 => 0x1a },
	'sequenceimagenumber' => { 429 => 0x0, 430 => 0x0, 431 => 0x0, 432 => 0x0, 441 => 0x8, 442 => 0x8, 443 => 0x12, 450 => 0x24 },
	'sequencelength' => { 441 => 0x22, 442 => 0x1e, 443 => [0x16,0x1e] },
	'sequencename' => { 492 => 'sequenceName' },
	'sequencenumber' => { 77 => 0x9, 113 => 0x301c, 127 => 0x1101, 140 => 0x1d, 256 => 0x51c, 320 => 0x2b, 409 => [0x10c,0x30c], 420 => 0xb04a, 492 => 'sequenceNumber' },
	'sequenceshotinterval' => { 396 => 0x224 },
	'sequencetotalnumber' => { 492 => 'sequenceTotalNumber' },
	'sequentialshot' => { 396 => 0x20e },
	'serialnumber' => { 64 => 0xc, 97 => 0x180b, 119 => [0xa431,0xfde9], 137 => 0xfa04, 139 => 0xfa00, 141 => 0xc354, 142 => 0xfa19, 153 => 0x0, 156 => 'SerialNumber', 191 => 0x5501, 226 => [0xa0,0x1d], 298 => 0x101, 302 => [0x404,0x101a], 315 => 0x303, 317 => 0x305, 322 => 0x3103, 355 => 0x229, 364 => 0x102, 365 => 0x407, 380 => ['SNum','slno'], 381 => 0x15, 382 => 0x4b, 383 => 0x7e, 387 => 0x5, 394 => 0xa002, 397 => 0x2, 420 => 0x2031, 474 => 'SerialNumber', 484 => 'BodySerialNumber' },
	'serialnumberformat' => { 64 => 0x15, 97 => 0x183b },
	'serialnumberhash' => { 380 => 'CAME' },
	'series' => { 489 => 'Series' },
	'seriesdatetime' => { 456 => 'SeriesDateTime' },
	'seriesdescription' => { 456 => 'SeriesDescription' },
	'seriesidentifier' => { 489 => [\'Series','SeriesIdentifier'] },
	'seriesmodality' => { 456 => 'SeriesModality' },
	'seriesname' => { 489 => [\'Series','SeriesName'] },
	'seriesnumber' => { 456 => 'SeriesNumber', 493 => 'seriesNumber' },
	'seriestitle' => { 493 => 'seriesTitle' },
	'serviceidentifier' => { 132 => 0x1e },
	'servingsize' => { 495 => 'servingSize' },
	'setbuttoncrosskeysfunc' => { 87 => 0x0, 88 => 0x0 },
	'setbuttonwhenshooting' => { 82 => 0x1, 84 => 0x704, 90 => 0xc },
	'setclockfromlocationdata' => { 229 => 0x61d },
	'setfunctionwhenshooting' => { 85 => 0x0, 86 => 0x1, 89 => 0x1 },
	'setting' => { 492 => 'setting' },
	'shadingcompensation' => { 297 => 0x50c, 320 => 0x8a },
	'shadingcompensation2' => { 301 => 0x1012 },
	'shadow' => { 397 => 0xe },
	'shadowadj' => { 103 => 0x2030b },
	'shadowcorrection' => { 355 => 0x79 },
	'shadowprotection' => { 271 => 0x0 },
	'shadows' => { 119 => 0xfe52, 420 => 0x2032, 471 => 'Shadows', 477 => 'Shadows', 479 => 'Shadows' },
	'shadows2012' => { 477 => 'Shadows2012', 479 => 'Shadows2012' },
	'shadowsadj' => { 454 => 0x901a },
	'shadowscale' => { 119 => 0xc633 },
	'shadowtint' => { 477 => 'ShadowTint', 479 => 'ShadowTint' },
	'shadowtone' => { 127 => 0x1040 },
	'shakereduction' => { 357 => 0x1, 358 => 0x1 },
	'shareduserrating' => { 179 => 'WM/SharedUserRating' },
	'sharpendetail' => { 477 => 'SharpenDetail', 479 => 'SharpenDetail' },
	'sharpenedgemasking' => { 477 => 'SharpenEdgeMasking', 479 => 'SharpenEdgeMasking' },
	'sharpening' => { 322 => 0x300b },
	'sharpeningadj' => { 275 => 0x2b },
	'sharpeningkernel' => { 138 => 0x92f },
	'sharpenradius' => { 477 => 'SharpenRadius', 479 => 'SharpenRadius' },
	'sharpness' => { 8 => [0x42,0x48], 10 => 0x72, 12 => 0x74, 34 => 0xf, 63 => 0x6, 74 => 0x2, 112 => 0xb, 113 => [0x3011,0x21], 119 => [0xa40a,0xfe56], 127 => 0x1001, 140 => 0x6b, 149 => 0x37, 156 => 'Sharpness', 181 => 0x21, 182 => 0x30, 183 => 0x26, 184 => 0x18, 189 => 0x3, 226 => 0x6, 231 => 0x32, 232 => 0x33, 233 => 0x39, 302 => 0x100f, 320 => 0x41, 355 => 0x21, 362 => 0xb, 381 => 0x26, 383 => 0x56, 386 => 0x22, 387 => [0x1003,0x1014], 397 => 0x11, 407 => 0x1c, 408 => 0x19, 420 => 0x2006, 450 => 0x52, 477 => 'Sharpness', 479 => 'Sharpness', 483 => 'Sharpness' },
	'sharpnessadj' => { 103 => 0x20310, 108 => 0x25a, 454 => 0x801a },
	'sharpnessadjon' => { 103 => '0x20310.0' },
	'sharpnessauto' => { 71 => 0x94 },
	'sharpnessfactor' => { 302 => 0x102a },
	'sharpnessfaithful' => { 19 => 0xf5, 70 => 0x64, 71 => 0x64 },
	'sharpnessfrequency' => { 8 => [0x41,0x47], 74 => 0x3 },
	'sharpnesslandscape' => { 19 => 0xf3, 70 => 0x34, 71 => 0x34 },
	'sharpnessmonochrome' => { 19 => 0xf6, 70 => 0x7c, 71 => 0x7c },
	'sharpnessneutral' => { 19 => 0xf4, 70 => 0x4c, 71 => 0x4c },
	'sharpnessovershoot' => { 454 => 0x801b },
	'sharpnessportrait' => { 19 => 0xf2, 70 => 0x1c, 71 => 0x1c },
	'sharpnessrange' => { 420 => 0x2035 },
	'sharpnesssetting' => { 297 => 0x506, 305 => 0x1013, 409 => 0x12, 425 => 0xa },
	'sharpnessstandard' => { 19 => 0xf1, 70 => 0x4, 71 => 0x4 },
	'sharpnessstrength' => { 103 => 0x20311 },
	'sharpnessthreshold' => { 454 => 0x801d },
	'sharpnessundershoot' => { 454 => 0x801c },
	'sharpnessuserdef1' => { 19 => 0xf7, 70 => 0x94, 71 => 0xac },
	'sharpnessuserdef2' => { 19 => 0xf8, 70 => 0xac, 71 => 0xc4 },
	'sharpnessuserdef3' => { 19 => 0xf9, 70 => 0xc4, 71 => 0xdc },
	'shiftcols' => { 138 => 0xc70 },
	'shootid' => { 492 => 'shootID' },
	'shootingdistance' => { 103 => 0x20701 },
	'shootinginfodisplay' => { 279 => '13.2', 280 => '5.1', 288 => '10.2', 289 => '4.1', 292 => '5.1', 294 => '5.3' },
	'shootinginfomonitorofftime' => { 279 => '26.2', 280 => '22.2', 282 => '22.2', 283 => '22.2', 287 => '21.2', 288 => '9.1', 289 => '21.2', 292 => '22.2', 293 => '22.2', 294 => '22.2', 295 => 0x37 },
	'shootingmode' => { 156 => 'ShootingMode', 226 => 0x89, 320 => 0x1f },
	'shootingmodesetting' => { 281 => '5.1' },
	'shortdescription' => { 481 => 'shortdescription' },
	'shortdocumentid' => { 131 => 0xba },
	'shortname' => { 477 => 'ShortName', 479 => 'ShortName' },
	'shortownername' => { 19 => 0xac },
	'shortreleasetimelag' => { 84 => 0x80d },
	'shorttitle' => { 372 => '@sti' },
	'shotdate' => { 503 => 'shotDate' },
	'shotday' => { 503 => 'shotDay' },
	'shotlocation' => { 503 => 'shotLocation' },
	'shotname' => { 380 => 'shot', 503 => 'shotName' },
	'shotnumber' => { 503 => 'shotNumber' },
	'shotnumbersincepowerup' => { 424 => 0x44e, 441 => 0x1a, 442 => 0x16, 443 => 0xa },
	'shotnumbersincepowerup2' => { 409 => 0x200 },
	'shotsize' => { 503 => 'shotSize' },
	'shotsperinterval' => { 228 => 0xb4, 229 => 0xc0, 252 => 0xc412 },
	'showmovement' => { 372 => 'shwm' },
	'shownevent' => { 489 => 'EventExt' },
	'showneventidentifier' => { 489 => [\'EventExt','EventExtIdentifier'] },
	'showneventname' => { 489 => [\'EventExt','EventExtName'] },
	'shutter' => { 438 => 0x20, 439 => 0x26, 440 => 0x26 },
	'shutter-aelock' => { 82 => 0x4, 84 => 0x701, 85 => 0x3, 86 => 0x4, 87 => 0x3, 88 => 0x3, 89 => 0x4, 90 => 0x2 },
	'shutteraelbutton' => { 83 => 0x4 },
	'shutterbuttonafonbutton' => { 84 => 0x701 },
	'shuttercount' => { 11 => 0x176, 57 => 0x1, 226 => 0xa7, 238 => [0x6a,0x157,0x24d], 239 => 0x286, 240 => 0x279, 241 => 0x284, 242 => 0x242, 243 => 0x280, 244 => 0x276, 245 => [0x27d,0x27f], 246 => 0x246, 249 => 0x2d6, 250 => 0x321, 251 => 0xbd8, 253 => 0x287, 254 => 0x320, 255 => 0x24a, 256 => 0x5fb, 259 => 0x2d5, 355 => 0x5d, 418 => 0x846, 423 => [0x125,0x14a], 438 => 0x32, 439 => 0x3a, 440 => 0x3a },
	'shuttercount2' => { 438 => 0x4c, 439 => [0x50,0x52,0x58], 440 => 0x50 },
	'shuttercount3' => { 438 => [0x1a0,0x1aa,0x1bd], 439 => [0x19f,0x1cb,0x1cd] },
	'shuttercurtainsync' => { 82 => 0xf, 83 => 0xf, 84 => 0x305, 85 => 0xe, 86 => 0xf, 87 => 0x8, 88 => 0x8, 89 => 0xf, 90 => 0x8 },
	'shuttermode' => { 57 => 0x17, 140 => 0x1b, 226 => 0x34 },
	'shutterreleasebuttonae-l' => { 279 => '17.7', 280 => '18.4', 282 => '78.4', 283 => '78.4', 284 => '16.1', 285 => '17.1', 286 => '17.1', 287 => '17.1', 288 => '7.1', 289 => '17.5', 292 => '18.4', 293 => '78.4', 294 => '18.2', 295 => 0x29 },
	'shutterreleasemethod' => { 97 => 0x1010 },
	'shutterreleasenocfcard' => { 82 => 0x2, 83 => 0x2, 90 => 0xf },
	'shutterreleasetiming' => { 97 => 0x1011 },
	'shutterreleasewithoutlens' => { 84 => 0x711 },
	'shutterspeedlock' => { 280 => '38.1', 282 => '38.1', 283 => '38.1', 292 => '38.1', 293 => '38.1', 295 => 0xb7 },
	'shutterspeedrange' => { 84 => 0x10c },
	'shutterspeedsetting' => { 184 => 0x6, 407 => 0x2f, 408 => 0x28, 409 => 0x0 },
	'shutterspeedvalue' => { 93 => 0x1, 119 => 0x9201, 302 => 0x1000, 364 => 0x400, 483 => 'ShutterSpeedValue' },
	'shuttertype' => { 127 => 0x1050, 320 => 0x9f, 355 => 0x87 },
	'sidecarforextension' => { 491 => 'SidecarForExtension' },
	'sigmaimpulseparameters' => { 138 => 0xe0d },
	'sigmascalingfactorcamera' => { 138 => 0xe0c },
	'sigmascalingfactorlowres' => { 138 => 0xe0b },
	'sigmasizetable' => { 138 => 0xe0f },
	'silentphotography' => { 226 => 0xbf },
	'similarityindex' => { 131 => 0xe4 },
	'singleframebracketing' => { 184 => 0x21 },
	'skilllevel' => { 495 => 'skillLevel' },
	'skintonecorrection' => { 355 => 0x95 },
	'skiplinetime' => { 138 => 0x184e },
	'slaveflashmeteringsegments' => { 355 => 0x20b },
	'slideshowname' => { 492 => 'slideshowName' },
	'slideshownumber' => { 492 => 'slideshowNumber' },
	'slideshowtotalnumber' => { 492 => 'slideshowTotalNumber' },
	'slowshutter' => { 77 => 0x8 },
	'slowsync' => { 127 => 0x1030 },
	'smartalbumcolor' => { 394 => 0x20 },
	'smartrange' => { 394 => 0xa012 },
	'smileshutter' => { 409 => 0x31 },
	'smileshuttermode' => { 409 => 0x27 },
	'smoothness' => { 119 => 0xfe57, 477 => 'Smoothness', 479 => 'Smoothness' },
	'snapshot' => { 489 => 'SnapshotLink' },
	'snapshotformat' => { 489 => [\'SnapshotLink','SnapshotLinkFormat'] },
	'snapshotheightpixels' => { 489 => [\'SnapshotLink','SnapshotLinkHeightPixels'] },
	'snapshotimagerole' => { 489 => [\'SnapshotLink','SnapshotLinkImageRole'] },
	'snapshotlink' => { 489 => [\'SnapshotLink','SnapshotLinkLink'] },
	'snapshotlinkqualifier' => { 489 => [\'SnapshotLink','SnapshotLinkLinkQualifier'] },
	'snapshots' => { 472 => 'Snapshots' },
	'snapshotusedvideoframe' => { 489 => [\'SnapshotLink','SnapshotLinkUsedVideoFrame'] },
	'snapshotusedvideoframetimeformat' => { 489 => [\'SnapshotLink','SnapshotLinkUsedVideoFrameTimeFormat'] },
	'snapshotusedvideoframetimevalue' => { 489 => [\'SnapshotLink','SnapshotLinkUsedVideoFrameTimeValue'] },
	'snapshotusedvideoframevalue' => { 489 => [\'SnapshotLink','SnapshotLinkUsedVideoFrameValue'] },
	'snapshotwidthpixels' => { 489 => [\'SnapshotLink','SnapshotLinkWidthPixels'] },
	'softskineffect' => { 420 => 0x200f },
	'software' => { 119 => 0x131, 157 => 'Software', 310 => 'Software', 364 => 0x203, 374 => 'software', 397 => 0x18, 462 => 'Software', 499 => 'Software' },
	'softwareversion' => { 380 => ['@swr',"\xa9swr"], 396 => 0x207 },
	'soloist' => { 372 => "\xa9sol" },
	'songwriter' => { 380 => "\xa9swf" },
	'songwriterkeywords' => { 380 => "\xa9swk" },
	'sonycropsize' => { 119 => 0x74c8 },
	'sonycroptopleft' => { 119 => 0x74c7 },
	'sonydatetime' => { 427 => 0x6, 429 => 0x1b6, 430 => 0x210, 431 => 0x1fe, 432 => 0x22c },
	'sonydatetime2' => { 438 => 0x51 },
	'sonyexposuretime' => { 438 => 0x3a, 439 => 0x46, 440 => [0x66,0x46] },
	'sonyexposuretime2' => { 450 => 0xe },
	'sonyfnumber' => { 438 => 0x3c, 439 => 0x48, 440 => [0x68,0x48], 450 => 0x14 },
	'sonyimageheight' => { 427 => 0x1a, 441 => 0x44, 442 => 0x3f, 443 => 0x47 },
	'sonyimageheightmax' => { 450 => 0x40 },
	'sonyimagesize' => { 184 => 0x3b, 407 => 0x54, 408 => 0x54, 409 => 0x9 },
	'sonyimagewidth' => { 427 => 0x1c },
	'sonyimagewidthmax' => { 450 => 0x3e },
	'sonyiso' => { 429 => 0x1218, 430 => 0x11f4, 431 => 0x1270, 432 => [0x1254,0x1258,0x1280], 433 => 0x113c, 434 => 0x344, 435 => 0x346, 436 => 0x320, 450 => 0x4 },
	'sonymaxaperture' => { 438 => 0x0, 439 => 0x0 },
	'sonymaxaperturevalue' => { 450 => 0x16 },
	'sonyminaperture' => { 438 => 0x1, 439 => 0x1 },
	'sonymodelid' => { 420 => 0xb001 },
	'sonyquality' => { 184 => 0x3c },
	'sonytimeminsec' => { 439 => 0x61 },
	'sortalbum' => { 372 => 'soal' },
	'sortalbumartist' => { 372 => 'soaa' },
	'sortartist' => { 372 => 'soar' },
	'sortcomposer' => { 372 => 'soco' },
	'sortname' => { 372 => 'sonm', 477 => 'SortName', 479 => 'SortName' },
	'sortshow' => { 372 => 'sosn' },
	'soundengineer' => { 372 => "\xa9sne" },
	'source' => { 131 => 0x73, 310 => 'Source', 480 => 'source', 481 => 'source', 491 => 'Source' },
	'sourcecount' => { 466 => 'SourceCount' },
	'sourcecredits' => { 380 => "\xa9src" },
	'sourcedirectoryindex' => { 342 => 0x0 },
	'sourcefileindex' => { 342 => 0x2 },
	'sourcephotoscount' => { 465 => 'SourcePhotosCount' },
	'sourceprofileprefix' => { 138 => 0x1390 },
	'spatialfrequencyresponse' => { 483 => 'SpatialFrequencyResponse' },
	'spatialfrequencyresponsecolumns' => { 483 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseColumns'] },
	'spatialfrequencyresponsenames' => { 483 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseNames'] },
	'spatialfrequencyresponserows' => { 483 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseRows'] },
	'spatialfrequencyresponsevalues' => { 483 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseValues'] },
	'speakerplacement' => { 503 => 'speakerPlacement' },
	'specialeffectlevel' => { 113 => 0x3030 },
	'specialeffectmode' => { 113 => 0x2076 },
	'specialeffectsetting' => { 113 => 0x3031 },
	'specialinstructions' => { 131 => 0x28 },
	'specialmode' => { 302 => 0x200, 396 => 0x200 },
	'specialoccasion' => { 495 => 'specialOccasion' },
	'specialtypeid' => { 460 => 'SpecialTypeID' },
	'spectralsensitivity' => { 119 => 0x8824, 483 => 'SpectralSensitivity' },
	'specularwhitelevel' => { 41 => 0x32b, 42 => 0x281, 45 => [0x2b9,0x2d0,0x2d4], 46 => 0x56a, 47 => 0x1e4, 48 => [0x1fd,0x2dd], 49 => [0x231,0x30f], 50 => 0x31d },
	'speedx' => { 115 => 0x3, 380 => "\xa9xsp" },
	'speedy' => { 115 => 0x4, 380 => "\xa9ysp" },
	'speedz' => { 115 => 0x5, 380 => "\xa9zsp" },
	'spherical' => { 466 => 'Spherical' },
	'splitcolumn' => { 364 => 0x222 },
	'splittoningbalance' => { 477 => 'SplitToningBalance', 479 => 'SplitToningBalance' },
	'splittoninghighlighthue' => { 477 => 'SplitToningHighlightHue', 479 => 'SplitToningHighlightHue' },
	'splittoninghighlightsaturation' => { 477 => 'SplitToningHighlightSaturation', 479 => 'SplitToningHighlightSaturation' },
	'splittoningshadowhue' => { 477 => 'SplitToningShadowHue', 479 => 'SplitToningShadowHue' },
	'splittoningshadowsaturation' => { 477 => 'SplitToningShadowSaturation', 479 => 'SplitToningShadowSaturation' },
	'sport' => { 493 => 'sport' },
	'spotfocuspointx' => { 181 => 0x2d },
	'spotfocuspointy' => { 181 => 0x2e },
	'spotmeteringmode' => { 34 => 0x27 },
	'spotmeterlinktoafpoint' => { 84 => 0x107 },
	'sractive' => { 336 => '17.1' },
	'srawquality' => { 34 => 0x2e },
	'srfocallength' => { 357 => 0x3 },
	'srgbrendering' => { 308 => 'sRGB' },
	'srhalfpresstime' => { 357 => 0x2 },
	'srresult' => { 357 => 0x0, 358 => 0x0 },
	'stackedimage' => { 297 => 0x804 },
	'standardmatrixcustom' => { 138 => 0x7d4 },
	'standardmatrixdaylight' => { 138 => 0x7d0 },
	'standardmatrixflash' => { 138 => 0x7d3 },
	'standardmatrixfluorescent' => { 138 => 0x7d2 },
	'standardmatrixtungsten' => { 138 => 0x7d1 },
	'standardoutputhighlightpoint' => { 109 => 0x14 },
	'standardoutputsensitivity' => { 119 => 0x8831, 484 => 'StandardOutputSensitivity' },
	'standardoutputshadowpoint' => { 109 => 0x15 },
	'standardrawcolortone' => { 109 => 0xd },
	'standardrawcontrast' => { 109 => 0xf },
	'standardrawhighlight' => { 109 => 0x75 },
	'standardrawhighlightpoint' => { 109 => 0x12 },
	'standardrawlinear' => { 109 => 0x10 },
	'standardrawsaturation' => { 109 => 0xe },
	'standardrawshadow' => { 109 => 0x7e },
	'standardrawshadowpoint' => { 109 => 0x13 },
	'standardrawsharpness' => { 109 => 0x11 },
	'standardunsharpmaskfineness' => { 109 => 0x94 },
	'standardunsharpmaskstrength' => { 109 => 0x92 },
	'standardunsharpmaskthreshold' => { 109 => 0x96 },
	'standardwhitecustom' => { 138 => 0x838 },
	'standardwhitedaylight' => { 138 => 0x834 },
	'standardwhiteflash' => { 138 => 0x837 },
	'standardwhitefluorescent' => { 138 => 0x836 },
	'standardwhitetungsten' => { 138 => 0x835 },
	'standbytimer' => { 280 => '19.1', 282 => '19.1', 283 => '19.1', 286 => '18.1', 287 => '18.1', 292 => '19.1', 293 => '19.1' },
	'starlightview' => { 295 => 0x249 },
	'startingpage' => { 493 => 'startingPage' },
	'startmovieshooting' => { 84 => 0x70d },
	'starttimecode' => { 380 => "\xa9TIM", 503 => 'startTimecode' },
	'starttimecodetimeformat' => { 503 => [\'startTimecode','startTimecodeTimeFormat'] },
	'starttimecodetimevalue' => { 503 => [\'startTimecode','startTimecodeTimeValue'] },
	'starttimecodevalue' => { 503 => [\'startTimecode','startTimecodeValue'] },
	'starttimesamplesize' => { 380 => "\xa9TSZ", 503 => 'startTimeSampleSize' },
	'starttimescale' => { 380 => "\xa9TSC", 503 => 'startTimeScale' },
	'state' => { 161 => 'State', 320 => 0x6b, 491 => 'State' },
	'status' => { 458 => 'Status', 470 => 'Status' },
	'stereomode' => { 466 => 'StereoMode' },
	'stitched' => { 466 => 'Stitched' },
	'stitchingsoftware' => { 465 => 'StitchingSoftware', 466 => 'StitchingSoftware' },
	'stopsabovebaseiso' => { 428 => 0x113e, 429 => 0x113e, 430 => 0x111a, 431 => 0x1196, 432 => 0x1172, 433 => 0x102a, 434 => 0x222, 435 => 0x222, 436 => 0x217, 450 => 0xa },
	'storagemethod' => { 188 => 0x12 },
	'storebyorientation' => { 280 => '46.3', 282 => '47.3', 283 => '47.3', 292 => '47.3', 293 => '47.3', 295 => 0xd },
	'storedescription' => { 372 => 'sdes' },
	'storylineidentifier' => { 489 => 'StorylineIdentifier' },
	'straightenangle' => { 272 => 0x2fc08431 },
	'streamready' => { 489 => 'StreamReady' },
	'streamtype' => { 176 => 'StreamType' },
	'stretchmode' => { 503 => 'stretchMode' },
	'studydatetime' => { 456 => 'StudyDateTime' },
	'studydescription' => { 456 => 'StudyDescription' },
	'studyid' => { 456 => 'StudyID' },
	'studyphysician' => { 456 => 'StudyPhysician' },
	'styleperiod' => { 489 => 'StylePeriod' },
	'sub-location' => { 131 => 0x5c },
	'subcommanddialplaybackmode' => { 295 => 0x1cf },
	'subfiledata' => { 164 => 'data' },
	'subfiledirectory' => { 164 => '1Directory' },
	'subfilemimetype' => { 164 => '2MIME' },
	'subfilename' => { 164 => '1Name' },
	'subfileresource' => { 164 => 'rsrc' },
	'subfiletype' => { 119 => 0xfe, 164 => '0Type' },
	'subject' => { 306 => 'Subject', 371 => 'Subject', 480 => 'subject', 490 => 'Subject', 504 => 'subject' },
	'subjectarea' => { 119 => 0x9214, 483 => 'SubjectArea' },
	'subjectcode' => { 488 => 'SubjectCode' },
	'subjectdetection' => { 229 => 0x23e },
	'subjectdistance' => { 119 => 0x9206, 140 => 0x3e, 483 => 'SubjectDistance' },
	'subjectdistancerange' => { 119 => 0xa40c, 483 => 'SubjectDistanceRange' },
	'subjectlocation' => { 119 => 0xa214, 483 => 'SubjectLocation' },
	'subjectmotion' => { 282 => '78.2', 283 => '78.2', 293 => '78.2', 295 => 0x103 },
	'subjectprogram' => { 181 => 0x22 },
	'subjectreference' => { 131 => 0xc },
	'sublabels1' => { 487 => [\'TagStructure','TagStructureSubLabels'] },
	'sublabels2' => { 487 => [\'TagStructure','TagStructureSubLabelsSubLabels'] },
	'sublabels3' => { 487 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabels'] },
	'sublabels4' => { 487 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabels'] },
	'sublabels5' => { 487 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabels'] },
	'subseccreatedate' => { 114 => 'Exif-SubSecCreateDate' },
	'subsecdatetimeoriginal' => { 114 => 'Exif-SubSecDateTimeOriginal' },
	'subsecmodifydate' => { 114 => 'Exif-SubSecModifyDate' },
	'subsectime' => { 119 => 0x9290 },
	'subsectimedigitized' => { 119 => 0x9292 },
	'subsectimeoriginal' => { 119 => 0x9291 },
	'subsection1' => { 493 => 'subsection1' },
	'subsection2' => { 493 => 'subsection2' },
	'subsection3' => { 493 => 'subsection3' },
	'subsection4' => { 493 => 'subsection4' },
	'subselector' => { 280 => '49.1', 282 => '71.1', 283 => '71.1', 293 => '71.1', 295 => 0x8f },
	'subselectorassignment' => { 280 => '48.1' },
	'subselectorcenter' => { 282 => '72.1', 283 => '72.1', 293 => '72.1' },
	'subselectorplusdials' => { 280 => '49.2', 282 => '73.1', 283 => '73.1', 293 => '73.1' },
	'subtitle' => { 179 => 'WM/SubTitle', 372 => "\xa9st3", 380 => "\xa9snm", 493 => 'subtitle' },
	'subtitlekeywords' => { 380 => "\xa9snk" },
	'subversionfilename' => { 487 => [\'SubVersions','SubVersionsFileName'] },
	'subversionreference' => { 487 => [\'SubVersions','SubVersionsVersRef'] },
	'subversions' => { 487 => 'SubVersions' },
	'superimposeddisplay' => { 82 => 0xa, 84 => 0x510, 85 => 0x9, 86 => 0xa, 89 => 0xa, 90 => 0xe },
	'supermacro' => { 64 => 0x1a },
	'supplementalcategories' => { 131 => 0x14, 491 => 'SupplementalCategories' },
	'supplementaltype' => { 133 => 0x37 },
	'supplementdisplayid' => { 493 => 'supplementDisplayID' },
	'supplementstartingpage' => { 493 => 'supplementStartingPage' },
	'supplementtitle' => { 493 => 'supplementTitle' },
	'supplychainsource' => { 489 => 'SupplyChainSource' },
	'supplychainsourceidentifier' => { 489 => [\'SupplyChainSource','SupplyChainSourceIdentifier'] },
	'supplychainsourcename' => { 489 => [\'SupplyChainSource','SupplyChainSourceName'] },
	'supportsamount' => { 477 => 'SupportsAmount', 479 => 'SupportsAmount' },
	'supportscolor' => { 477 => 'SupportsColor', 479 => 'SupportsColor' },
	'supportshighdynamicrange' => { 477 => 'SupportsHighDynamicRange', 479 => 'SupportsHighDynamicRange' },
	'supportsmonochrome' => { 477 => 'SupportsMonochrome', 479 => 'SupportsMonochrome' },
	'supportsnormaldynamicrange' => { 477 => 'SupportsNormalDynamicRange', 479 => 'SupportsNormalDynamicRange' },
	'supportsoutputreferred' => { 477 => 'SupportsOutputReferred', 479 => 'SupportsOutputReferred' },
	'supportsscenereferred' => { 477 => 'SupportsSceneReferred', 479 => 'SupportsSceneReferred' },
	'svisosetting' => { 336 => 0x14 },
	'swatchcoloranta' => { 508 => [\'SwatchGroups','SwatchGroupsColorantsA'] },
	'swatchcolorantb' => { 508 => [\'SwatchGroups','SwatchGroupsColorantsB'] },
	'swatchcolorantblack' => { 508 => [\'SwatchGroups','SwatchGroupsColorantsBlack'] },
	'swatchcolorantblue' => { 508 => [\'SwatchGroups','SwatchGroupsColorantsBlue'] },
	'swatchcolorantcyan' => { 508 => [\'SwatchGroups','SwatchGroupsColorantsCyan'] },
	'swatchcolorantgray' => { 508 => [\'SwatchGroups','SwatchGroupsColorantsGray'] },
	'swatchcolorantgreen' => { 508 => [\'SwatchGroups','SwatchGroupsColorantsGreen'] },
	'swatchcolorantl' => { 508 => [\'SwatchGroups','SwatchGroupsColorantsL'] },
	'swatchcolorantmagenta' => { 508 => [\'SwatchGroups','SwatchGroupsColorantsMagenta'] },
	'swatchcolorantmode' => { 508 => [\'SwatchGroups','SwatchGroupsColorantsMode'] },
	'swatchcolorantred' => { 508 => [\'SwatchGroups','SwatchGroupsColorantsRed'] },
	'swatchcolorantswatchname' => { 508 => [\'SwatchGroups','SwatchGroupsColorantsSwatchName'] },
	'swatchcoloranttint' => { 508 => [\'SwatchGroups','SwatchGroupsColorantsTint'] },
	'swatchcoloranttype' => { 508 => [\'SwatchGroups','SwatchGroupsColorantsType'] },
	'swatchcolorantyellow' => { 508 => [\'SwatchGroups','SwatchGroupsColorantsYellow'] },
	'swatchgroupname' => { 508 => [\'SwatchGroups','SwatchGroupsGroupName'] },
	'swatchgroups' => { 508 => 'SwatchGroups' },
	'swatchgroupscolorants' => { 508 => [\'SwatchGroups','SwatchGroupsColorants'] },
	'swatchgrouptype' => { 508 => [\'SwatchGroups','SwatchGroupsGroupType'] },
	'sweeppanoramadirection' => { 320 => 0x93, 409 => 0x33 },
	'sweeppanoramafieldofview' => { 320 => 0x94 },
	'sweeppanoramasize' => { 409 => 0x32 },
	'switchtoregisteredafpoint' => { 83 => 0x12, 84 => 0x50a },
	'symlink' => { 120 => 'SymLink' },
	'syncreleasemode' => { 282 => '77.1', 283 => '77.1', 293 => '77.1', 295 => 0x41 },
	'system' => { 364 => 0x204 },
	'tagged' => { 366 => 0xdd, 367 => 'Tagged', 472 => 'tagged' },
	'tagslist' => { 482 => 'TagsList' },
	'tagstructure' => { 487 => 'TagStructure' },
	'takenumber' => { 503 => 'takeNumber' },
	'tapename' => { 503 => 'tapeName' },
	'targetaperture' => { 77 => 0x4 },
	'targetcompressionratio' => { 95 => 0x1 },
	'targetdistancesetting' => { 97 => 0x1807 },
	'targetexposuretime' => { 77 => 0x5 },
	'targetimagetype' => { 97 => 0x100a },
	'targetprinter' => { 119 => 0x151 },
	'taxon' => { 118 => 'Taxon' },
	'taxonacceptednameusage' => { 118 => [\'Taxon','TaxonAcceptedNameUsage'] },
	'taxonacceptednameusageid' => { 118 => [\'Taxon','TaxonAcceptedNameUsageID'] },
	'taxonclass' => { 118 => [\'Taxon','TaxonClass'] },
	'taxonconceptid' => { 118 => [\'Taxon','TaxonTaxonConceptID'] },
	'taxonfamily' => { 118 => [\'Taxon','TaxonFamily'] },
	'taxongenus' => { 118 => [\'Taxon','TaxonGenus'] },
	'taxonhigherclassification' => { 118 => [\'Taxon','TaxonHigherClassification'] },
	'taxonid' => { 118 => [\'Taxon','TaxonTaxonID'] },
	'taxoninfraspecificepithet' => { 118 => [\'Taxon','TaxonInfraspecificEpithet'] },
	'taxonkingdom' => { 118 => [\'Taxon','TaxonKingdom'] },
	'taxonnameaccordingto' => { 118 => [\'Taxon','TaxonNameAccordingTo'] },
	'taxonnameaccordingtoid' => { 118 => [\'Taxon','TaxonNameAccordingToID'] },
	'taxonnamepublishedin' => { 118 => [\'Taxon','TaxonNamePublishedIn'] },
	'taxonnamepublishedinid' => { 118 => [\'Taxon','TaxonNamePublishedInID'] },
	'taxonnamepublishedinyear' => { 118 => [\'Taxon','TaxonNamePublishedInYear'] },
	'taxonnomenclaturalcode' => { 118 => [\'Taxon','TaxonNomenclaturalCode'] },
	'taxonnomenclaturalstatus' => { 118 => [\'Taxon','TaxonNomenclaturalStatus'] },
	'taxonorder' => { 118 => [\'Taxon','TaxonOrder'] },
	'taxonoriginalnameusage' => { 118 => [\'Taxon','TaxonOriginalNameUsage'] },
	'taxonoriginalnameusageid' => { 118 => [\'Taxon','TaxonOriginalNameUsageID'] },
	'taxonparentnameusage' => { 118 => [\'Taxon','TaxonParentNameUsage'] },
	'taxonparentnameusageid' => { 118 => [\'Taxon','TaxonParentNameUsageID'] },
	'taxonphylum' => { 118 => [\'Taxon','TaxonPhylum'] },
	'taxonrank' => { 118 => [\'Taxon','TaxonTaxonRank'] },
	'taxonremarks' => { 118 => [\'Taxon','TaxonTaxonRemarks'] },
	'taxonscientificname' => { 118 => [\'Taxon','TaxonScientificName'] },
	'taxonscientificnameauthorship' => { 118 => [\'Taxon','TaxonScientificNameAuthorship'] },
	'taxonscientificnameid' => { 118 => [\'Taxon','TaxonScientificNameID'] },
	'taxonspecificepithet' => { 118 => [\'Taxon','TaxonSpecificEpithet'] },
	'taxonsubgenus' => { 118 => [\'Taxon','TaxonSubgenus'] },
	'taxontaxonomicstatus' => { 118 => [\'Taxon','TaxonTaxonomicStatus'] },
	'taxonverbatimtaxonrank' => { 118 => [\'Taxon','TaxonVerbatimTaxonRank'] },
	'taxonvernacularname' => { 118 => [\'Taxon','TaxonVernacularName'] },
	'tda1bandwidth' => { 138 => 0x196f },
	'tda1edgepolarity' => { 138 => 0x1971 },
	'tda1gain' => { 138 => 0x1970 },
	'tda1offset' => { 138 => 0x196e },
	'tda2bandwidth' => { 138 => 0x1979 },
	'tda2edgepolarity' => { 138 => 0x197b },
	'tda2gain' => { 138 => 0x197a },
	'tda2offset' => { 138 => 0x1978 },
	'tda3bandwidth' => { 138 => 0x1983 },
	'tda3edgepolarity' => { 138 => 0x1985 },
	'tda3gain' => { 138 => 0x1984 },
	'tda3offset' => { 138 => 0x1982 },
	'tda4bandwidth' => { 138 => 0x198d },
	'tda4edgepolarity' => { 138 => 0x198f },
	'tda4gain' => { 138 => 0x198e },
	'tda4offset' => { 138 => 0x198c },
	'teaser' => { 493 => 'teaser' },
	'teleconverter' => { 186 => 0x105, 420 => 0x105 },
	'tempampgainx100' => { 138 => 0x1914 },
	'tempo' => { 503 => 'tempo' },
	'temporalcoverage' => { 489 => 'TemporalCoverage' },
	'temporalcoveragefrom' => { 489 => [\'TemporalCoverage','TemporalCoverageTempCoverageFrom'] },
	'temporalcoverageto' => { 489 => [\'TemporalCoverage','TemporalCoverageTempCoverageTo'] },
	'termsandconditionstext' => { 307 => 'TermsAndConditionsText' },
	'termsandconditionsurl' => { 307 => 'TermsAndConditionsURL' },
	'testname' => { 120 => 'TestName' },
	'textencoding' => { 225 => 0x4 },
	'textlayername' => { 491 => [\'TextLayers','TextLayersLayerName'] },
	'textlayers' => { 491 => 'TextLayers' },
	'textlayertext' => { 491 => [\'TextLayers','TextLayersLayerText'] },
	'textstamp' => { 320 => [0x8008,0x8009,0x3b,0x3e] },
	'texture' => { 477 => 'Texture', 479 => 'Texture' },
	'three-dtrackingfacedetection' => { 282 => '1.4', 283 => '1.4', 293 => '1.4' },
	'three-dtrackingwatcharea' => { 282 => '78.1', 283 => '78.1', 293 => '78.1' },
	'thresholding' => { 119 => 0x107 },
	'thumbnailfilename' => { 97 => 0x817 },
	'thumbnailformat' => { 501 => [\'Thumbnails','ThumbnailsFormat'] },
	'thumbnailheight' => { 142 => 0xfa55, 501 => [\'Thumbnails','ThumbnailsHeight'] },
	'thumbnailimage' => { 6 => 'CNDA', 97 => 0x2008, 114 => 'Exif-ThumbnailImage', 122 => 0x3, 167 => 'data', 302 => 0x100, 380 => 'thmb', 501 => [\'Thumbnails','ThumbnailsImage'] },
	'thumbnailimagename' => { 167 => '1Name' },
	'thumbnailimagesize' => { 167 => 'ImageSize' },
	'thumbnailimagetype' => { 167 => '0Type' },
	'thumbnailimagevalidarea' => { 64 => 0x13 },
	'thumbnaillength' => { 119 => 0x202 },
	'thumbnailoffset' => { 119 => 0x201 },
	'thumbnailpng' => { 380 => 'thmb' },
	'thumbnails' => { 501 => 'Thumbnails' },
	'thumbnailwidth' => { 142 => 0xfa54, 501 => [\'Thumbnails','ThumbnailsWidth'] },
	'ticker' => { 493 => 'ticker' },
	'tiffhandling' => { 477 => 'TIFFHandling', 479 => 'TIFFHandling' },
	'tiffmeteringimage' => { 187 => 0x104c, 418 => 0x1110 },
	'tilelength' => { 119 => 0x143 },
	'tilewidth' => { 119 => 0x142 },
	'time' => { 138 => 0x401, 355 => 0x7 },
	'timecodes' => { 119 => 0xc763 },
	'timecreated' => { 131 => 0x3c, 140 => 0x14, 149 => 0x10, 367 => 'TimeCreated' },
	'timelapseshotnumber' => { 323 => 0x10 },
	'timeperiod' => { 493 => 'timePeriod' },
	'timerfunctionbutton' => { 281 => '5.2', 284 => '12.1', 285 => '13.1' },
	'timerlength' => { 84 => 0x80c },
	'timerrecording' => { 320 => 0x96 },
	'timescaleparams' => { 503 => 'timeScaleParams' },
	'timescaleparamsframeoverlappingpercentage' => { 503 => [\'timeScaleParams','timeScaleParamsFrameOverlappingPercentage'] },
	'timescaleparamsframesize' => { 503 => [\'timeScaleParams','timeScaleParamsFrameSize'] },
	'timescaleparamsquality' => { 503 => [\'timeScaleParams','timeScaleParamsQuality'] },
	'timesent' => { 132 => 0x50 },
	'timeshot' => { 467 => 'TimeShot' },
	'timesignature' => { 503 => 'timeSignature' },
	'timesincepoweron' => { 320 => 0x29 },
	'timestamp' => { 11 => 0x45e, 19 => 0x11c, 296 => 0x8, 310 => 'TimeStamp', 320 => 0xaf, 466 => 'Timestamp', 473 => 'Timestamp', 487 => 'TimeStamp' },
	'timestamp1' => { 11 => 0x45a },
	'timezone' => { 78 => 0x1, 229 => 0x594, 264 => 0x0, 390 => 0xa },
	'timezonecity' => { 78 => 0x2 },
	'timezonecode' => { 100 => 0x1 },
	'timezoneinfo' => { 100 => 0x2 },
	'timezoneoffset' => { 119 => 0x882a },
	'tint' => { 374 => 'player.movie.visual.tint', 477 => 'Tint', 479 => 'Tint' },
	'title' => { 157 => 'Title', 306 => 'Title', 310 => 'Title', 320 => 0x65, 371 => 'Title', 372 => ['titl',"\xa9nam"], 374 => 'title', 380 => ['titl',"\xa9nam"], 480 => 'title', 490 => 'Title', 501 => 'Title' },
	'togglestyleamount' => { 477 => 'ToggleStyleAmount', 479 => 'ToggleStyleAmount' },
	'togglestyledigest' => { 477 => 'ToggleStyleDigest', 479 => 'ToggleStyleDigest' },
	'tonecomp' => { 226 => 0x81 },
	'tonecurve' => { 74 => 0x1, 355 => 0x402, 477 => 'ToneCurve', 479 => 'ToneCurve' },
	'tonecurveactive' => { 108 => 0x110 },
	'tonecurveadobergb' => { 394 => 0xa043 },
	'tonecurveadobergbdefault' => { 394 => 0xa041 },
	'tonecurveblue' => { 477 => 'ToneCurveBlue', 479 => 'ToneCurveBlue' },
	'tonecurvebluex' => { 454 => 0x9003 },
	'tonecurvebluey' => { 454 => 0x9007 },
	'tonecurvebrightness' => { 103 => 0x20410 },
	'tonecurvebrightnessx' => { 454 => 0x9000 },
	'tonecurvebrightnessy' => { 454 => 0x9004 },
	'tonecurvecolorspace' => { 107 => 0x0 },
	'tonecurvecontrast' => { 103 => 0x20411 },
	'tonecurvegreen' => { 477 => 'ToneCurveGreen', 479 => 'ToneCurveGreen' },
	'tonecurvegreenx' => { 454 => 0x9002 },
	'tonecurvegreeny' => { 454 => 0x9006 },
	'tonecurveinputrange' => { 107 => 0x3 },
	'tonecurveinterpolation' => { 108 => 0x159 },
	'tonecurvemode' => { 108 => 0x113 },
	'tonecurvename' => { 477 => 'ToneCurveName', 479 => 'ToneCurveName' },
	'tonecurvename2012' => { 477 => 'ToneCurveName2012', 479 => 'ToneCurveName2012' },
	'tonecurveoriginal' => { 103 => '0x20400.1' },
	'tonecurveoutputrange' => { 107 => 0x5 },
	'tonecurveprofilename' => { 138 => 0x1391 },
	'tonecurveproperty' => { 108 => 0x3c },
	'tonecurvepv2012' => { 477 => 'ToneCurvePV2012', 479 => 'ToneCurvePV2012' },
	'tonecurvepv2012blue' => { 477 => 'ToneCurvePV2012Blue', 479 => 'ToneCurvePV2012Blue' },
	'tonecurvepv2012green' => { 477 => 'ToneCurvePV2012Green', 479 => 'ToneCurvePV2012Green' },
	'tonecurvepv2012red' => { 477 => 'ToneCurvePV2012Red', 479 => 'ToneCurvePV2012Red' },
	'tonecurvered' => { 477 => 'ToneCurveRed', 479 => 'ToneCurveRed' },
	'tonecurveredx' => { 454 => 0x9001 },
	'tonecurveredy' => { 454 => 0x9005 },
	'tonecurves' => { 355 => 0x403 },
	'tonecurveshape' => { 107 => 0x1 },
	'tonecurvesrgb' => { 394 => 0xa042 },
	'tonecurvesrgbdefault' => { 394 => 0xa040 },
	'tonecurvex' => { 107 => 0xa },
	'tonecurvey' => { 107 => 0xb },
	'tonelevel' => { 297 => 0x52e },
	'tonemapstrength' => { 477 => 'ToneMapStrength', 479 => 'ToneMapStrength' },
	'toningeffect' => { 57 => 0xf, 226 => 0xb3, 231 => 0x38, 232 => 0x40, 233 => 0x48, 387 => 0x1015 },
	'toningeffectauto' => { 71 => 0xa4 },
	'toningeffectfaithful' => { 70 => 0x74, 71 => 0x74 },
	'toningeffectlandscape' => { 70 => 0x44, 71 => 0x44 },
	'toningeffectmonochrome' => { 19 => 0x108, 70 => 0x8c, 71 => 0x8c },
	'toningeffectneutral' => { 70 => 0x5c, 71 => 0x5c },
	'toningeffectportrait' => { 70 => 0x2c, 71 => 0x2c },
	'toningeffectstandard' => { 70 => 0x14, 71 => 0x14 },
	'toningeffectuserdef1' => { 70 => 0xa4, 71 => 0xbc },
	'toningeffectuserdef2' => { 70 => 0xbc, 71 => 0xd4 },
	'toningeffectuserdef3' => { 70 => 0xd4, 71 => 0xec },
	'toningsaturation' => { 231 => 0x39, 232 => 0x41, 233 => 0x49 },
	'totalzoom' => { 140 => 0x62 },
	'touchae' => { 320 => 0xab },
	'track' => { 372 => "\xa9trk", 380 => "\xa9trk" },
	'trackcreatedate' => { 379 => 0x1 },
	'trackmodifydate' => { 379 => 0x2 },
	'tracknumber' => { 372 => 'trkn', 503 => 'trackNumber' },
	'tracks' => { 503 => 'Tracks' },
	'tracksframerate' => { 503 => [\'Tracks','TracksFrameRate'] },
	'tracksmarkers' => { 503 => [\'Tracks','TracksMarkers'] },
	'tracksmarkerscomment' => { 503 => [\'Tracks','TracksMarkersComment'] },
	'tracksmarkerscuepointparams' => { 503 => [\'Tracks','TracksMarkersCuePointParams'] },
	'tracksmarkerscuepointparamskey' => { 503 => [\'Tracks','TracksMarkersCuePointParamsKey'] },
	'tracksmarkerscuepointparamsvalue' => { 503 => [\'Tracks','TracksMarkersCuePointParamsValue'] },
	'tracksmarkerscuepointtype' => { 503 => [\'Tracks','TracksMarkersCuePointType'] },
	'tracksmarkersduration' => { 503 => [\'Tracks','TracksMarkersDuration'] },
	'tracksmarkerslocation' => { 503 => [\'Tracks','TracksMarkersLocation'] },
	'tracksmarkersname' => { 503 => [\'Tracks','TracksMarkersName'] },
	'tracksmarkersprobability' => { 503 => [\'Tracks','TracksMarkersProbability'] },
	'tracksmarkersspeaker' => { 503 => [\'Tracks','TracksMarkersSpeaker'] },
	'tracksmarkersstarttime' => { 503 => [\'Tracks','TracksMarkersStartTime'] },
	'tracksmarkerstarget' => { 503 => [\'Tracks','TracksMarkersTarget'] },
	'tracksmarkerstype' => { 503 => [\'Tracks','TracksMarkersType'] },
	'trackstrackname' => { 503 => [\'Tracks','TracksTrackName'] },
	'trackstracktype' => { 503 => [\'Tracks','TracksTrackType'] },
	'tracktype' => { 380 => 'kgtt' },
	'trailer' => { 120 => 'Trailer' },
	'trailersignature' => { 164 => 'zmie' },
	'transcript' => { 489 => 'Transcript' },
	'transcriptlink' => { 489 => 'TranscriptLink' },
	'transcriptlinklink' => { 489 => [\'TranscriptLink','TranscriptLinkLink'] },
	'transcriptlinklinkqualifier' => { 489 => [\'TranscriptLink','TranscriptLinkLinkQualifier'] },
	'transferfunction' => { 119 => 0x12d, 499 => 'TransferFunction' },
	'transfertimenormal' => { 138 => 0x1888 },
	'transfertimetest' => { 138 => 0x1889 },
	'transform' => { 320 => [0x8012,0x59] },
	'transmissionreference' => { 491 => 'TransmissionReference' },
	'trapped' => { 306 => 'Trapped', 490 => 'Trapped' },
	'trashbuttonfunction' => { 84 => 0x710 },
	'travelday' => { 320 => 0x36 },
	'treble' => { 374 => 'player.movie.audio.treble' },
	'triggermode' => { 381 => 0x6, 382 => 0x34, 383 => 0x34 },
	'tstop' => { 119 => 0xc772 },
	'ttl_da_adown' => { 343 => 0x5 },
	'ttl_da_aup' => { 343 => 0x4 },
	'ttl_da_bdown' => { 343 => 0x7 },
	'ttl_da_bup' => { 343 => 0x6 },
	'tungstenawb' => { 333 => 0x1 },
	'tvepisode' => { 372 => 'tves' },
	'tvepisodeid' => { 372 => 'tven' },
	'tvexposuretimesetting' => { 336 => 0x12 },
	'tvnetworkname' => { 372 => 'tvnn' },
	'tvseason' => { 372 => 'tvsn' },
	'tvshow' => { 372 => 'tvsh' },
	'type' => { 480 => 'type', 498 => 'type' },
	'typestatus' => { 118 => [\'Identification','IdentificationTypeStatus'] },
	'uniquecameramodel' => { 119 => 0xc614 },
	'uniquedocumentid' => { 131 => 0xbb },
	'uniquematrixauto' => { 138 => 0x7e9 },
	'uniquematrixcustom' => { 138 => 0x7e8 },
	'uniquematrixdaylight' => { 138 => 0x7e4 },
	'uniquematrixflash' => { 138 => 0x7e7 },
	'uniquematrixfluorescent' => { 138 => 0x7e6 },
	'uniquematrixtungsten' => { 138 => 0x7e5 },
	'uniqueobjectname' => { 132 => 0x64 },
	'units' => { 462 => 'Units' },
	'unknown_aacr' => { 372 => 'AACR' },
	'unknown_cdek' => { 372 => 'CDEK' },
	'unknown_cdet' => { 372 => 'CDET' },
	'unknownblock' => { 355 => 0x405 },
	'unknownblock1' => { 301 => 0x635 },
	'unknownblock2' => { 301 => 0x636 },
	'unknownblock3' => { 301 => 0x1103 },
	'unknownblock4' => { 301 => 0x1104 },
	'unknowncontrast' => { 109 => 0x45 },
	'unknowndate' => { 364 => 0x212 },
	'unknownev' => { 138 => 0x1 },
	'unknownlinear' => { 109 => 0x46 },
	'unknownnumber' => { 97 => 0x180b },
	'unknownoutputhighlightpoint' => { 109 => 0x4a },
	'unknownoutputshadowpoint' => { 109 => 0x4b },
	'unknownrawhighlight' => { 109 => 0x7b },
	'unknownrawhighlightpoint' => { 109 => 0x48 },
	'unknownrawshadow' => { 109 => 0x84 },
	'unknownrawshadowpoint' => { 109 => 0x49 },
	'unknownsharpness' => { 109 => 0x47 },
	'unknowntags' => { 380 => 'TAGS' },
	'unknowntemperature' => { 121 => 0x4 },
	'unknownthumbnail' => { 380 => 'thmb' },
	'unsharp1color' => { 277 => 0x13 },
	'unsharp1halowidth' => { 277 => 0x19 },
	'unsharp1intensity' => { 277 => 0x17 },
	'unsharp1threshold' => { 277 => 0x1b },
	'unsharp2color' => { 277 => 0x2e },
	'unsharp2halowidth' => { 277 => 0x34 },
	'unsharp2intensity' => { 277 => 0x32 },
	'unsharp2threshold' => { 277 => 0x36 },
	'unsharp3color' => { 277 => 0x49 },
	'unsharp3halowidth' => { 277 => 0x4f },
	'unsharp3intensity' => { 277 => 0x4d },
	'unsharp3threshold' => { 277 => 0x51 },
	'unsharp4color' => { 277 => 0x64 },
	'unsharp4halowidth' => { 277 => 0x6a },
	'unsharp4intensity' => { 277 => 0x68 },
	'unsharp4threshold' => { 277 => 0x6c },
	'unsharpcount' => { 277 => 0x0 },
	'unsharpmask' => { 109 => 0x90, 272 => 0x76a43200 },
	'unsharpmaskfineness' => { 103 => 0x20309 },
	'unsharpmaskstrength' => { 103 => 0x20308 },
	'unsharpmaskthreshold' => { 103 => 0x2030a },
	'uprightcentermode' => { 477 => 'UprightCenterMode', 479 => 'UprightCenterMode' },
	'uprightcenternormx' => { 477 => 'UprightCenterNormX', 479 => 'UprightCenterNormX' },
	'uprightcenternormy' => { 477 => 'UprightCenterNormY', 479 => 'UprightCenterNormY' },
	'uprightdependentdigest' => { 477 => 'UprightDependentDigest', 479 => 'UprightDependentDigest' },
	'uprightfocallength35mm' => { 477 => 'UprightFocalLength35mm', 479 => 'UprightFocalLength35mm' },
	'uprightfocalmode' => { 477 => 'UprightFocalMode', 479 => 'UprightFocalMode' },
	'uprightfoursegmentscount' => { 477 => 'UprightFourSegmentsCount', 479 => 'UprightFourSegmentsCount' },
	'uprightpreview' => { 477 => 'UprightPreview', 479 => 'UprightPreview' },
	'uprighttransform_0' => { 477 => 'UprightTransform_0', 479 => 'UprightTransform_0' },
	'uprighttransform_1' => { 477 => 'UprightTransform_1', 479 => 'UprightTransform_1' },
	'uprighttransform_2' => { 477 => 'UprightTransform_2', 479 => 'UprightTransform_2' },
	'uprighttransform_3' => { 477 => 'UprightTransform_3', 479 => 'UprightTransform_3' },
	'uprighttransform_4' => { 477 => 'UprightTransform_4', 479 => 'UprightTransform_4' },
	'uprighttransform_5' => { 477 => 'UprightTransform_5', 479 => 'UprightTransform_5' },
	'uprighttransformcount' => { 477 => 'UprightTransformCount', 479 => 'UprightTransformCount' },
	'uprightversion' => { 477 => 'UprightVersion', 479 => 'UprightVersion' },
	'urgency' => { 131 => 0xa, 491 => 'Urgency' },
	'url' => { 157 => 'URL', 310 => 'URL', 369 => 0x40b, 493 => 'url' },
	'url_list' => { 369 => 0x41e },
	'urla-platform' => { 493 => [\'url','urlA-platform'] },
	'urlurl' => { 493 => [\'url','urlUrl'] },
	'usablemeteringmodes' => { 84 => 0x10a },
	'usableshootingmodes' => { 84 => 0x109 },
	'usage' => { 494 => 'usage' },
	'usageterms' => { 507 => 'UsageTerms' },
	'usbpowerdelivery' => { 229 => 0x664 },
	'usedialwithouthold' => { 295 => 0xbf },
	'useguidelines' => { 475 => 'useGuidelines' },
	'usepanoramaviewer' => { 465 => 'UsePanoramaViewer' },
	'usercollection' => { 374 => 'collection.user' },
	'usercomment' => { 97 => 0x805, 119 => 0x9286, 483 => 'UserComment' },
	'userdef1picturestyle' => { 19 => 0x10c, 70 => 0xd8, 71 => 0xf0 },
	'userdef2picturestyle' => { 19 => 0x10e, 70 => 0xda, 71 => 0xf2 },
	'userdef3picturestyle' => { 19 => 0x110, 70 => 0xdc, 71 => 0xf4 },
	'userfields' => { 470 => 'UserFields' },
	'userlabel' => { 381 => 0x2b, 382 => 0x5a, 383 => 0x68 },
	'userprofile' => { 315 => 0x302, 319 => 0x34c, 322 => 0x3038 },
	'userrating' => { 374 => 'rating.user', 380 => 'urat' },
	'usmlenselectronicmf' => { 2 => 0x7, 83 => 0x7, 84 => 0x501 },
	'uspsnumber' => { 493 => 'uspsNumber' },
	'utmeasting' => { 168 => 'Easting' },
	'utmmapdatum' => { 168 => 'Datum' },
	'utmnorthing' => { 168 => 'Northing' },
	'utmzone' => { 168 => 'Zone' },
	'uuid' => { 477 => 'UUID', 479 => 'UUID' },
	'uv-irfiltercorrection' => { 315 => 0x325 },
	'validbits' => { 301 => 0x611, 302 => 0x102c },
	'validpixeldepth' => { 305 => 0x611 },
	'variablelowpassfilter' => { 420 => 0x2028 },
	'variousmodes' => { 140 => 0x26 },
	'variousmodes2' => { 140 => 0x3a },
	'variprogram' => { 226 => 0xab },
	'varraydacnominalvalues' => { 138 => 0x191e },
	'vendor' => { 380 => 'vndr' },
	'vendorinfo' => { 457 => 'VendorInfo' },
	'vendorinfomanufacturer' => { 457 => [\'VendorInfo','VendorInfoManufacturer'] },
	'vendorinfomodel' => { 457 => [\'VendorInfo','VendorInfoModel'] },
	'vendorinfonotes' => { 457 => [\'VendorInfo','VendorInfoNotes'] },
	'version' => { 127 => 0x0, 371 => 'Version', 374 => 'version', 477 => 'Version', 479 => 'Version' },
	'versioncreatedate' => { 454 => 0xd100 },
	'versionid' => { 504 => 'VersionID' },
	'versionidentifier' => { 493 => 'versionIdentifier' },
	'versionmodifydate' => { 454 => 0xd101 },
	'versions' => { 504 => 'Versions' },
	'versionscomments' => { 504 => [\'Versions','VersionsComments'] },
	'versionsevent' => { 504 => [\'Versions','VersionsEvent'] },
	'versionseventaction' => { 504 => [\'Versions','VersionsEventAction'] },
	'versionseventchanged' => { 504 => [\'Versions','VersionsEventChanged'] },
	'versionseventinstanceid' => { 504 => [\'Versions','VersionsEventInstanceID'] },
	'versionseventparameters' => { 504 => [\'Versions','VersionsEventParameters'] },
	'versionseventsoftwareagent' => { 504 => [\'Versions','VersionsEventSoftwareAgent'] },
	'versionseventwhen' => { 504 => [\'Versions','VersionsEventWhen'] },
	'versionsmodifier' => { 504 => [\'Versions','VersionsModifier'] },
	'versionsmodifydate' => { 504 => [\'Versions','VersionsModifyDate'] },
	'versionsversion' => { 504 => [\'Versions','VersionsVersion'] },
	'verticalafonbutton' => { 279 => '3.2', 280 => '47.2', 282 => '79.1', 295 => 0x11d },
	'verticalclockoverlaps' => { 138 => 0x412 },
	'verticalfuncbutton' => { 280 => '42.2', 282 => '67.1', 295 => 0x115 },
	'verticalfuncbuttonplaybackmode' => { 295 => 0x1b7 },
	'verticalfuncbuttonplusdials' => { 280 => '43.1' },
	'verticalfuncplusdials' => { 282 => '68.1' },
	'verticalmovieafonbutton' => { 295 => 0x1f9 },
	'verticalmoviefuncbutton' => { 295 => 0x1e1 },
	'verticalmultiselector' => { 280 => '42.1', 282 => '66.1', 283 => '66.1', 293 => '66.1', 295 => 0x18f },
	'verticalmultiselectorplaybackmode' => { 295 => 0x125 },
	'vfdisplayillumination' => { 2 => 0x11, 84 => [0x510,0x51d] },
	'vibrance' => { 471 => 'Vibrance', 477 => 'Vibrance', 479 => 'Vibrance' },
	'vibrationreduction' => { 238 => [0x75,0x82,0x1ae], 246 => '586.1', 255 => '590.2', 263 => 0x4 },
	'videoalphamode' => { 503 => 'videoAlphaMode' },
	'videoalphapremultiplecolor' => { 503 => 'videoAlphaPremultipleColor' },
	'videoalphapremultiplecolora' => { 503 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorA'] },
	'videoalphapremultiplecolorb' => { 503 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorB'] },
	'videoalphapremultiplecolorblack' => { 503 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorBlack'] },
	'videoalphapremultiplecolorblue' => { 503 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorBlue'] },
	'videoalphapremultiplecolorcyan' => { 503 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorCyan'] },
	'videoalphapremultiplecolorgray' => { 503 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorGray'] },
	'videoalphapremultiplecolorgreen' => { 503 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorGreen'] },
	'videoalphapremultiplecolorl' => { 503 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorL'] },
	'videoalphapremultiplecolormagenta' => { 503 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorMagenta'] },
	'videoalphapremultiplecolormode' => { 503 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorMode'] },
	'videoalphapremultiplecolorred' => { 503 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorRed'] },
	'videoalphapremultiplecolorswatchname' => { 503 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorSwatchName'] },
	'videoalphapremultiplecolortint' => { 503 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorTint'] },
	'videoalphapremultiplecolortype' => { 503 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorType'] },
	'videoalphapremultiplecoloryellow' => { 503 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorYellow'] },
	'videoalphaunityistransparent' => { 503 => 'videoAlphaUnityIsTransparent' },
	'videobitrate' => { 489 => 'videoBitRate' },
	'videobitratemode' => { 489 => 'videoBitRateMode' },
	'videoburstmode' => { 320 => 0xbb },
	'videoburstresolution' => { 320 => 0xb3 },
	'videocodec' => { 67 => 0x74 },
	'videocolorspace' => { 503 => 'videoColorSpace' },
	'videocompression' => { 127 => 0x3806 },
	'videocompressor' => { 503 => 'videoCompressor' },
	'videodisplayaspectratio' => { 489 => 'videoDisplayAspectRatio' },
	'videoencodingprofile' => { 489 => 'videoEncodingProfile' },
	'videofieldorder' => { 503 => 'videoFieldOrder' },
	'videoframerate' => { 320 => 0x27, 503 => 'videoFrameRate' },
	'videoframesize' => { 503 => 'videoFrameSize' },
	'videoframesizeh' => { 503 => [\'videoFrameSize','videoFrameSizeH'] },
	'videoframesizeunit' => { 503 => [\'videoFrameSize','videoFrameSizeUnit'] },
	'videoframesizew' => { 503 => [\'videoFrameSize','videoFrameSizeW'] },
	'videomoddate' => { 503 => 'videoModDate' },
	'videopixelaspectratio' => { 503 => 'videoPixelAspectRatio' },
	'videopixeldepth' => { 503 => 'videoPixelDepth' },
	'videopreburst' => { 320 => 0xc1 },
	'videoquality' => { 113 => 0x4003 },
	'videorecordingmode' => { 127 => 0x3803 },
	'videoshottype' => { 489 => 'VideoShotType' },
	'videoshottypeidentifier' => { 489 => [\'VideoShotType','VideoShotTypeIdentifier'] },
	'videoshottypename' => { 489 => [\'VideoShotType','VideoShotTypeName'] },
	'videostreamscount' => { 489 => 'videoStreamsCount' },
	'viewfinder' => { 364 => 0x455 },
	'viewfinderdisplay' => { 279 => '12.4', 280 => '6.3' },
	'viewfinderwarning' => { 279 => '13.4', 289 => '3.5', 290 => '6.2', 294 => '4.4' },
	'viewfinderwarnings' => { 84 => 0x40a },
	'viewinfoduringexposure' => { 84 => 0x407 },
	'viewingmode' => { 409 => 0x2f, 425 => 0x18 },
	'viewingmode2' => { 409 => [0x85,0x285] },
	'viewpoint' => { 492 => 'viewpoint' },
	'vignetteamount' => { 477 => 'VignetteAmount', 479 => 'VignetteAmount' },
	'vignettecontrol' => { 226 => 0x2a, 272 => 0x76a43205 },
	'vignettecontrolintensity' => { 272 => 0xac6bd5c0 },
	'vignettecorrectionalreadyapplied' => { 474 => 'VignetteCorrectionAlreadyApplied' },
	'vignettemidpoint' => { 477 => 'VignetteMidpoint', 479 => 'VignetteMidpoint' },
	'vignetting' => { 387 => 0x1011, 394 => 0xa052 },
	'vignettingcorrection' => { 119 => 0x7031, 394 => 0xa053, 420 => 0x2011 },
	'vignettingcorrparams' => { 119 => 0x7032, 449 => 0x64a, 450 => [0x34a,0x350,0x35c,0x368] },
	'vignettingsetting' => { 394 => 0xa054 },
	'virtualhorizonstyle' => { 295 => 0x167 },
	'visualcolor' => { 489 => 'VisualColour' },
	'visualtechnique' => { 492 => 'visualTechnique' },
	'voicememo' => { 396 => 0x216 },
	'volume' => { 493 => 'volume' },
	'vr_0x66' => { 238 => 0x66 },
	'vrdoffset' => { 64 => 0xd0 },
	'vrmode' => { 229 => 0x212, 263 => 0x6 },
	'waterdepth' => { 119 => 0x9403, 484 => 'WaterDepth' },
	'wb_bluelevel3500k' => { 187 => 0x19a },
	'wb_bluelevel6500k' => { 187 => 0x18a },
	'wb_bluelevelcustom' => { 187 => 0x18e },
	'wb_bluelevelscloudy' => { 187 => 0x106 },
	'wb_bluelevelsdaylight' => { 187 => 0xea },
	'wb_bluelevelsflash' => { 187 => 0x122 },
	'wb_bluelevelsfluorescent' => { 187 => [0x40a,0x15a] },
	'wb_bluelevelskelvin' => { 187 => 0x254 },
	'wb_bluelevelsshade' => { 187 => 0x176 },
	'wb_bluelevelstungsten' => { 187 => 0xce },
	'wb_gbrglevels' => { 187 => 0xae, 190 => 0x4 },
	'wb_glevel' => { 301 => 0x11f },
	'wb_glevel3000k' => { 301 => 0x113 },
	'wb_glevel3300k' => { 301 => 0x114 },
	'wb_glevel3600k' => { 301 => 0x115 },
	'wb_glevel3900k' => { 301 => 0x116 },
	'wb_glevel4000k' => { 301 => 0x117 },
	'wb_glevel4300k' => { 301 => 0x118 },
	'wb_glevel4500k' => { 301 => 0x119 },
	'wb_glevel4800k' => { 301 => 0x11a },
	'wb_glevel5300k' => { 301 => 0x11b },
	'wb_glevel6000k' => { 301 => 0x11c },
	'wb_glevel6600k' => { 301 => 0x11d },
	'wb_glevel7500k' => { 301 => 0x11e },
	'wb_grbglevels' => { 201 => 0x0 },
	'wb_grgblevelsauto' => { 81 => 0x2 },
	'wb_grgblevelscloudy' => { 81 => 0x12 },
	'wb_grgblevelscustom1' => { 81 => 0x42 },
	'wb_grgblevelscustom2' => { 81 => 0x4a },
	'wb_grgblevelsdaylight' => { 81 => 0xa },
	'wb_grgblevelsflash' => { 81 => 0x32 },
	'wb_grgblevelsfluorescent' => { 81 => 0x22 },
	'wb_grgblevelsfluorhigh' => { 81 => 0x2a },
	'wb_grgblevelstungsten' => { 81 => 0x1a },
	'wb_grgblevelsunderwater' => { 81 => 0x3a },
	'wb_rbgglevels' => { 198 => 0x0 },
	'wb_rblevels' => { 202 => 0x270, 226 => 0xc, 301 => 0x100 },
	'wb_rblevels1' => { 326 => 0x2 },
	'wb_rblevels2' => { 326 => 0x5 },
	'wb_rblevels3' => { 326 => 0x8 },
	'wb_rblevels3000k' => { 301 => 0x102 },
	'wb_rblevels3300k' => { 301 => 0x103 },
	'wb_rblevels3500k' => { 187 => 0x430 },
	'wb_rblevels3600k' => { 301 => 0x104 },
	'wb_rblevels3900k' => { 301 => 0x105 },
	'wb_rblevels4' => { 326 => 0xb },
	'wb_rblevels4000k' => { 301 => 0x106 },
	'wb_rblevels4300k' => { 301 => 0x107 },
	'wb_rblevels4500k' => { 301 => 0x108 },
	'wb_rblevels4800k' => { 301 => 0x109 },
	'wb_rblevels5' => { 326 => 0xe },
	'wb_rblevels5300k' => { 301 => 0x10a },
	'wb_rblevels6' => { 326 => 0x11 },
	'wb_rblevels6000k' => { 301 => 0x10b },
	'wb_rblevels6500k' => { 187 => 0x420 },
	'wb_rblevels6600k' => { 301 => 0x10c },
	'wb_rblevels7' => { 326 => 0x14 },
	'wb_rblevels7500k' => { 301 => 0x10d },
	'wb_rblevelsauto' => { 202 => 0x272, 305 => 0x110 },
	'wb_rblevelscloudy' => { 187 => 0x3f0, 189 => 0x10, 202 => 0x296, 305 => 0x121 },
	'wb_rblevelscoolwhitef' => { 187 => 0x308, 189 => 0x14 },
	'wb_rblevelscoolwhitefluor' => { 305 => 0x132 },
	'wb_rblevelscustom' => { 187 => 0x424, 189 => 0x1c },
	'wb_rblevelscwb1' => { 301 => 0x10e },
	'wb_rblevelscwb2' => { 301 => 0x10f },
	'wb_rblevelscwb3' => { 301 => 0x110 },
	'wb_rblevelscwb4' => { 301 => 0x111 },
	'wb_rblevelsdaylight' => { 187 => [0x3ec,0x528], 189 => 0xc, 202 => 0x274 },
	'wb_rblevelsdaylightf' => { 189 => 0x24 },
	'wb_rblevelsdaylightfluor' => { 305 => 0x130 },
	'wb_rblevelsdaywhitef' => { 189 => 0x28 },
	'wb_rblevelsdaywhitefluor' => { 305 => 0x131 },
	'wb_rblevelseveningsunlight' => { 305 => 0x124 },
	'wb_rblevelsfineweather' => { 305 => 0x122 },
	'wb_rblevelsflash' => { 187 => [0x3f4,0x304], 189 => 0x18, 202 => 0x2a4 },
	'wb_rblevelsfluorescent' => { 202 => 0x290 },
	'wb_rblevelsincandescent' => { 202 => 0x282 },
	'wb_rblevelsshade' => { 187 => 0x418, 189 => 0x20, 202 => 0x2b2, 305 => 0x120 },
	'wb_rblevelstungsten' => { 187 => 0x3e8, 189 => 0x8, 305 => 0x123 },
	'wb_rblevelsused' => { 305 => 0x100 },
	'wb_rblevelswhitef' => { 189 => 0x2c },
	'wb_rblevelswhitefluorescent' => { 305 => 0x133 },
	'wb_redlevel3500k' => { 187 => 0x198 },
	'wb_redlevel6500k' => { 187 => 0x188 },
	'wb_redlevelcustom' => { 187 => 0x18c },
	'wb_redlevelscloudy' => { 187 => 0xf8 },
	'wb_redlevelsdaylight' => { 187 => 0xdc },
	'wb_redlevelsflash' => { 187 => 0x114 },
	'wb_redlevelsfluorescent' => { 187 => [0x3fc,0x14c] },
	'wb_redlevelskelvin' => { 187 => 0x1be },
	'wb_redlevelsshade' => { 187 => 0x168 },
	'wb_redlevelstungsten' => { 187 => 0xc0 },
	'wb_rgbglevels' => { 200 => 0x0 },
	'wb_rgblevels' => { 187 => [0x546,0x96], 316 => 0xd, 317 => 0x413, 322 => 0x3036, 364 => 0x107, 428 => 0x117c, 429 => 0x1180, 430 => 0x115c, 431 => 0x11d8, 432 => 0x11b4, 433 => 0x106c, 434 => 0x264, 435 => 0x264, 436 => 0x252 },
	'wb_rgblevels1' => { 327 => 0x2 },
	'wb_rgblevels2' => { 327 => 0x6 },
	'wb_rgblevels3' => { 327 => 0xa },
	'wb_rgblevels4' => { 327 => 0xe },
	'wb_rgblevels5' => { 327 => 0x12 },
	'wb_rgblevels6' => { 327 => 0x16 },
	'wb_rgblevels7' => { 327 => 0x1a },
	'wb_rgblevelsauto' => { 398 => 0x0 },
	'wb_rgblevelscustom1' => { 398 => 0x15 },
	'wb_rgblevelscustom2' => { 398 => 0x18 },
	'wb_rgblevelscustom3' => { 398 => 0x1b },
	'wb_rgblevelsdaylight' => { 398 => 0x3 },
	'wb_rgblevelsflash' => { 398 => 0x12 },
	'wb_rgblevelsfluorescent' => { 398 => 0xf },
	'wb_rgblevelsincandescent' => { 398 => 0xc },
	'wb_rgblevelsovercast' => { 398 => 0x9 },
	'wb_rgblevelsshade' => { 398 => 0x6 },
	'wb_rgblevelsunknown0' => { 399 => 0x0 },
	'wb_rgblevelsunknown1' => { 399 => 0x3 },
	'wb_rgblevelsunknown2' => { 399 => 0x6 },
	'wb_rgblevelsunknown3' => { 399 => 0x9 },
	'wb_rgblevelsunknown4' => { 399 => 0xc },
	'wb_rgblevelsunknown5' => { 399 => 0xf },
	'wb_rgblevelsunknown6' => { 399 => 0x12 },
	'wb_rgblevelsunknown7' => { 399 => 0x15 },
	'wb_rgblevelsunknown8' => { 399 => 0x18 },
	'wb_rgblevelsunknown9' => { 399 => 0x1b },
	'wb_rgbmuldaylight' => { 138 => 0x852 },
	'wb_rgbmulflash' => { 138 => 0x855 },
	'wb_rgbmulfluorescent' => { 138 => 0x854 },
	'wb_rgbmultungsten' => { 138 => 0x853 },
	'wb_rggbblacklevels' => { 35 => 0x25 },
	'wb_rggblevels' => { 190 => 0x4, 199 => 0x0, 203 => 0x13e8, 204 => 0x38 },
	'wb_rggblevelsasshot' => { 38 => 0x0, 39 => 0x0, 40 => 0x19, 41 => 0x55, 42 => 0x69, 43 => 0x22, 44 => 0x3f, 47 => 0x3f, 48 => 0x3f, 49 => 0x3f, 50 => 0x47 },
	'wb_rggblevelsauto' => { 35 => 0x1, 38 => 0x5, 39 => 0x8, 40 => 0x1e, 41 => 0x5a, 42 => 0x6e, 43 => 0x18, 44 => 0x44, 47 => 0x44, 48 => 0x44, 49 => 0x44, 50 => 0x4c, 203 => 0x1478, 204 => 0x114, 394 => 0xa022 },
	'wb_rggblevelsblack' => { 394 => 0xa028 },
	'wb_rggblevelscloudy' => { 35 => 0xd, 38 => 0x1e, 39 => 0x30, 40 => 0x2d, 41 => 0xa0, 42 => 0xd7, 43 => 0x31, 44 => 0x58, 47 => 0x71, 48 => 0x8a, 49 => 0x8f, 50 => 0x92, 203 => 0x1408, 204 => 0x60, 355 => 0x20f, 363 => 0x14 },
	'wb_rggblevelscustom' => { 35 => 0x1d, 44 => 0x80, 203 => 0x1468, 204 => 0x100 },
	'wb_rggblevelscustom1' => { 40 => 0x41 },
	'wb_rggblevelscustom2' => { 40 => 0x46 },
	'wb_rggblevelsdaylight' => { 35 => 0x5, 38 => 0x14, 39 => 0x20, 40 => 0x23, 41 => 0x96, 42 => 0xcd, 43 => 0x27, 44 => 0x4e, 47 => 0x67, 48 => 0x80, 49 => 0x85, 50 => 0x88, 203 => 0x13f8, 204 => 0x4c, 355 => 0x20d, 363 => 0x2 },
	'wb_rggblevelsflash' => { 35 => 0x19, 38 => 0x32, 39 => 0x50, 40 => 0x3c, 41 => 0xb4, 42 => 0xeb, 43 => 0x45, 44 => 0x6c, 47 => 0x85, 48 => 0x9e, 49 => 0xa3, 50 => 0xa6, 203 => 0x1448, 355 => 0x214, 363 => 0x41 },
	'wb_rggblevelsfluorescent' => { 35 => 0x15, 38 => 0x28, 39 => 0x40, 40 => 0x37, 41 => 0xaa, 42 => 0xe1, 43 => 0x3b, 44 => 0x62, 47 => 0x7b, 48 => 0x94, 49 => 0x99, 50 => 0x9c },
	'wb_rggblevelsfluorescentd' => { 204 => 0xc4, 355 => 0x211, 363 => 0x26 },
	'wb_rggblevelsfluorescentl' => { 363 => 0x4a },
	'wb_rggblevelsfluorescentn' => { 204 => 0xb0, 355 => 0x212, 363 => 0x2f },
	'wb_rggblevelsfluorescentw' => { 203 => 0x1438, 204 => 0x9c, 355 => 0x213, 363 => 0x38 },
	'wb_rggblevelshtmercury' => { 204 => 0xd8 },
	'wb_rggblevelsilluminator1' => { 394 => 0xa023 },
	'wb_rggblevelsilluminator2' => { 394 => 0xa024 },
	'wb_rggblevelskelvin' => { 35 => 0x21, 38 => 0x2d, 39 => 0x48, 41 => 0xaf, 42 => 0xe6, 43 => 0x40, 44 => 0x67, 47 => 0x80, 48 => 0x99, 49 => 0x9e, 50 => 0xa1 },
	'wb_rggblevelsmeasured' => { 38 => 0xa, 39 => 0x10, 41 => 0x5f, 42 => 0x73, 44 => 0x49, 47 => 0x49, 48 => 0x49, 49 => 0x49, 50 => 0x51 },
	'wb_rggblevelspc1' => { 43 => 0x90, 44 => 0x71 },
	'wb_rggblevelspc2' => { 43 => 0x95, 44 => 0x76 },
	'wb_rggblevelspc3' => { 43 => 0x9a, 44 => 0x7b },
	'wb_rggblevelsshade' => { 35 => 0x9, 38 => 0x19, 39 => 0x28, 40 => 0x28, 41 => 0x9b, 42 => 0xd2, 43 => 0x2c, 44 => 0x53, 47 => 0x6c, 48 => 0x85, 49 => 0x8a, 50 => 0x8d, 204 => 0x74, 355 => 0x20e, 363 => 0xb },
	'wb_rggblevelstungsten' => { 35 => 0x11, 38 => 0x23, 39 => 0x38, 40 => 0x32, 41 => 0xa5, 42 => 0xdc, 43 => 0x36, 44 => 0x5d, 47 => 0x76, 48 => 0x8f, 49 => 0x94, 50 => 0x97, 203 => 0x1428, 204 => 0x88, 355 => 0x210, 363 => 0x1d },
	'wb_rggblevelsuncorrected' => { 394 => 0xa021 },
	'wb_rggblevelsunknown' => { 38 => 0xf, 39 => 0x18, 41 => 0x64, 42 => 0x78, 43 => 0x1d, 47 => 0x4e, 48 => 0x4e, 49 => 0x4e, 50 => 0x56, 363 => 0x53 },
	'wb_rggblevelsunknown10' => { 38 => 0x5f, 39 => 0x98, 41 => 0x91, 42 => 0xa5, 43 => 0x72, 47 => 0x9e, 48 => 0x7b, 49 => 0x7b, 50 => 0x83 },
	'wb_rggblevelsunknown11' => { 38 => 0x64, 39 => 0xa0, 41 => 0xb9, 42 => [0xaa,0xaf], 43 => 0x77, 47 => 0xa3, 48 => 0xa3, 49 => 0x80, 50 => 0xab },
	'wb_rggblevelsunknown12' => { 38 => 0x69, 39 => 0xa8, 41 => 0xbe, 42 => 0xb4, 43 => 0x7c, 47 => 0xa8, 48 => 0xa8, 49 => 0xa8, 50 => 0xb0 },
	'wb_rggblevelsunknown13' => { 38 => 0x6e, 39 => 0xb0, 41 => 0xc3, 42 => 0xb9, 43 => 0x81, 47 => 0xad, 48 => 0xad, 49 => 0xad, 50 => 0xb5 },
	'wb_rggblevelsunknown14' => { 41 => 0xc8, 42 => 0xbe, 43 => 0x86, 47 => 0xb2, 48 => 0xb2, 49 => 0xb2, 50 => 0xba },
	'wb_rggblevelsunknown15' => { 41 => 0xcd, 42 => 0xc3, 43 => 0x8b, 47 => 0xb7, 48 => 0xb7, 49 => 0xb7, 50 => 0xbf },
	'wb_rggblevelsunknown16' => { 41 => 0xd2, 42 => 0xc8, 43 => 0x9f, 48 => 0xbc, 49 => 0xbc, 50 => 0xc4 },
	'wb_rggblevelsunknown17' => { 41 => 0xd7, 42 => 0xf0, 48 => 0xc1, 49 => 0xc1, 50 => 0xc9 },
	'wb_rggblevelsunknown18' => { 41 => 0xdc, 42 => 0xf5, 48 => 0xc6, 49 => 0xc6, 50 => 0xce },
	'wb_rggblevelsunknown19' => { 41 => 0xe1, 42 => 0xfa, 48 => 0xcb, 49 => 0xcb, 50 => 0xd3 },
	'wb_rggblevelsunknown2' => { 38 => 0x37, 39 => 0x58, 41 => 0x69, 42 => 0x7d, 43 => 0x4a, 47 => 0x53, 48 => 0x53, 49 => 0x53, 50 => 0x5b },
	'wb_rggblevelsunknown20' => { 41 => 0xe6, 42 => 0xff, 48 => 0xd0, 49 => 0xd0, 50 => 0xd8 },
	'wb_rggblevelsunknown21' => { 41 => 0xeb, 42 => 0x104, 49 => 0xd5, 50 => 0xdd },
	'wb_rggblevelsunknown22' => { 41 => 0xf0, 42 => 0x109, 49 => 0xda, 50 => 0xe2 },
	'wb_rggblevelsunknown23' => { 41 => 0xf5, 42 => 0x10e, 49 => 0xdf, 50 => 0xe7 },
	'wb_rggblevelsunknown24' => { 41 => 0xfa, 42 => 0x113, 49 => 0xe4, 50 => 0xec },
	'wb_rggblevelsunknown25' => { 41 => 0xff, 42 => 0x118, 49 => 0xe9, 50 => 0xf1 },
	'wb_rggblevelsunknown26' => { 41 => 0x104, 42 => 0x11d, 49 => 0xee, 50 => 0xf6 },
	'wb_rggblevelsunknown27' => { 41 => 0x109, 42 => 0x122, 49 => 0xf3, 50 => 0xfb },
	'wb_rggblevelsunknown28' => { 41 => 0x10e, 49 => 0xf8, 50 => 0x100 },
	'wb_rggblevelsunknown29' => { 41 => 0x113, 49 => 0xfd, 50 => 0x105 },
	'wb_rggblevelsunknown3' => { 38 => 0x3c, 39 => 0x60, 41 => 0x6e, 42 => 0x82, 43 => 0x4f, 47 => 0x58, 48 => 0x58, 49 => 0x58, 50 => 0x60 },
	'wb_rggblevelsunknown30' => { 49 => 0x102 },
	'wb_rggblevelsunknown4' => { 38 => 0x41, 39 => 0x68, 41 => 0x73, 42 => 0x87, 43 => 0x54, 47 => 0x5d, 48 => 0x5d, 49 => 0x5d, 50 => 0x65 },
	'wb_rggblevelsunknown5' => { 38 => 0x46, 39 => 0x70, 41 => 0x78, 42 => 0x8c, 43 => 0x59, 47 => 0x62, 48 => 0x62, 49 => 0x62, 50 => 0x6a },
	'wb_rggblevelsunknown6' => { 38 => 0x4b, 39 => 0x78, 41 => 0x7d, 42 => 0x91, 43 => 0x5e, 47 => 0x8a, 48 => 0x67, 49 => 0x67, 50 => 0x6f },
	'wb_rggblevelsunknown7' => { 38 => 0x50, 39 => 0x80, 41 => 0x82, 42 => 0x96, 43 => 0x63, 47 => 0x8f, 48 => 0x6c, 49 => 0x6c, 50 => 0x74 },
	'wb_rggblevelsunknown8' => { 38 => 0x55, 39 => 0x88, 41 => 0x87, 42 => 0x9b, 43 => 0x68, 47 => 0x94, 48 => 0x71, 49 => 0x71, 50 => 0x79 },
	'wb_rggblevelsunknown9' => { 38 => 0x5a, 39 => 0x90, 41 => 0x8c, 42 => 0xa0, 43 => 0x6d, 47 => 0x99, 48 => 0x76, 49 => 0x76, 50 => 0x7e },
	'wb_rggblevelsuserselected' => { 363 => 0x5c },
	'wbadjblueamber' => { 103 => 0x20106 },
	'wbadjbluebalance' => { 278 => 0x8 },
	'wbadjcolortemp' => { 103 => 0x20102, 108 => 0x1a },
	'wbadjlighting' => { 278 => 0x14 },
	'wbadjmagentagreen' => { 103 => 0x20105 },
	'wbadjmode' => { 278 => 0x10 },
	'wbadjredbalance' => { 278 => 0x0 },
	'wbadjrggblevels' => { 103 => 0x20125, 108 => 0x6 },
	'wbadjtemperature' => { 278 => 0x18 },
	'wbadjtint' => { 278 => 0x25 },
	'wbbluelevel' => { 315 => 0x324, 320 => 0x8006, 325 => 0x26 },
	'wbbracketingsteps' => { 247 => 0x174d, 248 => 0x87c, 257 => 0x1757 },
	'wbbracketmode' => { 57 => 0x9 },
	'wbbracketshotnumber' => { 187 => 0x2b, 387 => 0x101a },
	'wbbracketvalueab' => { 57 => 0xc },
	'wbbracketvaluegm' => { 57 => 0xd },
	'wbfinetuneactive' => { 108 => 0x24 },
	'wbfinetunesaturation' => { 108 => 0x28 },
	'wbfinetunetone' => { 108 => 0x2c },
	'wbgreenlevel' => { 315 => 0x323, 320 => 0x8005, 325 => 0x25 },
	'wbmediaimagesizesetting' => { 84 => 0x708 },
	'wbmode' => { 189 => 0x4, 302 => 0x1015 },
	'wbredlevel' => { 315 => 0x322, 320 => 0x8004, 325 => 0x24 },
	'wbscale' => { 190 => 0x0 },
	'wbshiftab' => { 74 => 0xc, 320 => 0x46, 337 => 0x10 },
	'wbshiftab_gm' => { 420 => 0x2014 },
	'wbshiftab_gm_precise' => { 420 => 0x2026 },
	'wbshiftcreativecontrol' => { 320 => 0x92 },
	'wbshiftgm' => { 74 => 0xd, 320 => 0x47, 337 => 0x11 },
	'wbshiftintelligentauto' => { 320 => 0x8b },
	'wbtype1' => { 326 => 0x1, 327 => 0x1 },
	'wbtype2' => { 326 => 0x4, 327 => 0x5 },
	'wbtype3' => { 326 => 0x7, 327 => 0x9 },
	'wbtype4' => { 326 => 0xa, 327 => 0xd },
	'wbtype5' => { 326 => 0xd, 327 => 0x11 },
	'wbtype6' => { 326 => 0x10, 327 => 0x15 },
	'wbtype7' => { 326 => 0x13, 327 => 0x19 },
	'webstatement' => { 507 => 'WebStatement' },
	'weightedflatsubject' => { 469 => 'weightedFlatSubject' },
	'what' => { 477 => 'What', 479 => 'What' },
	'whitebalance' => { 7 => 0x6f, 8 => [0x44,0x4a], 9 => 0xbc, 10 => 0x36, 11 => 0x5e, 12 => 0x36, 13 => 0x78, 14 => 0x6f, 15 => 0x6f, 16 => 0x73, 17 => 0x6f, 18 => 0x78, 19 => 0x54, 20 => 0x6f, 21 => 0xbc, 22 => 0x7b, 24 => 0xbc, 25 => 0xc2, 27 => 0x131, 28 => 0x77, 74 => 0x8, 77 => 0x7, 112 => 0x7, 113 => [0x19,0x2012], 119 => [0xa403,0xfe4e], 127 => 0x1002, 138 => 0x3fc, 139 => 0xfa0d, 140 => 0x40, 151 => 0x1a, 181 => 0x3, 182 => 0xe, 183 => 0x4, 184 => 0xb, 186 => 0x115, 226 => 0x5, 262 => 0x7, 315 => 0x304, 320 => 0x3, 322 => 0x3033, 355 => 0x19, 362 => 0x7, 386 => 0x26, 387 => 0x1003, 397 => [0x88,0x3c,0x7,0x58], 407 => 0xf, 408 => 0xe, 420 => [0x115,0xb054], 477 => 'WhiteBalance', 479 => 'WhiteBalance', 483 => 'WhiteBalance' },
	'whitebalance0' => { 176 => 'WhiteBalance0' },
	'whitebalance1' => { 176 => 'WhiteBalance1' },
	'whitebalance2' => { 176 => 'WhiteBalance2', 297 => 0x500 },
	'whitebalanceadj' => { 103 => 0x20101, 108 => 0x18, 272 => 0x76a43204 },
	'whitebalanceautoadjustment' => { 333 => 0x0 },
	'whitebalancebias' => { 113 => 0x2011, 302 => 0x304, 320 => 0x23 },
	'whitebalanceblue' => { 74 => 0x7 },
	'whitebalancebracket' => { 297 => 0x502, 302 => 0x303 },
	'whitebalancebracketing' => { 184 => 0x22, 187 => 0x2c, 418 => 0x2c },
	'whitebalancebuttonplaybackmode' => { 295 => 0x1c5 },
	'whitebalancecomp' => { 305 => 0x1001 },
	'whitebalancedetected' => { 138 => 0x3fb },
	'whitebalancefinetune' => { 127 => 0x100a, 184 => 0x38, 186 => 0x112, 226 => 0xb, 387 => 0x1004, 407 => 0x6, 408 => 0x5, 420 => 0x112 },
	'whitebalancemode' => { 138 => 0x3fa, 355 => 0x1a },
	'whitebalancered' => { 74 => 0x6 },
	'whitebalanceset' => { 336 => 0xa },
	'whitebalancesetting' => { 184 => 0x23, 407 => 0x5, 408 => 0x4, 409 => 0x16, 425 => 0xd },
	'whitebalancesetup' => { 394 => 0x41 },
	'whitebalancetemperature' => { 297 => 0x501 },
	'whiteboard' => { 302 => 0x301 },
	'whitelevel' => { 119 => 0xc61d, 355 => 0x7e },
	'whitepoint' => { 119 => 0x13e, 319 => 0x35d, 355 => 0x201, 499 => 'WhitePoint' },
	'whites2012' => { 477 => 'Whites2012', 479 => 'Whites2012' },
	'whitesadj' => { 454 => 0x9017 },
	'wideadapter' => { 387 => 0x1017 },
	'widefocuszone' => { 181 => 0x2f },
	'widerange' => { 396 => 0x20f },
	'windmode' => { 138 => 0x3f4 },
	'windnoisereduction' => { 229 => 0x2d6 },
	'windowlocation' => { 380 => 'WLOC' },
	'windowsatom' => { 478 => 'windowsAtom' },
	'windowsatomextension' => { 478 => [\'windowsAtom','windowsAtomExtension'] },
	'windowsatominvocationflags' => { 478 => [\'windowsAtom','windowsAtomInvocationFlags'] },
	'windowsatomuncprojectpath' => { 478 => [\'windowsAtom','windowsAtomUncProjectPath'] },
	'wordcount' => { 493 => 'wordCount' },
	'work' => { 372 => "\xa9wrk" },
	'workcolorspace' => { 103 => 0x10200, 108 => 0x270 },
	'workflowtag' => { 489 => 'WorkflowTag' },
	'workflowtagcvid' => { 489 => [\'WorkflowTag','WorkflowTagCvId'] },
	'workflowtagcvtermid' => { 489 => [\'WorkflowTag','WorkflowTagCvTermId'] },
	'workflowtagcvtermname' => { 489 => [\'WorkflowTag','WorkflowTagCvTermName'] },
	'workflowtagcvtermrefinedabout' => { 489 => [\'WorkflowTag','WorkflowTagCvTermRefinedAbout'] },
	'worktodo' => { 485 => 'WorkToDo' },
	'worldtimelocation' => { 320 => 0x3a, 355 => 0x22, 361 => '0.1' },
	'writer' => { 179 => 'WM/Writer' },
	'writer-editor' => { 131 => 0x7a },
	'x3filllight' => { 397 => 0x12 },
	'xattrquarantine' => { 174 => 'com.apple.quarantine' },
	'xilinxversion' => { 138 => 0x414 },
	'xml' => { 136 => 'xml ' },
	'xmp' => { 106 => 0xffff00f6, 120 => 'XMP' },
	'xmptoolkit' => { 500 => 'xmptk' },
	'xpauthor' => { 119 => 0x9c9d },
	'xpcomment' => { 119 => 0x9c9c },
	'xpkeywords' => { 119 => 0x9c9e },
	'xposition' => { 119 => 0x11e },
	'xpsubject' => { 119 => 0x9c9f },
	'xptitle' => { 119 => 0x9c9b },
	'xresolution' => { 119 => 0x11a, 134 => 0x3, 370 => 0x0, 499 => 'XResolution' },
	'xyresolution' => { 123 => 0x3 },
	'yaw' => { 115 => 0x7, 380 => ['_yaw',"\xa9fyw"] },
	'yawangle' => { 247 => 0x3513, 248 => 0x2c2c, 252 => 0xc222, 257 => 0x36fc, 258 => 0x2f03, 260 => 0xce3a, 261 => 0xeaf3, 392 => 0x0 },
	'ycbcrcoefficients' => { 119 => 0x211, 499 => 'YCbCrCoefficients' },
	'ycbcrpositioning' => { 119 => 0x213, 499 => 'YCbCrPositioning' },
	'ycbcrsubsampling' => { 119 => 0x212, 499 => 'YCbCrSubSampling' },
	'year' => { 372 => 'yrrc', 374 => 'year', 380 => 'yrrc' },
	'yearcreated' => { 140 => 0x10, 149 => 0xc },
	'yellowhsl' => { 103 => 0x20912 },
	'yield' => { 495 => 'yield' },
	'yposition' => { 119 => 0x11f },
	'yresolution' => { 119 => 0x11b, 134 => 0x5, 370 => 0x4, 499 => 'YResolution' },
	'zebrapatterntonerange' => { 295 => 0x211 },
	'zoneidentifier' => { 120 => 'ZoneIdentifier' },
	'zonematching' => { 186 => 0x10a, 189 => [0x3a,0x4a], 420 => 0xb024 },
	'zonematchingmode' => { 184 => 0x14 },
	'zonematchingon' => { 183 => 0x75 },
	'zonematchingvalue' => { 407 => 0x1f },
	'zoomedpreviewlength' => { 302 => 0xf05 },
	'zoomedpreviewsize' => { 302 => 0xf06 },
	'zoomedpreviewstart' => { 302 => 0xf04 },
	'zoomsourcewidth' => { 34 => 0x24 },
	'zoomstepcount' => { 300 => 0x300, 302 => 0x100d },
	'zoomtargetwidth' => { 34 => 0x25 },
);

# lookup for non-writable tags to check if the name exists
my %tagExists = (
	'_ac3' => 1,
	'_h264' => 1,
	'_stream' => 1,
	'a100dataoffset' => 1,
	'aas' => 1,
	'abovecolor' => 1,
	'abstract' => 1,
	'abstractfilename' => 1,
	'accel360fly' => 1,
	'acceldata' => 1,
	'accelerometermatrix' => 1,
	'accelerometertime' => 1,
	'accelmode' => 1,
	'accelypr' => 1,
	'accessdate' => 1,
	'accountname' => 1,
	'acdsee' => 1,
	'acquisitiontime' => 1,
	'acquisitiontimeday' => 1,
	'acquisitiontimemonth' => 1,
	'acquisitiontimeyear' => 1,
	'acquisitiontimeyearmonth' => 1,
	'acquisitiontimeyearmonthday' => 1,
	'acroform' => 1,
	'activebuf1cols' => 1,
	'activebuf1rows' => 1,
	'activebuf2cols' => 1,
	'activebuf2rows' => 1,
	'activecols' => 1,
	'activectemonitor1cols' => 1,
	'activectemonitor2cols' => 1,
	'activectemonitorrows' => 1,
	'activerows' => 1,
	'actor' => 1,
	'actualcompensation' => 1,
	'actualscalemax' => 1,
	'actualscalemin' => 1,
	'actualsoftpostpadding' => 1,
	'actualsoftprepadding' => 1,
	'additionalinfo' => 1,
	'adjustedtbnimageheight' => 1,
	'adjustedtbnimagewidth' => 1,
	'adobe_cm' => 1,
	'adobecmtype' => 1,
	'adobecrw' => 1,
	'adobekoda' => 1,
	'adobeleaf' => 1,
	'adobemrw' => 1,
	'adobepano' => 1,
	'adobephotoshop' => 1,
	'adoberaf' => 1,
	'adobesr2' => 1,
	'adoptedneutral' => 1,
	'adult' => 1,
	'advancedcontentencryption' => 1,
	'advancedmutualexcl' => 1,
	'advancedscenemode' => 1,
	'adventrevision' => 1,
	'adventscale' => 1,
	'aeflags' => 1,
	'aeinfo' => 1,
	'aeinfo2' => 1,
	'aeinfo3' => 1,
	'aeinfounknown' => 1,
	'af-cprioritysel' => 1,
	'af-sprioritysel' => 1,
	'afarea' => 1,
	'afareaheights' => 1,
	'afareawidths' => 1,
	'afareaxpositions' => 1,
	'afareaypositions' => 1,
	'afconfig' => 1,
	'afcp' => 1,
	'afcp_iptc' => 1,
	'afcsettings' => 1,
	'aff1' => 1,
	'aff5' => 1,
	'affheader' => 1,
	'affinetransformmat' => 1,
	'afinfo' => 1,
	'afinfo2' => 1,
	'afinfo2version' => 1,
	'afinfo3' => 1,
	'afinfocus' => 1,
	'afinfosize' => 1,
	'afm' => 1,
	'afpointinfo' => 1,
	'afpointsinfocus1d' => 1,
	'afsp' => 1,
	'afstatus15' => 1,
	'afstatus19' => 1,
	'afstatus79' => 1,
	'aftune' => 1,
	'aibuildnumber' => 1,
	'aicolormodel' => 1,
	'aicolorusage' => 1,
	'aicreatorversion' => 1,
	'aifileformat' => 1,
	'aimetadata' => 1,
	'ainumlayers' => 1,
	'aipdfprivatedata' => 1,
	'aiprivatedata' => 1,
	'airspeed' => 1,
	'airulerunits' => 1,
	'aitargetresolution' => 1,
	'album2' => 1,
	'albumartistsortorder' => 1,
	'albumid' => 1,
	'albumidalbumartist' => 1,
	'albumname' => 1,
	'albumsortorder' => 1,
	'albumtitlesortorder' => 1,
	'aliaslayermetadata' => 1,
	'alignment' => 1,
	'allcolorflatfield1' => 1,
	'allcolorflatfield2' => 1,
	'allcolorflatfield3' => 1,
	'alph' => 1,
	'alpha' => 1,
	'alphabitdepth' => 1,
	'alphabytecount' => 1,
	'alphachannelsnames' => 1,
	'alphacompression' => 1,
	'alphadatadiscard' => 1,
	'alphafilter' => 1,
	'alphafiltering' => 1,
	'alphaidentifiers' => 1,
	'alphainterlace' => 1,
	'alphamask' => 1,
	'alphaoffset' => 1,
	'alphapreprocessing' => 1,
	'alphasample' => 1,
	'alternateduotonecolors' => 1,
	'alternatesourceurl' => 1,
	'alternatespotcolors' => 1,
	'altitudefromtakeoff' => 1,
	'ambienceinfo' => 1,
	'angleaxis' => 1,
	'angularvelocity' => 1,
	'anim' => 1,
	'animation' => 1,
	'animationcontrol' => 1,
	'animationframes' => 1,
	'animationiterations' => 1,
	'animationloopcount' => 1,
	'animationplays' => 1,
	'anmf' => 1,
	'anniversary' => 1,
	'annotation' => 1,
	'annotations' => 1,
	'annotationusagerights' => 1,
	'announce' => 1,
	'announcelist1' => 1,
	'anoiselines' => 1,
	'anta' => 1,
	'aperture' => 1,
	'aperturedisplayed' => 1,
	'apeversion' => 1,
	'app14flags0' => 1,
	'app14flags1' => 1,
	'app1_profile' => 1,
	'apple-fi' => 1,
	'appledataoffsets' => 1,
	'applemaildatereceived' => 1,
	'applemaildatesent' => 1,
	'applemailflagged' => 1,
	'applemailisremoteattachment' => 1,
	'applemailmessageid' => 1,
	'applemailpriority' => 1,
	'applemailread' => 1,
	'applemailrepliedto' => 1,
	'application' => 1,
	'applicationdata' => 1,
	'applicationmissingmsg' => 1,
	'applicationversion' => 1,
	'applysettingstoliveview' => 1,
	'appname' => 1,
	'archivallocation' => 1,
	'archivedfilename' => 1,
	'ardronefile' => 1,
	'ardronetelemetry' => 1,
	'artist2' => 1,
	'artistlen' => 1,
	'artists' => 1,
	'artisturl' => 1,
	'ascender' => 1,
	'ascent' => 1,
	'asfleakybucketpairs' => 1,
	'asfpacketcount' => 1,
	'asfsecurityobjectssize' => 1,
	'asin' => 1,
	'asin2' => 1,
	'aspectinfo' => 1,
	'aspectratiox' => 1,
	'aspectratioy' => 1,
	'assistantsname' => 1,
	'assistantsphone' => 1,
	'associateddatalist' => 1,
	'associatedimagefile' => 1,
	'association' => 1,
	'assumeddisplaysize' => 1,
	'assumeddistanceview' => 1,
	'ast' => 1,
	'atmospherictemperature' => 1,
	'atmospherictransalpha1' => 1,
	'atmospherictransalpha2' => 1,
	'atmospherictransbeta1' => 1,
	'atmospherictransbeta2' => 1,
	'atmospherictransx' => 1,
	'atob0' => 1,
	'atob1' => 1,
	'atob2' => 1,
	'atob3' => 1,
	'atom0' => 1,
	'atsccontent' => 1,
	'attachments' => 1,
	'attitude' => 1,
	'attitudetarget' => 1,
	'attr' => 1,
	'attributes' => 1,
	'audible_cvrx' => 1,
	'audible_meta' => 1,
	'audible_meta2' => 1,
	'audible_tags' => 1,
	'audible_tseg' => 1,
	'audiences' => 1,
	'audioattributes' => 1,
	'audioavailablebitraterange' => 1,
	'audioavailablenumberchannels' => 1,
	'audioavgbitrate' => 1,
	'audiobitratecontrolmode' => 1,
	'audiobytes' => 1,
	'audiochannellayout' => 1,
	'audiochanneltypes' => 1,
	'audiocodec' => 1,
	'audiocodecdescription' => 1,
	'audiocodecid' => 1,
	'audiocodecinfo' => 1,
	'audiocodecname' => 1,
	'audiocodecprimemethod' => 1,
	'audiocomponentversion' => 1,
	'audiocurrenttargetbitrate' => 1,
	'audiodelay' => 1,
	'audiodoessamplerateconversion' => 1,
	'audioencoding' => 1,
	'audioencodingparamsversion' => 1,
	'audioextendfrequencies' => 1,
	'audiofilesize' => 1,
	'audiofileurl' => 1,
	'audioformat' => 1,
	'audioframesize' => 1,
	'audiohasvariablepacketbytesizes' => 1,
	'audioheader' => 1,
	'audioinfo' => 1,
	'audioinputbuffersize' => 1,
	'audioisinitialized' => 1,
	'audiolayer' => 1,
	'audiomaxbitrate' => 1,
	'audiomaximumpacketbytesize' => 1,
	'audiominimumdelaymode' => 1,
	'audiominimumnumberinputpackets' => 1,
	'audiominimumnumberoutputpackets' => 1,
	'audiomode' => 1,
	'audiooutputprecedence' => 1,
	'audiopacketframesize' => 1,
	'audioprofile' => 1,
	'audioprofileversion' => 1,
	'audioqualitysetting' => 1,
	'audiorequirespacketdescription' => 1,
	'audiosamplecount' => 1,
	'audiosampledesc' => 1,
	'audiosamplesize' => 1,
	'audiosetting' => 1,
	'audiosize' => 1,
	'audiosourceurl' => 1,
	'audiostream' => 1,
	'audiostreamtype' => 1,
	'audiotrackid' => 1,
	'audiousedinputbuffersize' => 1,
	'audiouserecommendedsamplerate' => 1,
	'audiovbrquality' => 1,
	'audiovendorid' => 1,
	'audiozeroframespadded' => 1,
	'authenticationtime' => 1,
	'authenticationtype' => 1,
	'authoridentifier' => 1,
	'authoringsoftwarerelease' => 1,
	'authorlen' => 1,
	'authorname' => 1,
	'authorship' => 1,
	'authorsortorder' => 1,
	'autoareaafstartingpoint' => 1,
	'autoisomin' => 1,
	'autolowlightduration' => 1,
	'automationanimation' => 1,
	'automationflags' => 1,
	'autorotation' => 1,
	'autosavefilepath' => 1,
	'autosaveformat' => 1,
	'autosummary' => 1,
	'aux' => 1,
	'auxiliaryimageref' => 1,
	'auxiliaryimagetype' => 1,
	'av1configuration' => 1,
	'av1configurationversion' => 1,
	'avcconfiguration' => 1,
	'averagebitrate' => 1,
	'averageframerate' => 1,
	'averagelevel' => 1,
	'avgbitrate' => 1,
	'avgbytespersec' => 1,
	'avgpacketsize' => 1,
	'avgpdusize' => 1,
	'avgwidth' => 1,
	'avi1' => 1,
	'avif' => 1,
	'aviheader' => 1,
	'awbinfo' => 1,
	'axisdistancex' => 1,
	'axisdistancey' => 1,
	'axisdistancez' => 1,
	'axml' => 1,
	'b1' => 1,
	'b2' => 1,
	'background' => 1,
	'backgroundcolor' => 1,
	'backgroundcolorindicator' => 1,
	'backgroundcolorvalue' => 1,
	'backgroundimageid' => 1,
	'backgroundtiling' => 1,
	'backlight' => 1,
	'backserial' => 1,
	'backuptime' => 1,
	'badfaxlines' => 1,
	'bahpver' => 1,
	'balpver' => 1,
	'band' => 1,
	'bandwidthsharing' => 1,
	'bannerimage' => 1,
	'bannerimagedata' => 1,
	'bannerimagetype' => 1,
	'bannerimageurl' => 1,
	'barcode' => 1,
	'barcodes' => 1,
	'barometerinfo' => 1,
	'barometerinfoversion' => 1,
	'baselinelength' => 1,
	'basename' => 1,
	'baseviewpointnum' => 1,
	'basisobject' => 1,
	'battery' => 1,
	'batterycapacity' => 1,
	'batterycurrent' => 1,
	'batteryinfo' => 1,
	'batterystatus' => 1,
	'batterytime' => 1,
	'batteryvoltage3' => 1,
	'batteryvoltage4' => 1,
	'bavpver' => 1,
	'bccaddresses' => 1,
	'bccnames' => 1,
	'beats-per-minute' => 1,
	'beautycolorlevel' => 1,
	'beautyretouchlevel' => 1,
	'belowcolor' => 1,
	'beta' => 1,
	'bibligraphicfilename' => 1,
	'bikebroaccel' => 1,
	'bikebrogps' => 1,
	'billinginformation' => 1,
	'binarydata' => 1,
	'binarydatatype' => 1,
	'binaryfilter' => 1,
	'binaryxml' => 1,
	'binning' => 1,
	'birthday' => 1,
	'bitdepthchroma' => 1,
	'bitdepthluma' => 1,
	'bitrate' => 1,
	'bitrateinfo' => 1,
	'bitratemutualexclusion' => 1,
	'bitsperextendedrunlength' => 1,
	'bitsperpixel' => 1,
	'bitsperrunlength' => 1,
	'blackadcountsperdacvolt' => 1,
	'blackclamp' => 1,
	'blackclampoffset' => 1,
	'blackcolsleft' => 1,
	'blackcolsright' => 1,
	'blackdacchannel' => 1,
	'blackdacsettlingmsec' => 1,
	'blackmaskbottomborder' => 1,
	'blackmaskleftborder' => 1,
	'blackmaskrightborder' => 1,
	'blackmasktopborder' => 1,
	'blackrowsbottom' => 1,
	'blackrowstop' => 1,
	'blacktarget' => 1,
	'blocklocation' => 1,
	'blocksize' => 1,
	'blocksizemax' => 1,
	'blocksizemin' => 1,
	'blockspercolumn' => 1,
	'blocksperframe' => 1,
	'blocksperrow' => 1,
	'blueadjust' => 1,
	'blueendpoint' => 1,
	'bluegain' => 1,
	'bluegrassscale1' => 1,
	'bluegrassscale2' => 1,
	'bluegrasstable' => 1,
	'bluemask' => 1,
	'bluematrixcolumn' => 1,
	'blueprimary' => 1,
	'bluesample' => 1,
	'bluetrc' => 1,
	'bluex' => 1,
	'bluey' => 1,
	'blurstrength' => 1,
	'bmpversion' => 1,
	'boardtemperature' => 1,
	'bokehshape' => 1,
	'bookname' => 1,
	'booktitle' => 1,
	'booktype' => 1,
	'bookversion' => 1,
	'bootidentifier' => 1,
	'bootrecord' => 1,
	'bootsystem' => 1,
	'bordercolor' => 1,
	'borderid' => 1,
	'borderinformation' => 1,
	'borderlocation' => 1,
	'bordername' => 1,
	'bordersversion' => 1,
	'bordertype' => 1,
	'bottomdarkrow1' => 1,
	'bottomdarkrow2' => 1,
	'bottommag' => 1,
	'boundaryorigin' => 1,
	'boundingbox' => 1,
	'bracketingburstoptions' => 1,
	'bracketingcounter' => 1,
	'bracketingmode' => 1,
	'bracketingstep' => 1,
	'bracketshot' => 1,
	'brain' => 1,
	'brandingimageid' => 1,
	'brandingname' => 1,
	'brdfatob0' => 1,
	'brdfatob1' => 1,
	'brdfatob2' => 1,
	'brdfatob3' => 1,
	'brdfbtoa0' => 1,
	'brdfbtoa1' => 1,
	'brdfbtoa2' => 1,
	'brdfbtoa3' => 1,
	'brdfbtod0' => 1,
	'brdfbtod1' => 1,
	'brdfbtod2' => 1,
	'brdfbtod3' => 1,
	'brdfcolorimetricparam0' => 1,
	'brdfcolorimetricparam1' => 1,
	'brdfcolorimetricparam2' => 1,
	'brdfcolorimetricparam3' => 1,
	'brdfdtob0' => 1,
	'brdfdtob1' => 1,
	'brdfdtob2' => 1,
	'brdfdtob3' => 1,
	'brdfmtob0' => 1,
	'brdfmtob1' => 1,
	'brdfmtob2' => 1,
	'brdfmtob3' => 1,
	'brdfmtos0' => 1,
	'brdfmtos1' => 1,
	'brdfmtos2' => 1,
	'brdfmtos3' => 1,
	'brdfspectralparam0' => 1,
	'brdfspectralparam1' => 1,
	'brdfspectralparam2' => 1,
	'brdfspectralparam3' => 1,
	'breakchar' => 1,
	'brightdefectintegrationms' => 1,
	'brightdefectisocode' => 1,
	'brightdefectthreshold' => 1,
	'brightnessdata' => 1,
	'brightrowstop' => 1,
	'broadcast' => 1,
	'broadcastdate' => 1,
	'broadcastextension' => 1,
	'btoa0' => 1,
	'btoa1' => 1,
	'btoa2' => 1,
	'btoa3' => 1,
	'btod0' => 1,
	'btod1' => 1,
	'btod2' => 1,
	'btod3' => 1,
	'bufferaverage' => 1,
	'buffersize' => 1,
	'builddate' => 1,
	'buildversion' => 1,
	'businessaddress' => 1,
	'businesscity' => 1,
	'businesscountry-region' => 1,
	'businessfax' => 1,
	'businesshomepage' => 1,
	'businessphone' => 1,
	'businesspobox' => 1,
	'businesspostalcode' => 1,
	'businessstateorprovince' => 1,
	'businessstreet' => 1,
	'buynow' => 1,
	'buytickets' => 1,
	'bw_halftoninginfo' => 1,
	'bw_transferfunc' => 1,
	'bwf_umid' => 1,
	'bwfversion' => 1,
	'bytelength' => 1,
	'byteorder' => 1,
	'byteordermark' => 1,
	'bytes' => 1,
	'bytesperline' => 1,
	'bytesperminute' => 1,
	'cachecontrol' => 1,
	'cachedimageheight' => 1,
	'cachedimagewidth' => 1,
	'calculatedscalemax' => 1,
	'calculatedscalemin' => 1,
	'calibrationdatetime' => 1,
	'calibrationlog' => 1,
	'callbacknumber' => 1,
	'callletters' => 1,
	'camcore' => 1,
	'camera1' => 1,
	'camera2' => 1,
	'cameraarrangementinterval' => 1,
	'camerabacktype' => 1,
	'camerabody' => 1,
	'camerabyteorder' => 1,
	'cameradatetime' => 1,
	'cameraifd' => 1,
	'camerainfo' => 1,
	'camerainfo2' => 1,
	'camerainfo3' => 1,
	'camerainfoa100' => 1,
	'camerainfounknown' => 1,
	'cameramaker' => 1,
	'cameramanufacturer' => 1,
	'cameraname' => 1,
	'cameraobjbacktype' => 1,
	'cameraobject' => 1,
	'cameraobjname' => 1,
	'cameraobjtype' => 1,
	'cameraobjversion' => 1,
	'cameraoperator' => 1,
	'camerapan' => 1,
	'camerapartnumber' => 1,
	'cameraprofileversion' => 1,
	'camerascalemax' => 1,
	'camerascalemin' => 1,
	'camerasettings' => 1,
	'camerasettings2' => 1,
	'camerasettings3' => 1,
	'camerasettingsa100' => 1,
	'camerasettingsifd' => 1,
	'camerasettingsunknown' => 1,
	'camerasetup' => 1,
	'camerasoftware' => 1,
	'cameraspecification' => 1,
	'cameratemperaturemaxclip' => 1,
	'cameratemperaturemaxsaturated' => 1,
	'cameratemperaturemaxwarn' => 1,
	'cameratemperatureminclip' => 1,
	'cameratemperatureminsaturated' => 1,
	'cameratemperatureminwarn' => 1,
	'cameratilt' => 1,
	'camm0' => 1,
	'camm1' => 1,
	'camm2' => 1,
	'camm3' => 1,
	'camm4' => 1,
	'camm5' => 1,
	'camm6' => 1,
	'camm7' => 1,
	'can_skip_backward' => 1,
	'can_skip_forward' => 1,
	'canon' => 1,
	'canon_afinfo2_0x000d' => 1,
	'canon_afinfo_0x000b' => 1,
	'canonafinfo' => 1,
	'canonafinfo2' => 1,
	'canoncamerainfo1000d' => 1,
	'canoncamerainfo1100d' => 1,
	'canoncamerainfo1200d' => 1,
	'canoncamerainfo1d' => 1,
	'canoncamerainfo1dmkii' => 1,
	'canoncamerainfo1dmkiii' => 1,
	'canoncamerainfo1dmkiin' => 1,
	'canoncamerainfo1dmkiv' => 1,
	'canoncamerainfo1dx' => 1,
	'canoncamerainfo40d' => 1,
	'canoncamerainfo450d' => 1,
	'canoncamerainfo500d' => 1,
	'canoncamerainfo50d' => 1,
	'canoncamerainfo550d' => 1,
	'canoncamerainfo5d' => 1,
	'canoncamerainfo5dmkii' => 1,
	'canoncamerainfo5dmkiii' => 1,
	'canoncamerainfo600d' => 1,
	'canoncamerainfo60d' => 1,
	'canoncamerainfo650d' => 1,
	'canoncamerainfo6d' => 1,
	'canoncamerainfo700d' => 1,
	'canoncamerainfo70d' => 1,
	'canoncamerainfo750d' => 1,
	'canoncamerainfo760d' => 1,
	'canoncamerainfo7d' => 1,
	'canoncamerainfo80d' => 1,
	'canoncamerainfopowershot' => 1,
	'canoncamerainfopowershot2' => 1,
	'canoncamerainfounknown' => 1,
	'canoncamerainfounknown16' => 1,
	'canoncamerainfounknown32' => 1,
	'canoncamerasettings' => 1,
	'canoncctp' => 1,
	'canoncnop' => 1,
	'canoncnth' => 1,
	'canoncolorinfo1' => 1,
	'canoncolorinfo2' => 1,
	'canonfileinfo' => 1,
	'canonflags' => 1,
	'canonfocallength' => 1,
	'canonimageheight' => 1,
	'canonimagewidth' => 1,
	'canonpanorama' => 1,
	'canonrawmakemodel' => 1,
	'canonshotinfo' => 1,
	'canonskip' => 1,
	'canseekontime' => 1,
	'canseektoend' => 1,
	'capheight' => 1,
	'captiontext' => 1,
	'captprofbacktype' => 1,
	'captprofname' => 1,
	'captproftype' => 1,
	'captprofversion' => 1,
	'captureconditionspar' => 1,
	'capturedevicefid' => 1,
	'captureheightresetblacksegnormal' => 1,
	'captureheightresetblacksegtest' => 1,
	'captureheighttest' => 1,
	'captureobjbacktype' => 1,
	'captureobjname' => 1,
	'captureobjtype' => 1,
	'captureobjversion' => 1,
	'captureprofile' => 1,
	'captureresolution' => 1,
	'captureserial' => 1,
	'capturesetup' => 1,
	'capturewidthresetblacksegnormal' => 1,
	'capturewidthresetblacksegtest' => 1,
	'capturexresolution' => 1,
	'capturexresolutionunit' => 1,
	'captureyresolution' => 1,
	'captureyresolutionunit' => 1,
	'car' => 1,
	'carphone' => 1,
	'casio' => 1,
	'casiodata' => 1,
	'casiojunk' => 1,
	'casioquality' => 1,
	'casioqvmi' => 1,
	'cast' => 1,
	'catalognumber' => 1,
	'cbordata' => 1,
	'cc' => 1,
	'ccaddresses' => 1,
	'ccdrect' => 1,
	'ccdvalidrect' => 1,
	'ccdvideorect' => 1,
	'ccnames' => 1,
	'cddb1info' => 1,
	'cddbdiscplaytime' => 1,
	'cddbdisctracks' => 1,
	'cddbtracknumber' => 1,
	'cdetype' => 1,
	'cdi1' => 1,
	'cdtrackenabled' => 1,
	'cell' => 1,
	'cellphone' => 1,
	'centerdarkrect' => 1,
	'cfagreenthreshold1' => 1,
	'cfagreenthreshold2' => 1,
	'cfalayout' => 1,
	'cfaplanecolor' => 1,
	'channel0lagkernel' => 1,
	'channel1coordinates' => 1,
	'channel1flags' => 1,
	'channel1label' => 1,
	'channel1lagkernel' => 1,
	'channel2coordinates' => 1,
	'channel2flags' => 1,
	'channel2label' => 1,
	'channel2lagkernel' => 1,
	'channel3coordinates' => 1,
	'channel3flags' => 1,
	'channel3label' => 1,
	'channel3lagkernel' => 1,
	'channel4coordinates' => 1,
	'channel4flags' => 1,
	'channel4label' => 1,
	'channel5coordinates' => 1,
	'channel5flags' => 1,
	'channel5label' => 1,
	'channel6coordinates' => 1,
	'channel6flags' => 1,
	'channel6label' => 1,
	'channel7coordinates' => 1,
	'channel7flags' => 1,
	'channel7label' => 1,
	'channel8coordinates' => 1,
	'channel8flags' => 1,
	'channel8label' => 1,
	'channelcoarsegainadjust' => 1,
	'channelmode' => 1,
	'channelnumber' => 1,
	'channelusage' => 1,
	'chapter' => 1,
	'chaptercount' => 1,
	'chapterlisttrackid' => 1,
	'chaptername' => 1,
	'chapternum' => 1,
	'chapternumber' => 1,
	'characterescapesequence' => 1,
	'characters' => 1,
	'characterset' => 1,
	'characterswithspaces' => 1,
	'charcountwithspaces' => 1,
	'chartarget' => 1,
	'chartcontourinterval' => 1,
	'chartcorrdate' => 1,
	'chartcountryorigin' => 1,
	'chartdepthunits' => 1,
	'chartformat' => 1,
	'chartmagvar' => 1,
	'chartmagvarannchange' => 1,
	'chartmagvaryear' => 1,
	'chartrasteredition' => 1,
	'chartsoundingdatum' => 1,
	'chartsource' => 1,
	'chartsourcedate' => 1,
	'chartsourceedition' => 1,
	'chartwgsnsshift' => 1,
	'checkedby' => 1,
	'children' => 1,
	'chmversion' => 1,
	'chromaformat' => 1,
	'chromasampleposition' => 1,
	'chromaticaberrationparams' => 1,
	'chromaticadaptation' => 1,
	'chromaticities' => 1,
	'chromaticity' => 1,
	'chromaticitychannel1' => 1,
	'chromaticitychannel2' => 1,
	'chromaticitychannel3' => 1,
	'chromaticitychannel4' => 1,
	'chromaticitychannels' => 1,
	'chromaticitycolorant' => 1,
	'chunkoffset' => 1,
	'chunkoffset64' => 1,
	'ciff' => 1,
	'cinematographer' => 1,
	'cip3datafile' => 1,
	'cip3sheet' => 1,
	'cip3side' => 1,
	'circleofconfusion' => 1,
	'class' => 1,
	'cleanaperture' => 1,
	'cleanaperturedimensions' => 1,
	'cleanapertureheight' => 1,
	'cleanapertureoffsetx' => 1,
	'cleanapertureoffsety' => 1,
	'cleanaperturewidth' => 1,
	'cleanfaxdata' => 1,
	'clientid' => 1,
	'clipboundary' => 1,
	'clipobjects' => 1,
	'clippath' => 1,
	'clippingboundary' => 1,
	'clippinglimit' => 1,
	'clippingpathname' => 1,
	'cloneid' => 1,
	'cloneobject' => 1,
	'clonetype' => 1,
	'closedcaptioning' => 1,
	'cmddialsaperturesetting' => 1,
	'cmddialschangemainsub' => 1,
	'cmddialschangemainsubexposure' => 1,
	'cmddialsmenuandplayback' => 1,
	'cmddialsreverserotexposurecomp' => 1,
	'cmmflags' => 1,
	'cmp1' => 1,
	'cmykequivalent' => 1,
	'coarsedata' => 1,
	'coarsemapimage' => 1,
	'coarsemapimageheight' => 1,
	'coarsemapimagetype' => 1,
	'coarsemapimagewidth' => 1,
	'codecflavorid' => 1,
	'codeclist' => 1,
	'codedframesize' => 1,
	'codepage' => 1,
	'codesize' => 1,
	'codestreamheader' => 1,
	'codestreamregistration' => 1,
	'codinghistory' => 1,
	'codingmethods' => 1,
	'codirectors' => 1,
	'colorant1coordinates' => 1,
	'colorant1name' => 1,
	'colorant2coordinates' => 1,
	'colorant2name' => 1,
	'colorant3coordinates' => 1,
	'colorant3name' => 1,
	'colorantcount' => 1,
	'colorantinfoout' => 1,
	'colorantorder' => 1,
	'colorantorderout' => 1,
	'coloranttable' => 1,
	'coloranttableout' => 1,
	'coloraverages' => 1,
	'colorbalance0100' => 1,
	'colorbalance0102' => 1,
	'colorbalance0103' => 1,
	'colorbalance02' => 1,
	'colorbalance0205' => 1,
	'colorbalance0209' => 1,
	'colorbalance0211' => 1,
	'colorbalance0213' => 1,
	'colorbalance0215' => 1,
	'colorbalancea' => 1,
	'colorbalanceunknown' => 1,
	'colorbalanceunknown02' => 1,
	'colorbalanceunknown04' => 1,
	'colorbitdepth' => 1,
	'colorboostdata' => 1,
	'colorbw' => 1,
	'colorcalib' => 1,
	'colorcalib2' => 1,
	'colorcalibrationmatrix' => 1,
	'colorcasts' => 1,
	'colorcharacterization' => 1,
	'colorcoefs' => 1,
	'colorcoefs2' => 1,
	'colorcomponents' => 1,
	'colordata1' => 1,
	'colordata10' => 1,
	'colordata11' => 1,
	'colordata2' => 1,
	'colordata3' => 1,
	'colordata4' => 1,
	'colordata5' => 1,
	'colordata6' => 1,
	'colordata7' => 1,
	'colordata8' => 1,
	'colordata9' => 1,
	'colordataunknown' => 1,
	'colorencodingparams' => 1,
	'colorgroup' => 1,
	'colorhalftoninginfo' => 1,
	'colorimetricintentimagestate' => 1,
	'colorimetricspecification' => 1,
	'colorimetry' => 1,
	'colorinfo' => 1,
	'colormap' => 1,
	'colorobjbacktype' => 1,
	'colorobjname' => 1,
	'colorobjtype' => 1,
	'colorobjversion' => 1,
	'colorpalette' => 1,
	'colorpopstrength' => 1,
	'colorprimaries' => 1,
	'colorresolutiondepth' => 1,
	'colorresponseunit' => 1,
	'colors' => 1,
	'colorsamplersresource' => 1,
	'colorsamplersresource2' => 1,
	'colorsetup' => 1,
	'colorspacedata' => 1,
	'colorspacename' => 1,
	'colorspecification' => 1,
	'colortable' => 1,
	'colortemperatures' => 1,
	'colortransferfuncs' => 1,
	'colortransform' => 1,
	'colortwistmatrix' => 1,
	'colortype' => 1,
	'columncount' => 1,
	'columngainfactors' => 1,
	'columnresetoffsets' => 1,
	'command' => 1,
	'commandlinearguments' => 1,
	'commentby' => 1,
	'commentlen' => 1,
	'comments' => 1,
	'commenttime' => 1,
	'commercialurl' => 1,
	'commissioned' => 1,
	'common' => 1,
	'commonnetworkrellink' => 1,
	'commonpathsuffix' => 1,
	'compactsamplesizes' => 1,
	'company' => 1,
	'companymainphone' => 1,
	'companyname' => 1,
	'compatibility' => 1,
	'compatiblebrands' => 1,
	'compatiblefontname' => 1,
	'complete' => 1,
	'compobj' => 1,
	'compobjusertype' => 1,
	'compobjusertypelen' => 1,
	'componentbitdepth' => 1,
	'componentdefinition' => 1,
	'componentmapping' => 1,
	'componenttable' => 1,
	'composers' => 1,
	'composersortorder' => 1,
	'compositinglayerheader' => 1,
	'compositionmode' => 1,
	'compositionoptions' => 1,
	'compositiontimetosample' => 1,
	'compositiontodecodetimelinemapping' => 1,
	'compressed' => 1,
	'compressedannotation' => 1,
	'compresseddatalength' => 1,
	'compresseddataoffset' => 1,
	'compressedmovie' => 1,
	'compressedsize' => 1,
	'compressedtext' => 1,
	'compressionclass' => 1,
	'compressionlevel' => 1,
	'compressiontype' => 1,
	'compressorid' => 1,
	'compressorname' => 1,
	'computedatmospherictrans' => 1,
	'computer' => 1,
	'concreteflag' => 1,
	'condition' => 1,
	'conditionalfec' => 1,
	'conductors' => 1,
	'confirmedobjectsize' => 1,
	'connectionspaceilluminant' => 1,
	'consecutivebadfaxlines' => 1,
	'consoledata' => 1,
	'consolefedata' => 1,
	'constantframerate' => 1,
	'constraintindicatorflags' => 1,
	'cont' => 1,
	'contactnames' => 1,
	'containerversion' => 1,
	'contake' => 1,
	'contentbranding' => 1,
	'contentdescribes' => 1,
	'contentdescription' => 1,
	'contentdescriptionnotes' => 1,
	'contentdisposition' => 1,
	'contentdistributorduration' => 1,
	'contentdistributortype' => 1,
	'contentencryption' => 1,
	'contentgroupdescription' => 1,
	'contentlanguage' => 1,
	'contentprotected' => 1,
	'contentprotectedpercent' => 1,
	'contentrating' => 1,
	'contents' => 1,
	'contentscripttype' => 1,
	'contentstyletype' => 1,
	'contiguouscodestream' => 1,
	'contrastadjustment' => 1,
	'contrastinfo' => 1,
	'controller' => 1,
	'convergenceangle' => 1,
	'convergencebaseimage' => 1,
	'convergencedistance' => 1,
	'conversationid' => 1,
	'copyrightfilename' => 1,
	'copyrightlen' => 1,
	'copyrighturl' => 1,
	'coringtablebest' => 1,
	'coringtablebetter' => 1,
	'coringtablegood' => 1,
	'correctionmethod' => 1,
	'costumedesigner' => 1,
	'count' => 1,
	'countinfo' => 1,
	'country-region' => 1,
	'coverartmimetype' => 1,
	'coverarttype' => 1,
	'coyotesense' => 1,
	'coyotestatus' => 1,
	'cpuarchitecture' => 1,
	'cpubyteorder' => 1,
	'cpucount' => 1,
	'cpusubtype' => 1,
	'cputype' => 1,
	'cpuversions' => 1,
	'cr2cfapattern' => 1,
	'crc' => 1,
	'crcdevelparams' => 1,
	'crd' => 1,
	'crdinfo' => 1,
	'createdby' => 1,
	'creatingapplication' => 1,
	'creatingtransform' => 1,
	'creationpathvector' => 1,
	'creatorapplication' => 1,
	'creatorappversion' => 1,
	'creatoratom' => 1,
	'creatorbuildnumber' => 1,
	'creatorbuildnumber2' => 1,
	'creatorinfo' => 1,
	'creatormajorversion' => 1,
	'creatorminorversion' => 1,
	'creatorsoftware' => 1,
	'creatorversion' => 1,
	'crgbtoerimm0spline' => 1,
	'crgbtoerimm1spline' => 1,
	'crgbtoerimm2spline' => 1,
	'crgbtoerimm3spline' => 1,
	'crgbtoerimm4spline' => 1,
	'crgbtoerimm5spline' => 1,
	'crgbtoerimm6spline' => 1,
	'crgbtoerimm7spline' => 1,
	'crgbtoerimm8spline' => 1,
	'crgbtoerimm9spline' => 1,
	'cropdata' => 1,
	'cropinfo' => 1,
	'cropped' => 1,
	'cropxcommonoffset' => 1,
	'cropxoffset' => 1,
	'cropxoffset2' => 1,
	'cropxsize' => 1,
	'cropxviewpointnumber' => 1,
	'cropxviewpointnumber2' => 1,
	'cropycommonoffset' => 1,
	'cropyoffset' => 1,
	'cropyoffset2' => 1,
	'cropysize' => 1,
	'cropyviewpointnumber' => 1,
	'cropyviewpointnumber2' => 1,
	'cross-reference' => 1,
	'crossbarenable' => 1,
	'crossref' => 1,
	'crs' => 1,
	'crwparam' => 1,
	'cs0' => 1,
	'cs1' => 1,
	'ctmd' => 1,
	'cubemapproj' => 1,
	'cuepoint' => 1,
	'cuepointlabel' => 1,
	'cuepointnote' => 1,
	'cuepoints' => 1,
	'cuesheet' => 1,
	'currentbitrate' => 1,
	'currentiptcdigest' => 1,
	'currenttime' => 1,
	'currentuser' => 1,
	'cursorsize' => 1,
	'customfunctions10d' => 1,
	'customfunctions1d' => 1,
	'customfunctions2' => 1,
	'customfunctions20d' => 1,
	'customfunctions30d' => 1,
	'customfunctions350d' => 1,
	'customfunctions400d' => 1,
	'customfunctions5d' => 1,
	'customfunctionsd30' => 1,
	'customfunctionsd60' => 1,
	'customfunctionsunknown' => 1,
	'customsettingsd3' => 1,
	'customsettingsd300' => 1,
	'customsettingsd300s' => 1,
	'customsettingsd3s' => 1,
	'customsettingsd3x' => 1,
	'customsettingsd4' => 1,
	'customsettingsd40' => 1,
	'customsettingsd4s' => 1,
	'customsettingsd5' => 1,
	'customsettingsd500' => 1,
	'customsettingsd5000' => 1,
	'customsettingsd5100' => 1,
	'customsettingsd5200' => 1,
	'customsettingsd610' => 1,
	'customsettingsd700' => 1,
	'customsettingsd7000' => 1,
	'customsettingsd80' => 1,
	'customsettingsd800' => 1,
	'customsettingsd810' => 1,
	'customsettingsd850' => 1,
	'customsettingsd90' => 1,
	'customsettingsz9' => 1,
	'customtostandardpcc' => 1,
	'cxf' => 1,
	'd-lightinghqdata' => 1,
	'd-lightinghsdata' => 1,
	'd2' => 1,
	'daccountspervolt' => 1,
	'dacgainscoarse' => 1,
	'dacgainscoarseadjpreif41' => 1,
	'dacgainsfine' => 1,
	'dacvoltages' => 1,
	'dacvoltagesflush' => 1,
	'darkcorrectiontype' => 1,
	'darkmapscale' => 1,
	'darkrefoffsetnormal' => 1,
	'darkrefoffsettest' => 1,
	'darkthreshold' => 1,
	'darwindata' => 1,
	'data' => 1,
	'data1' => 1,
	'data2' => 1,
	'databasename' => 1,
	'datacreatedate' => 1,
	'datadump' => 1,
	'datadump2' => 1,
	'datainfo' => 1,
	'datakey' => 1,
	'datalen' => 1,
	'datalength' => 1,
	'datalocation' => 1,
	'datamodifydate' => 1,
	'dataobject' => 1,
	'dataobjectid' => 1,
	'dataobjectstatus' => 1,
	'dataobjecttitle' => 1,
	'dataoffset' => 1,
	'dataoffsets' => 1,
	'datapackets' => 1,
	'datapreparer' => 1,
	'datarate' => 1,
	'dataref' => 1,
	'datareference' => 1,
	'datasign' => 1,
	'datasize' => 1,
	'datasize64' => 1,
	'datatype' => 1,
	'datawindow' => 1,
	'dateaccessed' => 1,
	'datearchived' => 1,
	'datecompleted' => 1,
	'dateimported' => 1,
	'datelastsaved' => 1,
	'datemodified' => 1,
	'datepicturetaken' => 1,
	'datereceived' => 1,
	'datereleased' => 1,
	'datetime1' => 1,
	'datetime2' => 1,
	'datetimecreated' => 1,
	'datetimeend' => 1,
	'datetimegenerated' => 1,
	'datevisited' => 1,
	'daymat0' => 1,
	'daymat1' => 1,
	'daymat2' => 1,
	'daymat3' => 1,
	'daymat4' => 1,
	'daymat5' => 1,
	'daymat6' => 1,
	'daymat7' => 1,
	'daymat8' => 1,
	'daymat9' => 1,
	'db' => 1,
	'dblcoldcacthres1' => 1,
	'dblcoldcacthres2' => 1,
	'dc' => 1,
	'dcem' => 1,
	'dcme' => 1,
	'dcs3xxprocessinginfo' => 1,
	'dcs3xxprocessinginfoifd' => 1,
	'dctencodeversion' => 1,
	'dealeridnumber' => 1,
	'decimationmethod' => 1,
	'decimationprefilterwidth' => 1,
	'decode' => 1,
	'decodeconfig' => 1,
	'decodertable' => 1,
	'decodertablenumber' => 1,
	'decoderversion' => 1,
	'defaultaudiostream' => 1,
	'defaultchar' => 1,
	'defaultcmyk' => 1,
	'defaultdisplayheight' => 1,
	'defaultdisplaywidth' => 1,
	'defaultimagecolor' => 1,
	'defaultrgb' => 1,
	'defaultstyle' => 1,
	'defectconcealartcorrectthres' => 1,
	'defectconcealthrestable' => 1,
	'defectcount' => 1,
	'defectlist' => 1,
	'defectlistpacked' => 1,
	'defineobject' => 1,
	'definequantizationtable' => 1,
	'delay' => 1,
	'delaycols' => 1,
	'delaytime' => 1,
	'delimiter' => 1,
	'delta12to8spline' => 1,
	'delta8to12spline' => 1,
	'deltapngheader' => 1,
	'deltatype' => 1,
	'deltaxy' => 1,
	'department' => 1,
	'dependentimage1entrynumber' => 1,
	'dependentimage2entrynumber' => 1,
	'depth' => 1,
	'depthhwheight' => 1,
	'depthhwwidth' => 1,
	'depthmapdata' => 1,
	'depthmapdata2' => 1,
	'depthmapheight' => 1,
	'depthmapname' => 1,
	'depthmaptiff' => 1,
	'depthmapwidth' => 1,
	'depthswheight' => 1,
	'depthswwidth' => 1,
	'derivedimageref' => 1,
	'descender' => 1,
	'designer' => 1,
	'designerurl' => 1,
	'desiredreproductions' => 1,
	'destinationid' => 1,
	'detectedfacebounds' => 1,
	'detectedfaceid' => 1,
	'detectedfacerollangle' => 1,
	'detectedfaceyawangle' => 1,
	'detector' => 1,
	'detectorboard' => 1,
	'deviceattributes' => 1,
	'devicecontainer' => 1,
	'deviceid' => 1,
	'devicemanufacturer' => 1,
	'devicemfgdesc' => 1,
	'devicemodel' => 1,
	'devicemodeldesc' => 1,
	'devicename' => 1,
	'deviceorientation' => 1,
	'devicesettings' => 1,
	'dex' => 1,
	'dialect' => 1,
	'dicom' => 1,
	'dictionary' => 1,
	'dictionaryshortname' => 1,
	'difftilegains24t852822' => 1,
	'difftilegains602832' => 1,
	'digikam' => 1,
	'digitalcreationdatetime' => 1,
	'digitaleffectsname' => 1,
	'digitaleffectstype' => 1,
	'digitaleffectsversion' => 1,
	'digitalexposurebiases' => 1,
	'digitalexposuregains' => 1,
	'digitalimagebroker' => 1,
	'digitalsignature' => 1,
	'dimensions' => 1,
	'directionalatob0' => 1,
	'directionalatob1' => 1,
	'directionalatob2' => 1,
	'directionalatob3' => 1,
	'directionalbtoa0' => 1,
	'directionalbtoa1' => 1,
	'directionalbtoa2' => 1,
	'directionalbtoa3' => 1,
	'directionalbtod0' => 1,
	'directionalbtod1' => 1,
	'directionalbtod2' => 1,
	'directionalbtod3' => 1,
	'directionaldtob0' => 1,
	'directionaldtob1' => 1,
	'directionaldtob2' => 1,
	'directionaldtob3' => 1,
	'directors' => 1,
	'disableflagspresent' => 1,
	'discardobjects' => 1,
	'displayartist' => 1,
	'displayinfo' => 1,
	'displayresolution' => 1,
	'displaysize' => 1,
	'displayunits' => 1,
	'displaywindow' => 1,
	'displayxresolution' => 1,
	'displayxresolutionunit' => 1,
	'displayyresolution' => 1,
	'displayyresolutionunit' => 1,
	'dispose' => 1,
	'disposition' => 1,
	'distance' => 1,
	'distancefromhome' => 1,
	'distortinfo' => 1,
	'distortioninfo' => 1,
	'distortionversion' => 1,
	'distributedby' => 1,
	'distribution' => 1,
	'dittokey' => 1,
	'division' => 1,
	'dji_dtat' => 1,
	'djvuversion' => 1,
	'dlnaserverudn' => 1,
	'dlnasourceuri' => 1,
	'dlodata' => 1,
	'dlodatalength' => 1,
	'dloinfo' => 1,
	'dmeroderadius' => 1,
	'dmfillrejthresh' => 1,
	'dmnoisescale' => 1,
	'dmnumpatches' => 1,
	'dmpixelthresholdfactor' => 1,
	'dmsmoothrejthresh' => 1,
	'dmtrimfraction' => 1,
	'dmwindowthresholdfactor' => 1,
	'docclass' => 1,
	'docflags' => 1,
	'docmdp' => 1,
	'docrights' => 1,
	'docsecurity' => 1,
	'doctype' => 1,
	'documentinfo' => 1,
	'documentnumber' => 1,
	'documentusagerights' => 1,
	'dof' => 1,
	'donotshow' => 1,
	'dop' => 1,
	'dotrange' => 1,
	'dotsperinch' => 1,
	'downsampleby2hor' => 1,
	'downsampleby2hor3mpdcr' => 1,
	'downsampleby2ver' => 1,
	'downsampleby2ver3mpdcr' => 1,
	'downsampleby3hor' => 1,
	'downsampleby3ver' => 1,
	'downsampleby4hor' => 1,
	'downsampleby4ver' => 1,
	'downsampleby6hor' => 1,
	'downsampleby6ver' => 1,
	'dpxfilesize' => 1,
	'dr4' => 1,
	'dr4header' => 1,
	'driveserialnumber' => 1,
	'drivesettings' => 1,
	'drivetype' => 1,
	'drm' => 1,
	'drm_contentid' => 1,
	'drm_drmheader' => 1,
	'drm_drmheader_contentdistributor' => 1,
	'drm_drmheader_contentid' => 1,
	'drm_drmheader_individualizedversion' => 1,
	'drm_drmheader_keyid' => 1,
	'drm_drmheader_licenseacqurl' => 1,
	'drm_drmheader_subscriptioncontentid' => 1,
	'drm_e-bookbaseid' => 1,
	'drm_individualizedversion' => 1,
	'drm_keyid' => 1,
	'drm_lasignaturecert' => 1,
	'drm_lasignaturelicsrvcert' => 1,
	'drm_lasignatureprivkey' => 1,
	'drm_lasignaturerootcert' => 1,
	'drm_licenseacqurl' => 1,
	'drm_v1licenseacqurl' => 1,
	'drmcommerceid' => 1,
	'drmindividualizedversion' => 1,
	'drmkeyid' => 1,
	'drmserverid' => 1,
	'drone-dji' => 1,
	'dronepitch' => 1,
	'dronequaternion' => 1,
	'droneroll' => 1,
	'droneyaw' => 1,
	'dropbykeyword' => 1,
	'dropchunks' => 1,
	'dtcpiphost' => 1,
	'dtcpipport' => 1,
	'dtob0' => 1,
	'dtob1' => 1,
	'dtob2' => 1,
	'dtob3' => 1,
	'dtvcontent' => 1,
	'dualcameraimage' => 1,
	'dualcameraimagename' => 1,
	'dualshotextra' => 1,
	'ducky' => 1,
	'duedate' => 1,
	'dummycolsleft' => 1,
	'dummycolsright' => 1,
	'duotonehalftoninginfo' => 1,
	'duotoneimageinfo' => 1,
	'duotonetransferfuncs' => 1,
	'dustdeleteapplied' => 1,
	'dustinfo' => 1,
	'dvdid' => 1,
	'dwc' => 1,
	'dynamicranger128' => 1,
	'e-mail2' => 1,
	'e-mail3' => 1,
	'e-mailaddress' => 1,
	'e-maildisplayname' => 1,
	'e-maillist' => 1,
	'edgespline' => 1,
	'edgesplinehigh' => 1,
	'edgesplinelow' => 1,
	'edgesplinemed' => 1,
	'edit4data' => 1,
	'editdata' => 1,
	'editedby' => 1,
	'editor' => 1,
	'edittagarray' => 1,
	'effect' => 1,
	'effectivebw' => 1,
	'effectstrength' => 1,
	'effectsvisible' => 1,
	'effecttype' => 1,
	'eighteenpercentpoint' => 1,
	'eighthlanguage' => 1,
	'electricalextendermagnification' => 1,
	'electronicimagestabilization' => 1,
	'electronicvr' => 1,
	'elementarystreamtrack' => 1,
	'embeddedaudiofile' => 1,
	'embeddedaudiofilename' => 1,
	'embeddedfile' => 1,
	'embeddedfilename' => 1,
	'embeddedfileusagerights' => 1,
	'embeddedimage' => 1,
	'embeddedimage2' => 1,
	'embeddedimagecolorspace' => 1,
	'embeddedimagefilter' => 1,
	'embeddedimageheight' => 1,
	'embeddedimagename' => 1,
	'embeddedimagetype' => 1,
	'embeddedimagewidth' => 1,
	'embeddedjpg' => 1,
	'embeddedpng' => 1,
	'embeddedvideo' => 1,
	'embeddedvideofile' => 1,
	'embeddedvideotype' => 1,
	'emphasis' => 1,
	'empty' => 1,
	'encodedpixelsdimensions' => 1,
	'encodedusing' => 1,
	'encoderoptions' => 1,
	'encodersettings' => 1,
	'encodervendor' => 1,
	'encoderversion' => 1,
	'encodetime' => 1,
	'encoding' => 1,
	'encodingparams' => 1,
	'encodingprocess' => 1,
	'encodingscheme' => 1,
	'encodingsettings' => 1,
	'encrypt' => 1,
	'encryption' => 1,
	'enddate' => 1,
	'endianness' => 1,
	'endpoints' => 1,
	'endtime' => 1,
	'endtimecode' => 1,
	'entrypoint' => 1,
	'entrytype' => 1,
	'environmentmap' => 1,
	'envvardata' => 1,
	'eppim' => 1,
	'eprint' => 1,
	'epsoptions' => 1,
	'equipment' => 1,
	'equipmentifd' => 1,
	'equirectangularproj' => 1,
	'erimmnonlinearityspline' => 1,
	'erimmtocrgb0spline' => 1,
	'erimmtocrgb1spline' => 1,
	'erimmtocrgb2spline' => 1,
	'erimmtocrgb3spline' => 1,
	'erimmtocrgb4spline' => 1,
	'erimmtocrgb5spline' => 1,
	'erimmtocrgb6spline' => 1,
	'erimmtocrgb7spline' => 1,
	'erimmtocrgb8spline' => 1,
	'erimmtocrgb9spline' => 1,
	'erimmtonescale0spline' => 1,
	'erimmtonescale1spline' => 1,
	'erimmtonescale2spline' => 1,
	'erimmtonescale3spline' => 1,
	'erimmtonescale4spline' => 1,
	'erimmtonescale5spline' => 1,
	'erimmtonescale6spline' => 1,
	'erimmtonescale7spline' => 1,
	'erimmtonescale8spline' => 1,
	'erimmtonescale9spline' => 1,
	'error' => 1,
	'errorcorrection' => 1,
	'errorcorrectiontype' => 1,
	'escapestatus' => 1,
	'escchar' => 1,
	'estimatedatmospherictrans' => 1,
	'evalstate' => 1,
	'eventlogcapture' => 1,
	'eventlogprocess' => 1,
	'events' => 1,
	'evstepinfo' => 1,
	'exif_profile' => 1,
	'exifdata' => 1,
	'exifex' => 1,
	'exififd' => 1,
	'exifinfo' => 1,
	'exifinfo2' => 1,
	'exifinfo7' => 1,
	'exifinfo8' => 1,
	'exifinfo9' => 1,
	'exifinformation' => 1,
	'exifoffset' => 1,
	'exiftoolversion' => 1,
	'expandfilm' => 1,
	'expandfilterlens' => 1,
	'expandflashlamp' => 1,
	'expandlens' => 1,
	'expandscanner' => 1,
	'expandsoftware' => 1,
	'expirationspan' => 1,
	'expires' => 1,
	'exportimage' => 1,
	'exposurebias' => 1,
	'exposureheadroomfactor' => 1,
	'exposureinfo' => 1,
	'exposurereferencegain' => 1,
	'exposurereferenceoffset' => 1,
	'exposuretimes' => 1,
	'exposureunknown' => 1,
	'expressionmedia' => 1,
	'exrversion' => 1,
	'extcache' => 1,
	'extendedalbumname' => 1,
	'extendedartistname' => 1,
	'extendedaviheader' => 1,
	'extendedcontentdescr' => 1,
	'extendedcontentencryption' => 1,
	'extendedinfo' => 1,
	'extendedstreamprops' => 1,
	'extendedtracktitle' => 1,
	'extendedxmp' => 1,
	'extensionclassid' => 1,
	'extensioncreatedate' => 1,
	'extensiondescription' => 1,
	'extensionmodifydate' => 1,
	'extensionname' => 1,
	'extensionpersistence' => 1,
	'extensions' => 1,
	'extensis' => 1,
	'externalleading' => 1,
	'externaltriggercount' => 1,
	'extraflags' => 1,
	'extrainfo' => 1,
	'extrainfo2' => 1,
	'extrainfo3' => 1,
	'extrasamples' => 1,
	'extraticklocations' => 1,
	'f-stop' => 1,
	'face1birthday' => 1,
	'face1category' => 1,
	'face1name' => 1,
	'face2birthday' => 1,
	'face2category' => 1,
	'face2name' => 1,
	'face3birthday' => 1,
	'face3category' => 1,
	'face3name' => 1,
	'face4birthday' => 1,
	'face4category' => 1,
	'face4name' => 1,
	'face5birthday' => 1,
	'face5category' => 1,
	'face5name' => 1,
	'face6birthday' => 1,
	'face6category' => 1,
	'face6name' => 1,
	'face7birthday' => 1,
	'face7category' => 1,
	'face7name' => 1,
	'face8birthday' => 1,
	'face8category' => 1,
	'face8name' => 1,
	'facedetect1' => 1,
	'facedetect2' => 1,
	'facedetect3' => 1,
	'facedetected' => 1,
	'facedetinfo' => 1,
	'faceinfo' => 1,
	'faceinfo1' => 1,
	'faceinfo2' => 1,
	'faceinfoa' => 1,
	'faceinfolength' => 1,
	'faceinfooffset' => 1,
	'faceitem' => 1,
	'facenumbers' => 1,
	'facepos' => 1,
	'facerec' => 1,
	'facerecinfo' => 1,
	'facesize' => 1,
	'factorywhitegainsdaylight' => 1,
	'factorywhiteoffsetsdaylight' => 1,
	'farklewhitethreshold' => 1,
	'fastseek' => 1,
	'faxprofile' => 1,
	'faxrecvparams' => 1,
	'faxrecvtime' => 1,
	'faxsubaddress' => 1,
	'fdsc' => 1,
	'fedexedr' => 1,
	'fffheader' => 1,
	'fieldmdp' => 1,
	'fieldpermissions' => 1,
	'fifthlanguage' => 1,
	'file1duration' => 1,
	'file1length' => 1,
	'file1md5sum' => 1,
	'file1media' => 1,
	'file1path' => 1,
	'file1pathutf-8' => 1,
	'fileaccessdate' => 1,
	'fileas' => 1,
	'fileattributes' => 1,
	'fileblockcount' => 1,
	'fileblocksize' => 1,
	'filecount' => 1,
	'filedescription' => 1,
	'filedeviceid' => 1,
	'filedevicenumber' => 1,
	'fileflags' => 1,
	'fileflagsmask' => 1,
	'filefunctionflags' => 1,
	'fileglobalprofile' => 1,
	'fileguid' => 1,
	'filehardlinks' => 1,
	'fileid' => 1,
	'fileinfo' => 1,
	'fileinfolen' => 1,
	'fileinfolen2' => 1,
	'fileinfoproperties' => 1,
	'fileinfoversion' => 1,
	'fileinodechangedate' => 1,
	'fileinodenumber' => 1,
	'filelength' => 1,
	'fileos' => 1,
	'fileowner' => 1,
	'filepath' => 1,
	'fileprofileversion' => 1,
	'fileproperties' => 1,
	'files' => 1,
	'filesequence' => 1,
	'filesize' => 1,
	'filesizebytes' => 1,
	'filesubtype' => 1,
	'filetype' => 1,
	'filetypeextension' => 1,
	'fileurl' => 1,
	'fileversionnumber' => 1,
	'fillattributes' => 1,
	'fillmethod' => 1,
	'filmbrand' => 1,
	'filmcategory' => 1,
	'filmframenumber' => 1,
	'filmgencode' => 1,
	'filmproductcode' => 1,
	'filmrollnumber' => 1,
	'filmsize' => 1,
	'filter' => 1,
	'filterinfo' => 1,
	'filtering' => 1,
	'filtermodel' => 1,
	'filterparametersbinary' => 1,
	'filterparameterscustomcustomdata' => 1,
	'filterparametersexportexportdata' => 1,
	'filterpartnumber' => 1,
	'filterserialnumber' => 1,
	'finalflushsequence' => 1,
	'finalframeblocks' => 1,
	'finetune' => 1,
	'finishedfileprocessingrequest' => 1,
	'finishipaversion' => 1,
	'finishipfversion' => 1,
	'firmwareinfo' => 1,
	'firstchar' => 1,
	'firstflushsequence' => 1,
	'firstlanguage' => 1,
	'firstlines' => 1,
	'firstlinetransfertiming' => 1,
	'firstname' => 1,
	'firstobject' => 1,
	'firstobjectid' => 1,
	'fisheyefilter' => 1,
	'flac' => 1,
	'flagcolor' => 1,
	'flags' => 1,
	'flagstatus' => 1,
	'flashattributes' => 1,
	'flashexpcomp' => 1,
	'flashinfo' => 1,
	'flashinfo0100' => 1,
	'flashinfo0102' => 1,
	'flashinfo0103' => 1,
	'flashinfo0106' => 1,
	'flashinfo0107' => 1,
	'flashinfo0300' => 1,
	'flashinfounknown' => 1,
	'flashinfoversion' => 1,
	'flashmat0' => 1,
	'flashmat1' => 1,
	'flashmat2' => 1,
	'flashmat3' => 1,
	'flashmat4' => 1,
	'flashmat5' => 1,
	'flashmat6' => 1,
	'flashmat7' => 1,
	'flashmat8' => 1,
	'flashmat9' => 1,
	'flashpixstreamfieldoffset' => 1,
	'flashpixstreampathname' => 1,
	'flashpower' => 1,
	'flashsyncmode' => 1,
	'flashttlmode' => 1,
	'flashused' => 1,
	'flashversion' => 1,
	'flavor' => 1,
	'flipstatus' => 1,
	'flir' => 1,
	'flir_gps' => 1,
	'flir_moreinfo' => 1,
	'flir_params' => 1,
	'flir_parts' => 1,
	'flir_serial' => 1,
	'flir_unknown' => 1,
	'flir_unknownuuid' => 1,
	'fluormat0' => 1,
	'fluormat1' => 1,
	'fluormat2' => 1,
	'fluormat3' => 1,
	'fluormat4' => 1,
	'fluormat5' => 1,
	'fluormat6' => 1,
	'fluormat7' => 1,
	'fluormat8' => 1,
	'fluormat9' => 1,
	'flushtiming' => 1,
	'flyingstate' => 1,
	'focalinfo' => 1,
	'focallength35efl' => 1,
	'focallength35mm' => 1,
	'focalplanecolorimetryestimates' => 1,
	'focalrange' => 1,
	'focusdistance2' => 1,
	'focusedgemap' => 1,
	'focusframesize' => 1,
	'focusinfo' => 1,
	'focusinfoifd' => 1,
	'focuspointbrightness' => 1,
	'focuspointselectionspeed' => 1,
	'focuspos' => 1,
	'focussettings' => 1,
	'folder' => 1,
	'folderpath' => 1,
	'follow-meanimation' => 1,
	'follow-memode' => 1,
	'font' => 1,
	'fontsize' => 1,
	'fontsubfamily' => 1,
	'fontsubfamilyid' => 1,
	'fonttable' => 1,
	'fontweight' => 1,
	'footerposition' => 1,
	'footnotes' => 1,
	'form' => 1,
	'formattag' => 1,
	'formatter' => 1,
	'formatversion' => 1,
	'formatversiontime' => 1,
	'formextrausagerights' => 1,
	'formfields' => 1,
	'formusagerights' => 1,
	'forwardto' => 1,
	'fotostation' => 1,
	'fourcc' => 1,
	'fourcc1' => 1,
	'fourcc2' => 1,
	'fourcc2len' => 1,
	'fourcc3' => 1,
	'fourcc3len' => 1,
	'fourthlanguage' => 1,
	'fov' => 1,
	'fovcot' => 1,
	'fpfversion' => 1,
	'fpv' => 1,
	'fpxr' => 1,
	'fractalparameters' => 1,
	'fragmentlist' => 1,
	'fragmenttable' => 1,
	'frame' => 1,
	'framebaseview' => 1,
	'frameexposuretime' => 1,
	'frameid' => 1,
	'frameinfo' => 1,
	'framepriority' => 1,
	'framesize' => 1,
	'framesizemax' => 1,
	'framesizemin' => 1,
	'framespersecond' => 1,
	'frameview' => 1,
	'framinggriddisplay' => 1,
	'free' => 1,
	'free-busystatus' => 1,
	'freebytecounts' => 1,
	'freeoffsets' => 1,
	'frequency' => 1,
	'fromaddresses' => 1,
	'fromnames' => 1,
	'fstype' => 1,
	'fujifilm' => 1,
	'fujifilmffmv' => 1,
	'fujifilmmvtg' => 1,
	'fujifilmtags' => 1,
	'fujiifd' => 1,
	'fujilayout' => 1,
	'fullname' => 1,
	'fullscreen' => 1,
	'fusion360fly' => 1,
	'fusionmode' => 1,
	'fusionypr' => 1,
	'gain' => 1,
	'gaindeaddata' => 1,
	'gaindeadmapimage' => 1,
	'gaindeadmapimageheight' => 1,
	'gaindeadmapimagetype' => 1,
	'gaindeadmapimagewidth' => 1,
	'gammablue' => 1,
	'gammagreen' => 1,
	'gammainfo' => 1,
	'gammared' => 1,
	'gammatable' => 1,
	'gamut' => 1,
	'gamutboundarydescription0' => 1,
	'gamutboundarydescription1' => 1,
	'gamutboundarydescription2' => 1,
	'gamutboundarydescription3' => 1,
	'gapless' => 1,
	'gaudio' => 1,
	'gaussianweights' => 1,
	'gcamera' => 1,
	'gcreations' => 1,
	'gdepth' => 1,
	'geminfo' => 1,
	'genbalance' => 1,
	'gender' => 1,
	'generallevelidc' => 1,
	'generalprofileidc' => 1,
	'generalprofilespace' => 1,
	'generaltierflag' => 1,
	'generator' => 1,
	'generatorversion' => 1,
	'genflags' => 1,
	'gengraphicsmode' => 1,
	'genmediaheader' => 1,
	'genmediainfo' => 1,
	'genmediaversion' => 1,
	'genopcolor' => 1,
	'genprofilecompatibilityflags' => 1,
	'genr' => 1,
	'geo' => 1,
	'geogangularunits' => 1,
	'geogangularunitsize' => 1,
	'geogazimuthunits' => 1,
	'geogcitation' => 1,
	'geogellipsoid' => 1,
	'geoggeodeticdatum' => 1,
	'geoginvflattening' => 1,
	'geoglinearunits' => 1,
	'geoglinearunitsize' => 1,
	'geogprimemeridian' => 1,
	'geogprimemeridianlong' => 1,
	'geographictype' => 1,
	'geogsemimajoraxis' => 1,
	'geogsemiminoraxis' => 1,
	'geogtowgs84' => 1,
	'geometricdistortionparams' => 1,
	'geotiffversion' => 1,
	'getty' => 1,
	'gfocus' => 1,
	'gidcver' => 1,
	'gidpver' => 1,
	'gifapplicationextension' => 1,
	'gifgraphiccontrolextension' => 1,
	'gifplaintextextension' => 1,
	'gifversion' => 1,
	'gimage' => 1,
	'gimbalpitch' => 1,
	'gimbalroll' => 1,
	'gimbalyaw' => 1,
	'gipc_cpld' => 1,
	'gipcver' => 1,
	'givenname' => 1,
	'gixiver' => 1,
	'globalinfo' => 1,
	'globalparametersifd' => 1,
	'globalpixelsize' => 1,
	'googlebot' => 1,
	'gopro' => 1,
	'goprogpmf' => 1,
	'gpano' => 1,
	'gpmd_fmas' => 1,
	'gpmd_gopro' => 1,
	'gpmd_kingslim' => 1,
	'gpmd_rove' => 1,
	'gps' => 1,
	'gps360fly' => 1,
	'gpsaltituderaw' => 1,
	'gpsdatalist' => 1,
	'gpsdatalist2' => 1,
	'gpsdatetimeraw' => 1,
	'gpsdestaltitude' => 1,
	'gpsframingaltitude' => 1,
	'gpsframinglatitude' => 1,
	'gpsframinglongitude' => 1,
	'gpshorizontalaccuracy' => 1,
	'gpsinfo' => 1,
	'gpslatituderaw' => 1,
	'gpslog' => 1,
	'gpslongituderaw' => 1,
	'gpsmode' => 1,
	'gpspos' => 1,
	'gpsraw' => 1,
	'gpsspeed3d' => 1,
	'gpsspeedaccuracy' => 1,
	'gpsspeedraw' => 1,
	'gpsspeedx' => 1,
	'gpsspeedy' => 1,
	'gpsspeedz' => 1,
	'gpstargetaltitude' => 1,
	'gpstargetlatitude' => 1,
	'gpstargetlongitude' => 1,
	'gpstrackraw' => 1,
	'gpsvalid' => 1,
	'gpsvelocitydown' => 1,
	'gpsvelocityeast' => 1,
	'gpsvelocitynorth' => 1,
	'gpsvelocityup' => 1,
	'gpsverticalaccuracy' => 1,
	'grainybwfilter' => 1,
	'graphicconverter' => 1,
	'graphicsmode' => 1,
	'graphicstechnologystandardoutput' => 1,
	'grayresponsecurve' => 1,
	'graytrc' => 1,
	'greenadjust' => 1,
	'greenendpoint' => 1,
	'greengain' => 1,
	'greenmask' => 1,
	'greenmatrixcolumn' => 1,
	'greenprimary' => 1,
	'greensample' => 1,
	'greentrc' => 1,
	'greenx' => 1,
	'greeny' => 1,
	'gridguidesinfo' => 1,
	'groupareac1' => 1,
	'groupcaption' => 1,
	'groupmutualexclusion' => 1,
	'groups' => 1,
	'gsensor' => 1,
	'gspherical' => 1,
	'gtcitation' => 1,
	'gtmodeltype' => 1,
	'gtrastertype' => 1,
	'gyro360fly' => 1,
	'gyromode' => 1,
	'gyroscope' => 1,
	'gyroypr' => 1,
	'handler' => 1,
	'handlerclass' => 1,
	'handlerdescription' => 1,
	'handlertype' => 1,
	'handlervendorid' => 1,
	'hardpostpadding' => 1,
	'hardprepadding' => 1,
	'hasarbitrarydatastream' => 1,
	'hasattachedimages' => 1,
	'hasattachments' => 1,
	'hasaudio' => 1,
	'hascolormap' => 1,
	'hascuepoints' => 1,
	'hasfiletransferstream' => 1,
	'hasflag' => 1,
	'hasicc' => 1,
	'hasimage' => 1,
	'haskeyframes' => 1,
	'hasmetadata' => 1,
	'hasrealmergeddata' => 1,
	'hasscript' => 1,
	'hasselbladexif' => 1,
	'hasselbladrawimage' => 1,
	'hasvideo' => 1,
	'hasxfa' => 1,
	'hcusage' => 1,
	'hdcontent' => 1,
	'hdmibitdepth' => 1,
	'hdmiexternalrecorder' => 1,
	'hdmioutputhdr' => 1,
	'hdmioutputrange' => 1,
	'hdrinfo' => 1,
	'hdrl' => 1,
	'hdrtoninginfo' => 1,
	'header' => 1,
	'header4' => 1,
	'headerext' => 1,
	'headerextension' => 1,
	'headersize' => 1,
	'headerversion' => 1,
	'headingpairs' => 1,
	'heightresolution' => 1,
	'hevcconfiguration' => 1,
	'hevcconfigurationversion' => 1,
	'hiddenslides' => 1,
	'highbitdepth' => 1,
	'highisomode' => 1,
	'highlightdata' => 1,
	'highlightendpoints' => 1,
	'highnote' => 1,
	'highvelocity' => 1,
	'hintformat' => 1,
	'hintheader' => 1,
	'hintinfo' => 1,
	'hintsampledesc' => 1,
	'hinttrackinfo' => 1,
	'hinttrackversion' => 1,
	'histogram' => 1,
	'historybuffersize' => 1,
	'hmaphandling' => 1,
	'hmcolrejthresh' => 1,
	'hmcolthresh' => 1,
	'hmpixthresh' => 1,
	'hmwsize' => 1,
	'hobbies' => 1,
	'homeaddress' => 1,
	'homecity' => 1,
	'homecountry-region' => 1,
	'homefax' => 1,
	'homephone' => 1,
	'homepobox' => 1,
	'homepostalcode' => 1,
	'homestateorprovince' => 1,
	'homestreet' => 1,
	'horizontalresolution' => 1,
	'horizontalscale' => 1,
	'hostsoftwareexportversion' => 1,
	'hotkey' => 1,
	'howpublished' => 1,
	'hp_tdhd' => 1,
	'hrnoiselines' => 1,
	'htcbinary' => 1,
	'htcinfo' => 1,
	'htctrack' => 1,
	'http-equiv' => 1,
	'httphostheader' => 1,
	'huawei' => 1,
	'huffmantable' => 1,
	'huffmantablelength' => 1,
	'huffmantablevalue' => 1,
	'hyperfocaldistance' => 1,
	'hyperlinkbase' => 1,
	'hyperlinks' => 1,
	'hyperlinkschanged' => 1,
	'iad1' => 1,
	'icc_untagged' => 1,
	'iccbased' => 1,
	'iconenvdata' => 1,
	'iconfilename' => 1,
	'iconindex' => 1,
	'ics' => 1,
	'id' => 1,
	'id3' => 1,
	'id3size' => 1,
	'id3v1' => 1,
	'id3v1_enh' => 1,
	'id3v2_2' => 1,
	'id3v2_3' => 1,
	'id3v2_4' => 1,
	'idc2_ifd' => 1,
	'idc_ifd' => 1,
	'idcpreviewimage' => 1,
	'idependentanddisposablesamples' => 1,
	'idlesequence' => 1,
	'idletiming' => 1,
	'idsbasevalue' => 1,
	'ifd0' => 1,
	'ifd0_offset' => 1,
	'ihl_exif' => 1,
	'ihldata' => 1,
	'illuminantdetectordata' => 1,
	'illuminantdetecttable' => 1,
	'illustrator' => 1,
	'im' => 1,
	'imaddresses' => 1,
	'image' => 1,
	'image2description' => 1,
	'image3description' => 1,
	'image4description' => 1,
	'image5description' => 1,
	'image6description' => 1,
	'image7description' => 1,
	'image8description' => 1,
	'imagearrangement' => 1,
	'imageboardid' => 1,
	'imagebounds' => 1,
	'imagebytecount' => 1,
	'imageclass' => 1,
	'imagecolor' => 1,
	'imagecolorindicator' => 1,
	'imagecolorvalue' => 1,
	'imagecompressiontable' => 1,
	'imagedatadiscard' => 1,
	'imagedataoffset' => 1,
	'imagedepth' => 1,
	'imageelements' => 1,
	'imageexpansiontable' => 1,
	'imagefields' => 1,
	'imagefilecharacteristics' => 1,
	'imagefilename' => 1,
	'imageformat' => 1,
	'imagefullheight' => 1,
	'imagefullwidth' => 1,
	'imageheader' => 1,
	'imageid' => 1,
	'imageinfo' => 1,
	'imagelayer' => 1,
	'imagelength' => 1,
	'imagelimitexposurebias' => 1,
	'imagemagnificationdescriptor' => 1,
	'imagemedium' => 1,
	'imagemodulationexposurebias' => 1,
	'imageoffset' => 1,
	'imagepixeldepth' => 1,
	'imagepixelformat' => 1,
	'imageprintstatus' => 1,
	'imageprocessingifd' => 1,
	'imageprofile' => 1,
	'imageprops' => 1,
	'imagerboardid' => 1,
	'imagereadydatasets' => 1,
	'imagereadyvariables' => 1,
	'imagereferencepoints' => 1,
	'imageresources' => 1,
	'imagerinitialtimingcode' => 1,
	'imagerlogicprogram' => 1,
	'imagerotation' => 1,
	'imagerotationstatus' => 1,
	'imagertimingdata' => 1,
	'imagesensorgain' => 1,
	'imagesourceek' => 1,
	'imagespatialextent' => 1,
	'imagestatus' => 1,
	'imagetoolbar' => 1,
	'imageuidlist' => 1,
	'imageversion' => 1,
	'imageworkstationmake' => 1,
	'imgprofbacktype' => 1,
	'imgprofname' => 1,
	'imgproftype' => 1,
	'imgprofversion' => 1,
	'immediatedatabytes' => 1,
	'importance' => 1,
	'imprint' => 1,
	'inbandratingattributes' => 1,
	'inbandratinglevel' => 1,
	'inbandratingsystem' => 1,
	'includedfileid' => 1,
	'incomplete' => 1,
	'index' => 1,
	'index01' => 1,
	'index02' => 1,
	'index03' => 1,
	'index04' => 1,
	'index05' => 1,
	'index06' => 1,
	'index07' => 1,
	'index08' => 1,
	'index09' => 1,
	'index10' => 1,
	'index11' => 1,
	'index12' => 1,
	'index13' => 1,
	'index14' => 1,
	'index15' => 1,
	'index16' => 1,
	'indexable' => 1,
	'indexed' => 1,
	'indexedcolortablecount' => 1,
	'indexoffset' => 1,
	'indexparameters' => 1,
	'indications' => 1,
	'info' => 1,
	'ingrreserved' => 1,
	'initialdelaysamples' => 1,
	'initialdisplayeffect' => 1,
	'initializationvector' => 1,
	'initializeddatasize' => 1,
	'initialobjectdescriptor' => 1,
	'initials' => 1,
	'inknames' => 1,
	'inputdataobjectlist' => 1,
	'inputdevicename' => 1,
	'inputdeviceserialnumber' => 1,
	'inputheight' => 1,
	'inputorientation' => 1,
	'inputuniformity' => 1,
	'inputwidth' => 1,
	'insertmode' => 1,
	'insetnwpixelx' => 1,
	'insetnwpixely' => 1,
	'insta360' => 1,
	'institution' => 1,
	'instructionset' => 1,
	'insv' => 1,
	'integratetiming' => 1,
	'intellectualproperty' => 1,
	'intellectualpropertynotes' => 1,
	'intensitystereo' => 1,
	'intergraphflagregisters' => 1,
	'intergraphpacketdata' => 1,
	'interlace' => 1,
	'interleavedfield' => 1,
	'internalidnumber' => 1,
	'internalleading' => 1,
	'internalname' => 1,
	'internalversionnumber' => 1,
	'internationaltext' => 1,
	'internetradiostationname' => 1,
	'internetradiostationowner' => 1,
	'internetradiostationurl' => 1,
	'interopoffset' => 1,
	'interpolationcoefficients' => 1,
	'interpolationcoefficients3mp' => 1,
	'interpolationcoefficients6mp' => 1,
	'interpretedby' => 1,
	'inversemonitormatrix' => 1,
	'inverserimnonlinearity' => 1,
	'inversesbalog12transform' => 1,
	'inversesbalogtransform' => 1,
	'invnifnonlinearity' => 1,
	'involvedpeople' => 1,
	'ipmpcontrol' => 1,
	'iptc_profile' => 1,
	'iptcapplication' => 1,
	'iptccore' => 1,
	'iptcdata' => 1,
	'iptcenvelope' => 1,
	'iptcext' => 1,
	'iptcfotostation' => 1,
	'iptcnewsphoto' => 1,
	'iptcobjectdata' => 1,
	'iptcpostobjectdata' => 1,
	'iptcpreobjectdata' => 1,
	'irwindowtemperature' => 1,
	'irwindowtransmission' => 1,
	'is_protected' => 1,
	'is_trusted' => 1,
	'isartbokeh' => 1,
	'isattachment' => 1,
	'isbasefont' => 1,
	'iscompleted' => 1,
	'isdeleted' => 1,
	'isfixedpitch' => 1,
	'isfixedv' => 1,
	'isinfoa100' => 1,
	'isnetworkfeed' => 1,
	'isocalibrationgaintable' => 1,
	'isoinfo' => 1,
	'isonline' => 1,
	'isospeeds' => 1,
	'isotherm1color' => 1,
	'isotherm2color' => 1,
	'isprotected' => 1,
	'isrc' => 1,
	'isrcnumber' => 1,
	'isrecurring' => 1,
	'isvbr' => 1,
	'it8header' => 1,
	'italic' => 1,
	'italicangle' => 1,
	'itch' => 1,
	'item' => 1,
	'item0032' => 1,
	'itemid' => 1,
	'iteminfoentry' => 1,
	'iteminformation' => 1,
	'itemlist' => 1,
	'itemlocation' => 1,
	'itemproperties' => 1,
	'itempropertyassociation' => 1,
	'itempropertycontainer' => 1,
	'itemprotection' => 1,
	'itemreference' => 1,
	'itemtool' => 1,
	'itemvendorid' => 1,
	'iterationcount' => 1,
	'iterationendaction' => 1,
	'iterationmax' => 1,
	'iterationminmax' => 1,
	'iterations' => 1,
	'itunesinfo' => 1,
	'itunesmediatype' => 1,
	'itunmovi' => 1,
	'itunsmpb' => 1,
	'ituntool' => 1,
	'ixml' => 1,
	'jbigoptions' => 1,
	'jfif' => 1,
	'jfifversion' => 1,
	'jfxx' => 1,
	'jngheader' => 1,
	'jobtitle' => 1,
	'journal' => 1,
	'jp2header' => 1,
	'jp2signature' => 1,
	'jpeg-hdr' => 1,
	'jpeg-hdrversion' => 1,
	'jpeg-likedata' => 1,
	'jpeg_quality' => 1,
	'jpegactables' => 1,
	'jpegdctables' => 1,
	'jpegdigest' => 1,
	'jpegexifdata' => 1,
	'jpegimagelength' => 1,
	'jpeginfo' => 1,
	'jpeglosslesspredictors' => 1,
	'jpegpointtransforms' => 1,
	'jpegproc' => 1,
	'jpegprocess' => 1,
	'jpegqtablebest' => 1,
	'jpegqtablebetter' => 1,
	'jpegqtablegood' => 1,
	'jpegqtables' => 1,
	'jpegqualityestimate' => 1,
	'jpegrestartinterval' => 1,
	'jpegtables' => 1,
	'jplcartoifd' => 1,
	'jps' => 1,
	'jpscomment' => 1,
	'jpsflags' => 1,
	'jpslayout' => 1,
	'jpsseparation' => 1,
	'jpstype' => 1,
	'jsondata' => 1,
	'jsonmetadata' => 1,
	'jumbf' => 1,
	'jumbfbox' => 1,
	'jumbfdescr' => 1,
	'jumdid' => 1,
	'jumdlabel' => 1,
	'jumdsignature' => 1,
	'jumdtoggles' => 1,
	'jumdtype' => 1,
	'jumptoxpep' => 1,
	'junk' => 1,
	'jxlcodestream' => 1,
	'k1' => 1,
	'k2' => 1,
	'k3' => 1,
	'k4' => 1,
	'kbytesize' => 1,
	'kdc_ifd' => 1,
	'keepexposurewithteleconverter' => 1,
	'keepuntil' => 1,
	'kelvinwb' => 1,
	'keycode' => 1,
	'keyframepositions' => 1,
	'keyframestimes' => 1,
	'keyid' => 1,
	'keys' => 1,
	'kf' => 1,
	'kf8coveruri' => 1,
	'khufui0thresholds' => 1,
	'khufui1thresholds' => 1,
	'khufui2thresholds' => 1,
	'khufui3thresholds' => 1,
	'khufui4thresholds' => 1,
	'khufui5thresholds' => 1,
	'khufulinearbluemixingcoefficient' => 1,
	'khufulineargreenmixingcoefficient' => 1,
	'khufulinearredmixingcoefficient' => 1,
	'khufusigmagaussianweights' => 1,
	'khufusigmascalingfactors14mp' => 1,
	'khufusigmascalingfactors3mp' => 1,
	'khufusigmascalingfactors6mp' => 1,
	'khufuuspacec2mixingcoefficient' => 1,
	'kids' => 1,
	'kilocalories' => 1,
	'kinds' => 1,
	'kj' => 1,
	'kk' => 1,
	'klut' => 1,
	'klut12tolin12' => 1,
	'knownfolderdata' => 1,
	'kodak' => 1,
	'kodak_frea' => 1,
	'kodakbordersifd' => 1,
	'kodakdcmd' => 1,
	'kodakeffectsifd' => 1,
	'kodakfree' => 1,
	'kodakifd' => 1,
	'kodakmake' => 1,
	'kodaktags' => 1,
	'konicaminolta' => 1,
	'konicaminoltatags' => 1,
	'label0' => 1,
	'label1' => 1,
	'label2' => 1,
	'label3' => 1,
	'labeledtext' => 1,
	'lamebitrate' => 1,
	'lameheader' => 1,
	'lamelowpassfilter' => 1,
	'lamemethod' => 1,
	'lamequality' => 1,
	'lamestereomode' => 1,
	'lamevbrquality' => 1,
	'languagecode' => 1,
	'languagelist' => 1,
	'largestpacketduration' => 1,
	'largestpacketsize' => 1,
	'lastauthor' => 1,
	'lastbackupdate' => 1,
	'lastchar' => 1,
	'lastkeyframetime' => 1,
	'lastmodifiedby' => 1,
	'lastmodifier' => 1,
	'lastname' => 1,
	'lastobject' => 1,
	'lastobjectid' => 1,
	'lastprinted' => 1,
	'lastsavedby' => 1,
	'lasttimestamp' => 1,
	'lastupdate' => 1,
	'lastupdatetime' => 1,
	'layerblendmodes' => 1,
	'layercomps' => 1,
	'layercount' => 1,
	'layergroupsenabledid' => 1,
	'layerids' => 1,
	'layermodifydates' => 1,
	'layernames' => 1,
	'layeropacities' => 1,
	'layerrectangles' => 1,
	'layers' => 1,
	'layerselectionids' => 1,
	'layersgroupinfo' => 1,
	'layerunicodenames' => 1,
	'layout' => 1,
	'layoutflags' => 1,
	'lcdedgemapslope' => 1,
	'lcdedgemapx1' => 1,
	'lcdedgemapx2' => 1,
	'lcdedgemapx3' => 1,
	'lcdedgemapx4' => 1,
	'lcdedgespline' => 1,
	'lcdgammatable' => 1,
	'lcdgammatablechickfix' => 1,
	'lcdgammatablemarvin' => 1,
	'lcdhistlut0' => 1,
	'lcdhistlut1' => 1,
	'lcdhistlut2' => 1,
	'lcdhistlut3' => 1,
	'lcdhistlut4' => 1,
	'lcdhistlut5' => 1,
	'lcdhistlut6' => 1,
	'lcdhistlut7' => 1,
	'lcdhistlut8' => 1,
	'lcdhistlut9' => 1,
	'lcdlinearclipvalue' => 1,
	'lcdsharpeningf1' => 1,
	'lcdsharpeningf2' => 1,
	'lcdsharpeningf3' => 1,
	'lcdsharpeningf4' => 1,
	'lcdstepyvalues' => 1,
	'lcdstepyvalueschickfix' => 1,
	'lcdstepyvaluesmarvin' => 1,
	'leadperformer' => 1,
	'leafautoactive' => 1,
	'leafautobasename' => 1,
	'leafdata' => 1,
	'leafhotfolder' => 1,
	'leafopenprochdr' => 1,
	'leafoutputfiletype' => 1,
	'leafsaveselection' => 1,
	'leafsubifd' => 1,
	'leftdarkcol1' => 1,
	'leftdarkcol2' => 1,
	'leftdarkrect' => 1,
	'leftmag' => 1,
	'leftmargin' => 1,
	'legalcopyright' => 1,
	'legaltrademarks' => 1,
	'leicaleic' => 1,
	'length' => 1,
	'lens35efl' => 1,
	'lensattached' => 1,
	'lenscorr' => 1,
	'lensdata' => 1,
	'lensdata0100' => 1,
	'lensdata0101' => 1,
	'lensdata0201' => 1,
	'lensdata0204' => 1,
	'lensdata0400' => 1,
	'lensdata0402' => 1,
	'lensdata0403' => 1,
	'lensdata0800' => 1,
	'lensdataunknown' => 1,
	'lensdataversion' => 1,
	'lensfacing' => 1,
	'lensinfoq' => 1,
	'lensmaker' => 1,
	'lensnumber' => 1,
	'lenspartnumber' => 1,
	'lensrec' => 1,
	'lensshading' => 1,
	'lenstableindex' => 1,
	'levelinfo' => 1,
	'libraryid' => 1,
	'libraryname' => 1,
	'licenseinfourl' => 1,
	'lightingopt' => 1,
	'lightness' => 1,
	'lightroomworkflow' => 1,
	'lights' => 1,
	'lightvalue' => 1,
	'limage' => 1,
	'limitaf-areamodeselautoanimals' => 1,
	'limitaf-areamodeselautopeople' => 1,
	'limitaf-areamodeseldynamic' => 1,
	'limitaf-areamodeselwidelanimals' => 1,
	'limitaf-areamodeselwidelpeople' => 1,
	'limitafareamodesel3d' => 1,
	'limitafareamodeseld105' => 1,
	'limitafareamodeseld25' => 1,
	'limitafareamodeseld49' => 1,
	'limitafareamodeseld9' => 1,
	'limitafareamodeselgroup' => 1,
	'limitafareamodeselgroupc1' => 1,
	'limitafareamodeselgroupc2' => 1,
	'limitreleasemodeselmirror-up' => 1,
	'limitreleasemodeselq' => 1,
	'limitreleasemodeseltimer' => 1,
	'limitselectableimagearea5to4' => 1,
	'lin12toklut12' => 1,
	'lin12toklut8' => 1,
	'linearitysplinetags' => 1,
	'linearizationcoefficients1' => 1,
	'linearizationcoefficients2' => 1,
	'linearized' => 1,
	'linecount' => 1,
	'lineorder' => 1,
	'lines' => 1,
	'linkedprofilename' => 1,
	'linkerversion' => 1,
	'linkgoodput' => 1,
	'linkinfo' => 1,
	'linkquality' => 1,
	'linkstatus' => 1,
	'linksuptodate' => 1,
	'linktarget' => 1,
	'linlogtable' => 1,
	'listtype' => 1,
	'lit' => 1,
	'livephotoinfo' => 1,
	'ln0' => 1,
	'ln1' => 1,
	'localbasepath' => 1,
	'localdeltatype' => 1,
	'localeindicator' => 1,
	'localpositionned' => 1,
	'locationinfo' => 1,
	'lockedpropertylist' => 1,
	'locks' => 1,
	'loginfo' => 1,
	'loglintable' => 1,
	'logoiconurl' => 1,
	'logourl' => 1,
	'lookheadbacktype' => 1,
	'lookheader' => 1,
	'lookheadname' => 1,
	'lookheadtype' => 1,
	'lookheadversion' => 1,
	'lookmat0' => 1,
	'lookmat1' => 1,
	'lookmat2' => 1,
	'lookmat3' => 1,
	'lookmat4' => 1,
	'lookmat5' => 1,
	'lookmat6' => 1,
	'lookmat7' => 1,
	'lookmat8' => 1,
	'lookmat9' => 1,
	'lookmodtransform' => 1,
	'lookuptable' => 1,
	'lotus' => 1,
	'lowlightaf' => 1,
	'lownote' => 1,
	'lowvelocity' => 1,
	'lr' => 1,
	'lslv' => 1,
	'lucasjunk' => 1,
	'luminance' => 1,
	'luminanceconsts' => 1,
	'lyricist' => 1,
	'lyrics_synchronised' => 1,
	'machineid' => 1,
	'machinetype' => 1,
	'macintoshnsprintinfo' => 1,
	'macintoshprintinfo' => 1,
	'mag360fly' => 1,
	'magmode' => 1,
	'magneticfield' => 1,
	'magnetometer' => 1,
	'magnetometerxyz' => 1,
	'magnification' => 1,
	'magnifyobject' => 1,
	'mailingaddress' => 1,
	'mailstop' => 1,
	'mainboard' => 1,
	'maininfo' => 1,
	'maininfoifd' => 1,
	'majorbrand' => 1,
	'makeandmodel' => 1,
	'makemodel' => 1,
	'makernotepentax5a' => 1,
	'makernotepentax5b' => 1,
	'makernotepentax5c' => 1,
	'makernotes' => 1,
	'mandatorybackground' => 1,
	'manufacturecode' => 1,
	'manufactureindex' => 1,
	'manufacturername' => 1,
	'mappingscheme' => 1,
	'mapscale' => 1,
	'mariahthresholds' => 1,
	'mariahthresholdslow' => 1,
	'mariahthresholdsnormal' => 1,
	'mariahthresholdsstrong' => 1,
	'markbits' => 1,
	'marker' => 1,
	'markerid' => 1,
	'markinfo' => 1,
	'marl' => 1,
	'masksubarea' => 1,
	'mastergainadjustment' => 1,
	'matrixworldtocamera' => 1,
	'matrixworldtoscreen' => 1,
	'mattcolor' => 1,
	'matte' => 1,
	'matteing' => 1,
	'matter' => 1,
	'maxband' => 1,
	'maxbitrate' => 1,
	'maxdatarate' => 1,
	'maximumbitrate' => 1,
	'maximumimageindex' => 1,
	'maximumobjectsize' => 1,
	'maximumoperationindex' => 1,
	'maximumshutterangle' => 1,
	'maximumtransformindex' => 1,
	'maxjpegtableindex' => 1,
	'maxpacketsize' => 1,
	'maxpagenormal' => 1,
	'maxpdusize' => 1,
	'maxsubfilesize' => 1,
	'maxtransmissiontime' => 1,
	'maxval' => 1,
	'maxwidth' => 1,
	'mc' => 1,
	'mccdata' => 1,
	'mcdi' => 1,
	'md5signature' => 1,
	'md5sum' => 1,
	'mdcolortable' => 1,
	'mdfiletag' => 1,
	'mdfileunits' => 1,
	'mditemaccounthandles' => 1,
	'mditemaccountidentifier' => 1,
	'mditemacquisitionmake' => 1,
	'mditemacquisitionmodel' => 1,
	'mditemaltitude' => 1,
	'mditemaperture' => 1,
	'mditemaudiobitrate' => 1,
	'mditemaudiochannelcount' => 1,
	'mditemauthoremailaddresses' => 1,
	'mditemauthors' => 1,
	'mditembitspersample' => 1,
	'mditembundleidentifier' => 1,
	'mditemcity' => 1,
	'mditemcodecs' => 1,
	'mditemcolorspace' => 1,
	'mditemcomment' => 1,
	'mditemcontentcreationdate' => 1,
	'mditemcontentcreationdate_ranking' => 1,
	'mditemcontentcreationdateranking' => 1,
	'mditemcontentmodificationdate' => 1,
	'mditemcontenttype' => 1,
	'mditemcontenttypetree' => 1,
	'mditemcontributors' => 1,
	'mditemcopyright' => 1,
	'mditemcountry' => 1,
	'mditemcreator' => 1,
	'mditemdateadded' => 1,
	'mditemdateadded_ranking' => 1,
	'mditemdescription' => 1,
	'mditemdisplayname' => 1,
	'mditemdownloadeddate' => 1,
	'mditemdurationseconds' => 1,
	'mditememailconversationid' => 1,
	'mditemencodingapplications' => 1,
	'mditemexifgpsversion' => 1,
	'mditemexifversion' => 1,
	'mditemexposuremode' => 1,
	'mditemexposureprogram' => 1,
	'mditemexposuretimeseconds' => 1,
	'mditemflashonoff' => 1,
	'mditemfnumber' => 1,
	'mditemfocallength' => 1,
	'mditemfscontentchangedate' => 1,
	'mditemfscreatorcode' => 1,
	'mditemfsfinderflags' => 1,
	'mditemfshascustomicon' => 1,
	'mditemfsinvisible' => 1,
	'mditemfsisextensionhidden' => 1,
	'mditemfsisstationery' => 1,
	'mditemfsname' => 1,
	'mditemfsnodecount' => 1,
	'mditemfsownergroupid' => 1,
	'mditemfsowneruserid' => 1,
	'mditemfssize' => 1,
	'mditemfstypecode' => 1,
	'mditemgpsdatestamp' => 1,
	'mditemgpsstatus' => 1,
	'mditemgpstrack' => 1,
	'mditemhasalphachannel' => 1,
	'mditemidentifier' => 1,
	'mditemimagedirection' => 1,
	'mditeminterestingdate_ranking' => 1,
	'mditeminterestingdateranking' => 1,
	'mditemisapplicationmanaged' => 1,
	'mditemisexistingthread' => 1,
	'mditemislikelyjunk' => 1,
	'mditemisospeed' => 1,
	'mditemkeywords' => 1,
	'mditemkind' => 1,
	'mditemlastuseddate' => 1,
	'mditemlastuseddate_ranking' => 1,
	'mditemlatitude' => 1,
	'mditemlensmodel' => 1,
	'mditemlogicalsize' => 1,
	'mditemlongitude' => 1,
	'mditemmailboxes' => 1,
	'mditemmaildatereceived_ranking' => 1,
	'mditemmediatypes' => 1,
	'mditemnumberofpages' => 1,
	'mditemorientation' => 1,
	'mditemoriginapplicationidentifier' => 1,
	'mditemoriginmessageid' => 1,
	'mditemoriginsenderdisplayname' => 1,
	'mditemoriginsenderhandle' => 1,
	'mditemoriginsubject' => 1,
	'mditempageheight' => 1,
	'mditempagewidth' => 1,
	'mditemphysicalsize' => 1,
	'mditempixelcount' => 1,
	'mditempixelheight' => 1,
	'mditempixelwidth' => 1,
	'mditemprimaryrecipientemailaddresses' => 1,
	'mditemprofilename' => 1,
	'mditemrecipients' => 1,
	'mditemredeyeonoff' => 1,
	'mditemresolutionheightdpi' => 1,
	'mditemresolutionwidthdpi' => 1,
	'mditemsecuritymethod' => 1,
	'mditemspeed' => 1,
	'mditemstateorprovince' => 1,
	'mditemstreamable' => 1,
	'mditemsubject' => 1,
	'mditemtimestamp' => 1,
	'mditemtitle' => 1,
	'mditemtotalbitrate' => 1,
	'mditemusecount' => 1,
	'mditemuseddates' => 1,
	'mditemuserdownloadeddate' => 1,
	'mditemuserdownloadeduserhandle' => 1,
	'mditemusersharedreceiveddate' => 1,
	'mditemusersharedreceivedrecipient' => 1,
	'mditemusersharedreceivedrecipienthandle' => 1,
	'mditemusersharedreceivedsender' => 1,
	'mditemusersharedreceivedsenderhandle' => 1,
	'mditemusersharedreceivedtransport' => 1,
	'mditemversion' => 1,
	'mditemvideobitrate' => 1,
	'mditemwherefroms' => 1,
	'mditemwhitebalance' => 1,
	'mdlabname' => 1,
	'mdpm' => 1,
	'mdpr' => 1,
	'mdprepdate' => 1,
	'mdpreptime' => 1,
	'mdsampleinfo' => 1,
	'mdscalepixel' => 1,
	'meas1label' => 1,
	'meas1params' => 1,
	'meas1type' => 1,
	'measuredcolor' => 1,
	'measuredinfo' => 1,
	'measurement' => 1,
	'measurementbacking' => 1,
	'measurementflare' => 1,
	'measurementgeometry' => 1,
	'measurementilluminant' => 1,
	'measurementinfo' => 1,
	'measurementinputinfo' => 1,
	'measurementobserver' => 1,
	'measurementscale' => 1,
	'mebx' => 1,
	'media' => 1,
	'mediablackpoint' => 1,
	'mediacolor' => 1,
	'mediacontenttypes' => 1,
	'mediacreated' => 1,
	'mediacredits' => 1,
	'mediadata' => 1,
	'mediadataoffset' => 1,
	'mediadatasize' => 1,
	'mediaduration' => 1,
	'mediaflags' => 1,
	'mediaheader' => 1,
	'mediaheaderversion' => 1,
	'mediaindex' => 1,
	'mediainfo' => 1,
	'mediaisdelay' => 1,
	'mediaisfinale' => 1,
	'mediaislive' => 1,
	'mediaismovie' => 1,
	'mediaispremiere' => 1,
	'mediaisrepeat' => 1,
	'mediaissap' => 1,
	'mediaissport' => 1,
	'mediaisstereo' => 1,
	'mediaissubtitled' => 1,
	'mediaistape' => 1,
	'mediajukebox' => 1,
	'medialanguagecode' => 1,
	'medianetworkaffiliation' => 1,
	'mediaoriginalbroadcastdatetime' => 1,
	'mediaoriginalchannel' => 1,
	'mediaoriginalchannelsubnumber' => 1,
	'mediaoriginalruntime' => 1,
	'mediapro' => 1,
	'mediastationcallsign' => 1,
	'mediastationname' => 1,
	'mediathumbaspectratiox' => 1,
	'mediathumbaspectratioy' => 1,
	'mediathumbheight' => 1,
	'mediathumbratingattributes' => 1,
	'mediathumbratinglevel' => 1,
	'mediathumbratingsystem' => 1,
	'mediathumbret' => 1,
	'mediathumbstride' => 1,
	'mediathumbtimestamp' => 1,
	'mediathumbwidth' => 1,
	'mediatimescale' => 1,
	'mediatrackbytes' => 1,
	'mediauniqueid' => 1,
	'mediaweight' => 1,
	'mediawhitepoint' => 1,
	'medium' => 1,
	'megapixels' => 1,
	'melodicpolyphony' => 1,
	'menusettingsz7ii' => 1,
	'menusettingsz9' => 1,
	'message' => 1,
	'meta' => 1,
	'metadata' => 1,
	'metadatacreator' => 1,
	'metadataid' => 1,
	'metadatalibrary' => 1,
	'metadatanumber' => 1,
	'metadatasource' => 1,
	'metadataversion' => 1,
	'metaformat' => 1,
	'metaimagesize' => 1,
	'metarelation' => 1,
	'metasampledesc' => 1,
	'metdata' => 1,
	'meterinfo' => 1,
	'meteringbutton' => 1,
	'meterlink' => 1,
	'metermode' => 1,
	'mett' => 1,
	'microsoft' => 1,
	'microsoftxtra' => 1,
	'middlename' => 1,
	'midicontrol' => 1,
	'midicontrolversion' => 1,
	'midipitchfraction' => 1,
	'midisong' => 1,
	'midiunitynote' => 1,
	'mie' => 1,
	'mileage' => 1,
	'mimeencoding' => 1,
	'mimetype' => 1,
	'miniaturefilter' => 1,
	'miniaturefilterorientation' => 1,
	'miniaturefilterparameter' => 1,
	'miniaturefilterposition' => 1,
	'minimumbitrate' => 1,
	'minimumflushrows' => 1,
	'minimumversion' => 1,
	'minoltacamerasettings' => 1,
	'minoltacamerasettings2' => 1,
	'minoltacamerasettings5d' => 1,
	'minoltacamerasettings7d' => 1,
	'minoltacamerasettingsold' => 1,
	'minoltamakernote' => 1,
	'minoltamma0' => 1,
	'minoltamma1' => 1,
	'minoltaprd' => 1,
	'minoltarif' => 1,
	'minoltatags' => 1,
	'minoltattw' => 1,
	'minoltawbg' => 1,
	'minpacketsize' => 1,
	'minspatialsegmentationidc' => 1,
	'mintransmissiontime' => 1,
	'mmclips' => 1,
	'mngheader' => 1,
	'mobitype' => 1,
	'mobiversion' => 1,
	'modeextension' => 1,
	'modeflags' => 1,
	'model2' => 1,
	'modelandversion' => 1,
	'modeltype' => 1,
	'modenumber' => 1,
	'modificationnumber' => 1,
	'modificationpermissions' => 1,
	'modifiedby' => 1,
	'modifiedinfo' => 1,
	'moiversion' => 1,
	'monomonitormatrix' => 1,
	'monostrength' => 1,
	'monotonescaletable' => 1,
	'monouniquematrix' => 1,
	'montage' => 1,
	'month' => 1,
	'moreinfo' => 1,
	'moreinfo0201' => 1,
	'moreinfo0401' => 1,
	'moreinfobannerimage' => 1,
	'moreinfobannerurl' => 1,
	'moreinfotext' => 1,
	'moreinfourl' => 1,
	'moresettings' => 1,
	'mosaicpattern' => 1,
	'movableinfo' => 1,
	'moveobjects' => 1,
	'movie' => 1,
	'moviefragment' => 1,
	'moviefragmentheader' => 1,
	'moviefragmentsequence' => 1,
	'moviefunc2button' => 1,
	'movieheader' => 1,
	'movieheaderversion' => 1,
	'moviehighlightdisplaypattern' => 1,
	'movieinfo' => 1,
	'moviestreamname' => 1,
	'moviewhitebalancesameasphoto' => 1,
	'mp' => 1,
	'mp1' => 1,
	'mpeg7binary' => 1,
	'mpegaudioversion' => 1,
	'mpf' => 1,
	'mpfversion' => 1,
	'mpimage' => 1,
	'mpimageflags' => 1,
	'mpimageformat' => 1,
	'mpimagelength' => 1,
	'mpimagelist' => 1,
	'mpimagestart' => 1,
	'mpimagetype' => 1,
	'mpindividualnum' => 1,
	'mrwinfo' => 1,
	'msdocumenttext' => 1,
	'msdocumenttextposition' => 1,
	'mspropertysetstorage' => 1,
	'msstereo' => 1,
	'mtoa0' => 1,
	'mtob0' => 1,
	'mtob1' => 1,
	'mtob2' => 1,
	'mtob3' => 1,
	'mtos0' => 1,
	'mtos1' => 1,
	'mtos2' => 1,
	'mtos3' => 1,
	'multiexp' => 1,
	'multiexposureversion' => 1,
	'multimediatype' => 1,
	'multiplexdefaultvalues' => 1,
	'multiplextypearray' => 1,
	'multiprofiles' => 1,
	'multiquality' => 1,
	'multishoton' => 1,
	'multiview' => 1,
	'musicby' => 1,
	'musiccdidentifier' => 1,
	'musiciancredits' => 1,
	'mwg-coll' => 1,
	'mwg-kw' => 1,
	'mwg-rs' => 1,
	'mxfversion' => 1,
	'mycolors' => 1,
	'namedcolor' => 1,
	'namedcolor2' => 1,
	'nametableversion' => 1,
	'nameutf-8' => 1,
	'nativedisplayinfo' => 1,
	'nativeresolutionunit' => 1,
	'nativexresolution' => 1,
	'nativeyresolution' => 1,
	'ncc' => 1,
	'nemoblurkernel' => 1,
	'nemodarklimit' => 1,
	'nemogainfactors' => 1,
	'nemohighlight12limit' => 1,
	'nemotilesize' => 1,
	'nestedsignalstream' => 1,
	'nestlevel' => 1,
	'netexposurecompensation' => 1,
	'netname' => 1,
	'netprovidertype' => 1,
	'neutals' => 1,
	'neutobjbacktype' => 1,
	'neutobjname' => 1,
	'neutobjtype' => 1,
	'neutobjversion' => 1,
	'neutrals' => 1,
	'newbitdepth' => 1,
	'newcolortype' => 1,
	'newguid' => 1,
	'newlines' => 1,
	'nexttrackid' => 1,
	'nifnonlinearity' => 1,
	'nifnonlinearity12bit' => 1,
	'nifnonlinearity12to16' => 1,
	'nifnonlinearity16bit' => 1,
	'nifnonlinearityext' => 1,
	'nikon' => 1,
	'nikonapp' => 1,
	'nikondata' => 1,
	'nikondatetime' => 1,
	'nikonncdb' => 1,
	'nikonncdt' => 1,
	'nikonnefinfo' => 1,
	'nikonscanifd' => 1,
	'nikontags' => 1,
	'nikonvers' => 1,
	'nine' => 1,
	'nineedits' => 1,
	'ninthlanguage' => 1,
	'nitf' => 1,
	'nitfversion' => 1,
	'noise' => 1,
	'noisereductiondata' => 1,
	'noisereductionkernel' => 1,
	'noisereductionparametershostlow' => 1,
	'noisereductionparametershostnormal' => 1,
	'noisereductionparametershoststrong' => 1,
	'nominalbitrate' => 1,
	'nominalframecount' => 1,
	'nominallayercount' => 1,
	'nominalplaytime' => 1,
	'nominalvideobitrate' => 1,
	'nomssmarttags' => 1,
	'normallinetransfertiming' => 1,
	'note' => 1,
	'notice' => 1,
	'now' => 1,
	'npts' => 1,
	'nrwdata' => 1,
	'nsc_address' => 1,
	'nsc_description' => 1,
	'nsc_email' => 1,
	'nsc_name' => 1,
	'nsc_phone' => 1,
	'nullmediaheader' => 1,
	'numberlist' => 1,
	'numberofcomponents' => 1,
	'numberofframes' => 1,
	'numberofimages' => 1,
	'numberofinks' => 1,
	'numberofparts' => 1,
	'numberofplanes' => 1,
	'numberofresolutions' => 1,
	'numberofsamples' => 1,
	'numberofsamples64' => 1,
	'numchanneldescriptions' => 1,
	'numchannels' => 1,
	'numcolors' => 1,
	'numfonts' => 1,
	'numhistorybuffers' => 1,
	'numimportantcolors' => 1,
	'numpackets' => 1,
	'numproperties' => 1,
	'numrules' => 1,
	'numsampleframes' => 1,
	'numsampleloops' => 1,
	'numslices' => 1,
	'numstreams' => 1,
	'numtemporallayers' => 1,
	'objectfiletype' => 1,
	'objectflags' => 1,
	'objectid' => 1,
	'objectorientation' => 1,
	'objectsizeannounced' => 1,
	'observationdate' => 1,
	'observationdateend' => 1,
	'observationtime' => 1,
	'observationtimeend' => 1,
	'observer' => 1,
	'obsoletephotoshoptag1' => 1,
	'obsoletephotoshoptag2' => 1,
	'obsoletephotoshoptag3' => 1,
	'ocad' => 1,
	'ocadrevision' => 1,
	'oceapplicationselector' => 1,
	'oceidnumber' => 1,
	'oceimagelogic' => 1,
	'ocescanjobdesc' => 1,
	'office' => 1,
	'officelocation' => 1,
	'offlineavailability' => 1,
	'offlinestatus' => 1,
	'offsetmaphorizontal' => 1,
	'offsetmapvertical' => 1,
	'offsetorigin' => 1,
	'offsetx' => 1,
	'offsetxy' => 1,
	'offsety' => 1,
	'oldxmp' => 1,
	'olym' => 1,
	'olympus' => 1,
	'olympus2100' => 1,
	'olympus2100ifd' => 1,
	'olympus2200' => 1,
	'olympus2200ifd' => 1,
	'olympus2300' => 1,
	'olympus2300ifd' => 1,
	'olympus2400' => 1,
	'olympus2400ifd' => 1,
	'olympus2500' => 1,
	'olympus2500ifd' => 1,
	'olympus2600' => 1,
	'olympus2600ifd' => 1,
	'olympus2700' => 1,
	'olympus2700ifd' => 1,
	'olympus2800' => 1,
	'olympus2800ifd' => 1,
	'olympus2900' => 1,
	'olympus2900ifd' => 1,
	'olympusatom' => 1,
	'olympusdss' => 1,
	'olympusjunk' => 1,
	'olympusolym' => 1,
	'olympuspreview' => 1,
	'olympustags1' => 1,
	'olympustags2' => 1,
	'olympustags3' => 1,
	'olympustags4' => 1,
	'olympusthumbnail' => 1,
	'omenatcapturemode' => 1,
	'omenearlygobcolumns' => 1,
	'omenearlygobrows' => 1,
	'omenearlygobsurface' => 1,
	'omengradientexclusionlimits' => 1,
	'omengradientkernel' => 1,
	'omengradientkerneltaps' => 1,
	'omengradientoffset' => 1,
	'omeninitialcolumns' => 1,
	'omeninitialrows' => 1,
	'omeninitialscaling' => 1,
	'omenmeantostrength' => 1,
	'omenpercenttorationallimitsblue' => 1,
	'omenpercenttorationallimitsgob' => 1,
	'omenpercenttorationallimitsgor' => 1,
	'omenpercenttorationallimitsred' => 1,
	'omenrangeweighting' => 1,
	'omenratioclipfactors' => 1,
	'omenratioexclusionfactors' => 1,
	'omenroicoefficients' => 1,
	'omenroicoordinates' => 1,
	'omensmoothingkernel' => 1,
	'on1_settingsdata' => 1,
	'on1_settingsmetadatacreated' => 1,
	'on1_settingsmetadatamodified' => 1,
	'on1_settingsmetadataname' => 1,
	'on1_settingsmetadatapluginid' => 1,
	'on1_settingsmetadatatimestamp' => 1,
	'on1_settingsmetadatausage' => 1,
	'on1_settingsmetadatavisibletouser' => 1,
	'onionskins' => 1,
	'opacity' => 1,
	'opcolor' => 1,
	'opendml' => 1,
	'openwithapplication' => 1,
	'operatingsystem' => 1,
	'operation' => 1,
	'operationclassid' => 1,
	'operationid' => 1,
	'operationnumber' => 1,
	'opiproxy' => 1,
	'opticalvr' => 1,
	'optics' => 1,
	'optimalbitrate' => 1,
	'optionalattendeeaddresses' => 1,
	'optionalattendees' => 1,
	'opus' => 1,
	'opusversion' => 1,
	'orderingrestrictions' => 1,
	'organizeraddress' => 1,
	'organizername' => 1,
	'orientationinfo' => 1,
	'originalalbum' => 1,
	'originaldate' => 1,
	'originaldocumentsize' => 1,
	'originalfilesize' => 1,
	'originalfiletype' => 1,
	'originalformat' => 1,
	'originalframerate' => 1,
	'originalimagebroker' => 1,
	'originalmedia' => 1,
	'originalmedium' => 1,
	'originalrawcreator' => 1,
	'originalrawfiletype' => 1,
	'originalrawimage' => 1,
	'originalrawresource' => 1,
	'originalreleasetime' => 1,
	'originalreleaseyear' => 1,
	'originalscannedimagesize' => 1,
	'originalsoftpostpadding' => 1,
	'originalsoftprepadding' => 1,
	'originalthmcreator' => 1,
	'originalthmfiletype' => 1,
	'originalthmimage' => 1,
	'originalthmresource' => 1,
	'originalyear' => 1,
	'originator' => 1,
	'originatorreference' => 1,
	'originpathinfo' => 1,
	'osversion' => 1,
	'otheraddress' => 1,
	'othercity' => 1,
	'othercodecdescription' => 1,
	'othercodecname' => 1,
	'othercountry-region' => 1,
	'otherdate1' => 1,
	'otherdate2' => 1,
	'otherdate3' => 1,
	'otherfirmware' => 1,
	'otherformat' => 1,
	'otherinfo' => 1,
	'othermeta' => 1,
	'othername' => 1,
	'otherpobox' => 1,
	'otherpostalcode' => 1,
	'othersampledesc' => 1,
	'otherserialnumber' => 1,
	'otherstateorprovince' => 1,
	'otherstreet' => 1,
	'outputdataobjectlist' => 1,
	'outputgain' => 1,
	'outputheight' => 1,
	'outputorientation' => 1,
	'outputresponse' => 1,
	'outputwidth' => 1,
	'overclockcolsright' => 1,
	'overclockrowsbottom' => 1,
	'overflowcolor' => 1,
	'ownership' => 1,
	'packets' => 1,
	'packingmethod' => 1,
	'page' => 1,
	'pageenter' => 1,
	'pageexit' => 1,
	'pagefront' => 1,
	'pagelayout' => 1,
	'pagemode' => 1,
	'pagenormal' => 1,
	'pager' => 1,
	'pages' => 1,
	'pagespecial' => 1,
	'paintdata' => 1,
	'paintimage' => 1,
	'paintimageheight' => 1,
	'paintimagetype' => 1,
	'paintimagewidth' => 1,
	'paintingfilter' => 1,
	'palette' => 1,
	'palettecolors' => 1,
	'palettefilename' => 1,
	'palettehistogram' => 1,
	'paletteinfo' => 1,
	'palettemethod' => 1,
	'palettename' => 1,
	'palettestretch' => 1,
	'palmfiletype' => 1,
	'panasonic' => 1,
	'panasonicpana' => 1,
	'panorama' => 1,
	'panorientation' => 1,
	'panoverlaph' => 1,
	'panoverlapv' => 1,
	'paragraphs' => 1,
	'parallelismtype' => 1,
	'param0' => 1,
	'param1' => 1,
	'param2' => 1,
	'param3' => 1,
	'parameter' => 1,
	'parameterinfo' => 1,
	'parameters' => 1,
	'parasites' => 1,
	'parentalratingreason' => 1,
	'parrotautomation' => 1,
	'parrotfollowme' => 1,
	'parrottimestamp' => 1,
	'parrotv1' => 1,
	'parrotv2' => 1,
	'parrotv3' => 1,
	'part' => 1,
	'partialactivecolsleft' => 1,
	'partialactivecolsright' => 1,
	'partialactiverowsbottom' => 1,
	'partialactiverowstop' => 1,
	'partialpalette' => 1,
	'partialsyncsamples' => 1,
	'participants' => 1,
	'partnumber' => 1,
	'partofset' => 1,
	'pastclippingboundary' => 1,
	'pasteimage' => 1,
	'path' => 1,
	'pathselectionstate' => 1,
	'pathtablelocation' => 1,
	'pathtablesize' => 1,
	'patternangle' => 1,
	'patterncorrectionfactors' => 1,
	'patterncorrectiongains' => 1,
	'patterncorrectionoffsets' => 1,
	'patterngainconversiontable' => 1,
	'payloadtype' => 1,
	'paymenturl' => 1,
	'pcscitation' => 1,
	'pdahistogram' => 1,
	'pdf' => 1,
	'pdfx' => 1,
	'peakbitrate' => 1,
	'peaklevelr128' => 1,
	'peaklevelsample' => 1,
	'peakspectralsensitivity' => 1,
	'peakvalue' => 1,
	'pefversion' => 1,
	'pentax' => 1,
	'pentaxdata' => 1,
	'pentaxdata2' => 1,
	'pentaxjunk' => 1,
	'pentaxjunk2' => 1,
	'pentaxpent' => 1,
	'pentaxpreview' => 1,
	'pentaxtags' => 1,
	'perceivedtype' => 1,
	'perceptualrenderingintentgamut' => 1,
	'percussivepolyphony' => 1,
	'perfmode' => 1,
	'performersortorder' => 1,
	'perms' => 1,
	'perpicturenotes' => 1,
	'personalfunctions' => 1,
	'personalfunctionvalues' => 1,
	'personaltitle' => 1,
	'petype' => 1,
	'pfmheader' => 1,
	'pfmversion' => 1,
	'pgfversion' => 1,
	'photoeffectsdata' => 1,
	'photofinishername' => 1,
	'photomech' => 1,
	'photomechanic' => 1,
	'photoresolution' => 1,
	'photoshop' => 1,
	'photoshop2colortable' => 1,
	'photoshop2info' => 1,
	'photoshop_profile' => 1,
	'photoshopdata' => 1,
	'photoshopformat' => 1,
	'photoshopinfo' => 1,
	'photoshopsettings' => 1,
	'physicalpixel' => 1,
	'physicalstreamnumbermap' => 1,
	'physicalstreamnumbers' => 1,
	'physicalstreams' => 1,
	'pic_ifd' => 1,
	'picslabel' => 1,
	'picture' => 1,
	'picturebitsperpixel' => 1,
	'picturecontrolversion' => 1,
	'picturectrl' => 1,
	'picturedescription' => 1,
	'pictureformat' => 1,
	'pictureheight' => 1,
	'pictureindexedcolors' => 1,
	'pictureinfo' => 1,
	'picturelength' => 1,
	'picturemimetype' => 1,
	'picturestyleinfo' => 1,
	'picturetype' => 1,
	'picturewidth' => 1,
	'pieceinfo' => 1,
	'piecelength' => 1,
	'pieces' => 1,
	'pilotingmode' => 1,
	'pip' => 1,
	'pipx1' => 1,
	'pipx2' => 1,
	'pipy1' => 1,
	'pipy2' => 1,
	'pitchandfamily' => 1,
	'pitchrollyaw' => 1,
	'pittasoft' => 1,
	'pixelaspectratiox' => 1,
	'pixelaspectratioy' => 1,
	'pixelcalibration' => 1,
	'pixelcorrectiongains' => 1,
	'pixelexposuretime' => 1,
	'pixelformat' => 1,
	'pixelinfo' => 1,
	'pixelintensityrange' => 1,
	'pixellive' => 1,
	'pixelmagicjbigoptions' => 1,
	'pixelspermeterx' => 1,
	'pixelspermetery' => 1,
	'pixheight' => 1,
	'pixwidth' => 1,
	'places' => 1,
	'planckb' => 1,
	'planckf' => 1,
	'plancko' => 1,
	'planckr1' => 1,
	'planckr2' => 1,
	'playbackflickdownrating' => 1,
	'playbackflickuprating' => 1,
	'playcounter' => 1,
	'playlist' => 1,
	'playlistdelay' => 1,
	'playlistindex' => 1,
	'plus' => 1,
	'pmi' => 1,
	'pobox' => 1,
	'podcastcategory' => 1,
	'podcastdescription' => 1,
	'podcastid' => 1,
	'podcastkeywords' => 1,
	'pointsize' => 1,
	'popularimeter' => 1,
	'popupfillattributes' => 1,
	'popupflash' => 1,
	'portraitmatrix' => 1,
	'portraittonescaletable' => 1,
	'poseyawdegrees' => 1,
	'position' => 1,
	'postertime' => 1,
	'postscript2crd0' => 1,
	'postscript2crd1' => 1,
	'postscript2crd2' => 1,
	'postscript2crd3' => 1,
	'postscript2csa' => 1,
	'postscriptfont' => 1,
	'postscriptfontname' => 1,
	'pragma' => 1,
	'preferredfamily' => 1,
	'preferredrate' => 1,
	'preferredsubfamily' => 1,
	'preferredvolume' => 1,
	'prefersubselectorcenter' => 1,
	'preroll' => 1,
	'presentationformat' => 1,
	'presentationtarget' => 1,
	'preview' => 1,
	'preview0' => 1,
	'preview1' => 1,
	'preview2' => 1,
	'previewatomindex' => 1,
	'previewatomtype' => 1,
	'previewduration' => 1,
	'previewifd' => 1,
	'previewifd_offset' => 1,
	'previewimage1' => 1,
	'previewimage2' => 1,
	'previewimagedata' => 1,
	'previewimageinfo' => 1,
	'previewinfo' => 1,
	'previewpdf' => 1,
	'previewpict' => 1,
	'previewpng' => 1,
	'previewtiff' => 1,
	'previewtime' => 1,
	'previewversion' => 1,
	'previewwmf' => 1,
	'primarye-mail' => 1,
	'primaryfileguid' => 1,
	'primaryitemreference' => 1,
	'primaryphone' => 1,
	'primaryplatform' => 1,
	'primaryvolume' => 1,
	'printflags' => 1,
	'printflagsinfo' => 1,
	'printimversion' => 1,
	'printinfo' => 1,
	'printinfo2' => 1,
	'printposition' => 1,
	'printquality' => 1,
	'printscale' => 1,
	'printscaleinfo' => 1,
	'printstyle' => 1,
	'printtovideo' => 1,
	'priority' => 1,
	'prioritysettings' => 1,
	'prism' => 1,
	'private' => 1,
	'privatebuild' => 1,
	'prl' => 1,
	'prm' => 1,
	'processing' => 1,
	'processinginfo' => 1,
	'processingparameters' => 1,
	'processingtime' => 1,
	'processparametersv2' => 1,
	'prod' => 1,
	'prodnotes' => 1,
	'producedby' => 1,
	'produceddate' => 1,
	'producednotice' => 1,
	'producers' => 1,
	'product' => 1,
	'productionaperturedimensions' => 1,
	'productiondate' => 1,
	'productiondesigner' => 1,
	'productionstudio' => 1,
	'productname' => 1,
	'producttype' => 1,
	'productversionnumber' => 1,
	'profile1audiocodec' => 1,
	'profile1height' => 1,
	'profile1videocodec' => 1,
	'profile1width' => 1,
	'profileclass' => 1,
	'profilecmmtype' => 1,
	'profileconnectionspace' => 1,
	'profilecreator' => 1,
	'profiledataoffset' => 1,
	'profiledatetime' => 1,
	'profiledescription' => 1,
	'profiledescriptionml' => 1,
	'profilefilesignature' => 1,
	'profileheader' => 1,
	'profileid' => 1,
	'profileifd' => 1,
	'profilesequencedesc' => 1,
	'profilesequenceidentifier' => 1,
	'profilesequenceinfo' => 1,
	'profilesize' => 1,
	'profileversion' => 1,
	'progid' => 1,
	'programdescription' => 1,
	'programid' => 1,
	'programname' => 1,
	'progressivescans' => 1,
	'projazimuthangle' => 1,
	'projcentereasting' => 1,
	'projcenterlat' => 1,
	'projcenterlong' => 1,
	'projcenternorthing' => 1,
	'projcoordtrans' => 1,
	'project' => 1,
	'projectedcstype' => 1,
	'projection' => 1,
	'projectionboundsbottom' => 1,
	'projectionboundsleft' => 1,
	'projectionboundsright' => 1,
	'projectionboundstop' => 1,
	'projectionheader' => 1,
	'projects' => 1,
	'projfalseeasting' => 1,
	'projfalsenorthing' => 1,
	'projfalseorigineasting' => 1,
	'projfalseoriginlat' => 1,
	'projfalseoriginlong' => 1,
	'projfalseoriginnorthing' => 1,
	'projlinearunits' => 1,
	'projlinearunitsize' => 1,
	'projnatoriginlat' => 1,
	'projnatoriginlong' => 1,
	'projrectifiedgridangle' => 1,
	'projscaleatcenter' => 1,
	'projscaleatnatorigin' => 1,
	'projstdparallel1' => 1,
	'projstdparallel2' => 1,
	'projstraightvertpolelong' => 1,
	'promoteparent' => 1,
	'prop' => 1,
	'properties' => 1,
	'propertysetidcodes' => 1,
	'propertysetpathname' => 1,
	'propertystoredata' => 1,
	'propertyvectorelements' => 1,
	'protect' => 1,
	'protected' => 1,
	'protectioninfo' => 1,
	'protectiontype' => 1,
	'protune' => 1,
	'providercopyright' => 1,
	'providerlogourl' => 1,
	'providerrating' => 1,
	'providerstyle' => 1,
	'providerurl' => 1,
	'ps2crdvmsize' => 1,
	'ps2renderingintent' => 1,
	'psfontinfo' => 1,
	'pstringcaption' => 1,
	'ptrh' => 1,
	'publishdate' => 1,
	'publishdatestart' => 1,
	'publisherlimit' => 1,
	'publisherurl' => 1,
	'pur' => 1,
	'purchasefileformat' => 1,
	'purchaseinfo' => 1,
	'purpose' => 1,
	'pyramidlevels' => 1,
	'qtablelarge100pct' => 1,
	'qtablelarge25pct' => 1,
	'qtablelarge50pct' => 1,
	'qtablelarge67pct' => 1,
	'qtablemedium100pct' => 1,
	'qtablemedium25pct' => 1,
	'qtablemedium50pct' => 1,
	'qtablemedium67pct' => 1,
	'qtablesmall100pct' => 1,
	'qtablesmall25pct' => 1,
	'qtablesmall50pct' => 1,
	'qtablesmall67pct' => 1,
	'qualcomm' => 1,
	'quickedit' => 1,
	'quickmaskinfo' => 1,
	'quietshuttershootingspeed' => 1,
	'quoting' => 1,
	'qvci' => 1,
	'ra3' => 1,
	'ra4' => 1,
	'ra5' => 1,
	'radioband' => 1,
	'radioformat' => 1,
	'radiostationname' => 1,
	'radiostationowner' => 1,
	'rafdata' => 1,
	'rafversion' => 1,
	'rasterpadding' => 1,
	'rate' => 1,
	'rated' => 1,
	'ratingorg' => 1,
	'ratioimage' => 1,
	'rawburstmoderoll' => 1,
	'rawcfacomponentaverages' => 1,
	'rawcodecversion' => 1,
	'rawdatalength' => 1,
	'rawdataoffset' => 1,
	'rawdatarotation' => 1,
	'rawdev2' => 1,
	'rawdev2ifd' => 1,
	'rawdevelopment' => 1,
	'rawdevelopmentifd' => 1,
	'rawexposurebias' => 1,
	'rawgsensor' => 1,
	'rawhistogram' => 1,
	'rawimageaspectratio' => 1,
	'rawimagecroppedsize' => 1,
	'rawimagecroptopleft' => 1,
	'rawimagefullheight' => 1,
	'rawimagefullsize' => 1,
	'rawimagefullwidth' => 1,
	'rawimageheight' => 1,
	'rawimagemode' => 1,
	'rawimagesegmentation' => 1,
	'rawimagewidth' => 1,
	'rawinfo' => 1,
	'rawinfoifd' => 1,
	'rawjpginfo' => 1,
	'rawthermalimage' => 1,
	'rawthermalimageheight' => 1,
	'rawthermalimagetype' => 1,
	'rawthermalimagewidth' => 1,
	'rawvaluemedian' => 1,
	'rawvaluerange' => 1,
	'rawvaluerangemax' => 1,
	'rawvaluerangemin' => 1,
	'rawzorcreatorversion' => 1,
	'rawzorrequiredversion' => 1,
	'rdf' => 1,
	'readername' => 1,
	'readerrequirements' => 1,
	'reading1description' => 1,
	'reading1device' => 1,
	'reading1units' => 1,
	'reading1value' => 1,
	'reading2description' => 1,
	'reading2device' => 1,
	'reading2units' => 1,
	'reading2value' => 1,
	'reading3description' => 1,
	'reading3device' => 1,
	'reading3units' => 1,
	'reading3value' => 1,
	'reading4description' => 1,
	'reading4device' => 1,
	'reading4units' => 1,
	'reading4value' => 1,
	'readstatus' => 1,
	'real2ir' => 1,
	'realtimestreamingprotocol' => 1,
	'rearcontropaneldisplay' => 1,
	'recallshootfuncaf-on' => 1,
	'recallshootfuncafareamode' => 1,
	'recallshootfuncaperture' => 1,
	'recallshootfuncexposurecomp' => 1,
	'recallshootfuncexposuremode' => 1,
	'recallshootfuncfocustracking' => 1,
	'recallshootfunciso' => 1,
	'recallshootfuncmeteringmode' => 1,
	'recallshootfuncshutterspeed' => 1,
	'recallshootfuncwhitebalance' => 1,
	'receivedfrom' => 1,
	'recengineer' => 1,
	'recinfo' => 1,
	'reclocation' => 1,
	'reconstructiontype' => 1,
	'recordedby' => 1,
	'recordeddate' => 1,
	'recordingdates' => 1,
	'recordingtime' => 1,
	'recordingtimeday' => 1,
	'recordingtimemonth' => 1,
	'recordingtimeyear' => 1,
	'recordingtimeyearmonth' => 1,
	'recordingtimeyearmonthday' => 1,
	'rect' => 1,
	'rectangleofinterest' => 1,
	'red1header' => 1,
	'red2header' => 1,
	'redadjust' => 1,
	'redblueflatfield' => 1,
	'redcodeversion' => 1,
	'redendpoint' => 1,
	'redeyedata' => 1,
	'redgain' => 1,
	'redmask' => 1,
	'redmatrixcolumn' => 1,
	'redprimary' => 1,
	'redsample' => 1,
	'redtrc' => 1,
	'redx' => 1,
	'redy' => 1,
	'reelnumber' => 1,
	'reeltimecode' => 1,
	'reference' => 1,
	'referencename' => 1,
	'referencetemperature' => 1,
	'reflectedapparenttemperature' => 1,
	'reflection' => 1,
	'reflectionhardcopyorigcolorimetry' => 1,
	'reflectionprintoutputcolorimetry' => 1,
	'refresh' => 1,
	'regionxformtackpoint' => 1,
	'registerreadtiming' => 1,
	'relatedimagefile' => 1,
	'relationship' => 1,
	'relativeexposure' => 1,
	'relativehumidity' => 1,
	'relativelocation' => 1,
	'relativepath' => 1,
	'relativevolumeadjustment' => 1,
	'releasedateday' => 1,
	'releasedatemonth' => 1,
	'releasedateyear' => 1,
	'releasedateyearmonth' => 1,
	'releasedateyearmonthday' => 1,
	'rembrandtconsumertonescale' => 1,
	'rembrandtportraittonescale' => 1,
	'rembrandttonescale' => 1,
	'remindertime' => 1,
	'remotefuncbutton' => 1,
	'removehistoryduplicates' => 1,
	'renderingintent' => 1,
	'renderingtransform' => 1,
	'rentalexpirationdate' => 1,
	'rentalflag' => 1,
	'repeateddatabytes' => 1,
	'replaygainalbumgain' => 1,
	'replaygainalbumpeak' => 1,
	'replaygaintrackgain' => 1,
	'replaygaintrackpeak' => 1,
	'replaytrackgain' => 1,
	'replaytrackpeak' => 1,
	'replayvolumelevel' => 1,
	'replyto' => 1,
	'representativedisparityfar' => 1,
	'representativedisparitynear' => 1,
	'representativeimage' => 1,
	'requestid' => 1,
	'requeststate' => 1,
	'requiredattendeeaddresses' => 1,
	'requiredattendees' => 1,
	'rerun' => 1,
	'reserved1' => 1,
	'reserved5' => 1,
	'reservedblob2' => 1,
	'reservedblob3' => 1,
	'reservedblob4' => 1,
	'reservedblob5' => 1,
	'reservedblob6' => 1,
	'reservedblob7' => 1,
	'reservedblob8' => 1,
	'reservedblob9' => 1,
	'resolutioninfo' => 1,
	'resourcecount' => 1,
	'resourceforksize' => 1,
	'resources' => 1,
	'resourcesneeded' => 1,
	'resourcetype' => 1,
	'resultaspectratio' => 1,
	'retailprice' => 1,
	'retailpricecurrency' => 1,
	'retouchinfoversion' => 1,
	'review' => 1,
	'revisiondate' => 1,
	'revisionnumber' => 1,
	'revisitafter' => 1,
	'rgb_profile' => 1,
	'rgbcurves' => 1,
	'rgbtoev0' => 1,
	'rgbtoev1' => 1,
	'rgbtoev2' => 1,
	'rgbtoev3' => 1,
	'rgbtoev4' => 1,
	'rgbtoev5' => 1,
	'rgbtoev6' => 1,
	'rgbtoev7' => 1,
	'rgbtoev8' => 1,
	'rgbtoev9' => 1,
	'rgtable' => 1,
	'ricoh' => 1,
	'ricohjunk' => 1,
	'ricohmake' => 1,
	'ricohmodel' => 1,
	'ricohpitch' => 1,
	'ricohrdc2' => 1,
	'ricohrmkn' => 1,
	'ricohroll' => 1,
	'ricohrr1subdir' => 1,
	'ricohsubdir' => 1,
	'ricohsubdirifd' => 1,
	'riffsize64' => 1,
	'rightdarkcol1' => 1,
	'rightdarkcol2' => 1,
	'rightdarkrect' => 1,
	'rightmag' => 1,
	'rimm13toerimm12spline' => 1,
	'rimmtocrgb0spline' => 1,
	'rimmtocrgb1spline' => 1,
	'rimmtocrgb2spline' => 1,
	'rimmtocrgb3spline' => 1,
	'rimmtocrgb4spline' => 1,
	'rimmtocrgb5spline' => 1,
	'rimmtocrgb6spline' => 1,
	'rimmtocrgb7spline' => 1,
	'rimmtocrgb8spline' => 1,
	'rimmtocrgb9spline' => 1,
	'rimnonlinearity' => 1,
	'rimtonifcolortransform' => 1,
	'rimtonifscalefactor' => 1,
	'rippedby' => 1,
	'rjmd' => 1,
	'rmeta' => 1,
	'rnoiselines' => 1,
	'robots' => 1,
	'rocinfo' => 1,
	'roidescription' => 1,
	'rollguidelements' => 1,
	'rollingshutterskewtime' => 1,
	'root' => 1,
	'rootdirectorycreatedate' => 1,
	'rot360fly' => 1,
	'rotationangle' => 1,
	'rotationxyz' => 1,
	'rotmode' => 1,
	'roundtripversion' => 1,
	'rowcount' => 1,
	'rowinterleavefactor' => 1,
	'rsrc' => 1,
	'rtmd' => 1,
	'rtptimescale' => 1,
	'runtime' => 1,
	'runtimeepoch' => 1,
	'runtimeflags' => 1,
	'runtimescale' => 1,
	'runtimesincepowerup' => 1,
	'runtimevalue' => 1,
	'runwindow' => 1,
	'rvmi_grev' => 1,
	'rvmi_srev' => 1,
	's2n' => 1,
	'sampleblacksequence' => 1,
	'sampledatetime' => 1,
	'sampledegradationpriority' => 1,
	'sampleduration' => 1,
	'sampleflag' => 1,
	'sampleformat' => 1,
	'samplegroupdescription' => 1,
	'samplepaddingbits' => 1,
	'sampleperiod' => 1,
	'sampler' => 1,
	'samplerate2' => 1,
	'samplerdata' => 1,
	'samplerdatalen' => 1,
	'samplesize' => 1,
	'samplesizes' => 1,
	'sampletable' => 1,
	'sampletext' => 1,
	'sampletime' => 1,
	'sampletochunk' => 1,
	'sampletogroup' => 1,
	'samsung' => 1,
	'samsungifd' => 1,
	'samsunginfo' => 1,
	'samsungrawbyteorder' => 1,
	'samsungrawpointerslength' => 1,
	'samsungrawpointersoffset' => 1,
	'samsungrawunknown' => 1,
	'samsungsec' => 1,
	'samsungsmta' => 1,
	'samsungsvss' => 1,
	'samsungtags' => 1,
	'samsungtrailer' => 1,
	'samsunguniqueid' => 1,
	'sanyomov' => 1,
	'sanyomp4' => 1,
	'sap' => 1,
	'saturationinfo' => 1,
	'saturationrenderingintentgamut' => 1,
	'savefocus' => 1,
	'saveobjbacktype' => 1,
	'saveobjects' => 1,
	'saveobjname' => 1,
	'saveobjtype' => 1,
	'saveobjversion' => 1,
	'savesetup' => 1,
	'sba_rgbshifts' => 1,
	'sbabluebalancelut' => 1,
	'sbaexposurerecord' => 1,
	'sbagreenbalancelut' => 1,
	'sbainputimagebitdepth' => 1,
	'sbainputimagecolorspace' => 1,
	'sbalog12transform' => 1,
	'sbalogtransform' => 1,
	'sbaredbalancelut' => 1,
	'scalado' => 1,
	'scale' => 1,
	'scalecrop' => 1,
	'scaledimu' => 1,
	'scaledpressure' => 1,
	'scalefactor' => 1,
	'scalefactor35efl' => 1,
	'scalingfactor' => 1,
	'scandate' => 1,
	'scannerfirmwaredate' => 1,
	'scannerfirmwareversion' => 1,
	'scannermake' => 1,
	'scannermodel' => 1,
	'scannerpixelsize' => 1,
	'scannerproductid' => 1,
	'scannerserialnumber' => 1,
	'scannervendorid' => 1,
	'scanoperatorid' => 1,
	'scansoftware' => 1,
	'scansoftwarerevisiondate' => 1,
	'scav11cols' => 1,
	'scav12cols' => 1,
	'scav21cols' => 1,
	'scav22cols' => 1,
	'sceneappearanceestimates' => 1,
	'scenebalancealgorithmcommand' => 1,
	'scenebalancealgorithmfilmid' => 1,
	'scenebalancealgorithmrevision' => 1,
	'scenecolorimetryestimates' => 1,
	'scheduleitemid' => 1,
	'schemeinfo' => 1,
	'schemetype' => 1,
	'schemeurl' => 1,
	'schemeversion' => 1,
	'school' => 1,
	'screenbuffersize' => 1,
	'screendescriptor' => 1,
	'screenheight' => 1,
	'screening' => 1,
	'screeningdesc' => 1,
	'screennail' => 1,
	'screenwidth' => 1,
	'screenwindowcenter' => 1,
	'screenwindowwidth' => 1,
	'screenwriters' => 1,
	'script' => 1,
	'scriptcommand' => 1,
	'sdc' => 1,
	'searchranking' => 1,
	'secondarygenre' => 1,
	'secondlanguage' => 1,
	'security' => 1,
	'seekable' => 1,
	'seekpoint' => 1,
	'seektable' => 1,
	'segheight' => 1,
	'segwidth' => 1,
	'selection' => 1,
	'selectionduration' => 1,
	'selectiontime' => 1,
	'selobjbacktype' => 1,
	'selobjname' => 1,
	'selobjtype' => 1,
	'selobjversion' => 1,
	'semanticinstanceifd' => 1,
	'semanticname' => 1,
	'sendduration' => 1,
	'senderaddress' => 1,
	'sendername' => 1,
	'sensitivity' => 1,
	'sensitivityvalue' => 1,
	'sensorbottomborder' => 1,
	'sensordata' => 1,
	'sensordefects' => 1,
	'sensorid' => 1,
	'sensorinfo' => 1,
	'sensorreadouttime' => 1,
	'sensorrightborder' => 1,
	'seqlevelidx0' => 1,
	'seqprofile' => 1,
	'seqtier0' => 1,
	'sequenceframenumber' => 1,
	'sequencenumberrandomoffset' => 1,
	'serialinfo' => 1,
	'seriesuid' => 1,
	'serviceid' => 1,
	'serviceorganizationname' => 1,
	'setcookie' => 1,
	'setinfo' => 1,
	'setsubtitle' => 1,
	'seventhlanguage' => 1,
	'sfsboundary' => 1,
	'sglcoldcacthres1' => 1,
	'sglcoldcacthres2' => 1,
	'sglcoldcacthres3' => 1,
	'shadowendpoints' => 1,
	'shadowfilepath' => 1,
	'shadowsyncsampletable' => 1,
	'shakereductioninfo' => 1,
	'shared' => 1,
	'shareddata' => 1,
	'shareddoc' => 1,
	'sharedwith' => 1,
	'sharpenforthumbnail' => 1,
	'sharpeningon' => 1,
	'sharpinfo' => 1,
	'sharpmethod' => 1,
	'sharpnessapproximation' => 1,
	'sharpnessfreqtable' => 1,
	'sharpnesstable' => 1,
	'sharpobjbacktype' => 1,
	'sharpobjname' => 1,
	'sharpobjtype' => 1,
	'sharpobjversion' => 1,
	'sheetdisclosure' => 1,
	'shifttiming' => 1,
	'shimdata' => 1,
	'shootingcount' => 1,
	'shootingrecord' => 1,
	'shootobjbacktype' => 1,
	'shootobjname' => 1,
	'shootobjtype' => 1,
	'shootobjversion' => 1,
	'shootsetup' => 1,
	'shotinfo' => 1,
	'shotinfo02xx' => 1,
	'shotinfod300a' => 1,
	'shotinfod300b' => 1,
	'shotinfod300s' => 1,
	'shotinfod3a' => 1,
	'shotinfod3b' => 1,
	'shotinfod3s' => 1,
	'shotinfod3x' => 1,
	'shotinfod4' => 1,
	'shotinfod40' => 1,
	'shotinfod4s' => 1,
	'shotinfod5' => 1,
	'shotinfod500' => 1,
	'shotinfod5000' => 1,
	'shotinfod5100' => 1,
	'shotinfod5200' => 1,
	'shotinfod6' => 1,
	'shotinfod610' => 1,
	'shotinfod700' => 1,
	'shotinfod7000' => 1,
	'shotinfod80' => 1,
	'shotinfod800' => 1,
	'shotinfod810' => 1,
	'shotinfod850' => 1,
	'shotinfod90' => 1,
	'shotinfounknown' => 1,
	'shotinfoversion' => 1,
	'shotinfoz7ii' => 1,
	'shotinfoz9' => 1,
	'showmode' => 1,
	'showobjects' => 1,
	'shutterangle' => 1,
	'shuttercurtainhack' => 1,
	'shutterspeed' => 1,
	'shutterspeeddisplayed' => 1,
	'sidebars' => 1,
	'sidelightstrength' => 1,
	'sigma' => 1,
	'sigmanoisefiltercaltablev1' => 1,
	'sigmanoisefiltertablev1' => 1,
	'sigmanoisefiltertablev1version' => 1,
	'sigmanoisethreshtablev2' => 1,
	'signalnumber' => 1,
	'signature' => 1,
	'signature_name' => 1,
	'signatureusagerights' => 1,
	'signercontactinfo' => 1,
	'significantbits' => 1,
	'signingauthority' => 1,
	'signingdate' => 1,
	'signinglocation' => 1,
	'signingreason' => 1,
	'signtype' => 1,
	'simpleindex' => 1,
	'simplicityprofile' => 1,
	'singlequality' => 1,
	'singleshotdepthmap' => 1,
	'singleshotdepthmaptiff' => 1,
	'singleshotmeta' => 1,
	'site' => 1,
	'siteenter' => 1,
	'siteexit' => 1,
	'siunits' => 1,
	'sixthlanguage' => 1,
	'size' => 1,
	'sizemode' => 1,
	'skip' => 1,
	'slateinformation' => 1,
	'sliceinfo' => 1,
	'slicesgroupname' => 1,
	'slides' => 1,
	'slideshow' => 1,
	'smaxsamplevalue' => 1,
	'sminsamplevalue' => 1,
	'smpteformat' => 1,
	'smpteoffset' => 1,
	'snapshotid' => 1,
	'snapshotname' => 1,
	'soctemperature' => 1,
	'softedit' => 1,
	'softfocusfilter' => 1,
	'softwarecomponents' => 1,
	'softwarerelease' => 1,
	'sony' => 1,
	'sony_0x9416' => 1,
	'sonyfnumber2' => 1,
	'sonyrawfiletype' => 1,
	'sonytonecurve' => 1,
	'soundfile' => 1,
	'soundschemetitle' => 1,
	'sourcecreatedate' => 1,
	'sourcedata' => 1,
	'sourcedate' => 1,
	'sourceedition' => 1,
	'sourcefilename' => 1,
	'sourceform' => 1,
	'sourceid' => 1,
	'sourceimagedirectory' => 1,
	'sourceimagefilename' => 1,
	'sourceimageheight' => 1,
	'sourceimagevolumename' => 1,
	'sourceimagewidth' => 1,
	'sourcepublisher' => 1,
	'sourcerights' => 1,
	'sourcetitle' => 1,
	'sourceurl' => 1,
	'spacefree' => 1,
	'spaceused' => 1,
	'spatialorientation' => 1,
	'spatialresolution' => 1,
	'specialbuild' => 1,
	'specialeffectsopticalfilter' => 1,
	'specialfolderdata' => 1,
	'specificationversion' => 1,
	'spectralviewingconditions' => 1,
	'spectralwhitepoint' => 1,
	'speed' => 1,
	'sphericalvideo' => 1,
	'sphericalvideoxml' => 1,
	'spiff' => 1,
	'spiffversion' => 1,
	'spinstrength' => 1,
	'spothalftone' => 1,
	'spouse' => 1,
	'sr2dataifd' => 1,
	'sr2private' => 1,
	'sr2subifdkey' => 1,
	'sr2subifdlength' => 1,
	'sr2subifdoffset' => 1,
	'srawtype' => 1,
	'srf2key' => 1,
	'srf6offset' => 1,
	'srfdataoffset' => 1,
	'stampinfo' => 1,
	'stamptoolcount' => 1,
	'standardtocustompcc' => 1,
	'standbymonitorofftime' => 1,
	'starring' => 1,
	'startdate' => 1,
	'startedgecode' => 1,
	'startofframe' => 1,
	'startreading' => 1,
	'starttime' => 1,
	'stateorprovince' => 1,
	'stationcallsign' => 1,
	'stationname' => 1,
	'statistics' => 1,
	'stdautoactive' => 1,
	'stdbasename' => 1,
	'stdhotfolder' => 1,
	'stdopeninphotoshop' => 1,
	'stdoutputbitdepth' => 1,
	'stdoutputcolormode' => 1,
	'stdoutputfiletype' => 1,
	'stdoxygen' => 1,
	'stdsaveselection' => 1,
	'stdscaledoutput' => 1,
	'stdsharpenoutput' => 1,
	'stereo' => 1,
	'stereoimage' => 1,
	'stereoscopic3d' => 1,
	'stillimagetime' => 1,
	'stim' => 1,
	'stimversion' => 1,
	'stitchcolumns' => 1,
	'stitchinfo' => 1,
	'stitchrows' => 1,
	'stonits' => 1,
	'storage-streampathname' => 1,
	'storageformatdate' => 1,
	'storageformattime' => 1,
	'storagemodel' => 1,
	'storageserialnumber' => 1,
	'storagetype' => 1,
	'store' => 1,
	'stream' => 1,
	'streamavgbitrate' => 1,
	'streamavgpacketsize' => 1,
	'streambitdepth' => 1,
	'streambitrateprops' => 1,
	'streamcolor' => 1,
	'streamcount' => 1,
	'streamdata' => 1,
	'streamduration' => 1,
	'streamheader' => 1,
	'streaminfo' => 1,
	'streamingdataprotocol' => 1,
	'streammaxbitrate' => 1,
	'streammaxpacketsize' => 1,
	'streammimelen' => 1,
	'streammimetype' => 1,
	'streamname' => 1,
	'streamnamelen' => 1,
	'streamnumber' => 1,
	'streampreroll' => 1,
	'streamprioritization' => 1,
	'streamproperties' => 1,
	'streamsamplecount' => 1,
	'streamsamplerate' => 1,
	'streamstarttime' => 1,
	'streamtypeinfo' => 1,
	'street' => 1,
	'stridable' => 1,
	'strikeout' => 1,
	'stripbytecounts' => 1,
	'stripoffsets' => 1,
	'striprowcounts' => 1,
	'strobe' => 1,
	'strobetime' => 1,
	'structuretype' => 1,
	'studio' => 1,
	'sub-sampleinformation' => 1,
	'subdialframeadvance' => 1,
	'subdialframeadvancerating0' => 1,
	'subdialframeadvancerating1' => 1,
	'subdialframeadvancerating2' => 1,
	'subdialframeadvancerating3' => 1,
	'subdialframeadvancerating4' => 1,
	'subdialframeadvancerating5' => 1,
	'subdir3000' => 1,
	'subdir3100' => 1,
	'subdir3400' => 1,
	'subdir3900' => 1,
	'subfile' => 1,
	'subifd' => 1,
	'subifd0' => 1,
	'subifd1' => 1,
	'subifd2' => 1,
	'subifd255' => 1,
	'subifd3' => 1,
	'subifd4' => 1,
	'subifd5' => 1,
	'subifd6' => 1,
	'subifd_offset' => 1,
	'subimagecolor' => 1,
	'subimagehdr' => 1,
	'subimageheight' => 1,
	'subimageicc_profile' => 1,
	'subimagenumericalformat' => 1,
	'subimageresolutions' => 1,
	'subimagetilecount' => 1,
	'subimagetileheight' => 1,
	'subimagetilewidth' => 1,
	'subimagewidth' => 1,
	'subjectpixelheight' => 1,
	'subjectpixelwidth' => 1,
	'subjectscale' => 1,
	'subjectunits' => 1,
	'subpacketh' => 1,
	'subpacketsize' => 1,
	'subscriptioncontentid' => 1,
	'subsystem' => 1,
	'subsystemversion' => 1,
	'subtileblocksize' => 1,
	'subtitledescription' => 1,
	'suffix' => 1,
	'suggestedpalette' => 1,
	'summary' => 1,
	'summaryinfo' => 1,
	'surfacemap' => 1,
	'surroundmode' => 1,
	'surroundshotvideo' => 1,
	'surroundshotvideoname' => 1,
	'svgversion' => 1,
	'swf' => 1,
	'sync01' => 1,
	'sync02' => 1,
	'sync03' => 1,
	'sync04' => 1,
	'sync05' => 1,
	'sync06' => 1,
	'sync07' => 1,
	'sync08' => 1,
	'sync09' => 1,
	'sync10' => 1,
	'sync11' => 1,
	'sync12' => 1,
	'sync13' => 1,
	'sync14' => 1,
	'sync15' => 1,
	'sync16' => 1,
	'synchronizedlyricsdescription' => 1,
	'synchronizedlyricstext' => 1,
	'synchronizedlyricstype' => 1,
	'synconly' => 1,
	'syncsampletable' => 1,
	'syncstate' => 1,
	'synlyrics' => 1,
	'systemtime' => 1,
	't4options' => 1,
	't6options' => 1,
	't82options' => 1,
	't88options' => 1,
	'tag2010a' => 1,
	'tag2010b' => 1,
	'tag2010c' => 1,
	'tag2010d' => 1,
	'tag2010e' => 1,
	'tag2010f' => 1,
	'tag2010g' => 1,
	'tag2010h' => 1,
	'tag2010i' => 1,
	'tag202a' => 1,
	'tag900b' => 1,
	'tag9050a' => 1,
	'tag9050b' => 1,
	'tag9050c' => 1,
	'tag9400a' => 1,
	'tag9400b' => 1,
	'tag9400c' => 1,
	'tag9401' => 1,
	'tag9402' => 1,
	'tag9403' => 1,
	'tag9404a' => 1,
	'tag9404b' => 1,
	'tag9404c' => 1,
	'tag9405a' => 1,
	'tag9405b' => 1,
	'tag9406' => 1,
	'tag940a' => 1,
	'tag940c' => 1,
	'tag940e' => 1,
	'tag9416_0000' => 1,
	'taggedpdf' => 1,
	'taggingtime' => 1,
	'take' => 1,
	'tamper-proofkeys' => 1,
	'targetaudiences' => 1,
	'targetdeltatype' => 1,
	'targetfiledosname' => 1,
	'targetfilesize' => 1,
	'targetlayerid' => 1,
	'targetxy' => 1,
	'taskowner' => 1,
	'tattoo' => 1,
	'tcmediainfo' => 1,
	'tdat' => 1,
	'tdhd' => 1,
	'technician' => 1,
	'technology' => 1,
	'telephonenumber' => 1,
	'telescope' => 1,
	'telex' => 1,
	'temperature' => 1,
	'tempinfo' => 1,
	'template' => 1,
	'temporalidnested' => 1,
	'temporary' => 1,
	'terminationaction' => 1,
	'terminationcondition' => 1,
	'termsofuse' => 1,
	'testtarget' => 1,
	'testtransfertiming' => 1,
	'text' => 1,
	'textcolor' => 1,
	'textface' => 1,
	'textfont' => 1,
	'textinfo' => 1,
	'textinfo1' => 1,
	'textinfo2' => 1,
	'textjunk' => 1,
	'textsize' => 1,
	'texttospeech' => 1,
	'textualdata' => 1,
	'textualinfo' => 1,
	'textureformat' => 1,
	'theora' => 1,
	'theoraversion' => 1,
	'thermalcalibration' => 1,
	'thermaldata' => 1,
	'thermalparams' => 1,
	'thetasubdir' => 1,
	'things' => 1,
	'thirdlanguage' => 1,
	'thumbinfo' => 1,
	'thumbnail' => 1,
	'thumbnailbpg' => 1,
	'thumbnailclip' => 1,
	'thumbnailcompressiontable' => 1,
	'thumbnailexpansiontable' => 1,
	'thumbnailhash' => 1,
	'thumbnailref' => 1,
	'thumbnailresizeratio' => 1,
	'thumbnailtiff' => 1,
	'thumbnailurl' => 1,
	'tickspersecond' => 1,
	'tiff' => 1,
	'tiff-epstandardid' => 1,
	'tiff_fxextensions' => 1,
	'tiffmeteringimageheight' => 1,
	'tiffmeteringimagewidth' => 1,
	'tiffpreview' => 1,
	'tilebytecounts' => 1,
	'tiledepth' => 1,
	'tilegaindeterminationtable' => 1,
	'tileoffsets' => 1,
	'tiles' => 1,
	'timecode' => 1,
	'timecodeindex' => 1,
	'timecodeindexparms' => 1,
	'timeinfo' => 1,
	'timelineinfo' => 1,
	'timeoffset' => 1,
	'timereference' => 1,
	'timescale' => 1,
	'timestamplist' => 1,
	'timestamprandomoffset' => 1,
	'timetosampletable' => 1,
	'title2' => 1,
	'titlelen' => 1,
	'titlenum' => 1,
	'titleofparts' => 1,
	'titlesofparts' => 1,
	'titlesortorder' => 1,
	'toaddresses' => 1,
	'tocitems' => 1,
	'todotitle' => 1,
	'tomtomad' => 1,
	'tomtomhl' => 1,
	'tomtomid' => 1,
	'tomtommetadata' => 1,
	'tomtomvd' => 1,
	'tomtomvi' => 1,
	'tonames' => 1,
	'tonecurvematching' => 1,
	'tonecurvetable' => 1,
	'tonematrix' => 1,
	'toneobjbacktype' => 1,
	'toneobjname' => 1,
	'toneobjtype' => 1,
	'toneobjversion' => 1,
	'tones' => 1,
	'tonescale0' => 1,
	'tonescale0spline' => 1,
	'tonescale1' => 1,
	'tonescale1spline' => 1,
	'tonescale2' => 1,
	'tonescale2spline' => 1,
	'tonescale3' => 1,
	'tonescale3spline' => 1,
	'tonescale4' => 1,
	'tonescale4spline' => 1,
	'tonescale5' => 1,
	'tonescale5spline' => 1,
	'tonescale6' => 1,
	'tonescale6spline' => 1,
	'tonescale7' => 1,
	'tonescale7spline' => 1,
	'tonescale8' => 1,
	'tonescale8spline' => 1,
	'tonescale9' => 1,
	'tonescale9spline' => 1,
	'tonespaceflow' => 1,
	'tonscaletable' => 1,
	'tool_name' => 1,
	'tool_version' => 1,
	'toolname' => 1,
	'toolversion' => 1,
	'topdarkrow1' => 1,
	'topdarkrow2' => 1,
	'topmag' => 1,
	'topmargin' => 1,
	'totalbitrate' => 1,
	'totalbytes' => 1,
	'totalbytesnortpheaders' => 1,
	'totaldatarate' => 1,
	'totalduration' => 1,
	'totaleditingtime' => 1,
	'totaledittime' => 1,
	'totalfilesize' => 1,
	'totalframecount' => 1,
	'totalframes' => 1,
	'totalsamples' => 1,
	'totalsize' => 1,
	'toycamerafilter' => 1,
	'trackaperture' => 1,
	'trackcategory' => 1,
	'trackcomments' => 1,
	'trackduration' => 1,
	'trackerdata' => 1,
	'trackfragment' => 1,
	'trackheader' => 1,
	'trackheaderversion' => 1,
	'trackid' => 1,
	'trackingid' => 1,
	'tracklayer' => 1,
	'tracklyrics' => 1,
	'trackproperty' => 1,
	'trackref' => 1,
	'trackvolume' => 1,
	'trademark' => 1,
	'transactionid' => 1,
	'transfercharacteristic' => 1,
	'transferrange' => 1,
	'transfersequence' => 1,
	'transformation' => 1,
	'transformcreatedate' => 1,
	'transformedimagetitle' => 1,
	'transformmodifydate' => 1,
	'transformnodeid' => 1,
	'transformparams' => 1,
	'transformtitle' => 1,
	'transparency' => 1,
	'transparencyindicator' => 1,
	'transparentcolor' => 1,
	'transparentindex' => 1,
	'trapindicator' => 1,
	'trashcolsright' => 1,
	'trashrowsbottom' => 1,
	'trim' => 1,
	'tty-ttdphone' => 1,
	'tungmat0' => 1,
	'tungmat1' => 1,
	'tungmat2' => 1,
	'tungmat3' => 1,
	'tungmat4' => 1,
	'tungmat5' => 1,
	'tungmat6' => 1,
	'tungmat7' => 1,
	'tungmat8' => 1,
	'tungmat9' => 1,
	'twelvebit' => 1,
	'tx3g' => 1,
	'typeoforiginal' => 1,
	'typist' => 1,
	'ucrbg' => 1,
	'uic1tag' => 1,
	'uic2tag' => 1,
	'uic3tag' => 1,
	'uic4tag' => 1,
	'uncompressed' => 1,
	'uncompressedsize' => 1,
	'uncompressedtextlength' => 1,
	'underflowcolor' => 1,
	'underline' => 1,
	'underlineposition' => 1,
	'underlinethickness' => 1,
	'unicodealphanames' => 1,
	'uninitializeddatasize' => 1,
	'uniquefileidentifier' => 1,
	'uniqueid' => 1,
	'unknown' => 1,
	'unknown00' => 1,
	'unknown01' => 1,
	'unknown02' => 1,
	'unknown03' => 1,
	'unknown_cndb' => 1,
	'unknown_slmt' => 1,
	'unknownd30' => 1,
	'unknowndata' => 1,
	'unknownexif' => 1,
	'unknowninfo' => 1,
	'unknowninfo2' => 1,
	'unknowninfo2version' => 1,
	'unknowninfoifd' => 1,
	'unknowninfoversion' => 1,
	'unknownserial1' => 1,
	'unknownserial2' => 1,
	'unknownserial3' => 1,
	'unknownserial4' => 1,
	'unknowntemperature1' => 1,
	'unknowntemperature2' => 1,
	'unsharpdata' => 1,
	'unshiftednote' => 1,
	'untitled0' => 1,
	'untitled1' => 1,
	'untitled2' => 1,
	'unused' => 1,
	'unusedblackcolsleftin' => 1,
	'unusedblackcolsleftout' => 1,
	'unusedblackcolsrightin' => 1,
	'unusedblackcolsrightout' => 1,
	'unusedblackrowsbottomin' => 1,
	'unusedblackrowsbottomout' => 1,
	'unusedblackrowstopin' => 1,
	'unusedblackrowstopout' => 1,
	'updatedtitle' => 1,
	'ur3' => 1,
	'urllist1' => 1,
	'urn' => 1,
	'usagerightsmessage' => 1,
	'usedextensionnumbers' => 1,
	'useraccess' => 1,
	'useradjsba_rgbshifts' => 1,
	'usercustom1' => 1,
	'usercustom2' => 1,
	'userdata' => 1,
	'userdefinedid' => 1,
	'userdefinedtext' => 1,
	'userdefinedurl' => 1,
	'usereffectiverating' => 1,
	'userid' => 1,
	'userlastplayedtime' => 1,
	'usermetadata' => 1,
	'username' => 1,
	'userplaycount' => 1,
	'userplaycountafternoon' => 1,
	'userplaycountevening' => 1,
	'userplaycountmorning' => 1,
	'userplaycountnight' => 1,
	'userplaycountweekday' => 1,
	'userplaycountweekend' => 1,
	'userselectgrouptitle' => 1,
	'userservicerating' => 1,
	'usertext' => 1,
	'userweburl' => 1,
	'usingtransforms' => 1,
	'usmparametershigh' => 1,
	'usmparametershost' => 1,
	'usmparametershost3mp' => 1,
	'usmparametershost6mp' => 1,
	'usmparameterslow' => 1,
	'usmparametersmed' => 1,
	'usptomiscellaneous' => 1,
	'usptooriginalcontenttype' => 1,
	'utm' => 1,
	'uuid-c2paclaimsignature' => 1,
	'uuid-canon' => 1,
	'uuid-canon2' => 1,
	'uuid-exif' => 1,
	'uuid-exif2' => 1,
	'uuid-exif_bad' => 1,
	'uuid-flip' => 1,
	'uuid-geojp2' => 1,
	'uuid-iptc' => 1,
	'uuid-iptc2' => 1,
	'uuid-photoshop' => 1,
	'uuid-prof' => 1,
	'uuid-signature' => 1,
	'uuid-unknown' => 1,
	'uuid-usmt' => 1,
	'uuid-xmp' => 1,
	'uuidinfo' => 1,
	'uuidlist' => 1,
	'validafpoints' => 1,
	'validate' => 1,
	'value0' => 1,
	'value1' => 1,
	'value2' => 1,
	'value3' => 1,
	'vary' => 1,
	'vbrbytes' => 1,
	'vbrframes' => 1,
	'vbrpeak' => 1,
	'vbrscale' => 1,
	'vddimdacnominalvalues' => 1,
	'vegasversionmajor' => 1,
	'vegasversionminor' => 1,
	'vendorid' => 1,
	'vendorname' => 1,
	'vendorurl' => 1,
	'version1' => 1,
	'version2' => 1,
	'versionbf' => 1,
	'versionifd' => 1,
	'versioninfo' => 1,
	'versionrestrictions' => 1,
	'versionyear' => 1,
	'verticalaf-onbutton' => 1,
	'verticalcitation' => 1,
	'verticalcstype' => 1,
	'verticaldatum' => 1,
	'verticaldivergence' => 1,
	'verticalresolution' => 1,
	'verticalscale' => 1,
	'verticalspeed' => 1,
	'verticalunits' => 1,
	'video' => 1,
	'videoattributes' => 1,
	'videoavgbitrate' => 1,
	'videoavgframerate' => 1,
	'videocardgamma' => 1,
	'videoclosedcaptioning' => 1,
	'videocodecdescription' => 1,
	'videocodecid' => 1,
	'videocodecinfo' => 1,
	'videocodecname' => 1,
	'videoencoding' => 1,
	'videoformat' => 1,
	'videoframecount' => 1,
	'videoheader' => 1,
	'videoheight' => 1,
	'videomaxbitrate' => 1,
	'videomaxframerate' => 1,
	'videomode' => 1,
	'videoorientation' => 1,
	'videoprofile' => 1,
	'videoprofileversion' => 1,
	'videosampledesc' => 1,
	'videoscantype' => 1,
	'videosize' => 1,
	'videostreamtype' => 1,
	'videotimestamp' => 1,
	'videotrackid' => 1,
	'videowidth' => 1,
	'view' => 1,
	'viewable' => 1,
	'viewingconddesc' => 1,
	'viewingcondilluminant' => 1,
	'viewingcondilluminanttype' => 1,
	'viewingconditions' => 1,
	'viewingcondsurround' => 1,
	'viewtype' => 1,
	'vignettingcorr' => 1,
	'vignettingcorr2' => 1,
	'vignettingcorrunknown1' => 1,
	'vignettingcorrunknown2' => 1,
	'vignettingcorrversion' => 1,
	'vignettingparams' => 1,
	'vintagestrength' => 1,
	'virtualimageheight' => 1,
	'virtualimagewidth' => 1,
	'virtualpage' => 1,
	'virtualpageunits' => 1,
	'visibleoutputs' => 1,
	'vistaidlistdata' => 1,
	'visualflightruleshud' => 1,
	'vmaphandling' => 1,
	'vmcoldropthresh' => 1,
	'vmcolthresh' => 1,
	'vmnbands' => 1,
	'vmpatchreslimit' => 1,
	'vmpixthresh' => 1,
	'vmwsize' => 1,
	'volumeblockcount' => 1,
	'volumeblocksize' => 1,
	'volumecreatedate' => 1,
	'volumeeffectivedate' => 1,
	'volumeexpirationdate' => 1,
	'volumeid' => 1,
	'volumelabel' => 1,
	'volumelevelr128' => 1,
	'volumemodifydate' => 1,
	'volumename' => 1,
	'volumenormalization' => 1,
	'volumesetdiskcount' => 1,
	'volumesetdisknumber' => 1,
	'volumesetname' => 1,
	'volumesize' => 1,
	'vorbis' => 1,
	'vorbiscomment' => 1,
	'vorbisversion' => 1,
	'vp8bitstream' => 1,
	'vp8l' => 1,
	'vp8version' => 1,
	'vp8x' => 1,
	'vrd1' => 1,
	'vrd2' => 1,
	'vrdstamptool' => 1,
	'vrdversion' => 1,
	'vrinfo' => 1,
	'vrinfoversion' => 1,
	'vw96' => 1,
	'wangannotation' => 1,
	'wangtag1' => 1,
	'wangtag3' => 1,
	'wangtag4' => 1,
	'warning' => 1,
	'warpquadrilateral' => 1,
	'watched' => 1,
	'watercolorfilter' => 1,
	'watermark' => 1,
	'watermarktype' => 1,
	'watermarkurl' => 1,
	'wave' => 1,
	'wb_bluelevelauto' => 1,
	'wb_cfa0_leveldaylight' => 1,
	'wb_cfa1_leveldaylight' => 1,
	'wb_cfa2_leveldaylight' => 1,
	'wb_cfa3_leveldaylight' => 1,
	'wb_grbglevelsauto' => 1,
	'wb_grblevels' => 1,
	'wb_grblevelsauto' => 1,
	'wb_grblevelsstandard' => 1,
	'wb_grgblevels' => 1,
	'wb_grgblevelsdaylightfluor' => 1,
	'wb_grgblevelsdaywhitefluor' => 1,
	'wb_grgblevelslivingroomwarmwhitefluor' => 1,
	'wb_grgblevelswarmwhitefluor' => 1,
	'wb_grgblevelswhitefluorescent' => 1,
	'wb_redlevelauto' => 1,
	'wb_rgbcoeffsdaylight' => 1,
	'wb_rgbcoeffsflash' => 1,
	'wb_rgbcoeffsfluorescent' => 1,
	'wb_rgbcoeffstungsten' => 1,
	'wb_rgblevels2500k' => 1,
	'wb_rgblevels3200k' => 1,
	'wb_rgblevels4500k' => 1,
	'wb_rgblevels6000k' => 1,
	'wb_rgblevels8500k' => 1,
	'wb_rgblevelsasshot' => 1,
	'wb_rgblevelscloudy' => 1,
	'wb_rgblevelscustom' => 1,
	'wb_rgblevelsfluorescentm1' => 1,
	'wb_rgblevelsfluorescentp1' => 1,
	'wb_rgblevelsfluorescentp2' => 1,
	'wb_rgblevelstungsten' => 1,
	'wbadjdata' => 1,
	'wbblueasshot' => 1,
	'wbbluecloudy' => 1,
	'wbbluedaylight' => 1,
	'wbblueflash' => 1,
	'wbbluefluorescent' => 1,
	'wbbluetungsten' => 1,
	'wbgreenasshot' => 1,
	'wbgreencloudy' => 1,
	'wbgreendaylight' => 1,
	'wbgreenflash' => 1,
	'wbgreenfluorescent' => 1,
	'wbgreentungsten' => 1,
	'wbinfo' => 1,
	'wbinfo2' => 1,
	'wbinfoa100' => 1,
	'wblevels' => 1,
	'wbredasshot' => 1,
	'wbredcloudy' => 1,
	'wbreddaylight' => 1,
	'wbredflash' => 1,
	'wbredfluorescent' => 1,
	'wbredtungsten' => 1,
	'wbsettings' => 1,
	'wbsettings2' => 1,
	'wcsprofiles' => 1,
	'webpage' => 1,
	'weight' => 1,
	'whitebalancematching' => 1,
	'whitebalancergb' => 1,
	'whitebalancetable' => 1,
	'whiteluminance' => 1,
	'whitepointx' => 1,
	'whitepointy' => 1,
	'whitesample' => 1,
	'whitesamplebits' => 1,
	'whitesampleheight' => 1,
	'whitesampleleftborder' => 1,
	'whitesampletopborder' => 1,
	'whitesamplewidth' => 1,
	'wide' => 1,
	'widthbytes' => 1,
	'widthresolution' => 1,
	'wifirssi' => 1,
	'windoworigin' => 1,
	'windoworiginauto' => 1,
	'windowsdevmode' => 1,
	'windowsfilename' => 1,
	'windowsize' => 1,
	'windowtarget' => 1,
	'wm_collectiongroupid' => 1,
	'wm_collectionid' => 1,
	'wm_contentid' => 1,
	'wm_mediaclassprimaryid' => 1,
	'wm_mediaclasssecondaryid' => 1,
	'wm_provider' => 1,
	'wmadrcaveragereference' => 1,
	'wmadrcaveragetarget' => 1,
	'wmadrcpeakreference' => 1,
	'wmadrcpeaktarget' => 1,
	'wmcollectiongroupid' => 1,
	'wmcollectionid' => 1,
	'wmcontentid' => 1,
	'wmshadowfilesourcedrmtype' => 1,
	'wmshadowfilesourcefiletype' => 1,
	'word97' => 1,
	'worddocument' => 1,
	'words' => 1,
	'workflowurl' => 1,
	'workingdirectory' => 1,
	'workingpath' => 1,
	'worldtime' => 1,
	'worldtocamera' => 1,
	'worldtondc' => 1,
	'wrapmodes' => 1,
	'writername' => 1,
	'writers' => 1,
	'writtenby' => 1,
	'wwsfamilyname' => 1,
	'wwssubfamilyname' => 1,
	'x' => 1,
	'xattrapplemaildatereceived' => 1,
	'xattrapplemaildatesent' => 1,
	'xattrapplemailisremoteattachment' => 1,
	'xattrfinderinfo' => 1,
	'xattrlastuseddate' => 1,
	'xattrmditemdownloadeddate' => 1,
	'xattrmditemfindercomment' => 1,
	'xattrmditemwherefroms' => 1,
	'xattrmdlabel' => 1,
	'xattrresourcefork' => 1,
	'xcfversion' => 1,
	'xclippathunits' => 1,
	'xheight' => 1,
	'xmag' => 1,
	'xmethod' => 1,
	'xmldata' => 1,
	'xmlfiletype' => 1,
	'xmlpackets' => 1,
	'xmp_profile' => 1,
	'xmpbj' => 1,
	'xmpdm' => 1,
	'xmpmm' => 1,
	'xmpnote' => 1,
	'xmpplus' => 1,
	'xmprights' => 1,
	'xmptpg' => 1,
	'xobject' => 1,
	'xoffset' => 1,
	'xp_dip_xml' => 1,
	'xtranslayout' => 1,
	'xylocation' => 1,
	'xyoffsetinfo' => 1,
	'yclippathunits' => 1,
	'ycrcbmatrix' => 1,
	'ylevel' => 1,
	'ymag' => 1,
	'ymethod' => 1,
	'yoffset' => 1,
	'ytarget' => 1,
	'zipbitflag' => 1,
	'zipcompressedsize' => 1,
	'zipcompression' => 1,
	'zipcrc' => 1,
	'zipfilecomment' => 1,
	'zipfilename' => 1,
	'zipmodifydate' => 1,
	'ziprequiredversion' => 1,
	'zipuncompressedsize' => 1,
	'zisrawversion' => 1,
	'zoom' => 1,
	'zoomedpreviewimage' => 1,
	'zoompos' => 1,
	'zoomposition' => 1,
	'zoomstrength' => 1,
	'zxif' => 1,
);

# module names for writable Composite tags
my %compositeModules = (
	'filenumber' => 'Image::ExifTool::Canon',
	'flash' => 'Image::ExifTool::XMP',
	'gpsposition' => 'Image::ExifTool::Exif',
	'jpgfromraw' => 'Image::ExifTool::Exif',
	'originaldecisiondata' => 'Image::ExifTool::Canon',
	'otherimage' => 'Image::ExifTool::Exif',
	'previewimage' => 'Image::ExifTool::Exif',
	'rotation' => 'Image::ExifTool::QuickTime',
	'subseccreatedate' => 'Image::ExifTool::Exif',
	'subsecdatetimeoriginal' => 'Image::ExifTool::Exif',
	'subsecmodifydate' => 'Image::ExifTool::Exif',
	'thumbnailimage' => 'Image::ExifTool::Exif',
);

#++++ End automatically generated code ++++

my %specialStruct = (
    NAMESPACE   => 1,
    STRUCT_NAME => 1,
    TYPE        => 1,
    NOTES       => 1,
    GROUPS      => 1,
);

# insert any user-defined tags into our tag lookup
if (%Image::ExifTool::UserDefined) {
    my @userTables = sort keys %Image::ExifTool::UserDefined;
    while (@userTables) {
        my $table = shift @userTables;
        AddTags($Image::ExifTool::UserDefined{$table}, $table);
    }
}

# insert any other queued tags from plug-in modules
if (@Image::ExifTool::pluginTags) {
    my $args;
    foreach $args (@Image::ExifTool::pluginTags) {
        AddTags($$args[0], $$args[1]);
    }
    undef @Image::ExifTool::pluginTags;
}


#------------------------------------------------------------------------------
# Add tag names corresponding to flattened XMP tags for all structure fields
# Inputs: 0) tag table ref for flattened tags, 1) tagID, 2) lowercase tag name,
#         3) tag ID list ref, 4) reference to list of lowercase tag names
#         5) table number in lookup, 6) tagInfo hash for parent structure
#         7) tag ID of top-level structure
# Notes: Used only for user-defined structures
sub AddFields($$$$$$;$$)
{
    my ($tagTablePtr, $tagID, $lcTag, $tagIDs, $lcTags, $tnum, $tagInfo, $baseID) = @_;
    return if length($tagID) > 500;    # avoid deep recursion
    unless ($tagInfo) {
        $tagInfo = $$tagTablePtr{$tagID};
        $baseID = $tagID;
    }
    my $strTable = $$tagInfo{Struct};
    unless (ref $strTable) {
        my $strName = $strTable;
        $strTable = $Image::ExifTool::UserDefined::xmpStruct{$strTable};
        $strTable or warn("No definition for structure '${strName}'\n"), return;
        $$strTable{STRUCT_NAME} or $$strTable{STRUCT_NAME} = "XMP $strName";
        $$tagInfo{Struct} = $strTable;  # replace name with hash ref
        delete $$tagInfo{SubDirectory}; # deprecated use of SubDirectory in Struct tags
    }
    # inherit NAMESPACE from parent table if it doesn't exist
    $$strTable{NAMESPACE} = $$tagTablePtr{NAMESPACE} unless exists $$strTable{NAMESPACE};
    my $field;
    foreach $field (keys %$strTable) {
        next if $specialStruct{$field};
        my $id = $tagID . ucfirst($field);
        # use name of existing flattened tag if already defined
        my $flatInfo = $$tagTablePtr{$id};
        my $fieldInfo = $$strTable{$field};
        my $flatName;
        $flatName = $$fieldInfo{FlatName} if ref $fieldInfo eq 'HASH';
        $flatName or ($flatName = $field) =~ tr/-_a-zA-Z0-9//dc;    # remove illegal characters
        my $lc = ($flatInfo and $$flatInfo{Name}) ? lc $$flatInfo{Name} : $lcTag . lc($flatName);
        my $copyID = $baseID;
        push @$tagIDs, \$copyID, $id;
        push @$lcTags, $lc, $lc;
        next unless ref $fieldInfo eq 'HASH' and $$fieldInfo{Struct};
        # recursively add flattened tags for all sub-fields
        AddFields($tagTablePtr, $id, $lc, $tagIDs, $lcTags, $tnum, $fieldInfo, $baseID);
    }
}

#------------------------------------------------------------------------------
# Add tags to the lookup (for user-defined tags, etc)
# Inputs: 0) tag table ref, 1) table name
my %tableNumHash;
sub AddTags($$)
{
    my ($tagTablePtr, $table) = @_;

    # generate lookup for table numbers if not done already
    unless (%tableNumHash) {
        my $tnum = 0;
        my $tbl;
        foreach $tbl (@tableList) {
            $tableNumHash{$tbl} = $tnum++;
        }
    }
    my (@moreTables, %moreTableRefs);
    for (;;) {
        my $tnum = $tableNumHash{$table};
        unless (defined $tnum) {
            # add new table to list
            $tnum = scalar @tableList;
            push @tableList, $table;
        }
        my $tagID;
        foreach $tagID (Image::ExifTool::TagTableKeys($tagTablePtr)) {
            my $newInfo = $$tagTablePtr{$tagID};
            if (ref $newInfo eq 'HASH') {
                $$newInfo{Name} or $$newInfo{Name} = Image::ExifTool::MakeTagName($tagID);
                # use new ID of tag in Composite table in case it changed
                $tagID = $$newInfo{NewTagID} if defined $$newInfo{NewTagID};
            } else {
                $newInfo = $$tagTablePtr{$tagID} = { Name => $newInfo };
            }
            my $lcTag = lc $$newInfo{Name};
            my (@lcTags, @tagIDs, $existed, $isFlat);
            # if this is a structure, add all flattened tag names to lookup
            if ($$newInfo{Struct}) {
                AddFields($tagTablePtr, $tagID, $lcTag, \@tagIDs, \@lcTags, $tnum);
            }
            # add tags to lookup even though we don't know if they are writable
            # (to save speed by not having to load the module)
Tags:       for (;;) {
                my $lookup = $tagLookup{$lcTag};
                $lookup or $lookup = $tagLookup{$lcTag} = { };
                if ($$lookup{$tnum}) {
                    my $le = $$lookup{$tnum};
                    my $ids = (ref $le eq 'ARRAY') ? $le : [ $le ];
                    if (ref $tagID) {
                        # a reference points to the tag ID of the base structure for
                        # a flattened tag.  There must be only one of these,
                        # and it must come first.
                        unshift @$ids, $tagID unless ref $$ids[0];
                    # only add new tag ID if it didn't already exist
                    } elsif (grep /^$tagID$/, @$ids) {
                        $existed = 1 unless $isFlat;
                    } else {
                        push @$ids, $tagID;
                    }
                    # only update lookup if there is now more than one entry
                    $$lookup{$tnum} = $ids if @$ids > 1;
                } else {
                    $$lookup{$tnum} = $tagID;
                }
                last unless @tagIDs;
                for (;;) {
                    $tagID = shift @tagIDs;
                    $lcTag = shift @lcTags;
                    last unless $$tagTablePtr{$tagID}; # don't waste time if it exists
                    last Tags unless @tagIDs;
                }
                $isFlat = 1;
            }
            # add any new subdirectory tables (unless done already)
            next if $existed or not $$newInfo{SubDirectory};
            my $subTable = $$newInfo{SubDirectory}{TagTable};
            next unless $subTable and not defined $tableNumHash{$subTable};
            next if $moreTableRefs{$subTable};
            no strict 'refs';
            next unless %$subTable;
            # save new table to process after this one
            push @moreTables, $subTable;
            $moreTableRefs{$subTable} = \%$subTable;
            # save source table name so we can load it when necessary
            $$subTable{SRC_TABLE} = $table;
        }
        $table = shift @moreTables or last;
        $tagTablePtr = $moreTableRefs{$table};
    }
}

#------------------------------------------------------------------------------
# Return true if the tag exists
# Inputs: 0) tag name (case insensitive)
# Returns: true if tag exists
sub TagExists($)
{
    my $tag = lc($_[0]);
    return 1 if $tagExists{$tag} or $tagLookup{$tag};
    return 0;
}

#------------------------------------------------------------------------------
# Find information for writable tags (case insensitive)
# Inputs: 0) tag name (case insensitive)
# Returns: Scalar context: tag info or false if none found
#          List context: list of all matching tagInfo hashes
sub FindTagInfo($)
{
    local $_;
    my $tag = shift;
    my $lcTag = lc($tag);
    my ($tableNum, @tagInfoList, @lookups);
    my $lookup = $tagLookup{$lcTag};
    if (not $lookup and $lcTag =~ /[?*]/) {
        # allow wildcards in tag name
        my $pat = $lcTag;
        $pat =~ s/\*/[-\\w]*/g;
        $pat =~ s/\?/[-\\w]/g;
        my @tags = grep(/^$pat$/, keys %tagLookup);
        if (@tags) {
            push @lookups, $tagLookup{$_} foreach sort @tags;
            $lookup = shift @lookups;
        }
    }
    while ($lookup) {
        foreach $tableNum (sort { $a <=> $b } keys %$lookup) {
            my $table = GetTagTable($tableList[$tableNum]);
            my $le = $$lookup{$tableNum};
            my ($tagID, $tagIDs);
            if (ref $le eq 'ARRAY') {
                $tagIDs = $le;
                # if first entry is a reference, it indicates that this is a
                # flattened tag and refers to the tag ID of the containing top-level
                # structure, so now is the time to generate the flattened tags
                if (ref $$tagIDs[0]) {
                    # (remove from the lookup since we only need to do this once)
                    my $rootIDPtr = shift @$tagIDs;
                    require Image::ExifTool::XMP;
                    Image::ExifTool::XMP::AddFlattenedTags($table, $$rootIDPtr);
                }
            } else {
                $tagIDs = [ $le ];
            }
            foreach $tagID (@$tagIDs) {
                my @infoList = GetTagInfoList($table,$tagID);
                unless (@infoList) {
                    my $reload;
                    # call write proc if it exists in case it adds tags to the table
                    my $writeProc = $table->{WRITE_PROC};
                    if ($writeProc) {
                        no strict 'refs';
                        $reload = 1 if &$writeProc();
                    }
                    # load module with composite tag if necessary
                    my $compMod = $compositeModules{$lcTag};
                    $reload = 1 if $compMod and eval "require $compMod";
                    @infoList = GetTagInfoList($table,$tagID) if $reload;
                }
                if (@infoList == 1) {
                    push @tagInfoList, @infoList;
                } elsif (@infoList > 1) {
                    my $tagInfo;
                    # must check tag list in case tags have different names
                    foreach $tagInfo (@infoList) {
                        next unless $lcTag eq lc($$tagInfo{Name});
                        push @tagInfoList, $tagInfo;
                    }
                }
            }
        }
        $lookup = shift @lookups;
    }
    if (wantarray) {
        return @tagInfoList;
    } else {
        return $tagInfoList[0];
    }
}


1;  # end

__END__

=head1 NAME

Image::ExifTool::TagLookup - Fast lookup for ExifTool tags

=head1 SYNOPSIS

This module is required by Image::ExifTool for writing tags.

=head1 DESCRIPTION

Provides a fast, case insensitive lookup for tag names.

=head1 AUTHOR

Copyright 2003-2022, Phil Harvey (philharvey66 at gmail.com)

This library is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

=head1 SEE ALSO

L<Image::ExifTool(3pm)|Image::ExifTool>,
L<Image::ExifTool::BuildTagLookup(3pm)|Image::ExifTool::BuildTagLookup>,
L<Image::ExifTool::TagNames(3pm)|Image::ExifTool::TagNames>

=cut
