/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.preparator.extension;

import de.rub.nds.modifiablevariable.bytearray.ModifiableByteArray;
import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.constants.SrtpProtectionProfiles;
import de.rub.nds.tlsattacker.core.protocol.message.extension.SrtpExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.preparator.extension.ExtensionPreparator;
import de.rub.nds.tlsattacker.core.protocol.serializer.extension.ExtensionSerializer;
import de.rub.nds.tlsattacker.core.workflow.chooser.Chooser;
import java.io.ByteArrayOutputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SrtpExtensionPreparator
extends ExtensionPreparator<SrtpExtensionMessage> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final SrtpExtensionMessage msg;

    public SrtpExtensionPreparator(Chooser chooser, SrtpExtensionMessage message, ExtensionSerializer<SrtpExtensionMessage> serializer) {
        super(chooser, message, serializer);
        this.msg = message;
    }

    @Override
    public void prepareExtensionContent() {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        for (SrtpProtectionProfiles profile : this.chooser.getConfig().getSecureRealTimeTransportProtocolProtectionProfiles()) {
            byteStream.write(profile.getMinor());
            byteStream.write(profile.getMajor());
        }
        this.msg.setSrtpProtectionProfiles(byteStream.toByteArray());
        LOGGER.debug("Prepared the SRTP extension with protection profiles " + ArrayConverter.bytesToHexString((ModifiableByteArray)this.msg.getSrtpProtectionProfiles()));
        this.msg.setSrtpProtectionProfilesLength(((byte[])this.msg.getSrtpProtectionProfiles().getValue()).length);
        LOGGER.debug("Prepared the SRTP extension with protection profiles length " + this.msg.getSrtpProtectionProfilesLength().getValue());
        if (this.chooser.getConfig().getSecureRealTimeTransportProtocolMasterKeyIdentifier().length != 0) {
            this.msg.setSrtpMki(this.chooser.getConfig().getSecureRealTimeTransportProtocolMasterKeyIdentifier());
            LOGGER.debug("Prepared the SRTP extension with MKI " + ArrayConverter.bytesToHexString((ModifiableByteArray)this.msg.getSrtpMki()));
            this.msg.setSrtpMkiLength(((byte[])this.msg.getSrtpMki().getValue()).length);
            LOGGER.debug("Prepared the SRTP extension with mki length " + this.msg.getSrtpMkiLength().getValue());
        } else {
            this.msg.setSrtpMki(this.chooser.getConfig().getSecureRealTimeTransportProtocolMasterKeyIdentifier());
            this.msg.setSrtpMkiLength(0);
            LOGGER.debug("Prepared the SRTP extension with no MKI, hence the length is 0");
        }
    }
}

