/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkSubmitInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int WAITSEMAPHORECOUNT;
    public static final int PWAITSEMAPHORES;
    public static final int PWAITDSTSTAGEMASK;
    public static final int COMMANDBUFFERCOUNT;
    public static final int PCOMMANDBUFFERS;
    public static final int SIGNALSEMAPHORECOUNT;
    public static final int PSIGNALSEMAPHORES;

    public VkSubmitInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkSubmitInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkSubmitInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkSubmitInfo.npNext(this.address());
    }

    @NativeType(value="uint32_t")
    public int waitSemaphoreCount() {
        return VkSubmitInfo.nwaitSemaphoreCount(this.address());
    }

    @Nullable
    @NativeType(value="VkSemaphore const *")
    public LongBuffer pWaitSemaphores() {
        return VkSubmitInfo.npWaitSemaphores(this.address());
    }

    @Nullable
    @NativeType(value="VkPipelineStageFlags const *")
    public IntBuffer pWaitDstStageMask() {
        return VkSubmitInfo.npWaitDstStageMask(this.address());
    }

    @NativeType(value="uint32_t")
    public int commandBufferCount() {
        return VkSubmitInfo.ncommandBufferCount(this.address());
    }

    @Nullable
    @NativeType(value="VkCommandBuffer const *")
    public PointerBuffer pCommandBuffers() {
        return VkSubmitInfo.npCommandBuffers(this.address());
    }

    @NativeType(value="uint32_t")
    public int signalSemaphoreCount() {
        return VkSubmitInfo.nsignalSemaphoreCount(this.address());
    }

    @Nullable
    @NativeType(value="VkSemaphore const *")
    public LongBuffer pSignalSemaphores() {
        return VkSubmitInfo.npSignalSemaphores(this.address());
    }

    public VkSubmitInfo sType(@NativeType(value="VkStructureType") int value) {
        VkSubmitInfo.nsType(this.address(), value);
        return this;
    }

    public VkSubmitInfo pNext(@NativeType(value="void const *") long value) {
        VkSubmitInfo.npNext(this.address(), value);
        return this;
    }

    public VkSubmitInfo waitSemaphoreCount(@NativeType(value="uint32_t") int value) {
        VkSubmitInfo.nwaitSemaphoreCount(this.address(), value);
        return this;
    }

    public VkSubmitInfo pWaitSemaphores(@Nullable @NativeType(value="VkSemaphore const *") LongBuffer value) {
        VkSubmitInfo.npWaitSemaphores(this.address(), value);
        return this;
    }

    public VkSubmitInfo pWaitDstStageMask(@Nullable @NativeType(value="VkPipelineStageFlags const *") IntBuffer value) {
        VkSubmitInfo.npWaitDstStageMask(this.address(), value);
        return this;
    }

    public VkSubmitInfo pCommandBuffers(@Nullable @NativeType(value="VkCommandBuffer const *") PointerBuffer value) {
        VkSubmitInfo.npCommandBuffers(this.address(), value);
        return this;
    }

    public VkSubmitInfo pSignalSemaphores(@Nullable @NativeType(value="VkSemaphore const *") LongBuffer value) {
        VkSubmitInfo.npSignalSemaphores(this.address(), value);
        return this;
    }

    public VkSubmitInfo set(int sType, long pNext, int waitSemaphoreCount, @Nullable LongBuffer pWaitSemaphores, @Nullable IntBuffer pWaitDstStageMask, @Nullable PointerBuffer pCommandBuffers, @Nullable LongBuffer pSignalSemaphores) {
        this.sType(sType);
        this.pNext(pNext);
        this.waitSemaphoreCount(waitSemaphoreCount);
        this.pWaitSemaphores(pWaitSemaphores);
        this.pWaitDstStageMask(pWaitDstStageMask);
        this.pCommandBuffers(pCommandBuffers);
        this.pSignalSemaphores(pSignalSemaphores);
        return this;
    }

    public VkSubmitInfo set(VkSubmitInfo src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkSubmitInfo malloc() {
        return (VkSubmitInfo)VkSubmitInfo.wrap(VkSubmitInfo.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkSubmitInfo calloc() {
        return (VkSubmitInfo)VkSubmitInfo.wrap(VkSubmitInfo.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkSubmitInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkSubmitInfo)VkSubmitInfo.wrap(VkSubmitInfo.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkSubmitInfo create(long address) {
        return (VkSubmitInfo)VkSubmitInfo.wrap(VkSubmitInfo.class, (long)address);
    }

    @Nullable
    public static VkSubmitInfo createSafe(long address) {
        return address == 0L ? null : (VkSubmitInfo)VkSubmitInfo.wrap(VkSubmitInfo.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkSubmitInfo.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkSubmitInfo.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkSubmitInfo.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkSubmitInfo.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkSubmitInfo.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkSubmitInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkSubmitInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VkSubmitInfo mallocStack() {
        return VkSubmitInfo.mallocStack(MemoryStack.stackGet());
    }

    public static VkSubmitInfo callocStack() {
        return VkSubmitInfo.callocStack(MemoryStack.stackGet());
    }

    public static VkSubmitInfo mallocStack(MemoryStack stack) {
        return (VkSubmitInfo)VkSubmitInfo.wrap(VkSubmitInfo.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkSubmitInfo callocStack(MemoryStack stack) {
        return (VkSubmitInfo)VkSubmitInfo.wrap(VkSubmitInfo.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkSubmitInfo.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkSubmitInfo.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkSubmitInfo.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkSubmitInfo.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static int nwaitSemaphoreCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)WAITSEMAPHORECOUNT);
    }

    @Nullable
    public static LongBuffer npWaitSemaphores(long struct) {
        return MemoryUtil.memLongBufferSafe((long)MemoryUtil.memGetAddress((long)(struct + (long)PWAITSEMAPHORES)), (int)VkSubmitInfo.nwaitSemaphoreCount(struct));
    }

    @Nullable
    public static IntBuffer npWaitDstStageMask(long struct) {
        return MemoryUtil.memIntBufferSafe((long)MemoryUtil.memGetAddress((long)(struct + (long)PWAITDSTSTAGEMASK)), (int)VkSubmitInfo.nwaitSemaphoreCount(struct));
    }

    public static int ncommandBufferCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)COMMANDBUFFERCOUNT);
    }

    @Nullable
    public static PointerBuffer npCommandBuffers(long struct) {
        return MemoryUtil.memPointerBufferSafe((long)MemoryUtil.memGetAddress((long)(struct + (long)PCOMMANDBUFFERS)), (int)VkSubmitInfo.ncommandBufferCount(struct));
    }

    public static int nsignalSemaphoreCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)SIGNALSEMAPHORECOUNT);
    }

    @Nullable
    public static LongBuffer npSignalSemaphores(long struct) {
        return MemoryUtil.memLongBufferSafe((long)MemoryUtil.memGetAddress((long)(struct + (long)PSIGNALSEMAPHORES)), (int)VkSubmitInfo.nsignalSemaphoreCount(struct));
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void nwaitSemaphoreCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)WAITSEMAPHORECOUNT, value);
    }

    public static void npWaitSemaphores(long struct, @Nullable LongBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PWAITSEMAPHORES), (long)MemoryUtil.memAddressSafe((LongBuffer)value));
    }

    public static void npWaitDstStageMask(long struct, @Nullable IntBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PWAITDSTSTAGEMASK), (long)MemoryUtil.memAddressSafe((IntBuffer)value));
    }

    public static void ncommandBufferCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)COMMANDBUFFERCOUNT, value);
    }

    public static void npCommandBuffers(long struct, @Nullable PointerBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PCOMMANDBUFFERS), (long)MemoryUtil.memAddressSafe((Pointer)value));
        VkSubmitInfo.ncommandBufferCount(struct, value == null ? 0 : value.remaining());
    }

    public static void nsignalSemaphoreCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SIGNALSEMAPHORECOUNT, value);
    }

    public static void npSignalSemaphores(long struct, @Nullable LongBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PSIGNALSEMAPHORES), (long)MemoryUtil.memAddressSafe((LongBuffer)value));
        VkSubmitInfo.nsignalSemaphoreCount(struct, value == null ? 0 : value.remaining());
    }

    public static void validate(long struct) {
        if (VkSubmitInfo.nwaitSemaphoreCount(struct) != 0) {
            Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PWAITSEMAPHORES)));
            Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PWAITDSTSTAGEMASK)));
        }
        if (VkSubmitInfo.ncommandBufferCount(struct) != 0) {
            Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PCOMMANDBUFFERS)));
        }
        if (VkSubmitInfo.nsignalSemaphoreCount(struct) != 0) {
            Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PSIGNALSEMAPHORES)));
        }
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            VkSubmitInfo.validate(array + Integer.toUnsignedLong(i) * (long)SIZEOF);
        }
    }

    static {
        Struct.Layout layout = VkSubmitInfo.__struct((Struct.Member[])new Struct.Member[]{VkSubmitInfo.__member((int)4), VkSubmitInfo.__member((int)POINTER_SIZE), VkSubmitInfo.__member((int)4), VkSubmitInfo.__member((int)POINTER_SIZE), VkSubmitInfo.__member((int)POINTER_SIZE), VkSubmitInfo.__member((int)4), VkSubmitInfo.__member((int)POINTER_SIZE), VkSubmitInfo.__member((int)4), VkSubmitInfo.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        WAITSEMAPHORECOUNT = layout.offsetof(2);
        PWAITSEMAPHORES = layout.offsetof(3);
        PWAITDSTSTAGEMASK = layout.offsetof(4);
        COMMANDBUFFERCOUNT = layout.offsetof(5);
        PCOMMANDBUFFERS = layout.offsetof(6);
        SIGNALSEMAPHORECOUNT = layout.offsetof(7);
        PSIGNALSEMAPHORES = layout.offsetof(8);
    }

    public static class Buffer
    extends StructBuffer<VkSubmitInfo, Buffer>
    implements NativeResource {
        private static final VkSubmitInfo ELEMENT_FACTORY = VkSubmitInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkSubmitInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkSubmitInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkSubmitInfo.npNext(this.address());
        }

        @NativeType(value="uint32_t")
        public int waitSemaphoreCount() {
            return VkSubmitInfo.nwaitSemaphoreCount(this.address());
        }

        @Nullable
        @NativeType(value="VkSemaphore const *")
        public LongBuffer pWaitSemaphores() {
            return VkSubmitInfo.npWaitSemaphores(this.address());
        }

        @Nullable
        @NativeType(value="VkPipelineStageFlags const *")
        public IntBuffer pWaitDstStageMask() {
            return VkSubmitInfo.npWaitDstStageMask(this.address());
        }

        @NativeType(value="uint32_t")
        public int commandBufferCount() {
            return VkSubmitInfo.ncommandBufferCount(this.address());
        }

        @Nullable
        @NativeType(value="VkCommandBuffer const *")
        public PointerBuffer pCommandBuffers() {
            return VkSubmitInfo.npCommandBuffers(this.address());
        }

        @NativeType(value="uint32_t")
        public int signalSemaphoreCount() {
            return VkSubmitInfo.nsignalSemaphoreCount(this.address());
        }

        @Nullable
        @NativeType(value="VkSemaphore const *")
        public LongBuffer pSignalSemaphores() {
            return VkSubmitInfo.npSignalSemaphores(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkSubmitInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkSubmitInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer waitSemaphoreCount(@NativeType(value="uint32_t") int value) {
            VkSubmitInfo.nwaitSemaphoreCount(this.address(), value);
            return this;
        }

        public Buffer pWaitSemaphores(@Nullable @NativeType(value="VkSemaphore const *") LongBuffer value) {
            VkSubmitInfo.npWaitSemaphores(this.address(), value);
            return this;
        }

        public Buffer pWaitDstStageMask(@Nullable @NativeType(value="VkPipelineStageFlags const *") IntBuffer value) {
            VkSubmitInfo.npWaitDstStageMask(this.address(), value);
            return this;
        }

        public Buffer pCommandBuffers(@Nullable @NativeType(value="VkCommandBuffer const *") PointerBuffer value) {
            VkSubmitInfo.npCommandBuffers(this.address(), value);
            return this;
        }

        public Buffer pSignalSemaphores(@Nullable @NativeType(value="VkSemaphore const *") LongBuffer value) {
            VkSubmitInfo.npSignalSemaphores(this.address(), value);
            return this;
        }
    }
}

