/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.datatype.microsoft;

import ghidra.app.util.datatype.microsoft.DataValidationOptions;
import ghidra.app.util.datatype.microsoft.MSDataTypeUtils;
import ghidra.app.util.datatype.microsoft.RTTI2DataType;
import ghidra.app.util.datatype.microsoft.RTTIDataType;
import ghidra.docking.settings.Settings;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DWordDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DynamicDataType;
import ghidra.program.model.data.InvalidDataTypeException;
import ghidra.program.model.data.ReadOnlyDataTypeComponent;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.scalar.Scalar;
import ghidra.util.Msg;

@Deprecated
public class RTTI3DataType
extends RTTIDataType {
    private static final int MAX_RTTI_1_COUNT = 1000;
    private static final long serialVersionUID = 1L;
    private static final int LENGTH = 16;
    private static final int SIGNATURE_OFFSET = 0;
    private static final int ATTRIBUTES_OFFSET = 4;
    private static final int RTTI_1_COUNT_OFFSET = 8;
    private static final int RTTI_2_POINTER_OFFSET = 12;
    private DataTypeComponent[] fixedComps;

    public RTTI3DataType() {
        this(null);
    }

    public RTTI3DataType(DataTypeManager dtm) {
        super("RTTI_3", dtm);
        this.buildFixedComponents();
    }

    public DataType clone(DataTypeManager dtm) {
        if (dtm == this.getDataTypeManager()) {
            return this;
        }
        return new RTTI3DataType(dtm);
    }

    private void buildFixedComponents() {
        this.fixedComps = new DataTypeComponent[3];
        this.fixedComps[0] = new ReadOnlyDataTypeComponent((DataType)new DWordDataType(), (DynamicDataType)this, 4, 0, 0, "signature", null);
        this.fixedComps[1] = new ReadOnlyDataTypeComponent((DataType)new DWordDataType(), (DynamicDataType)this, 4, 1, 4, "attributes", "bit flags");
        this.fixedComps[2] = new ReadOnlyDataTypeComponent((DataType)new DWordDataType(), (DynamicDataType)this, 4, 2, 8, "numBaseClasses", "number of base classes (i.e. rtti1Count)");
    }

    public String getDescription() {
        return "RTTI 3 (RTTI Class Hierarchy Descriptor) Structure";
    }

    public String getMnemonic(Settings settings) {
        return "RTTI_3";
    }

    public int getLength() {
        return 16;
    }

    public String getRepresentation(MemBuffer buf, Settings settings, int length) {
        return "";
    }

    public Object getValue(MemBuffer buf, Settings settings, int length) {
        return null;
    }

    protected DataTypeComponent[] getAllComponents(MemBuffer buf) {
        Program program = buf.getMemory().getProgram();
        DataTypeManager dtm = program.getDataTypeManager();
        long rtti1Count = this.getRtti1Count(buf.getMemory(), buf.getAddress());
        RTTI2DataType rtti2Dt = new RTTI2DataType(rtti1Count, dtm);
        DataType rtti2RefDt = MSDataTypeUtils.getReferenceDataType(program, (DataType)rtti2Dt);
        DataTypeComponent[] comps = new DataTypeComponent[4];
        System.arraycopy(this.fixedComps, 0, comps, 0, 3);
        comps[3] = new ReadOnlyDataTypeComponent(rtti2RefDt, (DynamicDataType)this, 4, 3, 12, "pBaseClassArray", MSDataTypeUtils.is64Bit(program) ? "rtti1MapDisplacement" : "rtti1MapPointer");
        return comps;
    }

    public int getLength(Memory memory, Address address, byte[] bytes) {
        if (address.getOffset() % 4L != 0L) {
            return 0;
        }
        if (bytes.length < 16) {
            return 0;
        }
        long rtti1Count = this.getRtti1Count(memory, address);
        if (rtti1Count < 0L || rtti1Count > 500L) {
            return 0;
        }
        Address rtti2Address = this.getRtti2Address(memory, address);
        if (!memory.contains(rtti2Address)) {
            return 0;
        }
        return 16;
    }

    public long getRtti1Count(Memory memory, Address rtti3Address) {
        Address rtti1CountAddress = rtti3Address.add(8L);
        try {
            long rtti1Count = new Scalar(32, (long)memory.getInt(rtti1CountAddress, memory.isBigEndian())).getValue();
            return rtti1Count;
        }
        catch (MemoryAccessException e) {
            Msg.error((Object)((Object)this), (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
            return 0L;
        }
    }

    public Address getRtti2Address(Memory memory, Address rtti3Address) {
        Address rtti2CompAddress;
        Program program = memory.getProgram();
        Address pointedToAddress = MSDataTypeUtils.getReferencedAddress(program, rtti2CompAddress = rtti3Address.add(12L));
        if (pointedToAddress == null || !memory.contains(pointedToAddress)) {
            return null;
        }
        return pointedToAddress;
    }

    @Override
    public boolean isValid(Program program, Address startAddress, DataValidationOptions validationOptions) {
        Memory memory = program.getMemory();
        if (!memory.contains(startAddress)) {
            return false;
        }
        if (startAddress.getOffset() % 4L != 0L) {
            return false;
        }
        Listing listing = program.getListing();
        Address endAddress = startAddress.add(15L);
        try {
            MSDataTypeUtils.getBytes(memory, startAddress, 16);
        }
        catch (InvalidDataTypeException e) {
            return false;
        }
        if (!validationOptions.shouldIgnoreInstructions() && this.containsInstruction(listing, startAddress, endAddress)) {
            return false;
        }
        if (!validationOptions.shouldIgnoreDefinedData() && this.containsDefinedData(listing, startAddress, endAddress)) {
            return false;
        }
        long rtti1Count = this.getRtti1Count(memory, startAddress);
        if (rtti1Count < 0L || rtti1Count > 1000L) {
            return false;
        }
        boolean validateReferredToData = validationOptions.shouldValidateReferredToData();
        Address rtti2Address = this.getRtti2Address(memory, startAddress);
        RTTI2DataType rtti2 = new RTTI2DataType(rtti1Count, program.getDataTypeManager());
        return rtti2Address != null && (!validateReferredToData || rtti2.isValid(program, rtti2Address, validationOptions));
    }

    public String getDefaultLabelPrefix() {
        return "RTTI_3";
    }
}

