/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.strings;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.DialogComponentProvider;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.MenuData;
import docking.action.ToolBarData;
import ghidra.app.events.ProgramSelectionPluginEvent;
import ghidra.app.plugin.ProgramPlugin;
import ghidra.app.plugin.core.data.DataSettingsDialog;
import ghidra.app.plugin.core.strings.ViewStringsProvider;
import ghidra.app.services.GoToService;
import ghidra.framework.model.DomainObjectChangeRecord;
import ghidra.framework.model.DomainObjectChangedEvent;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramChangeRecord;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;
import ghidra.util.HelpLocation;
import ghidra.util.exception.CancelledException;
import ghidra.util.table.SelectionNavigationAction;
import ghidra.util.table.actions.MakeProgramSelectionAction;
import ghidra.util.task.SwingUpdateManager;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import resources.Icons;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Common", shortDescription="Defined String Table", description="Displays all defined strings in the current program.", servicesRequired={GoToService.class})
public class ViewStringsPlugin
extends ProgramPlugin
implements DomainObjectListener {
    private DockingAction selectAction;
    private DockingAction showSettingsAction;
    private DockingAction showDefaultSettingsAction;
    private SelectionNavigationAction linkNavigationAction;
    private ViewStringsProvider provider;
    private SwingUpdateManager reloadUpdateMgr;

    public ViewStringsPlugin(PluginTool tool) {
        super(tool, false, false);
    }

    void doReload() {
        this.provider.reload();
    }

    protected void init() {
        super.init();
        this.provider = new ViewStringsProvider(this);
        this.reloadUpdateMgr = new SwingUpdateManager(100, 60000, this::doReload);
        this.createActions();
    }

    private void createActions() {
        DockingAction refreshAction = new DockingAction("Refresh Strings", this.getName()){

            public boolean isEnabledForContext(ActionContext context) {
                return ViewStringsPlugin.this.getCurrentProgram() != null;
            }

            public void actionPerformed(ActionContext context) {
                ViewStringsPlugin.this.reload();
            }
        };
        ImageIcon refreshIcon = Icons.REFRESH_ICON;
        refreshAction.setDescription("Reloads all string data from the program");
        refreshAction.setToolBarData(new ToolBarData((Icon)refreshIcon));
        refreshAction.setHelpLocation(new HelpLocation("ViewStringsPlugin", "Refresh"));
        this.tool.addLocalAction((ComponentProvider)this.provider, (DockingActionIf)refreshAction);
        this.tool.addLocalAction((ComponentProvider)this.provider, (DockingActionIf)new MakeProgramSelectionAction(this, this.provider.getTable()));
        this.linkNavigationAction = new SelectionNavigationAction(this, this.provider.getTable());
        this.tool.addLocalAction((ComponentProvider)this.provider, (DockingActionIf)this.linkNavigationAction);
        this.showSettingsAction = new DockingAction("Settings", this.getName()){

            public void actionPerformed(ActionContext context) {
                try {
                    DataSettingsDialog dialog = ViewStringsPlugin.this.provider.getSelectedRowCount() == 1 ? new DataSettingsDialog(ViewStringsPlugin.this.currentProgram, ViewStringsPlugin.this.provider.getSelectedData()) : new DataSettingsDialog(ViewStringsPlugin.this.currentProgram, ViewStringsPlugin.this.provider.selectData());
                    ViewStringsPlugin.this.tool.showDialog((DialogComponentProvider)dialog);
                    dialog.dispose();
                }
                catch (CancelledException cancelledException) {
                    // empty catch block
                }
            }
        };
        this.showSettingsAction.setPopupMenuData(new MenuData(new String[]{"Settings..."}, "R"));
        this.showSettingsAction.setDescription("Shows settings for the selected strings");
        this.showSettingsAction.setHelpLocation(new HelpLocation("DataPlugin", "Data_Settings"));
        this.showDefaultSettingsAction = new DockingAction("Default Settings", this.getName()){

            public void actionPerformed(ActionContext context) {
                Data data = ViewStringsPlugin.this.provider.getSelectedData();
                DataSettingsDialog dataSettingsDialog = new DataSettingsDialog(ViewStringsPlugin.this.getCurrentProgram(), data.getDataType());
                ViewStringsPlugin.this.tool.showDialog((DialogComponentProvider)dataSettingsDialog);
                dataSettingsDialog.dispose();
            }

            public boolean isEnabledForContext(ActionContext context) {
                return ViewStringsPlugin.this.provider.getSelectedRowCount() == 1;
            }
        };
        this.showDefaultSettingsAction.setPopupMenuData(new MenuData(new String[]{"Default Settings..."}, "R"));
        this.showDefaultSettingsAction.setDescription("Shows settings for the selected string data type");
        this.showDefaultSettingsAction.setHelpLocation(new HelpLocation("DataPlugin", "Default_Data_Settings"));
        this.tool.addLocalAction((ComponentProvider)this.provider, (DockingActionIf)this.showSettingsAction);
        this.tool.addLocalAction((ComponentProvider)this.provider, (DockingActionIf)this.showDefaultSettingsAction);
    }

    private void selectData(ProgramSelection selection) {
        ProgramSelectionPluginEvent pspe = new ProgramSelectionPluginEvent("Selection", selection, this.currentProgram);
        this.firePluginEvent(pspe);
        this.processEvent(pspe);
    }

    public void dispose() {
        this.reloadUpdateMgr.dispose();
        this.provider.dispose();
        super.dispose();
    }

    @Override
    protected void programDeactivated(Program program) {
        program.removeListener((DomainObjectListener)this);
        this.provider.setProgram(null);
    }

    @Override
    protected void programActivated(Program program) {
        program.addListener((DomainObjectListener)this);
        this.provider.setProgram(program);
    }

    @Override
    protected void locationChanged(ProgramLocation loc) {
        if (this.linkNavigationAction.isSelected() && loc != null) {
            this.provider.setProgram(loc.getProgram());
            this.provider.showProgramLocation(loc);
        }
    }

    public void domainObjectChanged(DomainObjectChangedEvent ev) {
        if (ev.containsEvent(4) || ev.containsEvent(23) || ev.containsEvent(21) || ev.containsEvent(31) || ev.containsEvent(108)) {
            this.reload();
        } else if (ev.containsEvent(30)) {
            block4: for (int i = 0; i < ev.numRecords(); ++i) {
                DomainObjectChangeRecord doRecord = ev.getChangeRecord(i);
                Object newValue = doRecord.getNewValue();
                switch (doRecord.getEventType()) {
                    case 31: 
                    case 33: {
                        ProgramChangeRecord pcRec = (ProgramChangeRecord)doRecord;
                        this.provider.remove(pcRec.getStart(), pcRec.getEnd());
                        continue block4;
                    }
                    case 30: {
                        if (!(newValue instanceof Data)) continue block4;
                        this.provider.add((Data)newValue);
                        continue block4;
                    }
                }
            }
        } else if (ev.containsEvent(109)) {
            this.provider.getComponent().repaint();
        }
    }

    void reload() {
        this.reloadUpdateMgr.update();
    }
}

