/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.register;

import docking.DialogComponentProvider;
import docking.widgets.OptionDialog;
import docking.widgets.table.AbstractSortedTableModel;
import ghidra.app.cmd.register.SetRegisterCmd;
import ghidra.app.events.ProgramSelectionPluginEvent;
import ghidra.app.plugin.core.register.EditRegisterValueDialog;
import ghidra.app.plugin.core.register.RegisterManagerProvider;
import ghidra.app.plugin.core.register.RegisterValueRange;
import ghidra.app.plugin.core.register.RegisterValueRangeComparator;
import ghidra.app.plugin.core.register.RegisterValueRenderer;
import ghidra.app.services.GoToService;
import ghidra.app.services.MarkerService;
import ghidra.app.services.MarkerSet;
import ghidra.framework.cmd.Command;
import ghidra.framework.cmd.CompoundCmd;
import ghidra.framework.model.DomainObject;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramContext;
import ghidra.program.util.CombinedAddressRangeIterator;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;
import ghidra.util.table.GhidraTable;
import ghidra.util.table.ProgramTableModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

class RegisterValuesPanel
extends JPanel {
    private static final String VALUE_COLUMN_NAME = "Value";
    private static final String START_ADDRESS_COLUMN_NAME = "Start Address";
    private static final String END_ADDRESS_COLUMN_NAME = "End Address";
    private static final Color REGISTER_MARKER_COLOR = new Color(0, 153, 153);
    private Program currentProgram;
    private GhidraTable table;
    private Register selectedRegister;
    private PluginTool tool;
    private MarkerSet markerSet;
    private boolean includeDefaultValues;
    private RegisterValuesTableModel model;
    private AddressSet markerAddressSet;
    private boolean isShowing;
    private final RegisterManagerProvider provider;

    RegisterValuesPanel(PluginTool tool, RegisterManagerProvider provider) {
        this.tool = tool;
        this.provider = provider;
        this.setLayout(new BorderLayout());
        this.table = this.createBasicTable();
        this.add((Component)new JScrollPane((Component)((Object)this.table)), "Center");
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int row = RegisterValuesPanel.this.table.rowAtPoint(e.getPoint());
                int col = RegisterValuesPanel.this.table.columnAtPoint(e.getPoint());
                col = RegisterValuesPanel.this.table.convertColumnIndexToModel(col);
                if (e.getClickCount() == 2 && row >= 0) {
                    RegisterValuesPanel.this.editRow(row);
                }
            }
        });
        this.table.setDefaultRenderer(RegisterValueRange.class, (TableCellRenderer)((Object)new RegisterValueRenderer((JTable)((Object)this.table))));
    }

    private void editRow(int row) {
        RegisterValueRange range = this.model.values.get(row);
        Address start = range.getStartAddress();
        Address end = range.getEndAddress();
        BigInteger value = range.getValue();
        EditRegisterValueDialog dialog = new EditRegisterValueDialog(this.selectedRegister, start, end, value, this.currentProgram.getAddressFactory());
        this.tool.showDialog((DialogComponentProvider)dialog, (Component)this);
        if (!dialog.wasCancelled()) {
            Address newStart = dialog.getStartAddress();
            Address newEnd = dialog.getEndAddress();
            BigInteger newValue = dialog.getValue();
            this.updateValue(start, end, newStart, newEnd, newValue);
        }
    }

    private void updateValue(Address start, Address end, Address newStart, Address newEnd, BigInteger newValue) {
        CompoundCmd cmd = new CompoundCmd("Update Register Range");
        SetRegisterCmd cmd1 = new SetRegisterCmd(this.selectedRegister, start, end, null);
        SetRegisterCmd cmd2 = new SetRegisterCmd(this.selectedRegister, newStart, newEnd, newValue);
        cmd.add((Command)cmd1);
        cmd.add((Command)cmd2);
        this.tool.execute((Command)cmd, (DomainObject)this.currentProgram);
    }

    private GhidraTable createBasicTable() {
        this.model = new RegisterValuesTableModel();
        this.table = new GhidraTable((TableModel)((Object)this.model));
        this.table.setSelectionMode(2);
        this.table.setRowSelectionAllowed(true);
        this.table.setColumnSelectionAllowed(false);
        GoToService goToService = (GoToService)this.tool.getService(GoToService.class);
        this.table.installNavigation(goToService, goToService.getDefaultNavigatable());
        this.table.setNavigateOnSelectionEnabled(true);
        return this.table;
    }

    GhidraTable getTable() {
        return this.table;
    }

    void setProgram(Program program) {
        this.clearMarkers(this.currentProgram);
        this.currentProgram = program;
        this.setRegister(null);
    }

    void setRegister(Register register) {
        this.selectedRegister = register;
        if (!this.isShowing) {
            return;
        }
        try {
            AddressSet set = new AddressSet();
            ArrayList<RegisterValueRange> data = new ArrayList<RegisterValueRange>();
            if (register != null) {
                ProgramContext context = this.currentProgram.getProgramContext();
                AddressRangeIterator registerValueAddressRanges = context.getRegisterValueAddressRanges(register);
                if (this.includeDefaultValues) {
                    AddressRangeIterator defaultIt = context.getDefaultRegisterValueAddressRanges(register);
                    registerValueAddressRanges = new CombinedAddressRangeIterator(registerValueAddressRanges, defaultIt);
                }
                try {
                    RegisterValueRange lastValueRange = null;
                    while (registerValueAddressRanges.hasNext()) {
                        AddressRange range = (AddressRange)registerValueAddressRanges.next();
                        BigInteger value = context.getValue(register, range.getMinAddress(), false);
                        if (value == null) continue;
                        boolean isDefault = this.checkIsDefaultValue(register, context, range, value);
                        if (lastValueRange != null && lastValueRange.getValue().equals(value) && this.isNextAddress(lastValueRange.getEndAddress(), range.getMinAddress())) {
                            lastValueRange.setEndAddress(range.getMaxAddress());
                        } else {
                            lastValueRange = new RegisterValueRange(range, value, isDefault);
                            data.add(lastValueRange);
                        }
                        if (isDefault) continue;
                        set.add(range);
                    }
                }
                catch (ConcurrentModificationException concurrentModificationException) {
                    // empty catch block
                }
            }
            this.model.setValues(data);
            this.markerAddressSet = set;
            this.updateMarkers();
        }
        catch (ConcurrentModificationException e) {
            this.provider.scheduleUpdate();
        }
    }

    private boolean isNextAddress(Address addr1, Address addr2) {
        if (addr1.getAddressSpace() != addr2.getAddressSpace()) {
            return false;
        }
        return addr1.next().equals((Object)addr2);
    }

    private boolean checkIsDefaultValue(Register register, ProgramContext context, AddressRange range, BigInteger value) {
        BigInteger defaultValue;
        if (!this.includeDefaultValues) {
            return false;
        }
        RegisterValue defaultRegsiterValue = context.getDefaultValue(register, range.getMinAddress());
        return defaultRegsiterValue != null && defaultRegsiterValue.hasValue() && value.equals(defaultValue = defaultRegsiterValue.getUnsignedValue());
    }

    void updateMarkers() {
        MarkerService service = (MarkerService)this.tool.getService(MarkerService.class);
        if (service == null) {
            return;
        }
        if (this.currentProgram == null) {
            return;
        }
        if (this.markerSet == null) {
            this.markerSet = service.createAreaMarker("Register Values", "Area where selected register has defined values", this.currentProgram, 0, true, true, false, REGISTER_MARKER_COLOR);
        }
        this.markerSet.clearAll();
        this.markerSet.add((AddressSetView)this.markerAddressSet);
    }

    private void clearMarkers(Program program) {
        if (this.markerSet == null || program == null) {
            return;
        }
        MarkerService service = (MarkerService)this.tool.getService(MarkerService.class);
        if (service == null) {
            return;
        }
        service.removeMarker(this.markerSet, program);
        this.markerSet = null;
    }

    void deleteSelectedRanges() {
        int result;
        CompoundCmd cmd = new CompoundCmd("Delete Register Value Ranges");
        int[] rows = this.table.getSelectedRows();
        boolean containsDefaultValues = false;
        for (int row : rows) {
            RegisterValueRange rvr = this.model.values.get(row);
            if (rvr.isDefault()) {
                containsDefaultValues = true;
            }
            cmd.add((Command)new SetRegisterCmd(this.selectedRegister, rvr.getStartAddress(), rvr.getEndAddress(), null));
        }
        if (containsDefaultValues && (result = OptionDialog.showOptionDialog((Component)((Object)this.table), (String)"Warning", (String)"The selected ranges contain default values that can't be deleted.\n  Do you want to continue?", (String)"Yes", (int)2)) == 0) {
            return;
        }
        if (cmd.size() > 0) {
            this.tool.execute((Command)cmd, (DomainObject)this.currentProgram);
        }
    }

    void selectedRanges() {
        int[] rows = this.table.getSelectedRows();
        AddressSet set = new AddressSet();
        for (int element : rows) {
            Address start = (Address)this.model.getValueAt(element, 0);
            Address end = (Address)this.model.getValueAt(element, 1);
            set.addRange(start, end);
        }
        ProgramSelection selection = new ProgramSelection((AddressSetView)set);
        this.tool.firePluginEvent((PluginEvent)new ProgramSelectionPluginEvent("Registers", selection, this.currentProgram));
    }

    void setShowDefaultValues(boolean b) {
        this.includeDefaultValues = b;
        this.setRegister(this.selectedRegister);
    }

    void setAddress(Address address) {
        int numRows = this.model.getRowCount();
        for (int i = 0; i < numRows; ++i) {
            Address start = (Address)this.model.getValueAt(i, 0);
            Address end = (Address)this.model.getValueAt(i, 1);
            if (start.compareTo((Object)address) > 0 || end.compareTo((Object)address) < 0) continue;
            this.table.changeSelection(i, 0, false, false);
            return;
        }
        this.table.clearSelection();
    }

    void setIsShowing(boolean b) {
        this.isShowing = b;
        if (this.isShowing) {
            this.setRegister(this.selectedRegister);
        } else {
            this.markerAddressSet = new AddressSet();
            this.updateMarkers();
        }
    }

    void dispose() {
        this.table.dispose();
    }

    private class RegisterValuesTableModel
    extends AbstractSortedTableModel<RegisterValueRange>
    implements ProgramTableModel {
        List<RegisterValueRange> values = new ArrayList<RegisterValueRange>();

        RegisterValuesTableModel() {
        }

        void setValues(List<RegisterValueRange> values) {
            this.values = values;
            this.fireTableDataChanged();
        }

        public String getName() {
            return "Register Values";
        }

        public int getColumnCount() {
            return 3;
        }

        public int getRowCount() {
            return this.values.size();
        }

        public Class<?> getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: 
                case 1: {
                    return Address.class;
                }
            }
            return RegisterValueRange.class;
        }

        public boolean isSortable(int columnIndex) {
            return true;
        }

        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return RegisterValuesPanel.START_ADDRESS_COLUMN_NAME;
                }
                case 1: {
                    return RegisterValuesPanel.END_ADDRESS_COLUMN_NAME;
                }
            }
            return RegisterValuesPanel.VALUE_COLUMN_NAME;
        }

        @Override
        public Program getProgram() {
            return RegisterValuesPanel.this.currentProgram;
        }

        @Override
        public ProgramLocation getProgramLocation(int row, int column) {
            RegisterValueRange range = this.values.get(row);
            switch (column) {
                case 0: {
                    return new ProgramLocation(RegisterValuesPanel.this.currentProgram, range.getStartAddress());
                }
                case 1: {
                    return new ProgramLocation(RegisterValuesPanel.this.currentProgram, range.getEndAddress());
                }
            }
            return null;
        }

        @Override
        public ProgramSelection getProgramSelection(int[] rows) {
            return null;
        }

        public Object getColumnValueForRow(RegisterValueRange range, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return range.getStartAddress();
                }
                case 1: {
                    return range.getEndAddress();
                }
            }
            return range;
        }

        public List<RegisterValueRange> getModelData() {
            return this.values;
        }

        protected Comparator<RegisterValueRange> createSortComparator(int columnIndex) {
            return new RegisterValueRangeComparator(columnIndex);
        }
    }
}

