/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.function;

import docking.DialogComponentProvider;
import docking.widgets.label.GLabel;
import ghidra.app.util.NamespaceUtils;
import ghidra.app.util.PseudoDisassembler;
import ghidra.app.util.SymbolPath;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Library;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.ExternalLocation;
import ghidra.program.model.symbol.ExternalManager;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.symbol.SymbolType;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.exception.NotFoundException;
import ghidra.util.layout.PairLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ThunkReferenceAddressDialog
extends DialogComponentProvider {
    private PluginTool tool;
    private JTextField refFunctionField;
    private Address refAddress;
    private Symbol refSymbol;
    private Program program;

    public ThunkReferenceAddressDialog(PluginTool tool) {
        super("Thunk Destination Function/Address", true, true, true, false);
        this.tool = tool;
        this.setHelpLocation(new HelpLocation("LabelMgrPlugin", "AddEditDialog"));
        this.addWorkPanel(this.create());
        this.setFocusComponent(this.refFunctionField);
        this.addOKButton();
        this.addCancelButton();
        this.setDefaultButton(this.okButton);
        this.setRememberSize(false);
        this.setRememberLocation(false);
    }

    public void showDialog(Program p, Address entry, Address referencedFunctionAddr) {
        this.program = p;
        String defaultStr = "";
        if (referencedFunctionAddr != null) {
            defaultStr = Long.toHexString(referencedFunctionAddr.getAddressableWordOffset());
        }
        this.refFunctionField.setText(defaultStr);
        this.tool.showDialog((DialogComponentProvider)this);
    }

    public void showDialog(Program p, Address entry, Symbol symbol) {
        this.program = p;
        String defaultStr = "";
        if (symbol != null) {
            defaultStr = symbol.getName(true);
        }
        this.refFunctionField.setText(defaultStr);
        this.tool.showDialog((DialogComponentProvider)this);
    }

    public Address getAddress() {
        return this.refAddress;
    }

    public Symbol getSymbol() {
        return this.refSymbol;
    }

    protected void okCallback() {
        String text = this.refFunctionField.getText().trim();
        if (text.isEmpty()) {
            this.setStatusText("Destination cannot be blank");
            return;
        }
        this.refAddress = this.program.getAddressFactory().getAddress(text);
        if (this.refAddress == null) {
            try {
                this.refSymbol = this.getSymbolForText(text);
                if (this.refSymbol == null) {
                    Msg.showError((Object)((Object)this), (Component)this.getComponent(), (String)"Ambiguous Symbol Name", (Object)"Specified symbol is ambiguous.  Try full namespace name, mangled name or address.");
                    return;
                }
            }
            catch (NotFoundException e) {
                Msg.showError((Object)((Object)this), (Component)this.getComponent(), (String)"Invalid Entry Error", (Object)("Invalid thunk reference address or name specified: " + text));
                return;
            }
            this.refAddress = this.refSymbol.getAddress();
        }
        this.refSymbol = this.maybeUpgradeToFunctionSymbol(this.refAddress, this.refSymbol);
        if (!this.isValid(this.refAddress, this.refSymbol)) {
            return;
        }
        this.close();
    }

    private boolean isValid(Address addr, Symbol s) {
        if (s != null && (this.refSymbol.isExternal() || s.getSymbolType() == SymbolType.FUNCTION)) {
            return true;
        }
        if (addr == null) {
            return false;
        }
        Listing listing = this.program.getListing();
        if (listing.getFunctionContaining(addr) != null) {
            this.setStatusText("Address cannot be within function: " + addr);
            return false;
        }
        return true;
    }

    private Symbol maybeUpgradeToFunctionSymbol(Address addr, Symbol s) {
        if (s != null) {
            if (s.getSymbolType() == SymbolType.FUNCTION) {
                return s;
            }
            addr = s.getAddress();
        } else {
            addr = PseudoDisassembler.getNormalizedDisassemblyAddress((Program)this.program, (Address)addr);
        }
        Listing listing = this.program.getListing();
        Function refFunction = listing.getFunctionAt(addr);
        if (refFunction != null) {
            return refFunction.getSymbol();
        }
        return s;
    }

    private Symbol getSymbolForText(String text) throws NotFoundException {
        SymbolTable symbolTable = this.program.getSymbolTable();
        SymbolPath symbolPath = new SymbolPath(text);
        Namespace namespace = this.getNamespace(symbolPath);
        Object symbolIterator = namespace == null ? symbolTable.getSymbols(text) : symbolTable.getSymbols(symbolPath.getName(), namespace).iterator();
        Symbol symbol = null;
        try {
            symbol = this.findRefSymbol((Iterator<Symbol>)symbolIterator);
            if (symbol == null) {
                return null;
            }
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        Symbol candidateSymbol2 = null;
        if (namespace == null) {
            try {
                candidateSymbol2 = this.findOriginalExternalSymbol(text);
                if (candidateSymbol2 == null) {
                    return null;
                }
                if (symbol != null) {
                    return null;
                }
                symbol = candidateSymbol2;
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
        }
        if (symbol == null) {
            throw new NotFoundException();
        }
        return symbol;
    }

    private Namespace getNamespace(SymbolPath symbolPath) {
        String parentNs = symbolPath.getParentPath();
        if (parentNs == null) {
            return null;
        }
        List namespaces = NamespaceUtils.getNamespaces((String)parentNs, null, (Program)this.program);
        if (namespaces.isEmpty()) {
            String libraryName;
            Symbol librarySymbol;
            SymbolTable symbolTable = this.program.getSymbolTable();
            String[] stringArray = this.program.getExternalManager().getExternalLibraryNames();
            int n = stringArray.length;
            for (int i = 0; i < n && (namespaces = NamespaceUtils.getNamespaces((String)parentNs, (Namespace)((Library)(librarySymbol = symbolTable.getLibrarySymbol(libraryName = stringArray[i])).getObject()), (Program)this.program)).isEmpty(); ++i) {
            }
        }
        if (namespaces.size() > 1) {
            Msg.showError((Object)((Object)this), (Component)this.getComponent(), (String)"Invalid Namespace", (Object)"Invalid namespace specified, expected Class or Namespace");
        }
        return namespaces.isEmpty() ? null : (Namespace)namespaces.get(0);
    }

    private Symbol findRefSymbol(Iterator<Symbol> symbolIterator) throws NotFoundException {
        Object candidateSymbol = null;
        Object candidateThunkSymbol = null;
        Symbol candidateThunkedSymbol = null;
        while (symbolIterator.hasNext()) {
            Symbol s = symbolIterator.next();
            SymbolType type = s.getSymbolType();
            if (type != SymbolType.FUNCTION && type != SymbolType.LABEL) continue;
            Symbol thunkedSymbol = this.getThunkedSymbol(s);
            if (thunkedSymbol != null) {
                if (candidateThunkSymbol != null && !thunkedSymbol.equals(candidateThunkedSymbol)) {
                    return null;
                }
                candidateThunkedSymbol = thunkedSymbol;
                candidateThunkSymbol = s;
                continue;
            }
            if (candidateSymbol != null) {
                return null;
            }
            candidateSymbol = s;
        }
        if (candidateSymbol == null) {
            candidateSymbol = candidateThunkSymbol;
        } else if (candidateThunkSymbol != null && !candidateSymbol.equals(candidateThunkedSymbol)) {
            return null;
        }
        if (candidateSymbol == null) {
            throw new NotFoundException();
        }
        return candidateSymbol;
    }

    private Symbol findOriginalExternalSymbol(String name) throws NotFoundException {
        Symbol candidateSymbol = null;
        SymbolTable symbolTable = this.program.getSymbolTable();
        ExternalManager externalManager = this.program.getExternalManager();
        for (Symbol s : symbolTable.getExternalSymbols()) {
            ExternalLocation externalLocation;
            String originalName;
            SymbolType type = s.getSymbolType();
            if (type != SymbolType.FUNCTION && type != SymbolType.LABEL || !name.equals(originalName = (externalLocation = externalManager.getExternalLocation(s)).getOriginalImportedName())) continue;
            if (candidateSymbol != null) {
                return null;
            }
            candidateSymbol = s;
        }
        if (candidateSymbol == null) {
            throw new NotFoundException();
        }
        return candidateSymbol;
    }

    private Symbol getThunkedSymbol(Symbol s) {
        if (s.getSymbolType() != SymbolType.FUNCTION) {
            return null;
        }
        Function f = (Function)s.getObject();
        Function thunkedFunction = f.getThunkedFunction(true);
        return thunkedFunction != null ? thunkedFunction.getSymbol() : null;
    }

    private JPanel create() {
        JPanel mainPanel = new JPanel((LayoutManager)new PairLayout(5, 5));
        this.refFunctionField = new JTextField(20);
        mainPanel.add((Component)new GLabel("Destination Function/Address:"));
        mainPanel.add(this.refFunctionField);
        mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10));
        return mainPanel;
    }
}

