/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.analysis;

import ghidra.app.services.AbstractAnalyzer;
import ghidra.app.services.AnalysisPriority;
import ghidra.app.services.AnalyzerType;
import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.MemoryByteProvider;
import ghidra.app.util.bin.format.objectiveC.ObjectiveC1_Constants;
import ghidra.app.util.bin.format.objectiveC.ObjectiveC1_Module;
import ghidra.app.util.bin.format.objectiveC.ObjectiveC1_Protocol;
import ghidra.app.util.bin.format.objectiveC.ObjectiveC1_State;
import ghidra.app.util.bin.format.objectiveC.ObjectiveC1_Utilities;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ObjectiveC1_ClassAnalyzer
extends AbstractAnalyzer {
    private static final String DESCRIPTION = "An analyzer for extracting Objective-C class structure information.";
    private static final String NAME = "Objective-C Class";

    public ObjectiveC1_ClassAnalyzer() {
        super(NAME, DESCRIPTION, AnalyzerType.BYTE_ANALYZER);
        this.setPriority(AnalysisPriority.FORMAT_ANALYSIS);
        this.setDefaultEnablement(true);
    }

    @Override
    public boolean added(Program program, AddressSetView set, TaskMonitor monitor, MessageLog log) throws CancelledException {
        MemoryByteProvider provider = new MemoryByteProvider(program.getMemory(), program.getAddressFactory().getDefaultAddressSpace());
        BinaryReader reader = new BinaryReader(provider, !program.getLanguage().isBigEndian());
        ObjectiveC1_State state = new ObjectiveC1_State(program, monitor, ObjectiveC1_Constants.CATEGORY_PATH);
        try {
            this.processModules(state, reader);
            this.processProtocols(state, reader);
            ObjectiveC1_Utilities.createMethods(state);
            this.setDataAndRefBlocksReadOnly(state);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ObjectiveC1_Utilities.fixupReferences(state);
        return true;
    }

    private void setDataAndRefBlocksReadOnly(ObjectiveC1_State state) {
        MemoryBlock messageRefsBlock;
        MemoryBlock classRefsBlock;
        Memory memory = state.program.getMemory();
        MemoryBlock dataBlock = memory.getBlock("__data");
        if (dataBlock != null) {
            dataBlock.setWrite(false);
        }
        if ((classRefsBlock = memory.getBlock("__cls_refs")) != null) {
            classRefsBlock.setWrite(false);
        }
        if ((messageRefsBlock = memory.getBlock("__message_refs")) != null) {
            messageRefsBlock.setWrite(false);
        }
    }

    @Override
    public boolean canAnalyze(Program program) {
        return ObjectiveC1_Constants.isObjectiveC(program);
    }

    private void processModules(ObjectiveC1_State state, BinaryReader reader) throws Exception {
        state.monitor.setMessage("Objective-C Modules...");
        List<ObjectiveC1_Module> modules = this.parseModuleList(state, reader);
        state.monitor.initialize((long)modules.size());
        int progress = 0;
        for (ObjectiveC1_Module module : modules) {
            if (state.monitor.isCancelled()) break;
            state.monitor.setProgress((long)(++progress));
            module.applyTo();
        }
    }

    private List<ObjectiveC1_Module> parseModuleList(ObjectiveC1_State state, BinaryReader reader) {
        ArrayList<ObjectiveC1_Module> modules = new ArrayList<ObjectiveC1_Module>();
        state.monitor.setMessage("Parsing Objective-C information...");
        try {
            MemoryBlock moduleInfoBlock = state.program.getMemory().getBlock("__module_info");
            long moduleInfoStartIndex = moduleInfoBlock.getStart().getOffset();
            long moduleInfoEndIndex = moduleInfoBlock.getEnd().getOffset();
            state.monitor.initialize((long)((int)(moduleInfoEndIndex - moduleInfoStartIndex)));
            reader.setPointerIndex(moduleInfoStartIndex);
            while (reader.getPointerIndex() < moduleInfoEndIndex && !state.monitor.isCancelled()) {
                modules.add(new ObjectiveC1_Module(state, reader));
                state.monitor.setProgress((long)((int)(reader.getPointerIndex() - moduleInfoStartIndex)));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return modules;
    }

    private void processProtocols(ObjectiveC1_State state, BinaryReader reader) throws Exception {
        state.monitor.setMessage("Objective-C Protocols...");
        MemoryBlock block = state.program.getMemory().getBlock("__protocol");
        if (block == null) {
            return;
        }
        state.monitor.initialize((long)((int)block.getSize()));
        Address address = block.getStart();
        reader.setPointerIndex(block.getStart().getOffset());
        while (address.compareTo((Object)block.getEnd()) < 0 && !state.monitor.isCancelled()) {
            state.monitor.setProgress((long)((int)address.subtract(block.getStart())));
            ObjectiveC1_Protocol protocol = new ObjectiveC1_Protocol(state, reader);
            protocol.applyTo();
            address = address.add(20L);
        }
    }
}

