/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.function;

import ghidra.framework.cmd.Command;
import ghidra.framework.model.DomainObject;
import ghidra.program.database.ProgramDB;
import ghidra.program.database.function.FunctionManagerDB;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Function;

public class AddFunctionTagCmd
implements Command {
    private Address entryPoint;
    private String tagName;
    private String errorMsg = "";

    public AddFunctionTagCmd(String tagName, Address entryPoint) {
        this.tagName = tagName;
        this.entryPoint = entryPoint;
    }

    public boolean applyTo(DomainObject obj) {
        ProgramDB program = (ProgramDB)obj;
        FunctionManagerDB functionManagerDB = (FunctionManagerDB)program.getFunctionManager();
        Function function = functionManagerDB.getFunctionAt(this.entryPoint);
        if (function == null) {
            this.errorMsg = "Function not found at: " + this.entryPoint.toString();
            return false;
        }
        return function.addTag(this.tagName);
    }

    public String getStatusMsg() {
        return this.errorMsg;
    }

    public String getName() {
        return "Add Tag To Function";
    }
}

