/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.api.db;

import db.DBHandle;
import db.Field;
import db.IntField;
import db.LongField;
import db.OpenMode;
import db.Record;
import db.RecordIterator;
import db.Schema;
import db.StringField;
import ghidra.feature.vt.api.db.VTAssociationDB;
import ghidra.feature.vt.api.db.VTMatchSetDB;
import ghidra.feature.vt.api.db.VTMatchTableDBAdapterV0;
import ghidra.feature.vt.api.db.VTMatchTagDB;
import ghidra.feature.vt.api.main.VTMatchInfo;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.LinkedList;

public abstract class VTMatchTableDBAdapter {
    static String TABLE_NAME = "MatchTable";
    static Schema TABLE_SCHEMA = new Schema(0, "Key", (Class[])ColumnDescription.getColumnClasses(), ColumnDescription.getColumnNames());

    static VTMatchTableDBAdapter createAdapter(DBHandle dbHandle, long tableID) throws IOException {
        return new VTMatchTableDBAdapterV0(dbHandle, tableID);
    }

    static VTMatchTableDBAdapter getAdapter(DBHandle dbHandle, long tableID, OpenMode openMode, TaskMonitor monitor) throws VersionException {
        return new VTMatchTableDBAdapterV0(dbHandle, tableID, openMode, monitor);
    }

    public abstract Record insertMatchRecord(VTMatchInfo var1, VTMatchSetDB var2, VTAssociationDB var3, VTMatchTagDB var4) throws IOException;

    public abstract RecordIterator getRecords() throws IOException;

    abstract Record getMatchRecord(long var1) throws IOException;

    abstract int getRecordCount();

    abstract void updateRecord(Record var1) throws IOException;

    abstract boolean deleteRecord(long var1) throws IOException;

    abstract RecordIterator getRecords(long var1) throws IOException;

    public static enum ColumnDescription {
        TAG_KEY_COL(LongField.class),
        MATCH_SET_COL(LongField.class),
        SIMILARITY_SCORE_COL(StringField.class),
        CONFIDENCE_SCORE_COL(StringField.class),
        LENGTH_TYPE(StringField.class),
        SOURCE_LENGTH_COL(IntField.class),
        DESTINATION_LENGTH_COL(IntField.class),
        ASSOCIATION_COL(LongField.class);

        private final Class<? extends Field> columnClass;

        private ColumnDescription(Class<? extends Field> columnClass) {
            this.columnClass = columnClass;
        }

        public Class<? extends Field> getColumnClass() {
            return this.columnClass;
        }

        public int column() {
            return this.ordinal();
        }

        private static String[] getColumnNames() {
            ColumnDescription[] columns = ColumnDescription.values();
            LinkedList<String> list = new LinkedList<String>();
            for (ColumnDescription column : columns) {
                list.add(column.name());
            }
            return list.toArray(new String[columns.length]);
        }

        private static Class<? extends Field>[] getColumnClasses() {
            ColumnDescription[] columns = ColumnDescription.values();
            LinkedList<Class<? extends Field>> list = new LinkedList<Class<? extends Field>>();
            for (ColumnDescription column : columns) {
                list.add(column.getColumnClass());
            }
            return list.toArray(new Class[columns.length]);
        }
    }
}

