/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.datastruct;

import ghidra.util.datastruct.LongObjectHashtable;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.LinkedList;

public class ObjectCache {
    private LongObjectHashtable<Object> hashTable;
    private ReferenceQueue<Object> refQueue;
    private LinkedList<Object> hardCache;
    private int hardCacheSize;

    public ObjectCache(int hardCacheSize) {
        this.hardCacheSize = hardCacheSize;
        this.hashTable = new LongObjectHashtable();
        this.refQueue = new ReferenceQueue();
        this.hardCache = new LinkedList();
    }

    public synchronized boolean contains(long key) {
        this.processQueue();
        return this.hashTable.contains(key);
    }

    public synchronized Object get(long key) {
        WeakReference ref = (WeakReference)this.hashTable.get(key);
        if (ref != null) {
            Object obj = ref.get();
            if (obj == null) {
                this.hashTable.remove(key);
            }
            this.addToHardCache(obj);
            return obj;
        }
        return null;
    }

    public int size() {
        return this.hardCacheSize;
    }

    public synchronized void setHardCacheSize(int size) {
        while (this.hardCache.size() > size) {
            this.hardCache.removeLast();
        }
        this.hardCacheSize = size;
    }

    public synchronized void put(long key, Object obj) {
        this.processQueue();
        KeyedSoftReference<Object> ref = new KeyedSoftReference<Object>(key, obj, this.refQueue);
        this.hashTable.put(key, ref);
        this.addToHardCache(obj);
    }

    public synchronized void clear() {
        long[] keys;
        this.processQueue();
        for (long element : keys = this.hashTable.getKeys()) {
            KeyedSoftReference ref = (KeyedSoftReference)this.hashTable.get(element);
            ref.clear();
        }
        this.hashTable.removeAll();
        this.refQueue = new ReferenceQueue();
    }

    public synchronized void remove(long startKey, long endKey) {
        if ((endKey >> 1) - (startKey >> 1) < (long)(this.hashTable.size() >> 1)) {
            for (long i = startKey; i <= endKey; ++i) {
                this.remove(i);
            }
        } else {
            long[] keys;
            for (long element : keys = this.hashTable.getKeys()) {
                if (element < startKey || element > endKey) continue;
                this.remove(element);
            }
        }
    }

    public synchronized void remove(long key) {
        this.processQueue();
        KeyedSoftReference ref = (KeyedSoftReference)this.hashTable.get(key);
        if (ref != null) {
            ref.clear();
            this.hashTable.remove(key);
        }
    }

    private void addToHardCache(Object obj) {
        this.hardCache.addLast(obj);
        if (this.hardCache.size() > this.hardCacheSize) {
            this.hardCache.removeFirst();
        }
    }

    private void processQueue() {
        KeyedSoftReference ref;
        while ((ref = (KeyedSoftReference)this.refQueue.poll()) != null) {
            this.hashTable.remove(ref.getKey());
        }
    }

    private class KeyedSoftReference<T>
    extends WeakReference<T> {
        private long key;

        KeyedSoftReference(long key, T obj, ReferenceQueue<T> queue) {
            super(obj, queue);
            this.key = key;
        }

        long getKey() {
            return this.key;
        }
    }
}

