/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.datastruct;

import ghidra.util.datastruct.Array;
import ghidra.util.datastruct.DataTable;
import java.io.Serializable;

public class BooleanArray
implements Array,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final int MIN_SIZE = 4;
    private static final int[] ONBITS = new int[]{1, 2, 4, 8, 16, 32, 64, 128};
    private static final int[] OFFBITS = new int[]{254, 253, 251, 247, 239, 223, 191, 127};
    int lastNonZeroIndex = -1;
    private byte[] bytes = new byte[4];

    public void put(int index, boolean value) {
        int byteNum = index / 8;
        int bitNum = index % 8;
        if (byteNum >= this.bytes.length) {
            if (!value) {
                return;
            }
            this.adjustArray(Math.max(byteNum + 1, this.bytes.length * 2));
        }
        if (value) {
            int n = byteNum;
            this.bytes[n] = (byte)(this.bytes[n] | ONBITS[bitNum]);
            if (index > this.lastNonZeroIndex) {
                this.lastNonZeroIndex = index;
            }
        } else {
            int n = byteNum;
            this.bytes[n] = (byte)(this.bytes[n] & OFFBITS[bitNum]);
            if (index == this.lastNonZeroIndex) {
                this.lastNonZeroIndex = this.findLastNonZeroIndex();
            }
            if (this.lastNonZeroIndex / 8 < this.bytes.length / 4) {
                this.adjustArray(this.lastNonZeroIndex / 4);
            }
        }
    }

    private int findLastNonZeroIndex() {
        for (int i = this.lastNonZeroIndex / 8; i >= 0; --i) {
            if (this.bytes[i] == 0) continue;
            for (int j = 7; j >= 0; --j) {
                if ((this.bytes[i] & ONBITS[j]) == 0) continue;
                return i * 8 + j;
            }
        }
        return -1;
    }

    @Override
    public void remove(int index) {
        this.put(index, false);
    }

    public boolean get(int index) {
        int byteNum = index / 8;
        int bitNum = index % 8;
        if (byteNum < this.bytes.length) {
            return (this.bytes[byteNum] & ONBITS[bitNum]) != 0;
        }
        return false;
    }

    private void adjustArray(int size) {
        if (size < 4) {
            size = 4;
        }
        byte[] newBytes = new byte[size];
        int len = Math.min(size, this.bytes.length);
        System.arraycopy(this.bytes, 0, newBytes, 0, len);
        this.bytes = newBytes;
    }

    @Override
    public int getLastNonEmptyIndex() {
        return this.lastNonZeroIndex;
    }

    @Override
    public void copyDataTo(int index, DataTable table, int toIndex, int toCol) {
        table.putBoolean(toIndex, toCol, this.get(index));
    }
}

