/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.pcode;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.data.DataType;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.VariableStorage;
import ghidra.program.model.pcode.DynamicHash;
import ghidra.program.model.pcode.DynamicSymbol;
import ghidra.program.model.pcode.HighSymbol;
import ghidra.program.model.pcode.HighVariable;
import ghidra.program.model.pcode.MappedSymbol;
import ghidra.program.model.pcode.Varnode;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.InvalidInputException;

public class HighLocal
extends HighVariable {
    private Address pcaddr;
    private HighSymbol symbol;
    private long hash = 0L;

    public HighLocal(DataType type, Varnode vn, Varnode[] inst, Address pc, HighSymbol sym) {
        super(sym.getName(), type, vn, inst, sym.getHighFunction());
        this.pcaddr = pc;
        this.symbol = sym;
    }

    public HighSymbol getSymbol() {
        return this.symbol;
    }

    public Address getPCAddress() {
        return this.pcaddr;
    }

    protected int getFirstUseOffset() {
        Address pcaddr = this.getPCAddress();
        if (pcaddr == null || this.getRepresentative().getAddress().isStackAddress()) {
            return 0;
        }
        return (int)pcaddr.subtract(this.getHighFunction().getFunction().getEntryPoint());
    }

    @Override
    public VariableStorage getStorage() {
        Program program = this.getHighFunction().getFunction().getProgram();
        Varnode represent = this.getRepresentative();
        if (this.symbol instanceof DynamicSymbol || represent.isUnique()) {
            long hash = this.buildDynamicHash();
            try {
                return new VariableStorage(program, AddressSpace.HASH_SPACE.getAddress(hash), represent.getSize());
            }
            catch (InvalidInputException e) {
                throw new AssertException("Unexpected exception", (Throwable)e);
            }
        }
        if (this.symbol instanceof MappedSymbol) {
            return ((MappedSymbol)this.symbol).getStorage();
        }
        return super.getStorage();
    }

    public long buildDynamicHash() {
        if (this.hash != 0L) {
            return this.hash;
        }
        if (this.symbol instanceof DynamicSymbol) {
            this.hash = ((DynamicSymbol)this.symbol).getHash();
            this.pcaddr = this.symbol.getPCAddress();
        } else if (this.getRepresentative().isUnique()) {
            DynamicHash dynamicHash = new DynamicHash(this.getRepresentative(), this.getHighFunction());
            this.hash = dynamicHash.getHash();
            this.pcaddr = dynamicHash.getAddress();
        }
        return this.hash;
    }
}

