/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.references;

import db.BinaryField;
import db.ByteField;
import db.DBHandle;
import db.IntField;
import db.Schema;
import db.util.ErrorHandler;
import ghidra.program.database.DBObjectCache;
import ghidra.program.database.ProgramDB;
import ghidra.program.database.map.AddressMap;
import ghidra.program.database.references.RecordAdapter;
import ghidra.program.database.references.RefList;
import ghidra.program.database.references.RefListV0;
import ghidra.program.database.references.ToAdapterSharedTable;
import ghidra.program.database.references.ToAdapterV0;
import ghidra.program.database.references.ToAdapterV1;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.symbol.Reference;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

abstract class ToAdapter
implements RecordAdapter {
    static final String TO_REFS_TABLE_NAME = "TO REFS";
    static final int CURRENT_VERSION = 1;
    static final Schema TO_REFS_SCHEMA = new Schema(1, "To Address", new Class[]{IntField.class, BinaryField.class, ByteField.class}, new String[]{"Number of Refs", "Ref Data", "Ref Level"});
    static final int REF_COUNT_COL = 0;
    static final int REF_DATA_COL = 1;
    static final int REF_LEVEL_COL = 2;

    ToAdapter() {
    }

    static ToAdapter getAdapter(DBHandle dbHandle, int openMode, AddressMap addrMap, ErrorHandler errHandler, TaskMonitor monitor) throws VersionException, CancelledException, IOException {
        if (openMode == 0) {
            return new ToAdapterV1(dbHandle, true, addrMap, errHandler);
        }
        try {
            ToAdapterV1 adapter = new ToAdapterV1(dbHandle, false, addrMap, errHandler);
            if (addrMap.isUpgraded()) {
                throw new VersionException(true);
            }
            return adapter;
        }
        catch (VersionException e) {
            if (!e.isUpgradable() || openMode == 1) {
                throw e;
            }
            ToAdapter adapter = ToAdapter.findReadOnlyAdapter(dbHandle, addrMap, errHandler);
            if (openMode == 3) {
                adapter = ToAdapter.upgrade(dbHandle, adapter, addrMap, errHandler, monitor);
            }
            return adapter;
        }
    }

    private static ToAdapter findReadOnlyAdapter(DBHandle dbHandle, AddressMap addrMap, ErrorHandler errHandler) throws VersionException, IOException {
        try {
            return new ToAdapterV1(dbHandle, false, addrMap.getOldAddressMap(), errHandler);
        }
        catch (VersionException versionException) {
            try {
                return new ToAdapterV0(dbHandle, addrMap, errHandler);
            }
            catch (VersionException versionException2) {
                return new ToAdapterSharedTable(dbHandle, addrMap, errHandler);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ToAdapter upgrade(DBHandle dbHandle, ToAdapter oldAdapter, AddressMap addrMap, ErrorHandler errHandler, TaskMonitor monitor) throws VersionException, IOException, CancelledException {
        AddressMap oldAddrMap = addrMap.getOldAddressMap();
        try (DBHandle tmpHandle = new DBHandle();){
            tmpHandle.startTransaction();
            monitor.setMessage("Upgrading Memory References...");
            monitor.initialize((long)(oldAdapter.getRecordCount() * 2));
            int count = 0;
            ToAdapterV1 tmpAdapter = new ToAdapterV1(tmpHandle, true, addrMap, errHandler);
            AddressIterator addrIter = oldAdapter.getToIterator(true);
            while (addrIter.hasNext()) {
                if (monitor.isCancelled()) {
                    throw new CancelledException();
                }
                Address to = addrIter.next();
                RefListV0 refList = (RefListV0)oldAdapter.getRefList(null, null, to, oldAddrMap.getKey(to, false));
                Reference[] refs = refList.getAllRefs();
                RefListV0 newRefList = new RefListV0(to, (RecordAdapter)tmpAdapter, addrMap, null, null, false);
                newRefList.addRefs(refs);
                monitor.setProgress((long)(++count));
            }
            dbHandle.deleteTable(TO_REFS_TABLE_NAME);
            ToAdapterV1 newAdapter = new ToAdapterV1(dbHandle, true, addrMap, errHandler);
            addrIter = ((ToAdapter)tmpAdapter).getToIterator(true);
            while (addrIter.hasNext()) {
                if (monitor.isCancelled()) {
                    throw new CancelledException();
                }
                Address to = addrIter.next();
                long toAddr = addrMap.getKey(to, true);
                RefListV0 refList = (RefListV0)((ToAdapter)tmpAdapter).getRefList(null, null, to, toAddr);
                byte refLevel = -1;
                if (refList != null) {
                    refLevel = refList.getReferenceLevel();
                }
                newAdapter.createRecord(toAddr, refList != null ? refList.getNumRefs() : 0, refLevel, refList != null ? refList.getData() : null);
                monitor.setProgress((long)(++count));
            }
            ToAdapterV1 toAdapterV1 = newAdapter;
            return toAdapterV1;
        }
    }

    abstract int getRecordCount();

    abstract RefList createRefList(ProgramDB var1, DBObjectCache<RefList> var2, Address var3) throws IOException;

    abstract RefList getRefList(ProgramDB var1, DBObjectCache<RefList> var2, Address var3, long var4) throws IOException;

    abstract boolean hasRefTo(long var1) throws IOException;

    abstract AddressIterator getToIterator(boolean var1) throws IOException;

    abstract AddressIterator getToIterator(Address var1, boolean var2) throws IOException;

    abstract AddressIterator getToIterator(AddressSetView var1, boolean var2) throws IOException;

    abstract AddressIterator getOldNamespaceAddresses(AddressSpace var1) throws IOException;

    public void putRecord(long key, int numRefs, byte[] refData) {
        throw new UnsupportedOperationException();
    }
}

