/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcodeCPort.slghpatexpress;

import generic.stl.VectorSTL;
import ghidra.pcodeCPort.slghpatexpress.PatternExpression;
import ghidra.pcodeCPort.slghpatexpress.PatternValue;
import ghidra.pcodeCPort.slghpatexpress.TokenPattern;
import ghidra.pcodeCPort.translate.Translate;
import ghidra.sleigh.grammar.Location;
import java.io.PrintStream;
import java.util.List;
import org.jdom.Element;

public abstract class BinaryExpression
extends PatternExpression {
    private PatternExpression left;
    private PatternExpression right;

    public BinaryExpression(Location location) {
        super(location);
        this.left = null;
        this.right = null;
    }

    public PatternExpression getLeft() {
        return this.left;
    }

    public PatternExpression getRight() {
        return this.right;
    }

    @Override
    public TokenPattern genMinPattern(VectorSTL<TokenPattern> ops) {
        return new TokenPattern(this.location);
    }

    @Override
    public void listValues(VectorSTL<PatternValue> list) {
        this.left.listValues(list);
        this.right.listValues(list);
    }

    @Override
    public void getMinMax(VectorSTL<Long> minlist, VectorSTL<Long> maxlist) {
        this.left.getMinMax(minlist, maxlist);
        this.right.getMinMax(minlist, maxlist);
    }

    public BinaryExpression(Location location, PatternExpression l, PatternExpression r) {
        super(location);
        this.left = l;
        this.left.layClaim();
        this.right = r;
        this.right.layClaim();
    }

    @Override
    public void dispose() {
        if (this.left != null) {
            PatternExpression.release(this.left);
        }
        if (this.right != null) {
            PatternExpression.release(this.right);
        }
    }

    @Override
    public void saveXml(PrintStream s) {
        this.left.saveXml(s);
        this.right.saveXml(s);
    }

    @Override
    public void restoreXml(Element el, Translate trans) {
        List list = el.getChildren();
        this.left = PatternExpression.restoreExpression((Element)list.get(0), trans);
        this.right = PatternExpression.restoreExpression((Element)list.get(1), trans);
        this.left.layClaim();
        this.right.layClaim();
    }
}

