/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfsexplorer.types.finder;

import java.io.PrintStream;
import org.catacombae.csjc.StructElements;
import org.catacombae.csjc.structelements.Dictionary;
import org.catacombae.hfsexplorer.Util;
import org.catacombae.hfsexplorer.types.carbon.Point;
import org.catacombae.hfsexplorer.types.finder.CommonExtendedFinderInfo;

public class ExtendedFolderInfo
extends CommonExtendedFinderInfo {
    private final Point scrollPosition;
    private final byte[] reserved1 = new byte[4];

    public ExtendedFolderInfo(byte[] data, int offset) {
        super(data, offset);
        this.scrollPosition = new Point(data, offset + 0);
        System.arraycopy(data, offset + 4, this.reserved1, 0, 4);
    }

    public static int length() {
        return 16;
    }

    public byte[] getBytes() {
        byte[] result = new byte[ExtendedFolderInfo.length()];
        int offset = 0;
        byte[] tempData = this.scrollPosition.getBytes();
        System.arraycopy(tempData, 0, result, offset, tempData.length);
        System.arraycopy(this.reserved1, 0, result, offset += tempData.length, this.reserved1.length);
        tempData = super.getBytes();
        System.arraycopy(tempData, 0, result, offset += this.reserved1.length, tempData.length);
        offset += tempData.length;
        return result;
    }

    public Point getScrollPosition() {
        return this.scrollPosition;
    }

    public int getReserved1() {
        return Util.readIntBE((byte[])this.reserved1);
    }

    public void printFields(PrintStream ps, String prefix) {
        ps.println(prefix + " scrollPosition: ");
        this.getScrollPosition().print(ps, prefix + "  ");
        ps.println(prefix + " reserved1: " + this.getReserved1());
        super.printFields(ps, prefix);
    }

    public void print(PrintStream ps, String prefix) {
        ps.println(prefix + "ExtendedFolderInfo:");
        this.printFields(ps, prefix);
    }

    public Dictionary getStructElements() {
        StructElements.DictionaryBuilder db = new StructElements.DictionaryBuilder(ExtendedFolderInfo.class.getName());
        db.add("scrollPosition", this.scrollPosition.getStructElements());
        db.addUIntBE("reserved1", this.reserved1);
        db.addAll(super.getStructElements());
        return db.getResult();
    }
}

