/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.task;

import docking.DialogComponentProvider;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.CachingLoader;
import ghidra.util.task.TaskDialog;
import ghidra.util.task.TaskMonitor;
import ghidra.util.task.TaskMonitorAdapter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;

public abstract class CachingSwingWorker<T>
implements CachingLoader<T> {
    private String name;
    private int taskDialogDelay = 500;
    private boolean hasProgress = true;
    private T cachedValue;
    private SwingWorker<T, Object> worker;
    private WorkerTaskMonitor taskMonitor = new WorkerTaskMonitor();

    public CachingSwingWorker(String name, boolean hasProgress) {
        this.name = name;
        this.hasProgress = hasProgress;
    }

    public void setTaskDialogDelay(int delay) {
        this.taskDialogDelay = delay;
    }

    protected abstract T runInBackground(TaskMonitor var1);

    @Override
    public T get(TaskMonitor monitor) {
        T value = this.getCachedValue();
        if (value != null) {
            return value;
        }
        this.addMonitor(monitor);
        SwingWorker<T, Object> swingWorker = this.getWorker();
        if (SwingUtilities.isEventDispatchThread()) {
            this.blockSwingWithProgressDialog(swingWorker);
        }
        value = this.waitForValue(swingWorker);
        this.worker = null;
        this.setCachedValue(value);
        return value;
    }

    public void startLoading() {
        SwingWorker<T, Object> swingWorker = this.getWorker();
        swingWorker.execute();
    }

    public synchronized T getCachedValue() {
        return this.cachedValue;
    }

    @Override
    public synchronized void clear() {
        this.cachedValue = null;
    }

    public synchronized void done() {
    }

    private synchronized void setCachedValue(T value) {
        this.cachedValue = value;
    }

    private void addMonitor(TaskMonitor monitor) {
        if (monitor != null) {
            this.taskMonitor.add(monitor);
        }
    }

    private void blockSwingWithProgressDialog(SwingWorker<T, Object> localWorker) {
        if (!localWorker.isDone()) {
            SwingWorkerTaskDialog dialog = new SwingWorkerTaskDialog(this.name, this.hasProgress, localWorker);
            this.taskMonitor.setBlockingMonitor(dialog);
            localWorker.addPropertyChangeListener(new SwingWorkerCompletionWaiter(dialog));
            dialog.show(this.taskDialogDelay);
        }
    }

    private synchronized SwingWorker<T, Object> getWorker() {
        if (this.worker == null) {
            this.worker = new SwingWorkerImpl();
            this.worker.execute();
        }
        return this.worker;
    }

    private T waitForValue(SwingWorker<T, Object> swingWorker) {
        T newValue = null;
        while (true) {
            try {
                newValue = swingWorker.get();
            }
            catch (ExecutionException e) {
                if (this.taskMonitor.isCancelled()) break;
                Msg.error((Object)this, (Object)("Error running " + this.name), (Throwable)e);
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
        this.taskMonitor.clear();
        this.worker = null;
        return newValue;
    }

    private class SwingWorkerCompletionWaiter
    implements PropertyChangeListener {
        private DialogComponentProvider dialog;

        public SwingWorkerCompletionWaiter(DialogComponentProvider dialog) {
            this.dialog = dialog;
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            if ("state".equals(event.getPropertyName()) && SwingWorker.StateValue.DONE == event.getNewValue()) {
                this.dialog.close();
            }
        }
    }

    private class WorkerTaskMonitor
    extends TaskMonitorAdapter {
        private List<TaskMonitor> monitors = new CopyOnWriteArrayList<TaskMonitor>();
        private int min = 0;
        private int max = 0;
        private int progress = 0;
        private String pendingMessage = null;

        private WorkerTaskMonitor() {
        }

        public void setMessage(String message) {
            if (this.monitors.isEmpty()) {
                this.pendingMessage = message;
                return;
            }
            for (int i = 0; i < this.monitors.size(); ++i) {
                this.monitors.get(i).setMessage(message);
            }
        }

        public void setBlockingMonitor(TaskMonitor monitor) {
            this.monitors.add(monitor);
            if (this.pendingMessage != null) {
                monitor.setMessage(this.pendingMessage);
            }
        }

        public void clear() {
            this.monitors.clear();
        }

        public void add(TaskMonitor monitor) {
            this.monitors.add(monitor);
        }

        public void initialize(long maximum) {
            for (int i = 0; i < this.monitors.size(); ++i) {
                this.monitors.get(i).initialize(maximum);
            }
        }

        public void setMaximum(long max) {
            for (int i = 0; i < this.monitors.size(); ++i) {
                this.monitors.get(i).initialize(max);
            }
        }

        public void setProgress(long value) {
            for (int i = 0; i < this.monitors.size(); ++i) {
                this.monitors.get(i).setProgress(value);
            }
        }

        public void incrementProgress(long incrementAmount) {
            for (int i = 0; i < this.monitors.size(); ++i) {
                this.monitors.get(i).incrementProgress(incrementAmount);
            }
        }

        public void checkCanceled() throws CancelledException {
            for (int i = 0; i < this.monitors.size(); ++i) {
                this.monitors.get(i).checkCanceled();
            }
        }

        public long getMaximum() {
            return this.max;
        }

        public int getMinimum() {
            return this.min;
        }

        public long getProgress() {
            return this.progress;
        }

        public boolean isCancelEnabled() {
            return true;
        }

        public boolean isCancelled() {
            for (int i = 0; i < this.monitors.size(); ++i) {
                TaskMonitor tm = this.monitors.get(i);
                if (!tm.isCancelled()) continue;
                return true;
            }
            return false;
        }
    }

    private class SwingWorkerImpl
    extends SwingWorker<T, Object> {
        private SwingWorkerImpl() {
        }

        @Override
        protected T doInBackground() throws Exception {
            Object result = CachingSwingWorker.this.runInBackground((TaskMonitor)CachingSwingWorker.this.taskMonitor);
            return result;
        }

        @Override
        protected void done() {
            try {
                Object t = this.get();
                CachingSwingWorker.this.setCachedValue(t);
            }
            catch (Exception exception) {
                // empty catch block
            }
            CachingSwingWorker.this.done();
        }
    }

    private class SwingWorkerTaskDialog
    extends TaskDialog {
        private SwingWorker<T, Object> taskWorker;

        SwingWorkerTaskDialog(String title, boolean showProgress, SwingWorker<T, Object> worker) {
            super(title, true, true, showProgress);
            this.taskWorker = worker;
        }

        @Override
        public synchronized boolean isCompleted() {
            return this.taskWorker.isDone() || super.isCompleted();
        }
    }
}

