/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.fieldpanel.support;

import docking.widgets.fieldpanel.field.FieldElement;
import java.util.ArrayList;
import java.util.List;

public class FieldUtils {
    private static final char[] WHITE_SPACE = new char[]{'\t', '\n', '\r', '\f'};

    private FieldUtils() {
    }

    public static List<FieldElement> wrap(List<FieldElement> fieldElements, int width) {
        ArrayList<FieldElement> wrappedElements = new ArrayList<FieldElement>();
        for (FieldElement fieldElement : fieldElements) {
            wrappedElements.addAll(FieldUtils.wordWrapList(fieldElement, width));
        }
        return wrappedElements;
    }

    public static FieldElement[] wrap(FieldElement fieldElement, int width) {
        FieldElement originalFieldElement = fieldElement.replaceAll(WHITE_SPACE, ' ');
        if (originalFieldElement.getStringWidth() <= width) {
            return new FieldElement[]{originalFieldElement};
        }
        ArrayList<FieldElement> lines = new ArrayList<FieldElement>();
        int wordWrapPos = FieldUtils.findWordWrapPosition(originalFieldElement, width);
        while (wordWrapPos > 0) {
            lines.add(originalFieldElement.substring(0, wordWrapPos));
            if (originalFieldElement.charAt(wordWrapPos) == ' ') {
                ++wordWrapPos;
            }
            originalFieldElement = originalFieldElement.substring(wordWrapPos);
            wordWrapPos = FieldUtils.findWordWrapPosition(originalFieldElement, width);
        }
        lines.add(originalFieldElement);
        return lines.toArray(new FieldElement[lines.size()]);
    }

    public static List<FieldElement> wordWrapList(FieldElement fieldElement, int width) {
        ArrayList<FieldElement> lines = new ArrayList<FieldElement>();
        FieldElement originalFieldElement = fieldElement.replaceAll(WHITE_SPACE, ' ');
        if (originalFieldElement.getStringWidth() <= width) {
            lines.add(originalFieldElement);
            return lines;
        }
        int wordWrapPos = FieldUtils.findWordWrapPosition(originalFieldElement, width);
        while (wordWrapPos > 0) {
            lines.add(originalFieldElement.substring(0, wordWrapPos));
            if (originalFieldElement.charAt(wordWrapPos) == ' ') {
                ++wordWrapPos;
            }
            originalFieldElement = originalFieldElement.substring(wordWrapPos);
            wordWrapPos = FieldUtils.findWordWrapPosition(originalFieldElement, width);
        }
        lines.add(originalFieldElement);
        return lines;
    }

    private static int findWordWrapPosition(FieldElement element, int width) {
        String text = element.getText();
        int wrapPosition = element.getMaxCharactersForWidth(width);
        if (wrapPosition == element.length() || wrapPosition == 0) {
            return 0;
        }
        int whiteSpacePosition = text.lastIndexOf(" ", wrapPosition - 1);
        if (whiteSpacePosition >= 0) {
            return whiteSpacePosition;
        }
        return wrapPosition;
    }

    public static String trimString(String string) {
        StringBuffer buffer = new StringBuffer(string);
        if (Character.isJavaIdentifierPart(buffer.charAt(0))) {
            for (int index = 1; index < buffer.length(); ++index) {
                char charAt = buffer.charAt(index);
                if (Character.isJavaIdentifierPart((int)charAt)) continue;
                return buffer.substring(0, index);
            }
            return buffer.toString();
        }
        int index = 0;
        char charAt = buffer.charAt(index);
        while (!Character.isJavaIdentifierPart((int)charAt) && buffer.length() > 0) {
            buffer.deleteCharAt(0);
            charAt = buffer.charAt(0);
        }
        index = buffer.length() - 1;
        charAt = buffer.charAt(index);
        while (!Character.isJavaIdentifierPart((int)charAt) && index > 0) {
            buffer.deleteCharAt(index);
            charAt = buffer.charAt(--index);
        }
        return buffer.toString();
    }
}

