/*
 * Decompiled with CFR 0.152.
 */
package pdb;

import docking.DialogComponentProvider;
import docking.DockingWindowManager;
import docking.widgets.dialogs.MultiLineMessageDialog;
import ghidra.app.plugin.core.analysis.AnalysisWorker;
import ghidra.app.plugin.core.analysis.AutoAnalysisManager;
import ghidra.app.plugin.core.analysis.DemanglerAnalyzer;
import ghidra.app.services.DataTypeManagerService;
import ghidra.app.util.bin.format.pdb.PdbException;
import ghidra.app.util.bin.format.pdb.PdbParser;
import ghidra.app.util.importer.MessageLog;
import ghidra.framework.options.Options;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.lang.reflect.InvocationTargetException;

class LoadPdbTask
extends Task {
    private File pdbFile;
    private DataTypeManagerService service;
    private final Program program;

    LoadPdbTask(Program program, File pdbFile, DataTypeManagerService service) {
        super("Loading PDB...", true, false, false);
        this.program = program;
        this.pdbFile = pdbFile;
        this.service = service;
    }

    public void run(final TaskMonitor monitor) {
        final MessageLog log = new MessageLog();
        AnalysisWorker worker = new AnalysisWorker(){

            public String getWorkerName() {
                return "Load PDB";
            }

            public boolean analysisWorkerCallback(Program currentProgram, Object workerContext, TaskMonitor currentMonitor) throws Exception, CancelledException, PdbException {
                PdbParser parser = new PdbParser(LoadPdbTask.this.pdbFile, LoadPdbTask.this.program, LoadPdbTask.this.service, true, currentMonitor);
                parser.parse();
                parser.openDataTypeArchives();
                parser.applyTo(log);
                LoadPdbTask.this.analyzeSymbols(currentMonitor, log);
                return !monitor.isCancelled();
            }
        };
        boolean analyzed = this.program.getOptions("Program Information").getBoolean("Analyzed", false);
        if (analyzed) {
            Msg.showWarn((Object)((Object)this), null, (String)"PDB Warning", (Object)"Loading PDB after analysis has been performed will produce\npoor results.  PDBs should be loaded prior to analysis or\nautomatically during auto-analysis.");
        }
        try {
            AutoAnalysisManager.getAnalysisManager((Program)this.program).scheduleWorker(worker, null, true, monitor);
        }
        catch (CancelledException | InterruptedException throwable) {
        }
        catch (InvocationTargetException e) {
            String message;
            Throwable t = e.getCause();
            if (t == null) {
                message = "Unknown cause";
            } else {
                message = t.getMessage();
                if (message == null) {
                    message = t.toString();
                }
            }
            Msg.showError(((Object)((Object)this)).getClass(), null, (String)"Load PDB Failed", (Object)message, (Throwable)t);
        }
        if (log.getMsgCount() > 0) {
            MultiLineMessageDialog dialog = new MultiLineMessageDialog("Load PDB File", "There were warnings/errors loading the PDB file.", log.toString(), 2, false);
            DockingWindowManager.showDialog(null, (DialogComponentProvider)dialog);
        }
    }

    private void analyzeSymbols(TaskMonitor monitor, MessageLog log) {
        DemanglerAnalyzer demanglerAnalyzer = new DemanglerAnalyzer();
        String analyzerName = demanglerAnalyzer.getName();
        Options analysisProperties = this.program.getOptions("Analyzers");
        String defaultValueAsString = analysisProperties.getValueAsString(analyzerName);
        boolean doDemangle = true;
        if (defaultValueAsString != null) {
            doDemangle = Boolean.parseBoolean(defaultValueAsString);
        }
        if (doDemangle) {
            Memory addrs = this.program.getMemory();
            monitor.initialize(addrs.getNumAddresses());
            try {
                demanglerAnalyzer.added(this.program, (AddressSetView)addrs, monitor, log);
            }
            catch (CancelledException cancelledException) {
                // empty catch block
            }
        }
    }
}

