/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.repository;

public final class RepositoryPolicy {
    public static final String UPDATE_POLICY_NEVER = "never";
    public static final String UPDATE_POLICY_ALWAYS = "always";
    public static final String UPDATE_POLICY_DAILY = "daily";
    public static final String UPDATE_POLICY_INTERVAL = "interval";
    public static final String CHECKSUM_POLICY_FAIL = "fail";
    public static final String CHECKSUM_POLICY_WARN = "warn";
    public static final String CHECKSUM_POLICY_IGNORE = "ignore";
    private final boolean enabled;
    private final String updatePolicy;
    private final String checksumPolicy;

    public RepositoryPolicy() {
        this(true, UPDATE_POLICY_DAILY, CHECKSUM_POLICY_WARN);
    }

    public RepositoryPolicy(boolean enabled, String updatePolicy, String checksumPolicy) {
        this.enabled = enabled;
        this.updatePolicy = updatePolicy != null ? updatePolicy : "";
        this.checksumPolicy = checksumPolicy != null ? checksumPolicy : "";
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getUpdatePolicy() {
        return this.updatePolicy;
    }

    public String getChecksumPolicy() {
        return this.checksumPolicy;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(256);
        buffer.append("enabled=").append(this.isEnabled());
        buffer.append(", checksums=").append(this.getChecksumPolicy());
        buffer.append(", updates=").append(this.getUpdatePolicy());
        return buffer.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        RepositoryPolicy that = (RepositoryPolicy)obj;
        return this.enabled == that.enabled && this.updatePolicy.equals(that.updatePolicy) && this.checksumPolicy.equals(that.checksumPolicy);
    }

    public int hashCode() {
        int hash2 = 17;
        hash2 = hash2 * 31 + (this.enabled ? 1 : 0);
        hash2 = hash2 * 31 + this.updatePolicy.hashCode();
        hash2 = hash2 * 31 + this.checksumPolicy.hashCode();
        return hash2;
    }
}

