# -*- coding: utf-8 -*-
#---------------------------------------------------------------------------
# Copyright 2021 VMware, Inc.  All rights reserved.

# AUTO GENERATED FILE -- DO NOT MODIFY!
#
# vAPI stub file for package com.vmware.esx.settings.clusters.configuration.
#---------------------------------------------------------------------------

"""
The ``com.vmware.esx.settings.clusters.configuration_client`` module provides
classes to manage the configuration of an ESX cluster. The
``com.vmware.esx.settings.clusters.configuration.reports_client`` module
provides classes for accessing reports regarding the configuration state of the
cluster.

"""

__author__ = 'VMware, Inc.'
__docformat__ = 'restructuredtext en'

import sys

from vmware.vapi.bindings import type
from vmware.vapi.bindings.converter import TypeConverter
from vmware.vapi.bindings.enum import Enum
from vmware.vapi.bindings.error import VapiError
from vmware.vapi.bindings.struct import VapiStruct
from vmware.vapi.bindings.stub import (
    ApiInterfaceStub, StubFactoryBase, VapiInterface)
from vmware.vapi.bindings.common import raise_core_exception
from vmware.vapi.data.validator import (UnionValidator, HasFieldsOfValidator)
from vmware.vapi.exception import CoreException
from vmware.vapi.lib.constants import TaskType
from vmware.vapi.lib.rest import OperationRestMetadata

class ComplianceStatus(Enum):
    """
    This ``ComplianceStatus`` class represents the compliance status of desired
    configuration on the ESXi host.

    .. note::
        This class represents an enumerated type in the interface language
        definition. The class contains class attributes which represent the
        values in the current version of the enumerated type. Newer versions of
        the enumerated type may contain new values. To use new values of the
        enumerated type in communication with a server that supports the newer
        version of the API, you instantiate this class. See :ref:`enumerated
        type description page <enumeration_description>`.
    """
    COMPLIANT = None
    """
    ESXi host is in compliance with Desired configuration.

    """
    NON_COMPLIANT = None
    """
    ESXi host is not in compliance with Desired configuration.

    """
    NOT_COMPUTABLE = None
    """
    Compliance status could not be computed on the ESXi host due to some
    errors.

    """

    def __init__(self, string):
        """
        :type  string: :class:`str`
        :param string: String value for the :class:`ComplianceStatus` instance.
        """
        Enum.__init__(string)

ComplianceStatus._set_values([
    ComplianceStatus('COMPLIANT'),
    ComplianceStatus('NON_COMPLIANT'),
    ComplianceStatus('NOT_COMPUTABLE'),
])
ComplianceStatus._set_binding_type(type.EnumType(
    'com.vmware.esx.settings.clusters.configuration.compliance_status',
    ComplianceStatus))



class ImpactType(Enum):
    """
    The ``ImpactType`` class contains information about the impact of applying
    desired configuration on the ESXi host.

    .. note::
        This class represents an enumerated type in the interface language
        definition. The class contains class attributes which represent the
        values in the current version of the enumerated type. Newer versions of
        the enumerated type may contain new values. To use new values of the
        enumerated type in communication with a server that supports the newer
        version of the API, you instantiate this class. See :ref:`enumerated
        type description page <enumeration_description>`.
    """
    NO_IMPACT = None
    """
    Host has no impact.

    """
    MAINTENANCE_MODE_REQUIRED = None
    """
    Host requires maintenance mode to reach the desired state.

    """
    REBOOT_REQUIRED = None
    """
    Host requires reboot to reach the desired state.

    """

    def __init__(self, string):
        """
        :type  string: :class:`str`
        :param string: String value for the :class:`ImpactType` instance.
        """
        Enum.__init__(string)

ImpactType._set_values([
    ImpactType('NO_IMPACT'),
    ImpactType('MAINTENANCE_MODE_REQUIRED'),
    ImpactType('REBOOT_REQUIRED'),
])
ImpactType._set_binding_type(type.EnumType(
    'com.vmware.esx.settings.clusters.configuration.impact_type',
    ImpactType))




class HostStatus(VapiStruct):
    """
    The ``HostStatus`` class contains attributes that describe the status of an
    method.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """




    def __init__(self,
                 status=None,
                 attempts=None,
                 remaining_retries=None,
                 start_time=None,
                 end_time=None,
                 notifications=None,
                ):
        """
        :type  status: :class:`HostStatus.Status`
        :param status: The status of the method.
        :type  attempts: :class:`long` or ``None``
        :param attempts: Number of the performed attempts of the method.
            This field is None if it is not applicable.
        :type  remaining_retries: :class:`long` or ``None``
        :param remaining_retries: Number of the remaining attempts of the method.
            This field is None if it is not applicable.
        :type  start_time: :class:`datetime.datetime`
        :param start_time: Time when the method started.
        :type  end_time: :class:`datetime.datetime`
        :param end_time: Time when the method completed.
        :type  notifications: :class:`com.vmware.esx.settings_client.Notifications`
        :param notifications: Notifications providing additional information about the status of
            the method.
        """
        self.status = status
        self.attempts = attempts
        self.remaining_retries = remaining_retries
        self.start_time = start_time
        self.end_time = end_time
        self.notifications = notifications
        VapiStruct.__init__(self)


    class Status(Enum):
        """
        The ``HostStatus.Status`` class contains the possible different status
        codes that can be returned while trying to perform an operation on the
        hosts within the cluster.

        .. note::
            This class represents an enumerated type in the interface language
            definition. The class contains class attributes which represent the
            values in the current version of the enumerated type. Newer versions of
            the enumerated type may contain new values. To use new values of the
            enumerated type in communication with a server that supports the newer
            version of the API, you instantiate this class. See :ref:`enumerated
            type description page <enumeration_description>`.
        """
        OK = None
        """
        The method completed successfully.

        """
        PENDING = None
        """
        The method is pending.

        """
        RUNNING = None
        """
        The method is in progress.

        """
        RETRY_PENDING = None
        """
        The method is pending a retry.

        """
        SKIPPED = None
        """
        The method was skipped.

        """
        CANCELED = None
        """
        The method was canceled.

        """
        TIMED_OUT = None
        """
        The method timed out.

        """
        ERROR = None
        """
        The method encountered an unspecified error.

        """

        def __init__(self, string):
            """
            :type  string: :class:`str`
            :param string: String value for the :class:`Status` instance.
            """
            Enum.__init__(string)

    Status._set_values([
        Status('OK'),
        Status('PENDING'),
        Status('RUNNING'),
        Status('RETRY_PENDING'),
        Status('SKIPPED'),
        Status('CANCELED'),
        Status('TIMED_OUT'),
        Status('ERROR'),
    ])
    Status._set_binding_type(type.EnumType(
        'com.vmware.esx.settings.clusters.configuration.host_status.status',
        Status))

HostStatus._set_binding_type(type.StructType(
    'com.vmware.esx.settings.clusters.configuration.host_status', {
        'status': type.ReferenceType(__name__, 'HostStatus.Status'),
        'attempts': type.OptionalType(type.IntegerType()),
        'remaining_retries': type.OptionalType(type.IntegerType()),
        'start_time': type.DateTimeType(),
        'end_time': type.DateTimeType(),
        'notifications': type.ReferenceType('com.vmware.esx.settings_client', 'Notifications'),
    },
    HostStatus,
    False,
    None))



class SettingCompliance(VapiStruct):
    """
    The ``SettingCompliance`` class contains attributes that describe a drift
    in an ESXi host setting. This structure is used to describe either a change
    in configuration value(set) or addition of configuration or deletion of
    configuration. When used to describe addition or deletion of a setting,
    only the path is set. When used to describe a set operation, current and
    target values are set only if drift is in a property that is of primitive
    type.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """




    def __init__(self,
                 path=None,
                 current=None,
                 target=None,
                ):
        """
        :type  path: :class:`str`
        :param path: Full path to the setting within the desired document.
        :type  current: :class:`str` or ``None``
        :param current: Value of setting on the ESXi host.
            This field is None if there is no host value to report or if
            setting is of complex type.
        :type  target: :class:`str` or ``None``
        :param target: Value of setting in the desired document.
            This field is None if there is no value in the desired document to
            report or if setting is of complex type.
        """
        self.path = path
        self.current = current
        self.target = target
        VapiStruct.__init__(self)


SettingCompliance._set_binding_type(type.StructType(
    'com.vmware.esx.settings.clusters.configuration.setting_compliance', {
        'path': type.StringType(),
        'current': type.OptionalType(type.StringType()),
        'target': type.OptionalType(type.StringType()),
    },
    SettingCompliance,
    False,
    None))



class ComplianceInfo(VapiStruct):
    """
    The ``ComplianceInfo`` class contains attributes that describe the
    configuration drift between the desired document and the configurations on
    the ESXi host.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """




    def __init__(self,
                 sets=None,
                 adds=None,
                 deletes=None,
                ):
        """
        :type  sets: :class:`list` of :class:`SettingCompliance` or ``None``
        :param sets: List of configuration drifts represented by
            :class:`SettingCompliance`. Each describing a configuration whose
            value on ESXi host is different to that in the desired document
            This field is None if there are no drifts to report in this
            category.
        :type  adds: :class:`list` of :class:`SettingCompliance` or ``None``
        :param adds: List of configuration drifts represented by
            :class:`SettingCompliance`. Each describing a configuration that is
            present in the desired document but absent on the ESXi host.
            This field is None if there are no drifts to report in this
            category.
        :type  deletes: :class:`list` of :class:`SettingCompliance` or ``None``
        :param deletes: List of configuration drifts represented by
            :class:`SettingCompliance`. Each describing a configuration that is
            present on the ESXi host but absent in the desired document.
            This field is None if there are no drifts to report in this
            category.
        """
        self.sets = sets
        self.adds = adds
        self.deletes = deletes
        VapiStruct.__init__(self)


ComplianceInfo._set_binding_type(type.StructType(
    'com.vmware.esx.settings.clusters.configuration.compliance_info', {
        'sets': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'SettingCompliance'))),
        'adds': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'SettingCompliance'))),
        'deletes': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'SettingCompliance'))),
    },
    ComplianceInfo,
    False,
    None))



class HostCompliance(VapiStruct):
    """
    The ``HostCompliance`` class contains attributes that describe compliance
    information for the ESXi host on which the Check Compliance operation
    completed successfully.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """

    _validator_list = [
        UnionValidator(
            'status',
            {
                'NON_COMPLIANT' : [('compliance_info', True)],
                'NOT_COMPUTABLE' : [('errors', True)],
                'COMPLIANT' : [],
            }
        ),
    ]



    def __init__(self,
                 status=None,
                 compliance_info=None,
                 errors=None,
                ):
        """
        :type  status: :class:`ComplianceStatus`
        :param status: This field indicates whether the ESXi host is compliant with the
            desired configuration specified in
            com.vmware.esx.settings_daemon.Configuration#CheckComplianceSpec.
            If COMPLIANT, no other information is available. If NON_COMPLAINT,
            drift information can be fetched from {#ComplianceInfo} If
            NOT_COMPUTABLE, error information can be fetched from
            {#ValidationError}
        :type  compliance_info: :class:`ComplianceInfo`
        :param compliance_info: Settings compliance information generated by the CheckCompliance
            operation.
            This attribute is optional and it is only relevant when the value
            of ``status`` is :attr:`ComplianceStatus.NON_COMPLIANT`.
        :type  errors: :class:`list` of :class:`ValidationError`
        :param errors: List of validation errors if the desired document
            com.vmware.esx.settings_daemon.Configuration#CheckComplianceSpec is
            invalid. No compliance checks are performed on the invalid
            document.
            This attribute is optional and it is only relevant when the value
            of ``status`` is :attr:`ComplianceStatus.NOT_COMPUTABLE`.
        """
        self.status = status
        self.compliance_info = compliance_info
        self.errors = errors
        VapiStruct.__init__(self)


HostCompliance._set_binding_type(type.StructType(
    'com.vmware.esx.settings.clusters.configuration.host_compliance', {
        'status': type.ReferenceType(__name__, 'ComplianceStatus'),
        'compliance_info': type.OptionalType(type.ReferenceType(__name__, 'ComplianceInfo')),
        'errors': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ValidationError'))),
    },
    HostCompliance,
    False,
    None))



class HostResult(VapiStruct):
    """
    This ``HostResult`` class contains attributes that describe the result of
    the check compliance operation on an ESXi host.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """




    def __init__(self,
                 host_status=None,
                 host_info=None,
                 host_compliance=None,
                ):
        """
        :type  host_status: :class:`HostStatus`
        :param host_status: This field represents the status of the check compliance operation.
            If status is OK, the result of operation can be retrived from
            {#HostCompliance}
        :type  host_info: :class:`com.vmware.esx.settings_client.HostInfo`
        :param host_info: Additional information about hosts.
        :type  host_compliance: :class:`HostCompliance` or ``None``
        :param host_compliance: This field provides compliance results for the host, if the
            operation completed on the host. That is, this field is populated
            only if HostStatus is OK.
            This field is None if check compliance found the host compliant or
            if check compliance could not be completed on the host.
        """
        self.host_status = host_status
        self.host_info = host_info
        self.host_compliance = host_compliance
        VapiStruct.__init__(self)


HostResult._set_binding_type(type.StructType(
    'com.vmware.esx.settings.clusters.configuration.host_result', {
        'host_status': type.ReferenceType(__name__, 'HostStatus'),
        'host_info': type.ReferenceType('com.vmware.esx.settings_client', 'HostInfo'),
        'host_compliance': type.OptionalType(type.ReferenceType(__name__, 'HostCompliance')),
    },
    HostResult,
    False,
    None))



class ClusterCompliance(VapiStruct):
    """
    This ``ClusterCompliance`` class contains attributes that describe the
    compliance result for each host in the cluster as well as overall cluster
    compliance status.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """




    def __init__(self,
                 cluster_status=None,
                 commit=None,
                 software_commit=None,
                 hosts=None,
                 compliant_hosts=None,
                 non_compliant_hosts=None,
                 not_computable_hosts=None,
                 unavailable_hosts=None,
                 last_check_time=None,
                ):
        """
        :type  cluster_status: :class:`ClusterCompliance.Status`
        :param cluster_status: Consolidated status of all host compliance checks.
        :type  commit: :class:`str` or ``None``
        :param commit: This identifier refers to the commit action of importing the
            desired configuration document. It will not be set for a draft
            execution of check compliance.
            When clients pass a value of this class as a parameter, the
            attribute must be an identifier for the resource type:
            ``com.vmware.esx.settings.commit``. When methods return a value of
            this class as a return value, the attribute will be an identifier
            for the resource type: ``com.vmware.esx.settings.commit``.
        :type  software_commit: :class:`str`
        :param software_commit: The current commit ID for the software associated with the cluster.
            When clients pass a value of this class as a parameter, the
            attribute must be an identifier for the resource type:
            ``com.vmware.esx.settings.commit``. When methods return a value of
            this class as a return value, the attribute will be an identifier
            for the resource type: ``com.vmware.esx.settings.commit``.
        :type  hosts: :class:`dict` of :class:`str` and :class:`HostResult`
        :param hosts: Map of host IDs to their compliance results.
            When clients pass a value of this class as a parameter, the key in
            the attribute :class:`dict` must be an identifier for the resource
            type: ``HostSystem``. When methods return a value of this class as
            a return value, the key in the attribute :class:`dict` will be an
            identifier for the resource type: ``HostSystem``.
        :type  compliant_hosts: :class:`set` of :class:`str`
        :param compliant_hosts: Identifiers of compliant hosts
            When clients pass a value of this class as a parameter, the
            attribute must contain identifiers for the resource type:
            ``HostSystem``. When methods return a value of this class as a
            return value, the attribute will contain identifiers for the
            resource type: ``HostSystem``.
        :type  non_compliant_hosts: :class:`set` of :class:`str`
        :param non_compliant_hosts: Identifiers of non-compliant hosts
            When clients pass a value of this class as a parameter, the
            attribute must contain identifiers for the resource type:
            ``HostSystem``. When methods return a value of this class as a
            return value, the attribute will contain identifiers for the
            resource type: ``HostSystem``.
        :type  not_computable_hosts: :class:`set` of :class:`str`
        :param not_computable_hosts: Identifiers of not computable hosts
            When clients pass a value of this class as a parameter, the
            attribute must contain identifiers for the resource type:
            ``HostSystem``. When methods return a value of this class as a
            return value, the attribute will contain identifiers for the
            resource type: ``HostSystem``.
        :type  unavailable_hosts: :class:`set` of :class:`str`
        :param unavailable_hosts: Identifiers of failed or unavailable hosts. There won't be any
            compliance details for these hosts in hosts
            When clients pass a value of this class as a parameter, the
            attribute must contain identifiers for the resource type:
            ``HostSystem``. When methods return a value of this class as a
            return value, the attribute will contain identifiers for the
            resource type: ``HostSystem``.
        :type  last_check_time: :class:`datetime.datetime`
        :param last_check_time: CheckCompliance completion time.
        """
        self.cluster_status = cluster_status
        self.commit = commit
        self.software_commit = software_commit
        self.hosts = hosts
        self.compliant_hosts = compliant_hosts
        self.non_compliant_hosts = non_compliant_hosts
        self.not_computable_hosts = not_computable_hosts
        self.unavailable_hosts = unavailable_hosts
        self.last_check_time = last_check_time
        VapiStruct.__init__(self)


    class Status(Enum):
        """
        Consolidated compliance status of the cluster

        .. note::
            This class represents an enumerated type in the interface language
            definition. The class contains class attributes which represent the
            values in the current version of the enumerated type. Newer versions of
            the enumerated type may contain new values. To use new values of the
            enumerated type in communication with a server that supports the newer
            version of the API, you instantiate this class. See :ref:`enumerated
            type description page <enumeration_description>`.
        """
        OK = None
        """
        All hosts in the cluster are compliant.

        """
        ERROR = None
        """


        """

        def __init__(self, string):
            """
            :type  string: :class:`str`
            :param string: String value for the :class:`Status` instance.
            """
            Enum.__init__(string)

    Status._set_values([
        Status('OK'),
        Status('ERROR'),
    ])
    Status._set_binding_type(type.EnumType(
        'com.vmware.esx.settings.clusters.configuration.cluster_compliance.status',
        Status))

ClusterCompliance._set_binding_type(type.StructType(
    'com.vmware.esx.settings.clusters.configuration.cluster_compliance', {
        'cluster_status': type.ReferenceType(__name__, 'ClusterCompliance.Status'),
        'commit': type.OptionalType(type.IdType()),
        'software_commit': type.IdType(resource_types='com.vmware.esx.settings.commit'),
        'hosts': type.MapType(type.IdType(), type.ReferenceType(__name__, 'HostResult')),
        'compliant_hosts': type.SetType(type.IdType()),
        'non_compliant_hosts': type.SetType(type.IdType()),
        'not_computable_hosts': type.SetType(type.IdType()),
        'unavailable_hosts': type.SetType(type.IdType()),
        'last_check_time': type.DateTimeType(),
    },
    ClusterCompliance,
    False,
    None))



class ValidationError(VapiStruct):
    """
    The ``ValidationError`` class contains attributes that describes a
    validation error in the configuration.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """




    def __init__(self,
                 path=None,
                 messages=None,
                ):
        """
        :type  path: :class:`str`
        :param path: Full path to the configuration or the property within the
            configuration which was found to be invalid.
        :type  messages: :class:`list` of :class:`com.vmware.vapi.std_client.LocalizableMessage`
        :param messages: Localized error message describing the validation error.
        """
        self.path = path
        self.messages = messages
        VapiStruct.__init__(self)


ValidationError._set_binding_type(type.StructType(
    'com.vmware.esx.settings.clusters.configuration.validation_error', {
        'path': type.StringType(),
        'messages': type.ListType(type.ReferenceType('com.vmware.vapi.std_client', 'LocalizableMessage')),
    },
    ValidationError,
    False,
    None))



class ValidationResult(VapiStruct):
    """
    This ``ValidationResult`` class contains attributes that describe the
    result of validating a configuration document.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """




    def __init__(self,
                 valid=None,
                 errors=None,
                ):
        """
        :type  valid: :class:`bool`
        :param valid: This boolean flag indicates whether the configuration document
            validated successfully with no validation errors.
        :type  errors: :class:`list` of :class:`ValidationError` or ``None``
        :param errors: Lists all validation errors identified in the configuration
            document.
            This is set when :attr:`ValidationResult.valid` is false.
        """
        self.valid = valid
        self.errors = errors
        VapiStruct.__init__(self)


ValidationResult._set_binding_type(type.StructType(
    'com.vmware.esx.settings.clusters.configuration.validation_result', {
        'valid': type.BooleanType(),
        'errors': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ValidationError'))),
    },
    ValidationResult,
    False,
    None))



class ImpactInfo(VapiStruct):
    """
    This ``ImpactInfo`` class contains attributes that describes the Impact if
    the host is not compliant against the desired configuration.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """




    def __init__(self,
                 impact=None,
                 info=None,
                ):
        """
        :type  impact: :class:`ImpactType`
        :param impact: This field indicates the ESXi host impact on applying the desired
            configuration.
        :type  info: :class:`list` of :class:`com.vmware.vapi.std_client.LocalizableMessage`
        :param info: This field represents the list of impact information describing the
            configuration changes needed on the host to reach the desired
            state.
        """
        self.impact = impact
        self.info = info
        VapiStruct.__init__(self)


ImpactInfo._set_binding_type(type.StructType(
    'com.vmware.esx.settings.clusters.configuration.impact_info', {
        'impact': type.ReferenceType(__name__, 'ImpactType'),
        'info': type.ListType(type.ReferenceType('com.vmware.vapi.std_client', 'LocalizableMessage')),
    },
    ImpactInfo,
    False,
    None))



class HostImpact(VapiStruct):
    """
    This ``HostImpact`` class contains attributes that describe the result of
    the Impact API on the host.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """

    _validator_list = [
        UnionValidator(
            'compliance',
            {
                'NON_COMPLIANT' : [('impact_info', True)],
                'NOT_COMPUTABLE' : [('errors', True)],
                'COMPLIANT' : [],
            }
        ),
    ]



    def __init__(self,
                 compliance=None,
                 impact_info=None,
                 errors=None,
                ):
        """
        :type  compliance: :class:`ComplianceStatus`
        :param compliance: This field indicates the ESXi host impact on applying the desired
            configuration.
        :type  impact_info: :class:`ImpactInfo`
        :param impact_info: This field represents the list of impact information describing the
            configuration changes needed on the host to reach the desired
            state.
            This attribute is optional and it is only relevant when the value
            of ``compliance`` is :attr:`ComplianceStatus.NON_COMPLIANT`.
        :type  errors: :class:`list` of :class:`ValidationError`
        :param errors: This field represents the validation errors if the desired
            configuration specified is not valid.
            This attribute is optional and it is only relevant when the value
            of ``compliance`` is :attr:`ComplianceStatus.NOT_COMPUTABLE`.
        """
        self.compliance = compliance
        self.impact_info = impact_info
        self.errors = errors
        VapiStruct.__init__(self)


HostImpact._set_binding_type(type.StructType(
    'com.vmware.esx.settings.clusters.configuration.host_impact', {
        'compliance': type.ReferenceType(__name__, 'ComplianceStatus'),
        'impact_info': type.OptionalType(type.ReferenceType(__name__, 'ImpactInfo')),
        'errors': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ValidationError'))),
    },
    HostImpact,
    False,
    None))



class HostPrecheckResult(VapiStruct):
    """
    This ``HostPrecheckResult`` class contains attributes that describes the
    Precheck API result on a host.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """




    def __init__(self,
                 status=None,
                 impact=None,
                 precheck_result=None,
                ):
        """
        :type  status: :class:`HostStatus`
        :param status: This field represents the status of the precheck request for this
            host.
        :type  impact: :class:`HostImpact` or ``None``
        :param impact: This field represents the impact on the host, if the operation was
            successfully executed on the host.
            This field is None if :attr:`HostPrecheckResult.status` is SKIPPED,
            TIMED_OUT or ERROR.
        :type  precheck_result: :class:`com.vmware.esx.settings_client.StatusInfo` or ``None``
        :param precheck_result: This field represents the health check results from the host, if
            the host needs to be put in maintenance mode or to be rebooted.
            This field is None if :attr:`HostPrecheckResult.status` is SKIPPED,
            TIMED_OUT or ERROR. The field is set if host health checks are
            invoked.
        """
        self.status = status
        self.impact = impact
        self.precheck_result = precheck_result
        VapiStruct.__init__(self)


HostPrecheckResult._set_binding_type(type.StructType(
    'com.vmware.esx.settings.clusters.configuration.host_precheck_result', {
        'status': type.ReferenceType(__name__, 'HostStatus'),
        'impact': type.OptionalType(type.ReferenceType(__name__, 'HostImpact')),
        'precheck_result': type.OptionalType(type.ReferenceType('com.vmware.esx.settings_client', 'StatusInfo')),
    },
    HostPrecheckResult,
    False,
    None))



class ClusterPrecheckResult(VapiStruct):
    """
    The ``PrecheckResult`` class contains attributes that describe precheck
    status of applying the desired document to a group of hosts.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """




    def __init__(self,
                 status=None,
                 commit=None,
                 software_commit=None,
                 end_time=None,
                 precheck_summary=None,
                 remediation_summary=None,
                 remediation_notes=None,
                 host_info=None,
                 host_precheck=None,
                 precheck_result=None,
                ):
        """
        :type  status: :class:`ClusterPrecheckResult.Status`
        :param status: Overall status of precheck on the cluster. Operation is sucessfull
            when precheck is run on all hosts successfully and no validation or
            precheck errors are detected.
        :type  commit: :class:`str` or ``None``
        :param commit: This identifier refers to the commit action of importing the
            desired configuration document. It will not be set for a precheck
            of a draft configuration.
            When clients pass a value of this class as a parameter, the
            attribute must be an identifier for the resource type:
            ``com.vmware.esx.settings.commit``. When methods return a value of
            this class as a return value, the attribute will be an identifier
            for the resource type: ``com.vmware.esx.settings.commit``.
        :type  software_commit: :class:`str`
        :param software_commit: The current commit ID for the software associated with the cluster.
            When clients pass a value of this class as a parameter, the
            attribute must be an identifier for the resource type:
            ``com.vmware.esx.settings.commit``. When methods return a value of
            this class as a return value, the attribute will be an identifier
            for the resource type: ``com.vmware.esx.settings.commit``.
        :type  end_time: :class:`datetime.datetime`
        :param end_time: Precheck completion time.
        :type  precheck_summary: :class:`com.vmware.vapi.std_client.LocalizableMessage` or ``None``
        :param precheck_summary: Summarizing precheck stating number of precheck errors on host and
            cluster.
        :type  remediation_summary: :class:`list` of :class:`com.vmware.vapi.std_client.LocalizableMessage`
        :param remediation_summary: Summarizing remediation stating number of hosts needing reboot and
            maintenance mode during remediation and number of precheck errors
            on host and cluster.
        :type  remediation_notes: :class:`list` of :class:`com.vmware.vapi.std_client.LocalizableMessage`
        :param remediation_notes: Static notes to the user describing steps that will be taken during
            remediation.
        :type  host_info: :class:`dict` of :class:`str` and :class:`com.vmware.esx.settings_client.HostInfo`
        :param host_info: Map of host IDs to hostname
            When clients pass a value of this class as a parameter, the key in
            the attribute :class:`dict` must be an identifier for the resource
            type: ``HostSystem``. When methods return a value of this class as
            a return value, the key in the attribute :class:`dict` will be an
            identifier for the resource type: ``HostSystem``.
        :type  host_precheck: :class:`dict` of :class:`str` and :class:`HostPrecheckResult`
        :param host_precheck: Map of host IDs to their precheck results. If
            :attr:`ClusterPrecheckResult.status` is ERROR, This field will
            contain Validation errors or Host Impact and Health Check errors.
            If :attr:`ClusterPrecheckResult.status` is OK, This field will
            contain Impact and Health Check information.
            When clients pass a value of this class as a parameter, the key in
            the attribute :class:`dict` must be an identifier for the resource
            type: ``HostSystem``. When methods return a value of this class as
            a return value, the key in the attribute :class:`dict` will be an
            identifier for the resource type: ``HostSystem``.
        :type  precheck_result: :class:`com.vmware.esx.settings_client.StatusInfo` or ``None``
        :param precheck_result: This field represents the precheck results on the cluster, if any
            one host in the cluster needs to be put in maintenance mode or to
            be rebooted.
            This field is set if cluster prechecks are invoked.
        """
        self.status = status
        self.commit = commit
        self.software_commit = software_commit
        self.end_time = end_time
        self.precheck_summary = precheck_summary
        self.remediation_summary = remediation_summary
        self.remediation_notes = remediation_notes
        self.host_info = host_info
        self.host_precheck = host_precheck
        self.precheck_result = precheck_result
        VapiStruct.__init__(self)


    class Status(Enum):
        """
        The ``ClusterPrecheckResult.Status`` class contains the possible statuses
        of the Precheck API on the cluster.

        .. note::
            This class represents an enumerated type in the interface language
            definition. The class contains class attributes which represent the
            values in the current version of the enumerated type. Newer versions of
            the enumerated type may contain new values. To use new values of the
            enumerated type in communication with a server that supports the newer
            version of the API, you instantiate this class. See :ref:`enumerated
            type description page <enumeration_description>`.
        """
        OK = None
        """
        The operation completed successfully.

        """
        ERROR = None
        """
        The operation failed with errors.

        """

        def __init__(self, string):
            """
            :type  string: :class:`str`
            :param string: String value for the :class:`Status` instance.
            """
            Enum.__init__(string)

    Status._set_values([
        Status('OK'),
        Status('ERROR'),
    ])
    Status._set_binding_type(type.EnumType(
        'com.vmware.esx.settings.clusters.configuration.cluster_precheck_result.status',
        Status))

ClusterPrecheckResult._set_binding_type(type.StructType(
    'com.vmware.esx.settings.clusters.configuration.cluster_precheck_result', {
        'status': type.ReferenceType(__name__, 'ClusterPrecheckResult.Status'),
        'commit': type.OptionalType(type.IdType()),
        'software_commit': type.IdType(resource_types='com.vmware.esx.settings.commit'),
        'end_time': type.DateTimeType(),
        'precheck_summary': type.OptionalType(type.ReferenceType('com.vmware.vapi.std_client', 'LocalizableMessage')),
        'remediation_summary': type.ListType(type.ReferenceType('com.vmware.vapi.std_client', 'LocalizableMessage')),
        'remediation_notes': type.ListType(type.ReferenceType('com.vmware.vapi.std_client', 'LocalizableMessage')),
        'host_info': type.MapType(type.IdType(), type.ReferenceType('com.vmware.esx.settings_client', 'HostInfo')),
        'host_precheck': type.MapType(type.IdType(), type.ReferenceType(__name__, 'HostPrecheckResult')),
        'precheck_result': type.OptionalType(type.ReferenceType('com.vmware.esx.settings_client', 'StatusInfo')),
    },
    ClusterPrecheckResult,
    False,
    None))



class ImportResult(VapiStruct):
    """
    This ``ImportResult`` class contains attributes that describe the result of
    importing a configuration document in the cluster.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """

    _validator_list = [
        UnionValidator(
            'status',
            {
                'OK' : [('commit', True)],
                'ERROR' : [('errors', True)],
            }
        ),
    ]



    def __init__(self,
                 status=None,
                 commit=None,
                 errors=None,
                ):
        """
        :type  status: :class:`ImportResult.Status`
        :param status: 
        :type  commit: :class:`str`
        :param commit: This identifier refers to the commit action of importing the
            desired configuration document. This identifier can be used in the
            apply API.
            When clients pass a value of this class as a parameter, the
            attribute must be an identifier for the resource type:
            ``com.vmware.esx.settings.commit``. When methods return a value of
            this class as a return value, the attribute will be an identifier
            for the resource type: ``com.vmware.esx.settings.commit``.
            This attribute is optional and it is only relevant when the value
            of ``status`` is :attr:`ImportResult.Status.OK`.
        :type  errors: :class:`list` of :class:`ValidationError`
        :param errors: Lists all validation errors identified in the configuration
            document.
            This is set when #success is false.
        """
        self.status = status
        self.commit = commit
        self.errors = errors
        VapiStruct.__init__(self)


    class Status(Enum):
        """
        This enum indicates whether the configuration document was imported
        successfully in the cluster.

        .. note::
            This class represents an enumerated type in the interface language
            definition. The class contains class attributes which represent the
            values in the current version of the enumerated type. Newer versions of
            the enumerated type may contain new values. To use new values of the
            enumerated type in communication with a server that supports the newer
            version of the API, you instantiate this class. See :ref:`enumerated
            type description page <enumeration_description>`.
        """
        OK = None
        """


        """
        ERROR = None
        """


        """

        def __init__(self, string):
            """
            :type  string: :class:`str`
            :param string: String value for the :class:`Status` instance.
            """
            Enum.__init__(string)

    Status._set_values([
        Status('OK'),
        Status('ERROR'),
    ])
    Status._set_binding_type(type.EnumType(
        'com.vmware.esx.settings.clusters.configuration.import_result.status',
        Status))

ImportResult._set_binding_type(type.StructType(
    'com.vmware.esx.settings.clusters.configuration.import_result', {
        'status': type.ReferenceType(__name__, 'ImportResult.Status'),
        'commit': type.OptionalType(type.IdType()),
        'errors': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ValidationError'))),
    },
    ImportResult,
    False,
    None))



class ExportResult(VapiStruct):
    """
    This ``ExportResult`` class contains attributes that describe the result of
    exporting configuration from the cluster.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """




    def __init__(self,
                 config=None,
                ):
        """
        :type  config: :class:`str`
        :param config: Configuration of the cluster encoded as JSON.
        """
        self.config = config
        VapiStruct.__init__(self)


ExportResult._set_binding_type(type.StructType(
    'com.vmware.esx.settings.clusters.configuration.export_result', {
        'config': type.StringType(),
    },
    ExportResult,
    False,
    None))




class StubFactory(StubFactoryBase):
    _attrs = {
    }

