// Generated by gmmproc 2.68.1 -- DO NOT MODIFY!
#ifndef _GTKMM_LISTITEM_H
#define _GTKMM_LISTITEM_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* Copyright (C) 2020 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

#include <gtkmm/widget.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
using GtkListItem = struct _GtkListItem;
using GtkListItemClass = struct _GtkListItemClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Gtk
{ class GTKMM_API ListItem_Class; } // namespace Gtk
#endif //DOXYGEN_SHOULD_SKIP_THIS

namespace Gtk
{

/** %Object used to represent items of a list model.
 *
 * %Gtk::ListItem is the object that list-handling containers such
 * as Gtk::ListView use to represent items in a Gio::ListModel. They are
 * managed by the container and cannot be created by application code.
 *
 * %Gtk::ListItems need to be populated by application code. This is done by
 * calling set_child().
 *
 * %Gtk::ListItems exist in 2 stages:
 *
 * 1. The unbound stage where the listitem is not currently connected to
 *    an item in the list. In that case, the property_item() property is
 *    not set.
 *
 * 2. The bound stage where the listitem references an item from the list.
 *    The property_item() property is set.
 *
 * @see Gtk::ListView, Gio::ListModel
 * @newin{3,98}
 */

class GTKMM_API ListItem : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  using CppObjectType = ListItem;
  using CppClassType = ListItem_Class;
  using BaseObjectType = GtkListItem;
  using BaseClassType = GtkListItemClass;

  // noncopyable
  ListItem(const ListItem&) = delete;
  ListItem& operator=(const ListItem&) = delete;

private:  friend class ListItem_Class;
  static CppClassType listitem_class_;

protected:
  explicit ListItem(const Glib::ConstructParams& construct_params);
  explicit ListItem(GtkListItem* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:

  ListItem(ListItem&& src) noexcept;
  ListItem& operator=(ListItem&& src) noexcept;

  ~ListItem() noexcept override;

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GtkListItem*       gobj()       { return reinterpret_cast<GtkListItem*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GtkListItem* gobj() const { return reinterpret_cast<GtkListItem*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GtkListItem* gobj_copy();

private:


public:
  // Don't use Glib::RefPtr<Glib::Object> Glib::wrap(GObject* object, bool take_copy).
  // The object may be an interface object, e.g. Gio::AppInfo. Such an object can't be
  // cast to Glib::Object. https://gitlab.gnome.org/GNOME/glibmm/-/issues/93
 

  /** Gets the model item that associated with @a self.
   * 
   * If @a self is unbound, this function returns <tt>nullptr</tt>.
   * 
   * @return The item displayed.
   */
  Glib::RefPtr<Glib::ObjectBase> get_item();
  
  /** Gets the model item that associated with @a self.
   * 
   * If @a self is unbound, this function returns <tt>nullptr</tt>.
   * 
   * @return The item displayed.
   */
  Glib::RefPtr<const Glib::ObjectBase> get_item() const;
  
  /** Gets the position in the model that @a self currently displays.
   * 
   * If @a self is unbound, GTK_INVALID_LIST_POSITION is returned.
   * 
   * @return The position of this item.
   */
  guint get_position() const;
  
  /** Checks if the item is displayed as selected.
   * 
   * The selected state is maintained by the liste widget and its model
   * and cannot be set otherwise.
   * 
   * @return <tt>true</tt> if the item is selected.
   */
  bool get_selected() const;
  
  /** Checks if a list item has been set to be selectable via
   * set_selectable().
   * 
   * Do not confuse this function with get_selected().
   * 
   * @return <tt>true</tt> if the item is selectable.
   */
  bool get_selectable() const;
  
  /** Sets @a self to be selectable.
   * 
   * If an item is selectable, clicking on the item or using the keyboard
   * will try to select or unselect the item. If this succeeds is up to
   * the model to determine, as it is managing the selected state.
   * 
   * Note that this means that making an item non-selectable has no
   * influence on the selected state at all. A non-selectable item
   * may still be selected.
   * 
   * By default, list items are selectable. When rebinding them to
   * a new item, they will also be reset to be selectable by GTK.
   * 
   * @param selectable If the item should be selectable.
   */
  void set_selectable(bool selectable =  true);
  
  /** Checks if a list item has been set to be activatable via
   * set_activatable().
   * 
   * @return <tt>true</tt> if the item is activatable.
   */
  bool get_activatable() const;
  
  /** Sets @a self to be activatable.
   * 
   * If an item is activatable, double-clicking on the item, using
   * the Return key or calling Gtk::Widget::activate() will activate
   * the item. Activating instructs the containing view to handle
   * activation. `Gtk::ListView` for example will be emitting the
   * Gtk::ListView::signal_activate() signal.
   * 
   * By default, list items are activatable.
   * 
   * @param activatable If the item should be activatable.
   */
  void set_activatable(bool activatable =  true);
  
  /** Sets the child to be used for this listitem.
   * 
   * This function is typically called by applications when
   * setting up a listitem so that the widget can be reused when
   * binding it multiple times.
   * 
   * @param child The list item's child or <tt>nullptr</tt> to unset.
   */
  void set_child(Widget& child);
  void unset_child();
  
  /** Gets the child previously set via set_child() or
   * <tt>nullptr</tt> if none was set.
   * 
   * @return The child.
   */
  Widget* get_child();
  
  /** Gets the child previously set via set_child() or
   * <tt>nullptr</tt> if none was set.
   * 
   * @return The child.
   */
  const Widget* get_child() const;

  /** If the item can be activated by the user.
   *
   * Default value: <tt>true</tt>
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_activatable() ;

/** If the item can be activated by the user.
   *
   * Default value: <tt>true</tt>
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_activatable() const;

  /** Widget used for display.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Widget* > property_child() ;

/** Widget used for display.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Widget* > property_child() const;

  /** Displayed item.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Glib::ObjectBase> > property_item() const;


  /** Position of the item.
   *
   * Default value: 4294967295
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< guint > property_position() const;


  /** If the item can be selected by the user.
   *
   * Default value: <tt>true</tt>
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_selectable() ;

/** If the item can be selected by the user.
   *
   * Default value: <tt>true</tt>
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_selectable() const;

  /** If the item is currently selected.
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_selected() const;


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} // namespace Gtk


namespace Glib
{
  /** A Glib::wrap() method for this object.
   *
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gtk::ListItem
   */
  GTKMM_API
  Glib::RefPtr<Gtk::ListItem> wrap(GtkListItem* object, bool take_copy = false);
}


#endif /* _GTKMM_LISTITEM_H */

