/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io.fastCgi;

import com.intellij.openapi.diagnostic.Logger;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.io.MessageDecoder;
import org.jetbrains.io.NettyUtil;
import org.jetbrains.io.Responses;
import org.jetbrains.io.fastCgi.FastCgiService;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u0018\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\"\u0019\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0010"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "parseHeaders", "", "response", "Lio/netty/handler/codec/http/HttpResponse;", "buffer", "Lio/netty/buffer/ByteBuf;", "sendBadGateway", "channel", "Lio/netty/channel/Channel;", "extraHeaders", "Lio/netty/handler/codec/http/HttpHeaders;", "intellij.platform.builtInServer.impl"})
public final class FastCgiServiceKt {
    @NotNull
    private static final Logger LOG;

    @NotNull
    public static final Logger getLOG() {
        return LOG;
    }

    private static final void sendBadGateway(Channel channel, HttpHeaders extraHeaders) {
        try {
            if (channel.isActive()) {
                HttpResponseStatus httpResponseStatus = HttpResponseStatus.BAD_GATEWAY;
                Intrinsics.checkNotNullExpressionValue((Object)httpResponseStatus, (String)"HttpResponseStatus.BAD_GATEWAY");
                Responses.send$default((HttpResponseStatus)httpResponseStatus, (Channel)channel, null, null, (HttpHeaders)extraHeaders, (int)6, null);
            }
        }
        catch (Throwable e) {
            NettyUtil.log((Throwable)e, (Logger)LOG);
        }
    }

    private static final void parseHeaders(HttpResponse response, ByteBuf buffer) {
        StringBuilder builder = new StringBuilder();
        while (buffer.isReadable()) {
            String value;
            byte b22;
            builder.setLength(0);
            String key = null;
            boolean valueExpected = true;
            while ((b22 = buffer.readByte()) >= 0 && (char)b22 != '\n') {
                if ((char)b22 == '\r') continue;
                if (valueExpected && (char)b22 == ':') {
                    valueExpected = false;
                    key = builder.toString();
                    builder.setLength(0);
                    MessageDecoder.skipWhitespace((ByteBuf)buffer);
                    continue;
                }
                builder.append((char)b22);
            }
            CharSequence b22 = builder;
            boolean bl = false;
            if (b22.length() == 0) {
                return;
            }
            b22 = key;
            bl = false;
            boolean bl2 = false;
            if (b22 == null || b22.length() == 0 || StringsKt.startsWith((String)key, (String)"http", (boolean)true) || StringsKt.startsWith((String)key, (String)"X-Accel-", (boolean)true)) continue;
            Intrinsics.checkNotNullExpressionValue((Object)builder.toString(), (String)"builder.toString()");
            if (StringsKt.equals((String)key, (String)"status", (boolean)true)) {
                int index = StringsKt.indexOf$default((CharSequence)value, (char)' ', (int)0, (boolean)false, (int)6, null);
                if (index == -1) {
                    LOG.warn("Cannot parse status: " + value);
                    response.setStatus(HttpResponseStatus.OK);
                    continue;
                }
                String string = value;
                int n = 0;
                boolean bl3 = false;
                String string2 = string;
                if (string2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = string2.substring(n, index);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                response.setStatus(HttpResponseStatus.valueOf((int)Integer.parseInt(string3)));
                continue;
            }
            if (StringsKt.startsWith$default((String)key, (String)"http", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)key, (String)"HTTP", (boolean)false, (int)2, null)) continue;
            response.headers().add(key, (Object)value);
        }
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(FastCgiService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ void access$sendBadGateway(Channel channel, HttpHeaders extraHeaders) {
        FastCgiServiceKt.sendBadGateway(channel, extraHeaders);
    }

    public static final /* synthetic */ void access$parseHeaders(HttpResponse response, ByteBuf buffer) {
        FastCgiServiceKt.parseHeaders(response, buffer);
    }
}

